/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Plugin;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import tvbrowser.core.Settings;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemList;

public class PluginChooserDlg
extends JDialog
implements WindowClosingIf {
    public static final int TYPE_RECEIVE_DEFAULT = 0;
    public static final int TYPE_RECEIVE_ADD_REMOVE = 1;
    public static final int TYPE_RECEIVE_ADD_BOTH = 2;
    public static final int TYPE_RECEIVE_ALL = 3;
    private ProgramReceiveIf[] mResultPluginArr;
    private Hashtable<ProgramReceiveIf, ArrayList<ProgramReceiveTarget>> mReceiveTargetTable;
    private SelectableItemList<ProgramReceiveIf> mPluginItemList;
    private ProgramReceiveTarget[] mCurrentTargets;
    private boolean mOkWasPressed;
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(PluginChooserDlg.class);

    public PluginChooserDlg(Window parent, ProgramReceiveIf[] pluginArr, String description, ProgramReceiveIf caller) {
        this(0, parent, pluginArr, description, caller);
    }

    public PluginChooserDlg(int type, Window parent, ProgramReceiveIf[] pluginArr, String description, ProgramReceiveIf caller) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.init(type, pluginArr, description, caller, null, null, parent);
    }

    public PluginChooserDlg(Window parent, ProgramReceiveTarget[] pluginArr, String description, ProgramReceiveIf caller) {
        this(parent, pluginArr, description, caller, null);
    }

    public PluginChooserDlg(Window parent, ProgramReceiveTarget[] pluginArr, String description, ProgramReceiveIf caller, ProgramReceiveTarget[] disabledTargets) {
        this(0, parent, pluginArr, description, caller, disabledTargets);
    }

    public PluginChooserDlg(int type, Window parent, ProgramReceiveTarget[] pluginArr, String description, ProgramReceiveIf caller, ProgramReceiveTarget[] disabledTargets) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        Hashtable<ProgramReceiveIf, ArrayList<ProgramReceiveTarget>> table = this.createReceiveTable(pluginArr);
        this.init(type, table.keySet().toArray(new ProgramReceiveIf[table.keySet().size()]), description, caller, table, disabledTargets, parent);
    }

    private Hashtable<ProgramReceiveIf, ArrayList<ProgramReceiveTarget>> createReceiveTable(ProgramReceiveTarget[] targets) {
        Hashtable<ProgramReceiveIf, ArrayList<ProgramReceiveTarget>> table = new Hashtable<ProgramReceiveIf, ArrayList<ProgramReceiveTarget>>();
        if (targets != null) {
            for (ProgramReceiveTarget target : targets) {
                if (target == null || target.getReceifeIfForIdOfTarget() == null) continue;
                ArrayList<ProgramReceiveTarget> receiveTargetList = table.get(target.getReceifeIfForIdOfTarget());
                if (receiveTargetList != null) {
                    receiveTargetList.add(target);
                    continue;
                }
                receiveTargetList = new ArrayList();
                receiveTargetList.add(target);
                table.put(target.getReceifeIfForIdOfTarget(), receiveTargetList);
            }
        }
        return table;
    }

    private void init(int type, ProgramReceiveIf[] pluginArr, String description, ProgramReceiveIf caller, Hashtable<ProgramReceiveIf, ArrayList<ProgramReceiveTarget>> targetTable, ProgramReceiveTarget[] disabledReceiveTargets, Window parent) {
        this.mOkWasPressed = false;
        this.setTitle(LOCALIZER.msg("title", "Choose Plugins"));
        UiUtilities.registerForClosing(this);
        if (pluginArr == null) {
            this.mResultPluginArr = new ProgramReceiveIf[0];
            this.mReceiveTargetTable = new Hashtable();
        } else {
            this.mResultPluginArr = pluginArr;
            this.mReceiveTargetTable = targetTable;
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        FormLayout layout = new FormLayout("fill:pref:grow", "");
        contentPane.setLayout((LayoutManager)layout);
        contentPane.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        ProgramReceiveIf[] tempProgramReceiveIf = Plugin.getPluginManager().getReceiveIfs(caller, null);
        ArrayList<ProgramReceiveIf> disabledList = new ArrayList<ProgramReceiveIf>(disabledReceiveTargets != null ? disabledReceiveTargets.length : 0);
        if (disabledReceiveTargets != null) {
            for (ProgramReceiveTarget target : disabledReceiveTargets) {
                disabledList.add(target.getReceifeIfForIdOfTarget());
            }
        }
        if (caller != null) {
            ArrayList<ProgramReceiveIf> list = new ArrayList<ProgramReceiveIf>();
            for (ProgramReceiveIf tempIf : tempProgramReceiveIf) {
                if (tempIf.getId().compareTo(caller.getId()) == 0) continue;
                list.add(tempIf);
            }
            this.mPluginItemList = new SelectableItemList<ProgramReceiveIf>(this.mResultPluginArr, list.toArray(new ProgramReceiveIf[list.size()]), disabledList.toArray(new ProgramReceiveIf[disabledList.size()]));
        } else {
            this.mPluginItemList = new SelectableItemList<ProgramReceiveIf>(this.mResultPluginArr, tempProgramReceiveIf, disabledList.toArray(new ProgramReceiveIf[disabledList.size()]));
        }
        this.mPluginItemList.setSelectionMode(0);
        int pos = 1;
        layout.appendRow(RowSpec.decode((String)"fill:default:grow"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        if (targetTable != null) {
            JRadioButton addRemove;
            JRadioButton remove;
            JRadioButton add;
            JSplitPane splitPane = new JSplitPane();
            splitPane.setLeftComponent(this.mPluginItemList);
            FormLayout typeLayout = new FormLayout("5dlu,default:grow", "5dlu,default,5dlu,default,default");
            JPanel typePanel = new JPanel((LayoutManager)typeLayout);
            AtomicReference currentTarget = new AtomicReference();
            if (type != 0) {
                ButtonGroup bg = new ButtonGroup();
                typePanel.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("type", "Type of sending")), CC.xyw((int)1, (int)2, (int)2));
                add = new JRadioButton(LOCALIZER.msg("add", "Added"));
                add.addItemListener(e -> {
                    if (currentTarget.get() != null && e.getStateChange() == 1) {
                        ((ProgramReceiveTarget)currentTarget.get()).setEventType(1);
                    }
                });
                bg.add(add);
                typePanel.add((Component)add, CC.xy((int)2, (int)4));
                if (type != 2) {
                    remove = new JRadioButton(LOCALIZER.msg("remove", "Removed"));
                    remove.addItemListener(e -> {
                        if (currentTarget.get() != null && e.getStateChange() == 1) {
                            ((ProgramReceiveTarget)currentTarget.get()).setEventType(2);
                        }
                    });
                    bg.add(remove);
                    typePanel.add((Component)remove, CC.xy((int)2, (int)5));
                } else {
                    remove = null;
                }
                if (type == 3 || type == 2) {
                    int row = 4;
                    if (type == 2) {
                        row = 5;
                    } else {
                        typeLayout.insertRow(row, RowSpec.decode((String)"default"));
                    }
                    addRemove = new JRadioButton(LOCALIZER.msg("both", "Added and removed"));
                    addRemove.addItemListener(e -> {
                        if (currentTarget.get() != null && e.getStateChange() == 1) {
                            ((ProgramReceiveTarget)currentTarget.get()).setEventType(3);
                        }
                    });
                    bg.add(addRemove);
                    addRemove.setSelected(true);
                    typePanel.add((Component)addRemove, CC.xy((int)2, (int)row));
                } else {
                    addRemove = null;
                    add.setSelected(true);
                }
            } else {
                add = null;
                remove = null;
                addRemove = null;
            }
            JPanel targetPanel = new JPanel();
            targetPanel.setLayout(new BoxLayout(targetPanel, 1));
            this.mPluginItemList.addListSelectionListener(e -> {
                try {
                    if (!e.getValueIsAdjusting()) {
                        targetPanel.removeAll();
                        SelectableItem<ProgramReceiveIf> pluginItem = this.mPluginItemList.getSelectedValue();
                        ProgramReceiveIf plugin = pluginItem.getItem();
                        ProgramReceiveTarget[] pluginTargets = plugin.getProgramReceiveTargets();
                        this.mCurrentTargets = Arrays.copyOf(pluginTargets, pluginTargets.length);
                        if (this.mCurrentTargets != null) {
                            Arrays.sort(this.mCurrentTargets);
                            ArrayList<ProgramReceiveTarget> targets = this.mReceiveTargetTable.get(plugin);
                            if (targets == null || !pluginItem.isSelected()) {
                                targets = new ArrayList();
                            }
                            if (pluginItem.isSelected() && targets.isEmpty()) {
                                targets.add(this.mCurrentTargets[0]);
                            }
                            for (ProgramReceiveTarget t : targets) {
                                for (int i = this.mCurrentTargets.length - 1; i >= 0; --i) {
                                    if (!t.equals(this.mCurrentTargets[i]) || t.getEventType() > this.mCurrentTargets[i].getSupportedEventType()) continue;
                                    this.mCurrentTargets[i].setEventType(t.getEventType());
                                }
                            }
                            this.mReceiveTargetTable.put(plugin, targets);
                            SelectableItemList<ProgramReceiveTarget> targetList = new SelectableItemList<ProgramReceiveTarget>(targets.toArray(new ProgramReceiveTarget[targets.size()]), this.mCurrentTargets, disabledReceiveTargets);
                            targetPanel.add(targetList);
                            if (typePanel != null) {
                                targetPanel.remove(typePanel);
                            }
                            targetList.addListSelectionListener(listEvent -> {
                                if (!listEvent.getValueIsAdjusting()) {
                                    currentTarget.set(null);
                                    if (typePanel != null) {
                                        targetPanel.remove(typePanel);
                                        targetPanel.revalidate();
                                        targetPanel.repaint();
                                    }
                                    SelectableItem<ProgramReceiveIf> currPluginItem = this.mPluginItemList.getSelectedValue();
                                    ProgramReceiveIf currPlugin = currPluginItem.getItem();
                                    SelectableItem current = targetList.getSelectedValue();
                                    if (current != null && typePanel != null) {
                                        currentTarget.set((ProgramReceiveTarget)current.getItem());
                                        int supportedType = ((ProgramReceiveTarget)current.getItem()).getSupportedEventType();
                                        if (type != 0 && currPlugin.canReceiveProgramsWithTarget() && supportedType == 3) {
                                            int currentType = ((ProgramReceiveTarget)current.getItem()).getEventType();
                                            switch (currentType) {
                                                case 0: 
                                                case 1: {
                                                    if (add == null) break;
                                                    add.setSelected(true);
                                                    break;
                                                }
                                                case 2: {
                                                    if (remove == null) break;
                                                    remove.setSelected(true);
                                                    break;
                                                }
                                                case 3: {
                                                    if (addRemove != null) {
                                                        addRemove.setSelected(true);
                                                        break;
                                                    }
                                                    if (add == null) break;
                                                    add.setSelected(true);
                                                }
                                            }
                                            targetPanel.add(typePanel);
                                            targetPanel.revalidate();
                                            targetPanel.repaint();
                                        }
                                    } else {
                                        currentTarget.set(null);
                                    }
                                    List sel = targetList.getSelectionList();
                                    ArrayList<ProgramReceiveTarget> selTargets = new ArrayList<ProgramReceiveTarget>(sel.size());
                                    for (ProgramReceiveTarget obj : sel) {
                                        selTargets.add(obj);
                                    }
                                    if (currPluginItem.isSelected() != sel.size() > 0) {
                                        currPluginItem.setSelected(sel.size() > 0);
                                        this.mPluginItemList.updateCurrentSelection();
                                    }
                                    this.mReceiveTargetTable.put(currPlugin, selTargets);
                                }
                            });
                            if (targetList.getSelectedValue() == null && !targetList.isEmpty()) {
                                targetList.setSelectedIndex(0);
                            }
                        }
                        targetPanel.updateUI();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            });
            splitPane.setRightComponent(targetPanel);
            contentPane.add((Component)splitPane, cc.xy(1, pos));
        } else {
            contentPane.add(this.mPluginItemList, cc.xy(1, pos));
        }
        this.mPluginItemList.setSelectedIndex(0);
        pos += 2;
        if (description != null) {
            JLabel lb = new JLabel(description);
            layout.appendRow(RowSpec.decode((String)"pref"));
            layout.appendRow(RowSpec.decode((String)"3dlu"));
            contentPane.add((Component)lb, cc.xy(1, pos));
            pos += 2;
        }
        JButton okBt = new JButton(Localizer.getLocalization("i18n_ok"));
        JButton cancelBt = new JButton(Localizer.getLocalization("i18n_cancel"));
        okBt.addActionListener(event -> {
            this.mOkWasPressed = true;
            List<ProgramReceiveIf> list = this.mPluginItemList.getSelectionList();
            this.mResultPluginArr = new ProgramReceiveIf[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.mResultPluginArr[i] = list.get(i);
            }
            this.close();
        });
        cancelBt.addActionListener(event -> {
            this.mOkWasPressed = false;
            this.mResultPluginArr = null;
            this.close();
        });
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        builder.addButton((JComponent[])new JButton[]{okBt, cancelBt});
        layout.appendRow(RowSpec.decode((String)"pref"));
        contentPane.add((Component)builder.getPanel(), cc.xy(1, pos));
        Settings.layoutWindow("pluginChooserDlg", this, new Dimension(350, 300), parent);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PluginChooserDlg.this.close();
            }
        });
    }

    public ProgramReceiveIf[] getPlugins() {
        if (this.mResultPluginArr == null) {
            return new ProgramReceiveIf[0];
        }
        return (ProgramReceiveIf[])this.mResultPluginArr.clone();
    }

    public ProgramReceiveTarget[] getReceiveTargets() {
        if (this.mOkWasPressed) {
            ArrayList targetList = new ArrayList();
            Enumeration<ProgramReceiveIf> keyEnum = this.mReceiveTargetTable.keys();
            while (keyEnum.hasMoreElements()) {
                ProgramReceiveIf plugin = keyEnum.nextElement();
                for (ProgramReceiveIf selectedPlugin : this.mResultPluginArr) {
                    if (selectedPlugin != plugin) continue;
                    targetList.addAll(this.mReceiveTargetTable.get(plugin));
                }
            }
            return targetList.toArray(new ProgramReceiveTarget[targetList.size()]);
        }
        return null;
    }

    @Override
    public void close() {
        this.setVisible(false);
        this.dispose();
    }
}

