/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Plugin;
import devplugin.PluginsProgramFilter;
import devplugin.ProgramFilter;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tvbrowser.core.filters.Excludable;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.ui.filter.dlgs.EditFilterDlg;
import tvbrowser.ui.filter.dlgs.FilterTreeModel;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.WrapperFilter;

public final class FilterSelectionPanel
extends JPanel {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(FilterSelectionPanel.class);
    private JLabel mLabel;
    private JComboBox<WrapperFilter> mFilterBox;
    private JButton mEdit;
    private WrapperFilter mNewFilter;
    private WrapperFilter mLastSelectedFilter;

    public static String getNewFilterName() {
        return LOCALIZER.ellipsisMsg("createFilter", "Create new filter");
    }

    private static String getLineSpec(boolean hasLabel, boolean grow) {
        StringBuilder b = new StringBuilder();
        if (hasLabel) {
            b.append("default,2dlu,");
        } else {
            b.append("0dlu,0dlu,");
        }
        b.append("default");
        if (grow) {
            b.append(":grow");
        }
        b.append(",2dlu,default");
        return b.toString();
    }

    public FilterSelectionPanel(ProgramFilter selectedFilter) {
        this(null, selectedFilter, true);
    }

    public FilterSelectionPanel(String label, ProgramFilter selectedFilter, boolean showEditButton) {
        this(label, selectedFilter, showEditButton, false, new Class[0]);
    }

    @SafeVarargs
    public FilterSelectionPanel(String label, ProgramFilter selectedFilter, boolean showEditButton, boolean grow, Class<? extends Excludable> ... exclusions) {
        ProgramFilter[] filters;
        this.setLayout((LayoutManager)new FormLayout(FilterSelectionPanel.getLineSpec(label == null || !label.isBlank(), grow), "default"));
        this.mFilterBox = new JComboBox();
        this.mNewFilter = new WrapperFilter(new UserFilter(FilterSelectionPanel.getNewFilterName()));
        if (selectedFilter == null) {
            selectedFilter = FilterManagerImpl.getInstance().getDefaultFilter();
        }
        if (selectedFilter == null) {
            selectedFilter = FilterManagerImpl.getInstance().getAllFilter();
        }
        for (ProgramFilter filter : filters = FilterManagerImpl.getInstance().getAvailableFilters()) {
            if (this.isExcluded(filter, exclusions)) continue;
            WrapperFilter wrapper = new WrapperFilter(filter);
            this.mFilterBox.addItem(wrapper);
            if (!filter.getName().equals(selectedFilter.getName())) continue;
            this.mFilterBox.setSelectedItem(wrapper);
        }
        this.mFilterBox.addItem(this.mNewFilter);
        this.mLabel = new JLabel(label != null ? label : LOCALIZER.msg("filterLabel", "Filter:"));
        this.add((Component)this.mLabel, CC.xy((int)1, (int)1));
        this.add(this.mFilterBox, CC.xy((int)3, (int)1));
        if (showEditButton) {
            this.mEdit = new JButton(Localizer.getLocalization("i18n_edit"), TVBrowserIcons.edit(16));
            this.mEdit.setEnabled(selectedFilter instanceof UserFilter);
            this.mEdit.addActionListener(e -> {
                try {
                    EditFilterDlg dlg;
                    UserFilter filter = (UserFilter)((WrapperFilter)this.mFilterBox.getSelectedItem()).getFilter();
                    boolean filterNew = this.mFilterBox.getSelectedItem().equals(this.mNewFilter);
                    if (filterNew) {
                        filter = new UserFilter("");
                    }
                    if ((dlg = new EditFilterDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), FilterList.getInstance(), filter, true)).getOkWasPressed()) {
                        if (filterNew) {
                            FilterTreeModel.getInstance().addFilter(filter);
                            FilterList.getInstance().store();
                            if (!this.isExcluded(filter, exclusions)) {
                                WrapperFilter wrapper = new WrapperFilter(filter);
                                this.mFilterBox.insertItemAt(wrapper, this.mFilterBox.getItemCount() - 1);
                                this.mFilterBox.setSelectedItem(wrapper);
                            }
                        } else {
                            FilterTreeModel.getInstance().fireFilterTouched(filter);
                        }
                        dlg.dispose();
                    } else if (filterNew) {
                        this.mFilterBox.setSelectedItem(this.mLastSelectedFilter);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            });
            this.mFilterBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.mEdit.setEnabled(((WrapperFilter)this.mFilterBox.getSelectedItem()).getFilter() instanceof UserFilter);
                    if (this.mFilterBox.getSelectedItem().equals(this.mNewFilter)) {
                        this.mFilterBox.setPopupVisible(false);
                        this.mEdit.doClick();
                    }
                } else {
                    this.mLastSelectedFilter = (WrapperFilter)e.getItem();
                }
            });
            this.add((Component)this.mEdit, CC.xy((int)5, (int)1));
        }
    }

    public ProgramFilter getSelectedFilter() {
        return ((WrapperFilter)this.mFilterBox.getSelectedItem()).getFilter();
    }

    public JComboBox<WrapperFilter> getFilterBox() {
        return this.mFilterBox;
    }

    public JButton getEditButton() {
        return this.mEdit;
    }

    public void setSelectedFilter(ProgramFilter filter) {
        this.mFilterBox.setSelectedItem(new WrapperFilter(filter));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mLabel.setEnabled(enabled);
        this.mFilterBox.setEnabled(enabled);
        if (this.mEdit != null) {
            this.mEdit.setEnabled(enabled && ((WrapperFilter)this.mFilterBox.getSelectedItem()).getFilter() instanceof UserFilter);
        }
    }

    private boolean isExcluded(ProgramFilter filter, Class<? extends Excludable>[] exclusions) {
        boolean result = false;
        if (exclusions != null) {
            for (Class<? extends Excludable> exclusion : exclusions) {
                if (!exclusion.isInstance(filter) && (!(filter instanceof PluginsProgramFilter) || !Plugin.class.isAssignableFrom(exclusion) || !((PluginsProgramFilter)filter).containsPluinClass(exclusion)) && (!(filter instanceof UserFilter) || !FilterComponent.class.isAssignableFrom(exclusion) || !((UserFilter)filter).containsRuleComponent(exclusion))) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

