/*
 * Decompiled with CFR 0.152.
 */
package util.io.windows.registry;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import util.io.ExecutionHandler;
import util.io.windows.registry.RegistryValue;

public class RegistryEditor {
    private static final File WSCRIPT = new File(System.getenv("windir") + File.separator + (System.getProperty("os.arch").contains("64") ? "SysWOW64" : "System32") + File.separator + "wscript.exe");
    private Hashtable<String, ArrayList<RegistryValue>> mValueTable = new Hashtable();

    private RegistryEditor() {
    }

    public static RegistryEditor create() {
        return new RegistryEditor();
    }

    public void setValue(String path, RegistryValue value) {
        ArrayList<RegistryValue> list = this.mValueTable.get(path);
        if (list == null) {
            list = new ArrayList();
            this.mValueTable.put(path, list);
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                RegistryValue v = list.get(i);
                if (!value.getName().equals(v.getName())) continue;
                list.remove(i);
                break;
            }
        }
        if (value != null) {
            list.add(value);
        }
    }

    public void commit() {
        this.commit("regChange");
    }

    public void commit(String prefix) {
        block34: {
            try {
                File reg = File.createTempFile(prefix, ".reg");
                File vbs = File.createTempFile(prefix, ".vbs");
                try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reg), "ISO-8859-1"));){
                    out.write("REGEDIT4\r\n\r\n");
                    Set<String> keys = this.mValueTable.keySet();
                    boolean first = true;
                    for (String key : keys) {
                        if (!first) {
                            out.write("\r\n\r\n");
                        } else {
                            first = false;
                        }
                        out.write("[");
                        out.write(key);
                        out.write("]");
                        ArrayList<RegistryValue> list = this.mValueTable.get(key);
                        StringBuilder content = new StringBuilder();
                        for (RegistryValue value : list) {
                            out.write("\r\n");
                            content.setLength(0);
                            if (value.getName().isBlank()) {
                                content.append("@");
                            } else {
                                content.append("\"").append(value.getName().replace("\"", "\\\"")).append("\"");
                            }
                            content.append("=");
                            if (value.isRegBinary()) {
                                content.append("hex:");
                                content.append(value.getData().replace(" ", ","));
                            } else if (value.isRegDword()) {
                                content.append("dword:");
                                for (int i = value.getData().length(); i < 8; ++i) {
                                    content.append("0");
                                }
                                content.append(value.getData());
                            } else if (value.isRegQword()) {
                                content.append("qword:");
                                for (int i = value.getData().length(); i < 16; ++i) {
                                    content.append("0");
                                }
                                content.append(value.getData());
                            } else if (value.isRegSz()) {
                                content.append("\"").append(value.getData().replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
                            }
                            String test = content.toString();
                            if (test.length() > 79 && value.isRegBinary()) {
                                int i;
                                out.write(test.substring(0, 79));
                                out.write("\\\r\n");
                                for (i = 156; i < test.length(); i += 77) {
                                    out.write("  ");
                                    out.write(test.substring(i - 77, i));
                                    if (i >= test.length() - 1) continue;
                                    out.write("\\\r\n");
                                }
                                if (i - 77 >= test.length() - 1) continue;
                                out.write("  ");
                                out.write(test.substring(i - 77, test.length()));
                                continue;
                            }
                            out.write(test);
                        }
                    }
                }
                if (reg.length() <= 0L) break block34;
                try {
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(vbs), "ISO-8859-1"));
                    try {
                        out.write("Set UAC = CreateObject(\"Shell.Application\")\r\n");
                        out.write("UAC.ShellExecute \"regedit.exe\", \"" + reg.getAbsolutePath() + "\", \"\", \"runas\", 1");
                    }
                    finally {
                        out.close();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                ExecutionHandler h = ExecutionHandler.create(WSCRIPT.getAbsolutePath(), vbs.getAbsolutePath());
                h.execute(true, true);
                try {
                    h.getProcess().waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

