/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.toolbar.ContextMenu;
import tvbrowser.ui.mainframe.toolbar.DefaultToolBarModel;
import tvbrowser.ui.mainframe.toolbar.ToolBar;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class ToolBarDragAndDropSettings
extends JDialog
implements WindowListener,
DragGestureListener,
DropTargetListener,
ActionListener,
MouseListener,
WindowClosingIf {
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(ToolBarDragAndDropSettings.class);
    private static final Logger LOG = Logger.getLogger(ToolBarDragAndDropSettings.class.getName());
    private static final long serialVersionUID = 1L;
    private Vector<Action> mCurrentActions = new Vector();
    private Vector<Action> mAvailableActions = new Vector();
    private JComboBox<String> mShowCB;
    private JComboBox<String> mLocationCB;
    private JCheckBox mShowToolbarCb;
    private JCheckBox mShowPluginActionsCb;
    private JCheckBox mUseBigIconsCb;
    private JCheckBox mShowSearchFieldCb;
    private JPanel mButtonPanel;
    private boolean mWest;
    private Rectangle2D mCueLine = new Rectangle2D.Float();
    private static ToolBarDragAndDropSettings mInstance = null;

    public ToolBarDragAndDropSettings() {
        super(MainFrame.getInstance());
        mInstance = this;
        UiUtilities.registerForClosing(this);
        this.getContentPane().setLayout((LayoutManager)new FormLayout("fill:pref:grow", "pref, 3dlu, fill:min:grow, 3dlu, pref, 3dlu, pref"));
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(0, 6, 2, 6));
        DefaultToolBarModel toolbarModel = DefaultToolBarModel.getInstance();
        Action[] currentActions = toolbarModel.getActions();
        ArrayList<Action> notSelectedActionsList = new ArrayList<Action>(Arrays.asList(toolbarModel.getAvailableActions()));
        for (Action a : currentActions) {
            this.mCurrentActions.addElement(a);
        }
        for (Action a : currentActions) {
            if (!notSelectedActionsList.contains(a)) continue;
            notSelectedActionsList.remove(a);
        }
        Action[] availableActions = new Action[notSelectedActionsList.size()];
        notSelectedActionsList.toArray(availableActions);
        for (Action a : availableActions) {
            this.mAvailableActions.addElement(a);
        }
        this.mAvailableActions.insertElementAt(toolbarModel.getSeparatorAction(), 0);
        this.mAvailableActions.insertElementAt(toolbarModel.getGlueAction(), 1);
        this.mAvailableActions.insertElementAt(toolbarModel.getSpaceAction(), 2);
        this.mButtonPanel = new JPanel();
        this.mButtonPanel.setLayout(new GridLayout(0, 4, 2, 2));
        this.mButtonPanel.setAlignmentX(0.0f);
        JScrollPane pane = new JScrollPane(this.mButtonPanel);
        pane.setAlignmentX(0.0f);
        pane.getVerticalScrollBar().setUnitIncrement(73);
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addMouseAdapterForHandCursorToComponent(pane);
        JPanel tVisPanel = new JPanel();
        tVisPanel.setAlignmentX(0.0f);
        tVisPanel.setLayout((LayoutManager)new FormLayout("default,10dlu:grow,default", "default,default"));
        tVisPanel.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY), BorderFactory.createEmptyBorder(10, 5, 9, 5)));
        this.mShowToolbarCb = new JCheckBox(LOCALIZER.msg("showToolbar", "Show toolbar"));
        this.mShowToolbarCb.setSelected(Settings.ToolBar.IS_VISIBLE.getBoolean());
        tVisPanel.add((Component)this.mShowToolbarCb, CC.xy((int)1, (int)1));
        this.mShowSearchFieldCb = new JCheckBox(LOCALIZER.msg("showSearchField", "Show Search field"));
        this.mShowSearchFieldCb.setSelected(Settings.ToolBar.IS_SEARCH_FIELD_VISIBLE.getBoolean());
        tVisPanel.add((Component)this.mShowSearchFieldCb, CC.xy((int)3, (int)1));
        this.mShowPluginActionsCb = new JCheckBox(LOCALIZER.msg("showPluginAction", "Show plugin actions in context menu"));
        this.mShowPluginActionsCb.setSelected(Settings.ToolBar.PLUGIN_FUNCTIONS_IN_MENU_SHOW.getBoolean());
        tVisPanel.add((Component)this.mShowPluginActionsCb, CC.xyw((int)1, (int)2, (int)3));
        JPanel tSetPanel = new JPanel((LayoutManager)new FormLayout("default,5dlu,default,0dlu:grow,default,5dlu,default,5dlu,default", "default"));
        tSetPanel.setAlignmentX(0.0f);
        this.mLocationCB = new JComboBox<String>(new String[]{LOCALIZER.msg("top", "top"), Localizer.getLocalization("i18n_left")});
        if ("west".equals(Settings.ToolBar.LOCATION.getString())) {
            this.mLocationCB.setSelectedIndex(1);
            this.mWest = true;
        } else {
            this.mWest = false;
        }
        this.mShowCB = new JComboBox<String>(new String[]{ContextMenu.mLocalizer.msg("text.and.icon", "text and icon"), ContextMenu.mLocalizer.msg("text", "text"), ContextMenu.mLocalizer.msg("icon", "icon")});
        String style = Settings.ToolBar.BUTTON_STYLE.getString();
        if ("text".equals(style)) {
            this.mShowCB.setSelectedIndex(1);
        } else if ("icon".equals(style)) {
            this.mShowCB.setSelectedIndex(2);
        }
        this.mShowCB.setAlignmentX(0.5f);
        this.mShowCB.setMaximumSize(this.mShowCB.getPreferredSize());
        this.mUseBigIconsCb = new JCheckBox(ContextMenu.mLocalizer.msg("bigIcons", "Use big icons"));
        this.mUseBigIconsCb.setSelected(Settings.ToolBar.BIG_ICONS_USE.getBoolean());
        CellConstraints cc = new CellConstraints();
        tSetPanel.add((Component)new JLabel(LOCALIZER.msg("location", "Location")), cc.xy(1, 1));
        tSetPanel.add(this.mLocationCB, cc.xy(3, 1));
        tSetPanel.add((Component)new JLabel(LOCALIZER.msg("icons", "Icons")), cc.xy(5, 1));
        tSetPanel.add(this.mShowCB, cc.xy(7, 1));
        tSetPanel.add((Component)this.mUseBigIconsCb, cc.xy(9, 1));
        tSetPanel.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.GRAY), BorderFactory.createEmptyBorder(10, 5, 9, 5)));
        JPanel okButtonPanel = new JPanel();
        okButtonPanel.setAlignmentX(0.0f);
        okButtonPanel.setLayout(new BoxLayout(okButtonPanel, 0));
        okButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        okButtonPanel.add(Box.createHorizontalGlue());
        okButtonPanel.add(ok);
        this.mShowToolbarCb.addActionListener(this);
        this.mShowPluginActionsCb.addActionListener(this);
        this.mShowSearchFieldCb.addActionListener(this);
        this.mShowCB.addActionListener(this);
        this.mUseBigIconsCb.addActionListener(this);
        this.mLocationCB.addActionListener(this);
        this.getContentPane().add((Component)tVisPanel, cc.xy(1, 1));
        this.getContentPane().add((Component)pane, cc.xy(1, 3));
        this.getContentPane().add((Component)tSetPanel, cc.xy(1, 5));
        this.getContentPane().add((Component)okButtonPanel, cc.xy(1, 7));
        Settings.layoutWindow("ToolBarDragAndDropSettings.class", this, new Dimension(630, 400), MainFrame.getInstance());
        this.addWindowListener(this);
        this.setTitle(LOCALIZER.msg("modifyToolbar", "Modify Toolbar"));
        this.setVisible(true);
        this.buildButtonPanel();
        this.setMainframeMenusEnabled(false);
        this.init();
    }

    private void addMouseAdapterForHandCursorToComponent(JComponent c) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolBarDragAndDropSettings.this.getContentPane().setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolBarDragAndDropSettings.this.getContentPane().setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public static ToolBarDragAndDropSettings getInstance() {
        return mInstance;
    }

    private void buildButtonPanel() {
        this.mButtonPanel.removeAll();
        int n = this.mAvailableActions.size() / 4;
        if (this.mAvailableActions.size() % 4 != 0) {
            ++n;
        }
        this.mButtonPanel.setPreferredSize(new Dimension(570, n * 73));
        for (Action action : this.mAvailableActions) {
            JButton button = new JButton("<html><div style=\"text-align:center\">" + (String)action.getValue("Name") + "</div></html>");
            button.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            Icon icon = (Icon)action.getValue("BigIcon");
            if (icon == null) {
                LOG.warning("Big icon missing for action " + action.getValue("Name"));
                icon = (Icon)action.getValue("SmallIcon");
            }
            if (!(icon == null || action.getValue("NoIconResize") != null && ((Boolean)action.getValue("NoIconResize")).booleanValue() || icon.getIconHeight() == 22 && icon.getIconWidth() == 22)) {
                icon = UiUtilities.scaleIcon(icon, 22, 22);
            }
            button.setIcon(icon);
            button.setDisabledIcon(icon);
            button.setVerticalTextPosition(3);
            button.setHorizontalTextPosition(0);
            button.setFont(new Font("Dialog", 0, 10));
            button.addMouseListener(this);
            this.addMouseAdapterForHandCursorToComponent(button);
            button.setContentAreaFilled(false);
            DragSource d = new DragSource();
            d.createDefaultDragGestureRecognizer(button, 2, this);
            button.setEnabled(false);
            this.mButtonPanel.add(button);
        }
        this.mButtonPanel.updateUI();
    }

    private void init() {
        new DropTarget(MainFrame.getInstance().getToolbar(), this);
        new DropTarget(MainFrame.getInstance().getToolBarPanel(), this);
        new DropTarget(this.mButtonPanel, this);
        MainFrame.getInstance().getToolbar().disableForDragAndDrop(this, this.mWest);
        if (this.mShowToolbarCb.isSelected()) {
            this.mShowSearchFieldCb.setEnabled(true);
        } else {
            this.mShowSearchFieldCb.setEnabled(false);
        }
    }

    private void setMainframeMenusEnabled(boolean enabled) {
        JMenuBar bar = MainFrame.getInstance().getJMenuBar();
        for (int i = 0; i < bar.getMenuCount(); ++i) {
            JMenu menu = bar.getMenu(i);
            if (menu == null) continue;
            menu.setEnabled(enabled);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.close();
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        if (flavors.length < 2) {
            e.rejectDrag();
            return;
        }
        if (flavors[0].getHumanPresentableName().equals("Action") && flavors[1].getHumanPresentableName().equals("Integer")) {
            e.acceptDrag(e.getDropAction());
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(e.getDropAction());
        Transferable tr = e.getTransferable();
        DataFlavor[] flavors = tr.getTransferDataFlavors();
        try {
            String name = (String)tr.getTransferData(flavors[0]);
            int index = (Integer)tr.getTransferData(flavors[1]);
            Action separator = DefaultToolBarModel.getInstance().getSeparatorAction();
            Action glue = DefaultToolBarModel.getInstance().getGlueAction();
            Action space = DefaultToolBarModel.getInstance().getSpaceAction();
            JComponent target = (JComponent)((DropTarget)e.getSource()).getComponent();
            if (target.equals(this.mButtonPanel)) {
                if (!(index != -1 || separator.getValue("Name").equals(name) || glue.getValue("Name").equals(name) || space.getValue("Name").equals(name))) {
                    for (Action a : this.mCurrentActions) {
                        if (!a.getValue("Name").equals(name)) continue;
                        this.mCurrentActions.removeElement(a);
                        this.mAvailableActions.addElement(a);
                        break;
                    }
                } else if (index != -1) {
                    Action a = this.mCurrentActions.elementAt(index);
                    this.mCurrentActions.removeElementAt(index);
                    if (!(separator.getValue("Name").equals(name) || glue.getValue("Name").equals(name) || space.getValue("Name").equals(name))) {
                        this.mAvailableActions.addElement(a);
                    }
                }
                this.saveSettings();
            } else if (target.equals(MainFrame.getInstance().getToolbar()) || ((DropTarget)e.getSource()).getComponent().equals(MainFrame.getInstance().getToolBarPanel())) {
                Point location = e.getLocation();
                if (this.mWest) {
                    location.setLocation(10, location.y);
                } else {
                    location.setLocation(location.x, MainFrame.getInstance().getToolbar().getHeight() / 2);
                }
                JComponent c = (JComponent)MainFrame.getInstance().getToolbar().getComponentAt(location);
                if ((c == null || c instanceof JToolBar) && MainFrame.getInstance().getToolbar().getComponentCount() > 0 && (c = (JComponent)MainFrame.getInstance().getToolbar().getComponent(MainFrame.getInstance().getToolbar().getComponentCount() - 1)) != null) {
                    location.setLocation(c.getLocation().x + c.getWidth() - 1, c.getLocation().y + c.getHeight() - 1);
                }
                int n = 0;
                if (c != null) {
                    Point p = SwingUtilities.convertPoint(MainFrame.getInstance().getToolBarPanel(), location, c);
                    n = MainFrame.getInstance().getToolbar().getComponentIndex(c);
                    if (!(this.mWest && p.y < c.getHeight() / 2 || !this.mWest && p.x < c.getWidth() / 2)) {
                        ++n;
                    }
                }
                if (index != -1) {
                    Action a = this.mCurrentActions.remove(index);
                    if (index < n) {
                        --n;
                    }
                    if (n > MainFrame.getInstance().getToolbar().getComponentCount() - 1) {
                        this.mCurrentActions.insertElementAt(a, n - 1);
                    } else {
                        this.mCurrentActions.insertElementAt(a, n);
                    }
                } else {
                    if (n < 0) {
                        n = 0;
                    }
                    for (Action a : this.mAvailableActions) {
                        if (!a.getValue("Name").equals(name)) continue;
                        if (!(separator.getValue("Name").equals(name) || glue.getValue("Name").equals(name) || space.getValue("Name").equals(name))) {
                            this.mAvailableActions.removeElement(a);
                        }
                        this.mCurrentActions.insertElementAt(a, n);
                        break;
                    }
                }
                this.saveSettings();
            }
            e.dropComplete(true);
        }
        catch (Exception ee) {
            ee.printStackTrace();
            e.dropComplete(false);
        }
        this.mCueLine.setRect(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Action separator = DefaultToolBarModel.getInstance().getSeparatorAction();
        Action glue = DefaultToolBarModel.getInstance().getGlueAction();
        Action space = DefaultToolBarModel.getInstance().getSpaceAction();
        Action[] actions = DefaultToolBarModel.getInstance().getAvailableActions();
        JComponent c = (JComponent)e.getComponent();
        for (Action action : actions) {
            String text = c instanceof JToolBar.Separator ? (String)separator.getValue("Name") : (c instanceof JPanel ? (String)glue.getValue("Name") : (((AbstractButton)c).getText() == null ? "notext" : (!((AbstractButton)c).getText().startsWith("<html>") ? ((AbstractButton)c).getText() : ((AbstractButton)c).getText().substring(37, ((AbstractButton)c).getText().length() - 13))));
            if (!action.getValue("Name").equals(text) && !separator.getValue("Name").equals(text) && !glue.getValue("Name").equals(text) && !space.getValue("Name").equals(text) && !text.equals("notext")) continue;
            c.setBackground(Color.WHITE);
            e.startDrag(null, new TransferAction(text, MainFrame.getInstance().getToolbar().getComponentIndex(e.getComponent())));
            break;
        }
    }

    private void saveSettings() {
        int size = this.mCurrentActions.size();
        String[] ids = new String[size];
        for (int i = 0; i < size; ++i) {
            Action action = this.mCurrentActions.elementAt(i);
            ids[i] = (String)action.getValue("ActionId");
        }
        DefaultToolBarModel.getInstance().setButtonIds(ids);
        Settings.ToolBar.BUTTONS.setStringArray(ids);
        Settings.ToolBar.PLUGIN_FUNCTIONS_IN_MENU_SHOW.setBoolean(this.mShowPluginActionsCb.isSelected());
        ToolBar toolbar = MainFrame.getInstance().getToolbar();
        int inx = this.mShowCB.getSelectedIndex();
        if (inx == 0) {
            toolbar.setStyle(3);
        } else if (inx == 1) {
            toolbar.setStyle(1);
        } else if (inx == 2) {
            toolbar.setStyle(2);
        }
        if (this.mLocationCB.getSelectedIndex() == 1) {
            toolbar.setToolbarLocation("West");
            this.mWest = true;
        } else {
            toolbar.setToolbarLocation("North");
            this.mWest = false;
        }
        MainFrame.getInstance().setShowToolbar(this.mShowToolbarCb.isSelected());
        MainFrame.getInstance().setShowSearchField(this.mShowSearchFieldCb.isSelected());
        toolbar.setUseBigIcons(this.mUseBigIconsCb.isSelected());
        toolbar.storeSettings();
        MainFrame.getInstance().updateToolbar();
        this.buildButtonPanel();
        this.init();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton && e.getActionCommand().equals("OK")) {
            this.windowClosing(new WindowEvent(this, 201));
        } else if (e.getSource() == this.mShowToolbarCb) {
            MainFrame.getInstance().setShowToolbar(this.mShowToolbarCb.isSelected());
            this.init();
        } else {
            this.saveSettings();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        JComponent target = (JComponent)((DropTarget)e.getSource()).getComponent();
        if (!target.equals(this.mButtonPanel)) {
            Point location = e.getLocation();
            if (this.mWest) {
                location.setLocation(10, location.y);
            } else {
                location.setLocation(location.x, MainFrame.getInstance().getToolbar().getHeight() / 2);
            }
            JComponent c = (JComponent)MainFrame.getInstance().getToolbar().getComponentAt(location);
            if ((c == null || c instanceof JToolBar) && MainFrame.getInstance().getToolbar().getComponentCount() > 0 && (c = (JComponent)MainFrame.getInstance().getToolbar().getComponent(MainFrame.getInstance().getToolbar().getComponentCount() - 1)) != null) {
                location.setLocation(c.getLocation().x + c.getWidth() - 1, c.getLocation().y + c.getHeight() - 1);
            }
            if (c != null) {
                JPanel toolBarPanel = MainFrame.getInstance().getToolBarPanel();
                Point p = SwingUtilities.convertPoint(toolBarPanel, location, c);
                Rectangle oldCueLineBounds = this.mCueLine.getBounds();
                if (this.mWest) {
                    this.mCueLine.setRect(1.0, p.y < c.getHeight() / 2 ? (double)(location.y - p.y) : (double)(location.y + c.getHeight() - p.y), toolBarPanel.getWidth() - 1, 2.0);
                } else {
                    this.mCueLine.setRect(p.x < c.getWidth() / 2 ? (double)(location.x - p.x) : (double)(location.x + c.getWidth() - p.x), 1.0, 2.0, toolBarPanel.getHeight() - 1);
                }
                if (!oldCueLineBounds.equals(this.mCueLine.getBounds())) {
                    Graphics2D g2d = (Graphics2D)toolBarPanel.getGraphics();
                    toolBarPanel.paintImmediately(oldCueLineBounds);
                    Color color = new Color(255, 0, 0, 180);
                    g2d.setColor(color);
                    g2d.fill(this.mCueLine);
                    g2d.dispose();
                }
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        MainFrame.getInstance().getToolBarPanel().paintImmediately(this.mCueLine.getBounds());
        this.mCueLine.setRect(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
            int index = MainFrame.getInstance().getToolbar().getComponentIndex(e.getComponent());
            int n = MainFrame.getInstance().getToolbar().getComponentCount();
            Action separator = DefaultToolBarModel.getInstance().getSeparatorAction();
            Action glue = DefaultToolBarModel.getInstance().getGlueAction();
            Action space = DefaultToolBarModel.getInstance().getSpaceAction();
            if (index != -1) {
                Action a = this.mCurrentActions.elementAt(index);
                this.mCurrentActions.removeElementAt(index);
                if (!(a.equals(separator) || a.equals(glue) || a.equals(space))) {
                    this.mAvailableActions.addElement(a);
                }
            } else {
                String name = ((AbstractButton)e.getComponent()).getText().substring(37, ((AbstractButton)e.getComponent()).getText().length() - 13);
                for (int i = 0; i < this.mAvailableActions.size(); ++i) {
                    Action a = this.mAvailableActions.elementAt(i);
                    if (!a.getValue("Name").equals(name)) continue;
                    if (!(separator.getValue("Name").equals(name) || glue.getValue("Name").equals(name) || space.getValue("Name").equals(name))) {
                        this.mAvailableActions.removeElement(a);
                    }
                    this.mCurrentActions.insertElementAt(a, n);
                }
            }
            this.saveSettings();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void close() {
        mInstance = null;
        this.setMainframeMenusEnabled(true);
        MainFrame.getInstance().updateToolbar();
        this.dispose();
    }

    private static class TransferAction
    implements Transferable {
        private String mName;
        private Integer mIndex;
        private DataFlavor mNF;
        private DataFlavor mIF;

        public TransferAction(String name, int index) {
            this.mName = name;
            this.mNF = new DataFlavor(Action.class, "Action");
            this.mIndex = index;
            this.mIF = new DataFlavor(Integer.class, "Integer");
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] f = new DataFlavor[]{this.mNF, this.mIF};
            return f;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor e) {
            return e.equals(this.mNF) || e.equals(this.mIF);
        }

        @Override
        public Object getTransferData(DataFlavor e) throws UnsupportedFlavorException, IOException {
            if (e.equals(this.mNF)) {
                return this.mName;
            }
            if (e.equals(this.mIF)) {
                return this.mIndex;
            }
            return null;
        }
    }
}

