/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.filter.dlgs;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.filters.filtercomponents.AcceptNoneFilterComponent;
import tvbrowser.core.filters.filtercomponents.SingleChannelFilterComponent;
import tvbrowser.core.filters.filtercomponents.UnknownFilterComponent;
import tvbrowser.ui.filter.dlgs.EditFilterComponentDlg;
import tvbrowser.ui.filter.dlgs.EditFilterDlg;
import tvbrowser.ui.filter.dlgs.FilterItem;
import tvbrowser.ui.filter.dlgs.FilterTreeModel;
import util.ui.EnhancedPanelBuilder;
import util.ui.TVBrowserIcons;

public class FilterComponentPanel
extends JPanel
implements ActionListener {
    private JList<FilterItem> mFilterComponentList;
    private DefaultListModel<FilterItem> mFilterComponentListModel;
    private JButton mNewBtn;
    private JButton mEditBtn;
    private JButton mCopyButton;
    private JButton mRemoveBtn;
    private JDialog mParent;
    private JTextField mFilterRuleTF;
    private UserFilter mFilter = null;
    private boolean mFilterComponentTouched = false;

    FilterComponentPanel(JDialog parent) {
        this(parent, null, null);
    }

    FilterComponentPanel(JDialog parent, JTextField filterRuleTF, UserFilter filter) {
        this.mParent = parent;
        this.mFilterRuleTF = filterRuleTF;
        this.mFilter = filter;
        EnhancedPanelBuilder filterComponents = new EnhancedPanelBuilder(new FormLayout("default:grow,5dlu,default"), (JPanel)this);
        this.mFilterComponentListModel = new DefaultListModel();
        if (this.mParent instanceof EditFilterDlg) {
            this.mFilterComponentListModel.addElement(new FilterItem(FilterItem.AND_KEY, 0));
            this.mFilterComponentListModel.addElement(new FilterItem(FilterItem.OR_KEY, 0));
            this.mFilterComponentListModel.addElement(new FilterItem(FilterItem.NOT_KEY, 0));
            this.mFilterComponentListModel.addElement(new FilterItem(FilterItem.OPEN_BRACKET_KEY, 0));
            this.mFilterComponentListModel.addElement(new FilterItem(FilterItem.CLOSE_BRACKET_KEY, 0));
        }
        this.mFilterComponentList = new JList<FilterItem>(this.mFilterComponentListModel);
        this.mFilterComponentList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof FilterItem) {
                    FilterItem item = (FilterItem)value;
                    if (item.isAndItem() || item.isNotItem() || item.isOrItem() || item.isOpenBracketItem() || item.isCloseBracketItem()) {
                        label.setFont(label.getFont().deriveFont(1));
                    } else if (item.getComponent().getDescription().length() > 0) {
                        label.setText(label.getText() + " [" + item.getComponent().getDescription() + "]");
                    }
                    label.setText(FilterComponentList.getLabelForComponent(item.getComponent(), label.getText()));
                }
                return label;
            }
        });
        this.mFilterComponentList.addListSelectionListener(e -> this.updateBtns());
        this.mFilterComponentList.setSelectionMode(0);
        FilterComponent[] fc = FilterComponentList.getInstance().getAvailableFilterComponents();
        Arrays.sort(fc, new FilterComponent.NameComparator());
        for (FilterComponent element : fc) {
            this.mFilterComponentListModel.addElement(new FilterItem(element, 0));
        }
        this.mNewBtn = new JButton(TVBrowserIcons.newIcon(16));
        this.mNewBtn.setToolTipText(EditFilterDlg.LOCALIZER.msg("newButton", "Create new filter component..."));
        this.mEditBtn = new JButton(TVBrowserIcons.edit(16));
        this.mEditBtn.setToolTipText(EditFilterDlg.LOCALIZER.msg("editButton", "Edit selected filter component..."));
        this.mCopyButton = new JButton(TVBrowserIcons.copy(16));
        this.mCopyButton.setToolTipText(EditFilterDlg.LOCALIZER.msg("copyButton", "Copy selected filter component..."));
        this.mRemoveBtn = new JButton(TVBrowserIcons.delete(16));
        this.mRemoveBtn.setToolTipText(EditFilterDlg.LOCALIZER.msg("removeButton", "Delete selected filter component"));
        this.mNewBtn.addActionListener(this);
        this.mEditBtn.addActionListener(this);
        this.mCopyButton.addActionListener(this);
        this.mRemoveBtn.addActionListener(this);
        filterComponents.addRow(false, (Component)this.mNewBtn, 3);
        filterComponents.addRow(this.mEditBtn, 3);
        filterComponents.addRow(this.mCopyButton, 3);
        filterComponents.addRow(this.mRemoveBtn, 3);
        filterComponents.addGrowingRow(false);
        filterComponents.add(new JScrollPane(this.mFilterComponentList), CC.xywh((int)1, (int)1, (int)1, (int)8));
        if (!(this.mParent instanceof EditFilterDlg)) {
            this.registerMouseListener();
        }
        this.updateBtns();
    }

    void registerMouseListener() {
        this.mFilterComponentList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FilterComponentPanel.this.mFilterComponentList.requestFocus();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    int index = FilterComponentPanel.this.mFilterComponentList.locationToIndex(e.getPoint());
                    FilterComponentPanel.this.mFilterComponentList.setSelectedIndex(index);
                    if (FilterComponentPanel.this.mEditBtn.isEnabled()) {
                        FilterComponentPanel.this.editSelectedFilterComponent();
                    }
                }
            }
        });
    }

    private void updateBtns() {
        if (this.mFilterComponentList == null) {
            return;
        }
        if (this.mFilterComponentList.getSelectedIndex() >= 0) {
            FilterItem item = this.mFilterComponentList.getSelectedValue();
            this.mRemoveBtn.setEnabled(!item.isAndItem() && !item.isOrItem() && !item.isNotItem() && !item.isOpenBracketItem() && !item.isCloseBracketItem() && !(item.getComponent() instanceof SingleChannelFilterComponent) && !(item.getComponent() instanceof UnknownFilterComponent));
            this.mEditBtn.setEnabled(this.mRemoveBtn.isEnabled() && !(item.getComponent() instanceof AcceptNoneFilterComponent));
            this.mCopyButton.setEnabled(this.mEditBtn.isEnabled());
        } else {
            this.mEditBtn.setEnabled(false);
            this.mRemoveBtn.setEnabled(false);
            this.mCopyButton.setEnabled(false);
        }
        if (this.mParent instanceof EditFilterDlg) {
            ((EditFilterDlg)this.mParent).updateBtns();
        }
    }

    JList<FilterItem> getList() {
        return this.mFilterComponentList;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.mNewBtn) {
            EditFilterComponentDlg dlg = new EditFilterComponentDlg(this.mParent);
            FilterComponent rule = dlg.getFilterComponent();
            if (rule != null) {
                this.mFilterComponentListModel.addElement(new FilterItem(rule, 0));
                FilterComponentList.getInstance().add(rule);
                if (this.mParent instanceof EditFilterDlg) {
                    Object text = this.mFilterRuleTF.getText();
                    if (((String)text).length() > 0) {
                        text = (String)text + " " + EditFilterDlg.FILTER_LOCALIZER.msg("or", "or") + " ";
                    }
                    text = (String)text + rule.getName();
                    this.mFilterRuleTF.setText((String)text);
                    ((EditFilterDlg)this.mParent).fillFilterConstruction();
                }
            }
        } else if (o == this.mCopyButton) {
            this.copySelectedFilterComponent();
        } else if (o == this.mEditBtn) {
            this.editSelectedFilterComponent();
        } else if (o == this.mFilterComponentList) {
            this.updateBtns();
        } else if (o == this.mRemoveBtn) {
            FilterComponent fc;
            UserFilter[] userFilterArr;
            boolean allowRemove;
            block18: {
                allowRemove = true;
                userFilterArr = FilterList.getInstance().getUserFilterArr();
                fc = this.mFilterComponentListModel.getElementAt(this.mFilterComponentList.getSelectedIndex()).getComponent();
                if (this.mParent instanceof EditFilterDlg) {
                    String name = ((EditFilterDlg)this.mParent).getFilterName();
                    UserFilter testFilter = new UserFilter("test");
                    try {
                        testFilter.setRule(this.mFilterRuleTF.getText());
                        if (testFilter.containsRuleComponent(fc.getName())) {
                            allowRemove = false;
                            JOptionPane.showMessageDialog(this, EditFilterDlg.LOCALIZER.msg("usedByAnotherFilter", "This filter component is used by filter '{0}'\nRemove the filter first.", name));
                        }
                    }
                    catch (Exception ex) {
                        if (this.mFilter == null || !this.mFilter.containsRuleComponent(fc.getName())) break block18;
                        allowRemove = false;
                        JOptionPane.showMessageDialog(this, EditFilterDlg.LOCALIZER.msg("usedByAnotherFilter", "This filter component is used by filter '{0}'\nRemove the filter first.", name));
                    }
                }
            }
            for (int i = 0; i < userFilterArr.length && allowRemove; ++i) {
                if (userFilterArr[i] == this.mFilter || !userFilterArr[i].containsRuleComponent(fc.getName())) continue;
                allowRemove = false;
                JOptionPane.showMessageDialog(this, EditFilterDlg.LOCALIZER.msg("usedByAnotherFilter", "This filter component is used by filter '{0}'\nRemove the filter first.", userFilterArr[i].toString()));
            }
            if (allowRemove) {
                FilterComponentList.getInstance().remove(fc.getName());
                this.mFilterComponentListModel.removeElementAt(this.mFilterComponentList.getSelectedIndex());
                this.updateBtns();
            }
        }
    }

    private void copySelectedFilterComponent() {
        int inx = this.mFilterComponentList.getSelectedIndex();
        if (inx == -1) {
            return;
        }
        FilterComponent rule = this.mFilterComponentListModel.getElementAt(inx).getComponent();
        String name = rule.getName();
        int count = name.lastIndexOf("_");
        if (count != -1) {
            try {
                count = Integer.parseInt(name.substring(count + 1)) + 1;
                name = name.substring(0, name.lastIndexOf("_"));
            }
            catch (NumberFormatException nfe) {
                count = 1;
            }
        } else {
            count = 1;
        }
        while (FilterComponentList.getInstance().exists(name + "_" + count)) {
            ++count;
        }
        rule = FilterComponentList.getInstance().createCopy(rule, name + "_" + count);
        EditFilterComponentDlg dlg = null;
        dlg = new EditFilterComponentDlg(this.mParent, rule);
        FilterComponent newRule = dlg.getFilterComponent();
        dlg.dispose();
        if (newRule != null) {
            this.mFilterComponentTouched = true;
            FilterComponentList.getInstance().add(newRule);
            this.mFilterComponentListModel.addElement(new FilterItem(newRule, 0));
            if (this.mParent instanceof EditFilterDlg) {
                ((EditFilterDlg)this.mParent).repaintFilterConstruction();
            }
        }
        this.updateBtns();
    }

    private void editSelectedFilterComponent() {
        new Thread("EDIT FILTER COMPONENT THREAD"){

            @Override
            public void run() {
                int inx = FilterComponentPanel.this.mFilterComponentList.getSelectedIndex();
                if (inx == -1) {
                    return;
                }
                FilterComponent rule = FilterComponentPanel.this.mFilterComponentListModel.getElementAt(inx).getComponent();
                String oldName = rule.getName();
                FilterComponentPanel.this.mFilterComponentListModel.removeElementAt(inx);
                EditFilterComponentDlg dlg = null;
                FilterComponent newRule = rule;
                FilterComponentList.getInstance().remove(oldName);
                dlg = new EditFilterComponentDlg(FilterComponentPanel.this.mParent, rule);
                if (dlg.getOkWasPressed()) {
                    FilterComponentPanel.this.mFilterComponentTouched = true;
                    newRule = dlg.getFilterComponent();
                    if (newRule == null) {
                        newRule = rule;
                    }
                    dlg.dispose();
                    FilterComponentList.getInstance().add(newRule);
                    FilterTreeModel.getInstance().updateFilterComponent(oldName, newRule);
                    if (FilterComponentPanel.this.mParent instanceof EditFilterDlg) {
                        if (!oldName.equalsIgnoreCase(newRule.getName())) {
                            String[] parts = FilterComponentPanel.this.mFilterRuleTF.getText().split("\\s+");
                            StringBuilder newRuleText = new StringBuilder();
                            for (int i = 0; i < parts.length; ++i) {
                                if (parts[i].equals(oldName)) {
                                    parts[i] = newRule.getName();
                                }
                                if (newRuleText.length() > 0) {
                                    newRuleText.append(" ");
                                }
                                newRuleText.append(parts[i]);
                            }
                            FilterComponentPanel.this.mFilterRuleTF.setText(newRuleText.toString());
                        }
                        ((EditFilterDlg)FilterComponentPanel.this.mParent).repaintFilterConstruction();
                    }
                } else {
                    FilterComponentList.getInstance().add(rule);
                }
                FilterComponentPanel.this.mFilterComponentListModel.insertElementAt(new FilterItem(newRule, 0), inx);
                FilterComponentPanel.this.mFilterComponentList.setSelectedIndex(inx);
                FilterComponentPanel.this.mFilterComponentList.ensureIndexIsVisible(inx);
                FilterComponentPanel.this.updateBtns();
            }
        }.start();
    }

    public boolean getFilterComponentWasTouched() {
        return this.mFilterComponentTouched;
    }
}

