/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.programinfo;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Program;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import tvbrowser.core.Settings;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.extras.programinfo.ProgramInfoDialog;
import util.io.IOUtilities;
import util.ui.ObjectSelectionButton;
import util.ui.ObjectSelectionListener;
import util.ui.TVBrowserIcons;

public class ProgramInfoToolBar
extends JPanel
implements ObjectSelectionListener<Program> {
    private JButton mHistPrevious;
    private JButton mHistNext;
    private JButton mPrevious;
    private JButton mNext;
    private JLabel mCurrent;
    private ObjectSelectionButton<Program> mPreviousSelection;
    private ObjectSelectionButton<Program> mNextSelection;

    public ProgramInfoToolBar() {
        this.setLayout((LayoutManager)new FormLayout("0dlu,default,3dlu,default,10dlu,default:grow,0dlu", "default,3dlu"));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.getComponent() instanceof JButton) {
                    ((JButton)e.getComponent()).setContentAreaFilled(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getComponent() instanceof JButton && e.getComponent().isEnabled()) {
                    ((JButton)e.getComponent()).setContentAreaFilled(true);
                }
            }
        };
        this.mCurrent = new JLabel(){

            @Override
            public void paintComponent(Graphics g) {
                ProgramInfoToolBar.this.paintProgress(ProgramInfoDialog.getCurrentProgram(), this, g);
                super.paintComponent(g);
            }
        };
        this.mCurrent.setHorizontalTextPosition(0);
        this.mCurrent.setHorizontalAlignment(0);
        this.mCurrent.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, UIManager.getColor("TextField.foreground")));
        this.mHistPrevious = new JButton(TVBrowserIcons.left(16));
        this.mHistPrevious.setEnabled(false);
        this.mHistPrevious.addActionListener(e -> ProgramInfo.getInstance().historyBack());
        this.mHistNext = new JButton(TVBrowserIcons.right(16));
        this.mHistNext.setEnabled(false);
        this.mHistNext.addActionListener(e -> ProgramInfo.getInstance().historyForward());
        this.mPreviousSelection = new ObjectSelectionButton(null, TVBrowserIcons.left(16));
        this.mPreviousSelection.addProgramSelectionListener(this);
        this.mPreviousSelection.setEnabled(false);
        this.mPreviousSelection.setContentAreaFilled(false);
        this.mPreviousSelection.setBorder(BorderFactory.createEmptyBorder());
        this.mPreviousSelection.setOpaque(false);
        this.mPreviousSelection.addMouseListener(mouseAdapter);
        this.mNextSelection = new ObjectSelectionButton(null, TVBrowserIcons.right(16));
        this.mNextSelection.addProgramSelectionListener(this);
        this.mNextSelection.setEnabled(false);
        this.mNextSelection.setContentAreaFilled(false);
        this.mNextSelection.setBorder(BorderFactory.createEmptyBorder());
        this.mNextSelection.setOpaque(false);
        this.mNextSelection.addMouseListener(mouseAdapter);
        this.mPrevious = new JButton(){

            @Override
            public void paintComponent(Graphics g) {
                Program[] previous = ProgramInfo.getInstance().getPreviousPrograms();
                if (previous != null && previous.length > 0) {
                    ProgramInfoToolBar.this.paintProgress(previous[0], this, g);
                }
                super.paintComponent(g);
            }
        };
        this.mPrevious.setForeground(UIManager.getColor("TextField.foreground"));
        this.mPrevious.setContentAreaFilled(false);
        this.mPrevious.setBorder(BorderFactory.createEmptyBorder());
        this.mPrevious.setOpaque(false);
        this.mPrevious.addMouseListener(mouseAdapter);
        this.mPrevious.addActionListener(e -> ProgramInfo.getInstance().previousProgram());
        this.mNext = new JButton(){

            @Override
            public void paintComponent(Graphics g) {
                Program[] next = ProgramInfo.getInstance().getNextPrograms();
                if (next != null && next.length > 0) {
                    ProgramInfoToolBar.this.paintProgress(next[0], this, g);
                }
                super.paintComponent(g);
            }
        };
        this.mNext.setForeground(UIManager.getColor("TextField.foreground"));
        this.mNext.setContentAreaFilled(false);
        this.mNext.setBorder(BorderFactory.createEmptyBorder());
        this.mNext.setOpaque(false);
        this.mNext.addMouseListener(mouseAdapter);
        this.mNext.addActionListener(e -> ProgramInfo.getInstance().nextProgram());
        CellConstraints cc = new CellConstraints();
        JPanel selection = new JPanel((LayoutManager)new FormLayout("default,1dlu,100dlu,1dlu,100dlu:grow,1dlu,100dlu,1dlu,default", "default"));
        selection.setBackground(UIManager.getColor("TextField.background"));
        selection.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        selection.add(this.mPreviousSelection, cc.xy(1, 1));
        selection.add((Component)this.mPrevious, cc.xy(3, 1));
        selection.add((Component)this.mCurrent, cc.xy(5, 1));
        selection.add((Component)this.mNext, cc.xy(7, 1));
        selection.add(this.mNextSelection, cc.xy(9, 1));
        this.add((Component)this.mHistPrevious, cc.xy(2, 1));
        this.add((Component)this.mHistNext, cc.xy(4, 1));
        this.add((Component)selection, cc.xy(6, 1));
    }

    @Override
    public void objectSeleted(Program prog) {
        ProgramInfo.getInstance().showProgram(prog);
    }

    public void update() {
        Program current = ProgramInfoDialog.getCurrentProgram();
        Program[] previous = ProgramInfo.getInstance().getPreviousPrograms();
        Program[] next = ProgramInfo.getInstance().getNextPrograms();
        if (current != null) {
            this.mCurrent.setText(current.getTitle());
            if (current.isExpired()) {
                this.mCurrent.setForeground(Color.lightGray);
            } else {
                this.mCurrent.setForeground(UIManager.getColor("TextField.foreground"));
            }
        }
        if (previous != null && previous.length > 0) {
            this.mPrevious.setText(previous[0].getTitle());
            if (previous[0].isExpired()) {
                this.mPrevious.setForeground(Color.lightGray);
            } else {
                this.mPrevious.setForeground(UIManager.getColor("TextField.foreground"));
            }
        } else {
            this.mPrevious.setText("");
        }
        if (next != null && next.length > 0) {
            this.mNext.setText(next[0].getTitle());
            if (next[0].isExpired()) {
                this.mNext.setForeground(Color.lightGray);
            } else {
                this.mNext.setForeground(UIManager.getColor("TextField.foreground"));
            }
        } else {
            this.mNext.setText("");
        }
        this.mHistPrevious.setEnabled(ProgramInfo.getInstance().canNavigateBack());
        this.mHistPrevious.setToolTipText(ProgramInfo.getInstance().navigationBackwardText());
        this.mHistNext.setEnabled(ProgramInfo.getInstance().canNavigateForward());
        this.mHistNext.setToolTipText(ProgramInfo.getInstance().navigationForwardText());
        this.mPreviousSelection.setEnabled(previous != null && previous.length > 0);
        this.mPreviousSelection.setObjectArr((Program[])previous);
        this.mPrevious.setEnabled(previous != null && previous.length > 0);
        this.mNext.setEnabled(next != null && next.length > 0);
        this.mNextSelection.setEnabled(next != null && next.length > 0);
        this.mNextSelection.setObjectArr((Program[])next);
        this.updateUI();
    }

    private void paintProgress(Program program, JComponent component, Graphics g) {
        if (program.isOnAir()) {
            g.setColor(Color.white);
            g.fillRect(0, 1, component.getWidth(), component.getHeight() - 2);
            int runTime = IOUtilities.getMinutesAfterMidnight() - program.getStartTime();
            if (runTime < 0) {
                runTime += 1440;
            }
            int progressX = (int)((double)component.getWidth() / (double)program.getLength() * (double)runTime);
            g.setColor(Settings.ProgramPanel.COLOR_ON_AIR_DARK.getColor());
            g.fillRect(0, 1, progressX, component.getHeight() - 2);
            g.setColor(Settings.ProgramPanel.COLOR_ON_AIR_LIGHT.getColor());
            g.fillRect(0 + progressX, 1, component.getWidth() - progressX, component.getHeight() - 2);
            component.setForeground(Color.black);
        }
    }
}

