/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.core;

import devplugin.Date;
import devplugin.Program;
import devplugin.ProgramFieldType;
import java.awt.GridLayout;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tvbrowser.extras.favoritesplugin.FavoriteConfigurator;
import tvbrowser.extras.favoritesplugin.core.ActorSearcher;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.ui.SearchFormSettings;

public class ActorsFavorite
extends Favorite {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ActorsFavorite.class);
    public static final String TYPE_ID = "actors";
    private String mActors;

    public ActorsFavorite(String actors) {
        actors = actors.trim();
        this.setName(actors);
        this.mSearchFormSettings = this.createSearchFormSettings(actors);
    }

    public ActorsFavorite(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super(in);
        in.readInt();
        String actors = (String)in.readObject();
        this.mSearchFormSettings = this.createSearchFormSettings(actors);
    }

    private SearchFormSettings createSearchFormSettings(String actors) {
        this.mActors = actors;
        SearchFormSettings formSettings = new SearchFormSettings("");
        formSettings.setSearchIn(3);
        formSettings.setSearcherType(4);
        formSettings.setUserDefinedFieldTypes(new ProgramFieldType[]{ProgramFieldType.ACTOR_LIST_TYPE, ProgramFieldType.DESCRIPTION_TYPE, ProgramFieldType.SHORT_DESCRIPTION_TYPE});
        return formSettings;
    }

    @Override
    public String getTypeID() {
        return TYPE_ID;
    }

    @Override
    protected void internalWriteData(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.mActors);
    }

    @Override
    protected Program[] internalSearchForPrograms() throws TvBrowserException {
        SearchFormSettings searchForm = this.mSearchFormSettings;
        ProgramFieldType[] fields = searchForm.getFieldTypes();
        ActorSearcher searcher = this.getSearcher();
        Program[] foundPrograms = searcher.search(fields, new Date().addDays(-1), 1000, this.getChannels(), false);
        return foundPrograms;
    }

    @Override
    public boolean matches(Program p) throws TvBrowserException {
        SearchFormSettings searchForm = this.mSearchFormSettings;
        ProgramFieldType[] fields = searchForm.getFieldTypes();
        return this.getSearcher().matches(p, fields);
    }

    @Override
    public ActorSearcher getSearcher() throws TvBrowserException {
        return new ActorSearcher(this.mActors);
    }

    @Override
    public FavoriteConfigurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public boolean isValidSearch() {
        return true;
    }

    @Override
    public String getTypeName() {
        return LOCALIZER.msg("typeName", "Actors Favorite");
    }

    class Configurator
    implements FavoriteConfigurator {
        private JTextField mSearchTextTf;

        public Configurator() {
            this.mSearchTextTf = new JTextField(ActorsFavorite.this.mActors);
        }

        @Override
        public JPanel createConfigurationPanel() {
            JPanel panel = new JPanel(new GridLayout(-1, 1));
            panel.add(new JLabel(LOCALIZER.msg("actors-favorite.term", "Any program containing all of theses actors will be marked as a favorite:")));
            panel.add(this.mSearchTextTf);
            return panel;
        }

        @Override
        public void save() {
            String actors = this.mSearchTextTf.getText();
            ActorsFavorite.this.mSearchFormSettings = ActorsFavorite.this.createSearchFormSettings(actors);
        }

        @Override
        public boolean check() {
            if (this.mSearchTextTf.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this.mSearchTextTf, LOCALIZER.msg("missingActor.message", "Please specify an actor for the favorite!"), LOCALIZER.msg("missingActor.title", "Invalid options"), 2);
                return false;
            }
            return true;
        }
    }
}

