/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ReminderConfiguration {
    public static final String REMINDER_DEFAULT = "window";
    public static final String REMINDER_EMAIL = "email-reminder";
    public static final String REMINDER_INSTANT_MESSAGE = "email-reminder";
    private String[] mServiceIDs;

    public ReminderConfiguration(String[] ids) {
        this.mServiceIDs = ids;
    }

    public ReminderConfiguration() {
        this.mServiceIDs = new String[]{REMINDER_DEFAULT};
    }

    public ReminderConfiguration(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.readInt();
        int cnt = in.readInt();
        this.mServiceIDs = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.mServiceIDs[i] = (String)in.readObject();
        }
    }

    public void store(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.mServiceIDs.length);
        for (String mServiceID : this.mServiceIDs) {
            out.writeObject(mServiceID);
        }
    }

    public String[] getReminderServices() {
        return this.mServiceIDs;
    }

    public void setReminderServices(String[] ids) {
        this.mServiceIDs = ids;
    }

    public boolean containsService(String service) {
        for (String mServiceID : this.mServiceIDs) {
            if (!service.equals(mServiceID)) continue;
            return true;
        }
        return false;
    }
}

