/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters;

import devplugin.Channel;
import devplugin.Program;
import devplugin.ProgramFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class SingleChannelFilter
implements ProgramFilter {
    private Channel mChannel;

    public SingleChannelFilter(Channel channel) {
        this.mChannel = channel;
    }

    @Override
    public boolean accept(Program program) {
        if (this.mChannel != null) {
            return program.getChannel().equals(this.mChannel);
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.mChannel != null) {
            return this.mChannel.getName() + "*";
        }
        return "[INVALID]";
    }

    public void store(String id, ObjectOutputStream out) throws IOException {
        if (this.mChannel != null) {
            out.writeUTF(id);
            this.mChannel.writeData(out);
        }
    }

    public boolean isValidChannel() {
        return this.mChannel != null;
    }

    public boolean containsChannel(Channel ch) {
        return this.mChannel != null && this.mChannel.equals(ch);
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

