/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters;

import devplugin.Channel;
import devplugin.PluginAccess;
import devplugin.PluginsFilterComponent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.ChannelFilterList;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.filters.filtercomponents.AcceptNoneFilterComponent;
import tvbrowser.core.filters.filtercomponents.ChannelFilterComponent;
import tvbrowser.core.filters.filtercomponents.FavoritesFilterComponent;
import tvbrowser.core.filters.filtercomponents.PluginFilterComponent;
import tvbrowser.core.filters.filtercomponents.ReminderFilterComponent;
import tvbrowser.core.filters.filtercomponents.SingleChannelFilterComponent;
import tvbrowser.core.filters.filtercomponents.UnknownFilterComponent;
import tvbrowser.core.plugin.PluginManagerImpl;
import util.io.stream.ObjectInputStreamProcessor;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;

public class FilterComponentList {
    private static FilterComponentList mInstance;
    private static ArrayList<FilterComponent> mComponentList;
    private static final Logger LOG;
    private static final int TYPE_BROKEN_FILTER_COMPONENT_NONE = 0;
    private static final int TYPE_BROKEN_FILTER_COMPONENT_PARTLY = 1;
    private static final int TYPE_BROKEN_FILTER_COMPONENT_COMPLETELY = 2;

    private FilterComponentList() {
        mComponentList = new ArrayList();
        File filterCompFile = new File(FilterList.FILTER_DIRECTORY, "filter.comp");
        if (filterCompFile.exists() && filterCompFile.isFile()) {
            StreamUtilities.objectInputStreamIgnoringExceptions(filterCompFile, 4096, new ObjectInputStreamProcessor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void process(ObjectInputStream in) throws IOException {
                    int version = in.readInt();
                    int compCnt = in.readInt();
                    for (int i = 0; i < compCnt; ++i) {
                        if (version == 1) {
                            FilterComponent comp = null;
                            try {
                                comp = FilterComponentList.this.readComponent(in);
                            }
                            catch (IOException e) {
                                LOG.log(Level.WARNING, "error reading filter component: ", e);
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                            if (comp == null || comp instanceof AcceptNoneFilterComponent) continue;
                            ArrayList<FilterComponent> e = mComponentList;
                            synchronized (e) {
                                mComponentList.add(comp);
                                continue;
                            }
                        }
                        if (version != 2) continue;
                        String key = in.readUTF();
                        File componentFile = new File(FilterList.FILTER_DIRECTORY, "java." + key + ".dat");
                        StreamUtilities.objectInputStreamIgnoringExceptions(componentFile, 4096, new ObjectInputStreamProcessor(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void process(ObjectInputStream inputStream) throws IOException {
                                inputStream.readInt();
                                int size = inputStream.readInt();
                                for (int j = 0; j < size; ++j) {
                                    FilterComponent comp = null;
                                    try {
                                        comp = FilterComponentList.this.readComponent(inputStream);
                                    }
                                    catch (IOException e) {
                                        LOG.log(Level.WARNING, "error reading filter component: ", e);
                                    }
                                    catch (ClassNotFoundException e) {
                                        e.printStackTrace();
                                    }
                                    if (comp == null || comp instanceof AcceptNoneFilterComponent) continue;
                                    ArrayList<FilterComponent> arrayList = mComponentList;
                                    synchronized (arrayList) {
                                        mComponentList.add(comp);
                                        continue;
                                    }
                                }
                            }
                        });
                    }
                    in.close();
                }
            });
        }
    }

    public ArrayList<SingleChannelFilterComponent> updateChannels(Channel[] channels) {
        ArrayList<SingleChannelFilterComponent> toRemove = new ArrayList<SingleChannelFilterComponent>();
        ArrayList<Channel> toAdd = new ArrayList<Channel>();
        toAdd.addAll(Arrays.asList(channels));
        ArrayList<String> acceptNoneFilterComponentNames = new ArrayList<String>();
        ArrayList<SingleChannelFilterComponent> chammelNameUpdateList = new ArrayList<SingleChannelFilterComponent>();
        for (FilterComponent test : mComponentList) {
            if (test instanceof SingleChannelFilterComponent) {
                boolean found = false;
                for (Channel ch : channels) {
                    if (!((SingleChannelFilterComponent)test).containsChannel(ch)) continue;
                    toAdd.remove(ch);
                    found = true;
                    break;
                }
                if (!found) {
                    toRemove.add((SingleChannelFilterComponent)test);
                    continue;
                }
                if (!((SingleChannelFilterComponent)test).isNameToUpdate()) continue;
                chammelNameUpdateList.add((SingleChannelFilterComponent)test);
                continue;
            }
            if (!(test instanceof AcceptNoneFilterComponent)) continue;
            acceptNoneFilterComponentNames.add(test.getName());
        }
        for (SingleChannelFilterComponent remove : toRemove) {
            mComponentList.remove(remove);
        }
        for (Channel ch : toAdd) {
            SingleChannelFilterComponent test = new SingleChannelFilterComponent(ch);
            if (acceptNoneFilterComponentNames.contains(test.getName())) {
                this.remove(test.getName());
            }
            mComponentList.add(test);
        }
        return chammelNameUpdateList;
    }

    public void store() {
        final HashMap<String, ArrayList<FilterComponent>> filterTable = new HashMap<String, ArrayList<FilterComponent>>();
        for (FilterComponent component : mComponentList) {
            String key = component.getClass().getCanonicalName();
            if (component instanceof UnknownFilterComponent) {
                key = ((UnknownFilterComponent)component).getClassName();
            } else if (component instanceof AcceptNoneFilterComponent) continue;
            ArrayList<FilterComponent> componentList = (ArrayList<FilterComponent>)filterTable.get(key);
            if (componentList == null) {
                componentList = new ArrayList<FilterComponent>();
                filterTable.put(key, componentList);
            }
            componentList.add(component);
        }
        File filterCompFile = new File(FilterList.FILTER_DIRECTORY, "filter.comp");
        StreamUtilities.objectOutputStreamIgnoringExceptions(filterCompFile, new ObjectOutputStreamProcessor(){

            @Override
            public void process(ObjectOutputStream out) throws IOException {
                out.writeInt(2);
                out.writeInt(filterTable.size());
                Set filterKeys = filterTable.keySet();
                for (String key : filterKeys) {
                    final ArrayList list = (ArrayList)filterTable.get(key);
                    out.writeUTF(key);
                    File componentFile = new File(FilterList.FILTER_DIRECTORY, "java." + key + ".dat");
                    if (list.get(0) instanceof UnknownFilterComponent) continue;
                    StreamUtilities.objectOutputStreamIgnoringExceptions(componentFile, new ObjectOutputStreamProcessor(){

                        @Override
                        public void process(ObjectOutputStream outputStream) throws IOException {
                            outputStream.writeInt(1);
                            outputStream.writeInt(list.size());
                            for (FilterComponent comp : list) {
                                FilterComponentList.this.writeComponent(outputStream, comp);
                            }
                            outputStream.close();
                        }
                    });
                }
                out.close();
            }
        });
    }

    private void writeComponent(ObjectOutputStream out, FilterComponent comp) throws IOException {
        out.writeObject(comp.getClass().getName());
        out.writeInt(comp.getVersion());
        out.writeObject(comp.getName());
        out.writeObject(comp.getDescription());
        comp.write(out);
    }

    public FilterComponent createCopy(FilterComponent source, String nameNew) {
        FilterComponent copy;
        block21: {
            copy = null;
            try {
                byte[] outArr = null;
                try (ByteArrayOutputStream tempOut = new ByteArrayOutputStream();){
                    try (ObjectOutputStream out = new ObjectOutputStream(tempOut);){
                        this.writeComponent(out, source);
                    }
                    tempOut.flush();
                    outArr = tempOut.toByteArray();
                }
                if (outArr == null) break block21;
                try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(outArr));){
                    copy = this.readComponent(in);
                    copy.setName(nameNew);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return copy;
    }

    private FilterComponent loadComponent(String className, String name, String description) {
        FilterComponent filterComponent = null;
        if (className.startsWith("tvbrowser.core.filters.filtercomponents")) {
            try {
                Class<?> filterComponentClass = Class.forName(className);
                Constructor<?> constructor = filterComponentClass.getConstructor(String.class, String.class);
                filterComponent = (FilterComponent)constructor.newInstance(name, description);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.log(Level.WARNING, "Filter component class '" + className + "' could not be instantiated.");
                filterComponent = new UnknownFilterComponent(name, description, className);
            }
        } else {
            try {
                PluginAccess[] plugins;
                block4: for (PluginAccess plugin : plugins = PluginManagerImpl.getInstance().getActivatedPlugins()) {
                    Class<? extends PluginsFilterComponent>[] clazzes = plugin.getAvailableFilterComponentClasses();
                    if (clazzes == null) continue;
                    for (Class<? extends PluginsFilterComponent> clazz : clazzes) {
                        if (clazz.getName().compareTo(className) != 0) continue;
                        filterComponent = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        continue block4;
                    }
                }
                filterComponent.setName(name);
                filterComponent.setDescription(description);
            }
            catch (Exception e) {
                LOG.warning("error reading filter component: " + className + " unknown");
                return null;
            }
        }
        return filterComponent;
    }

    private FilterComponent readComponent(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String description;
        String className = (String)in.readObject();
        int version = in.readInt();
        String name = (String)in.readObject();
        FilterComponent filterComponent = this.loadComponent(className, name, description = (String)in.readObject());
        if (filterComponent != null) {
            filterComponent.read(in, version);
            if (filterComponent instanceof PluginFilterComponent) {
                String pluginId = ((PluginFilterComponent)filterComponent).getPluginId();
                if (pluginId.compareTo("java.reminderplugin.ReminderPlugin") == 0) {
                    filterComponent = new ReminderFilterComponent(name, description);
                } else if (pluginId.compareTo("java.favoritesplugin.FavoritesPlugin") == 0) {
                    filterComponent = new FavoritesFilterComponent(name, description);
                }
            }
        } else {
            filterComponent = new UnknownFilterComponent(name, description, className);
        }
        return filterComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterComponent[] getAvailableFilterComponents() {
        ArrayList<FilterComponent> arrayList = mComponentList;
        synchronized (arrayList) {
            return mComponentList.toArray(new FilterComponent[mComponentList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterComponent getFilterComponentByName(String name) {
        ArrayList<FilterComponent> arrayList = mComponentList;
        synchronized (arrayList) {
            for (FilterComponent c : mComponentList) {
                if (c.getName().compareTo(name) != 0) continue;
                return c;
            }
        }
        return null;
    }

    public static synchronized FilterComponentList getInstance() {
        if (mInstance == null) {
            mInstance = new FilterComponentList();
            Settings.updateChannelFilters(ChannelList.getSubscribedChannels(), false);
        }
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(FilterComponent comp) {
        ArrayList<FilterComponent> arrayList = mComponentList;
        synchronized (arrayList) {
            String name = comp.getName();
            for (int i = 0; i < mComponentList.size(); ++i) {
                if (!name.equals(mComponentList.get(i).getName()) || !(mComponentList.get(i) instanceof AcceptNoneFilterComponent)) continue;
                mComponentList.remove(i);
                break;
            }
            mComponentList.add(comp);
        }
        this.store();
        if (comp instanceof ChannelFilterComponent) {
            ChannelFilterList.getInstance().fireChannelFilterAdded((ChannelFilterComponent)comp);
        }
    }

    public boolean exists(String name) {
        FilterComponent c = this.getFilterComponentByName(name);
        return c != null && !(c instanceof AcceptNoneFilterComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String filterCompName) {
        FilterComponent filterComp = this.getFilterComponentByName(filterCompName);
        ArrayList<FilterComponent> arrayList = mComponentList;
        synchronized (arrayList) {
            if (mComponentList.remove(filterComp)) {
                String key;
                File componentFile;
                if (filterComp instanceof ChannelFilterComponent) {
                    ChannelFilterList.getInstance().fireChannelFilterRemoved((ChannelFilterComponent)filterComp);
                }
                if ((componentFile = new File(FilterList.FILTER_DIRECTORY, "java." + (key = filterComp.getClass().getCanonicalName()) + ".dat")).isFile() && !componentFile.delete()) {
                    componentFile.deleteOnExit();
                }
            }
        }
        this.store();
    }

    public String[] getChannelFilterNames() {
        ArrayList<String> channelFilters = new ArrayList<String>();
        for (FilterComponent component : this.getAvailableFilterComponents()) {
            if (!(component instanceof ChannelFilterComponent)) continue;
            channelFilters.add(component.getName());
        }
        Object[] sortedArray = new String[channelFilters.size()];
        channelFilters.toArray(sortedArray);
        Arrays.sort(sortedArray);
        return sortedArray;
    }

    public static final String getLabelForComponent(FilterComponent component, String label) {
        int type;
        String result = component != null && label == null ? component.getName() : (label != null ? label : null);
        int n = type = component instanceof AcceptNoneFilterComponent ? 2 : 0;
        if (type == 0) {
            try {
                Method isBrokenCompletely = component.getClass().getMethod("isBrokenCompletely", new Class[0]);
                Object brokenResult = isBrokenCompletely.invoke((Object)component, new Object[0]);
                if (brokenResult instanceof Boolean && ((Boolean)brokenResult).booleanValue()) {
                    type = 2;
                } else {
                    Method isBrokenPartially = component.getClass().getMethod("isBrokenPartially", new Class[0]);
                    brokenResult = isBrokenPartially.invoke((Object)component, new Object[0]);
                    if (brokenResult instanceof Boolean && ((Boolean)brokenResult).booleanValue()) {
                        type = 1;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        switch (type) {
            case 2: {
                result = UserFilter.getLabelForBrokenCompletely(result);
                break;
            }
            case 1: {
                result = UserFilter.getLabelForBrokenPartially(result);
            }
        }
        return result;
    }

    static {
        LOG = Logger.getLogger(FilterComponentList.class.getName());
    }
}

