/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.jar.JarEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.posix.FileStat;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.JRubyNonExistentFile;
import org.jruby.util.JarCache;
import org.jruby.util.JarDirectoryResource;
import org.jruby.util.JarFileResource;
import org.jruby.util.JarFileStat;

abstract class JarResource
implements FileResource {
    private static Pattern PREFIX_MATCH = Pattern.compile("^(?:jar:)?(?:file:)?(.*)$");
    private static final JarCache jarCache = new JarCache();
    private final String jarPrefix;
    private final JarFileStat fileStat;

    public static JarResource create(String pathname2) {
        if (!pathname2.contains("!")) {
            return null;
        }
        Matcher matcher = PREFIX_MATCH.matcher(pathname2);
        String sanitized = matcher.matches() ? matcher.group(1) : pathname2;
        try {
            sanitized = URLDecoder.decode(sanitized, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("hmm - system does not know UTF-8 string encoding :(");
        }
        int bang = sanitized.indexOf(33);
        String jarPath = sanitized.substring(0, bang);
        String entryPath = sanitized.substring(bang + 1);
        JarResource resource2 = JarResource.createJarResource(jarPath, entryPath, false);
        if (resource2 == null && entryPath.startsWith("/")) {
            resource2 = JarResource.createJarResource(jarPath, entryPath.substring(1), true);
        }
        return resource2;
    }

    private static JarResource createJarResource(String jarPath, String entryPath, boolean rootSlashPrefix) {
        JarCache.JarIndex index2 = jarCache.getIndex(jarPath);
        if (index2 == null) {
            return null;
        }
        String[] entries2 = index2.getDirEntries(entryPath);
        if (entries2 != null) {
            return new JarDirectoryResource(jarPath, rootSlashPrefix, entryPath, entries2);
        }
        JarEntry jarEntry = index2.getJarEntry(entryPath);
        if (jarEntry != null) {
            return new JarFileResource(jarPath, rootSlashPrefix, index2, jarEntry);
        }
        return null;
    }

    protected JarResource(String jarPath, boolean rootSlashPrefix) {
        this.jarPrefix = rootSlashPrefix ? jarPath + "!/" : jarPath + "!";
        this.fileStat = new JarFileStat(this);
    }

    @Override
    public String absolutePath() {
        return this.jarPrefix + this.entryName();
    }

    @Override
    public String canonicalPath() {
        return this.absolutePath();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean isSymLink() {
        return false;
    }

    @Override
    public FileStat stat() {
        return this.fileStat;
    }

    @Override
    public FileStat lstat() {
        return this.stat();
    }

    @Override
    public JRubyFile hackyGetJRubyFile() {
        return JRubyNonExistentFile.NOT_EXIST;
    }

    protected abstract String entryName();
}

