/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.ruby20;

import org.jruby.RubyHash;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.operands.Variable;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveKeywordRestArgInstr
extends ReceiveArgBase {
    public final int numUsedArgs;

    public ReceiveKeywordRestArgInstr(Variable result2, int numUsedArgs) {
        super(Operation.RECV_KW_REST_ARG, result2, -1);
        this.numUsedArgs = numUsedArgs;
    }

    @Override
    public String toString() {
        return (this.isDead() ? "[DEAD]" : "") + (this.hasUnusedResult() ? "[DEAD-RESULT]" : "") + this.getResult() + " = " + (Object)((Object)this.getOperation()) + "(" + this.numUsedArgs + ")";
    }

    public Object receiveKWArg(ThreadContext context, int kwArgHashCount, IRubyObject[] args2) {
        if (kwArgHashCount == 0) {
            return RubyHash.newSmallHash(context.getRuntime());
        }
        if (this.numUsedArgs == args2.length) {
            Arity.raiseArgumentError(context.getRuntime(), args2.length - 1, this.numUsedArgs, -1);
        }
        return args2[args2.length - 1];
    }
}

