/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

@JRubyClass(name={"Bignum"}, parent="Integer")
public class RubyBignum
extends RubyInteger {
    private static final int BIT_SIZE = 64;
    private static final long MAX = Long.MAX_VALUE;
    public static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger ULONG_MAX = BigInteger.valueOf(1L).shiftLeft(64).subtract(BigInteger.valueOf(1L));
    private final BigInteger value;

    public static RubyClass createBignumClass(Ruby runtime) {
        RubyClass bignum = runtime.defineClass("Bignum", runtime.getInteger(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setBignum(bignum);
        bignum.index = 2;
        bignum.setReifiedClass(RubyBignum.class);
        bignum.defineAnnotatedMethods(RubyBignum.class);
        return bignum;
    }

    public RubyBignum(Ruby runtime, BigInteger value2) {
        super(runtime, runtime.getBignum());
        this.value = value2;
    }

    @Override
    public int getNativeTypeIndex() {
        return 2;
    }

    @Override
    public Class<?> getJavaClass() {
        return BigInteger.class;
    }

    public static RubyBignum newBignum(Ruby runtime, long value2) {
        return RubyBignum.newBignum(runtime, BigInteger.valueOf(value2));
    }

    public static RubyBignum newBignum(Ruby runtime, double value2) {
        return RubyBignum.newBignum(runtime, new BigDecimal(value2).toBigInteger());
    }

    public static RubyBignum newBignum(Ruby runtime, BigInteger value2) {
        return new RubyBignum(runtime, value2);
    }

    public static RubyBignum newBignum(Ruby runtime, String value2) {
        return new RubyBignum(runtime, new BigInteger(value2));
    }

    @Override
    public double getDoubleValue() {
        return RubyBignum.big2dbl(this);
    }

    @Override
    public long getLongValue() {
        return RubyBignum.big2long(this);
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.value;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public static RubyInteger bignorm(Ruby runtime, BigInteger bi) {
        if (bi.compareTo(LONG_MIN) < 0 || bi.compareTo(LONG_MAX) > 0) {
            return RubyBignum.newBignum(runtime, bi);
        }
        return runtime.newFixnum(bi.longValue());
    }

    public static long big2long(RubyBignum value2) {
        BigInteger big = value2.getValue();
        if (big.compareTo(LONG_MIN) < 0 || big.compareTo(LONG_MAX) > 0) {
            throw value2.getRuntime().newRangeError("bignum too big to convert into `long'");
        }
        return big.longValue();
    }

    public static long big2ulong(RubyBignum value2) {
        BigInteger big = value2.getValue();
        if (big.compareTo(LONG_MIN) <= 0 || big.compareTo(ULONG_MAX) > 0) {
            throw value2.getRuntime().newRangeError("bignum too big to convert into `ulong'");
        }
        return value2.getValue().longValue();
    }

    public static double big2dbl(RubyBignum value2) {
        BigInteger big = value2.getValue();
        double dbl = RubyBignum.convertToDouble(big);
        if (dbl == Double.NEGATIVE_INFINITY || dbl == Double.POSITIVE_INFINITY) {
            value2.getRuntime().getWarnings().warn(IRubyWarnings.ID.BIGNUM_FROM_FLOAT_RANGE, "Bignum out of Float range");
        }
        return dbl;
    }

    private IRubyObject checkShiftDown(RubyBignum other) {
        if (other.value.signum() == 0) {
            return RubyFixnum.zero(this.getRuntime());
        }
        if (this.value.compareTo(LONG_MIN) < 0 || this.value.compareTo(LONG_MAX) > 0) {
            return other.value.signum() >= 0 ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.minus_one(this.getRuntime());
        }
        return this.getRuntime().getNil();
    }

    static double convertToDouble(BigInteger bigint) {
        long signum = bigint.signum() == -1 ? Long.MIN_VALUE : 0L;
        int len = (bigint = bigint.abs()).bitLength();
        if (len == 0) {
            return 0.0;
        }
        long exp2 = len + 1022;
        long frac2 = 0L;
        if (exp2 > 2047L) {
            exp2 = 2047L;
        } else {
            frac2 = bigint.shiftRight(len - 54).longValue() + 1L >> 1;
            if (frac2 == 0x20000000000000L && ++exp2 > 2047L) {
                exp2 = 2047L;
            }
        }
        return Double.longBitsToDouble(signum | exp2 << 52 | frac2 & 0xFFFFFFFFFFFFFL);
    }

    public static BigInteger fix2big(RubyFixnum arg2) {
        return RubyBignum.long2big(arg2.getLongValue());
    }

    public static BigInteger long2big(long arg2) {
        return BigInteger.valueOf(arg2);
    }

    public IRubyObject to_s(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.to_s();
            }
            case 1: {
                return this.to_s(args2[0]);
            }
        }
        throw this.getRuntime().newArgumentError(args2.length, 1);
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        int base = 10;
        return RubyString.newUSASCIIString(this.getRuntime(), this.getValue().toString(base));
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(IRubyObject arg0) {
        int base = RubyBignum.num2int(arg0);
        if (base < 2 || base > 36) {
            throw this.getRuntime().newArgumentError("illegal radix " + base);
        }
        return RubyString.newUSASCIIString(this.getRuntime(), this.getValue().toString(base));
    }

    @Override
    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.getRuntime().newArray((IRubyObject)RubyBignum.newBignum(this.getRuntime(), ((RubyFixnum)other).getLongValue()), (IRubyObject)this);
        }
        if (other instanceof RubyBignum) {
            return this.getRuntime().newArray((IRubyObject)RubyBignum.newBignum(this.getRuntime(), ((RubyBignum)other).getValue()), (IRubyObject)this);
        }
        throw this.getRuntime().newTypeError("Can't coerce " + other.getMetaClass().getName() + " to Bignum");
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        return RubyBignum.bignorm(this.getRuntime(), this.value.negate());
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.addFixnum(((RubyFixnum)other).getLongValue());
        }
        if (other instanceof RubyBignum) {
            return this.addBignum(((RubyBignum)other).value);
        }
        if (other instanceof RubyFloat) {
            return this.addFloat((RubyFloat)other);
        }
        return this.addOther(context, other);
    }

    public IRubyObject op_plus(ThreadContext context, long other) {
        return this.addFixnum(other);
    }

    private IRubyObject addFixnum(long other) {
        BigInteger result2 = this.value.add(BigInteger.valueOf(other));
        if (other > 0L && this.value.signum() > 0) {
            return new RubyBignum(this.getRuntime(), result2);
        }
        return RubyBignum.bignorm(this.getRuntime(), result2);
    }

    private IRubyObject addBignum(BigInteger other) {
        BigInteger result2 = this.value.add(other);
        if (this.value.signum() > 0 && other.signum() > 0) {
            return new RubyBignum(this.getRuntime(), result2);
        }
        return RubyBignum.bignorm(this.getRuntime(), result2);
    }

    private IRubyObject addFloat(RubyFloat other) {
        return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) + other.getDoubleValue());
    }

    private IRubyObject addOther(ThreadContext context, IRubyObject other) {
        return this.coerceBin(context, "+", other);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.subtractFixnum(((RubyFixnum)other).getLongValue());
        }
        if (other instanceof RubyBignum) {
            return this.subtractBignum(((RubyBignum)other).value);
        }
        if (other instanceof RubyFloat) {
            return this.subtractFloat((RubyFloat)other);
        }
        return this.subtractOther(context, other);
    }

    public IRubyObject op_minus(ThreadContext context, long other) {
        return this.subtractFixnum(other);
    }

    private IRubyObject subtractFixnum(long other) {
        BigInteger result2 = this.value.subtract(BigInteger.valueOf(other));
        if (this.value.signum() < 0 && other > 0L) {
            return new RubyBignum(this.getRuntime(), result2);
        }
        return RubyBignum.bignorm(this.getRuntime(), result2);
    }

    private IRubyObject subtractBignum(BigInteger other) {
        BigInteger result2 = this.value.subtract(other);
        if (this.value.signum() < 0 && other.signum() > 0) {
            return new RubyBignum(this.getRuntime(), result2);
        }
        return RubyBignum.bignorm(this.getRuntime(), result2);
    }

    private IRubyObject subtractFloat(RubyFloat other) {
        return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) - other.getDoubleValue());
    }

    private IRubyObject subtractOther(ThreadContext context, IRubyObject other) {
        return this.coerceBin(context, "-", other);
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (other instanceof RubyFixnum) {
            BigInteger result2 = this.value.multiply(RubyBignum.fix2big((RubyFixnum)other));
            return result2.signum() == 0 ? RubyFixnum.zero(runtime) : new RubyBignum(runtime, result2);
        }
        if (other instanceof RubyBignum) {
            BigInteger result3 = this.value.multiply(((RubyBignum)other).value);
            return result3.signum() == 0 ? RubyFixnum.zero(runtime) : new RubyBignum(runtime, result3);
        }
        return this.opMulOther(context, other);
    }

    @JRubyMethod(name={"*"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_mul19(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (other instanceof RubyFixnum) {
            return RubyBignum.bignorm(runtime, this.value.multiply(RubyBignum.fix2big((RubyFixnum)other)));
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.bignorm(runtime, this.value.multiply(((RubyBignum)other).value));
        }
        return this.opMulOther(context, other);
    }

    public IRubyObject op_mul(ThreadContext context, long other) {
        Ruby runtime = context.runtime;
        BigInteger result2 = this.value.multiply(RubyBignum.long2big(other));
        return result2.signum() == 0 ? RubyFixnum.zero(runtime) : new RubyBignum(runtime, result2);
    }

    public IRubyObject opMulOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) * ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin(context, "*", other);
    }

    private IRubyObject op_divide(ThreadContext context, IRubyObject other, boolean slash) {
        BigInteger[] results;
        BigInteger otherValue;
        Ruby runtime = context.runtime;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            if (other instanceof RubyFloat) {
                double otherFloatValue = ((RubyFloat)other).getDoubleValue();
                if (runtime.is1_9() && !slash && otherFloatValue == 0.0) {
                    throw runtime.newZeroDivisionError();
                }
                double div2 = RubyBignum.big2dbl(this) / otherFloatValue;
                if (slash) {
                    return RubyFloat.newFloat(runtime, div2);
                }
                return RubyNumeric.dbl2num(runtime, div2);
            }
            return this.coerceBin(context, slash ? "/" : "div", other);
        }
        if (otherValue.signum() == 0) {
            throw runtime.newZeroDivisionError();
        }
        BigInteger result2 = this.value.signum() * otherValue.signum() == -1 ? ((results = this.value.divideAndRemainder(otherValue))[1].signum() != 0 ? results[0].subtract(BigInteger.ONE) : results[0]) : this.value.divide(otherValue);
        return RubyBignum.bignorm(this.getRuntime(), result2);
    }

    @JRubyMethod(name={"/"}, required=1)
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        return this.op_divide(context, other, true);
    }

    @JRubyMethod(name={"div"}, required=1)
    public IRubyObject op_idiv(ThreadContext context, IRubyObject other) {
        return this.op_divide(context, other, false);
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        BigInteger otherValue;
        Ruby runtime = context.runtime;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            return this.coerceBin(context, "divmod", other);
        }
        if (otherValue.signum() == 0) {
            throw runtime.newZeroDivisionError();
        }
        BigInteger[] results = this.value.divideAndRemainder(otherValue);
        if (this.value.signum() * otherValue.signum() == -1 && results[1].signum() != 0) {
            results[0] = results[0].subtract(BigInteger.ONE);
            results[1] = otherValue.add(results[1]);
        }
        return RubyArray.newArray(runtime, RubyBignum.bignorm(runtime, results[0]), RubyBignum.bignorm(runtime, results[1]));
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject divmod19(ThreadContext context, IRubyObject other) {
        if (!other.isNil() && other instanceof RubyFloat && ((RubyFloat)other).getDoubleValue() == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.divmod(context, other);
    }

    @JRubyMethod(name={"%", "modulo"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            return this.coerceBin(context, "%", other);
        }
        Ruby runtime = context.runtime;
        if (otherValue.signum() == 0) {
            throw runtime.newZeroDivisionError();
        }
        BigInteger result2 = this.value.mod(otherValue.abs());
        if (otherValue.signum() == -1 && result2.signum() != 0) {
            result2 = otherValue.add(result2);
        }
        return RubyBignum.bignorm(runtime, result2);
    }

    @JRubyMethod(name={"%", "modulo"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_mod19(ThreadContext context, IRubyObject other) {
        if (!other.isNil() && other instanceof RubyFloat && ((RubyFloat)other).getDoubleValue() == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.op_mod(context, other);
    }

    @Override
    @JRubyMethod(name={"remainder"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject remainder(ThreadContext context, IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            return this.coerceBin(context, "remainder", other);
        }
        Ruby runtime = context.runtime;
        if (otherValue.signum() == 0) {
            throw runtime.newZeroDivisionError();
        }
        return RubyBignum.bignorm(runtime, this.value.remainder(otherValue));
    }

    @JRubyMethod(name={"remainder"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject remainder19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFloat && ((RubyFloat)other).getDoubleValue() == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.remainder(context, other);
    }

    @Override
    @JRubyMethod(name={"quo"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject quo(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) / ((RubyNumeric)other).getDoubleValue());
        }
        return this.coerceBin(context, "quo", other);
    }

    @JRubyMethod(name={"quo"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject quo19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyInteger && ((RubyInteger)other).getDoubleValue() == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.quo(context, other);
    }

    @JRubyMethod(name={"**", "power"}, required=1)
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        double d;
        if (other instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)other;
            long fixValue = fix2.getLongValue();
            return this.op_pow(context, fixValue);
        }
        if (other instanceof RubyBignum) {
            d = ((RubyBignum)other).getDoubleValue();
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.MAY_BE_TOO_BIG, "in a**b, b may be too big");
        } else if (other instanceof RubyFloat) {
            d = ((RubyFloat)other).getDoubleValue();
        } else {
            return this.coerceBin(context, "**", other);
        }
        return RubyFloat.newFloat(this.getRuntime(), Math.pow(RubyBignum.big2dbl(this), d));
    }

    public IRubyObject op_pow(ThreadContext context, long other) {
        if ((long)((this.value.bitLength() + 7) / 8 * 4) * Math.abs(other) > 0x100000L) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.MAY_BE_TOO_BIG, "in a**b, b may be too big");
        }
        if (other >= 0L) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.pow((int)other));
        }
        return RubyFloat.newFloat(this.getRuntime(), Math.pow(RubyBignum.big2dbl(this), other));
    }

    @JRubyMethod(name={"**", "power"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_pow19(ThreadContext context, IRubyObject other) {
        double d;
        Ruby runtime = context.runtime;
        if (other == RubyFixnum.zero(runtime)) {
            return RubyFixnum.one(runtime);
        }
        if (other instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)other;
            long fixValue = fix2.getLongValue();
            if (fixValue < 0L) {
                return RubyRational.newRationalRaw(runtime, this).callMethod(context, "**", other);
            }
            if ((long)((this.value.bitLength() + 7) / 8 * 4) * Math.abs(fixValue) > 0x100000L) {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.MAY_BE_TOO_BIG, "in a**b, b may be too big");
            }
            if (fixValue >= 0L) {
                return RubyBignum.bignorm(runtime, this.value.pow((int)fixValue));
            }
            return RubyFloat.newFloat(runtime, Math.pow(RubyBignum.big2dbl(this), fixValue));
        }
        if (other instanceof RubyBignum) {
            d = ((RubyBignum)other).getDoubleValue();
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.MAY_BE_TOO_BIG, "in a**b, b may be too big");
        } else if (other instanceof RubyFloat) {
            d = ((RubyFloat)other).getDoubleValue();
            if (this.compareTo(RubyFixnum.zero(runtime)) == -1 && d != (double)Math.round(d)) {
                return RubyComplex.newComplexRaw(this.getRuntime(), this).callMethod(context, "**", other);
            }
        } else {
            return this.coerceBin(context, "**", other);
        }
        double pow = Math.pow(RubyBignum.big2dbl(this), d);
        if (Double.isInfinite(pow)) {
            return RubyFloat.newFloat(runtime, pow);
        }
        return RubyNumeric.dbl2num(runtime, pow);
    }

    @JRubyMethod(name={"&"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_and(ThreadContext context, IRubyObject other) {
        if ((other = other.convertToInteger()) instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.and(((RubyBignum)other).value));
        }
        if (other instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.and(RubyBignum.fix2big((RubyFixnum)other)));
        }
        return this.coerceBin(context, "&", other);
    }

    @JRubyMethod(name={"&"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_and19(ThreadContext context, IRubyObject other) {
        return this.op_and(context, this.convertToInteger(context, other));
    }

    @JRubyMethod(name={"|"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_or(ThreadContext context, IRubyObject other) {
        if ((other = other.convertToInteger()) instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.or(((RubyBignum)other).value));
        }
        if (other instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.or(RubyBignum.fix2big((RubyFixnum)other)));
        }
        return this.coerceBin(context, "|", other);
    }

    @JRubyMethod(name={"|"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_or19(ThreadContext context, IRubyObject other) {
        return this.op_or(context, this.convertToInteger(context, other));
    }

    @JRubyMethod(name={"^"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_xor(ThreadContext context, IRubyObject other) {
        if ((other = other.convertToInteger()) instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.xor(((RubyBignum)other).value));
        }
        if (other instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.xor(BigInteger.valueOf(((RubyFixnum)other).getLongValue())));
        }
        return this.coerceBin(context, "^", other);
    }

    @JRubyMethod(name={"^"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_xor19(ThreadContext context, IRubyObject other) {
        return this.op_xor(context, this.convertToInteger(context, other));
    }

    private IRubyObject convertToInteger(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFloat) {
            throw context.runtime.newTypeError("can't convert Float into Integer");
        }
        return other.convertToInteger();
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_neg() {
        return RubyBignum.newBignum(this.getRuntime(), this.value.not());
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject op_lshift(IRubyObject other) {
        long shift2;
        boolean neg = false;
        while (true) {
            if (other instanceof RubyFixnum) {
                shift2 = ((RubyFixnum)other).getLongValue();
                if (shift2 >= 0L) break;
                neg = true;
                shift2 = -shift2;
                break;
            }
            if (other instanceof RubyBignum) {
                RubyBignum otherBignum = (RubyBignum)other;
                if (otherBignum.value.signum() < 0) {
                    IRubyObject tmp = otherBignum.checkShiftDown(this);
                    if (!tmp.isNil()) {
                        return tmp;
                    }
                    neg = true;
                }
                shift2 = RubyBignum.big2long(otherBignum);
                break;
            }
            other = other.convertToInteger();
        }
        return RubyBignum.bignorm(this.getRuntime(), neg ? this.value.shiftRight((int)shift2) : this.value.shiftLeft((int)shift2));
    }

    @JRubyMethod(name={">>"}, required=1)
    public IRubyObject op_rshift(IRubyObject other) {
        long shift2;
        boolean neg = false;
        while (true) {
            if (other instanceof RubyFixnum) {
                shift2 = ((RubyFixnum)other).getLongValue();
                if (shift2 >= 0L) break;
                neg = true;
                shift2 = -shift2;
                break;
            }
            if (other instanceof RubyBignum) {
                RubyBignum otherBignum = (RubyBignum)other;
                if (otherBignum.value.signum() >= 0) {
                    IRubyObject tmp = otherBignum.checkShiftDown(this);
                    if (!tmp.isNil()) {
                        return tmp;
                    }
                } else {
                    neg = true;
                }
                shift2 = RubyBignum.big2long(otherBignum);
                break;
            }
            other = other.convertToInteger();
        }
        return RubyBignum.bignorm(this.getRuntime(), neg ? this.value.shiftLeft((int)shift2) : this.value.shiftRight((int)shift2));
    }

    @JRubyMethod(name={"[]"}, required=1)
    public RubyFixnum op_aref(IRubyObject other) {
        if (other instanceof RubyBignum && (other = RubyBignum.bignorm(this.getRuntime(), ((RubyBignum)other).value)) instanceof RubyBignum) {
            if (((RubyBignum)other).value.signum() >= 0 != (this.value.signum() == -1)) {
                return RubyFixnum.zero(this.getRuntime());
            }
            return RubyFixnum.one(this.getRuntime());
        }
        long position = RubyBignum.num2long(other);
        if (position < 0L || position > Integer.MAX_VALUE) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.value.testBit((int)position) ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.zero(this.getRuntime());
    }

    @Override
    public final int compareTo(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return this.value.compareTo(((RubyBignum)other).value);
        }
        return (int)this.coerceCmp(this.getRuntime().getCurrentContext(), "<=>", other).convertToInteger().getLongValue();
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            if (other instanceof RubyFloat) {
                RubyFloat flt = (RubyFloat)other;
                if (flt.infinite_p().isTrue()) {
                    if (flt.getDoubleValue() > 0.0) {
                        return RubyFixnum.minus_one(this.getRuntime());
                    }
                    return RubyFixnum.one(this.getRuntime());
                }
                return RubyBignum.dbl_cmp(this.getRuntime(), RubyBignum.big2dbl(this), flt.getDoubleValue());
            }
            return this.coerceCmp(context, "<=>", other);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value.compareTo(otherValue));
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            if (other instanceof RubyFloat) {
                double a = ((RubyFloat)other).getDoubleValue();
                if (Double.isNaN(a)) {
                    return this.getRuntime().getFalse();
                }
                return RubyBoolean.newBoolean(this.getRuntime(), a == RubyBignum.big2dbl(this));
            }
            return other.op_eqq(this.getRuntime().getCurrentContext(), this);
        }
        return RubyBoolean.newBoolean(this.getRuntime(), this.value.compareTo(otherValue) == 0);
    }

    @Override
    @JRubyMethod(name={"eql?", "==="}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return this.value.compareTo(((RubyBignum)other).value) == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"==="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject eql_p19(IRubyObject other) {
        return this.op_equal(other);
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        return RubyBignum.newBignum(this.getRuntime(), this.value.abs());
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum((this.value.bitLength() + 7) / 8);
    }

    public static void marshalTo(RubyBignum bignum, MarshalStream output) throws IOException {
        output.registerLinkTarget(bignum);
        output.write(bignum.value.signum() >= 0 ? 43 : 45);
        BigInteger absValue = bignum.value.abs();
        byte[] digits = absValue.toByteArray();
        boolean oddLengthNonzeroStart = digits.length % 2 != 0 && digits[0] != 0;
        int shortLength = digits.length / 2;
        if (oddLengthNonzeroStart) {
            ++shortLength;
        }
        output.writeInt(shortLength);
        for (int i2 = 1; i2 <= shortLength * 2 && i2 <= digits.length; ++i2) {
            output.write(digits[digits.length - i2]);
        }
        if (oddLengthNonzeroStart) {
            output.write(0);
        }
    }

    public static RubyNumeric unmarshalFrom(UnmarshalStream input) throws IOException {
        boolean positive = input.readUnsignedByte() == 43;
        int shortLength = input.unmarshalInt();
        byte[] digits = new byte[shortLength * 2 + 1];
        for (int i2 = digits.length - 1; i2 >= 1; --i2) {
            digits[i2] = input.readSignedByte();
        }
        BigInteger value2 = new BigInteger(digits);
        if (!positive) {
            value2 = value2.negate();
        }
        RubyInteger result2 = RubyBignum.bignorm(input.getRuntime(), value2);
        input.registerLinkTarget(result2);
        return result2;
    }
}

