/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.AtomicVertex;
import classycle.graph.LongestWalkProcessor;
import classycle.graph.StrongComponent;
import classycle.graph.StrongComponentProcessor;
import classycle.graph.Vertex;
import java.util.HashMap;
import java.util.Map;

public class StrongComponentAnalyser {
    private final AtomicVertex[] _graph;
    private StrongComponent[] _components;
    private HashMap _layerMap;

    public StrongComponentAnalyser(AtomicVertex[] graph) {
        this._graph = graph;
    }

    public AtomicVertex[] getGraph() {
        return this._graph;
    }

    public StrongComponent[] getCondensedGraph() {
        if (this._components == null) {
            StrongComponentProcessor processor = new StrongComponentProcessor(true);
            processor.deepSearchFirst(this._graph);
            this._components = processor.getStrongComponents();
        }
        return this._components;
    }

    public Map getLayerMap() {
        if (this._layerMap == null) {
            Vertex[] components = this.getCondensedGraph();
            new LongestWalkProcessor().deepSearchFirst(components);
            this._layerMap = new HashMap();
            for (int i = 0; i < components.length; ++i) {
                Vertex component = components[i];
                Integer layer = new Integer(((StrongComponent)component).getLongestWalk());
                int n = ((StrongComponent)component).getNumberOfVertices();
                for (int j = 0; j < n; ++j) {
                    this._layerMap.put(((StrongComponent)component).getVertex(j), layer);
                }
            }
        }
        return this._layerMap;
    }
}

