/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.PackageProcessor;
import classycle.dependency.CyclesResult;
import classycle.dependency.Result;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.Statement;
import classycle.graph.AtomicVertex;
import classycle.graph.NameAttributes;
import classycle.graph.StrongComponent;
import classycle.graph.StrongComponentAnalyser;
import classycle.util.StringPattern;
import java.util.ArrayList;

public class CheckCyclesStatement
implements Statement {
    private final StringPattern _set;
    private final int _maximumSize;
    private final boolean _packageCycles;
    private final SetDefinitionRepository _repository;

    public CheckCyclesStatement(StringPattern set, int size, boolean cycles, SetDefinitionRepository repository) {
        this._set = set;
        this._maximumSize = size;
        this._packageCycles = cycles;
        this._repository = repository;
    }

    public Result execute(AtomicVertex[] graph) {
        ArrayList<AtomicVertex> filteredGraph = new ArrayList<AtomicVertex>();
        for (int i = 0; i < graph.length; ++i) {
            if (!this._set.matches(((NameAttributes)graph[i].getAttributes()).getName())) continue;
            filteredGraph.add(graph[i]);
        }
        graph = filteredGraph.toArray(new AtomicVertex[0]);
        if (this._packageCycles) {
            PackageProcessor processor = new PackageProcessor();
            processor.deepSearchFirst(graph);
            graph = processor.getGraph();
        }
        StrongComponentAnalyser analyser = new StrongComponentAnalyser(graph);
        StrongComponent[] condensedGraph = analyser.getCondensedGraph();
        CyclesResult result = new CyclesResult(this.createStatement(), this._packageCycles);
        for (int i = 0; i < condensedGraph.length; ++i) {
            StrongComponent strongComponent = condensedGraph[i];
            if (strongComponent.getNumberOfVertices() <= this._maximumSize) continue;
            result.addCycle(strongComponent);
        }
        return result;
    }

    public String toString() {
        return this.createStatement();
    }

    private String createStatement() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("check").append(' ');
        if (this._packageCycles) {
            buffer.append("absenceOfPackageCycles");
        } else {
            buffer.append("absenceOfClassCycles");
        }
        buffer.append(" > ").append(this._maximumSize).append(' ');
        buffer.append("in").append(' ');
        buffer.append(this._repository.toString(this._set));
        return new String(buffer);
    }
}

