# 7.2 Changelog

## [7.2.19] - 2024-04-11

### Build and Packaging Improvements

<details>

<summary>

<p>Bump to .NET 6.0.29</p>

</summary>

<ul>
<li>Allow artifacts produced by partially successful builds to be consumed by release pipeline</li>
<li>Update SDK, dependencies and <code>cgmanifest</code> for <code>7.2.19</code></li>
<li>Revert changes to <code>packaging.psm1</code></li>
<li>Verify environment variable for OneBranch before we try to copy (#21441)</li>
<li>Multiple fixes in official build pipeline (#21408)</li>
<li>Add <code>dotenv</code> install as latest version does not work with current Ruby version (#21239)</li>
<li>PowerShell co-ordinated build OneBranch pipeline (#21364)</li>
<li>Remove <code>surrogateFile</code> setting of <code>APIScan</code> (#21238)</li>
</ul>

</details>

[7.2.19]: https://github.com/PowerShell/PowerShell/compare/v7.2.18...v7.2.19

## [7.2.18] - 2024-01-11

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET to 6.0.418</p>

</summary>

<ul>
<li>Update <code>ThirdPartyNotices.txt</code> for v7.2.18 (Internal 29173)</li>
<li>Update <code>cgmanifest.json</code> for v7.2.18 release (Internal 29161)</li>
<li>Update .NET SDK to 6.0.418 (Internal 29141)</li>
<li>Back port 3 build changes to <code>apiscan.yml</code> (#21036)</li>
<li>Set the <code>ollForwardOnNoCandidateFx</code> in <code>runtimeconfig.json</code> to roll forward only on minor and patch versions (#20689)</li>
<li>Remove the <code>ref</code> folder before running compliance (#20373)</li>
<li>Fix the tab completion tests (#20867)</li>
</ul>

</details>

[7.2.18]: https://github.com/PowerShell/PowerShell/compare/v7.2.17...v7.2.18

## [7.2.17] - 2023-11-16

### General Cmdlet Updates and Fixes

- Redact Auth header content from ErrorRecord (Internal 28411)

### Build and Packaging Improvements

<details>

<summary>

<p>Bump to .NET to version 6.0.417</p>

</summary>

<ul>
<li>Bump to .NET 6.0.417 (Internal 28486)</li>
<li>Copy azure blob with PowerShell global tool to private blob and move to CDN during release (Internal 28450)</li>
</ul>

</details>

[7.2.17]: https://github.com/PowerShell/PowerShell/compare/v7.2.16...v7.2.17

## [7.2.16] - 2023-10-26

### Build and Packaging Improvements

<details>

<summary>

<p>Update .NET 6 to version 6.0.416</p>

</summary>

<ul>
<li>Fix release pipeline yaml</li>
<li>Fix issues with merging backports in packaging (Internal 28158)</li>
<li>Update .NET 6 and TPN (Internal 28149)</li>
<li>Add runtime and packaging type info for mariner2 arm64 (#19450) (#20564)</li>
<li>Add mariner arm64 to PMC release (#20176) (#20567)</li>
<li>Remove <code>HostArchitecture</code> dynamic parameter for <code>osxpkg</code> (#19917) (#20565)</li>
<li>Use <code>fxdependent-win-desktop</code> runtime for compliance runs (#20326) (#20568)</li>
<li>Add SBOM for release pipeline (#20519) (#20570)</li>
<li>Increase timeout when publishing packages to <code>pacakages.microsoft.com</code> (#20470) (#20569)</li>
<li>Add mariner arm64 package build to release build (#19946) (#20566)</li>
</ul>

</details>

[7.2.16]: https://github.com/PowerShell/PowerShell/compare/v7.2.15...v7.2.16

## [7.2.15] - 2023-10-10

### Security Fixes

- Block getting help from network locations in restricted remoting sessions (Internal 27699)

### Build and Packaging Improvements

<details>

<summary>

<p>Build infrastructure maintenance</p>

</summary>

<ul>
<li>Release build: Change the names of the PATs (#20315)</li>
<li>Switch to GitHub Action for linting markdown (#20309)</li>
<li>Put the calls to <code>Set-AzDoProjectInfo</code> and Set-AzDoAuthToken` in the right order (#20312)</li>
</ul>

</details>

[7.2.15]: https://github.com/PowerShell/PowerShell/compare/v7.2.14...v7.2.15

## [7.2.14] - 2023-09-18

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET SDK version to 6.0.414</p>

</summary>

<ul>
<li>Update to use .NET SDK 6.0.414 (Internal 27575)</li>
<li>Enable <code>vPack</code> provenance data (#20242)</li>
<li>Start using new packages.microsoft.com CLI (#20241)</li>
<li>Remove spelling CI in favor of GitHub Action (#20239)</li>
<li>Make PR creation tool use <code>--web</code> because it is more reliable (#20238)</li>
<li>Update variable used to bypass the blocking check for multiple NuGet feeds (#20237)</li>
<li>Don't publish notice on failure because it prevents retry (#20236)</li>
<li>Publish rpm package for rhel9 (#20234)</li>
<li>Add <code>ProductCode</code> in registry for MSI install (#20233)</li>
</ul>

</details>

### Documentation and Help Content

- Update man page to match current help for pwsh (#20240)
- Update the link for getting started in `README.md` (#20235)

[7.2.14]: https://github.com/PowerShell/PowerShell/compare/v7.2.13...v7.2.14

## [7.2.13] - 2023-07-13

### Tests

- Increase the timeout to make subsystem tests more reliable (#19937)
- Increase the timeout when waiting for the event log (#19936)

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET SDK version to 6.0.412</p>

</summary>

<ul>
<li>Update Notice file (#19956)</li>
<li>Update cgmanifest (#19938)</li>
<li>Bump to 6.0.412 SDK (#19933)</li>
<li>Update variable used to bypass the blocking check for multiple NuGet feeds (#19935)</li>
</ul>

</details>

[7.2.13]: https://github.com/PowerShell/PowerShell/compare/v7.2.12...v7.2.13

## [7.2.12] - 2023-06-27

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET version to 6.0.411</p>

</summary>

<ul>
<li>Disable SBOM signing for CI and add extra files for packaging tests (#19729)</li>
<li>Update ThirdPartyNotices (Internal 26349)</li>
<li>Update the cgmanifest</li>
<li>Add PoolNames variable group to compliance pipeline (#19408)</li>
<li>Add tool to trigger license information gathering for NuGet modules (#18827)</li>
<li>Update to .NET 6.0.410 (#19798)</li>
<li>Always regenerate files wxs fragment (#19803)</li>
<li>Add prompt to fix conflict during backport (#19583)</li>
<li>Add backport function to release tools (#19568)</li>
<li>Do not remove <code>penimc_cor3.dll</code> from build (#18438)</li>
<li>Remove unnecessary native dependencies from the package (#18213)</li>
<li>Delete symbols on Linux as well (#19735)</li>
<li>Bump <code>Microsoft.PowerShell.MarkdownRender</code> (#19751)</li>
<li>Backport compliance changes  (#19719)</li>
<li>Delete charset regular expression test (#19585)</li>
<li>Fix issue with merge of 19068 (#19586)</li>
<li>Update the team member list in <code>releaseTools.psm1</code> (#19574)</li>
<li>Verify that packages have license data (#19543) (#19575)</li>
<li>Update experimental-feature.json (#19581)</li>
<li>Fix the regular expression used for package name check in <code>vPack</code> build (#19573)</li>
<li>Make the vPack PAT library more obvious (#19572)</li>
<li>Add an explicit manual stage for changelog update (#19551) (#19567)</li>
</ul>

</details>

[7.2.12]: https://github.com/PowerShell/PowerShell/compare/v7.2.11...v7.2.12

## [7.2.11] - 2023-04-12

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET version to 6.0.16</p>

</summary>

<ul>
<li>Update ThirdPartyNotices.txt</li>
<li>Update cgmanifest.json</li>
<li>Fix the template that creates nuget package</li>
<li>Update the wix file</li>
<li>Update .NET SDK to 6.0.408</li>
<li>Fix the build script and signing template</li>
<li>Fix stage dependencies and typo in release build (#19353)</li>
<li>Fix issues in release build and release pipeline (#19338)</li>
<li>Restructure the package build to simplify signing and packaging stages (#19321)</li>
<li>Skip VT100 tests on Windows Server 2012R2 as console does not support it (#19413)</li>
<li>Improve package management acceptance tests by not going to the gallery (#19412)</li>
<li>Test fixes for stabilizing tests (#19068)</li>
<li>Add stage for symbols job in Release build (#18937)</li>
<li>Use reference assemblies generated by dotnet (#19302)</li>
<li>Add URL for all distributions (#19159)</li>
<li>Update release pipeline to use Approvals and automate some manual tasks (#17837)</li>
</ul>

</details>

[7.2.11]: https://github.com/PowerShell/PowerShell/compare/v7.2.10...v7.2.11

## [7.2.10] - 2023-02-23

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET version to 6.0.14</p>

</summary>

<ul>
<li>Fixed package names verification to support multi-digit versions (#17220)</li>
<li>Add pipeline secrets (from #17837) (Internal 24413)</li>
<li>Update to azCopy 10 (#18509)</li>
<li>Update third party notices for v7.2.10 (Internal 24346)</li>
<li>Update cgmanifest for v7.2.10 (Internal 24333)</li>
<li>Pull latest patches for 7.2.10 dependencies (Internal 24325)</li>
<li>Update SDK to 6.0.406 for v7.2.10 (Internal 24324)</li>
<li>Add test for framework dependent package in release pipeline (#18506) (#19114)</li>
<li>Mark 7.2.x releases as latest LTS but not latest stable (#19069)</li>
</ul>

</details>

[7.2.10]: https://github.com/PowerShell/PowerShell/compare/v7.2.9...v7.2.10

## [7.2.9] - 2023-01-24

### Engine Updates and Fixes

- Fix for JEA session leaking functions (Internal 23821 & 23819)

### General Cmdlet Updates and Fixes

- Correct incorrect cmdlet name in script (#18919)

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET version to 6.0.13</p>

</summary>

<ul>
<li>Create test artifacts for windows arm64 (#18932)</li>
<li>Update dependencies for .NET release (Internal 23816)</li>
<li>Don't install based on build-id for RPM (#18921)</li>
<li>Apply expected file permissions to linux files after authenticode signing (#18922)</li>
<li>Add authenticode signing for assemblies on linux builds (#18920)</li>
</ul>

</details>

[7.2.9]: https://github.com/PowerShell/PowerShell/compare/v7.2.8...v7.2.9

## [7.2.8] - 2022-12-13

### Engine Updates and Fixes

- Remove TabExpansion for PSv2 from remote session configuration (Internal 23294)

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET SDK to 6.0.403</p>

</summary>

<ul>
<li>Update CGManifest and ThirdPartyNotices</li>
<li>Update Microsoft.CSharp from 4.3.0 to 4.7.0</li>
<li>Update to latest SDK (#18610)</li>
<li>Allow two-digit revisions in vPack package validation pattern (#18569)</li>
<li>Update outdated dependencies (#18576)</li>
<li>Work around args parsing issue (#18606)</li>
<li>Bump System.Data.SqlClient from 4.8.4 to 4.8.5 (#18515)</li>
</ul>

</details>

[7.2.8]: https://github.com/PowerShell/PowerShell/compare/v7.2.7...v7.2.8

## [7.2.7] - 2022-10-20

### Engine Updates and Fixes

- On Unix, explicitly terminate the native process during cleanup only if it's not running in background (#18280)
- Stop sending telemetry about `ApplicationType` (#18168)

### General Cmdlet Updates and Fixes

- Remove the 1-second minimum delay in `Invoke-WebRequest` for downloading small files, and prevent file-download-error suppression (#18170)
- Enable searching for assemblies in GAC_Arm64 on Windows (#18169)
- Fix error formatting to use color defined in `$PSStyle.Formatting` (#18287)

### Tests

- Use Ubuntu 20.04 for SSH remoting test (#18289)

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET to version 6.0.402 (#18188)(#18290)</p>

</summary>

<ul>
<li>Update cgmanifest (#18319)</li>
<li>Fix <code>build.psm1</code> to find the required .NET SDK version when a higher version is installed (#17299) (#18282)</li>
<li>Update MSI exit message (#18173)</li>
<li>Remove XML files for min-size package (#18274)</li>
<li>Update list of PS team members in release tools (#18171)</li>
<li>Make the link to minimal package blob public during release (#18174)</li>
<li>Add XML reference documents to NuPkg files for SDK (#18172)</li>
<li>Update to use version 2.21.0 of Application Insights (#18271)</li>
</ul>

</details>

[7.2.7]: https://github.com/PowerShell/PowerShell/compare/v7.2.6...v7.2.7

## [7.2.6] - 2022-08-11

### Engine Updates and Fixes

- Fix `ForEach-Object -Parallel` when passing in script block variable (#16564)

### General Cmdlet Updates and Fixes

- Make `Out-String` and `Out-File` keep string input unchanged (#17455)
- Update regular expression used to remove ANSI escape sequences to be more specific to decoration and hyperlinks (#16811)
- Fix legacy `ErrorView` types to use `$host.PrivateData` colors (#17705)
- Fix `Export-PSSession` to not throw error when a rooted path is specified for `-OutputModule` (#17671)

### Tests

- Disable RPM SBOM test. (#17532)

### Build and Packaging Improvements

<details>

<summary>
<p>Bump .NET SDK to 6.0.8 (Internal 22065)</p>
<p>We thank the following contributors!</p>
<p>@tamasvajk</p>
</summary>

<ul>
<li>Update Wix manifest</li>
<li>Add AppX capabilities in MSIX manifest so that PS7 can call the AppX APIs (#17416)</li>
<li>Use <code>Quality</code> only with <code>Channel</code> in <code>dotnet-install</code> (#17847)</li>
<li>Fix <code>build.psm1</code> to not specify both version and quality for <code>dotnet-install</code> (#17589) (Thanks @tamasvajk!)</li>
<li>Install .NET 3.1 as it is required by the vPack task</li>
</ul>

</details>

[7.2.6]: https://github.com/PowerShell/PowerShell/compare/v7.2.5...v7.2.6


## [7.2.5] - 2022-06-21

### Engine Updates and Fixes

- Fix native library loading for osx-arm64 (#17495) (Thanks @awakecoding!)

### Tests

- Make Assembly Load Native test work on a FX Dependent Linux Install (#17496)
- Enable more tests to be run in a container. (#17294)
- Switch to using GitHub action to verify Markdown links for PRs (#17281)
- Try to stabilize a few tests that fail intermittently (#17426)
- TLS test fix back-port (#17424)

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET SDK to 6.0.301 (Internal 21218)</p>

</summary>

<ul>
<li>Update Wix file (Internal 21242)</li>
<li>Conditionally add output argument</li>
<li>Rename mariner package to cm (#17506)</li>
<li>Backport test fixes for 7.2 (#17494)</li>
<li>Update dotnet-runtime version (#17472)</li>
<li>Update to use <code>windows-latest</code> as the build agent image (#17418)</li>
<li>Publish preview versions of mariner to preview repository (#17464)</li>
<li>Move <code>cgmanifest</code> generation to daily (#17258)</li>
<li>Fix mariner mappings (#17413)</li>
<li>Make sure we execute tests on LTS package for older LTS releases (#17430)</li>
<li>Add a finalize template which causes jobs with issues to fail (#17428)</li>
<li>Make mariner packages Framework dependent (#17425)</li>
<li>Base work for adding mariner amd64 package (#17417)</li>
</ul>

</details>

[7.2.5]: https://github.com/PowerShell/PowerShell/compare/v7.2.4...v7.2.5

## [7.2.4] - 2022-05-17

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET SDK to 6.0.203</p>

</summary>

<ul>
<li>Add mapping for Ubuntu22.04 Jammy (#17317)</li>
<li>Update to use <code>mcr.microsoft.com</code> (#17272)</li>
<li>Update third party notices</li>
<li>Update global.json and wix</li>
<li>Put Secure supply chain analysis at correct place (#17273)</li>
<li>Fix web cmdlets so that an empty <code>Get</code> does not include a <code>content-length</code> header (#16587)</li>
<li>Update package fallback list for Ubuntu (from those updated for Ubuntu <code>22.04</code>) (<code>deb</code>) (#17217)</li>
<li>Add <code>sha256</code> digests to RPM packages (#17215)</li>
<li>Allow multiple installations of dotnet. (#17216)</li>
</ul>

</details>

[7.2.4]: https://github.com/PowerShell/PowerShell/compare/v7.2.3...v7.2.4

## [7.2.3] - 2022-04-26

### Engine Updates and Fixes

- Fix for partial PowerShell module search paths, that can be resolved to CWD locations (Internal 20126)
- Do not include node names when sending telemetry. (#16981) to v7.2.3 (Internal 20188)

### Tests

- Re-enable `PowerShellGet` tests targeting PowerShell gallery (#17062)
- Skip failing scriptblock tests (#17093)

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET SDK to 6.0.202</p>

</summary>

<ul>
<li>Making NameObscurerTelemetryInitializer internal - v7.2.3 (Internal 20239)</li>
<li>Updated files.wxs for 7.2.3 (Internal 20211)</li>
<li>Updated ThirdPartyNotices for 7.2.3 (Internal 20199)</li>
<li>Work around issue with notice generation</li>
<li>Replace <code>.</code> in notices container name</li>
<li>Updated cgmanifest.json by findMissingNotices.ps1 in v7.2.3 (Internal 20190)</li>
<li>v7.2.3 - Updated packages using dotnet-outdated global tool (Internal 20170)</li>
<li>Updated to .NET 6.0.4 / SDK 6.0.202 (Internal 20128)</li>
<li>Update dotnet-install script download link (Internal 19951)</li>
<li>Create checksum file for global tools (#17056) (Internal 19935)</li>
<li>Make sure global tool packages are published in stable build (Internal 19625)</li>
<li>Fix release pipeline (Internal 19617)</li>
</ul>

</details>

[7.2.3]: https://github.com/PowerShell/PowerShell/compare/v7.2.2...v7.2.3

## [7.2.2] - 2022-03-16

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET SDK to 6.0.201</p>

</summary>

<ul>
<li>Update WiX file (Internal 19460)</li>
<li>Update .NET SDK version to 6.0.201 (Internal 19457)</li>
<li>Update experimental feature JSON files (#16838)</li>
<li>Ensure Alpine and ARM SKUs have <code>powershell.config.json</code> file with experimental features enabled (#16823)</li>
<li>Update the <code>vmImage</code> and PowerShell root directory for macOS builds (#16611)</li>
<li>Update macOS build image and root folder for build (#16609)</li>
<li>Remove WiX install (#16834)</li>
<li>Opt-in to build security monitoring (#16911)</li>
<li>Add SBOM manifest for release packages (#16641, #16711)</li>
<li>Add Linux package dependencies for packaging (#16807)</li>
<li>Switch to our custom images for build and release (#16801, #16580)</li>
<li>Remove all references to <code>cmake</code> for the builds in this repository (#16578)</li>
<li>Register NuGet source when generating <code>CGManifest</code> (#16570)</li>
</ul>

</details>

[7.2.2]: https://github.com/PowerShell/PowerShell/compare/v7.2.1...v7.2.2

## [7.2.1] - 2021-12-14

### General Cmdlet Updates and Fixes

- Remove declaration of experimental features in Utility module manifest as they are stable (#16460)
- Bring back pwsh.exe for framework dependent packages to support Start-Job (#16535)
- Change default for `$PSStyle.OutputRendering` to `Ansi` (Internal 18394)
- Update `HelpInfoUri` for 7.2 release (#16456)
- Fix typo for "privacy" in MSI installer (#16407)

### Tests

- Set clean state before testing `UseMU` in the MSI (#16543)

### Build and Packaging Improvements

<details>

<ul>
<li>Add explicit job name for approval tasks in Snap stage (#16579)</li>
<li>Fixing the build by removing duplicate TSAUpload entries (Internal 18399)</li>
<li>Port CGManifest fixes (Internal 18402)</li>
<li>Update CGManifest (Internal 18403)</li>
<li>Updated package dependencies for 7.2.1 (Internal 18388)</li>
<li>Use different containers for different branches (#16434)</li>
<li>Use notice task to generate license assuming CGManifest contains all components (#16340)</li>
<li>Create compliance build (#16286)</li>
<li>Update release instructions with link to new build (#16419)</li>
<li>Add diagnostics used to take corrective action when releasing buildInfoJson (#16404)</li>
<li>vPack release should use buildInfoJson new to 7.2 (#16402)</li>
<li>Add checkout to build json stage to get <code>ci.psm1</code> (#16399)</li>
<li>Update the usage of metadata.json for getting LTS information (#16381)</li>
<li>Move mapping file into product repository and add Debian 11 (#16316)</li>
</ul>

</details>

[7.2.1]: https://github.com/PowerShell/PowerShell/compare/v7.2.0...v7.2.1

## [7.2.0] - 2021-11-08

### General Cmdlet Updates and Fixes

- Handle exception when trying to resolve a possible link path (#16310)

### Tests

- Fix global tool and SDK tests in release pipeline (#16342)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@kondratyev-nv</p>

</summary>

<ul>
<li>Add an approval for releasing build-info json (#16351)</li>
<li>Release build info json when it is preview (#16335)</li>
<li>Update <code>metadata.json</code> for v7.2.0 release</li>
<li>Update to the latest notices file and update <code>cgmanifest.json</code> (#16339)(#16325)</li>
<li>Fix issues in release build by updating usage of <code>powershell.exe</code> with <code>pwsh.exe</code> (#16332)</li>
<li>Update feed and analyzer dependency (#16327)</li>
<li>Update to .NET 6 GA build <code>6.0.100-rtm.21527.11</code> (#16309)</li>
<li>Add a major-minor build info JSON file (#16301)</li>
<li>Fix Windows build ZIP packaging (#16299) (Thanks @kondratyev-nv!)</li>
<li>Clean up <code>crossgen</code> related build scripts also generate native symbols for <code>R2R</code> images (#16297)</li>
<li>Fix issues reported by code signing verification tool (#16291)</li>
</ul>

</details>

[7.2.0]: https://github.com/PowerShell/PowerShell/compare/v7.2.0-rc.1...v7.2.0

## [7.2.0-rc.1] - 2021-10-21

### General Cmdlet Updates and Fixes

- Disallow COM calls for AppLocker system lockdown (#16268)
- Configure `Microsoft.ApplicationInsights` to not send cloud role name (#16246)
- Disallow `Add-Type` in NoLanguage mode on a locked down machine (#16245)
- Make property names for color VT100 sequences consistent with documentation (#16212)
- Make moving a directory into itself with `Move-Item` an error (#16198)
- Change `FileSystemInfo.Target` from a `CodeProperty` to an `AliasProperty` that points to `FileSystemInfo.LinkTarget` (#16165)

### Tests

- Removed deprecated docker-based tests for PowerShell release packages (#16224)

### Build and Packaging Improvements

<details>

<summary>
<p>Bump .NET SDK to 6.0.100-rc.2</p>
</summary>

<ul>
<li>Update .NET 6 to version 6.0.100-rc.2.21505.57 (#16249)</li>
<li>Fix RPM packaging (Internal 17704)</li>
<li>Update <code>ThirdPartyNotices.txt</code> (#16283)</li>
<li>Update pipeline yaml file to use <code>ubuntu-latest</code> image (#16279)</li>
<li>Add script to generate <code>cgmanifest.json</code> (#16278)</li>
<li>Update version of <code>Microsoft.PowerShell.Native</code> and <code>Microsoft.PowerShell.MarkdownRender</code> packages (#16277)</li>
<li>Add <code>cgmanifest.json</code> for generating correct third party notice file (#16266)</li>
<li>Only upload stable <code>buildinfo</code> for stable releases (#16251)</li>
<li>Don't upload <code>.dep</code> or <code>.tar.gz</code> for RPM because there are none (#16230)</li>
<li>Ensure RPM license is recognized (#16189)</li>
<li>Add condition to only generate release files in local dev build only (#16259)</li>
<li>Ensure <code>psoptions.json</code> and <code>manifest.spdx.json</code> files always exist in packages (#16258)</li>
<li>Fix CI script and split out ARM runs (#16252)</li>
<li>Update vPack task version to 12 (#16250)</li>
<li>Sign third party executables (#16229)</li>
<li>Add Software Bill of Materials to the main packages (#16202)</li>
<li>Upgrade <code>set-value</code> package for Markdown test (#16196)</li>
<li>Fix Microsoft update spelling issue (#16178)</li>
<li>Move vPack build to 1ES Pool (#16169)</li>
</ul>

</details>

[7.2.0-rc.1]: https://github.com/PowerShell/PowerShell/compare/v7.2.0-preview.10...v7.2.0-rc.1

## [7.2.0-preview.10] - 2021-09-28

### Engine Updates and Fixes

- Remove duplicate remote server mediator code (#16027)

### General Cmdlet Updates and Fixes

- Use `PlainText` when writing to a host that doesn't support VT (#16092)
- Remove support for `AppExecLinks` to retrieve target (#16044)
- Move `GetOuputString()` and `GetFormatStyleString()` to `PSHostUserInterface` as public API (#16075)
- Add `isOutputRedirected` parameter to `GetFormatStyleString()` method (#14397)
- Fix `ConvertTo-SecureString` with key regression due to .NET breaking change (#16068)
- Fix regression in `Move-Item` to only fallback to `CopyAndDelete` in specific cases (#16029)
- Set `$?` correctly for command expression with redirection (#16046)
- Use `CurrentCulture` when handling conversions to `DateTime` in `Add-History` (#16005) (Thanks @vexx32!)
- Fix `NullReferenceException` in `Format-Wide` (#15990) (Thanks @DarylGraves!)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze!</p>

</summary>

<ul>
<li>Improve <code>CommandInvocationIntrinsics</code> API documentation and style (#14369)</li>
<li>Use <code>bool?.GetValueOrDefault()</code> in <code>FormatWideCommand</code> (#15988) (Thanks @xtqqczze!)</li>
</ul>

</details>

### Tools

- Fix typo in build.psm1 (#16038) (Thanks @eltociear!)
- Add `.stylecop` to `filetypexml` and format it (#16025)
- Enable sending Teams notification when workflow fails (#15982)

### Tests

- Enable two previously disabled `Get-Process` tests (#15845) (Thanks @iSazonov!)

### Build and Packaging Improvements

<details>

<summary>
Details
</summary>

<ul>
<li>Add SHA256 hashes to release (#16147)</li>
<li>Update <code>Microsoft.CodeAnalysis.CSharp</code> version (#16138)</li>
<li>Change path for Component Governance for build to the path we actually use to build (#16137)</li>
<li>Bump <code>Microsoft.CodeAnalysis.NetAnalyzers</code> (#16070) (#16045) (#16036) (#16021) (#15985)</li>
<li>Update .NET to <code>6.0.100-rc.1.21458.32</code> (#16066)</li>
<li>Update minimum required OS version for macOS (#16088)</li>
<li>Ensure locale is set correctly on Ubuntu 20.04 in CI (#16067) (#16073)</li>
<li>Update .NET SDK version from <code>6.0.100-preview.6.21355.2</code> to <code>6.0.100-rc.1.21455.2</code> (#16041) (#16028) (#15648)</li>
<li>Fix the GitHub Action for updating .NET daily builds (#16042)</li>
<li>Move from PkgES hosted agents to 1ES hosted agents (#16023)</li>
<li>Update Ubuntu images to use Ubuntu 20.04 (#15906)</li>
<li>Fix the macOS build by updating the pool image name (#16010)</li>
<li>Use Alpine 3.12 for building PowerShell for Alpine Linux (#16008)</li>
<li>Ignore error from <code>Find-Package</code> (#15999)</li>
<li>Find packages separately for each source in <code>UpdateDotnetRuntime.ps1</code> script (#15998)</li>
<li>Update metadata to start using .NET 6 RC1 builds (#15981)</li>
</ul>

</details>

[7.2.0-preview.10]: https://github.com/PowerShell/PowerShell/compare/v7.2.0-preview.9...v7.2.0-preview.10

## [7.2.0-preview.9] - 2021-08-23

### Breaking Changes

- Change the default value of `$PSStyle.OutputRendering` to `OutputRendering.Host` and remove `OutputRendering.Automatic` (#15882)
- Fix `CA1052` for public API to make classes static when they only have static methods (#15775) (Thanks @xtqqczze!)
- Update `pwsh.exe -File` to only accept `.ps1` script files on Windows (#15859)

### Engine Updates and Fixes

- Update .NET adapter to handle interface static members properly (#15908)
- Catch and handle unauthorized access exception when removing AppLocker test files (#15881)

### General Cmdlet Updates and Fixes

- Add `-PassThru` parameter to `Set-Clipboard` (#13713) (Thanks @ThomasNieto!)
- Add `-Encoding` parameter for `Tee-Object` (#12135) (Thanks @Peter-Schneider!)
- Update `ConvertTo-Csv` and `Export-Csv` to handle `IDictionary` objects (#11029) (Thanks @vexx32!)
- Update the parameters `-Exception` and `-ErrorRecord` for `Write-Error` to be position 0 (#13813) (Thanks @ThomasNieto!)
- Don't use `ArgumentList` when creating COM object with `New-Object` as it's not applicable to the COM parameter set (#15915)
- Fix `$PSStyle` list output to correctly show `TableHeader` (#15928)
- Remove the `PSImplicitRemotingBatching` experimental feature (#15863)
- Fix issue with `Get-Process -Module` failing to stop when it's piped to `Select-Object` (#15682) (Thanks @ArmaanMcleod!)
- Make the experimental features `PSUnixFileStat`, `PSCultureInvariantReplaceOperator`, `PSNotApplyErrorActionToStderr`, `PSAnsiRendering`, `PSAnsiProgressFeatureName` stable (#15864)
- Enhance `Remove-Item` to work with OneDrive (#15571) (Thanks @iSazonov!)
- Make global tool entrypoint class static (#15880)
- Update `ServerRemoteHost` version to be same as `PSVersion` (#15809)
- Make the initialization of `HttpKnownHeaderNames` thread safe (#15519) (Thanks @iSazonov!)
- `ConvertTo-Csv`: Quote fields with quotes and newlines when using `-UseQuotes AsNeeded` (#15765) (Thanks @lselden!)
- Forwarding progress stream changes from `Foreach-Object -Parallel` runspaces (#14271) (Thanks @powercode!)
- Add validation to `$PSStyle` to reject printable text when setting a property that only expects ANSI escape sequence (#15825)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze</p>

</summary>

<ul>
<li>Avoid unneeded array allocation in module code (#14329) (Thanks @xtqqczze!)</li>
<li>Enable and fix analysis rules <code>CA1052</code>, <code>CA1067</code>, and <code>IDE0049</code> (#15840) (Thanks @xtqqczze!)</li>
<li>Avoid unnecessary allocation in formatting code (#15832) (Thanks @xtqqczze!)</li>
<li>Specify the analyzed API surface for all code quality rules (#15778) (Thanks @xtqqczze!)</li>
</ul>

</details>

### Tools

- Enable `/rebase` to automatically rebase a PR (#15808)
- Update `.editorconfig` to not replace tabs with spaces in `.tsv` files (#15815) (Thanks @SethFalco!)
- Update PowerShell team members in the changelog generation script (#15817)

### Tests

- Add more tests to validate the current command error handling behaviors (#15919)
- Make `Measure-Object` property test independent of the file system (#15879)
- Add more information when a `syslog` parsing error occurs (#15857)
- Harden logic when looking for `syslog` entries to be sure that we select based on the process ID (#15841)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze</p>

</summary>

<ul>
<li>Disable implicit namespace imports for test projects (#15895)</li>
<li>Update language version to 10 and fix related issues (#15886)</li>
<li>Update <code>CodeQL</code> workflow to use Ubuntu 18.04 (#15868)</li>
<li>Bump the version of various packages (#15944, #15934, #15935, #15891, #15812, #15822) (Thanks @xtqqczze!)</li>
</ul>

</details>

### Documentation and Help Content

- Update `README` and `metadata files` for release `v7.2.0-preview.8` (#15819)
- Update changelogs for 7.0.7 and 7.1.4 (#15921)
- Fix spelling in XML docs (#15939) (Thanks @slowy07!)
- Update PowerShell Committee members (#15837)

[7.2.0-preview.9]: https://github.com/PowerShell/PowerShell/compare/v7.2.0-preview.8...v7.2.0-preview.9

## [7.2.0-preview.8] - 2021-07-22

### Engine Updates and Fixes

- Add a Windows mode to `$PSNativeCommandArgumentPassing` that allows some commands to use legacy argument passing (#15408)
- Use `nameof` to get parameter names when creating `ArgumentNullException` (#15604) (Thanks @gukoff!)
- Test if a command is 'Out-Default' more thoroughly for transcribing scenarios (#15653)
- Add `Microsoft.PowerShell.Crescendo` to telemetry allow list (#15372)

### General Cmdlet Updates and Fixes

- Use `$PSStyle.Formatting.FormatAccent` for `Format-List` and `$PSStyle.Formatting.TableHeader` for `Format-Table` output (#14406)
- Highlight using error color the exception `Message` and underline in `PositionMessage` for `Get-Error` (#15786)
- Implement a completion for View parameter of format cmdlets (#14513) (Thanks @iSazonov!)
- Add support to colorize `FileInfo` filenames (#14403)
- Don't serialize to JSON ETS properties for `DateTime` and `string` types (#15665)
- Fix `HyperVSocketEndPoint.ServiceId` setter (#15704) (Thanks @xtqqczze!)
- Add `DetailedView` to `$ErrorView` (#15609)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@iSazonov, @xtqqczze</p>

</summary>

<ul>
<li>Remove <code>consolehost.proto</code> file (#15741) (Thanks @iSazonov!)</li>
<li>Implement <code>IDisposable</code> for <code>ConvertToJsonCommand</code> (#15787) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDisposable</code> implementation for <code>CommandPathSearch</code> (#15793) (Thanks @xtqqczze!)</li>
<li>Delete IDE dispose analyzer rules (#15798) (Thanks @xtqqczze!)</li>
<li>Seal private classes (#15725) (Thanks @xtqqczze!)</li>
<li>Enable IDE0029: <code>UseCoalesceExpression</code> (#15770) (Thanks @xtqqczze!)</li>
<li>Enable IDE0070: <code>UseSystemHashCode</code> (#15715) (Thanks @xtqqczze!)</li>
<li>Enable IDE0030: <code>UseCoalesceExpressionForNullable</code> (#14289) (Thanks @xtqqczze!)</li>
<li>Fix CA1846 and CA1845 for using <code>AsSpan</code> instead of <code>Substring</code> (#15738)</li>
<li>Use <code>List&lt;T&gt;.RemoveAll</code> to avoid creating temporary list (#15686) (Thanks @xtqqczze!)</li>
<li>Enable IDE0044: <code>MakeFieldReadonly</code> (#13880) (Thanks @xtqqczze!)</li>
<li>Disable IDE0130 (#15728) (Thanks @xtqqczze!)</li>
<li>Make classes sealed (#15675) (Thanks @xtqqczze!)</li>
<li>Enable CA1043: Use integral or string argument for indexers (#14467) (Thanks @xtqqczze!)</li>
<li>Enable CA1812 (#15674) (Thanks @xtqqczze!)</li>
<li>Replace <code>Single</code> with <code>First</code> when we know the element count is 1 (#15676) (Thanks @xtqqczze!)</li>
<li>Skip analyzers for <code>Microsoft.Management.UI.Internal</code> (#15677) (Thanks @xtqqczze!)</li>
<li>Fix CA2243: Attribute string literals should parse correctly (#15622) (Thanks @xtqqczze!)</li>
<li>Enable CA1401 (#15621) (Thanks @xtqqczze!)</li>
<li>Fix CA1309: Use ordinal <code>StringComparison</code> in Certificate Provider (#14352) (Thanks @xtqqczze!)</li>
<li>Fix CA1839: Use <code>Environment.ProcessPath</code> (#15650) (Thanks @xtqqczze!)</li>
<li>Add new analyzer rules (#15620) (Thanks @xtqqczze!)</li>
</ul>

</details>

### Tools

- Add `SkipRoslynAnalyzers` parameter to `Start-PSBuild` (#15640) (Thanks @xtqqczze!)
- Create issue template for issues updating PowerShell through Windows update. (#15700)
- Add `DocumentationAnalyzers` to build (#14336) (Thanks @xtqqczze!)
- Convert GitHub issue templates to modern forms (#15645)

### Tests

- Add more tests for `ConvertFrom-Json` (#15706) (Thanks @strawgate!)
- Update `glob-parent` and `hosted-git-info` test dependencies (#15643)

### Build and Packaging Improvements

<details>

<summary>
Update .NET to version <code>v6.0.0-preview.6</code>
</summary>

<ul>
<li>Add new package name for <code>osx-arm64</code> (#15813)</li>
<li>Prefer version when available for dotnet-install (#15810)</li>
<li>Make warning about MU being required dynamic (#15776)</li>
<li>Add <code>Start-PSBootstrap</code> before running tests (#15804)</li>
<li>Update to .NET 6 Preview 6 and use <code>crossgen2</code> (#15763)</li>
<li>Enable ARM64 packaging for macOS (#15768)</li>
<li>Make Microsoft Update opt-out/in check boxes work (#15784)</li>
<li>Add Microsoft Update opt out to MSI install (#15727)</li>
<li>Bump <code>NJsonSchema</code> from <code>10.4.4</code> to <code>10.4.5</code> (#15769)</li>
<li>Fix computation of SHA512 checksum (#15736)</li>
<li>Update the script to use quality parameter for <code>dotnet-install</code> (#15731)</li>
<li>Generate SHA512 checksum file for all packages (#15678)</li>
<li>Enable signing daily release build with lifetime certificate (#15642)</li>
<li>Update metadata and README for 7.2.0-preview.7 (#15593)</li>
</ul>

</details>

### Documentation and Help Content

- Fix broken RFC links (#15807)
- Add to bug report template getting details from `Get-Error` (#15737)
- Update issue templates to link to new docs (#15711)
- Add @jborean93 to Remoting Working Group (#15683)

[7.2.0-preview.8]: https://github.com/PowerShell/PowerShell/compare/v7.2.0-preview.7...v7.2.0-preview.8

## [7.2.0-preview.7] - 2021-06-17

### Breaking Changes

- Remove PSDesiredStateConfiguration v2.0.5 module and published it to the PowerShell Gallery (#15536)

### Engine Updates and Fixes

- Fix splatting being treated as positional parameter in completions (#14623) (Thanks @MartinGC94!)
- Prevent PowerShell from crashing when a telemetry mutex can't be created (#15574) (Thanks @gukoff!)
- Ignore all exceptions when disposing an instance of a subsystem implementation (#15511)
- Wait for SSH exit when closing remote connection (#14635) (Thanks @dinhngtu!)

### Performance

- Retrieve `ProductVersion` using informational version attribute in `AmsiUtils.Init()` (#15527) (Thanks @Fs00!)

### General Cmdlet Updates and Fixes

- Fix retrieving dynamic parameters from provider even if globbed path returns no results (#15525)
- Revert "Enhance Remove-Item to work with OneDrive (#15260)" due to long path issue (#15546)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@octos4murai, @iSazonov, @Fs00</p>

</summary>

<ul>
<li>Correct parameter name passed to exception in <code>PSCommand</code> constructor (#15580) (Thanks @octos4murai!)</li>
<li>Enable nullable: <code>System.Management.Automation.ICommandRuntime</code> (#15566) (Thanks @iSazonov!)</li>
<li>Clean up code regarding <code>AppDomain.CreateDomain</code> and <code>AppDomain.Unload</code> (#15554)</li>
<li>Replace <code>ProcessModule.FileName</code> with <code>Environment.ProcessPath</code> and remove <code>PSUtils.GetMainModule</code> (#15012) (Thanks @Fs00!)</li>
</ul>

</details>

### Tests

- Fix `Start-Benchmarking` to put `TargetPSVersion` and `TargetFramework` in separate parameter sets (#15508)
- Add `win-x86` test package to the build (#15517)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@schuelermine</p>

</summary>

<ul>
<li>Update README.md and metadata.json for version 7.2.0-preview.6 (#15464)</li>
<li>Make sure GA revision increases from RC and Preview releases (#15558)</li>
<li>Remove <code>SupportsShouldProcess</code> from <code>Start-PSBootstrap</code> in build.psm1 (#15491) (Thanks @schuelermine!)</li>
<li>Update <code>DotnetMetadataRuntime.json</code> next channel to take daily build from .NET preview 5 (#15518)</li>
<li>Fix <code>deps.json</code> update in the release pipeline (#15486)</li>
</ul>

</details>

### Documentation and Help Content

- Add new members to Engine and Cmdlet Working Groups document (#15560)
- Update the `mdspell` command to exclude the folder that should be ignored (#15576)
- Replace 'User Voice' with 'Feedback Hub' in `README.md` (#15557)
- Update Virtual User Group chat links (#15505) (Thanks @Jaykul!)
- Fix typo in `FileSystemProvider.cs` (#15445) (Thanks @eltociear!)
- Add `PipelineStoppedException` notes to PowerShell API (#15324)
- Updated governance on Working Groups (WGs) (#14603)
- Correct and improve XML documentation comments on `PSCommand` (#15568) (Thanks @octos4murai!)

[7.2.0-preview.7]: https://github.com/PowerShell/PowerShell/compare/v7.2.0-preview.6...v7.2.0-preview.7

## [7.2.0-preview.6] - 2021-05-27

### Experimental Features

- [Breaking Change] Update prediction interface to provide additional feedback to a predictor plugin (#15421)

### Performance

- Avoid collecting logs in buffer if a pipeline execution event is not going to be logged (#15350)
- Avoid allocation in `LanguagePrimitives.UpdateTypeConvertFromTypeTable` (#15168) (Thanks @xtqqczze!)
- Replace `Directory.GetDirectories` with `Directory.EnumerateDirectories` to avoid array allocations (#15167) (Thanks @xtqqczze!)
- Use `List.ConvertAll` instead of `LINQ` (#15140) (Thanks @xtqqczze!)

### General Cmdlet Updates and Fixes

- Use `AllocConsole` before initializing CLR to ensure codepage is correct for WinRM remoting (PowerShell/PowerShell-Native#70) (Thanks @jborean93!)
- Add completions for `#requires` statements (#14596) (Thanks @MartinGC94!)
- Add completions for comment-based help keywords (#15337) (Thanks @MartinGC94!)
- Move cross platform DSC code to a PowerShell engine subsystem (#15127)
- Fix `Minimal` progress view to handle activity that is longer than console width (#15264)
- Handle exception if ConsoleHost tries to set cursor out of bounds because screen buffer changed (#15380)
- Fix `NullReferenceException` in DSC `ClearCache()` (#15373)
- Update `ControlSequenceLength` to handle colon as a virtual terminal parameter separator (#14942)
- Update the summary comment for `StopTranscriptCmdlet.cs` (#15349) (Thanks @dbaileyut!)
- Remove the unusable alias `d` for the `-Directory` parameter from `Get-ChildItem` (#15171) (Thanks @kvprasoon!)
- Fix tab completion for un-localized `about` topics (#15265) (Thanks @MartinGC94!)
- Remove the unneeded SSH stdio handle workaround (#15308)
- Add `LoadAssemblyFromNativeMemory` API to load assemblies from memory in a native PowerShell host (#14652) (Thanks @awakecoding!)
- Re-implement `Remove-Item` OneDrive support (#15260) (Thanks @iSazonov!)
- Kill native processes in pipeline when pipeline is disposed on Unix (#15287)
- Default to MTA on Windows platforms where STA is not supported (#15106)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze, @powercode, @bcwood</p>

</summary>

<ul>
<li>Enable <code>nullable</code> in some classes (#14185, #14177, #14159, #14191, #14162, #14150, #14156, #14161, #14155, #14163, #14181, #14157, #14151) (Thanks @powercode!)</li>
<li>Annotate <code>ThrowTerminatingError</code> with <code>DoesNotReturn</code> attribute (#15352) (Thanks @powercode!)</li>
<li>Use <code>GetValueOrDefault()</code> for nullable <code>PSLanguageMode</code> (#13849) (Thanks @bcwood!)</li>
<li>Enable <code>SA1008</code>: Opening parenthesis should be spaced correctly (#14242) (Thanks @xtqqczze!)</li>
</ul>

</details>

### Tools

- Add `winget` release script (#15050)

### Tests

- Enable cross-runtime benchmarking to compare different .NET runtimes (#15387) (Thanks @adamsitnik!)
- Add the performance benchmark project for PowerShell performance testing (#15242)

### Build and Packaging Improvements

<details>

<summary>
Update .NET to version <code>v6.0.0-preview.4</code>
</summary>

<ul>
<li>Suppress prompting when uploading the <code>msixbundle</code> package to blob (#15227)</li>
<li>Update to .NET preview 4 SDK (#15452)</li>
<li>Update <code>AppxManifest.xml</code> with newer OS version to allow PowerShell installed from Windows Store to make system-level changes (#15375)</li>
<li>Ensure the build works when <code>PSDesiredStateConfiguration</code> module is pulled in from PSGallery (#15355)</li>
<li>Make sure daily release tag does not change when retrying failures (#15286)</li>
<li>Improve messages and behavior when there's a problem in finding zip files (#15284)</li>
</ul>

</details>

### Documentation and Help Content

- Add documentation comments section to coding guidelines (#14316) (Thanks @xtqqczze!)

[7.2.0-preview.6]: https://github.com/PowerShell/PowerShell/compare/v7.2.0-preview.5...v7.2.0-preview.6

## [7.2.0-preview.5] - 2021-04-14

### Breaking Changes

- Make PowerShell Linux deb and RPM packages universal (#15109)
- Enforce AppLocker Deny configuration before Execution Policy Bypass configuration (#15035)
- Disallow mixed dash and slash in command-line parameter prefix (#15142) (Thanks @davidBar-On!)

### Experimental Features

- `PSNativeCommandArgumentPassing`: Use `ArgumentList` for native executable invocation (breaking change) (#14692)

### Engine Updates and Fixes

- Add `IArgumentCompleterFactory` for parameterized `ArgumentCompleters` (#12605) (Thanks @powercode!)

### General Cmdlet Updates and Fixes

- Fix SSH remoting connection never finishing with misconfigured endpoint (#15175)
- Respect `TERM` and `NO_COLOR` environment variables for `$PSStyle` rendering (#14969)
- Use `ProgressView.Classic` when Virtual Terminal is not supported (#15048)
- Fix `Get-Counter` issue with `-Computer` parameter (#15166) (Thanks @krishnayalavarthi!)
- Fix redundant iteration while splitting lines (#14851) (Thanks @hez2010!)
- Enhance `Remove-Item -Recurse` to work with OneDrive (#14902) (Thanks @iSazonov!)
- Change minimum depth to 0 for `ConvertTo-Json` (#14830) (Thanks @kvprasoon!)
- Allow `Set-Clipboard` to accept empty string (#14579)
- Turn on and off `DECCKM` to modify keyboard mode for Unix native commands to work correctly (#14943)
- Fall back to `CopyAndDelete()` when `MoveTo()` fails due to an `IOException` (#15077)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze, @iSazonov, @ZhiZe-ZG</p>

</summary>

<ul>
<li>Update .NET to <code>6.0.0-preview.3</code> (#15221)</li>
<li>Add space before comma to hosting test to fix error reported by <code>SA1001</code> (#15224)</li>
<li>Add <code>SecureStringHelper.FromPlainTextString</code> helper method for efficient secure string creation (#14124) (Thanks @xtqqczze!)</li>
<li>Use static lambda keyword (#15154) (Thanks @iSazonov!)</li>
<li>Remove unnecessary <code>Array</code> -&gt; <code>List</code> -&gt; <code>Array</code> conversion in <code>ProcessBaseCommand.AllProcesses</code> (#15052) (Thanks @xtqqczze!)</li>
<li>Standardize grammar comments in Parser.cs (#15114) (Thanks @ZhiZe-ZG!)</li>
<li>Enable <code>SA1001</code>: Commas should be spaced correctly (#14171) (Thanks @xtqqczze!)</li>
<li>Refactor <code>MultipleServiceCommandBase.AllServices</code> (#15053) (Thanks @xtqqczze!)</li>
</ul>

</details>

### Tools

- Use Unix line endings for shell scripts (#15180) (Thanks @xtqqczze!)

### Tests

- Add the missing tag in Host Utilities tests (#14983)
- Update `copy-props` version in `package.json` (#15124)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@JustinGrote</p>

</summary>

<ul>
<li>Fix <code>yarn-lock</code> for <code>copy-props</code> (#15225)</li>
<li>Make package validation regular expression accept universal Linux packages (#15226)</li>
<li>Bump NJsonSchema from 10.4.0 to 10.4.1 (#15190)</li>
<li>Make MSI and EXE signing always copy to fix daily build (#15191)</li>
<li>Sign internals of EXE package so that it works correctly when signed (#15132)</li>
<li>Bump Microsoft.NET.Test.Sdk from 16.9.1 to 16.9.4 (#15141)</li>
<li>Update daily release tag format to  work with new Microsoft Update work (#15164)</li>
<li>Feature: Add Ubuntu 20.04 Support to install-powershell.sh (#15095) (Thanks @JustinGrote!)</li>
<li>Treat rebuild branches like release branches (#15099)</li>
<li>Update WiX to 3.11.2 (#15097)</li>
<li>Bump NJsonSchema from 10.3.11 to 10.4.0 (#15092)</li>
<li>Allow patching of preview releases (#15074)</li>
<li>Bump Newtonsoft.Json from 12.0.3 to 13.0.1 (#15084, #15085)</li>
<li>Update the <code>minSize</code> build package filter to be explicit (#15055)</li>
<li>Bump NJsonSchema from 10.3.10 to 10.3.11 (#14965)</li>
</ul>

</details>

### Documentation and Help Content

- Merge `7.2.0-preview.4` changes to master (#15056)
- Update `README` and `metadata.json` (#15046)
- Fix broken links for `dotnet` CLI (#14937)

[7.2.0-preview.5]: https://github.com/PowerShell/PowerShell/compare/v7.2.0-preview.4...v7.2.0-preview.5

## [7.2.0-preview.4] - 2021-03-16

### Breaking Changes

- Fix `Get-Date -UFormat` `%G` and `%g` behavior (#14555) (Thanks @brianary!)

### Engine Updates and Fixes

- Update engine script signature validation to match `Get-AuthenticodeSignature` logic (#14849)
- Avoid array allocations from `GetDirectories` and `GetFiles` (#14327) (Thanks @xtqqczze!)

### General Cmdlet Updates and Fixes

- Add `UseOSCIndicator` setting to enable progress indicator in terminal (#14927)
- Re-enable VT mode on Windows after running command in `ConsoleHost` (#14413)
- Fix `Move-Item` for `FileSystemProvider` to use copy-delete instead of move for DFS paths (#14913)
- Fix `PromptForCredential()` to add `targetName` as domain (#14504)
- Update `Concise` `ErrorView` to not show line information for errors from script module functions (#14912)
- Remove the 32,767 character limit on the environment block for `Start-Process` (#14111) (Thanks @hbuckle!)
- Don't write possible secrets to verbose stream for web cmdlets (#14788)

### Tools

- Update `dependabot` configuration to V2 format (#14882)
- Add tooling issue slots in PR template (#14697)

### Tests

- Move misplaced test file to tests directory (#14908) (Thanks @MarianoAlipi!)
- Refactor MSI CI (#14753)

### Build and Packaging Improvements

<details>

<summary>
Update .NET to version <code>6.0.100-preview.2.21155.3</code>
</summary>

<ul>
<li>Update .NET to version <code>6.0.100-preview.2.21155.3</code> (#15007)</li>
<li>Bump <code>Microsoft.PowerShell.Native</code> to <code>7.2.0-preview.1</code> (#15030)</li>
<li>Create MSIX Bundle package in release pipeline (#14982)</li>
<li>Build self-contained minimal size package for Guest Config team (#14976)</li>
<li>Bump XunitXml.TestLogger from 3.0.62 to 3.0.66 (#14993) (Thanks @dependabot[bot]!)</li>
<li>Enable building PowerShell for Apple M1 runtime (#14923)</li>
<li>Fix the variable name in the condition for miscellaneous analysis CI (#14975)</li>
<li>Fix the variable usage in CI yaml (#14974)</li>
<li>Disable running Markdown link verification in release build CI (#14971)</li>
<li>Bump Microsoft.CodeAnalysis.CSharp from 3.9.0-3.final to 3.9.0 (#14934) (Thanks @dependabot[bot]!)</li>
<li>Declare which variable group is used for checking the blob in the release build (#14970)</li>
<li>Update metadata and script to enable consuming .NET daily builds (#14940)</li>
<li>Bump NJsonSchema from 10.3.9 to 10.3.10 (#14933) (Thanks @dependabot[bot]!)</li>
<li>Use template that disables component governance for CI (#14938)</li>
<li>Add suppress for nuget multi-feed warning (#14893)</li>
<li>Bump NJsonSchema from 10.3.8 to 10.3.9 (#14926) (Thanks @dependabot[bot]!)</li>
<li>Add exe wrapper to release (#14881)</li>
<li>Bump Microsoft.ApplicationInsights from 2.16.0 to 2.17.0 (#14847)</li>
<li>Bump Microsoft.NET.Test.Sdk from 16.8.3 to 16.9.1 (#14895) (Thanks @dependabot[bot]!)</li>
<li>Bump NJsonSchema from 10.3.7 to 10.3.8 (#14896) (Thanks @dependabot[bot]!)</li>
<li>Disable codesign validation where the file type is not supported (#14885)</li>
<li>Fixing broken Experimental Feature list in <code>powershell.config.json</code> (#14858)</li>
<li>Bump NJsonSchema from 10.3.6 to 10.3.7 (#14855)</li>
<li>Add exe wrapper for Microsoft Update scenarios (#14737)</li>
<li>Install wget on <code>CentOS</code> 7 docker image (#14857)</li>
<li>Fix install-dotnet download (#14856)</li>
<li>Fix Bootstrap step in Windows daily test runs (#14820)</li>
<li>Bump NJsonSchema from 10.3.5 to 10.3.6 (#14818)</li>
<li>Bump <code>NJsonSchema</code> from <code>10.3.4</code> to <code>10.3.5</code> (#14807)</li>
</ul>

</details>

### Documentation and Help Content

- Update `README.md` and `metadata.json` for upcoming releases (#14755)
- Merge 7.1.3 and 7.0.6 changelog to master (#15009)
- Update `README` and `metadata.json` for releases (#14997)
- Update ChangeLog for `v7.1.2` release (#14783)
- Update ChangeLog for `v7.0.5` release (#14782) (Internal 14479)

[7.2.0-preview.4]: https://github.com/PowerShell/PowerShell/compare/v7.2.0-preview.3...v7.2.0-preview.4

## [7.2.0-preview.3] - 2021-02-11

### Breaking Changes

- Fix `Get-Date -UFormat %u` behavior to comply with ISO 8601 (#14549) (Thanks @brianary!)

### Engine Updates and Fixes

- Together with `PSDesiredStateConfiguration` `v3` module allows `Get-DscResource`, `Invoke-DscResource` and DSC configuration compilation on all platforms, supported by PowerShell (using class-based DSC resources).

### Performance

- Avoid array allocations from `Directory.GetDirectories` and `Directory.GetFiles`. (#14326) (Thanks @xtqqczze!)
- Avoid `string.ToLowerInvariant()` from `GetEnvironmentVariableAsBool()` to avoid loading libicu at startup (#14323) (Thanks @iSazonov!)
- Get PowerShell version in `PSVersionInfo` using assembly attribute instead of `FileVersionInfo` (#14332) (Thanks @Fs00!)

### General Cmdlet Updates and Fixes

- Suppress `Write-Progress` in `ConsoleHost` if output is redirected and fix tests (#14716)
- Experimental feature `PSAnsiProgress`: Add minimal progress bar using ANSI rendering (#14414)
- Fix web cmdlets to properly construct URI from body when using `-NoProxy` (#14673)
- Update the `ICommandPredictor` to provide more feedback and also make feedback easier to be correlated (#14649)
- Reset color after writing `Verbose`, `Debug`, and `Warning` messages (#14698)
- Fix using variable for nested `ForEach-Object -Parallel` calls (#14548)
- When formatting, if collection is modified, don't fail the entire pipeline (#14438)
- Improve completion of parameters for attributes (#14525) (Thanks @MartinGC94!)
- Write proper error messages for `Get-Command ' '` (#13564) (Thanks @jakekerr!)
- Fix typo in the resource string `ProxyURINotSupplied` (#14526) (Thanks @romero126!)
- Add support to `$PSStyle` for strikethrough and hyperlinks (#14461)
- Fix `$PSStyle` blink codes (#14447) (Thanks @iSazonov!)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze, @powercode</p>

</summary>

<ul>
<li>Fix coding style issues: RCS1215, IDE0090, SA1504, SA1119, RCS1139, IDE0032 (#14356, #14341, #14241, #14204, #14442, #14443) (Thanks @xtqqczze!)</li>
<li>Enable coding style checks: CA2249, CA1052, IDE0076, IDE0077, SA1205, SA1003, SA1314, SA1216, SA1217, SA1213 (#14395, #14483, #14494, #14495, #14441, #14476, #14470, #14471, #14472) (Thanks @xtqqczze!)</li>
<li>Enable nullable in PowerShell codebase (#14160, #14172, #14088, #14154, #14166, #14184, #14178) (Thanks @powercode!)</li>
<li>Use <code>string.Split(char)</code> instead of <code>string.Split(string)</code> (#14465) (Thanks @xtqqczze!)</li>
<li>Use <code>string.Contains(char)</code> overload (#14368) (Thanks @xtqqczze!)</li>
<li>Refactor complex <code>if</code> statements (#14398) (Thanks @xtqqczze!)</li>
</ul>

</details>

### Tools

- Update script to use .NET 6 build resources (#14705)
- Fix the daily GitHub action (#14711) (Thanks @imba-tjd!)
- GitHub Actions: fix deprecated `::set-env` (#14629) (Thanks @imba-tjd!)
- Update Markdown test tools (#14325) (Thanks @RDIL!)
- Upgrade `StyleCopAnalyzers` to `v1.2.0-beta.312` (#14354) (Thanks @xtqqczze!)

### Tests

- Remove packaging from daily Windows build (#14749)
- Update link to the Manning book (#14750)
- A separate Windows packaging CI (#14670)
- Update `ini` component version in test `package.json` (#14454)
- Disable `libmi` dependent tests for macOS. (#14446)

### Build and Packaging Improvements

<details>

<ul>
<li>Fix the NuGet feed name and URL for .NET 6</li>
<li>Fix third party signing for files in sub-folders (#14751)</li>
<li>Make build script variable an <code>ArrayList</code> to enable <code>Add()</code> method (#14748)</li>
<li>Remove old .NET SDKs to make <code>dotnet restore</code> work with the latest SDK in CI pipeline (#14746)</li>
<li>Remove outdated Linux dependencies (#14688)</li>
<li>Bump .NET SDK version to 6.0.0-preview.1 (#14719)</li>
<li>Bump <code>NJsonSchema</code> to 10.3.4 (#14714)</li>
<li>Update daily GitHub action to allow manual trigger (#14718)</li>
<li>Bump <code>XunitXml.TestLogger</code> to 3.0.62 (#14702)</li>
<li>Make universal deb package based on the deb package specification (#14681)</li>
<li>Add manual release automation steps and improve changelog script (#14445)</li>
<li>Fix release build to upload global tool packages to artifacts (#14620)</li>
<li>Port changes from the PowerShell v7.0.4 release (#14637)</li>
<li>Port changes from the PowerShell v7.1.1 release (#14621)</li>
<li>Updated README and <code>metadata.json</code> (#14401, #14606, #14612)</li>
<li>Do not push nupkg artifacts to MyGet (#14613)</li>
<li>Use one feed in each <code>nuget.config</code> in official builds (#14363)</li>
<li>Fix path signed RPMs are uploaded from in release build (#14424)</li>
</ul>

</details>

### Documentation and Help Content

- Update distribution support request template to point to .NET 5.0 support document (#14578)
- Remove security GitHub issue template (#14453)
- Add intent for using the Discussions feature in repository (#14399)
- Fix Universal Dashboard to refer to PowerShell Universal (#14437)
- Update document link because of HTTP 301 redirect (#14431) (Thanks @xtqqczze!)

[7.2.0-preview.3]: https://github.com/PowerShell/PowerShell/compare/v7.2.0-preview.2...v7.2.0-preview.3

## [7.2.0-preview.2] - 2020-12-15

### Breaking Changes

- Improve detection of mutable value types (#12495) (Thanks @vexx32!)
- Ensure `-PipelineVariable` is set for all output from script cmdlets (#12766) (Thanks @vexx32!)

### Experimental Features

- `PSAnsiRendering`: Enable ANSI formatting via `$PSStyle` and support suppressing ANSI output (#13758)

### Performance

- Optimize `IEnumerable` variant of replace operator (#14221) (Thanks @iSazonov!)
- Refactor multiply operation for better performance in two `Microsoft.PowerShell.Commands.Utility` methods (#14148) (Thanks @xtqqczze!)
- Use `Environment.TickCount64` instead of `Datetime.Now` as the random seed for AppLocker test file content (#14283) (Thanks @iSazonov!)
- Avoid unnecessary array allocations when searching in GAC (#14291) (Thanks @xtqqczze!)
- Use `OrdinalIgnoreCase` in `CommandLineParser` (#14303) (Thanks @iSazonov!)
- Use `StringComparison.Ordinal` instead of `StringComparison.CurrentCulture` (#14298) (Thanks @iSazonov!)
- Avoid creating instances of the generated delegate helper class in `-replace` implementation (#14128)

### General Cmdlet Updates and Fixes

- Write better error message if config file is broken (#13496) (Thanks @iSazonov!)
- Make AppLocker Enforce mode take precedence over UMCI Audit mode (#14353)
- Add `-SkipLimitCheck` switch to `Import-PowerShellDataFile` (#13672)
- Restrict `New-Object` in NoLanguage mode under lock down (#14140) (Thanks @krishnayalavarthi!)
- The `-Stream` parameter now works with directories (#13941) (Thanks @kyanha!)
- Avoid an exception if file system does not support reparse points (#13634) (Thanks @iSazonov!)
- Enable `CA1012`: Abstract types should not have public constructors (#13940) (Thanks @xtqqczze!)
- Enable `SA1212`: Property accessors should follow order (#14051) (Thanks @xtqqczze!)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze, @matthewjdegarmo, @powercode, @Gimly</p>

</summary>

<ul>
<li>Enable <code>SA1007</code>: Operator keyword should be followed by space (#14130) (Thanks @xtqqczze!)</li>
<li>Expand <code>where</code> alias to <code>Where-Object</code> in <code>Reset-PWSHSystemPath.ps1</code> (#14113) (Thanks @matthewjdegarmo!)</li>
<li>Fix whitespace issues (#14092) (Thanks @xtqqczze!)</li>
<li>Add <code>StyleCop.Analyzers</code> package (#13963) (Thanks @xtqqczze!)</li>
<li>Enable <code>IDE0041</code>: <code>UseIsNullCheck</code> (#14041) (Thanks @xtqqczze!)</li>
<li>Enable <code>IDE0082</code>: <code>ConvertTypeOfToNameOf</code> (#14042) (Thanks @xtqqczze!)</li>
<li>Remove unnecessary usings part 4 (#14023) (Thanks @xtqqczze!)</li>
<li>Fix <code>PriorityAttribute</code> name (#14094) (Thanks @xtqqczze!)</li>
<li>Enable nullable: <code>System.Management.Automation.Interpreter.IBoxableInstruction</code> (#14165) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.Provider.IDynamicPropertyProvider</code> (#14167) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.Language.IScriptExtent</code> (#14179) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.Language.ICustomAstVisitor2</code> (#14192) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.LanguagePrimitives.IConversionData</code> (#14187) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Automation.Remoting.Client.IWSManNativeApiFacade</code> (#14186) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.Language.ISupportsAssignment</code> (#14180) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.ICommandRuntime2</code> (#14183) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.IOutputProcessingState</code> (#14175) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.IJobDebugger</code> (#14174) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.Interpreter.IInstructionProvider</code> (#14173) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.IHasSessionStateEntryVisibility</code> (#14169) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.Tracing.IEtwEventCorrelator</code> (#14168) (Thanks @powercode!)</li>
<li>Fix syntax error in Windows packaging script (#14377)</li>
<li>Remove redundant local assignment in <code>AclCommands</code> (#14358) (Thanks @xtqqczze!)</li>
<li>Enable nullable: <code>System.Management.Automation.Language.IAstPostVisitHandler</code> (#14164) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.IModuleAssemblyInitializer</code> (#14158) (Thanks @powercode!)</li>
<li>Use <code>Microsoft.PowerShell.MarkdownRender</code> package from <code>nuget.org</code> (#14090)</li>
<li>Replace <code>GetFiles</code> in <code>TestModuleManifestCommand</code> (#14317) (Thanks @xtqqczze!)</li>
<li>Enable nullable: <code>System.Management.Automation.Provider.IContentWriter</code> (#14152) (Thanks @powercode!)</li>
<li>Simplify getting Encoding in <code>TranscriptionOption.FlushContentToDisk</code> (#13910) (Thanks @Gimly!)</li>
<li>Mark applicable structs as <code>readonly</code> and use <code>in</code>-modifier (#13919) (Thanks @xtqqczze!)</li>
<li>Enable nullable: <code>System.Management.Automation.IArgumentCompleter</code> (#14182) (Thanks @powercode!)</li>
<li>Enable <code>CA1822</code>: Mark <code>private</code> members as <code>static</code> (#13897) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDE0090</code>: Simplify <code>new</code> expression part 6 (#14338) (Thanks @xtqqczze!)</li>
<li>Avoid array allocations from <code>GetDirectories</code>/<code>GetFiles</code>. (#14328) (Thanks @xtqqczze!)</li>
<li>Avoid array allocations from <code>GetDirectories</code>/<code>GetFiles</code>. (#14330) (Thanks @xtqqczze!)</li>
<li>Fix <code>RCS1188</code>: Remove redundant auto-property initialization part 2 (#14262) (Thanks @xtqqczze!)</li>
<li>Enable nullable: <code>System.Management.Automation.Host.IHostSupportsInteractiveSession</code> (#14170) (Thanks @powercode!)</li>
<li>Enable nullable: <code>System.Management.Automation.Provider.IPropertyCmdletProvider</code> (#14176) (Thanks @powercode!)</li>
<li>Fix <code>IDE0090</code>: Simplify new expression part 5 (#14301) (Thanks @xtqqczze!)</li>
<li>Enable <code>IDE0075</code>: <code>SimplifyConditionalExpression</code> (#14078) (Thanks @xtqqczze!)</li>
<li>Remove unnecessary usings part 9 (#14288) (Thanks @xtqqczze!)</li>
<li>Fix StyleCop and MarkdownLint CI failures (#14297) (Thanks @xtqqczze!)</li>
<li>Enable <code>SA1000</code>: Keywords should be spaced correctly (#13973) (Thanks @xtqqczze!)</li>
<li>Fix <code>RCS1188</code>: Remove redundant auto-property initialization part 1 (#14261) (Thanks @xtqqczze!)</li>
<li>Mark <code>private</code> members as <code>static</code> part 10 (#14235) (Thanks @xtqqczze!)</li>
<li>Mark <code>private</code> members as <code>static</code> part 9 (#14234) (Thanks @xtqqczze!)</li>
<li>Fix <code>SA1642</code> for <code>Microsoft.Management.Infrastructure.CimCmdlets</code> (#14239) (Thanks @xtqqczze!)</li>
<li>Use <code>AsSpan</code>/<code>AsMemory</code> slice constructor (#14265) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDE0090</code>: Simplify <code>new</code> expression part 4.6 (#14260) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDE0090</code>: Simplify <code>new</code> expression part 4.5 (#14259) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDE0090</code>: Simplify <code>new</code> expression part 4.3 (#14257) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDE0090</code>: Simplify <code>new</code> expression part 4.2 (#14256) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDE0090</code>: Simplify <code>new</code> expression part 2 (#14200) (Thanks @xtqqczze!)</li>
<li>Enable <code>SA1643</code>: Destructor summary documentation should begin with standard text (#14236) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDE0090</code>: Simplify new expression part 4.4 (#14258) (Thanks @xtqqczze!)</li>
<li>Use xml documentation child blocks correctly (#14249) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDE0090</code>: Simplify <code>new</code> expression part 4.1 (#14255) (Thanks @xtqqczze!)</li>
<li>Use consistent spacing in xml documentation tags (#14231) (Thanks @xtqqczze!)</li>
<li>Enable <code>IDE0074</code>: Use coalesce compound assignment (#13396) (Thanks @xtqqczze!)</li>
<li>Remove unnecessary finalizers (#14248) (Thanks @xtqqczze!)</li>
<li>Mark local variable as <code>const</code> (#13217) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDE0032</code>: <code>UseAutoProperty</code> part 2 (#14244) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDE0032</code>: <code>UseAutoProperty</code> part 1 (#14243) (Thanks @xtqqczze!)</li>
<li>Mark <code>private</code> members as <code>static</code> part 8 (#14233) (Thanks @xtqqczze!)</li>
<li>Fix <code>CA1822</code>: Mark members as <code>static</code> part 6 (#14229) (Thanks @xtqqczze!)</li>
<li>Fix <code>CA1822</code>: Mark members as <code>static</code> part 5 (#14228) (Thanks @xtqqczze!)</li>
<li>Fix <code>CA1822</code>: Mark members as <code>static</code> part 4 (#14227) (Thanks @xtqqczze!)</li>
<li>Fix <code>CA1822</code>: Mark members as <code>static</code> part 3 (#14226) (Thanks @xtqqczze!)</li>
<li>Fix <code>CA1822</code>: Mark members as <code>static</code> part 2 (#14225) (Thanks @xtqqczze!)</li>
<li>Fix <code>CA1822</code>: Mark members as <code>static</code> part 1 (#14224) (Thanks @xtqqczze!)</li>
<li>Use <code>see</code> keyword in documentation (#14220) (Thanks @xtqqczze!)</li>
<li>Enable <code>CA2211</code>: Non-constant fields should not be visible (#14073) (Thanks @xtqqczze!)</li>
<li>Enable <code>CA1816</code>: <code>Dispose</code> methods should call <code>SuppressFinalize</code> (#14074) (Thanks @xtqqczze!)</li>
<li>Remove incorrectly implemented finalizer (#14246) (Thanks @xtqqczze!)</li>
<li>Fix <code>CA1822</code>: Mark members as <code>static</code> part 7 (#14230) (Thanks @xtqqczze!)</li>
<li>Fix <code>SA1122</code>: Use <code>string.Empty</code> for empty strings (#14218) (Thanks @xtqqczze!)</li>
<li>Fix various xml documentation issues (#14223) (Thanks @xtqqczze!)</li>
<li>Remove unnecessary <code>using</code>s part 8 (#14072) (Thanks @xtqqczze!)</li>
<li>Enable <code>SA1006</code>: Preprocessor keywords should not be preceded by space (#14052) (Thanks @xtqqczze!)</li>
<li>Fix <code>SA1642</code> for <code>Microsoft.PowerShell.Commands.Utility</code> (#14142) (Thanks @xtqqczze!)</li>
<li>Enable <code>CA2216</code>: Disposable types should declare finalizer (#14089) (Thanks @xtqqczze!)</li>
<li>Wrap and name <code>LoadBinaryModule</code> arguments (#14193) (Thanks @xtqqczze!)</li>
<li>Wrap and name <code>GetListOfFilesFromData</code> arguments (#14194) (Thanks @xtqqczze!)</li>
<li>Enable <code>SA1002</code>: Semicolons should be spaced correctly (#14197) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDE0090</code>: Simplify <code>new</code> expression part 3 (#14201) (Thanks @xtqqczze!)</li>
<li>Enable <code>SA1106</code>: Code should not contain empty statements (#13964) (Thanks @xtqqczze!)</li>
<li>Code performance fixes follow-up (#14207) (Thanks @xtqqczze!)</li>
<li>Remove uninformative comments (#14199) (Thanks @xtqqczze!)</li>
<li>Fix <code>IDE0090</code>: Simplify <code>new</code> expression part 1 (#14027) (Thanks @xtqqczze!)</li>
<li>Enable <code>SA1517</code>: Code should not contain blank lines at start of file (#14131) (Thanks @xtqqczze!)</li>
<li>Enable <code>SA1131</code>: Use readable conditions (#14132) (Thanks @xtqqczze!)</li>
<li>Enable <code>SA1507</code>: Code should not contain multiple blank lines in a row (#14136) (Thanks @xtqqczze!)</li>
<li>Enable <code>SA1516</code> Elements should be separated by blank line (#14137) (Thanks @xtqqczze!)</li>
<li>Enable <code>IDE0031</code>: Null check can be simplified (#13548) (Thanks @xtqqczze!)</li>
<li>Enable <code>CA1065</code>: Do not raise exceptions in unexpected locations (#14117) (Thanks @xtqqczze!)</li>
<li>Enable <code>CA1000</code>: Do not declare <code>static</code> members on generic types (#14097) (Thanks @xtqqczze!)</li>
</ul>

</details>

### Tools

- Fixing formatting in `Reset-PWSHSystemPath.ps1` (#13689) (Thanks @dgoldman-msft!)

### Tests

- Reinstate `Test-Connection` tests (#13324)
- Update Markdown test packages with security fixes (#14145)

### Build and Packaging Improvements

<details>

<ul>
<li>Fix a typo in the <code>Get-ChangeLog</code> function (#14129)</li>
<li>Update <code>README</code> and <code>metadata.json</code> for <code>7.2.0-preview.1</code> release (#14104)</li>
<li>Bump <code>NJsonSchema</code> from <code>10.2.2</code> to <code>10.3.1</code> (#14040)</li>
<li>Move windows package signing to use ESRP (#14060)</li>
<li>Use one feed in each <code>nuget.config</code> in official builds (#14363)</li>
<li>Fix path signed RPMs are uploaded from in release build (#14424)</li>
<li>Add <code>Microsoft.PowerShell.MarkdownRender</code> to the package reference list (#14386)</li>
<li>Fix issue with unsigned build (#14367)</li>
<li>Move macOS and nuget to ESRP signing (#14324)</li>
<li>Fix nuget packaging to scrub <code>NullableAttribute</code> (#14344)</li>
<li>Bump <code>Microsoft.NET.Test.Sdk</code> from 16.8.0 to 16.8.3 (#14310)</li>
<li>Bump <code>Markdig.Signed</code> from 0.22.0 to 0.22.1 (#14305)</li>
<li>Bump <code>Microsoft.ApplicationInsights</code> from 2.15.0 to 2.16.0 (#14031)</li>
<li>Move Linux to ESRP signing (#14210)</li>
</ul>

</details>

### Documentation and Help Content

- Fix example `nuget.config` (#14349)
- Fix a broken link in Code Guidelines doc (#14314) (Thanks @iSazonov!)

[7.2.0-preview.2]: https://github.com/PowerShell/PowerShell/compare/v7.2.0-preview.1...v7.2.0-preview.2

## [7.2.0-preview.1] - 2020-11-17

### Engine Updates and Fixes

- Change the default fallback encoding for `GetEncoding` in `Start-Transcript` to be `UTF8` without a BOM (#13732) (Thanks @Gimly!)

### General Cmdlet Updates and Fixes

- Update `pwsh -?` output to match docs (#13748)
- Fix `NullReferenceException` in `Test-Json` (#12942) (Thanks @iSazonov!)
- Make `Dispose` in `TranscriptionOption` idempotent (#13839) (Thanks @krishnayalavarthi!)
- Add additional Microsoft PowerShell modules to the tracked modules list (#12183)
- Relax further `SSL` verification checks for `WSMan` on non-Windows hosts with verification available (#13786) (Thanks @jborean93!)
- Add the `OutputTypeAttribute` to `Get-ExperimentalFeature` (#13738) (Thanks @ThomasNieto!)
- Fix blocking wait when starting file associated with a Windows application (#13750)
- Emit warning if `ConvertTo-Json` exceeds `-Depth` value (#13692)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@xtqqczze, @mkswd, @ThomasNieto, @PatLeong, @paul-cheung, @georgettica</p>

</summary>

<ul>
<li>Fix RCS1049: Simplify boolean comparison (#13994) (Thanks @xtqqczze!)</li>
<li>Enable IDE0062: Make local function static (#14044) (Thanks @xtqqczze!)</li>
<li>Enable CA2207: Initialize value type static fields inline (#14068) (Thanks @xtqqczze!)</li>
<li>Enable CA1837: Use <code>ProcessId</code> and <code>CurrentManagedThreadId</code> from <code>System.Environment</code> (#14063) (Thanks @xtqqczze and @PatLeong!)</li>
<li>Remove unnecessary using directives (#14014, #14017, #14021, #14050, #14065, #14066, #13863, #13860, #13861, #13814) (Thanks @xtqqczze and @ThomasNieto!)</li>
<li>Remove unnecessary usage of LINQ <code>Count</code> method (#13545) (Thanks @xtqqczze!)</li>
<li>Fix SA1518: The code must not contain extra blank lines at the end of the file (#13574) (Thanks @xtqqczze!)</li>
<li>Enable CA1829: Use the <code>Length</code> or <code>Count</code> property instead of <code>Count()</code> (#13925) (Thanks @xtqqczze!)</li>
<li>Enable CA1827: Do not use <code>Count()</code> or <code>LongCount()</code> when <code>Any()</code> can be used (#13923) (Thanks @xtqqczze!)</li>
<li>Enable or fix nullable usage in a few files (#13793, #13805, #13808, #14018, #13804) (Thanks @mkswd and @georgettica!)</li>
<li>Enable IDE0040: Add accessibility modifiers (#13962, #13874) (Thanks @xtqqczze!)</li>
<li>Make applicable private Guid fields readonly (#14000) (Thanks @xtqqczze!)</li>
<li>Fix CA1003: Use generic event handler instances (#13937) (Thanks @xtqqczze!)</li>
<li>Simplify delegate creation (#13578) (Thanks @xtqqczze!)</li>
<li>Fix RCS1033: Remove redundant boolean literal (#13454) (Thanks @xtqqczze!)</li>
<li>Fix RCS1221: Use pattern matching instead of combination of <code>as</code> operator and null check (#13333) (Thanks @xtqqczze!)</li>
<li>Use <code>is not</code> syntax (#13338) (Thanks @xtqqczze!)</li>
<li>Replace magic number with constant in PDH (#13536) (Thanks @xtqqczze!)</li>
<li>Fix accessor order (#13538) (Thanks @xtqqczze!)</li>
<li>Enable IDE0054: Use compound assignment (#13546) (Thanks @xtqqczze!)</li>
<li>Fix RCS1098: Constant values should be on right side of comparisons (#13833) (Thanks @xtqqczze!)</li>
<li>Enable CA1068: <code>CancellationToken</code> parameters must come last (#13867) (Thanks @xtqqczze!)</li>
<li>Enable CA10XX rules with suggestion severity (#13870, #13928, #13924) (Thanks @xtqqczze!)</li>
<li>Enable IDE0064: Make Struct fields writable (#13945) (Thanks @xtqqczze!)</li>
<li>Run <code>dotnet-format</code> to improve formatting of source code (#13503) (Thanks @xtqqczze!)</li>
<li>Enable CA1825: Avoid zero-length array allocations (#13961) (Thanks @xtqqczze!)</li>
<li>Add IDE analyzer rule IDs to comments (#13960) (Thanks @xtqqczze!)</li>
<li>Enable CA1830: Prefer strongly-typed <code>Append</code> and <code>Insert</code> method overloads on <code>StringBuilder</code> (#13926) (Thanks @xtqqczze!)</li>
<li>Enforce code style in build (#13957) (Thanks @xtqqczze!)</li>
<li>Enable CA1836: Prefer <code>IsEmpty</code> over <code>Count</code> when available (#13877) (Thanks @xtqqczze!)</li>
<li>Enable CA1834: Consider using <code>StringBuilder.Append(char)</code> when applicable (#13878) (Thanks @xtqqczze!)</li>
<li>Fix IDE0044: Make field readonly (#13884, #13885, #13888, #13892, #13889, #13886, #13890, #13891, #13887, #13893, #13969, #13967, #13968, #13970, #13971, #13966, #14012) (Thanks @xtqqczze!)</li>
<li>Enable IDE0048: Add required parentheses (#13896) (Thanks @xtqqczze!)</li>
<li>Enable IDE1005: Invoke delegate with conditional access (#13911) (Thanks @xtqqczze!)</li>
<li>Enable IDE0036: Enable the check on the order of modifiers (#13958, #13881) (Thanks @xtqqczze!)</li>
<li>Use span-based <code>String.Concat</code> instead of <code>String.Substring</code> (#13500) (Thanks @xtqqczze!)</li>
<li>Enable CA1050: Declare types in namespace (#13872) (Thanks @xtqqczze!)</li>
<li>Fix minor keyword typo in C# code comment (#13811) (Thanks @paul-cheung!)</li>
</ul>

</details>

### Tools

- Enable `CodeQL` Security scanning (#13894)
- Add global `AnalyzerConfig` with default configuration (#13835) (Thanks @xtqqczze!)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@mkswd, @xtqqczze</p>

</summary>

<ul>
<li>Bump <code>Microsoft.NET.Test.Sdk</code> to <code>16.8.0</code> (#14020)</li>
<li>Bump <code>Microsoft.CodeAnalysis.CSharp</code> to <code>3.8.0</code> (#14075)</li>
<li>Remove workarounds for .NET 5 RTM builds (#14038)</li>
<li>Migrate 3rd party signing to ESRP (#14010)</li>
<li>Fixes to release pipeline for GA release (#14034)</li>
<li>Don't do a shallow checkout (#13992)</li>
<li>Add validation and dependencies for Ubuntu 20.04 distribution to packaging script (#13993)</li>
<li>Add .NET install workaround for RTM (#13991)</li>
<li>Move to ESRP signing for Windows files (#13988)</li>
<li>Update <code>PSReadLine</code> version to <code>2.1.0</code> (#13975)</li>
<li>Bump .NET to version <code>5.0.100-rtm.20526.5</code> (#13920)</li>
<li>Update script to use .NET RTM feeds (#13927)</li>
<li>Add checkout step to release build templates (#13840)</li>
<li>Turn on <code>/features:strict</code> for all projects (#13383) (Thanks @xtqqczze!)</li>
<li>Bump <code>NJsonSchema</code> to <code>10.2.2</code> (#13722, #13751)</li>
<li>Add flag to make Linux script publish to production repository (#13714)</li>
<li>Bump <code>Markdig.Signed</code> to <code>0.22.0</code> (#13741)</li>
<li>Use new release script for Linux packages (#13705)</li>
</ul>

</details>

### Documentation and Help Content

- Fix links to LTS versions for Windows (#14070)
- Fix `crontab` formatting in example doc (#13712) (Thanks @dgoldman-msft!)

[7.2.0-preview.1]: https://github.com/PowerShell/PowerShell/compare/v7.1.0...v7.2.0-preview.1
