// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"

namespace Rivet {


  /// @brief Add a short analysis description here
  class SND_2001_I579319 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(SND_2001_I579319);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");

      // Book histograms
      for (size_t ix=0; ix<2; ++ix) {
        book(_npion[ix], 1+ix, 1, 1);
        for (const string& en : _npion[ix].binning().edges<0>()) {
          const double eval = stod(en)*GeV;
          if (isCompatibleWithSqrtS(eval)) {
            _sqs[ix] = en; break;
          }
        }
      }
      raiseBeamErrorIf(_sqs[0].empty() && _sqs[1].empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      if (ntotal!=4) vetoEvent;
      if (nCount[-211]==2&&nCount[211]==2) {
        _npion[0]->fill(_sqs[0]);
      }
      else if (nCount[-211]==1 && nCount[211]==1 && nCount[111]==2) {
        _npion[1]->fill(_sqs[1]);
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_npion, crossSection()/sumOfWeights()/nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _npion[2];
    string _sqs[2];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(SND_2001_I579319);
}
