/*
 *  Copyright (C) 2010-2024 Fabio Cavallo (aka FHorse)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <string.h>
#include <stdlib.h>
#include "mappers.h"
#include "save_slot.h"
#include "ppu_inline.h"

INLINE static void prg_fix_006(void);
INLINE static void chr_fix_006(void);
INLINE static void wram_fix_006(void);
INLINE static void mirroring_fix_006(void);

INLINE static void irq_clock_006(BYTE nidx);

const BYTE initial_state[0x1000] = {
	0x20, 0x03, 0x70, 0x6C, 0xFC, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4C, 0xDD, 0x54, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x2C, 0x00, 0x45, 0x30, 0x19, 0x50, 0x17, 0x2C, 0x2F,
	0x50, 0x10, 0x0E, 0x8D, 0x44, 0x58, 0xA5, 0xFA, 0x0A, 0x09, 0xE0, 0x8D, 0xFD, 0x42, 0xAD,
	0x44, 0x58, 0x28, 0x4C, 0x11, 0x11, 0x8D, 0x44, 0x58, 0x8E, 0x45, 0x58, 0x8C, 0x46, 0x58,
	0xBA, 0x8E, 0x47, 0x58, 0xAD, 0x00, 0x58, 0x8D, 0x40, 0x58, 0x29, 0x7F, 0x8D, 0x00, 0x20,
	0xAD, 0x01, 0x58, 0x8D, 0x41, 0x58, 0xAD, 0x00, 0x45, 0x8D, 0x42, 0x58, 0xAD, 0x01, 0x45,
	0x8D, 0x43, 0x58, 0xA2, 0x1F, 0xBD, 0x00, 0x50, 0x9D, 0x48, 0x58, 0xBD, 0x00, 0x55, 0x9D,
	0x68, 0x58, 0xCA, 0x10, 0xF1, 0xA9, 0x00, 0x8D, 0x01, 0x45, 0x8D, 0x10, 0x40, 0x8D, 0x11,
	0x40, 0x8D, 0x15, 0x40, 0xA9, 0x01, 0x8D, 0x31, 0x50, 0x20, 0xCE, 0x53, 0xAD, 0xCA, 0x53,
	0xF0, 0xF8, 0xA9, 0x72, 0x8D, 0x00, 0x45, 0xA2, 0x00, 0xB5, 0x00, 0x9D, 0x00, 0x60, 0xBD,
	0x00, 0x01, 0x9D, 0x00, 0x61, 0xBD, 0x00, 0x02, 0x9D, 0x00, 0x62, 0xBD, 0x00, 0x03, 0x9D,
	0x00, 0x63, 0xBD, 0x00, 0x04, 0x9D, 0x00, 0x64, 0xBD, 0x00, 0x05, 0x9D, 0x00, 0x65, 0xBD,
	0x00, 0x06, 0x9D, 0x00, 0x66, 0xBD, 0x00, 0x07, 0x9D, 0x00, 0x67, 0xE8, 0xD0, 0xCE, 0xA9,
	0x00, 0x8D, 0x00, 0x20, 0x8D, 0x01, 0x20, 0xA2, 0x07, 0x9D, 0x10, 0x45, 0xCA, 0x10, 0xFA,
	0x20, 0xF8, 0x51, 0x20, 0xB6, 0x52, 0x20, 0x24, 0x53, 0x20, 0xE7, 0x52, 0x20, 0x18, 0x53,
	0xA9, 0x00, 0x8D, 0x00, 0x45, 0xA0, 0x02, 0x8C, 0x31, 0x50, 0x4C, 0x3D, 0xF0, 0xAD, 0x31,
	0x50, 0xC9, 0x01, 0xF0, 0x01, 0x60, 0x4C, 0xA7, 0x50, 0xAD, 0x31, 0x50, 0xC9, 0x02, 0xF0,
	0x01, 0x60, 0xA9, 0x00, 0x8D, 0x31, 0x50, 0x8D, 0x00, 0x20, 0x8D, 0x01, 0x20, 0x20, 0x52,
	0x53, 0x20, 0x88, 0x52, 0x20, 0x80, 0x53, 0x20, 0xAE, 0x53, 0xA9, 0x00, 0x8D, 0xFC, 0x43,
	0xA2, 0x03, 0xBD, 0x6C, 0x58, 0x9D, 0x04, 0x45, 0xCA, 0x10, 0xF7, 0xA2, 0x0B, 0xBD, 0x78,
	0x58, 0x9D, 0x10, 0x45, 0xCA, 0x10, 0xF7, 0xA2, 0x00, 0xBD, 0x48, 0x58, 0x9D, 0x00, 0x40,
	0xE8, 0xE0, 0x10, 0xD0, 0xF5, 0xAD, 0x5D, 0x58, 0x8D, 0x15, 0x40, 0xAD, 0x5E, 0x58, 0x8D,
	0x16, 0x40, 0xAD, 0x5F, 0x58, 0x8D, 0x17, 0x40, 0xA9, 0x72, 0x8D, 0x00, 0x45, 0xA2, 0x00,
	0xBD, 0x00, 0x60, 0x95, 0x00, 0xBD, 0x00, 0x61, 0x9D, 0x00, 0x01, 0xBD, 0x00, 0x62, 0x9D,
	0x00, 0x02, 0xBD, 0x00, 0x63, 0x9D, 0x00, 0x03, 0xBD, 0x00, 0x64, 0x9D, 0x00, 0x04, 0xBD,
	0x00, 0x65, 0x9D, 0x00, 0x05, 0xBD, 0x00, 0x66, 0x9D, 0x00, 0x06, 0xBD, 0x00, 0x67, 0x9D,
	0x00, 0x07, 0xE8, 0xD0, 0xCE, 0xAD, 0x68, 0x58, 0x8D, 0x00, 0x45, 0xAD, 0x42, 0x58, 0x29,
	0x03, 0xAA, 0xAD, 0x42, 0x58, 0x0A, 0x0A, 0x9D, 0xFC, 0x42, 0xAD, 0x43, 0x58, 0x29, 0x03,
	0xAA, 0xAD, 0x43, 0x58, 0x4A, 0x4A, 0x9D, 0xFC, 0x43, 0xAD, 0x02, 0x20, 0x10, 0xFB, 0xAD,
	0x02, 0x20, 0x10, 0xFB, 0x2C, 0x00, 0x45, 0x10, 0x03, 0x2C, 0x0A, 0x45, 0xAE, 0x47, 0x58,
	0x9A, 0xAC, 0x46, 0x58, 0xAE, 0x45, 0x58, 0xAD, 0x41, 0x58, 0x8D, 0x01, 0x20, 0xAD, 0x40,
	0x58, 0x8D, 0x00, 0x20, 0xAD, 0x44, 0x58, 0x28, 0x40, 0xA9, 0x20, 0x8D, 0xFD, 0x42, 0x8D,
	0xFC, 0x43, 0xA9, 0x00, 0x85, 0x00, 0xA9, 0x80, 0xA0, 0x04, 0x20, 0x2D, 0x52, 0x8E, 0x6C,
	0x58, 0xA9, 0xA0, 0xA0, 0x05, 0x20, 0x2D, 0x52, 0x8E, 0x6D, 0x58, 0xA9, 0xC0, 0xA0, 0x06,
	0x20, 0x2D, 0x52, 0x8E, 0x6E, 0x58, 0xA9, 0xE0, 0xA0, 0x07, 0x20, 0x2D, 0x52, 0x8E, 0x6F,
	0x58, 0x60, 0x85, 0x01, 0x8C, 0x56, 0x52, 0xA0, 0x00, 0xB1, 0x00, 0x8D, 0xC7, 0x53, 0xC8,
	0xB1, 0x00, 0x8D, 0xC8, 0x53, 0xC8, 0xB1, 0x00, 0x8D, 0xC9, 0x53, 0xA9, 0x49, 0x91, 0x00,
	0x88, 0xA9, 0x53, 0x91, 0x00, 0x88, 0xA9, 0x4A, 0x91, 0x00, 0xA2, 0x00, 0x8E, 0x04, 0x45,
	0xA0, 0x00, 0xB1, 0x00, 0xC9, 0x4A, 0xD0, 0x0E, 0xC8, 0xB1, 0x00, 0xC9, 0x53, 0xD0, 0x07,
	0xC8, 0xB1, 0x00, 0xC9, 0x49, 0xF0, 0x08, 0xE8, 0xE0, 0x80, 0xD0, 0xE2, 0x4C, 0x73, 0x52,
	0xAD, 0xC9, 0x53, 0x91, 0x00, 0x88, 0xAD, 0xC8, 0x53, 0x91, 0x00, 0x88, 0xAD, 0xC7, 0x53,
	0x91, 0x00, 0x60, 0x2C, 0x2F, 0x50, 0x10, 0x15, 0xA2, 0x0C, 0xA0, 0x01, 0x20, 0xA3, 0x52,
	0xA2, 0x0D, 0xA0, 0x02, 0x20, 0xA3, 0x52, 0xA2, 0x0E, 0xA0, 0x03, 0x20, 0xA3, 0x52, 0x60,
	0x8E, 0x07, 0x45, 0x8C, 0xFC, 0x43, 0xA9, 0x02, 0x8D, 0x00, 0x45, 0xA9, 0x20, 0x8D, 0xFD,
	0x42, 0x4C, 0xC5, 0x52, 0xA9, 0x62, 0x8D, 0x00, 0x45, 0xA9, 0x00, 0x8D, 0xFC, 0x43, 0xA9,
	0x20, 0x8D, 0xFF, 0x42, 0x2C, 0x02, 0x20, 0xA0, 0x00, 0x8C, 0x06, 0x20, 0x8C, 0x06, 0x20,
	0xA9, 0x60, 0x8D, 0xDD, 0x52, 0xAD, 0x07, 0x20, 0xAD, 0x07, 0x20, 0x99, 0x00, 0x60, 0xC8,
	0xD0, 0xF7, 0xEE, 0xDD, 0x52, 0x10, 0xF2, 0x60, 0xA9, 0x72, 0x8D, 0x00, 0x45, 0xA9, 0x20,
	0x8D, 0xFF, 0x42, 0x2C, 0x02, 0x20, 0xA0, 0x20, 0x8C, 0x06, 0x20, 0xA0, 0x00, 0x8C, 0x06,
	0x20, 0xA9, 0x68, 0x8D, 0x0D, 0x53, 0xA2, 0x08, 0xAD, 0x07, 0x20, 0xAD, 0x07, 0x20, 0x99,
	0x00, 0x68, 0xC8, 0xD0, 0xF7, 0xEE, 0x0D, 0x53, 0xCA, 0xD0, 0xF1, 0x60, 0xA2, 0x1F, 0xBD,
	0x20, 0x58, 0x9D, 0x88, 0x58, 0xCA, 0x10, 0xF7, 0x60, 0x2C, 0x2F, 0x50, 0x10, 0x15, 0xA2,
	0x0C, 0xA0, 0x01, 0x20, 0x3F, 0x53, 0xA2, 0x0D, 0xA0, 0x02, 0x20, 0x3F, 0x53, 0xA2, 0x0E,
	0xA0, 0x03, 0x20, 0x3F, 0x53, 0x60, 0x8E, 0x07, 0x45, 0x8C, 0xFC, 0x43, 0xA9, 0x02, 0x8D,
	0x00, 0x45, 0xA9, 0x20, 0x8D, 0xFD, 0x42, 0x4C, 0x61, 0x53, 0xA9, 0x62, 0x8D, 0x00, 0x45,
	0xA9, 0x00, 0x8D, 0xFC, 0x43, 0xA9, 0x20, 0x8D, 0xFF, 0x42, 0x2C, 0x02, 0x20, 0xA0, 0x00,
	0x8C, 0x06, 0x20, 0x8C, 0x06, 0x20, 0xA9, 0x60, 0x8D, 0x73, 0x53, 0xB9, 0x00, 0x60, 0x8D,
	0x07, 0x20, 0xC8, 0xD0, 0xF7, 0xEE, 0x73, 0x53, 0x10, 0xF2, 0x60, 0xA9, 0x72, 0x8D, 0x00,
	0x45, 0xA9, 0x20, 0x8D, 0xFF, 0x42, 0x2C, 0x02, 0x20, 0xA0, 0x20, 0x8C, 0x06, 0x20, 0xA0,
	0x00, 0x8C, 0x06, 0x20, 0xA9, 0x68, 0x8D, 0xA0, 0x53, 0xA2, 0x08, 0xB9, 0x00, 0x68, 0x8D,
	0x07, 0x20, 0xC8, 0xD0, 0xF7, 0xEE, 0xA0, 0x53, 0xCA, 0xD0, 0xF1, 0x60, 0x2C, 0x02, 0x20,
	0xA9, 0x3F, 0x8D, 0x06, 0x20, 0xA2, 0x00, 0x8E, 0x06, 0x20, 0xBD, 0x88, 0x58, 0x8D, 0x07,
	0x20, 0xE8, 0xE0, 0x20, 0x90, 0xF5, 0x60, 0x00, 0x11, 0x22, 0x00, 0x00, 0x00, 0x00, 0x2C,
	0x00, 0x45, 0x10, 0x03, 0x20, 0x21, 0x55, 0xA2, 0x01, 0x8E, 0x16, 0x40, 0xCA, 0x8E, 0x16,
	0x40, 0xA2, 0x08, 0xAD, 0x16, 0x40, 0x4A, 0x2E, 0xCA, 0x53, 0x4A, 0x2E, 0xCC, 0x53, 0xAD,
	0x17, 0x40, 0x4A, 0x2E, 0xCB, 0x53, 0x4A, 0x2E, 0xCD, 0x53, 0xCA, 0xD0, 0xE7, 0xAD, 0xCC,
	0x53, 0x0D, 0xCA, 0x53, 0x8D, 0xCA, 0x53, 0xAD, 0xCD, 0x53, 0x0D, 0xCB, 0x53, 0x8D, 0xCB,
	0x53, 0x60, 0xA9, 0x00, 0x8D, 0x00, 0x45, 0x4C, 0x25, 0xEF, 0xA9, 0x00, 0x8D, 0x01, 0x20,
	0xA9, 0x88, 0x8D, 0x00, 0x45, 0xAD, 0xFC, 0xFF, 0xC9, 0xFF, 0xD0, 0x15, 0xAD, 0xFD, 0xFF,
	0xC9, 0xFF, 0xD0, 0x0E, 0xA9, 0x02, 0x8D, 0x00, 0x45, 0x20, 0x00, 0xE4, 0xA9, 0x0A, 0x8D,
	0x01, 0x20, 0x60, 0x6C, 0xFC, 0xFF, 0xA9, 0x00, 0x8D, 0x01, 0x20, 0xA9, 0x88, 0x8D, 0x00,
	0x45, 0xAD, 0xE0, 0xE6, 0xC9, 0x49, 0xD0, 0xDE, 0xAD, 0xE1, 0xE6, 0xC9, 0x4E, 0xD0, 0xD7,
	0xAD, 0xE2, 0xE6, 0xC9, 0x2A, 0xD0, 0xD0, 0xA2, 0x88, 0xA0, 0x00, 0xA9, 0x0F, 0x8D, 0x07,
	0x45, 0x8E, 0x00, 0x45, 0xB9, 0x00, 0xE0, 0x8D, 0xFF, 0x43, 0x99, 0x00, 0x60, 0xC8, 0xD0,
	0xF1, 0xEE, 0x6B, 0x54, 0xEE, 0x71, 0x54, 0x10, 0xE9, 0xA0, 0x06, 0xB9, 0x9B, 0x54, 0x99,
	0x03, 0x06, 0x88, 0x10, 0xF7, 0xA9, 0xC0, 0x8D, 0x20, 0x50, 0xA9, 0xF0, 0x8D, 0x21, 0x50,
	0x8D, 0x27, 0x50, 0x8D, 0x2F, 0x50, 0x4C, 0x13, 0xEE, 0xA9, 0xF0, 0x8D, 0xFD, 0x42, 0x60,
	0xAD, 0x2E, 0x57, 0x8D, 0xCA, 0x53, 0xAD, 0x2F, 0x57, 0x8D, 0xCB, 0x53, 0x68, 0x68, 0x68,
	0x68, 0x60, 0xC9, 0x00, 0xD0, 0x03, 0x4C, 0x0D, 0x54, 0xC9, 0x01, 0xD0, 0x03, 0x4C, 0x13,
	0xEE, 0xC9, 0x02, 0xD0, 0x03, 0x4C, 0x15, 0x54, 0xC9, 0x03, 0xD0, 0x03, 0x4C, 0x0C, 0x51,
	0xC9, 0x04, 0xD0, 0x03, 0x4C, 0x17, 0x51, 0xC9, 0x05, 0xD0, 0x03, 0x4C, 0xA1, 0x54, 0x60,
	0x78, 0xD8, 0xAD, 0x00, 0x55, 0x8D, 0x68, 0x58, 0xAD, 0x07, 0x55, 0x8D, 0x6F, 0x58, 0xA9,
	0x02, 0x8D, 0x00, 0x45, 0x20, 0x73, 0xD6, 0xAA, 0xAD, 0x68, 0x58, 0x8D, 0x00, 0x45, 0xAD,
	0x6F, 0x58, 0x8D, 0x07, 0x45, 0x2C, 0x00, 0x45, 0x10, 0x03, 0x2C, 0x0A, 0x45, 0x60, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0xAD, 0x00, 0x55, 0x29, 0xF7, 0x8D, 0x00,
	0x45, 0x20, 0x03, 0x57, 0xC9, 0xD5, 0xD0, 0xF0, 0x20, 0x03, 0x57, 0xC9, 0xAA, 0xD0, 0xF5,
	0x20, 0x03, 0x57, 0xC9, 0x96, 0xF0, 0x07, 0xC9, 0xAD, 0xD0, 0xEA, 0x4C, 0xB5, 0x56, 0x20,
	0xF1, 0x56, 0xA2, 0x00, 0x20, 0x03, 0x57, 0x9D, 0x2B, 0x57, 0x4D, 0x30, 0x57, 0x8D, 0x30,
	0x57, 0xE8, 0xE0, 0x05, 0x90, 0xEF, 0x20, 0xF7, 0x56, 0xF0, 0x03, 0x4C, 0xE1, 0x56, 0xAD,
	0x2C, 0x57, 0x8D, 0x28, 0x57, 0xAD, 0x2D, 0x57, 0x8D, 0x29, 0x57, 0xAD, 0x2B, 0x57, 0xC9,
	0x00, 0xD0, 0x5C, 0x20, 0xF1, 0x56, 0xA0, 0x00, 0xAD, 0x2F, 0x57, 0xF0, 0x2B, 0xAD, 0x29,
	0x57, 0x8D, 0x96, 0x55, 0xAD, 0x28, 0x57, 0x8D, 0x95, 0x55, 0x2C, 0x00, 0x45, 0x10, 0xFB,
	0xAD, 0x0A, 0x45, 0x99, 0x00, 0x00, 0x4D, 0x30, 0x57, 0x8D, 0x30, 0x57, 0xC8, 0xD0, 0xEC,
	0xEE, 0x29, 0x57, 0xEE, 0x96, 0x55, 0xCE, 0x2F, 0x57, 0xD0, 0xE1, 0xAE, 0x2E, 0x57, 0xF0,
	0x1C, 0xA9, 0x8D, 0x8D, 0x27, 0x57, 0x2C, 0x00, 0x45, 0x10, 0xFB, 0xAD, 0x0A, 0x45, 0x20,
	0x27, 0x57, 0x4D, 0x30, 0x57, 0x8D, 0x30, 0x57, 0xEE, 0x28, 0x57, 0xCA, 0xD0, 0xE9, 0x20,
	0xF7, 0x56, 0x4C, 0xE5, 0x56, 0xC9, 0x01, 0xD0, 0x54, 0x20, 0xF1, 0x56, 0xA0, 0x00, 0xAD,
	0x2F, 0x57, 0xF0, 0x1E, 0xA9, 0xB9, 0x8D, 0x27, 0x57, 0x20, 0x27, 0x57, 0x48, 0x20, 0x0C,
	0x57, 0x68, 0x4D, 0x30, 0x57, 0x8D, 0x30, 0x57, 0xC8, 0xD0, 0xEF, 0xEE, 0x29, 0x57, 0xCE,
	0x2F, 0x57, 0xD0, 0xE7, 0xAE, 0x2E, 0x57, 0xF0, 0x19, 0xA9, 0xAD, 0x8D, 0x27, 0x57, 0x20,
	0x27, 0x57, 0x48, 0x20, 0x0C, 0x57, 0x68, 0x4D, 0x30, 0x57, 0x8D, 0x30, 0x57, 0xEE, 0x28,
	0x57, 0xCA, 0xD0, 0xEC, 0xAD, 0x30, 0x57, 0x20, 0x0C, 0x57, 0x2C, 0x00, 0x45, 0x30, 0xFB,
	0x4C, 0xEB, 0x56, 0xC9, 0x02, 0xD0, 0x29, 0x20, 0xAA, 0x56, 0xAD, 0x29, 0x57, 0x8D, 0x06,
	0x20, 0xAD, 0x28, 0x57, 0x8D, 0x06, 0x20, 0x20, 0xF1, 0x56, 0x20, 0x03, 0x57, 0x8D, 0x07,
	0x20, 0x4D, 0x30, 0x57, 0x8D, 0x30, 0x57, 0x20, 0xD0, 0x56, 0xD0, 0xEF, 0x20, 0xF7, 0x56,
	0x4C, 0xE5, 0x56, 0xC9, 0x03, 0xD0, 0x36, 0x20, 0xAA, 0x56, 0xAD, 0x29, 0x57, 0x8D, 0x06,
	0x20, 0xAD, 0x28, 0x57, 0x8D, 0x06, 0x20, 0xAD, 0x07, 0x20, 0x20, 0xF1, 0x56, 0xAD, 0x07,
	0x20, 0x48, 0x20, 0x0C, 0x57, 0x68, 0x4D, 0x30, 0x57, 0x8D, 0x30, 0x57, 0x20, 0xD0, 0x56,
	0xD0, 0xED, 0xAD, 0x30, 0x57, 0x20, 0x0C, 0x57, 0x2C, 0x00, 0x45, 0x30, 0xFB, 0x4C, 0xEB,
	0x56, 0xC9, 0x04, 0xD0, 0x08, 0xA9, 0x4C, 0x8D, 0x27, 0x57, 0x4C, 0x27, 0x57, 0xC9, 0x05,
	0xD0, 0x44, 0xAD, 0x2C, 0x57, 0x20, 0xB2, 0x54, 0x4C, 0xEB, 0x56, 0x2C, 0x02, 0x20, 0x30,
	0xFB, 0x2C, 0x02, 0x20, 0x10, 0xFB, 0x60, 0xA9, 0xAD, 0x8D, 0x27, 0x57, 0x20, 0x27, 0x57,
	0x20, 0x0C, 0x57, 0xEE, 0x28, 0x57, 0xD0, 0x03, 0xEE, 0x29, 0x57, 0x2C, 0x00, 0x45, 0x30,
	0xFB, 0x4C, 0xEB, 0x56, 0xAD, 0x2E, 0x57, 0xD0, 0x03, 0xCE, 0x2F, 0x57, 0xCE, 0x2E, 0x57,
	0xD0, 0x03, 0xAD, 0x2F, 0x57, 0x60, 0xA9, 0x01, 0xD0, 0x08, 0xF0, 0x04, 0xA9, 0x02, 0xD0,
	0x02, 0xA9, 0x00, 0x8D, 0x31, 0x57, 0x60, 0xA9, 0x81, 0x8D, 0x30, 0x57, 0x60, 0x2C, 0x00,
	0x45, 0x10, 0xFB, 0xAD, 0x0A, 0x45, 0x4D, 0x30, 0x57, 0x60, 0x2C, 0x00, 0x45, 0x10, 0xFB,
	0xAD, 0x0A, 0x45, 0x60, 0x2C, 0x00, 0x45, 0x30, 0xFB, 0x8D, 0x0A, 0x45, 0x2C, 0x0A, 0x45,
	0x4A, 0x4A, 0x4A, 0x4A, 0x2C, 0x00, 0x45, 0x30, 0xFB, 0x8D, 0x0A, 0x45, 0x2C, 0x0A, 0x45,
	0x60, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00
};

struct _m006 {
	BYTE prg[4];
	BYTE latch;
	struct _m006_chr {
		BYTE lock;
		BYTE reg[12];
		BYTE mmc4[2];
	} chr;
	struct _m006_mode {
		BYTE m1;
		BYTE m2m4;
		BYTE smc;
	} mode;
	struct _m006_irq {
		BYTE enable;
		DBWORD counter;
	} irq;
	struct _m006_fds {
		BYTE control;
		SWORD counter;
	} fds;
	BYTE scratch[0x1000];
} m006;
struct _m006tmp {
	BYTE *chr;
} m006tmp;

void map_init_006(void) {
	EXTCL_AFTER_MAPPER_INIT(006);
	EXTCL_CPU_INIT_PC(006);
	EXTCL_CPU_WR_MEM(006);
	EXTCL_CPU_RD_MEM(006);
	EXTCL_SAVE_MAPPER(006);
	EXTCL_WR_CHR(006);
	EXTCL_RD_CHR(006);
	EXTCL_CPU_EVERY_CYCLE(006);
	EXTCL_PPU_000_TO_255(006);
	EXTCL_PPU_256_TO_319(006);
	EXTCL_PPU_320_TO_34X(006);
	EXTCL_UPDATE_R2006(006);
	map_internal_struct_init((BYTE *)&m006, sizeof(m006));

	m006tmp.chr = NULL;

	if ((info.reset == CHANGE_ROM) || (info.reset == POWER_UP)) {
		if (chrrom_size()) {
			if (info.mapper.id != 12) {
				if (vram_size(0) < chrrom_size()) {
					vram_set_ram_size(0, chrrom_size());
					m006tmp.chr = chrrom_pnt();
				}
			} else {
				size_t old_size = prgrom_size();

				if (old_size < S512K) {
					prgrom_pnt() = realloc(prgrom_pnt(), S512K);
					prgrom_set_size(S512K);
				}
				memcpy(prgrom_pnt_byte(S256K), chrrom_pnt(),
					(chrrom_size() < (S512K - S256K) ? chrrom_size() : S512K - S256K));
			}
		} else if (info.format != NES_2_0) {
			vram_set_ram_size(0, S256K);
		}
	}

	if (info.reset == RESET) {
		m006.irq.enable = FALSE;
		m006.irq.counter = 0;
		m006.fds.control = 0;
		m006.fds.counter = 0;
	} else if (info.reset >= HARD) {
		memset(&m006, 0x00, sizeof(m006));

		if ((info.format == iNES_1_0) && (info.mapper.id == 6)) {
			info.mapper.submapper = 1;
		}
		if (info.mapper.id == 8) {
			info.mapper.id = 6;
			info.mapper.submapper = 4;
		}

		m006.mode.m1 = ((info.mapper.id == 6 ? info.mapper.submapper : 1) << 5) |
			(info.mapper.mirroring == MIRRORING_VERTICAL ? 0x01 : 0x11) | 0x02;
		m006.mode.m2m4 = (info.mapper.id == 12) || (info.mapper.id == 17) ? 0x00 : 0x03;
		m006.mode.smc = info.mapper.id == 17 ? 0x47 : 0x42;

		if (
			(info.crc32.prg == 0x6C30AE88) || // Contra (J) [hFFE].nes
			(info.crc32.prg == 0xA2D6EE34) || // Last Armageddon (J) [hFFE][b1].nes
			(info.crc32.prg == 0x2B28EE5C) || // Contra (J) [hFFE][b1].nes
			(info.crc32.prg == 0xCCA24CAF) || // Dragon Scroll - Yomigaerishi Maryuu (J) [hFFE].nes
			(info.crc32.prg == 0xDF5CA492) || // Dragon Scroll - Yomigaerishi Maryuu (J) [hFFE][a1].nes
			(info.crc32.prg == 0x9A57DB3F) || // Dragon Scroll - Yomigaerishi Maryuu (J) [hFFE][b1].nes
			(info.crc32.prg == 0x9F4CA77F)) { // Elysion (J) [hFFE].nes
			// one-screen mirroring
			m006.mode.m1 = (m006.mode.m1 & 0xEE) | 0x01;
		}

		m006.chr.lock = FALSE;
		m006.latch = 0;

		m006.prg[0] = ~3;
		m006.prg[1] = ~2;
		m006.prg[2] = ~1;
		m006.prg[3] = ~0;

		m006.chr.reg[0] = 0;
		m006.chr.reg[1] = 1;
		m006.chr.reg[2] = 2;
		m006.chr.reg[3] = 3;
		m006.chr.reg[4] = 4;
		m006.chr.reg[5] = 5;
		m006.chr.reg[6] = 6;
		m006.chr.reg[7] = 7;

		r4017.value = 0x40;
	}

	info.mapper.extend_wr = TRUE;
}
void extcl_after_mapper_init_006(void) {
	prg_fix_006();
	chr_fix_006();
	wram_fix_006();
	mirroring_fix_006();
}
void extcl_cpu_init_pc_006(BYTE nidx) {
	if (info.reset >= HARD) {
		WORD nmi_handler = 0;

		nmi_handler = prgrom_rd(nidx, 0xFFFA) | (prgrom_rd(nidx, 0xFFFB) << 8);
		if (nmi_handler == 0x5032) {
			prgrom_wr(nidx, 0xFFFA, m006.scratch[0x4F]);
			prgrom_wr(nidx, 0xFFFB, m006.scratch[0x50]);
		}
		memcpy(&m006.scratch[0], &initial_state, sizeof(m006.scratch));
		m006.scratch[0x4F] = prgrom_rd(nidx, 0xFFFA);
		m006.scratch[0x50] = prgrom_rd(nidx, 0xFFFB);
		if (info.mapper.id == 17) {
			prgrom_wr(nidx, 0xFFFA, 0x32);
			prgrom_wr(nidx, 0xFFFB, 0x50);
		}
		if (m006tmp.chr) {
			memcpy(vram_pnt(nidx), m006tmp.chr, chrrom_size());
		}
		// trainer
		if (miscrom.trainer.in_use && wram_size()) {
			WORD address = info.mapper.id != 17 ? 0x7000 :
				info.mapper.submapper == 0 ? 0x7000 :
				info.mapper.submapper << 8 | 0x5C00;

			miscrom_trainer_dst() = (address < 0x6000)
				? &m006.scratch[address & 0xF00]
				: wram_pnt_byte(address & 0x1FFF);
			nes[nidx].c.cpu.PC.w = info.mapper.id == 17 ? address : 0x5000;
		}
	}
}
void extcl_cpu_wr_mem_006(BYTE nidx, WORD address, BYTE value) {
	switch (address & 0xF000) {
		case 0x4000:
			switch (address) {
				case 0x4024:
					// FDS Write Data ($4024)
					// This register is not part of the RAM cartridge, but part of the FDS RAM adapter that originally
					// attached to it. Because the Magic Card 1M and 2M, the predecessors to the Super Magic Card, had
					// no IRQ counter of its own, a few games abuse the FDS Disk Data IRQ for frame timing and write any
					// value to this register to acknowledge a pending IRQ.
					nes[nidx].c.irq.high &= ~EXT_IRQ;
					return;
				case 0x4025:
					// FDS Control ($4025)
					// This register is not part of the RAM cartridge, but part of the FDS RAM adapter that originally
					// attached to it. Because the Magic Card 1M and 2M, the predecessors to the Super Magic Card, had
					// no IRQ counter of its own, a few games abuse the FDS Disk Data IRQ for frame timing. If bit 7 is
					// set, the FDS RAM adapter will generate IRQs every 1,792 cycles of the 21.4772 MHz master clock,
					// or after every 149+1/3 CPU cycles.
					nes[nidx].c.irq.high &= ~EXT_IRQ;
					if (!m006.irq.enable) {
						m006.fds.control = value;
						if (value & 0x42) {
							m006.fds.counter = 0;
						}
					}
					return;
				case 0x42FC:
				case 0x42FD:
				case 0x42FE:
				case 0x42FF:
					//  1M banking mode
					//A~FEDC BA98 7654 3210  D~7654 3210
					//  -------------------    ---------
					//  0100 0010 1111 11bM    BBBM ....
					//                   |+----|||+------ Set nametable mirroring type
					//                   |     |||         0: One-screen, page 0
					//                   |     |||         1: One-screen, page 1
					//                   |     |||         2: Vertical
					//                   |     |||         3: Horizontal
					//                   +-----|||------- 0: PRG memory is writeable, latch is disabled
					//                         |||        1: PRG memory is write-protected, latch is enabled
					//                         +++------- Select latch-based banking mode
					m006.mode.m1 = (value & 0xF0) | (address & 0x03);
					if (m006.mode.m1 >= 0x80) {
						// Setting modes 4-7 releases the CHR-RAM lock
						m006.chr.lock = FALSE;
					}
					prg_fix_006();
					chr_fix_006();
					mirroring_fix_006();
					return;
				case 0x43FC:
				case 0x43FD:
				case 0x43FE:
				case 0x43FF:
					//A~FEDC BA98 7654 3210  D~7654 3210
					//  -------------------    ---------
					//  0100 0011 1111 11NM    .... ..CC
					//                   ||           ++- switchable 8 KiB CHR bank #0-#3 via CC
					//                   ||
					//                   |+- 2M and 4M PRG banking mode select
					//                   |    0: Enable
					//                   |    1: Disable
					//                   +-- 2M or 4M banking mode select if M=0
					//                        0: 4M banking mode
					//                        1: 2M banking mode

					m006.mode.m2m4 = address & 0x03;
					// The CC bits are mirrors of those in the latch at $8000-$FFFF.
					m006.latch = (m006.latch & 0xFC) | (value & 0x03);
					prg_fix_006();
					chr_fix_006();
					mirroring_fix_006();
					return;
				case 0x4500:
					//D~7654 3210
					//  ---------
					//  PMWW ImNC
					//  |||| |||+- CHR-RAM mode
					//  |||| |||    0: 8 KiB
					//  |||| |||    1: 1 KiB
					//  |||| ||+-- Nametable mode
					//  |||| ||     0: Nametables from CHR memory via $4518-$451C
					//  |||| ||     1: Nametables from CIRAM, subject to mirroring via $42FC-$42FF
					//  |||| |+--- MMC4 mode
					//  |||| |      0: Enabled (ignored when C=0)
					//  |||| |      1: Disabled
					//  |||| +---- Play mode: IRQ source select
					//  ||||        0: M2 rise
					//  ||||        1: PA12 rise (unfiltered, e.g. 8 rises per scanline)
					//  ||||       GUI mode: Data source select
					//  ||||        0: Parallel port
					//  ||||        1: Floppy disk controller
					//  ||++------ Select 8 KiB WRAM bank at CPU $6000-$7FFF
					//  |+-------- Memory map
					//  |           0: GUI mode
					//  |           1: Play mode
					//  +--------- Pass-through mode
					//              0: Disabled
					//              1: Enabled, pass through all signals from cartridge connector
					m006.mode.smc = value;
					prg_fix_006();
					chr_fix_006();
					mirroring_fix_006();
					return;
				case 0x4501:
					m006.irq.enable = FALSE;
					nes[nidx].c.irq.high &= ~EXT_IRQ;
					return;
				case 0x4502:
					m006.irq.counter = (m006.irq.counter & 0xFF00) | value;
					nes[nidx].c.irq.high &= ~EXT_IRQ;
					return;
				case 0x4503:
					m006.irq.counter = (m006.irq.counter & 0x00FF) | (value << 8);
					m006.irq.enable = TRUE;
					nes[nidx].c.irq.high &= ~EXT_IRQ;
					return;
				case 0x4504:
				case 0x4505:
				case 0x4506:
				case 0x4507:
					if (m006.mode.m2m4) {
						value >>= 2;
					}
					m006.prg[address & 0x03] = value;
					prg_fix_006();
					chr_fix_006();
					mirroring_fix_006();
					return;
				case 0x4510:
				case 0x4511:
				case 0x4512:
				case 0x4513:
				case 0x4514:
				case 0x4515:
				case 0x4516:
				case 0x4517:
				case 0x4518:
				case 0x4519:
				case 0x451A:
				case 0x451B:
					m006.chr.reg[address & 0x0F] = value;
					chr_fix_006();
					mirroring_fix_006();
					return;
				default:
					return;
			}
			return;
		case 0x5000:
			m006.scratch[address & 0x0FFF] = value;
			return;
		case 0x8000:
		case 0x9000:
		case 0xA000:
		case 0xB000:
		case 0xC000:
		case 0xD000:
		case 0xE000:
		case 0xF000:
			if (m006.mode.m1 & 0x02) {
				m006.latch = value;
				if (m006.mode.m2m4 & 0x03) {
					m006.prg[(address >> 13) & 0x03] = value >> 2;
				}
				prg_fix_006();
				chr_fix_006();
				mirroring_fix_006();
			}
			return;
		default:
			return;
	}
}
BYTE extcl_cpu_rd_mem_006(BYTE nidx, WORD address, UNUSED(BYTE openbus)) {
	return (address == 0x4500 ? m006.mode.smc : wram_rd(nidx, address));
}
BYTE extcl_save_mapper_006(BYTE mode, BYTE slot, FILE *fp) {
	save_slot_ele(mode, slot, m006.prg);
	save_slot_ele(mode, slot, m006.latch);
	save_slot_ele(mode, slot, m006.chr.lock);
	save_slot_ele(mode, slot, m006.chr.reg);
	save_slot_ele(mode, slot, m006.chr.mmc4);
	save_slot_ele(mode, slot, m006.mode.m1);
	save_slot_ele(mode, slot, m006.mode.m2m4);
	save_slot_ele(mode, slot, m006.mode.smc);
	save_slot_ele(mode, slot, m006.irq.enable);
	save_slot_ele(mode, slot, m006.irq.counter);
	save_slot_ele(mode, slot, m006.fds.control);
	save_slot_ele(mode, slot, m006.fds.counter);
	save_slot_ele(mode, slot, m006.scratch);
	return (EXIT_OK);
}
void extcl_wr_chr_006(BYTE nidx, WORD address, BYTE value) {
	if ((m006.mode.m1 >= 0xA0) && !(m006.mode.m1 & 0x01)) {
		m006.chr.lock = (m006.mode.m1 & 0x10) != 0;
	}
	chr_wr(nidx, address, value);
}
BYTE extcl_rd_chr_006(BYTE nidx, WORD address) {
	if ((m006.mode.smc & 0x05) == 0x01) {
		switch (address & 0x0FF8) {
			case 0x0FD8:
			case 0x0FE8: {
				BYTE last = chr_rd(nidx, address);
				BYTE value = (address >> 4) & 0x02;
				BYTE reg = address >> 12;

				if (m006.chr.mmc4[reg] != value) {
					m006.chr.mmc4[reg] = value;
					chr_fix_006();
				};
				return (last);
			}
		}
	}
	return (chr_rd(nidx, address));
}
void extcl_cpu_every_cycle_006(BYTE nidx) {
	m006.fds.counter += 3;
	while ((m006.fds.counter >= 448) && (m006.fds.control & 0x80)) {
		nes[nidx].c.irq.high |= EXT_IRQ;
		m006.fds.counter -= 448;
	}
	if (!(m006.mode.smc & 0x08)) {
		irq_clock_006(nidx);
	}
}
void extcl_ppu_000_to_255_006(BYTE nidx) {
	if (nes[nidx].p.r2001.visible) {
		extcl_ppu_320_to_34x_006(nidx);
	}
}
void extcl_ppu_256_to_319_006(BYTE nidx) {
	if ((nes[nidx].p.ppu.frame_x & 0x0007) != 0x0003) {
		return;
	}

	if ((!nes[nidx].p.spr_ev.count_plus || (nes[nidx].p.spr_ev.tmp_spr_plus == nes[nidx].p.spr_ev.count_plus)) && (nes[nidx].p.r2000.size_spr == 16)) {
		nes[nidx].p.ppu.spr_adr = nes[nidx].p.r2000.spt_adr;
	} else {
		ppu_spr_adr((nes[nidx].p.ppu.frame_x & 0x0038) >> 3);
	}
	if ((nes[nidx].p.ppu.spr_adr & 0x1000) > (nes[nidx].p.ppu.bck_adr & 0x1000)) {
		if (m006.mode.smc & 0x08) {
			irq_clock_006(nidx);
		}
	}
}
void extcl_ppu_320_to_34x_006(BYTE nidx) {
	if ((nes[nidx].p.ppu.frame_x & 0x0007) != 0x0003) {
		return;
	}

	if (nes[nidx].p.ppu.frame_x == 323) {
		ppu_spr_adr(7);
	}

	ppu_bck_adr(nes[nidx].p.r2000.bpt_adr, nes[nidx].p.r2006.value);

	if ((nes[nidx].p.ppu.bck_adr & 0x1000) > (nes[nidx].p.ppu.spr_adr & 0x1000)) {
		if (m006.mode.smc & 0x08) {
			irq_clock_006(nidx);
		}
	}
}
void extcl_update_r2006_006(BYTE nidx, WORD new_r2006, WORD old_r2006) {
	if ((new_r2006 & 0x1000) > (old_r2006 & 0x1000)) {
		if (m006.mode.smc & 0x08) {
			irq_clock_006(nidx);
		}
	}
}

INLINE static void prg_fix_006(void) {
	BYTE enabled = !(m006.mode.m1 & 0x02);

	if (m006.mode.m2m4 & 0x01) {
		switch (m006.mode.m1 & 0xE0) {
			case 0x00:
				memmap_auto_wp_16k(0, MMCPU(0x8000), (m006.latch & 0x07), TRUE, enabled);
				memmap_auto_wp_16k(0, MMCPU(0xC000), 0x07, TRUE, enabled);
				break;
			case 0x20:
				memmap_auto_wp_16k(0, MMCPU(0x8000), ((m006.latch & 0x3C) >> 2), TRUE, enabled);
				memmap_auto_wp_16k(0, MMCPU(0xC000), 0x07, TRUE, enabled);
				break;
			case 0x40:
				memmap_auto_wp_16k(0, MMCPU(0x8000), (m006.latch & 0x0F), TRUE, enabled);
				memmap_auto_wp_16k(0, MMCPU(0xC000), 0x0F, TRUE, enabled);
				break;
			case 0x60:
				memmap_auto_wp_16k(0, MMCPU(0x8000), 0x0F, TRUE, enabled);
				memmap_auto_wp_16k(0, MMCPU(0xC000), (m006.latch & 0x0F), TRUE, enabled);
				break;
			case 0x80:
				memmap_auto_wp_32k(0, MMCPU(0x8000), ((m006.latch & 0x30) >> 4), TRUE, enabled);
				break;
			case 0xA0:
			case 0xC0:
			case 0xE0:
				memmap_auto_wp_32k(0, MMCPU(0x8000), 0x03, TRUE, enabled);
				break;
		}
	} else {
		memmap_auto_wp_8k(0, MMCPU(0x8000), m006.prg[0], TRUE, enabled);
		memmap_auto_wp_8k(0, MMCPU(0xA000), m006.prg[1], TRUE, enabled);
		memmap_auto_wp_8k(0, MMCPU(0xC000), m006.prg[2], TRUE, enabled);
		memmap_auto_wp_8k(0, MMCPU(0xE000), m006.prg[3], TRUE, enabled);
	}
}
INLINE static void chr_fix_006(void) {
	WORD bank[8];

	if (m006.mode.smc & 0x01) {
		if (m006.mode.smc & 0x04) {
			bank[0] = m006.chr.reg[0];
			bank[1] = m006.chr.reg[1];
			bank[2] = m006.chr.reg[2];
			bank[3] = m006.chr.reg[3];
			bank[4] = m006.chr.reg[4];
			bank[5] = m006.chr.reg[5];
			bank[6] = m006.chr.reg[6];
			bank[7] = m006.chr.reg[7];
		} else {
			bank[0] = m006.chr.reg[0 | m006.chr.mmc4[0]] & 0xFC;
			bank[1] = bank[0] | 0x01;
			bank[2] = bank[0] | 0x02;
			bank[3] = bank[0] | 0x03;
			bank[4] = m006.chr.reg[1 | m006.chr.mmc4[1]] & 0xFC;
			bank[5] = bank[4] | 0x01;
			bank[6] = bank[4] | 0x02;
			bank[7] = bank[4] | 0x03;
		}
	} else {
		switch (m006.mode.m1 & 0xE0) {
			default:
			case 0x00:
			case 0x40:
				bank[0] = 0;
				break;
			case 0x20:
			case 0x80:
			case 0xA0:
				bank[0] = m006.latch & 0x03;
				break;
			case 0x60:
				bank[0] = (m006.latch & 0x30) >> 4;
				break;
			case 0xC0:
				bank[0] = m006.latch & 0x01;
				break;
			case 0xE0:
				bank[0] = 3;
				break;
		}
		bank[0] = bank[0] << 3;
		bank[1] = bank[0] | 0x01;
		bank[2] = bank[0] | 0x02;
		bank[3] = bank[0] | 0x03;
		bank[4] = bank[0] | 0x04;
		bank[5] = bank[0] | 0x05;
		bank[6] = bank[0] | 0x06;
		bank[7] = bank[0] | 0x07;
	}
	{
		BYTE enabled = !(((m006.mode.m1 & 0xE1) >= 0x81) || m006.chr.lock);

		memmap_vram_wp_1k(0, MMPPU(0x0000), bank[0], TRUE, enabled);
		memmap_vram_wp_1k(0, MMPPU(0x0400), bank[1], TRUE, enabled);
		memmap_vram_wp_1k(0, MMPPU(0x0800), bank[2], TRUE, enabled);
		memmap_vram_wp_1k(0, MMPPU(0x0C00), bank[3], TRUE, enabled);
		memmap_vram_wp_1k(0, MMPPU(0x1000), bank[4], TRUE, enabled);
		memmap_vram_wp_1k(0, MMPPU(0x1400), bank[5], TRUE, enabled);
		memmap_vram_wp_1k(0, MMPPU(0x1800), bank[6], TRUE, enabled);
		memmap_vram_wp_1k(0, MMPPU(0x1C00), bank[7], TRUE, enabled);
	}
}
INLINE static void wram_fix_006(void) {
	memmap_other_4k(0, MMCPU(0x5000), 0, &m006.scratch[0], sizeof(m006.scratch), TRUE, TRUE);
}
INLINE static void mirroring_fix_006(void) {
	if (m006.mode.smc & 0x02) {
		switch (m006.mode.m1 & 0x11) {
			case 0x00:
				mirroring_SCR0(0);
				return;
			case 0x10:
				mirroring_SCR1(0);
				return;
			case 0x01:
				mirroring_V(0);
				return;
			case 0x11:
				mirroring_H(0);
				return;
		}
	} else {
		memmap_nmt_chrrom_1k(0, MMPPU(0x2000), m006.chr.reg[8]);
		memmap_nmt_chrrom_1k(0, MMPPU(0x3000), m006.chr.reg[8]);

		memmap_nmt_chrrom_1k(0, MMPPU(0x2400), m006.chr.reg[9]);
		memmap_nmt_chrrom_1k(0, MMPPU(0x3400), m006.chr.reg[9]);

		memmap_nmt_chrrom_1k(0, MMPPU(0x2800), m006.chr.reg[10]);
		memmap_nmt_chrrom_1k(0, MMPPU(0x3800), m006.chr.reg[10]);

		memmap_nmt_chrrom_1k(0, MMPPU(0x2C00), m006.chr.reg[11]);
		memmap_nmt_chrrom_1k(0, MMPPU(0x3C00), m006.chr.reg[11]);
	}
}

INLINE static void irq_clock_006(BYTE nidx) {
	if (m006.irq.enable) {
		m006.irq.counter++;
		if (m006.irq.counter >= 0x10000) {
			m006.irq.counter = 0;
			m006.irq.enable = FALSE;
			nes[nidx].c.irq.high |= EXT_IRQ;
		}
	}
}
