/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.ttflib;

import com.kreative.unicode.ttflib.DfontResource;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfontResourceType {
    private int type;
    private String typeString;
    private int count;
    private int offset;
    private List<DfontResource> resources;
    private Map<Integer, DfontResource> byId;
    private Map<String, DfontResource> byName;

    DfontResourceType() {
    }

    void readHead(DataInputStream dataInputStream) throws IOException {
        this.type = dataInputStream.readInt();
        byte[] byArray = new byte[]{(byte)(this.type >> 24), (byte)(this.type >> 16), (byte)(this.type >> 8), (byte)(this.type >> 0)};
        this.typeString = new String(byArray, "MacRoman");
        this.count = dataInputStream.readShort() + 1 & 0xFFFF;
        this.offset = dataInputStream.readShort();
    }

    void readBody(DataInputStream dataInputStream, int n, int n2, int n3, int n4) throws IOException {
        this.resources = new ArrayList<DfontResource>();
        this.byId = new TreeMap<Integer, DfontResource>();
        this.byName = new TreeMap<String, DfontResource>();
        dataInputStream.reset();
        dataInputStream.skipBytes(n2 + n3 + this.offset);
        for (int i = 0; i < this.count; ++i) {
            DfontResource dfontResource = new DfontResource();
            dfontResource.readHead(dataInputStream);
            this.resources.add(dfontResource);
            this.byId.put(dfontResource.getId(), dfontResource);
        }
        for (DfontResource dfontResource : this.resources) {
            dfontResource.readBody(dataInputStream, n, n2, n4);
            if (dfontResource.getName() == null) continue;
            this.byName.put(dfontResource.getName(), dfontResource);
        }
        this.resources = Collections.unmodifiableList(this.resources);
        this.byId = Collections.unmodifiableMap(this.byId);
        this.byName = Collections.unmodifiableMap(this.byName);
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public List<DfontResource> getResources() {
        return this.resources;
    }

    public Set<Integer> getResourceIds() {
        return this.byId.keySet();
    }

    public Set<String> getResourceNames() {
        return this.byName.keySet();
    }

    public DfontResource getResource(int n) {
        return this.byId.get(n);
    }

    public DfontResource getResource(String string) {
        return this.byName.get(string);
    }
}

