/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.EblcBitmapSize;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable1;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable2;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable3;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable4;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable5;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtableHeader;
import com.kreative.bitsnpicas.truetype.ListBasedTable;
import com.kreative.bitsnpicas.truetype.SbitTableType;
import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EblcTable
extends ListBasedTable<EblcBitmapSize> {
    public SbitTableType type;
    public int version;

    public EblcTable(SbitTableType sbitTableType) {
        this.type = sbitTableType;
        this.version = sbitTableType.version;
    }

    @Override
    public String tableName() {
        return this.type.locTableName;
    }

    @Override
    public String[] dependencyNames() {
        return new String[0];
    }

    @Override
    protected void compile(DataOutputStream dataOutputStream, TrueTypeTable[] trueTypeTableArray) throws IOException {
        int n = 8 + this.size() * 48;
        for (EblcBitmapSize eblcBitmapSize : this) {
            eblcBitmapSize.indexSubTableArrayOffset = n;
            eblcBitmapSize.indexTablesSize = eblcBitmapSize.size() * 8;
            eblcBitmapSize.numberOfIndexSubTables = eblcBitmapSize.size();
            n += eblcBitmapSize.size() * 8;
            for (EblcIndexSubtable eblcIndexSubtable : eblcBitmapSize) {
                eblcIndexSubtable.header.additionalOffsetToIndexSubtable = n - eblcBitmapSize.indexSubTableArrayOffset;
                eblcBitmapSize.indexTablesSize += 8 + eblcIndexSubtable.length();
                n += 8 + eblcIndexSubtable.length();
            }
        }
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeInt(this.size());
        for (EblcBitmapSize eblcBitmapSize : this) {
            eblcBitmapSize.write(dataOutputStream);
        }
        for (EblcBitmapSize eblcBitmapSize : this) {
            for (EblcIndexSubtable eblcIndexSubtable : eblcBitmapSize) {
                eblcIndexSubtable.header.writeElement(dataOutputStream);
            }
            for (EblcIndexSubtable eblcIndexSubtable : eblcBitmapSize) {
                eblcIndexSubtable.header.writeHeader(dataOutputStream);
                eblcIndexSubtable.write(dataOutputStream);
            }
        }
    }

    @Override
    protected void decompile(DataInputStream dataInputStream, int n, TrueTypeTable[] trueTypeTableArray) throws IOException {
        this.version = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            EblcBitmapSize eblcBitmapSize = new EblcBitmapSize();
            eblcBitmapSize.read(dataInputStream);
            this.add(eblcBitmapSize);
        }
        for (EblcBitmapSize eblcBitmapSize : this) {
            ArrayList<EblcIndexSubtableHeader> arrayList = new ArrayList<EblcIndexSubtableHeader>();
            dataInputStream.reset();
            dataInputStream.skip(eblcBitmapSize.indexSubTableArrayOffset);
            for (int i = 0; i < eblcBitmapSize.numberOfIndexSubTables; ++i) {
                EblcIndexSubtableHeader eblcIndexSubtableHeader = new EblcIndexSubtableHeader();
                eblcIndexSubtableHeader.readElement(dataInputStream);
                arrayList.add(eblcIndexSubtableHeader);
            }
            for (EblcIndexSubtableHeader eblcIndexSubtableHeader : arrayList) {
                dataInputStream.reset();
                dataInputStream.skip(eblcBitmapSize.indexSubTableArrayOffset + eblcIndexSubtableHeader.additionalOffsetToIndexSubtable);
                eblcIndexSubtableHeader.readHeader(dataInputStream);
                EblcIndexSubtable eblcIndexSubtable = EblcTable.createEblcIndexSubtable(eblcIndexSubtableHeader.indexFormat);
                eblcIndexSubtable.header = eblcIndexSubtableHeader;
                eblcIndexSubtable.read(dataInputStream);
                eblcBitmapSize.add(eblcIndexSubtable);
            }
        }
    }

    private static final EblcIndexSubtable createEblcIndexSubtable(int n) throws IOException {
        switch (n) {
            case 1: {
                return new EblcIndexSubtable1();
            }
            case 2: {
                return new EblcIndexSubtable2();
            }
            case 3: {
                return new EblcIndexSubtable3();
            }
            case 4: {
                return new EblcIndexSubtable4();
            }
            case 5: {
                return new EblcIndexSubtable5();
            }
        }
        throw new IOException("invalid indexFormat: " + n);
    }
}

