/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.CmapSubtable;
import com.kreative.bitsnpicas.truetype.CmapSubtableFormat0;
import com.kreative.bitsnpicas.truetype.CmapSubtableFormat10;
import com.kreative.bitsnpicas.truetype.CmapSubtableFormat12;
import com.kreative.bitsnpicas.truetype.CmapSubtableFormat4;
import com.kreative.bitsnpicas.truetype.CmapSubtableFormat6;
import com.kreative.bitsnpicas.truetype.CmapTableEntry;
import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import com.kreative.bitsnpicas.truetype.UnknownCmapSubtable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmapTable
extends TrueTypeTable {
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_CONTAINS_TYPE_8_OR_HIGHER = 1;
    public int version = 0;
    public final List<CmapTableEntry> entries = new ArrayList<CmapTableEntry>();
    public final List<CmapSubtable> subtables = new ArrayList<CmapSubtable>();

    private static final CmapSubtable createSubtable(int n) {
        switch (n) {
            case 0: {
                return new CmapSubtableFormat0();
            }
            case 4: {
                return new CmapSubtableFormat4();
            }
            case 6: {
                return new CmapSubtableFormat6();
            }
            case 10: {
                return new CmapSubtableFormat10();
            }
            case 12: {
                return new CmapSubtableFormat12();
            }
        }
        return new UnknownCmapSubtable(n);
    }

    public String tableName() {
        return "cmap";
    }

    public String[] dependencyNames() {
        return new String[0];
    }

    public CmapSubtable getSubtable(int n, int n2) {
        for (CmapTableEntry cmapTableEntry : this.entries) {
            if (cmapTableEntry.platformID != n || cmapTableEntry.platformSpecificID != n2) continue;
            return cmapTableEntry.subtable;
        }
        return null;
    }

    public CmapSubtable getBestSubtable() {
        CmapSubtable cmapSubtable = this.getSubtable(0, 10);
        if (cmapSubtable != null) {
            return cmapSubtable;
        }
        cmapSubtable = this.getSubtable(0, 6);
        if (cmapSubtable != null) {
            return cmapSubtable;
        }
        cmapSubtable = this.getSubtable(0, 4);
        if (cmapSubtable != null) {
            return cmapSubtable;
        }
        cmapSubtable = this.getSubtable(0, 3);
        if (cmapSubtable != null) {
            return cmapSubtable;
        }
        cmapSubtable = this.getSubtable(0, 1);
        if (cmapSubtable != null) {
            return cmapSubtable;
        }
        cmapSubtable = this.getSubtable(0, 0);
        if (cmapSubtable != null) {
            return cmapSubtable;
        }
        cmapSubtable = this.getSubtable(10, 10);
        if (cmapSubtable != null) {
            return cmapSubtable;
        }
        cmapSubtable = this.getSubtable(10, 1);
        if (cmapSubtable != null) {
            return cmapSubtable;
        }
        cmapSubtable = this.getSubtable(3, 10);
        if (cmapSubtable != null) {
            return cmapSubtable;
        }
        cmapSubtable = this.getSubtable(3, 1);
        if (cmapSubtable != null) {
            return cmapSubtable;
        }
        return null;
    }

    public int getGlyphIndex(int n) {
        CmapSubtable cmapSubtable = this.getBestSubtable();
        if (cmapSubtable != null) {
            return cmapSubtable.getGlyphIndex(n);
        }
        return 0;
    }

    protected void compile(DataOutputStream dataOutputStream, TrueTypeTable[] trueTypeTableArray) throws IOException {
        dataOutputStream.writeShort(this.version);
        dataOutputStream.writeShort(this.entries.size());
        int n = 4 + this.entries.size() * 8;
        HashMap<CmapSubtable, byte[]> hashMap = new HashMap<CmapSubtable, byte[]>();
        HashMap<CmapSubtable, Integer> hashMap2 = new HashMap<CmapSubtable, Integer>();
        for (CmapSubtable object : this.subtables) {
            byte[] byArray = object.compile();
            hashMap.put(object, byArray);
            hashMap2.put(object, n);
            n += byArray.length;
        }
        for (CmapTableEntry cmapTableEntry : this.entries) {
            dataOutputStream.writeShort(cmapTableEntry.platformID);
            dataOutputStream.writeShort(cmapTableEntry.platformSpecificID);
            dataOutputStream.writeInt((Integer)hashMap2.get(cmapTableEntry.subtable));
        }
        for (CmapSubtable cmapSubtable : this.subtables) {
            dataOutputStream.write((byte[])hashMap.get(cmapSubtable));
        }
    }

    protected void decompile(DataInputStream dataInputStream, int n, TrueTypeTable[] trueTypeTableArray) throws IOException {
        this.version = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        ArrayList<CmapSubtableInfo> arrayList = new ArrayList<CmapSubtableInfo>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(n);
        for (int i = 0; i < n2; ++i) {
            CmapSubtableInfo cmapSubtableInfo = new CmapSubtableInfo();
            cmapSubtableInfo.platformID = dataInputStream.readUnsignedShort();
            cmapSubtableInfo.platformSpecificID = dataInputStream.readUnsignedShort();
            cmapSubtableInfo.offset = dataInputStream.readInt();
            arrayList.add(cmapSubtableInfo);
            if (arrayList2.contains(cmapSubtableInfo.offset)) continue;
            arrayList2.add(cmapSubtableInfo.offset);
        }
        Collections.sort(arrayList2);
        HashMap<Integer, byte[]> hashMap = new HashMap<Integer, byte[]>();
        int n3 = (Integer)arrayList2.get(0);
        for (int i = 1; i < arrayList2.size(); ++i) {
            int n4 = (Integer)arrayList2.get(i);
            byte[] object = new byte[n4 - n3];
            dataInputStream.reset();
            dataInputStream.skipBytes(n3);
            dataInputStream.readFully(object);
            hashMap.put(n3, object);
            n3 = n4;
        }
        HashMap<Integer, CmapSubtable> hashMap2 = new HashMap<Integer, CmapSubtable>();
        for (Map.Entry entry : hashMap.entrySet()) {
            int n4 = (Integer)entry.getKey();
            byte[] byArray = (byte[])entry.getValue();
            int n5 = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            CmapSubtable cmapSubtable = CmapTable.createSubtable(n5);
            cmapSubtable.decompile(byArray);
            hashMap2.put(n4, cmapSubtable);
        }
        this.entries.clear();
        for (CmapSubtableInfo cmapSubtableInfo : arrayList) {
            CmapTableEntry cmapTableEntry = new CmapTableEntry();
            cmapTableEntry.platformID = cmapSubtableInfo.platformID;
            cmapTableEntry.platformSpecificID = cmapSubtableInfo.platformSpecificID;
            cmapTableEntry.subtable = (CmapSubtable)hashMap2.get(cmapSubtableInfo.offset);
            this.entries.add(cmapTableEntry);
        }
        this.subtables.clear();
        for (int i = 0; i < arrayList2.size() - 1; ++i) {
            int n6 = (Integer)arrayList2.get(i);
            this.subtables.add((CmapSubtable)hashMap2.get(n6));
        }
    }

    private static final class CmapSubtableInfo {
        private int platformID;
        private int platformSpecificID;
        private int offset;

        private CmapSubtableInfo() {
        }
    }
}

