/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.puaa;

import com.kreative.bitsnpicas.puaa.PuaaCodec;
import com.kreative.bitsnpicas.puaa.PuaaUtility;
import com.kreative.bitsnpicas.truetype.PuaaSubtable;
import com.kreative.bitsnpicas.truetype.PuaaSubtableEntry;
import com.kreative.bitsnpicas.truetype.PuaaTable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropListCodec
extends PuaaCodec {
    protected final String fileName;
    protected final List<String> propNames;

    protected AbstractPropListCodec(String string, List<String> list) {
        this.fileName = string;
        this.propNames = list;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String[] getPropertyNames() {
        return this.propNames.toArray(new String[this.propNames.size()]);
    }

    @Override
    public void compile(PuaaTable puaaTable, Scanner scanner) {
        Object object;
        HashMap hashMap = new HashMap();
        while (scanner.hasNextLine()) {
            String[] stringArray = PuaaUtility.splitLine(scanner.nextLine());
            if (stringArray == null || stringArray.length < 2) continue;
            try {
                int n;
                Map<Integer, Boolean> map;
                int[] numberFormatException = PuaaUtility.splitRange((String)stringArray[0]);
                object = ((String)stringArray[1]).trim();
                if (hashMap.containsKey(object)) {
                    map = (Map)hashMap.get(object);
                    for (n = numberFormatException[0]; n <= numberFormatException[1]; ++n) {
                        map.put(n, true);
                    }
                    continue;
                }
                map = new HashMap();
                for (n = numberFormatException[0]; n <= numberFormatException[1]; ++n) {
                    map.put(n, true);
                }
                hashMap.put(object, map);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = puaaTable.getOrCreateSubtable((String)entry.getKey());
            ((ArrayList)object).addAll(PuaaUtility.createEntriesFromBooleanMap((Map)entry.getValue()));
        }
    }

    @Override
    public void decompile(PuaaTable puaaTable, PrintWriter printWriter) {
        for (String string : this.propNames) {
            PuaaSubtable puaaSubtable = puaaTable.getSubtable(string);
            if (puaaSubtable == null || puaaSubtable.isEmpty()) continue;
            for (PuaaSubtableEntry.Single single : PuaaUtility.createRunsFromEntries(puaaSubtable)) {
                if (!"Y".equalsIgnoreCase(single.value)) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(PuaaUtility.joinRange(single));
                while (stringBuffer.length() < 14) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append("; ");
                stringBuffer.append(string);
                printWriter.println(stringBuffer.toString());
            }
        }
    }
}

