/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.mover;

import com.kreative.unicode.data.GlyphList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class KeyboardPanel
extends JPanel
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private final byte[] kchr;
    private final JLabel[][] labels;
    private final GlyphList encoding;
    private static final Color deadKeyColor = new Color(0xFFDD55);
    private static final int[][] keyWidths = new int[][]{{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8}, {6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6}, {7, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 9}, {9, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 7}};
    private static final int[][] keyCodes = new int[][]{{50, 18, 19, 20, 21, 23, 22, 26, 28, 25, 29, 27, 24, 51}, {48, 12, 13, 14, 15, 17, 16, 32, 34, 31, 35, 33, 30, 42}, {57, 0, 1, 2, 3, 5, 4, 38, 40, 37, 41, 39, 36}, {56, 6, 7, 8, 9, 11, 45, 46, 43, 47, 44, 10, 56}};
    private static boolean isCapsLockDown = false;

    public KeyboardPanel(byte[] byArray, GlyphList glyphList) {
        this.kchr = byArray;
        this.labels = new JLabel[4][];
        this.encoding = glyphList;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        for (int i = 0; i < keyWidths.length; ++i) {
            this.labels[i] = new JLabel[keyWidths[i].length];
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            for (int j = 0; j < keyWidths[i].length; ++j) {
                int n = keyWidths[i][j] * 6 + (j == 0 ? 2 : 1);
                int n2 = 24 + (i == 0 ? 2 : 1);
                if (i >= 2 && j == 0) {
                    ++n;
                }
                JLabel jLabel = new JLabel(" ");
                jLabel.setBorder(BorderFactory.createMatteBorder(i == 0 ? 1 : 0, j == 0 ? 1 : 0, 1, 1, Color.gray));
                jLabel.setBackground(Color.white);
                jLabel.setOpaque(true);
                jLabel.setHorizontalAlignment(0);
                jLabel.setVerticalAlignment(0);
                Dimension dimension = new Dimension(n, n2);
                jLabel.setMinimumSize(dimension);
                jLabel.setPreferredSize(dimension);
                jLabel.setMaximumSize(dimension);
                this.labels[i][j] = jLabel;
                jPanel2.add(jLabel);
            }
            jPanel.add(jPanel2);
        }
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridLayout());
        this.add(jPanel);
        this.refresh(null);
    }

    public void refresh(KeyEvent keyEvent) {
        int n = KeyboardPanel.getModifiers(keyEvent);
        int n2 = this.kchr[n + 2] & 0xFF;
        int n3 = n2 * 128 + 260;
        int n4 = (this.kchr[258] & 0xFF) << 8 | this.kchr[259] & 0xFF;
        int n5 = n4 * 128 + 262;
        int n6 = (this.kchr[n5 - 2] & 0xFF) << 8 | this.kchr[n5 - 1] & 0xFF;
        for (int i = 0; i < this.labels.length; ++i) {
            for (int j = 0; j < this.labels[i].length; ++j) {
                Integer n7;
                int n8 = keyCodes[i][j];
                boolean bl = false;
                int n9 = this.kchr[n3 + n8] & 0xFF;
                if (n9 == 0) {
                    int n10 = n5;
                    for (int k = 0; k < n6; ++k) {
                        int n11 = (this.kchr[n10 + 2] & 0xFF) << 8 | this.kchr[n10 + 3] & 0xFF;
                        int n12 = n11 * 2 + 6;
                        if ((this.kchr[n10 + 0] & 0xFF) == n2 && (this.kchr[n10 + 1] & 0xFF) == n8) {
                            bl = true;
                            n9 = this.kchr[n10 + n12 - 1] & 0xFF;
                            break;
                        }
                        n10 += n12;
                    }
                }
                if ((n7 = this.encoding.get(n9)) == null || n7 < 32) {
                    this.labels[i][j].setText(" ");
                } else {
                    this.labels[i][j].setText(new String(Character.toChars(n7)));
                }
                this.labels[i][j].setBackground(bl ? deadKeyColor : Color.white);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.refresh(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.refresh(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.refresh(keyEvent);
    }

    private static int getModifiers(KeyEvent keyEvent) {
        if (keyEvent == null) {
            return 0;
        }
        if (keyEvent.getKeyCode() == 20) {
            switch (keyEvent.getID()) {
                case 401: {
                    isCapsLockDown = true;
                    break;
                }
                case 402: {
                    isCapsLockDown = false;
                }
            }
        }
        int n = 0;
        if (keyEvent.isMetaDown()) {
            n |= 1;
        }
        if (keyEvent.isShiftDown()) {
            n |= 2;
        }
        if (isCapsLockDown) {
            n |= 4;
        }
        if (keyEvent.isAltDown()) {
            n |= 8;
        }
        if (keyEvent.isControlDown()) {
            n |= 0x10;
        }
        return n;
    }
}

