/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.mover;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FONDEntry
implements Comparable<FONDEntry> {
    public final int size;
    public final int style;
    public final int id;

    public FONDEntry(int n, int n2, int n3) {
        this.size = n;
        this.style = n2;
        this.id = n3;
    }

    public FONDEntry(DataInput dataInput) throws IOException {
        this.size = dataInput.readShort();
        this.style = dataInput.readShort();
        this.id = dataInput.readShort();
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.size);
        dataOutput.writeShort(this.style);
        dataOutput.writeShort(this.id);
    }

    @Override
    public int compareTo(FONDEntry fONDEntry) {
        if (this.size != fONDEntry.size) {
            return this.size - fONDEntry.size;
        }
        if (this.style != fONDEntry.style) {
            return this.style - fONDEntry.style;
        }
        return this.id - fONDEntry.id;
    }

    public boolean equals(Object object) {
        if (object instanceof FONDEntry) {
            FONDEntry fONDEntry = (FONDEntry)object;
            return this.size == fONDEntry.size && this.style == fONDEntry.style && this.id == fONDEntry.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id << 16 ^ this.style << 8 ^ this.size;
    }

    public String toString() {
        return "[" + this.toString("FONDEntry") + " -> " + this.id + "]";
    }

    public String toString(String string) {
        if (this.style != 0) {
            string = string + " (" + FONDEntry.styleString(this.style) + ")";
        }
        if (this.size != 0) {
            string = string + " " + this.size;
        }
        return string;
    }

    private static String styleString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("bold");
        }
        if ((n & 2) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("italic");
        }
        if ((n & 4) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("underline");
        }
        if ((n & 8) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("outline");
        }
        if ((n & 0x10) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("shadow");
        }
        if ((n & 0x20) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("condensed");
        }
        if ((n & 0x40) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("extended");
        }
        if ((n & 0x80) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("group");
        }
        return stringBuffer.toString();
    }
}

