/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.truetype.TrueTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class TTFRewriteTest {
    public static void main(String[] stringArray) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        for (String string : stringArray) {
            if (bl3 && string.startsWith("-")) {
                if (string.equals("--")) {
                    bl3 = false;
                    continue;
                }
                if (string.equals("-i")) {
                    bl = true;
                    continue;
                }
                if (string.equals("-n")) {
                    bl = false;
                    continue;
                }
                if (string.equals("-w")) {
                    bl2 = true;
                    continue;
                }
                if (string.equals("-q")) {
                    bl2 = false;
                    continue;
                }
                System.err.println("Unknown option: " + string);
                continue;
            }
            File file = new File(string);
            System.out.print("Testing " + file.getName() + "...");
            try {
                if (TTFRewriteTest.rewriteTest(file, bl, bl2)) {
                    System.out.println(" SAME");
                    continue;
                }
                System.out.println(" DIFF");
            }
            catch (IOException iOException) {
                System.out.println(" ERROR: " + iOException);
            }
        }
    }

    public static boolean rewriteTest(File file, boolean bl, boolean bl2) throws IOException {
        long l = file.length();
        if (l < 12L) {
            throw new IOException("file too small");
        }
        if (l > Integer.MAX_VALUE) {
            throw new IOException("file too large");
        }
        byte[] byArray = new byte[(int)l];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        TrueTypeFile trueTypeFile = new TrueTypeFile();
        trueTypeFile.interpret = bl;
        trueTypeFile.decompile(byArray);
        byte[] byArray2 = trueTypeFile.compile();
        if (Arrays.equals(byArray, byArray2)) {
            return true;
        }
        if (bl2) {
            File file2 = new File(file.getName() + ".diff");
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray2);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        return false;
    }
}

