/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.truetype.SvgTable;
import com.kreative.bitsnpicas.truetype.SvgTableEntry;
import com.kreative.bitsnpicas.truetype.TrueTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.HashMap;

public class ExtractSvg {
    public static void main(String[] stringArray) {
        try {
            System.setProperty("apple.awt.UIElement", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String string : stringArray) {
            File file = new File(string);
            System.out.print("Processing " + file.getAbsolutePath() + "... ");
            try {
                int n;
                BitSet bitSet;
                byte[] byArray = new byte[(int)file.length()];
                FileInputStream fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
                fileInputStream.close();
                TrueTypeFile trueTypeFile = new TrueTypeFile();
                trueTypeFile.decompile(byArray);
                SvgTable svgTable = (SvgTable)trueTypeFile.getByTableName("SVG ");
                if (svgTable == null) {
                    System.out.println("no svg table found.");
                    continue;
                }
                File file2 = new File(file.getParent(), file.getName() + ".svg.d");
                if (!file2.exists()) {
                    file2.mkdir();
                }
                HashMap<byte[], BitSet> hashMap = new HashMap<byte[], BitSet>();
                for (SvgTableEntry svgTableEntry : svgTable) {
                    if (svgTableEntry.svgDocument.length <= 0) continue;
                    bitSet = (BitSet)hashMap.get(svgTableEntry.svgDocument);
                    if (bitSet == null) {
                        bitSet = new BitSet();
                        hashMap.put(svgTableEntry.svgDocument, bitSet);
                    }
                    int n2 = Math.min(svgTableEntry.startGlyphID, svgTableEntry.endGlyphID);
                    n = Math.max(svgTableEntry.startGlyphID, svgTableEntry.endGlyphID) + 1;
                    bitSet.set(n2, n);
                }
                for (SvgTableEntry svgTableEntry : svgTable) {
                    if (!hashMap.containsKey(svgTableEntry.svgDocument)) continue;
                    bitSet = (BitSet)hashMap.remove(svgTableEntry.svgDocument);
                    StringBuffer stringBuffer = new StringBuffer();
                    n = bitSet.nextSetBit(0);
                    while (n >= 0) {
                        int n3 = bitSet.nextClearBit(n);
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append("+");
                        }
                        stringBuffer.append(n);
                        if (n3 - 1 > n) {
                            stringBuffer.append("-");
                            stringBuffer.append(n3 - 1);
                        }
                        n = bitSet.nextSetBit(n3);
                    }
                    String string2 = "glyph_" + stringBuffer.toString();
                    File file3 = new File(file2, string2 + ".svg");
                    ExtractSvg.copyAndClose(svgTableEntry.getInputStream(), new FileOutputStream(file3));
                }
                System.out.println("done.");
            }
            catch (Exception exception) {
                System.out.println("failed (" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ").");
                exception.printStackTrace();
            }
        }
    }

    private static void copyAndClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();
    }
}

