/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SRFontBitmapFontImporter
implements BitmapFontImporter {
    private static final int TRANSPARENT = 0;
    private static final int RED = 1152;
    private static final int ORANGE = 1160;
    private static final int YELLOW = 1168;
    private static final int GREEN = 1040;
    private static final int CYAN = 1042;
    private static final int BLUE = 1026;
    private static final int VIOLET = 1090;
    private static final int MAGENTA = 1154;
    private static final int MAX_ASCENT = 0;
    private static final int LINE_ASCENT = 1;
    private static final int EM_ASCENT = 2;
    private static final int X_HEIGHT = 3;
    private static final int EM_DESCENT = 4;
    private static final int LINE_DESCENT = 5;
    private static final int MAX_DESCENT = 6;
    private static final int LINE_GAP = 7;

    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BitmapFont[] bitmapFontArray = this.importFont(byteArrayInputStream);
        byteArrayInputStream.close();
        return bitmapFontArray;
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix("png");
        ImageReader imageReader = iterator.next();
        imageReader.setInput(ImageIO.createImageInputStream(inputStream));
        BufferedImage bufferedImage = imageReader.read(0);
        BitmapFont bitmapFont = this.importFont(bufferedImage);
        if (bitmapFont == null) {
            return new BitmapFont[0];
        }
        IIOImage iIOImage = imageReader.readAll(0, null);
        IIOMetadata iIOMetadata = iIOImage.getMetadata();
        String string = iIOMetadata.getNativeMetadataFormatName();
        Node node = iIOMetadata.getAsTree(string);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!"tEXt".equals(node2.getNodeName())) continue;
            for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                if (!"tEXtEntry".equals(node3.getNodeName())) continue;
                NamedNodeMap namedNodeMap = node3.getAttributes();
                String string2 = namedNodeMap.getNamedItem("keyword").getNodeValue();
                String string3 = namedNodeMap.getNamedItem("value").getNodeValue();
                if ("FontFamily".equals(string2)) {
                    bitmapFont.setName(1, string3);
                }
                if ("FontStyle".equals(string2)) {
                    bitmapFont.setName(2, string3);
                }
                if (!"Copyright".equals(string2)) continue;
                bitmapFont.setName(0, string3);
            }
        }
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BitmapFont[] bitmapFontArray = this.importFont(fileInputStream);
        fileInputStream.close();
        return bitmapFontArray;
    }

    public boolean canImportFont(BufferedImage bufferedImage) {
        return bufferedImage != null && this.decodeVM(bufferedImage, 0, 0, bufferedImage.getHeight()) != null;
    }

    public BitmapFont importFont(BufferedImage bufferedImage) {
        int n;
        int[] nArray = this.decodeVM(bufferedImage, 0, 0, bufferedImage.getHeight());
        if (nArray == null) {
            return null;
        }
        int n2 = 1 + nArray[0] + nArray[6] + nArray[7];
        int n3 = this.decodeCC(bufferedImage, 1, 0, n2);
        if (n3 < 0) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            int n10 = 0;
            int n11 = bufferedImage.getWidth();
            while (n10 < n11) {
                int n12 = 0;
                int n13 = 0;
                while (n10 < n11 && this.decodeControlPixel(bufferedImage.getRGB(n10, 0)) == 1154) {
                    ++n10;
                    ++n12;
                }
                while (n10 < n11 && this.decodeControlPixel(bufferedImage.getRGB(n10, 0)) != 1154) {
                    ++n10;
                    ++n13;
                }
                arrayList.add(n12);
                arrayList2.add(n13);
            }
            int[] nArray2 = new int[arrayList.size() - 1];
            int[] nArray3 = new int[arrayList.size() - 1];
            int[] nArray4 = new int[arrayList.size() - 1];
            byte[][][] byArrayArray = new byte[arrayList.size() - 1][][];
            n10 = 0;
            int n14 = 0;
            for (n9 = 0; n9 < nArray2.length; ++n9) {
                nArray2[n9] = n9 == 0 ? (Integer)arrayList.get(n9) : ((Integer)arrayList.get(n9) + 1) / 2;
                nArray3[n9] = (Integer)arrayList2.get(n9);
                nArray4[n9] = n9 == nArray2.length - 1 ? (Integer)arrayList.get(n9 + 1) : (Integer)arrayList.get(n9 + 1) / 2;
                int n15 = nArray2[n9] + nArray3[n9] + nArray4[n9];
                byArrayArray[n9] = new byte[n2 - 1][n15];
                for (n8 = 0; n8 < byArrayArray[n9].length; ++n8) {
                    for (n7 = 0; n7 < n15; ++n7) {
                        byArrayArray[n9][n8][n7] = (byte)(bufferedImage.getRGB(n10 + n7, 1 + n8) >> 24 & 0xFF);
                    }
                }
                n10 += n15;
                n14 += nArray3[n9];
            }
            n9 = 55;
            if (n9 < byArrayArray.length) {
                byte[][] byArray = byArrayArray[n9];
                for (n8 = 0; n8 < byArray.length && this.arrayEmpty(byArray[n8]); ++n8) {
                    nArray[2] = nArray[2] - 1;
                }
            }
            if ((n6 = 87) < byArrayArray.length) {
                byte[][] byArray = byArrayArray[n6];
                for (n7 = 0; n7 < byArray.length && this.arrayEmpty(byArray[n7]); ++n7) {
                    nArray[3] = nArray[3] - 1;
                }
                for (n7 = byArray.length - 1; n7 >= 0 && this.arrayEmpty(byArray[n7]); --n7) {
                    nArray[0] = nArray[0] - 1;
                    nArray[1] = nArray[1] - 1;
                    nArray[2] = nArray[2] - 1;
                    nArray[3] = nArray[3] - 1;
                    nArray[4] = nArray[4] + 1;
                    nArray[5] = nArray[5] + 1;
                    nArray[6] = nArray[6] + 1;
                }
            }
            if ((n5 = 88) < byArrayArray.length) {
                byte[][] byArray = byArrayArray[n5];
                for (n4 = byArray.length - 1; n4 >= 0 && this.arrayEmpty(byArray[n4]); --n4) {
                    nArray[4] = nArray[4] - 1;
                }
            }
            BitmapFont bitmapFont = new BitmapFont(nArray[2], nArray[4], nArray[1], nArray[5], nArray[3], nArray[3], nArray[7]);
            bitmapFont.putCharacter(32, new BitmapFontGlyph(new byte[n2 - 1][n14 / byArrayArray.length], 0, n14 / byArrayArray.length, nArray[0]));
            for (n4 = 0; n4 < byArrayArray.length; ++n4) {
                bitmapFont.putCharacter(n4 + 33, new BitmapFontGlyph(byArrayArray[n4], -nArray2[n4], nArray3[n4], nArray[0]));
            }
            bitmapFont.setCapHeight();
            return bitmapFont;
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap3 = new HashMap<Integer, Integer>();
        HashMap<Integer, byte[][]> hashMap4 = new HashMap<Integer, byte[][]>();
        int n16 = bufferedImage.getHeight();
        int n17 = bufferedImage.getWidth();
        int n18 = 0;
        while (n18 + n2 <= n16) {
            int n19 = 1;
            while (n19 < n17 && (n = this.decodeCC(bufferedImage, n19, n18, n2)) >= 0 && n < 0x110000) {
                int n20 = ++n19;
                int n21 = 0;
                int n22 = 0;
                int n23 = 0;
                while (n19 < n17 && this.decodeControlPixel(bufferedImage.getRGB(n19, n18)) == 1152) {
                    ++n19;
                    ++n21;
                }
                while (n19 < n17 && this.decodeControlPixel(bufferedImage.getRGB(n19, n18)) == 0) {
                    ++n19;
                    ++n22;
                }
                while (n19 < n17 && this.decodeControlPixel(bufferedImage.getRGB(n19, n18)) == 1026) {
                    ++n19;
                    ++n23;
                }
                int n24 = n21 + n22 + n23;
                byte[][] byArray = new byte[n2 - 1][n24];
                for (int i = 0; i < byArray.length; ++i) {
                    for (int j = 0; j < n24; ++j) {
                        byArray[i][j] = (byte)(bufferedImage.getRGB(n20 + j, n18 + 1 + i) >> 24 & 0xFF);
                    }
                }
                hashMap.put(n, n21);
                hashMap2.put(n, n22);
                hashMap3.put(n, n23);
                hashMap4.put(n, byArray);
            }
            n18 += n2;
        }
        BitmapFont bitmapFont = new BitmapFont(nArray[2], nArray[4], nArray[1], nArray[5], nArray[3], nArray[3], nArray[7]);
        Iterator iterator = hashMap4.keySet().iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            bitmapFont.putCharacter(n, new BitmapFontGlyph((byte[][])hashMap4.get(n), -((Integer)hashMap.get(n)).intValue(), (Integer)hashMap2.get(n), nArray[0]));
        }
        bitmapFont.setCapHeight();
        return bitmapFont;
    }

    private int decodeControlPixel(int n) {
        int n2 = (n >> 24 & 0xFF) / 86;
        if (n2 == 0) {
            return 0;
        }
        int n3 = (n >> 16 & 0xFF) / 86;
        int n4 = (n >> 8 & 0xFF) / 86;
        int n5 = (n >> 0 & 0xFF) / 86;
        return n2 << 9 | n3 << 6 | n4 << 3 | n5;
    }

    private int[] decodeVM(BufferedImage bufferedImage, int n, int n2, int n3) {
        if (this.decodeControlPixel(bufferedImage.getRGB(n, n2)) != 1154) {
            return null;
        }
        int[] nArray = new int[8];
        ++n2;
        while (n2 < n3) {
            switch (this.decodeControlPixel(bufferedImage.getRGB(n, n2))) {
                case 0: {
                    nArray[3] = nArray[3] + 1;
                }
                case 1168: {
                    nArray[2] = nArray[2] + 1;
                }
                case 1160: {
                    nArray[1] = nArray[1] + 1;
                }
                case 1152: {
                    nArray[0] = nArray[0] + 1;
                    break;
                }
                case 1040: {
                    nArray[4] = nArray[4] + 1;
                }
                case 1042: {
                    nArray[5] = nArray[5] + 1;
                }
                case 1026: {
                    nArray[6] = nArray[6] + 1;
                    break;
                }
                case 1090: {
                    nArray[7] = nArray[7] + 1;
                    break;
                }
                case 1154: {
                    return nArray;
                }
                default: {
                    return null;
                }
            }
            ++n2;
        }
        return nArray;
    }

    private int decodeCC(BufferedImage bufferedImage, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = bufferedImage.getRGB(n, n2);
        if ((n6 >> 24 & 0xFF) < 170 || (n6 >> 16 & 0xFF) < 170 || (n6 >> 8 & 0xFF) > 85 || (n6 >> 0 & 0xFF) < 170) {
            return -1;
        }
        for (n5 = 1; n5 < n3; ++n5) {
            n4 = bufferedImage.getRGB(n, n2 + n5);
            if ((n4 >> 24 & 0xFF) >= 170) continue;
            return -1;
        }
        if (n3 >= 22) {
            n5 = bufferedImage.getRGB(n, n2 + 16) & 0xFFFFFF;
            n4 = bufferedImage.getRGB(n, n2 + 17) & 0xFFFFFF;
            int n7 = bufferedImage.getRGB(n, n2 + 18) & 0xFFFFFF;
            int n8 = bufferedImage.getRGB(n, n2 + 19) & 0xFFFFFF;
            int n9 = bufferedImage.getRGB(n, n2 + 20) & 0xFFFFFF;
            int n10 = bufferedImage.getRGB(n, n2 + 21) & 0xFFFFFF;
            int n11 = ((n5 >> 20 & 0xF) + (n5 >> 12 & 0xF) + (n5 >> 4 & 0xF)) / 3;
            int n12 = ((n4 >> 20 & 0xF) + (n4 >> 12 & 0xF) + (n4 >> 4 & 0xF)) / 3;
            int n13 = ((n7 >> 20 & 0xF) + (n7 >> 12 & 0xF) + (n7 >> 4 & 0xF)) / 3;
            int n14 = ((n8 >> 20 & 0xF) + (n8 >> 12 & 0xF) + (n8 >> 4 & 0xF)) / 3;
            int n15 = ((n9 >> 20 & 0xF) + (n9 >> 12 & 0xF) + (n9 >> 4 & 0xF)) / 3;
            int n16 = ((n10 >> 20 & 0xF) + (n10 >> 12 & 0xF) + (n10 >> 4 & 0xF)) / 3;
            return n11 << 20 | n12 << 16 | n13 << 12 | n14 << 8 | n15 << 4 | n16;
        }
        if (n3 >= 11) {
            n5 = bufferedImage.getRGB(n, n2 + 7) & 0xFFFFFF;
            n4 = bufferedImage.getRGB(n, n2 + 8) & 0xFFFFFF;
            int n17 = bufferedImage.getRGB(n, n2 + 9) & 0xFFFFFF;
            int n18 = bufferedImage.getRGB(n, n2 + 10) & 0xFFFFFF;
            int n19 = ((n5 >> 20 & 0xF) + (n5 >> 12 & 0xF)) / 2;
            int n20 = ((n5 >> 4 & 0xF) + (n4 >> 20 & 0xF)) / 2;
            int n21 = ((n4 >> 12 & 0xF) + (n4 >> 4 & 0xF)) / 2;
            int n22 = ((n17 >> 20 & 0xF) + (n17 >> 12 & 0xF)) / 2;
            int n23 = ((n17 >> 4 & 0xF) + (n18 >> 20 & 0xF)) / 2;
            int n24 = ((n18 >> 12 & 0xF) + (n18 >> 4 & 0xF)) / 2;
            return n19 << 20 | n20 << 16 | n21 << 12 | n22 << 8 | n23 << 4 | n24;
        }
        if (n3 >= 7) {
            n5 = bufferedImage.getRGB(n, n2 + 4) & 0xFFFFFF;
            n4 = bufferedImage.getRGB(n, n2 + 5) & 0xFFFFFF;
            int n25 = bufferedImage.getRGB(n, n2 + 6) & 0xFFFFFF;
            int n26 = n5 >> 20 & 0xF;
            int n27 = n5 >> 4 & 0xF;
            int n28 = n4 >> 20 & 0xF;
            int n29 = n4 >> 4 & 0xF;
            int n30 = n25 >> 20 & 0xF;
            int n31 = n25 >> 4 & 0xF;
            return n26 << 20 | n27 << 16 | n28 << 12 | n29 << 8 | n30 << 4 | n31;
        }
        if (n3 >= 4) {
            n5 = bufferedImage.getRGB(n, n2 + 2) & 0xFFFFFF;
            n4 = bufferedImage.getRGB(n, n2 + 3) & 0xFFFFFF;
            int n32 = n5 >> 20 & 0xF;
            int n33 = n5 >> 12 & 0xF;
            int n34 = n5 >> 4 & 0xF;
            int n35 = n4 >> 20 & 0xF;
            int n36 = n4 >> 12 & 0xF;
            int n37 = n4 >> 4 & 0xF;
            return n32 << 20 | n33 << 16 | n34 << 12 | n35 << 8 | n36 << 4 | n37;
        }
        if (n3 >= 2) {
            return bufferedImage.getRGB(n, n2 + 1) & 0xFFFFFF;
        }
        return -1;
    }

    private boolean arrayEmpty(byte[] byArray) {
        for (byte by : byArray) {
            if (by == 0) continue;
            return false;
        }
        return true;
    }
}

