/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SBFBitmapFontImporter
implements BitmapFontImporter {
    private GlyphList encoding;
    private static final int[] C0 = new int[]{0, 715, 733, 729, 730, 711, 728, 731, 8, 9, 10, 11, 12, 13, 64257, 64258, 63743, 8260, 8730, 8721, 8719, 8747, 8710, 937, 960, 8706, 8734, 27, 8804, 8800, 8805, 8776};
    private static final int[] C1 = new int[]{8364, 9674, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 321, 381, 305, 8984, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 322, 382, 376};

    public SBFBitmapFontImporter() {
        this.encoding = null;
    }

    public SBFBitmapFontImporter(GlyphList glyphList) {
        this.encoding = glyphList;
    }

    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        if (dataInputStream.readInt() != 280067676) {
            throw new IOException("bad magic number");
        }
        dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        int n3 = dataInputStream.readUnsignedByte();
        int n4 = dataInputStream.readUnsignedByte();
        BitmapFont bitmapFont = new BitmapFont(n3, n4, n3, n4, 0, 0, n2 - n3 - n4);
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[256];
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        int[] nArray6 = new int[256];
        int[] nArray7 = new int[256];
        for (n = 1; n < 256; ++n) {
            nArray[n] = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
            nArray2[n] = dataInputStream.readUnsignedByte();
            nArray3[n] = dataInputStream.readUnsignedByte();
            nArray4[n] = dataInputStream.readByte();
            nArray5[n] = dataInputStream.readByte();
            nArray6[n] = dataInputStream.readUnsignedByte();
            nArray7[n] = dataInputStream.readUnsignedByte();
        }
        for (n = 0; n < 256; ++n) {
            int n5;
            if (nArray[n] <= 0) continue;
            int n6 = nArray2[n] * 8 - nArray7[n];
            byte[][] byArray2 = new byte[nArray3[n]][n6];
            int n7 = nArray[n];
            for (n5 = 0; n7 < byArray.length && n5 < byArray2.length; n7 += nArray2[n], ++n5) {
                int n8 = n7;
                for (int i = 0; n8 < byArray.length && i < n6; ++n8, i += 8) {
                    int n9 = 128;
                    for (int j = i; n9 != 0 && j < n6; n9 >>= 1, ++j) {
                        if ((byArray[n8] & n9) == 0) continue;
                        byArray2[n5][j] = -1;
                    }
                }
            }
            BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph(byArray2, nArray4[n], nArray6[n], nArray5[n]);
            int n10 = n5 = this.encoding != null ? this.encoding.get(n) : SBFBitmapFontImporter.fromSuperLatin(n);
            if (n5 < 0) continue;
            bitmapFont.putCharacter(n5, bitmapFontGlyph);
        }
        dataInputStream.close();
        bitmapFont.setXHeight();
        bitmapFont.setCapHeight();
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[0x100000];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        return this.importFont(byteArrayOutputStream.toByteArray());
    }

    public BitmapFont[] importFont(File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[0x100000];
        while ((n = fileInputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        fileInputStream.close();
        BitmapFont[] bitmapFontArray = this.importFont(byteArrayOutputStream.toByteArray());
        if (bitmapFontArray.length > 0) {
            String string = file.getName();
            if (string.toLowerCase().endsWith(".sbf")) {
                string = string.substring(0, string.length() - 4);
            }
            for (BitmapFont bitmapFont : bitmapFontArray) {
                bitmapFont.setName(1, string);
            }
        }
        return bitmapFontArray;
    }

    private static int fromSuperLatin(int n) {
        if ((n &= 0xFF) < 32) {
            return C0[n];
        }
        if (n < 128) {
            return n;
        }
        if (n < 160) {
            return C1[n & 0x1F];
        }
        return n;
    }
}

