/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos.mover;

import com.kreative.bitsnpicas.datatransfer.ImageSelection;
import com.kreative.bitsnpicas.geos.GEOSIcons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GEOSIconWell
extends JComponent {
    private static final long serialVersionUID = 1L;
    private byte[] iconData;
    private BufferedImage iconImage;

    public GEOSIconWell() {
        this.resetIcon();
        this.init();
    }

    public GEOSIconWell(byte[] byArray) {
        this.setIcon(byArray);
        this.init();
    }

    public GEOSIconWell(Image image) {
        this.setIcon(image);
        this.init();
    }

    private void init() {
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                GEOSIconWell.this.requestFocusInWindow();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                GEOSIconWell.this.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                GEOSIconWell.this.repaint();
            }
        });
        InputMap inputMap = this.getInputMap();
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        inputMap.put(KeyStroke.getKeyStroke(88, n), "Cut");
        inputMap.put(KeyStroke.getKeyStroke(67, n), "Copy");
        inputMap.put(KeyStroke.getKeyStroke(86, n), "Paste");
        inputMap.put(KeyStroke.getKeyStroke(127, n), "Clear");
        inputMap.put(KeyStroke.getKeyStroke(8, n), "Clear");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("Cut", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GEOSIconWell.this.doCut();
            }
        });
        actionMap.put("Copy", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GEOSIconWell.this.doCopy();
            }
        });
        actionMap.put("Paste", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GEOSIconWell.this.doPaste();
            }
        });
        actionMap.put("Clear", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GEOSIconWell.this.resetIcon();
            }
        });
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 1, new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                dragGestureEvent.startDrag(null, new ImageSelection(GEOSIconWell.this.iconImage));
            }
        });
        new DropTarget(this, new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                try {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                        Image image = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                        GEOSIconWell.this.setIcon(image);
                        dropTargetDropEvent.dropComplete(true);
                    } else {
                        dropTargetDropEvent.dropComplete(false);
                    }
                }
                catch (Exception exception) {
                    dropTargetDropEvent.dropComplete(false);
                }
            }
        });
    }

    public byte[] getIconData() {
        return this.iconData;
    }

    public BufferedImage getIconImage() {
        return this.iconImage;
    }

    public void resetIcon() {
        this.iconData = GEOSIcons.fontIcon();
        this.iconImage = GEOSIcons.toImage(this.iconData);
        this.repaint();
        this.fireChangeEvent();
    }

    public void setIcon(byte[] byArray) {
        this.iconData = byArray;
        this.iconImage = GEOSIcons.toImage(byArray);
        this.repaint();
        this.fireChangeEvent();
    }

    public void setIcon(Image image) {
        BufferedImage bufferedImage = new BufferedImage(24, 21, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, 24, 21, null);
        graphics2D.dispose();
        this.iconData = GEOSIcons.fromImage(bufferedImage, 0, 0);
        this.iconImage = GEOSIcons.toImage(this.iconData);
        this.repaint();
        this.fireChangeEvent();
    }

    public void doCut() {
        this.doCopy();
        this.resetIcon();
    }

    public void doCopy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new ImageSelection(this.iconImage), new ClipboardOwner(){

            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            }
        });
    }

    public void doPaste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
            try {
                Image image = (Image)clipboard.getData(DataFlavor.imageFlavor);
                if (image != null) {
                    this.setIcon(image);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.getChangeListeners()) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        int n = 52 + insets.left + insets.right;
        int n2 = 46 + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int n = 52 + insets.left + insets.right;
        int n2 = 46 + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    protected void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right - 4;
        int n2 = this.getHeight() - insets.top - insets.bottom - 4;
        int n3 = Math.max(1, Math.min(n / 24, n2 / 21));
        int n4 = insets.left + (n - n3 * 24) / 2 + 2;
        int n5 = insets.top + (n2 - n3 * 21) / 2 + 2;
        n = n3 * 24;
        n2 = n3 * 21;
        if (this.hasFocus()) {
            graphics.setColor(new Color(0x99CCDD));
            graphics.fillRect(n4 - 2, n5 - 2, n + 4, n2 + 4);
        } else {
            graphics.setColor(new Color(0xEEEEEE));
            graphics.fillRect(n4, n5, n, n2);
        }
        if (this.iconImage != null) {
            graphics.drawImage(this.iconImage, n4, n5, n, n2, null);
        }
    }
}

