/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos;

import com.kreative.bitsnpicas.geos.CBMDirectoryBlock;
import com.kreative.bitsnpicas.geos.GEOSInfoBlock;
import com.kreative.bitsnpicas.geos.VLIRRecordBlock;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GEOSList {
    public static void main(String[] stringArray) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        boolean bl = false;
        if (stringArray.length == 0) {
            stringArray = new String[]{"."};
        }
        for (String string : stringArray) {
            if (string.equals("-r")) {
                bl = true;
                continue;
            }
            GEOSList.process(printWriter, new File(string), bl);
        }
    }

    private static void process(PrintWriter printWriter, File file, boolean bl) {
        block9: {
            block8: {
                if (!file.isDirectory()) break block8;
                for (File file2 : file.listFiles()) {
                    if (file2.getName().startsWith(".") || !bl && !file2.isFile()) continue;
                    GEOSList.process(printWriter, file2, bl);
                }
                break block9;
            }
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".cvt")) break block9;
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                CBMDirectoryBlock cBMDirectoryBlock = new CBMDirectoryBlock();
                cBMDirectoryBlock.read(new DataInputStream(fileInputStream));
                if (cBMDirectoryBlock.geosFileType != 0) {
                    GEOSInfoBlock gEOSInfoBlock = new GEOSInfoBlock();
                    gEOSInfoBlock.read(new DataInputStream(fileInputStream));
                    printWriter.print(gEOSInfoBlock.getIconString());
                    printWriter.println(cBMDirectoryBlock.getFileName(true, true));
                    printWriter.println("Class: " + GEOSList.safe(gEOSInfoBlock.getClassTextString()));
                    if (gEOSInfoBlock.hasAuthorString()) {
                        printWriter.println("Author: " + GEOSList.safe(gEOSInfoBlock.getAuthorString()));
                    }
                    if (gEOSInfoBlock.hasCreatorString()) {
                        printWriter.println("Creator: " + GEOSList.safe(gEOSInfoBlock.getCreatorString()));
                    }
                    printWriter.println("Description: " + GEOSList.safe(gEOSInfoBlock.getDescriptionString()));
                    if (gEOSInfoBlock.geosFileType == 8) {
                        printWriter.println("Font ID: " + GEOSList.getFontID(gEOSInfoBlock));
                        printWriter.println("Point Sizes: " + GEOSList.join(GEOSList.getFontPointSizes(gEOSInfoBlock)));
                    }
                    if (gEOSInfoBlock.fileStructure == 1) {
                        VLIRRecordBlock vLIRRecordBlock = new VLIRRecordBlock();
                        vLIRRecordBlock.read(new DataInputStream(fileInputStream));
                        printWriter.println("VLIR Records: " + GEOSList.join(GEOSList.listRecords(vLIRRecordBlock)));
                    }
                    printWriter.println();
                }
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String safe(String string) {
        return string.replaceAll("[^!-~]+", " ");
    }

    private static int getFontID(GEOSInfoBlock gEOSInfoBlock) {
        return gEOSInfoBlock.getByte(128) & 0xFF | (gEOSInfoBlock.getByte(129) & 0xFF) << 8;
    }

    private static List<Integer> getFontPointSizes(GEOSInfoBlock gEOSInfoBlock) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 130;
        int n3 = 0;
        while (n3 < 15 && (n = gEOSInfoBlock.getByte(n2) & 0x3F) != 0) {
            arrayList.add(n);
            ++n3;
            n2 += 2;
        }
        if (arrayList.containsAll(Arrays.asList(48, 49, 50, 51, 52, 53, 54))) {
            arrayList.removeAll(Arrays.asList(49, 50, 51, 52, 53, 54));
        }
        return arrayList;
    }

    private static List<String> listRecords(VLIRRecordBlock vLIRRecordBlock) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < vLIRRecordBlock.size(); ++i) {
            VLIRRecordBlock.Entry entry = (VLIRRecordBlock.Entry)vLIRRecordBlock.get(i);
            if (entry == null || entry.length <= 0) continue;
            arrayList.add("#" + i + ": " + entry);
        }
        return arrayList;
    }

    private static String join(List<?> list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Object obj : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(obj);
        }
        return stringBuffer.toString();
    }
}

