/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos;

import com.kreative.bitsnpicas.geos.UTF8StrikeMap;
import java.io.ByteArrayOutputStream;

public class GEOSFontStrike {
    public int ascent;
    public int rowWidth;
    public int height;
    public int[] xCoord;
    public byte[] bitmap;
    public OffsetWidth[] offsetWidths;
    public UTF8StrikeMap utf8Map;

    public GEOSFontStrike() {
        this.clear(96, false, false);
    }

    public GEOSFontStrike(int n) {
        this.clear(n, false, false);
    }

    public GEOSFontStrike(boolean bl, boolean bl2) {
        this.clear(96, bl, bl2);
    }

    public GEOSFontStrike(int n, boolean bl, boolean bl2) {
        this.clear(n, bl, bl2);
    }

    public GEOSFontStrike(byte[] byArray) {
        this.read(byArray, 0, byArray.length);
    }

    public GEOSFontStrike(byte[] byArray, int n, int n2) {
        this.read(byArray, n, n2);
    }

    public void clear() {
        this.clear(96, false, false);
    }

    public void clear(int n) {
        this.clear(n, false, false);
    }

    public void clear(boolean bl, boolean bl2) {
        this.clear(96, bl, bl2);
    }

    public void clear(int n, boolean bl, boolean bl2) {
        this.ascent = 0;
        this.rowWidth = 0;
        this.height = 0;
        this.xCoord = new int[n + 1];
        this.bitmap = new byte[0];
        this.offsetWidths = bl ? new OffsetWidth[n] : null;
        this.utf8Map = bl2 ? new UTF8StrikeMap() : null;
    }

    public int getGlyphCount() {
        return this.xCoord.length - 1;
    }

    public byte[][] getGlyph(int n) {
        if (this.xCoord == null || this.xCoord.length == 0) {
            return null;
        }
        if (this.bitmap == null || this.bitmap.length == 0) {
            return null;
        }
        if (this.xCoord[n] > this.xCoord[n + 1] || this.xCoord[n] > this.rowWidth * 8 || this.xCoord[n + 1] > this.rowWidth * 8) {
            System.err.println("Warning: Bad X coordinates: " + this.xCoord[n] + ", " + this.xCoord[n + 1] + ", " + this.rowWidth * 8);
            return null;
        }
        byte[][] byArray = new byte[this.height][this.xCoord[n + 1] - this.xCoord[n]];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = n2 + (this.xCoord[n] >> 3);
            int n5 = 128 >> (this.xCoord[n] & 7);
            int n6 = 0;
            int n7 = this.xCoord[n];
            while (n7 < this.xCoord[n + 1]) {
                if ((this.bitmap[n4] & n5) != 0) {
                    byArray[n3][n6] = -1;
                }
                if ((n5 >>= 1) == 0) {
                    n5 = 128;
                    ++n4;
                }
                ++n7;
                ++n6;
            }
            ++n3;
            n2 += this.rowWidth;
        }
        return byArray;
    }

    public void setGlyph(int n, byte[][] byArray) {
        if (this.xCoord == null || this.xCoord.length == 0) {
            return;
        }
        if (this.bitmap == null || this.bitmap.length == 0) {
            return;
        }
        if (this.xCoord[n] > this.xCoord[n + 1] || this.xCoord[n] > this.rowWidth * 8 || this.xCoord[n + 1] > this.rowWidth * 8) {
            System.err.println("Warning: Bad X coordinates: " + this.xCoord[n] + ", " + this.xCoord[n + 1] + ", " + this.rowWidth * 8);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = n2 + (this.xCoord[n] >> 3);
            int n5 = 128 >> (this.xCoord[n] & 7);
            int n6 = 0;
            int n7 = this.xCoord[n];
            while (n7 < this.xCoord[n + 1]) {
                if (byArray[n3][n6] < 0) {
                    int n8 = n4;
                    this.bitmap[n8] = (byte)(this.bitmap[n8] | n5);
                }
                if ((n5 >>= 1) == 0) {
                    n5 = 128;
                    ++n4;
                }
                ++n7;
                ++n6;
            }
            ++n3;
            n2 += this.rowWidth;
        }
    }

    public void read(byte[] byArray) {
        this.read(byArray, 0, byArray.length);
    }

    public void read(byte[] byArray, int n, int n2) {
        this.ascent = byArray[n + 0] & 0xFF;
        this.rowWidth = byArray[n + 1] & 0xFF | (byArray[n + 2] & 0xFF) << 8;
        this.height = byArray[n + 3] & 0xFF;
        int n3 = byArray[n + 4] & 0xFF | (byArray[n + 5] & 0xFF) << 8;
        int n4 = byArray[n + 6] & 0xFF | (byArray[n + 7] & 0xFF) << 8;
        int n5 = byArray[n + 8] & 0xFF | (byArray[n + 9] & 0xFF) << 8;
        boolean bl = (n5 & 0x8000) != 0;
        boolean bl2 = bl && (n5 & 0x2000) != 0;
        boolean bl3 = bl && (n5 & 0x1000) != 0;
        int n6 = bl2 ? byArray[n + 10] & 0xFF | (byArray[n + 11] & 0xFF) << 8 : n2;
        int n7 = bl3 ? byArray[n + 12] & 0xFF | (byArray[n + 13] & 0xFF) << 8 : n2;
        int n8 = GEOSFontStrike.calculateLength(n3, n2, n4, n6, n7);
        int n9 = GEOSFontStrike.calculateLength(n4, n2, n3, n6, n7);
        int n10 = GEOSFontStrike.calculateLength(n6, n2, n3, n4, n7);
        this.xCoord = new int[n8 / 2];
        int n11 = n + n3;
        int n12 = 0;
        while (n12 < this.xCoord.length) {
            this.xCoord[n12] = byArray[n11] & 0xFF | (byArray[n11 + 1] & 0xFF) << 8;
            ++n12;
            n11 += 2;
        }
        this.bitmap = new byte[n9];
        n11 = n + n4;
        n12 = 0;
        while (n12 < this.bitmap.length) {
            this.bitmap[n12] = byArray[n11];
            ++n12;
            ++n11;
        }
        if (bl2) {
            this.offsetWidths = new OffsetWidth[n10 / 2];
            n11 = n + n6;
            n12 = 0;
            while (n12 < this.offsetWidths.length) {
                this.offsetWidths[n12] = new OffsetWidth(byArray[n11], byArray[n11 + 1] & 0xFF);
                ++n12;
                n11 += 2;
            }
        } else {
            this.offsetWidths = null;
        }
        if (bl3) {
            this.utf8Map = new UTF8StrikeMap();
            this.utf8Map.read(byArray, n + n7);
        } else {
            this.utf8Map = null;
        }
    }

    public byte[] write() {
        int n;
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = this.offsetWidths != null || this.utf8Map != null;
        int n3 = n2 = bl ? 14 : 8;
        int n4 = n2 += this.xCoord.length * 2;
        if (this.offsetWidths != null) {
            n2 += this.offsetWidths.length * 2;
        }
        int n5 = n2;
        int n6 = n2 += this.bitmap.length;
        byteArrayOutputStream.write(this.ascent);
        byteArrayOutputStream.write(this.rowWidth);
        byteArrayOutputStream.write(this.rowWidth >> 8);
        byteArrayOutputStream.write(this.height);
        byteArrayOutputStream.write(n3);
        byteArrayOutputStream.write(n3 >> 8);
        byteArrayOutputStream.write(n5);
        byteArrayOutputStream.write(n5 >> 8);
        if (bl) {
            n = 32768;
            if (this.xCoord.length < 96) {
                n |= 0x4000;
            }
            if (this.offsetWidths != null) {
                n |= 0x2000;
            }
            if (this.utf8Map != null) {
                n |= 0x1000;
            }
            byteArrayOutputStream.write(n);
            byteArrayOutputStream.write(n >> 8);
            byteArrayOutputStream.write(n4);
            byteArrayOutputStream.write(n4 >> 8);
            byteArrayOutputStream.write(n6);
            byteArrayOutputStream.write(n6 >> 8);
        }
        for (n = 0; n < this.xCoord.length; ++n) {
            byteArrayOutputStream.write(this.xCoord[n]);
            byteArrayOutputStream.write(this.xCoord[n] >> 8);
        }
        if (this.offsetWidths != null) {
            for (n = 0; n < this.offsetWidths.length; ++n) {
                if (this.offsetWidths[n] != null) {
                    byteArrayOutputStream.write(this.offsetWidths[n].offset);
                    byteArrayOutputStream.write(this.offsetWidths[n].width);
                    continue;
                }
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
            }
        }
        for (n = 0; n < this.bitmap.length; ++n) {
            byteArrayOutputStream.write(this.bitmap[n]);
        }
        if (this.utf8Map != null) {
            byte[] byArray = this.utf8Map.write(n6);
            for (int i = 0; i < byArray.length; ++i) {
                byteArrayOutputStream.write(byArray[i]);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static int calculateLength(int n, int n2, int ... nArray) {
        int n3 = n2;
        for (int n4 : nArray) {
            if (n4 < n || n4 >= n3) continue;
            n3 = n4;
        }
        return n3 - n;
    }

    public static final class OffsetWidth {
        public final int offset;
        public final int width;

        public OffsetWidth(int n, int n2) {
            this.offset = n;
            this.width = n2;
        }
    }
}

