/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos;

import com.kreative.bitsnpicas.geos.ConvertFile;
import com.kreative.bitsnpicas.geos.GEOSFontPointSize;
import com.kreative.bitsnpicas.geos.GEOSFontStrike;
import com.kreative.bitsnpicas.geos.GEOSIcons;
import com.kreative.bitsnpicas.geos.UTF8StrikeEntry;
import com.kreative.bitsnpicas.geos.UTF8StrikeIndex;
import com.kreative.bitsnpicas.geos.UTF8StrikeMap;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GEOSFontFile
extends ConvertFile {
    public GEOSFontFile() {
        super(131, 8, 1);
        this.infoBlock.iconBitmap = GEOSIcons.fontIcon();
        for (int i = 0; i < 127; ++i) {
            this.vlirData.add(new byte[0]);
        }
    }

    public GEOSFontFile(DataInput dataInput) throws IOException {
        this.read(dataInput);
    }

    public boolean isValid() {
        return this.directoryBlock != null && this.directoryBlock.geosFileType == 8 && this.directoryBlock.fileStructure == 1 && this.infoBlock != null && this.infoBlock.geosFileType == 8 && this.infoBlock.fileStructure == 1 && this.recordBlock != null && this.vlirData != null;
    }

    public boolean isMega() {
        int n;
        byte[] byArray = (byte[])this.vlirData.get(54);
        return byArray != null && byArray.length > 8 && (n = byArray[6] & 0xFF | (byArray[7] & 0xFF) << 8) >= byArray.length;
    }

    public boolean isUTF8() {
        byte[] byArray = (byte[])this.vlirData.get(126);
        return byArray != null && byArray.length > 0;
    }

    public String getFontName() {
        return this.directoryBlock.getFileName(true, true);
    }

    public void setFontName(String string) {
        this.directoryBlock.setFileName(string, true, true);
    }

    public String getClassTextString() {
        return this.infoBlock.getClassTextString();
    }

    public void setClassTextString(String string) {
        this.infoBlock.setClassTextString(string);
    }

    public String getDescriptionString() {
        return this.infoBlock.getDescriptionString();
    }

    public void setDescriptionString(String string) {
        this.infoBlock.setDescriptionString(string);
    }

    public int getFontID() {
        return this.infoBlock.getByte(128) & 0xFF | (this.infoBlock.getByte(129) & 0xFF) << 8;
    }

    public void setFontID(int n) {
        int n2;
        this.infoBlock.setByte(128, (byte)n);
        this.infoBlock.setByte(129, (byte)(n >> 8));
        n <<= 6;
        int n3 = 130;
        int n4 = 0;
        while (n4 < 15 && (n2 = this.infoBlock.getByte(n3) & 0x3F) != 0) {
            this.infoBlock.setByte(n3, (byte)(n2 | n));
            this.infoBlock.setByte(n3 + 1, (byte)(n >> 8));
            ++n4;
            n3 += 2;
        }
    }

    private GEOSFontStrike getFontStrike(int n) {
        byte[] byArray;
        if (n >= 0 && n < this.vlirData.size() && (byArray = (byte[])this.vlirData.get(n)) != null && byArray.length > 8) {
            return new GEOSFontStrike(byArray);
        }
        return null;
    }

    private GEOSFontStrike getFontStrike(int n, int n2, int n3) {
        byte[] byArray;
        if (n >= 0 && n < this.vlirData.size() && (byArray = (byte[])this.vlirData.get(n)) != null && byArray.length >= n2 * 254 + n3) {
            return new GEOSFontStrike(byArray, n2 * 254, n3);
        }
        return null;
    }

    private void removeFontStrike(int n) {
        if (n >= 0 && n < this.vlirData.size()) {
            this.vlirData.set(n, new byte[0]);
        }
    }

    private void setFontStrike(int n, GEOSFontStrike gEOSFontStrike) {
        if (n >= 0 && n < this.vlirData.size()) {
            this.vlirData.set(n, gEOSFontStrike.write());
        }
    }

    public List<Integer> getFontPointSizes() {
        byte[] byArray;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.isMega()) {
            for (int i = 49; i <= 54; ++i) {
                hashSet.add(i);
            }
        }
        if ((byArray = (byte[])this.vlirData.get(126)) != null && byArray.length > 0) {
            hashSet.add(126);
            int n = 0;
            while (n + 4 <= byArray.length) {
                hashSet.add(byArray[n] & 0xFF);
                n += 4;
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.vlirData.size(); ++i) {
            byte[] byArray2;
            if (hashSet.contains(i) || (byArray2 = (byte[])this.vlirData.get(i)).length <= 8) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public GEOSFontPointSize getFontPointSize(int n) {
        GEOSFontPointSize gEOSFontPointSize = new GEOSFontPointSize(n);
        if (n >= 48 && n <= 54 && this.isMega()) {
            gEOSFontPointSize.megaStrikes = new GEOSFontStrike[6];
            gEOSFontPointSize.megaStrikes[0] = this.getFontStrike(48);
            gEOSFontPointSize.megaStrikes[1] = this.getFontStrike(49);
            gEOSFontPointSize.megaStrikes[2] = this.getFontStrike(50);
            gEOSFontPointSize.megaStrikes[3] = this.getFontStrike(51);
            gEOSFontPointSize.megaStrikes[4] = this.getFontStrike(52);
            gEOSFontPointSize.megaStrikes[5] = this.getFontStrike(53);
            gEOSFontPointSize.megaStrikeIndex = this.getFontStrike(54);
            gEOSFontPointSize.utf8Map = gEOSFontPointSize.megaStrikeIndex.utf8Map;
        } else {
            gEOSFontPointSize.strike = this.getFontStrike(n);
            if (gEOSFontPointSize.strike == null) {
                return null;
            }
            gEOSFontPointSize.utf8Map = gEOSFontPointSize.strike.utf8Map;
        }
        if (gEOSFontPointSize.utf8Map != null) {
            gEOSFontPointSize.utf8Strikes = new HashMap<UTF8StrikeEntry, GEOSFontStrike>();
            for (UTF8StrikeEntry object : gEOSFontPointSize.utf8Map.lowEntries) {
                if (object == null) continue;
                gEOSFontPointSize.utf8Strikes.put(object, this.getFontStrike(object.recordIndex, object.sectorIndex, object.length));
            }
            for (UTF8StrikeMap.SubMap subMap : gEOSFontPointSize.utf8Map.highEntries) {
                if (subMap == null) continue;
                for (UTF8StrikeEntry uTF8StrikeEntry : subMap.entries) {
                    if (uTF8StrikeEntry == null) continue;
                    gEOSFontPointSize.utf8Strikes.put(uTF8StrikeEntry, this.getFontStrike(uTF8StrikeEntry.recordIndex, uTF8StrikeEntry.sectorIndex, uTF8StrikeEntry.length));
                }
            }
            for (UTF8StrikeMap.AstralMap astralMap : gEOSFontPointSize.utf8Map.astralEntries) {
                if (astralMap == null) continue;
                for (UTF8StrikeMap.SubMap subMap : astralMap.entries) {
                    if (subMap == null) continue;
                    for (UTF8StrikeEntry uTF8StrikeEntry : subMap.entries) {
                        if (uTF8StrikeEntry == null) continue;
                        gEOSFontPointSize.utf8Strikes.put(uTF8StrikeEntry, this.getFontStrike(uTF8StrikeEntry.recordIndex, uTF8StrikeEntry.sectorIndex, uTF8StrikeEntry.length));
                    }
                }
            }
        }
        return gEOSFontPointSize;
    }

    public int getFontPointSizeSectorCount(int n) {
        Object object;
        Iterator<UTF8StrikeEntry> iterator;
        int n2 = 0;
        UTF8StrikeMap uTF8StrikeMap = null;
        if (n >= 48 && n <= 54 && this.isMega()) {
            for (int i = 48; i <= 54; ++i) {
                iterator = (Iterator<UTF8StrikeEntry>)((byte[])this.vlirData.get(i));
                if (iterator == null) continue;
                n2 += (((Object)iterator).length + 253) / 254;
            }
            object = this.getFontStrike(54);
            if (object != null) {
                uTF8StrikeMap = object.utf8Map;
            }
        } else {
            object = (byte[])this.vlirData.get(n);
            if (object != null) {
                n2 += (((byte[])object).length + 253) / 254;
            }
            if ((iterator = this.getFontStrike(n)) != null) {
                uTF8StrikeMap = ((GEOSFontStrike)((Object)iterator)).utf8Map;
            }
        }
        if (uTF8StrikeMap != null) {
            object = new HashSet();
            for (UTF8StrikeEntry uTF8StrikeEntry : uTF8StrikeMap.entryList()) {
                object.add(uTF8StrikeEntry.recordIndex);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)((Object)iterator.next());
                byte[] byArray = (byte[])this.vlirData.get(n3);
                if (byArray == null) continue;
                n2 += (byArray.length + 253) / 254;
            }
        }
        return n2;
    }

    public String getFontPointSizeTypeString(int n) {
        String string = "font";
        UTF8StrikeMap uTF8StrikeMap = null;
        if (n >= 48 && n <= 54 && this.isMega()) {
            string = "mega " + string;
            GEOSFontStrike gEOSFontStrike = this.getFontStrike(54);
            if (gEOSFontStrike != null) {
                uTF8StrikeMap = gEOSFontStrike.utf8Map;
            }
        } else {
            GEOSFontStrike gEOSFontStrike = this.getFontStrike(n);
            if (gEOSFontStrike != null) {
                uTF8StrikeMap = gEOSFontStrike.utf8Map;
            }
        }
        if (uTF8StrikeMap != null) {
            string = "UTF-8 " + string;
        }
        return string;
    }

    public void removeFontPointSize(int n) {
        Object object;
        UTF8StrikeMap uTF8StrikeMap = null;
        if (n >= 48 && n <= 54 && this.isMega()) {
            object = this.getFontStrike(54);
            if (object != null) {
                uTF8StrikeMap = ((GEOSFontStrike)object).utf8Map;
            }
            this.removeFontStrike(48);
            this.removeFontStrike(49);
            this.removeFontStrike(50);
            this.removeFontStrike(51);
            this.removeFontStrike(52);
            this.removeFontStrike(53);
            this.removeFontStrike(54);
        } else {
            object = this.getFontStrike(n);
            if (object != null) {
                uTF8StrikeMap = ((GEOSFontStrike)object).utf8Map;
            }
            this.removeFontStrike(n);
        }
        if (uTF8StrikeMap != null) {
            object = this.getUTF8StrikeIndex();
            if (object == null) {
                object = new UTF8StrikeIndex();
            }
            for (UTF8StrikeEntry uTF8StrikeEntry : uTF8StrikeMap.entryList()) {
                this.removeFontStrike(uTF8StrikeEntry.recordIndex);
                ((TreeSet)object).remove(uTF8StrikeEntry);
            }
            this.setUTF8StrikeIndex((UTF8StrikeIndex)object);
        }
    }

    public void setFontPointSize(int n, GEOSFontPointSize gEOSFontPointSize) {
        if (gEOSFontPointSize.isUTF8()) {
            HashMap<UTF8StrikeEntry, UTF8StrikeEntry> hashMap = new HashMap<UTF8StrikeEntry, UTF8StrikeEntry>();
            UTF8StrikeIndex uTF8StrikeIndex = this.getUTF8StrikeIndex();
            if (uTF8StrikeIndex == null) {
                uTF8StrikeIndex = new UTF8StrikeIndex();
            }
            int n2 = 0;
            int n3 = this.nextRecordIndex();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Iterator<UTF8StrikeEntry> iterator = gEOSFontPointSize.utf8Map.entryList().iterator();
            while (iterator.hasNext()) {
                int n4 = (n2 + 253) / 254;
                int n5 = n4 * 254;
                UTF8StrikeEntry uTF8StrikeEntry = iterator.next();
                byte[] byArray = gEOSFontPointSize.utf8Strikes.get(uTF8StrikeEntry).write();
                if (n5 + byArray.length > 12192) {
                    this.vlirData.set(n3, byteArrayOutputStream.toByteArray());
                    n2 = 0;
                    n3 = this.nextRecordIndex();
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    n4 = 0;
                    n5 = 0;
                }
                hashMap.put(uTF8StrikeEntry, new UTF8StrikeEntry(n3, n4, byArray.length));
                uTF8StrikeIndex.add(new UTF8StrikeEntry(n3, n4, byArray.length));
                while (n2 < n5) {
                    byteArrayOutputStream.write(0);
                    ++n2;
                }
                for (byte by : byArray) {
                    byteArrayOutputStream.write(by);
                    ++n2;
                }
            }
            if (n2 > 0) {
                this.vlirData.set(n3, byteArrayOutputStream.toByteArray());
            }
            this.setUTF8StrikeIndex(uTF8StrikeIndex);
            gEOSFontPointSize.remap(hashMap);
        }
        if (gEOSFontPointSize.isMega()) {
            this.setFontStrike(48, gEOSFontPointSize.megaStrikes[0]);
            this.setFontStrike(49, gEOSFontPointSize.megaStrikes[1]);
            this.setFontStrike(50, gEOSFontPointSize.megaStrikes[2]);
            this.setFontStrike(51, gEOSFontPointSize.megaStrikes[3]);
            this.setFontStrike(52, gEOSFontPointSize.megaStrikes[4]);
            this.setFontStrike(53, gEOSFontPointSize.megaStrikes[5]);
            this.setFontStrike(54, gEOSFontPointSize.megaStrikeIndex);
        } else {
            this.setFontStrike(n, gEOSFontPointSize.strike);
        }
    }

    private int nextRecordIndex() {
        byte[] byArray;
        int n;
        for (n = 125; n > 0 && (byArray = (byte[])this.vlirData.get(n)) != null && byArray.length != 0; --n) {
        }
        return n;
    }

    private UTF8StrikeIndex getUTF8StrikeIndex() {
        byte[] byArray = (byte[])this.vlirData.get(126);
        if (byArray != null && byArray.length > 0) {
            UTF8StrikeIndex uTF8StrikeIndex = new UTF8StrikeIndex();
            uTF8StrikeIndex.read(byArray);
            return uTF8StrikeIndex;
        }
        return null;
    }

    private void setUTF8StrikeIndex(UTF8StrikeIndex uTF8StrikeIndex) {
        this.vlirData.set(126, uTF8StrikeIndex.write());
    }

    @Override
    public void recalculate() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.isMega()) {
            for (int i = 49; i <= 54; ++i) {
                hashSet.add(i);
            }
        }
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        byte[] byArray = (byte[])this.vlirData.get(126);
        if (byArray != null && byArray.length > 0) {
            hashSet2.add(126);
            int n = 0;
            while (n + 4 <= byArray.length) {
                hashSet2.add(byArray[n] & 0xFF);
                n += 4;
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i = 0; i < this.vlirData.size(); ++i) {
            byte[] byArray2;
            if (hashSet2.contains(i) || (byArray2 = (byte[])this.vlirData.get(i)).length <= 8) continue;
            if (!hashSet.contains(i)) {
                arrayList.add(i);
            }
            arrayList2.add(i);
            arrayList3.add(byArray2.length);
        }
        this.updateDescription(arrayList);
        this.setFontStrikes(arrayList2);
        this.setFontRecordLengths(arrayList3);
        super.recalculate();
    }

    private void updateDescription(List<Integer> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Available in ");
        int n = list.size();
        Object object = list.iterator();
        while (object.hasNext()) {
            int n2 = object.next();
            stringBuffer.append(n2);
            if (--n > 1) {
                stringBuffer.append(", ");
            }
            if (n != 1) continue;
            stringBuffer.append(" and ");
        }
        stringBuffer.append(" point.");
        object = this.infoBlock.getDescriptionString();
        object = ((String)object).trim().length() == 0 ? stringBuffer.toString() : ((String)object).replaceAll("Available in [^.]+ point.", stringBuffer.toString());
        this.infoBlock.setDescriptionString((String)object);
    }

    private void setFontStrikes(List<Integer> list) {
        int n = this.getFontID() << 6;
        int n2 = 130;
        int n3 = 0;
        int n4 = list.size();
        while (n3 < n4 && n3 < 15) {
            int n5 = list.get(n3) & 0x3F;
            this.infoBlock.setByte(n2, (byte)(n5 | n));
            this.infoBlock.setByte(n2 + 1, (byte)(n >> 8));
            ++n3;
            n2 += 2;
        }
        while (n3 < 15) {
            this.infoBlock.setByte(n2, (byte)0);
            this.infoBlock.setByte(n2 + 1, (byte)0);
            ++n3;
            n2 += 2;
        }
    }

    private void setFontRecordLengths(List<Integer> list) {
        int n = 97;
        int n2 = 0;
        int n3 = list.size();
        while (n2 < n3 && n2 < 15) {
            int n4 = list.get(n2);
            this.infoBlock.setByte(n, (byte)n4);
            this.infoBlock.setByte(n + 1, (byte)(n4 >> 8));
            ++n2;
            n += 2;
        }
        while (n2 < 15) {
            this.infoBlock.setByte(n, (byte)0);
            this.infoBlock.setByte(n + 1, (byte)0);
            ++n2;
            n += 2;
        }
    }
}

