/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SBFBitmapFontExporter
implements BitmapFontExporter {
    private GlyphList encoding;
    private static final int[] C0 = new int[]{0, 715, 733, 729, 730, 711, 728, 731, 8, 9, 10, 11, 12, 13, 64257, 64258, 63743, 8260, 8730, 8721, 8719, 8747, 8710, 937, 960, 8706, 8734, 27, 8804, 8800, 8805, 8776};
    private static final int[] C1 = new int[]{8364, 9674, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 321, 381, 305, 8984, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 322, 382, 376};

    public SBFBitmapFontExporter() {
        this.encoding = null;
    }

    public SBFBitmapFontExporter(GlyphList glyphList) {
        this.encoding = glyphList;
    }

    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportFont(bitmapFont, new DataOutputStream(byteArrayOutputStream));
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        this.exportFont(bitmapFont, new DataOutputStream(outputStream));
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.exportFont(bitmapFont, new DataOutputStream(fileOutputStream));
        fileOutputStream.close();
    }

    private void exportFont(BitmapFont bitmapFont, DataOutputStream dataOutputStream) throws IOException {
        BitmapFontGlyph bitmapFontGlyph;
        int n;
        int n2;
        int[] nArray = new int[256];
        int n3 = 2048;
        boolean bl = true;
        int n4 = 0;
        int n5 = bitmapFont.getLineAscent() + bitmapFont.getLineDescent() + bitmapFont.getLineGap();
        for (n2 = 0; n2 < 256; ++n2) {
            nArray[n2] = n3;
            n = this.encoding != null ? this.encoding.get(n2) : SBFBitmapFontExporter.fromSuperLatin(n2);
            bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n);
            if (bitmapFontGlyph == null) continue;
            n3 += SBFBitmapFontExporter.bitsToBytes(bitmapFontGlyph.getGlyphWidth()) * bitmapFontGlyph.getGlyphHeight();
            if (bl) {
                bl = false;
                n4 = bitmapFontGlyph.getCharacterWidth();
                continue;
            }
            if (n4 == 0 || n4 == bitmapFontGlyph.getCharacterWidth()) continue;
            n4 = 0;
        }
        dataOutputStream.writeInt(280067676);
        dataOutputStream.writeByte(n4);
        dataOutputStream.writeByte(n5);
        dataOutputStream.writeByte(bitmapFont.getLineAscent());
        dataOutputStream.writeByte(bitmapFont.getLineDescent());
        for (n2 = 1; n2 < 256; ++n2) {
            n = this.encoding != null ? this.encoding.get(n2) : SBFBitmapFontExporter.fromSuperLatin(n2);
            bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n);
            if (bitmapFontGlyph == null) {
                dataOutputStream.writeLong(0L);
                continue;
            }
            int n6 = SBFBitmapFontExporter.bitsToBytes(bitmapFontGlyph.getGlyphWidth());
            int n7 = (n6 << 3) - bitmapFontGlyph.getGlyphWidth();
            dataOutputStream.writeShort(Short.reverseBytes((short)nArray[n2]));
            dataOutputStream.writeByte(n6);
            dataOutputStream.writeByte(bitmapFontGlyph.getGlyphHeight());
            dataOutputStream.writeByte(bitmapFontGlyph.getGlyphOffset());
            dataOutputStream.writeByte(bitmapFontGlyph.getGlyphAscent());
            dataOutputStream.writeByte(bitmapFontGlyph.getCharacterWidth());
            dataOutputStream.writeByte(n7);
        }
        for (n2 = 0; n2 < 256; ++n2) {
            n = this.encoding != null ? this.encoding.get(n2) : SBFBitmapFontExporter.fromSuperLatin(n2);
            bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n);
            if (bitmapFontGlyph == null) continue;
            for (byte[] byArray : bitmapFontGlyph.getGlyph()) {
                byte[] byArray2 = new byte[SBFBitmapFontExporter.bitsToBytes(byArray.length)];
                int n8 = 0;
                int n9 = 128;
                for (byte by : byArray) {
                    if (by < 0) {
                        int n10 = n8;
                        byArray2[n10] = (byte)(byArray2[n10] | n9);
                    }
                    if ((n9 >>= 1) != 0) continue;
                    ++n8;
                    n9 = 128;
                }
                dataOutputStream.write(byArray2);
            }
        }
    }

    private static int fromSuperLatin(int n) {
        if ((n &= 0xFF) < 32) {
            return C0[n];
        }
        if (n < 128) {
            return n;
        }
        if (n < 160) {
            return C1[n & 0x1F];
        }
        return n;
    }

    private static int bitsToBytes(int n) {
        int n2 = n >> 3;
        if ((n & 7) != 0) {
            ++n2;
        }
        return n2;
    }
}

