/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CybikoBitmapFontExporter
implements BitmapFontExporter {
    private GlyphList encoding;

    public CybikoBitmapFontExporter() {
        this.encoding = null;
    }

    public CybikoBitmapFontExporter(GlyphList glyphList) {
        this.encoding = glyphList;
    }

    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportFontImpl(bitmapFont, new DataOutputStream(byteArrayOutputStream));
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        this.exportFontImpl(bitmapFont, new DataOutputStream(outputStream));
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.exportFontImpl(bitmapFont, new DataOutputStream(fileOutputStream));
        fileOutputStream.close();
    }

    private void exportFontImpl(BitmapFont bitmapFont, DataOutputStream dataOutputStream) throws IOException {
        int n;
        BitmapFontGlyph bitmapFontGlyph;
        int n2;
        int n3;
        int n4 = 32;
        int n5 = 1;
        int n6 = bitmapFont.getLineAscent() + bitmapFont.getLineDescent() + bitmapFont.getLineGap();
        for (n3 = 32; n3 < 256; ++n3) {
            n2 = this.encoding != null ? this.encoding.get(n3) : CybikoBitmapFontExporter.fromCybiko(n3);
            bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n2);
            if (bitmapFontGlyph == null) continue;
            n4 = n3;
            n = bitmapFontGlyph.getCharacterWidth();
            if (n <= n5) continue;
            n5 = n;
        }
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(n4 - 31);
        dataOutputStream.writeByte(n5);
        dataOutputStream.writeByte(n6);
        for (n3 = 32; n3 <= n4; ++n3) {
            int n7;
            n2 = this.encoding != null ? this.encoding.get(n3) : CybikoBitmapFontExporter.fromCybiko(n3);
            bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n2);
            if (bitmapFontGlyph == null) {
                dataOutputStream.writeByte(0);
                dataOutputStream.writeByte(0);
                dataOutputStream.writeByte(1);
                dataOutputStream.writeByte(1);
                dataOutputStream.writeByte(0);
                continue;
            }
            n = bitmapFontGlyph.getCharacterWidth();
            if (n < 1) {
                n = 1;
            }
            int n8 = bitmapFont.getLineAscent() - bitmapFontGlyph.getGlyphAscent();
            int n9 = 0;
            for (n7 = bitmapFontGlyph.getGlyphHeight(); n7 < 1; ++n7) {
                --n8;
                --n9;
            }
            while (n8 >= n6) {
                --n8;
                --n9;
                ++n7;
            }
            while (n8 < 0) {
                ++n8;
                ++n9;
                --n7;
            }
            if (n7 > n6 - n8) {
                n7 = n6 - n8;
            }
            if (n7 < 1) {
                n7 = 1;
            }
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(n8);
            dataOutputStream.writeByte(n);
            dataOutputStream.writeByte(n7);
            byte[][] byArray = bitmapFontGlyph.getGlyph();
            while (n7 > 0) {
                byte[] byArray2 = new byte[(n + 7) / 8];
                if (n9 >= 0 && n9 < byArray.length) {
                    int n10 = -bitmapFontGlyph.getGlyphOffset();
                    int n11 = 0;
                    int n12 = 0;
                    while (n12 < n) {
                        int n13 = 128;
                        int n14 = n12;
                        while (n13 != 0 && n14 < n) {
                            if (n10 >= 0 && n10 < byArray[n9].length && byArray[n9][n10] < 0) {
                                int n15 = n11;
                                byArray2[n15] = (byte)(byArray2[n15] | n13);
                            }
                            n13 >>= 1;
                            ++n14;
                            ++n10;
                        }
                        n12 += 8;
                        ++n11;
                    }
                }
                dataOutputStream.write(byArray2);
                --n7;
                ++n9;
            }
        }
    }

    private static int fromCybiko(int n) {
        switch (n) {
            case 127: {
                return 8230;
            }
            case 128: {
                return 9829;
            }
            case 129: {
                return 9679;
            }
            case 130: {
                return 9654;
            }
            case 131: {
                return 9655;
            }
            case 132: {
                return 1047586;
            }
            case 133: {
                return 1047587;
            }
            case 134: {
                return 8224;
            }
            case 135: {
                return 8225;
            }
            case 136: {
                return 710;
            }
            case 137: {
                return 8240;
            }
            case 138: {
                return 352;
            }
            case 139: {
                return 8249;
            }
            case 140: {
                return 338;
            }
            case 141: {
                return 321;
            }
            case 142: {
                return 381;
            }
            case 143: {
                return 305;
            }
            case 144: {
                return 8364;
            }
            case 145: {
                return 8216;
            }
            case 146: {
                return 8217;
            }
            case 147: {
                return 8220;
            }
            case 148: {
                return 8221;
            }
            case 149: {
                return 8226;
            }
            case 150: {
                return 8211;
            }
            case 151: {
                return 8212;
            }
            case 152: {
                return 732;
            }
            case 153: {
                return 8482;
            }
            case 154: {
                return 353;
            }
            case 155: {
                return 8250;
            }
            case 156: {
                return 339;
            }
            case 157: {
                return 322;
            }
            case 158: {
                return 382;
            }
            case 159: {
                return 376;
            }
        }
        return n;
    }
}

