/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.edit.BitmapGlyphState;
import com.kreative.bitsnpicas.edit.BitmapTool;
import com.kreative.bitsnpicas.edit.BitmapToolPanel;
import com.kreative.bitsnpicas.edit.GlyphComponent;
import com.kreative.bitsnpicas.edit.GlyphComponentListener;
import com.kreative.bitsnpicas.edit.SwingUtils;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitmapToolHandler
implements GlyphComponentListener<BitmapFontGlyph> {
    private final BitmapToolPanel toolPanel;
    private final GlyphComponent<BitmapFontGlyph> glyphComponent;
    private final Stack<BitmapGlyphState> undoStack;
    private final Stack<BitmapGlyphState> redoStack;
    private BitmapTool inProgressTool;
    private byte inProgressOpacity;
    private BitmapGlyphState inProgressState;
    private int startX;
    private int startY;
    private int startGx;
    private int startGy;
    private double startTx;
    private double startTy;

    public BitmapToolHandler(BitmapToolPanel bitmapToolPanel, GlyphComponent<BitmapFontGlyph> glyphComponent) {
        this.toolPanel = bitmapToolPanel;
        this.glyphComponent = glyphComponent;
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        glyphComponent.addGlyphComponentListener(this);
    }

    public void clearHistory() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    public void pushUndoState(BitmapGlyphState bitmapGlyphState) {
        if (bitmapGlyphState == null) {
            BitmapFontGlyph bitmapFontGlyph = this.glyphComponent.getGlyph();
            bitmapGlyphState = new BitmapGlyphState(bitmapFontGlyph);
        }
        this.undoStack.push(bitmapGlyphState);
        this.redoStack.clear();
    }

    public void undo() {
        if (!this.undoStack.isEmpty()) {
            BitmapFontGlyph bitmapFontGlyph = this.glyphComponent.getGlyph();
            this.redoStack.push(new BitmapGlyphState(bitmapFontGlyph));
            this.undoStack.pop().apply(bitmapFontGlyph);
            this.glyphComponent.glyphChanged();
        }
    }

    public void redo() {
        if (!this.redoStack.isEmpty()) {
            BitmapFontGlyph bitmapFontGlyph = this.glyphComponent.getGlyph();
            this.undoStack.push(new BitmapGlyphState(bitmapFontGlyph));
            this.redoStack.pop().apply(bitmapFontGlyph);
            this.glyphComponent.glyphChanged();
        }
    }

    @Override
    public Cursor getCursor(MouseEvent mouseEvent, Point2D point2D, BitmapFontGlyph bitmapFontGlyph, Font<BitmapFontGlyph> font) {
        return this.toolPanel.getSelectedTool().cursor;
    }

    @Override
    public boolean mouseMoved(MouseEvent mouseEvent, Point2D point2D, BitmapFontGlyph bitmapFontGlyph, Font<BitmapFontGlyph> font) {
        return false;
    }

    @Override
    public boolean mousePressed(MouseEvent mouseEvent, Point2D point2D, BitmapFontGlyph bitmapFontGlyph, Font<BitmapFontGlyph> font) {
        this.inProgressTool = this.toolPanel.getSelectedTool();
        this.inProgressOpacity = (byte)this.toolPanel.getOpacity();
        this.inProgressState = new BitmapGlyphState(bitmapFontGlyph);
        this.startX = (int)Math.floor(point2D.getX());
        this.startY = (int)Math.floor(point2D.getY());
        return this.doTool(mouseEvent, this.startX, this.startY, bitmapFontGlyph, font, true, false);
    }

    @Override
    public boolean mouseDragged(MouseEvent mouseEvent, Point2D point2D, BitmapFontGlyph bitmapFontGlyph, Font<BitmapFontGlyph> font) {
        int n = (int)Math.floor(point2D.getX());
        int n2 = (int)Math.floor(point2D.getY());
        return this.doTool(mouseEvent, n, n2, bitmapFontGlyph, font, false, false);
    }

    @Override
    public boolean mouseReleased(MouseEvent mouseEvent, Point2D point2D, BitmapFontGlyph bitmapFontGlyph, Font<BitmapFontGlyph> font) {
        int n = (int)Math.floor(point2D.getX());
        int n2 = (int)Math.floor(point2D.getY());
        return this.doTool(mouseEvent, n, n2, bitmapFontGlyph, font, false, true);
    }

    private boolean doTool(MouseEvent mouseEvent, int n, int n2, BitmapFontGlyph bitmapFontGlyph, Font<BitmapFontGlyph> font, boolean bl, boolean bl2) {
        int n3 = Math.min(this.startX, n);
        int n4 = Math.min(this.startY, n2);
        int n5 = Math.max(this.startX, n) - n3;
        int n6 = Math.max(this.startY, n2) - n4;
        switch (this.inProgressTool) {
            case PENCIL: {
                if (bl) {
                    this.pushUndoState(this.inProgressState);
                    byte by = bitmapFontGlyph.getPixel(n, n2);
                    if (this.inProgressOpacity == by) {
                        this.inProgressOpacity = 0;
                    }
                }
                bitmapFontGlyph.expand(n3, n4, n5 + 1, n6 + 1);
                bitmapFontGlyph.drawLine(this.startX, this.startY, n, n2, this.inProgressOpacity);
                this.startX = n;
                this.startY = n2;
                if (bl2) {
                    bitmapFontGlyph.contract();
                }
                return true;
            }
            case ERASER: {
                if (bl) {
                    this.pushUndoState(this.inProgressState);
                }
                bitmapFontGlyph.expand(n3, n4, n5 + 1, n6 + 1);
                bitmapFontGlyph.drawLine(this.startX, this.startY, n, n2, (byte)0);
                this.startX = n;
                this.startY = n2;
                if (bl2) {
                    bitmapFontGlyph.contract();
                }
                return true;
            }
            case EYEDROPPER: {
                this.toolPanel.setOpacity(bitmapFontGlyph.getPixel(n, n2) & 0xFF);
                return false;
            }
            case LINE: {
                if (bl) {
                    this.pushUndoState(this.inProgressState);
                }
                this.inProgressState.apply(bitmapFontGlyph);
                bitmapFontGlyph.expand(n3, n4, n5 + 1, n6 + 1);
                bitmapFontGlyph.drawLine(this.startX, this.startY, n, n2, this.inProgressOpacity);
                if (bl2) {
                    bitmapFontGlyph.contract();
                }
                return true;
            }
            case RECTANGLE: {
                if (bl) {
                    this.pushUndoState(this.inProgressState);
                }
                this.inProgressState.apply(bitmapFontGlyph);
                bitmapFontGlyph.expand(n3, n4, n5 + 1, n6 + 1);
                bitmapFontGlyph.drawRect(n3, n4, n5, n6, this.inProgressOpacity);
                if (bl2) {
                    bitmapFontGlyph.contract();
                }
                return true;
            }
            case FILLED_RECT: {
                if (bl) {
                    this.pushUndoState(this.inProgressState);
                }
                this.inProgressState.apply(bitmapFontGlyph);
                bitmapFontGlyph.expand(n3, n4, n5 + 1, n6 + 1);
                bitmapFontGlyph.fillRect(n3, n4, n5 + 1, n6 + 1, this.inProgressOpacity);
                if (bl2) {
                    bitmapFontGlyph.contract();
                }
                return true;
            }
            case INVERT: {
                if (bl) {
                    this.pushUndoState(this.inProgressState);
                }
                this.inProgressState.apply(bitmapFontGlyph);
                bitmapFontGlyph.expand(n3, n4, n5 + 1, n6 + 1);
                bitmapFontGlyph.invertRect(n3, n4, n5 + 1, n6 + 1);
                if (bl2) {
                    bitmapFontGlyph.contract();
                }
                return true;
            }
            case MOVE: {
                if (bl) {
                    this.pushUndoState(this.inProgressState);
                    this.startGx = bitmapFontGlyph.getX();
                    this.startGy = bitmapFontGlyph.getY();
                } else {
                    bitmapFontGlyph.setXY(this.startGx + (n - this.startX), this.startGy - (n2 - this.startY));
                }
                return true;
            }
            case GRABBER: {
                if (bl) {
                    this.glyphComponent.setCursor(SwingUtils.CURSOR_HAND_CLOSED);
                    this.startX = mouseEvent.getX();
                    this.startY = mouseEvent.getY();
                    this.startTx = this.glyphComponent.getTranslateX();
                    this.startTy = this.glyphComponent.getTranslateY();
                } else {
                    this.glyphComponent.setTranslate(Math.round(this.startTx + (double)mouseEvent.getX() - (double)this.startX), Math.round(this.startTy + (double)mouseEvent.getY() - (double)this.startY));
                }
                if (bl2) {
                    this.glyphComponent.setCursor(SwingUtils.CURSOR_HAND_OPEN);
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean mouseWheelMoved(MouseWheelEvent mouseWheelEvent, Point2D point2D, BitmapFontGlyph bitmapFontGlyph, Font<BitmapFontGlyph> font) {
        int n = this.toolPanel.getOpacity() - mouseWheelEvent.getWheelRotation();
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        this.toolPanel.setOpacity(n);
        return false;
    }

    @Override
    public void metricsChanged(BitmapFontGlyph bitmapFontGlyph, Font<BitmapFontGlyph> font) {
    }

    @Override
    public void glyphChanged(BitmapFontGlyph bitmapFontGlyph, Font<BitmapFontGlyph> font) {
    }
}

