/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.edit.BitmapGlyphState;
import com.kreative.bitsnpicas.edit.GlyphLocator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitmapGlyphListSelection
implements ClipboardOwner,
Transferable {
    public static final DataFlavor flavor = new DataFlavor(BitmapGlyphState[].class, "Bitmap Glyph List");
    private final BitmapGlyphState[] states;
    private final BufferedImage image;
    private final String string;

    public BitmapGlyphListSelection(Collection<GlyphLocator<BitmapFontGlyph>> collection) {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<BitmapFontGlyph> arrayList = new ArrayList<BitmapFontGlyph>();
        ArrayList<BitmapGlyphState> arrayList2 = new ArrayList<BitmapGlyphState>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (GlyphLocator<BitmapFontGlyph> glyphLocator : collection) {
            Font<BitmapFontGlyph> font;
            if (glyphLocator.isCodePoint()) {
                stringBuffer.append(Character.toChars(glyphLocator.getCodePoint()));
            } else if (glyphLocator.isGlyphName()) {
                stringBuffer.append(glyphLocator.getGlyphName());
            }
            object = glyphLocator.getGlyph();
            if (object != null) {
                arrayList.add((BitmapFontGlyph)object);
                arrayList2.add(new BitmapGlyphState((BitmapFontGlyph)object));
                n2 += ((BitmapFontGlyph)object).getCharacterWidth();
            }
            if ((font = glyphLocator.getGlyphFont()) == null) continue;
            if (font.getLineAscent() > n3) {
                n3 = font.getLineAscent();
            }
            if (font.getLineDescent() <= n4) continue;
            n4 = font.getLineDescent();
        }
        this.states = arrayList2.toArray(new BitmapGlyphState[arrayList2.size()]);
        int n5 = n2;
        if (n5 < 1) {
            n5 = 1;
        }
        if ((n = n3 + n4) < 1) {
            n = 1;
        }
        this.image = new BufferedImage(n5, n, 2);
        object = this.image.createGraphics();
        ((Graphics)object).setColor(Color.black);
        double d = 0.0;
        for (BitmapFontGlyph bitmapFontGlyph : arrayList) {
            d += bitmapFontGlyph.paint((Graphics)object, d, n3, 1.0);
        }
        ((Graphics)object).dispose();
        this.string = stringBuffer.toString();
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(dataFlavor)) {
            return this.states;
        }
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            return this.image;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.string;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{flavor, DataFlavor.imageFlavor, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return flavor.equals(dataFlavor) || DataFlavor.imageFlavor.equals(dataFlavor) || DataFlavor.stringFlavor.equals(dataFlavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

