/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListSelection
implements ClipboardOwner,
Transferable {
    private List<File> myList = new Vector<File>();
    private boolean isCut;

    public FileListSelection(File file) {
        this.myList.add(file);
        this.isCut = false;
    }

    public FileListSelection(File[] fileArray) {
        this.myList.addAll(Arrays.asList(fileArray));
        this.isCut = false;
    }

    public FileListSelection(Collection<File> collection) {
        this.myList.addAll(collection);
        this.isCut = false;
    }

    public FileListSelection(File file, boolean bl) {
        this.myList.add(file);
        this.isCut = bl;
    }

    public FileListSelection(File[] fileArray, boolean bl) {
        this.myList.addAll(Arrays.asList(fileArray));
        this.isCut = bl;
    }

    public FileListSelection(Collection<File> collection, boolean bl) {
        this.myList.addAll(collection);
        this.isCut = bl;
    }

    public boolean isCutOperation() {
        return this.isCut;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
            return this.myList;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            String string = "";
            for (File file : this.myList) {
                string = string + "\n" + file.getAbsolutePath();
            }
            return string.length() > 0 ? string.substring(1) : string;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return DataFlavor.javaFileListFlavor.equals(dataFlavor) || DataFlavor.stringFlavor.equals(dataFlavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

