/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import java.io.IOException;
import java.io.InputStream;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class Base64InputStream
extends InputStream {
    private final CharacterIterator ci;
    private final InputStream in;
    private int word = 0;
    private int count = 0;
    private boolean eof = false;

    public Base64InputStream(String string) {
        this.ci = new StringCharacterIterator(string);
        this.in = null;
    }

    public Base64InputStream(CharacterIterator characterIterator) {
        this.ci = characterIterator;
        this.in = null;
    }

    public Base64InputStream(InputStream inputStream) {
        this.ci = null;
        this.in = inputStream;
    }

    public int read() throws IOException {
        while (true) {
            if (this.count > 0) {
                this.word <<= 8;
                --this.count;
                return this.word >>> 24;
            }
            if (this.eof) {
                return -1;
            }
            this.readWord();
        }
    }

    private void readWord() throws IOException {
        while (true) {
            int n = -1;
            if (this.ci != null) {
                n = this.ci.current();
                this.ci.next();
            }
            if (this.in != null) {
                n = this.in.read();
            }
            if (n < 0 || n == 61 || n == 65535) {
                this.padWord();
                this.eof = true;
                return;
            }
            if ((n = this.b64d(n)) < 0) continue;
            this.word <<= 6;
            this.word |= n;
            ++this.count;
            if (this.count > 3) break;
        }
        this.count = 3;
    }

    private void padWord() {
        if (this.count > 0) {
            for (int i = this.count; i <= 3; ++i) {
                this.word <<= 6;
            }
            --this.count;
        }
    }

    private int b64d(int n) {
        switch (n) {
            case 65: {
                return 0;
            }
            case 66: {
                return 1;
            }
            case 67: {
                return 2;
            }
            case 68: {
                return 3;
            }
            case 69: {
                return 4;
            }
            case 70: {
                return 5;
            }
            case 71: {
                return 6;
            }
            case 72: {
                return 7;
            }
            case 73: {
                return 8;
            }
            case 74: {
                return 9;
            }
            case 75: {
                return 10;
            }
            case 76: {
                return 11;
            }
            case 77: {
                return 12;
            }
            case 78: {
                return 13;
            }
            case 79: {
                return 14;
            }
            case 80: {
                return 15;
            }
            case 81: {
                return 16;
            }
            case 82: {
                return 17;
            }
            case 83: {
                return 18;
            }
            case 84: {
                return 19;
            }
            case 85: {
                return 20;
            }
            case 86: {
                return 21;
            }
            case 87: {
                return 22;
            }
            case 88: {
                return 23;
            }
            case 89: {
                return 24;
            }
            case 90: {
                return 25;
            }
            case 97: {
                return 26;
            }
            case 98: {
                return 27;
            }
            case 99: {
                return 28;
            }
            case 100: {
                return 29;
            }
            case 101: {
                return 30;
            }
            case 102: {
                return 31;
            }
            case 103: {
                return 32;
            }
            case 104: {
                return 33;
            }
            case 105: {
                return 34;
            }
            case 106: {
                return 35;
            }
            case 107: {
                return 36;
            }
            case 108: {
                return 37;
            }
            case 109: {
                return 38;
            }
            case 110: {
                return 39;
            }
            case 111: {
                return 40;
            }
            case 112: {
                return 41;
            }
            case 113: {
                return 42;
            }
            case 114: {
                return 43;
            }
            case 115: {
                return 44;
            }
            case 116: {
                return 45;
            }
            case 117: {
                return 46;
            }
            case 118: {
                return 47;
            }
            case 119: {
                return 48;
            }
            case 120: {
                return 49;
            }
            case 121: {
                return 50;
            }
            case 122: {
                return 51;
            }
            case 48: {
                return 52;
            }
            case 49: {
                return 53;
            }
            case 50: {
                return 54;
            }
            case 51: {
                return 55;
            }
            case 52: {
                return 56;
            }
            case 53: {
                return 57;
            }
            case 54: {
                return 58;
            }
            case 55: {
                return 59;
            }
            case 56: {
                return 60;
            }
            case 57: {
                return 61;
            }
            case 43: {
                return 62;
            }
            case 47: {
                return 63;
            }
        }
        return -1;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

