// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/dataflow/v1beta3/templates.proto

package dataflow

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ParameterType specifies what kind of input we need for this parameter.
type ParameterType int32

const (
	// Default input type.
	ParameterType_DEFAULT ParameterType = 0
	// The parameter specifies generic text input.
	ParameterType_TEXT ParameterType = 1
	// The parameter specifies a Cloud Storage Bucket to read from.
	ParameterType_GCS_READ_BUCKET ParameterType = 2
	// The parameter specifies a Cloud Storage Bucket to write to.
	ParameterType_GCS_WRITE_BUCKET ParameterType = 3
	// The parameter specifies a Cloud Storage file path to read from.
	ParameterType_GCS_READ_FILE ParameterType = 4
	// The parameter specifies a Cloud Storage file path to write to.
	ParameterType_GCS_WRITE_FILE ParameterType = 5
	// The parameter specifies a Cloud Storage folder path to read from.
	ParameterType_GCS_READ_FOLDER ParameterType = 6
	// The parameter specifies a Cloud Storage folder to write to.
	ParameterType_GCS_WRITE_FOLDER ParameterType = 7
	// The parameter specifies a Pub/Sub Topic.
	ParameterType_PUBSUB_TOPIC ParameterType = 8
	// The parameter specifies a Pub/Sub Subscription.
	ParameterType_PUBSUB_SUBSCRIPTION ParameterType = 9
)

// Enum value maps for ParameterType.
var (
	ParameterType_name = map[int32]string{
		0: "DEFAULT",
		1: "TEXT",
		2: "GCS_READ_BUCKET",
		3: "GCS_WRITE_BUCKET",
		4: "GCS_READ_FILE",
		5: "GCS_WRITE_FILE",
		6: "GCS_READ_FOLDER",
		7: "GCS_WRITE_FOLDER",
		8: "PUBSUB_TOPIC",
		9: "PUBSUB_SUBSCRIPTION",
	}
	ParameterType_value = map[string]int32{
		"DEFAULT":             0,
		"TEXT":                1,
		"GCS_READ_BUCKET":     2,
		"GCS_WRITE_BUCKET":    3,
		"GCS_READ_FILE":       4,
		"GCS_WRITE_FILE":      5,
		"GCS_READ_FOLDER":     6,
		"GCS_WRITE_FOLDER":    7,
		"PUBSUB_TOPIC":        8,
		"PUBSUB_SUBSCRIPTION": 9,
	}
)

func (x ParameterType) Enum() *ParameterType {
	p := new(ParameterType)
	*p = x
	return p
}

func (x ParameterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ParameterType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_templates_proto_enumTypes[0].Descriptor()
}

func (ParameterType) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_templates_proto_enumTypes[0]
}

func (x ParameterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ParameterType.Descriptor instead.
func (ParameterType) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{0}
}

// SDK Language.
type SDKInfo_Language int32

const (
	// UNKNOWN Language.
	SDKInfo_UNKNOWN SDKInfo_Language = 0
	// Java.
	SDKInfo_JAVA SDKInfo_Language = 1
	// Python.
	SDKInfo_PYTHON SDKInfo_Language = 2
)

// Enum value maps for SDKInfo_Language.
var (
	SDKInfo_Language_name = map[int32]string{
		0: "UNKNOWN",
		1: "JAVA",
		2: "PYTHON",
	}
	SDKInfo_Language_value = map[string]int32{
		"UNKNOWN": 0,
		"JAVA":    1,
		"PYTHON":  2,
	}
)

func (x SDKInfo_Language) Enum() *SDKInfo_Language {
	p := new(SDKInfo_Language)
	*p = x
	return p
}

func (x SDKInfo_Language) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SDKInfo_Language) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_templates_proto_enumTypes[1].Descriptor()
}

func (SDKInfo_Language) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_templates_proto_enumTypes[1]
}

func (x SDKInfo_Language) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SDKInfo_Language.Descriptor instead.
func (SDKInfo_Language) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{8, 0}
}

// The various views of a template that may be retrieved.
type GetTemplateRequest_TemplateView int32

const (
	// Template view that retrieves only the metadata associated with the
	// template.
	GetTemplateRequest_METADATA_ONLY GetTemplateRequest_TemplateView = 0
)

// Enum value maps for GetTemplateRequest_TemplateView.
var (
	GetTemplateRequest_TemplateView_name = map[int32]string{
		0: "METADATA_ONLY",
	}
	GetTemplateRequest_TemplateView_value = map[string]int32{
		"METADATA_ONLY": 0,
	}
)

func (x GetTemplateRequest_TemplateView) Enum() *GetTemplateRequest_TemplateView {
	p := new(GetTemplateRequest_TemplateView)
	*p = x
	return p
}

func (x GetTemplateRequest_TemplateView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetTemplateRequest_TemplateView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_templates_proto_enumTypes[2].Descriptor()
}

func (GetTemplateRequest_TemplateView) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_templates_proto_enumTypes[2]
}

func (x GetTemplateRequest_TemplateView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetTemplateRequest_TemplateView.Descriptor instead.
func (GetTemplateRequest_TemplateView) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{11, 0}
}

// Template Type.
type GetTemplateResponse_TemplateType int32

const (
	// Unknown Template Type.
	GetTemplateResponse_UNKNOWN GetTemplateResponse_TemplateType = 0
	// Legacy Template.
	GetTemplateResponse_LEGACY GetTemplateResponse_TemplateType = 1
	// Flex Template.
	GetTemplateResponse_FLEX GetTemplateResponse_TemplateType = 2
)

// Enum value maps for GetTemplateResponse_TemplateType.
var (
	GetTemplateResponse_TemplateType_name = map[int32]string{
		0: "UNKNOWN",
		1: "LEGACY",
		2: "FLEX",
	}
	GetTemplateResponse_TemplateType_value = map[string]int32{
		"UNKNOWN": 0,
		"LEGACY":  1,
		"FLEX":    2,
	}
)

func (x GetTemplateResponse_TemplateType) Enum() *GetTemplateResponse_TemplateType {
	p := new(GetTemplateResponse_TemplateType)
	*p = x
	return p
}

func (x GetTemplateResponse_TemplateType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetTemplateResponse_TemplateType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_templates_proto_enumTypes[3].Descriptor()
}

func (GetTemplateResponse_TemplateType) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_templates_proto_enumTypes[3]
}

func (x GetTemplateResponse_TemplateType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetTemplateResponse_TemplateType.Descriptor instead.
func (GetTemplateResponse_TemplateType) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{12, 0}
}

// Response to the request to launch a job from Flex Template.
type LaunchFlexTemplateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The job that was launched, if the request was not a dry run and
	// the job was successfully launched.
	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *LaunchFlexTemplateResponse) Reset() {
	*x = LaunchFlexTemplateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchFlexTemplateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchFlexTemplateResponse) ProtoMessage() {}

func (x *LaunchFlexTemplateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchFlexTemplateResponse.ProtoReflect.Descriptor instead.
func (*LaunchFlexTemplateResponse) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{0}
}

func (x *LaunchFlexTemplateResponse) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

// Container Spec.
type ContainerSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the docker container image. E.g., gcr.io/project/some-image
	Image string `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Metadata describing a template including description and validation rules.
	Metadata *TemplateMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Required. SDK info of the Flex Template.
	SdkInfo *SDKInfo `protobuf:"bytes,3,opt,name=sdk_info,json=sdkInfo,proto3" json:"sdk_info,omitempty"`
	// Default runtime environment for the job.
	DefaultEnvironment *FlexTemplateRuntimeEnvironment `protobuf:"bytes,4,opt,name=default_environment,json=defaultEnvironment,proto3" json:"default_environment,omitempty"`
}

func (x *ContainerSpec) Reset() {
	*x = ContainerSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerSpec) ProtoMessage() {}

func (x *ContainerSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerSpec.ProtoReflect.Descriptor instead.
func (*ContainerSpec) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{1}
}

func (x *ContainerSpec) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *ContainerSpec) GetMetadata() *TemplateMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ContainerSpec) GetSdkInfo() *SDKInfo {
	if x != nil {
		return x.SdkInfo
	}
	return nil
}

func (x *ContainerSpec) GetDefaultEnvironment() *FlexTemplateRuntimeEnvironment {
	if x != nil {
		return x.DefaultEnvironment
	}
	return nil
}

// Launch FlexTemplate Parameter.
type LaunchFlexTemplateParameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The job name to use for the created job. For update job request,
	// job name should be same as the existing running job.
	JobName string `protobuf:"bytes,1,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// Launch Mechanism.
	//
	// Types that are assignable to Template:
	//	*LaunchFlexTemplateParameter_ContainerSpec
	//	*LaunchFlexTemplateParameter_ContainerSpecGcsPath
	Template isLaunchFlexTemplateParameter_Template `protobuf_oneof:"template"`
	// The parameters for FlexTemplate.
	// Ex. {"num_workers":"5"}
	Parameters map[string]string `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Launch options for this flex template job. This is a common set of options
	// across languages and templates. This should not be used to pass job
	// parameters.
	LaunchOptions map[string]string `protobuf:"bytes,6,rep,name=launch_options,json=launchOptions,proto3" json:"launch_options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The runtime environment for the FlexTemplate job
	Environment *FlexTemplateRuntimeEnvironment `protobuf:"bytes,7,opt,name=environment,proto3" json:"environment,omitempty"`
	// Set this to true if you are sending a request to update a running
	// streaming job. When set, the job name should be the same as the
	// running job.
	Update bool `protobuf:"varint,8,opt,name=update,proto3" json:"update,omitempty"`
	// Use this to pass transform_name_mappings for streaming update jobs.
	// Ex:{"oldTransformName":"newTransformName",...}'
	TransformNameMappings map[string]string `protobuf:"bytes,9,rep,name=transform_name_mappings,json=transformNameMappings,proto3" json:"transform_name_mappings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *LaunchFlexTemplateParameter) Reset() {
	*x = LaunchFlexTemplateParameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchFlexTemplateParameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchFlexTemplateParameter) ProtoMessage() {}

func (x *LaunchFlexTemplateParameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchFlexTemplateParameter.ProtoReflect.Descriptor instead.
func (*LaunchFlexTemplateParameter) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{2}
}

func (x *LaunchFlexTemplateParameter) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

func (m *LaunchFlexTemplateParameter) GetTemplate() isLaunchFlexTemplateParameter_Template {
	if m != nil {
		return m.Template
	}
	return nil
}

func (x *LaunchFlexTemplateParameter) GetContainerSpec() *ContainerSpec {
	if x, ok := x.GetTemplate().(*LaunchFlexTemplateParameter_ContainerSpec); ok {
		return x.ContainerSpec
	}
	return nil
}

func (x *LaunchFlexTemplateParameter) GetContainerSpecGcsPath() string {
	if x, ok := x.GetTemplate().(*LaunchFlexTemplateParameter_ContainerSpecGcsPath); ok {
		return x.ContainerSpecGcsPath
	}
	return ""
}

func (x *LaunchFlexTemplateParameter) GetParameters() map[string]string {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *LaunchFlexTemplateParameter) GetLaunchOptions() map[string]string {
	if x != nil {
		return x.LaunchOptions
	}
	return nil
}

func (x *LaunchFlexTemplateParameter) GetEnvironment() *FlexTemplateRuntimeEnvironment {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *LaunchFlexTemplateParameter) GetUpdate() bool {
	if x != nil {
		return x.Update
	}
	return false
}

func (x *LaunchFlexTemplateParameter) GetTransformNameMappings() map[string]string {
	if x != nil {
		return x.TransformNameMappings
	}
	return nil
}

type isLaunchFlexTemplateParameter_Template interface {
	isLaunchFlexTemplateParameter_Template()
}

type LaunchFlexTemplateParameter_ContainerSpec struct {
	// Spec about the container image to launch.
	ContainerSpec *ContainerSpec `protobuf:"bytes,4,opt,name=container_spec,json=containerSpec,proto3,oneof"`
}

type LaunchFlexTemplateParameter_ContainerSpecGcsPath struct {
	// Cloud Storage path to a file with json serialized ContainerSpec as
	// content.
	ContainerSpecGcsPath string `protobuf:"bytes,5,opt,name=container_spec_gcs_path,json=containerSpecGcsPath,proto3,oneof"`
}

func (*LaunchFlexTemplateParameter_ContainerSpec) isLaunchFlexTemplateParameter_Template() {}

func (*LaunchFlexTemplateParameter_ContainerSpecGcsPath) isLaunchFlexTemplateParameter_Template() {}

// The environment values to be set at runtime for flex template.
type FlexTemplateRuntimeEnvironment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The initial number of Google Compute Engine instances for the job.
	NumWorkers int32 `protobuf:"varint,1,opt,name=num_workers,json=numWorkers,proto3" json:"num_workers,omitempty"`
	// The maximum number of Google Compute Engine instances to be made
	// available to your pipeline during execution, from 1 to 1000.
	MaxWorkers int32 `protobuf:"varint,2,opt,name=max_workers,json=maxWorkers,proto3" json:"max_workers,omitempty"`
	// The Compute Engine [availability
	// zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones)
	// for launching worker instances to run your pipeline.
	// In the future, worker_zone will take precedence.
	Zone string `protobuf:"bytes,3,opt,name=zone,proto3" json:"zone,omitempty"`
	// The email address of the service account to run the job as.
	ServiceAccountEmail string `protobuf:"bytes,4,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// The Cloud Storage path to use for temporary files.
	// Must be a valid Cloud Storage URL, beginning with `gs://`.
	TempLocation string `protobuf:"bytes,5,opt,name=temp_location,json=tempLocation,proto3" json:"temp_location,omitempty"`
	// The machine type to use for the job. Defaults to the value from the
	// template if not specified.
	MachineType string `protobuf:"bytes,6,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Additional experiment flags for the job.
	AdditionalExperiments []string `protobuf:"bytes,7,rep,name=additional_experiments,json=additionalExperiments,proto3" json:"additional_experiments,omitempty"`
	// Network to which VMs will be assigned.  If empty or unspecified,
	// the service will use the network "default".
	Network string `protobuf:"bytes,8,opt,name=network,proto3" json:"network,omitempty"`
	// Subnetwork to which VMs will be assigned, if desired. You can specify a
	// subnetwork using either a complete URL or an abbreviated path. Expected to
	// be of the form
	// "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK"
	// or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in
	// a Shared VPC network, you must use the complete URL.
	Subnetwork string `protobuf:"bytes,9,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Additional user labels to be specified for the job.
	// Keys and values must follow the restrictions specified in the [labeling
	// restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
	// page.
	// An object containing a list of "key": value pairs.
	// Example: { "name": "wrench", "mass": "1kg", "count": "3" }.
	AdditionalUserLabels map[string]string `protobuf:"bytes,10,rep,name=additional_user_labels,json=additionalUserLabels,proto3" json:"additional_user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Name for the Cloud KMS key for the job.
	// Key format is:
	// projects/<project>/locations/<location>/keyRings/<keyring>/cryptoKeys/<key>
	KmsKeyName string `protobuf:"bytes,11,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Configuration for VM IPs.
	IpConfiguration WorkerIPAddressConfiguration `protobuf:"varint,12,opt,name=ip_configuration,json=ipConfiguration,proto3,enum=google.dataflow.v1beta3.WorkerIPAddressConfiguration" json:"ip_configuration,omitempty"`
	// The Compute Engine region
	// (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
	// which worker processing should occur, e.g. "us-west1". Mutually exclusive
	// with worker_zone. If neither worker_region nor worker_zone is specified,
	// default to the control plane's region.
	WorkerRegion string `protobuf:"bytes,13,opt,name=worker_region,json=workerRegion,proto3" json:"worker_region,omitempty"`
	// The Compute Engine zone
	// (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
	// which worker processing should occur, e.g. "us-west1-a". Mutually exclusive
	// with worker_region. If neither worker_region nor worker_zone is specified,
	// a zone in the control plane's region is chosen based on available capacity.
	// If both `worker_zone` and `zone` are set, `worker_zone` takes precedence.
	WorkerZone string `protobuf:"bytes,14,opt,name=worker_zone,json=workerZone,proto3" json:"worker_zone,omitempty"`
	// Whether to enable Streaming Engine for the job.
	EnableStreamingEngine bool `protobuf:"varint,15,opt,name=enable_streaming_engine,json=enableStreamingEngine,proto3" json:"enable_streaming_engine,omitempty"`
	// Set FlexRS goal for the job.
	// https://cloud.google.com/dataflow/docs/guides/flexrs
	FlexrsGoal FlexResourceSchedulingGoal `protobuf:"varint,16,opt,name=flexrs_goal,json=flexrsGoal,proto3,enum=google.dataflow.v1beta3.FlexResourceSchedulingGoal" json:"flexrs_goal,omitempty"`
	// The Cloud Storage path for staging local files.
	// Must be a valid Cloud Storage URL, beginning with `gs://`.
	StagingLocation string `protobuf:"bytes,17,opt,name=staging_location,json=stagingLocation,proto3" json:"staging_location,omitempty"`
	// Docker registry location of container image to use for the 'worker harness.
	// Default is the container for the version of the SDK. Note this field is
	// only valid for portable pipelines.
	SdkContainerImage string `protobuf:"bytes,18,opt,name=sdk_container_image,json=sdkContainerImage,proto3" json:"sdk_container_image,omitempty"`
	// Worker disk size, in gigabytes.
	DiskSizeGb int32 `protobuf:"varint,20,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// The algorithm to use for autoscaling
	AutoscalingAlgorithm AutoscalingAlgorithm `protobuf:"varint,21,opt,name=autoscaling_algorithm,json=autoscalingAlgorithm,proto3,enum=google.dataflow.v1beta3.AutoscalingAlgorithm" json:"autoscaling_algorithm,omitempty"`
	// If true, save a heap dump before killing a thread or process which is GC
	// thrashing or out of memory. The location of the heap file will either be
	// echoed back to the user, or the user will be given the opportunity to
	// download the heap file.
	DumpHeapOnOom bool `protobuf:"varint,22,opt,name=dump_heap_on_oom,json=dumpHeapOnOom,proto3" json:"dump_heap_on_oom,omitempty"`
	// Cloud Storage bucket (directory) to upload heap dumps to the given
	// location. Enabling this implies that heap dumps should be generated on OOM
	// (dump_heap_on_oom is set to true).
	SaveHeapDumpsToGcsPath string `protobuf:"bytes,23,opt,name=save_heap_dumps_to_gcs_path,json=saveHeapDumpsToGcsPath,proto3" json:"save_heap_dumps_to_gcs_path,omitempty"`
	// The machine type to use for launching the job. The default is
	// n1-standard-1.
	LauncherMachineType string `protobuf:"bytes,24,opt,name=launcher_machine_type,json=launcherMachineType,proto3" json:"launcher_machine_type,omitempty"`
}

func (x *FlexTemplateRuntimeEnvironment) Reset() {
	*x = FlexTemplateRuntimeEnvironment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FlexTemplateRuntimeEnvironment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlexTemplateRuntimeEnvironment) ProtoMessage() {}

func (x *FlexTemplateRuntimeEnvironment) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlexTemplateRuntimeEnvironment.ProtoReflect.Descriptor instead.
func (*FlexTemplateRuntimeEnvironment) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{3}
}

func (x *FlexTemplateRuntimeEnvironment) GetNumWorkers() int32 {
	if x != nil {
		return x.NumWorkers
	}
	return 0
}

func (x *FlexTemplateRuntimeEnvironment) GetMaxWorkers() int32 {
	if x != nil {
		return x.MaxWorkers
	}
	return 0
}

func (x *FlexTemplateRuntimeEnvironment) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *FlexTemplateRuntimeEnvironment) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *FlexTemplateRuntimeEnvironment) GetTempLocation() string {
	if x != nil {
		return x.TempLocation
	}
	return ""
}

func (x *FlexTemplateRuntimeEnvironment) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *FlexTemplateRuntimeEnvironment) GetAdditionalExperiments() []string {
	if x != nil {
		return x.AdditionalExperiments
	}
	return nil
}

func (x *FlexTemplateRuntimeEnvironment) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *FlexTemplateRuntimeEnvironment) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *FlexTemplateRuntimeEnvironment) GetAdditionalUserLabels() map[string]string {
	if x != nil {
		return x.AdditionalUserLabels
	}
	return nil
}

func (x *FlexTemplateRuntimeEnvironment) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *FlexTemplateRuntimeEnvironment) GetIpConfiguration() WorkerIPAddressConfiguration {
	if x != nil {
		return x.IpConfiguration
	}
	return WorkerIPAddressConfiguration_WORKER_IP_UNSPECIFIED
}

func (x *FlexTemplateRuntimeEnvironment) GetWorkerRegion() string {
	if x != nil {
		return x.WorkerRegion
	}
	return ""
}

func (x *FlexTemplateRuntimeEnvironment) GetWorkerZone() string {
	if x != nil {
		return x.WorkerZone
	}
	return ""
}

func (x *FlexTemplateRuntimeEnvironment) GetEnableStreamingEngine() bool {
	if x != nil {
		return x.EnableStreamingEngine
	}
	return false
}

func (x *FlexTemplateRuntimeEnvironment) GetFlexrsGoal() FlexResourceSchedulingGoal {
	if x != nil {
		return x.FlexrsGoal
	}
	return FlexResourceSchedulingGoal_FLEXRS_UNSPECIFIED
}

func (x *FlexTemplateRuntimeEnvironment) GetStagingLocation() string {
	if x != nil {
		return x.StagingLocation
	}
	return ""
}

func (x *FlexTemplateRuntimeEnvironment) GetSdkContainerImage() string {
	if x != nil {
		return x.SdkContainerImage
	}
	return ""
}

func (x *FlexTemplateRuntimeEnvironment) GetDiskSizeGb() int32 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *FlexTemplateRuntimeEnvironment) GetAutoscalingAlgorithm() AutoscalingAlgorithm {
	if x != nil {
		return x.AutoscalingAlgorithm
	}
	return AutoscalingAlgorithm_AUTOSCALING_ALGORITHM_UNKNOWN
}

func (x *FlexTemplateRuntimeEnvironment) GetDumpHeapOnOom() bool {
	if x != nil {
		return x.DumpHeapOnOom
	}
	return false
}

func (x *FlexTemplateRuntimeEnvironment) GetSaveHeapDumpsToGcsPath() string {
	if x != nil {
		return x.SaveHeapDumpsToGcsPath
	}
	return ""
}

func (x *FlexTemplateRuntimeEnvironment) GetLauncherMachineType() string {
	if x != nil {
		return x.LauncherMachineType
	}
	return ""
}

// A request to launch a Cloud Dataflow job from a FlexTemplate.
type LaunchFlexTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Cloud Platform project that the job belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Parameter to launch a job form Flex Template.
	LaunchParameter *LaunchFlexTemplateParameter `protobuf:"bytes,2,opt,name=launch_parameter,json=launchParameter,proto3" json:"launch_parameter,omitempty"`
	// Required. The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
	// which to direct the request. E.g., us-central1, us-west1.
	Location string `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
	// If true, the request is validated but not actually executed.
	// Defaults to false.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *LaunchFlexTemplateRequest) Reset() {
	*x = LaunchFlexTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchFlexTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchFlexTemplateRequest) ProtoMessage() {}

func (x *LaunchFlexTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchFlexTemplateRequest.ProtoReflect.Descriptor instead.
func (*LaunchFlexTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{4}
}

func (x *LaunchFlexTemplateRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *LaunchFlexTemplateRequest) GetLaunchParameter() *LaunchFlexTemplateParameter {
	if x != nil {
		return x.LaunchParameter
	}
	return nil
}

func (x *LaunchFlexTemplateRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *LaunchFlexTemplateRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The environment values to set at runtime.
type RuntimeEnvironment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The initial number of Google Compute Engine instnaces for the job.
	NumWorkers int32 `protobuf:"varint,11,opt,name=num_workers,json=numWorkers,proto3" json:"num_workers,omitempty"`
	// The maximum number of Google Compute Engine instances to be made
	// available to your pipeline during execution, from 1 to 1000.
	MaxWorkers int32 `protobuf:"varint,1,opt,name=max_workers,json=maxWorkers,proto3" json:"max_workers,omitempty"`
	// The Compute Engine [availability
	// zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones)
	// for launching worker instances to run your pipeline.
	// In the future, worker_zone will take precedence.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// The email address of the service account to run the job as.
	ServiceAccountEmail string `protobuf:"bytes,3,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// The Cloud Storage path to use for temporary files.
	// Must be a valid Cloud Storage URL, beginning with `gs://`.
	TempLocation string `protobuf:"bytes,4,opt,name=temp_location,json=tempLocation,proto3" json:"temp_location,omitempty"`
	// Whether to bypass the safety checks for the job's temporary directory.
	// Use with caution.
	BypassTempDirValidation bool `protobuf:"varint,5,opt,name=bypass_temp_dir_validation,json=bypassTempDirValidation,proto3" json:"bypass_temp_dir_validation,omitempty"`
	// The machine type to use for the job. Defaults to the value from the
	// template if not specified.
	MachineType string `protobuf:"bytes,6,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Additional experiment flags for the job, specified with the
	// `--experiments` option.
	AdditionalExperiments []string `protobuf:"bytes,7,rep,name=additional_experiments,json=additionalExperiments,proto3" json:"additional_experiments,omitempty"`
	// Network to which VMs will be assigned.  If empty or unspecified,
	// the service will use the network "default".
	Network string `protobuf:"bytes,8,opt,name=network,proto3" json:"network,omitempty"`
	// Subnetwork to which VMs will be assigned, if desired. You can specify a
	// subnetwork using either a complete URL or an abbreviated path. Expected to
	// be of the form
	// "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK"
	// or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in
	// a Shared VPC network, you must use the complete URL.
	Subnetwork string `protobuf:"bytes,9,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Additional user labels to be specified for the job.
	// Keys and values should follow the restrictions specified in the [labeling
	// restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions)
	// page.
	// An object containing a list of "key": value pairs.
	// Example: { "name": "wrench", "mass": "1kg", "count": "3" }.
	AdditionalUserLabels map[string]string `protobuf:"bytes,10,rep,name=additional_user_labels,json=additionalUserLabels,proto3" json:"additional_user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Name for the Cloud KMS key for the job.
	// Key format is:
	// projects/<project>/locations/<location>/keyRings/<keyring>/cryptoKeys/<key>
	KmsKeyName string `protobuf:"bytes,12,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Configuration for VM IPs.
	IpConfiguration WorkerIPAddressConfiguration `protobuf:"varint,14,opt,name=ip_configuration,json=ipConfiguration,proto3,enum=google.dataflow.v1beta3.WorkerIPAddressConfiguration" json:"ip_configuration,omitempty"`
	// The Compute Engine region
	// (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
	// which worker processing should occur, e.g. "us-west1". Mutually exclusive
	// with worker_zone. If neither worker_region nor worker_zone is specified,
	// default to the control plane's region.
	WorkerRegion string `protobuf:"bytes,15,opt,name=worker_region,json=workerRegion,proto3" json:"worker_region,omitempty"`
	// The Compute Engine zone
	// (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
	// which worker processing should occur, e.g. "us-west1-a". Mutually exclusive
	// with worker_region. If neither worker_region nor worker_zone is specified,
	// a zone in the control plane's region is chosen based on available capacity.
	// If both `worker_zone` and `zone` are set, `worker_zone` takes precedence.
	WorkerZone string `protobuf:"bytes,16,opt,name=worker_zone,json=workerZone,proto3" json:"worker_zone,omitempty"`
	// Whether to enable Streaming Engine for the job.
	EnableStreamingEngine bool `protobuf:"varint,17,opt,name=enable_streaming_engine,json=enableStreamingEngine,proto3" json:"enable_streaming_engine,omitempty"`
}

func (x *RuntimeEnvironment) Reset() {
	*x = RuntimeEnvironment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeEnvironment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeEnvironment) ProtoMessage() {}

func (x *RuntimeEnvironment) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeEnvironment.ProtoReflect.Descriptor instead.
func (*RuntimeEnvironment) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{5}
}

func (x *RuntimeEnvironment) GetNumWorkers() int32 {
	if x != nil {
		return x.NumWorkers
	}
	return 0
}

func (x *RuntimeEnvironment) GetMaxWorkers() int32 {
	if x != nil {
		return x.MaxWorkers
	}
	return 0
}

func (x *RuntimeEnvironment) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *RuntimeEnvironment) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *RuntimeEnvironment) GetTempLocation() string {
	if x != nil {
		return x.TempLocation
	}
	return ""
}

func (x *RuntimeEnvironment) GetBypassTempDirValidation() bool {
	if x != nil {
		return x.BypassTempDirValidation
	}
	return false
}

func (x *RuntimeEnvironment) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *RuntimeEnvironment) GetAdditionalExperiments() []string {
	if x != nil {
		return x.AdditionalExperiments
	}
	return nil
}

func (x *RuntimeEnvironment) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *RuntimeEnvironment) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *RuntimeEnvironment) GetAdditionalUserLabels() map[string]string {
	if x != nil {
		return x.AdditionalUserLabels
	}
	return nil
}

func (x *RuntimeEnvironment) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *RuntimeEnvironment) GetIpConfiguration() WorkerIPAddressConfiguration {
	if x != nil {
		return x.IpConfiguration
	}
	return WorkerIPAddressConfiguration_WORKER_IP_UNSPECIFIED
}

func (x *RuntimeEnvironment) GetWorkerRegion() string {
	if x != nil {
		return x.WorkerRegion
	}
	return ""
}

func (x *RuntimeEnvironment) GetWorkerZone() string {
	if x != nil {
		return x.WorkerZone
	}
	return ""
}

func (x *RuntimeEnvironment) GetEnableStreamingEngine() bool {
	if x != nil {
		return x.EnableStreamingEngine
	}
	return false
}

// Metadata for a specific parameter.
type ParameterMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parameter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The label to display for the parameter.
	Label string `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
	// Required. The help text to display for the parameter.
	HelpText string `protobuf:"bytes,3,opt,name=help_text,json=helpText,proto3" json:"help_text,omitempty"`
	// Optional. Whether the parameter is optional. Defaults to false.
	IsOptional bool `protobuf:"varint,4,opt,name=is_optional,json=isOptional,proto3" json:"is_optional,omitempty"`
	// Optional. Regexes that the parameter must match.
	Regexes []string `protobuf:"bytes,5,rep,name=regexes,proto3" json:"regexes,omitempty"`
	// Optional. The type of the parameter.
	// Used for selecting input picker.
	ParamType ParameterType `protobuf:"varint,6,opt,name=param_type,json=paramType,proto3,enum=google.dataflow.v1beta3.ParameterType" json:"param_type,omitempty"`
	// Optional. Additional metadata for describing this parameter.
	CustomMetadata map[string]string `protobuf:"bytes,7,rep,name=custom_metadata,json=customMetadata,proto3" json:"custom_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ParameterMetadata) Reset() {
	*x = ParameterMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ParameterMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParameterMetadata) ProtoMessage() {}

func (x *ParameterMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParameterMetadata.ProtoReflect.Descriptor instead.
func (*ParameterMetadata) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{6}
}

func (x *ParameterMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ParameterMetadata) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *ParameterMetadata) GetHelpText() string {
	if x != nil {
		return x.HelpText
	}
	return ""
}

func (x *ParameterMetadata) GetIsOptional() bool {
	if x != nil {
		return x.IsOptional
	}
	return false
}

func (x *ParameterMetadata) GetRegexes() []string {
	if x != nil {
		return x.Regexes
	}
	return nil
}

func (x *ParameterMetadata) GetParamType() ParameterType {
	if x != nil {
		return x.ParamType
	}
	return ParameterType_DEFAULT
}

func (x *ParameterMetadata) GetCustomMetadata() map[string]string {
	if x != nil {
		return x.CustomMetadata
	}
	return nil
}

// Metadata describing a template.
type TemplateMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the template.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A description of the template.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The parameters for the template.
	Parameters []*ParameterMetadata `protobuf:"bytes,3,rep,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *TemplateMetadata) Reset() {
	*x = TemplateMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TemplateMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TemplateMetadata) ProtoMessage() {}

func (x *TemplateMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TemplateMetadata.ProtoReflect.Descriptor instead.
func (*TemplateMetadata) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{7}
}

func (x *TemplateMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TemplateMetadata) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TemplateMetadata) GetParameters() []*ParameterMetadata {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// SDK Information.
type SDKInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The SDK Language.
	Language SDKInfo_Language `protobuf:"varint,1,opt,name=language,proto3,enum=google.dataflow.v1beta3.SDKInfo_Language" json:"language,omitempty"`
	// Optional. The SDK version.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SDKInfo) Reset() {
	*x = SDKInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SDKInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SDKInfo) ProtoMessage() {}

func (x *SDKInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SDKInfo.ProtoReflect.Descriptor instead.
func (*SDKInfo) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{8}
}

func (x *SDKInfo) GetLanguage() SDKInfo_Language {
	if x != nil {
		return x.Language
	}
	return SDKInfo_UNKNOWN
}

func (x *SDKInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// RuntimeMetadata describing a runtime environment.
type RuntimeMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// SDK Info for the template.
	SdkInfo *SDKInfo `protobuf:"bytes,1,opt,name=sdk_info,json=sdkInfo,proto3" json:"sdk_info,omitempty"`
	// The parameters for the template.
	Parameters []*ParameterMetadata `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *RuntimeMetadata) Reset() {
	*x = RuntimeMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeMetadata) ProtoMessage() {}

func (x *RuntimeMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeMetadata.ProtoReflect.Descriptor instead.
func (*RuntimeMetadata) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{9}
}

func (x *RuntimeMetadata) GetSdkInfo() *SDKInfo {
	if x != nil {
		return x.SdkInfo
	}
	return nil
}

func (x *RuntimeMetadata) GetParameters() []*ParameterMetadata {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// A request to create a Cloud Dataflow job from a template.
type CreateJobFromTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Cloud Platform project that the job belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The job name to use for the created job.
	JobName string `protobuf:"bytes,4,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// The template from which to create the job.
	//
	// Types that are assignable to Template:
	//	*CreateJobFromTemplateRequest_GcsPath
	Template isCreateJobFromTemplateRequest_Template `protobuf_oneof:"template"`
	// The runtime parameters to pass to the job.
	Parameters map[string]string `protobuf:"bytes,3,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The runtime environment for the job.
	Environment *RuntimeEnvironment `protobuf:"bytes,5,opt,name=environment,proto3" json:"environment,omitempty"`
	// The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
	// which to direct the request.
	Location string `protobuf:"bytes,6,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *CreateJobFromTemplateRequest) Reset() {
	*x = CreateJobFromTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateJobFromTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateJobFromTemplateRequest) ProtoMessage() {}

func (x *CreateJobFromTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateJobFromTemplateRequest.ProtoReflect.Descriptor instead.
func (*CreateJobFromTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{10}
}

func (x *CreateJobFromTemplateRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateJobFromTemplateRequest) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

func (m *CreateJobFromTemplateRequest) GetTemplate() isCreateJobFromTemplateRequest_Template {
	if m != nil {
		return m.Template
	}
	return nil
}

func (x *CreateJobFromTemplateRequest) GetGcsPath() string {
	if x, ok := x.GetTemplate().(*CreateJobFromTemplateRequest_GcsPath); ok {
		return x.GcsPath
	}
	return ""
}

func (x *CreateJobFromTemplateRequest) GetParameters() map[string]string {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *CreateJobFromTemplateRequest) GetEnvironment() *RuntimeEnvironment {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *CreateJobFromTemplateRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

type isCreateJobFromTemplateRequest_Template interface {
	isCreateJobFromTemplateRequest_Template()
}

type CreateJobFromTemplateRequest_GcsPath struct {
	// Required. A Cloud Storage path to the template from which to
	// create the job.
	// Must be a valid Cloud Storage URL, beginning with `gs://`.
	GcsPath string `protobuf:"bytes,2,opt,name=gcs_path,json=gcsPath,proto3,oneof"`
}

func (*CreateJobFromTemplateRequest_GcsPath) isCreateJobFromTemplateRequest_Template() {}

// A request to retrieve a Cloud Dataflow job template.
type GetTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Cloud Platform project that the job belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The template from which to create the job.
	//
	// Types that are assignable to Template:
	//	*GetTemplateRequest_GcsPath
	Template isGetTemplateRequest_Template `protobuf_oneof:"template"`
	// The view to retrieve. Defaults to METADATA_ONLY.
	View GetTemplateRequest_TemplateView `protobuf:"varint,3,opt,name=view,proto3,enum=google.dataflow.v1beta3.GetTemplateRequest_TemplateView" json:"view,omitempty"`
	// The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
	// which to direct the request.
	Location string `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *GetTemplateRequest) Reset() {
	*x = GetTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTemplateRequest) ProtoMessage() {}

func (x *GetTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTemplateRequest.ProtoReflect.Descriptor instead.
func (*GetTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{11}
}

func (x *GetTemplateRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (m *GetTemplateRequest) GetTemplate() isGetTemplateRequest_Template {
	if m != nil {
		return m.Template
	}
	return nil
}

func (x *GetTemplateRequest) GetGcsPath() string {
	if x, ok := x.GetTemplate().(*GetTemplateRequest_GcsPath); ok {
		return x.GcsPath
	}
	return ""
}

func (x *GetTemplateRequest) GetView() GetTemplateRequest_TemplateView {
	if x != nil {
		return x.View
	}
	return GetTemplateRequest_METADATA_ONLY
}

func (x *GetTemplateRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

type isGetTemplateRequest_Template interface {
	isGetTemplateRequest_Template()
}

type GetTemplateRequest_GcsPath struct {
	// Required. A Cloud Storage path to the template from which to
	// create the job.
	// Must be valid Cloud Storage URL, beginning with 'gs://'.
	GcsPath string `protobuf:"bytes,2,opt,name=gcs_path,json=gcsPath,proto3,oneof"`
}

func (*GetTemplateRequest_GcsPath) isGetTemplateRequest_Template() {}

// The response to a GetTemplate request.
type GetTemplateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of the get template request. Any problems with the
	// request will be indicated in the error_details.
	Status *status.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// The template metadata describing the template name, available
	// parameters, etc.
	Metadata *TemplateMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Template Type.
	TemplateType GetTemplateResponse_TemplateType `protobuf:"varint,3,opt,name=template_type,json=templateType,proto3,enum=google.dataflow.v1beta3.GetTemplateResponse_TemplateType" json:"template_type,omitempty"`
	// Describes the runtime metadata with SDKInfo and available parameters.
	RuntimeMetadata *RuntimeMetadata `protobuf:"bytes,4,opt,name=runtime_metadata,json=runtimeMetadata,proto3" json:"runtime_metadata,omitempty"`
}

func (x *GetTemplateResponse) Reset() {
	*x = GetTemplateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTemplateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTemplateResponse) ProtoMessage() {}

func (x *GetTemplateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTemplateResponse.ProtoReflect.Descriptor instead.
func (*GetTemplateResponse) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{12}
}

func (x *GetTemplateResponse) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *GetTemplateResponse) GetMetadata() *TemplateMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *GetTemplateResponse) GetTemplateType() GetTemplateResponse_TemplateType {
	if x != nil {
		return x.TemplateType
	}
	return GetTemplateResponse_UNKNOWN
}

func (x *GetTemplateResponse) GetRuntimeMetadata() *RuntimeMetadata {
	if x != nil {
		return x.RuntimeMetadata
	}
	return nil
}

// Parameters to provide to the template being launched.
type LaunchTemplateParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The job name to use for the created job.
	JobName string `protobuf:"bytes,1,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// The runtime parameters to pass to the job.
	Parameters map[string]string `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The runtime environment for the job.
	Environment *RuntimeEnvironment `protobuf:"bytes,3,opt,name=environment,proto3" json:"environment,omitempty"`
	// If set, replace the existing pipeline with the name specified by jobName
	// with this pipeline, preserving state.
	Update bool `protobuf:"varint,4,opt,name=update,proto3" json:"update,omitempty"`
	// Only applicable when updating a pipeline. Map of transform name prefixes of
	// the job to be replaced to the corresponding name prefixes of the new job.
	TransformNameMapping map[string]string `protobuf:"bytes,5,rep,name=transform_name_mapping,json=transformNameMapping,proto3" json:"transform_name_mapping,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *LaunchTemplateParameters) Reset() {
	*x = LaunchTemplateParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchTemplateParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchTemplateParameters) ProtoMessage() {}

func (x *LaunchTemplateParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchTemplateParameters.ProtoReflect.Descriptor instead.
func (*LaunchTemplateParameters) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{13}
}

func (x *LaunchTemplateParameters) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

func (x *LaunchTemplateParameters) GetParameters() map[string]string {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *LaunchTemplateParameters) GetEnvironment() *RuntimeEnvironment {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *LaunchTemplateParameters) GetUpdate() bool {
	if x != nil {
		return x.Update
	}
	return false
}

func (x *LaunchTemplateParameters) GetTransformNameMapping() map[string]string {
	if x != nil {
		return x.TransformNameMapping
	}
	return nil
}

// A request to launch a template.
type LaunchTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Cloud Platform project that the job belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// If true, the request is validated but not actually executed.
	// Defaults to false.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// The template from which to create the job.
	//
	// Types that are assignable to Template:
	//	*LaunchTemplateRequest_GcsPath
	//	*LaunchTemplateRequest_DynamicTemplate
	Template isLaunchTemplateRequest_Template `protobuf_oneof:"template"`
	// The parameters of the template to launch. This should be part of the
	// body of the POST request.
	LaunchParameters *LaunchTemplateParameters `protobuf:"bytes,4,opt,name=launch_parameters,json=launchParameters,proto3" json:"launch_parameters,omitempty"`
	// The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
	// which to direct the request.
	Location string `protobuf:"bytes,5,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *LaunchTemplateRequest) Reset() {
	*x = LaunchTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchTemplateRequest) ProtoMessage() {}

func (x *LaunchTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchTemplateRequest.ProtoReflect.Descriptor instead.
func (*LaunchTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{14}
}

func (x *LaunchTemplateRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *LaunchTemplateRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (m *LaunchTemplateRequest) GetTemplate() isLaunchTemplateRequest_Template {
	if m != nil {
		return m.Template
	}
	return nil
}

func (x *LaunchTemplateRequest) GetGcsPath() string {
	if x, ok := x.GetTemplate().(*LaunchTemplateRequest_GcsPath); ok {
		return x.GcsPath
	}
	return ""
}

func (x *LaunchTemplateRequest) GetDynamicTemplate() *DynamicTemplateLaunchParams {
	if x, ok := x.GetTemplate().(*LaunchTemplateRequest_DynamicTemplate); ok {
		return x.DynamicTemplate
	}
	return nil
}

func (x *LaunchTemplateRequest) GetLaunchParameters() *LaunchTemplateParameters {
	if x != nil {
		return x.LaunchParameters
	}
	return nil
}

func (x *LaunchTemplateRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

type isLaunchTemplateRequest_Template interface {
	isLaunchTemplateRequest_Template()
}

type LaunchTemplateRequest_GcsPath struct {
	// A Cloud Storage path to the template from which to create
	// the job.
	// Must be valid Cloud Storage URL, beginning with 'gs://'.
	GcsPath string `protobuf:"bytes,3,opt,name=gcs_path,json=gcsPath,proto3,oneof"`
}

type LaunchTemplateRequest_DynamicTemplate struct {
	// Params for launching a dynamic template.
	DynamicTemplate *DynamicTemplateLaunchParams `protobuf:"bytes,6,opt,name=dynamic_template,json=dynamicTemplate,proto3,oneof"`
}

func (*LaunchTemplateRequest_GcsPath) isLaunchTemplateRequest_Template() {}

func (*LaunchTemplateRequest_DynamicTemplate) isLaunchTemplateRequest_Template() {}

// Response to the request to launch a template.
type LaunchTemplateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The job that was launched, if the request was not a dry run and
	// the job was successfully launched.
	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *LaunchTemplateResponse) Reset() {
	*x = LaunchTemplateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchTemplateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchTemplateResponse) ProtoMessage() {}

func (x *LaunchTemplateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchTemplateResponse.ProtoReflect.Descriptor instead.
func (*LaunchTemplateResponse) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{15}
}

func (x *LaunchTemplateResponse) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

// Used in the error_details field of a google.rpc.Status message, this
// indicates problems with the template parameter.
type InvalidTemplateParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes all parameter violations in a template request.
	ParameterViolations []*InvalidTemplateParameters_ParameterViolation `protobuf:"bytes,1,rep,name=parameter_violations,json=parameterViolations,proto3" json:"parameter_violations,omitempty"`
}

func (x *InvalidTemplateParameters) Reset() {
	*x = InvalidTemplateParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InvalidTemplateParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvalidTemplateParameters) ProtoMessage() {}

func (x *InvalidTemplateParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvalidTemplateParameters.ProtoReflect.Descriptor instead.
func (*InvalidTemplateParameters) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{16}
}

func (x *InvalidTemplateParameters) GetParameterViolations() []*InvalidTemplateParameters_ParameterViolation {
	if x != nil {
		return x.ParameterViolations
	}
	return nil
}

// Params which should be passed when launching a dynamic template.
type DynamicTemplateLaunchParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to dynamic template spec file on Cloud Storage.
	// The file must be a Json serialized DynamicTemplateFieSpec object.
	GcsPath string `protobuf:"bytes,1,opt,name=gcs_path,json=gcsPath,proto3" json:"gcs_path,omitempty"`
	// Cloud Storage path for staging dependencies.
	// Must be a valid Cloud Storage URL, beginning with `gs://`.
	StagingLocation string `protobuf:"bytes,2,opt,name=staging_location,json=stagingLocation,proto3" json:"staging_location,omitempty"`
}

func (x *DynamicTemplateLaunchParams) Reset() {
	*x = DynamicTemplateLaunchParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DynamicTemplateLaunchParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicTemplateLaunchParams) ProtoMessage() {}

func (x *DynamicTemplateLaunchParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicTemplateLaunchParams.ProtoReflect.Descriptor instead.
func (*DynamicTemplateLaunchParams) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{17}
}

func (x *DynamicTemplateLaunchParams) GetGcsPath() string {
	if x != nil {
		return x.GcsPath
	}
	return ""
}

func (x *DynamicTemplateLaunchParams) GetStagingLocation() string {
	if x != nil {
		return x.StagingLocation
	}
	return ""
}

// A specific template-parameter violation.
type InvalidTemplateParameters_ParameterViolation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parameter that failed to validate.
	Parameter string `protobuf:"bytes,1,opt,name=parameter,proto3" json:"parameter,omitempty"`
	// A description of why the parameter failed to validate.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *InvalidTemplateParameters_ParameterViolation) Reset() {
	*x = InvalidTemplateParameters_ParameterViolation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InvalidTemplateParameters_ParameterViolation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvalidTemplateParameters_ParameterViolation) ProtoMessage() {}

func (x *InvalidTemplateParameters_ParameterViolation) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_templates_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvalidTemplateParameters_ParameterViolation.ProtoReflect.Descriptor instead.
func (*InvalidTemplateParameters_ParameterViolation) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_templates_proto_rawDescGZIP(), []int{16, 0}
}

func (x *InvalidTemplateParameters_ParameterViolation) GetParameter() string {
	if x != nil {
		return x.Parameter
	}
	return ""
}

func (x *InvalidTemplateParameters_ParameterViolation) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

var File_google_dataflow_v1beta3_templates_proto protoreflect.FileDescriptor

var file_google_dataflow_v1beta3_templates_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x6a, 0x6f,
	0x62, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x4c, 0x0a, 0x1a, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x46, 0x6c, 0x65, 0x78, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x2e, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22,
	0x93, 0x02, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x45, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b,
	0x0a, 0x08, 0x73, 0x64, 0x6b, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x44, 0x4b, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x07, 0x73, 0x64, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x68, 0x0a, 0x13, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x46, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xec, 0x06, 0x0a, 0x1b, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68,
	0x46, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x4f, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63,
	0x48, 0x00, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x37, 0x0a, 0x17, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53,
	0x70, 0x65, 0x63, 0x47, 0x63, 0x73, 0x50, 0x61, 0x74, 0x68, 0x12, 0x64, 0x0a, 0x0a, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x46,
	0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x6e, 0x0a, 0x0e, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x46, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x4c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0d, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x59, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x46, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x17, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x46, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0x3d, 0x0a,
	0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x40, 0x0a, 0x12,
	0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x48,
	0x0a, 0x1a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x4d,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x22, 0x89, 0x0a, 0x0a, 0x1e, 0x46, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x75, 0x6d, 0x5f, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6e, 0x75,
	0x6d, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f,
	0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d,
	0x61, 0x78, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x32, 0x0a,
	0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69,
	0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x65, 0x6d, 0x70, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x65, 0x6d, 0x70, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x35, 0x0a, 0x16, 0x61, 0x64, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x61, 0x64, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x87, 0x01, 0x0a, 0x16, 0x61,
	0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x46, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14,
	0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b,
	0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x10, 0x69, 0x70, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x49, 0x50, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x69, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a,
	0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x36,
	0x0a, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x54, 0x0a, 0x0b, 0x66, 0x6c, 0x65, 0x78, 0x72, 0x73,
	0x5f, 0x67, 0x6f, 0x61, 0x6c, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x46, 0x6c, 0x65, 0x78, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x47, 0x6f, 0x61, 0x6c,
	0x52, 0x0a, 0x66, 0x6c, 0x65, 0x78, 0x72, 0x73, 0x47, 0x6f, 0x61, 0x6c, 0x12, 0x29, 0x0a, 0x10,
	0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x64, 0x6b, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x73, 0x64, 0x6b, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x14, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x64,
	0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x62, 0x0a, 0x15, 0x61, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x6c,
	0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x14, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x27, 0x0a,
	0x10, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x65, 0x61, 0x70, 0x5f, 0x6f, 0x6e, 0x5f, 0x6f, 0x6f,
	0x6d, 0x18, 0x16, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x64, 0x75, 0x6d, 0x70, 0x48, 0x65, 0x61,
	0x70, 0x4f, 0x6e, 0x4f, 0x6f, 0x6d, 0x12, 0x3b, 0x0a, 0x1b, 0x73, 0x61, 0x76, 0x65, 0x5f, 0x68,
	0x65, 0x61, 0x70, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x67, 0x63, 0x73,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x73, 0x61, 0x76,
	0x65, 0x48, 0x65, 0x61, 0x70, 0x44, 0x75, 0x6d, 0x70, 0x73, 0x54, 0x6f, 0x47, 0x63, 0x73, 0x50,
	0x61, 0x74, 0x68, 0x12, 0x32, 0x0a, 0x15, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x65, 0x72, 0x5f,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x18, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x13, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x65, 0x72, 0x4d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x47, 0x0a, 0x19, 0x41, 0x64, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0xdc, 0x01, 0x0a, 0x19, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x46, 0x6c, 0x65, 0x78, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x5f, 0x0a,
	0x10, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x46, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0f, 0x6c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x1a,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22,
	0xdc, 0x06, 0x0a, 0x12, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x75, 0x6d, 0x5f, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6e, 0x75, 0x6d,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61,
	0x78, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x32, 0x0a, 0x15,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c,
	0x12, 0x23, 0x0a, 0x0d, 0x74, 0x65, 0x6d, 0x70, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x65, 0x6d, 0x70, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x1a, 0x62, 0x79, 0x70, 0x61, 0x73, 0x73, 0x5f,
	0x74, 0x65, 0x6d, 0x70, 0x5f, 0x64, 0x69, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x62, 0x79, 0x70, 0x61, 0x73,
	0x73, 0x54, 0x65, 0x6d, 0x70, 0x44, 0x69, 0x72, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x35, 0x0a, 0x16, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x7b, 0x0a, 0x16, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14, 0x61,
	0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x10, 0x69, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x49, 0x50, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x69, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b,
	0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x36, 0x0a,
	0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x1a, 0x47, 0x0a, 0x19, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x88,
	0x03, 0x0a, 0x11, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x1b,
	0x0a, 0x09, 0x68, 0x65, 0x6c, 0x70, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x68, 0x65, 0x6c, 0x70, 0x54, 0x65, 0x78, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x69,
	0x73, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x69, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x12, 0x18, 0x0a, 0x07,
	0x72, 0x65, 0x67, 0x65, 0x78, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x72,
	0x65, 0x67, 0x65, 0x78, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x09, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x12, 0x67, 0x0a,
	0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x41, 0x0a, 0x13, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x94, 0x01, 0x0a, 0x10, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x22, 0x99, 0x01, 0x0a, 0x07, 0x53, 0x44, 0x4b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x45, 0x0a, 0x08,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x44, 0x4b, 0x49, 0x6e, 0x66, 0x6f,
	0x2e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x2d, 0x0a,
	0x08, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x41, 0x56, 0x41, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x50, 0x59, 0x54, 0x48, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0x9a, 0x01, 0x0a,
	0x0f, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x3b, 0x0a, 0x08, 0x73, 0x64, 0x6b, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x44, 0x4b,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x73, 0x64, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4a, 0x0a,
	0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0a, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x92, 0x03, 0x0a, 0x1c, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x08, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x67, 0x63, 0x73, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x65, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0xe9,
	0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x08, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x67, 0x63, 0x73, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x4c, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12,
	0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x21, 0x0a, 0x0c, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x11, 0x0a, 0x0d, 0x4d,
	0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x00, 0x42, 0x0a,
	0x0a, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0xf0, 0x02, 0x0a, 0x13, 0x47,
	0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x45,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5e, 0x0a, 0x0d, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x53, 0x0a, 0x10, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x31, 0x0a, 0x0c, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x45, 0x47, 0x41, 0x43,
	0x59, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x4c, 0x45, 0x58, 0x10, 0x02, 0x22, 0x8b, 0x04,
	0x0a, 0x18, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f,
	0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f,
	0x62, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12,
	0x81, 0x01, 0x0a, 0x16, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63,
	0x68, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x4e, 0x61, 0x6d,
	0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x47, 0x0a, 0x19, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x4e,
	0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xe3, 0x02, 0x0a, 0x15,
	0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x1b, 0x0a, 0x08, 0x67, 0x63, 0x73,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x67,
	0x63, 0x73, 0x50, 0x61, 0x74, 0x68, 0x12, 0x61, 0x0a, 0x10, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d,
	0x69, 0x63, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x5e, 0x0a, 0x11, 0x6c, 0x61, 0x75,
	0x6e, 0x63, 0x68, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x10, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x22, 0x48, 0x0a, 0x16, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x03, 0x6a,
	0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0xeb, 0x01, 0x0a, 0x19,
	0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x78, 0x0a, 0x14, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x1a, 0x54, 0x0a, 0x12, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x63, 0x0a, 0x1b, 0x44, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x75, 0x6e,
	0x63, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x63, 0x73, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x63, 0x73, 0x50,
	0x61, 0x74, 0x68, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73,
	0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2a, 0xce,
	0x01, 0x0a, 0x0d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x54, 0x45, 0x58, 0x54, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x47, 0x43, 0x53, 0x5f, 0x52,
	0x45, 0x41, 0x44, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10,
	0x47, 0x43, 0x53, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54,
	0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x47, 0x43, 0x53, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x46,
	0x49, 0x4c, 0x45, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x47, 0x43, 0x53, 0x5f, 0x57, 0x52, 0x49,
	0x54, 0x45, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f, 0x47, 0x43, 0x53,
	0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x46, 0x4f, 0x4c, 0x44, 0x45, 0x52, 0x10, 0x06, 0x12, 0x14,
	0x0a, 0x10, 0x47, 0x43, 0x53, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x46, 0x4f, 0x4c, 0x44,
	0x45, 0x52, 0x10, 0x07, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x55, 0x42, 0x53, 0x55, 0x42, 0x5f, 0x54,
	0x4f, 0x50, 0x49, 0x43, 0x10, 0x08, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x55, 0x42, 0x53, 0x55, 0x42,
	0x5f, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x09, 0x32,
	0xc2, 0x07, 0x0a, 0x10, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xdf, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a,
	0x6f, 0x62, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a,
	0x6f, 0x62, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x4a, 0x6f, 0x62, 0x22, 0x71, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6b, 0x22, 0x3a, 0x2f, 0x76, 0x31,
	0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x2a, 0x22, 0x25, 0x2f, 0x76,
	0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0x12, 0x94, 0x02, 0x0a, 0x0e, 0x4c, 0x61, 0x75, 0x6e, 0x63,
	0x68, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa0, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x99, 0x01, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x3a, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x3a, 0x11, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x5a, 0x41, 0x22, 0x2c, 0x2f, 0x76,
	0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x3a, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x3a, 0x11, 0x6c, 0x61, 0x75, 0x6e,
	0x63, 0x68, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0xdd, 0x01,
	0x0a, 0x0b, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6d,
	0x12, 0x3e, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x3a, 0x67, 0x65, 0x74,
	0x5a, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x3a, 0x67, 0x65, 0x74, 0x1a, 0xd4, 0x01,
	0xca, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0xb6, 0x01, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x72, 0x65, 0x61,
	0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x65,
	0x6d, 0x61, 0x69, 0x6c, 0x32, 0xbf, 0x03, 0x0a, 0x14, 0x46, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xcf, 0x01,
	0x0a, 0x12, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x46, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x46, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x46, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x6c, 0x65, 0x78, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x3a, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x3a, 0x01, 0x2a, 0x1a,
	0xd4, 0x01, 0xca, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0xb6, 0x01,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x72,
	0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x69, 0x6e, 0x66, 0x6f,
	0x2e, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x42, 0xd3, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x42, 0x0e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x3b, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x33, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_dataflow_v1beta3_templates_proto_rawDescOnce sync.Once
	file_google_dataflow_v1beta3_templates_proto_rawDescData = file_google_dataflow_v1beta3_templates_proto_rawDesc
)

func file_google_dataflow_v1beta3_templates_proto_rawDescGZIP() []byte {
	file_google_dataflow_v1beta3_templates_proto_rawDescOnce.Do(func() {
		file_google_dataflow_v1beta3_templates_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_dataflow_v1beta3_templates_proto_rawDescData)
	})
	return file_google_dataflow_v1beta3_templates_proto_rawDescData
}

var file_google_dataflow_v1beta3_templates_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_dataflow_v1beta3_templates_proto_msgTypes = make([]protoimpl.MessageInfo, 28)
var file_google_dataflow_v1beta3_templates_proto_goTypes = []interface{}{
	(ParameterType)(0),                     // 0: google.dataflow.v1beta3.ParameterType
	(SDKInfo_Language)(0),                  // 1: google.dataflow.v1beta3.SDKInfo.Language
	(GetTemplateRequest_TemplateView)(0),   // 2: google.dataflow.v1beta3.GetTemplateRequest.TemplateView
	(GetTemplateResponse_TemplateType)(0),  // 3: google.dataflow.v1beta3.GetTemplateResponse.TemplateType
	(*LaunchFlexTemplateResponse)(nil),     // 4: google.dataflow.v1beta3.LaunchFlexTemplateResponse
	(*ContainerSpec)(nil),                  // 5: google.dataflow.v1beta3.ContainerSpec
	(*LaunchFlexTemplateParameter)(nil),    // 6: google.dataflow.v1beta3.LaunchFlexTemplateParameter
	(*FlexTemplateRuntimeEnvironment)(nil), // 7: google.dataflow.v1beta3.FlexTemplateRuntimeEnvironment
	(*LaunchFlexTemplateRequest)(nil),      // 8: google.dataflow.v1beta3.LaunchFlexTemplateRequest
	(*RuntimeEnvironment)(nil),             // 9: google.dataflow.v1beta3.RuntimeEnvironment
	(*ParameterMetadata)(nil),              // 10: google.dataflow.v1beta3.ParameterMetadata
	(*TemplateMetadata)(nil),               // 11: google.dataflow.v1beta3.TemplateMetadata
	(*SDKInfo)(nil),                        // 12: google.dataflow.v1beta3.SDKInfo
	(*RuntimeMetadata)(nil),                // 13: google.dataflow.v1beta3.RuntimeMetadata
	(*CreateJobFromTemplateRequest)(nil),   // 14: google.dataflow.v1beta3.CreateJobFromTemplateRequest
	(*GetTemplateRequest)(nil),             // 15: google.dataflow.v1beta3.GetTemplateRequest
	(*GetTemplateResponse)(nil),            // 16: google.dataflow.v1beta3.GetTemplateResponse
	(*LaunchTemplateParameters)(nil),       // 17: google.dataflow.v1beta3.LaunchTemplateParameters
	(*LaunchTemplateRequest)(nil),          // 18: google.dataflow.v1beta3.LaunchTemplateRequest
	(*LaunchTemplateResponse)(nil),         // 19: google.dataflow.v1beta3.LaunchTemplateResponse
	(*InvalidTemplateParameters)(nil),      // 20: google.dataflow.v1beta3.InvalidTemplateParameters
	(*DynamicTemplateLaunchParams)(nil),    // 21: google.dataflow.v1beta3.DynamicTemplateLaunchParams
	nil,                                    // 22: google.dataflow.v1beta3.LaunchFlexTemplateParameter.ParametersEntry
	nil,                                    // 23: google.dataflow.v1beta3.LaunchFlexTemplateParameter.LaunchOptionsEntry
	nil,                                    // 24: google.dataflow.v1beta3.LaunchFlexTemplateParameter.TransformNameMappingsEntry
	nil,                                    // 25: google.dataflow.v1beta3.FlexTemplateRuntimeEnvironment.AdditionalUserLabelsEntry
	nil,                                    // 26: google.dataflow.v1beta3.RuntimeEnvironment.AdditionalUserLabelsEntry
	nil,                                    // 27: google.dataflow.v1beta3.ParameterMetadata.CustomMetadataEntry
	nil,                                    // 28: google.dataflow.v1beta3.CreateJobFromTemplateRequest.ParametersEntry
	nil,                                    // 29: google.dataflow.v1beta3.LaunchTemplateParameters.ParametersEntry
	nil,                                    // 30: google.dataflow.v1beta3.LaunchTemplateParameters.TransformNameMappingEntry
	(*InvalidTemplateParameters_ParameterViolation)(nil), // 31: google.dataflow.v1beta3.InvalidTemplateParameters.ParameterViolation
	(*Job)(nil),                       // 32: google.dataflow.v1beta3.Job
	(WorkerIPAddressConfiguration)(0), // 33: google.dataflow.v1beta3.WorkerIPAddressConfiguration
	(FlexResourceSchedulingGoal)(0),   // 34: google.dataflow.v1beta3.FlexResourceSchedulingGoal
	(AutoscalingAlgorithm)(0),         // 35: google.dataflow.v1beta3.AutoscalingAlgorithm
	(*status.Status)(nil),             // 36: google.rpc.Status
}
var file_google_dataflow_v1beta3_templates_proto_depIdxs = []int32{
	32, // 0: google.dataflow.v1beta3.LaunchFlexTemplateResponse.job:type_name -> google.dataflow.v1beta3.Job
	11, // 1: google.dataflow.v1beta3.ContainerSpec.metadata:type_name -> google.dataflow.v1beta3.TemplateMetadata
	12, // 2: google.dataflow.v1beta3.ContainerSpec.sdk_info:type_name -> google.dataflow.v1beta3.SDKInfo
	7,  // 3: google.dataflow.v1beta3.ContainerSpec.default_environment:type_name -> google.dataflow.v1beta3.FlexTemplateRuntimeEnvironment
	5,  // 4: google.dataflow.v1beta3.LaunchFlexTemplateParameter.container_spec:type_name -> google.dataflow.v1beta3.ContainerSpec
	22, // 5: google.dataflow.v1beta3.LaunchFlexTemplateParameter.parameters:type_name -> google.dataflow.v1beta3.LaunchFlexTemplateParameter.ParametersEntry
	23, // 6: google.dataflow.v1beta3.LaunchFlexTemplateParameter.launch_options:type_name -> google.dataflow.v1beta3.LaunchFlexTemplateParameter.LaunchOptionsEntry
	7,  // 7: google.dataflow.v1beta3.LaunchFlexTemplateParameter.environment:type_name -> google.dataflow.v1beta3.FlexTemplateRuntimeEnvironment
	24, // 8: google.dataflow.v1beta3.LaunchFlexTemplateParameter.transform_name_mappings:type_name -> google.dataflow.v1beta3.LaunchFlexTemplateParameter.TransformNameMappingsEntry
	25, // 9: google.dataflow.v1beta3.FlexTemplateRuntimeEnvironment.additional_user_labels:type_name -> google.dataflow.v1beta3.FlexTemplateRuntimeEnvironment.AdditionalUserLabelsEntry
	33, // 10: google.dataflow.v1beta3.FlexTemplateRuntimeEnvironment.ip_configuration:type_name -> google.dataflow.v1beta3.WorkerIPAddressConfiguration
	34, // 11: google.dataflow.v1beta3.FlexTemplateRuntimeEnvironment.flexrs_goal:type_name -> google.dataflow.v1beta3.FlexResourceSchedulingGoal
	35, // 12: google.dataflow.v1beta3.FlexTemplateRuntimeEnvironment.autoscaling_algorithm:type_name -> google.dataflow.v1beta3.AutoscalingAlgorithm
	6,  // 13: google.dataflow.v1beta3.LaunchFlexTemplateRequest.launch_parameter:type_name -> google.dataflow.v1beta3.LaunchFlexTemplateParameter
	26, // 14: google.dataflow.v1beta3.RuntimeEnvironment.additional_user_labels:type_name -> google.dataflow.v1beta3.RuntimeEnvironment.AdditionalUserLabelsEntry
	33, // 15: google.dataflow.v1beta3.RuntimeEnvironment.ip_configuration:type_name -> google.dataflow.v1beta3.WorkerIPAddressConfiguration
	0,  // 16: google.dataflow.v1beta3.ParameterMetadata.param_type:type_name -> google.dataflow.v1beta3.ParameterType
	27, // 17: google.dataflow.v1beta3.ParameterMetadata.custom_metadata:type_name -> google.dataflow.v1beta3.ParameterMetadata.CustomMetadataEntry
	10, // 18: google.dataflow.v1beta3.TemplateMetadata.parameters:type_name -> google.dataflow.v1beta3.ParameterMetadata
	1,  // 19: google.dataflow.v1beta3.SDKInfo.language:type_name -> google.dataflow.v1beta3.SDKInfo.Language
	12, // 20: google.dataflow.v1beta3.RuntimeMetadata.sdk_info:type_name -> google.dataflow.v1beta3.SDKInfo
	10, // 21: google.dataflow.v1beta3.RuntimeMetadata.parameters:type_name -> google.dataflow.v1beta3.ParameterMetadata
	28, // 22: google.dataflow.v1beta3.CreateJobFromTemplateRequest.parameters:type_name -> google.dataflow.v1beta3.CreateJobFromTemplateRequest.ParametersEntry
	9,  // 23: google.dataflow.v1beta3.CreateJobFromTemplateRequest.environment:type_name -> google.dataflow.v1beta3.RuntimeEnvironment
	2,  // 24: google.dataflow.v1beta3.GetTemplateRequest.view:type_name -> google.dataflow.v1beta3.GetTemplateRequest.TemplateView
	36, // 25: google.dataflow.v1beta3.GetTemplateResponse.status:type_name -> google.rpc.Status
	11, // 26: google.dataflow.v1beta3.GetTemplateResponse.metadata:type_name -> google.dataflow.v1beta3.TemplateMetadata
	3,  // 27: google.dataflow.v1beta3.GetTemplateResponse.template_type:type_name -> google.dataflow.v1beta3.GetTemplateResponse.TemplateType
	13, // 28: google.dataflow.v1beta3.GetTemplateResponse.runtime_metadata:type_name -> google.dataflow.v1beta3.RuntimeMetadata
	29, // 29: google.dataflow.v1beta3.LaunchTemplateParameters.parameters:type_name -> google.dataflow.v1beta3.LaunchTemplateParameters.ParametersEntry
	9,  // 30: google.dataflow.v1beta3.LaunchTemplateParameters.environment:type_name -> google.dataflow.v1beta3.RuntimeEnvironment
	30, // 31: google.dataflow.v1beta3.LaunchTemplateParameters.transform_name_mapping:type_name -> google.dataflow.v1beta3.LaunchTemplateParameters.TransformNameMappingEntry
	21, // 32: google.dataflow.v1beta3.LaunchTemplateRequest.dynamic_template:type_name -> google.dataflow.v1beta3.DynamicTemplateLaunchParams
	17, // 33: google.dataflow.v1beta3.LaunchTemplateRequest.launch_parameters:type_name -> google.dataflow.v1beta3.LaunchTemplateParameters
	32, // 34: google.dataflow.v1beta3.LaunchTemplateResponse.job:type_name -> google.dataflow.v1beta3.Job
	31, // 35: google.dataflow.v1beta3.InvalidTemplateParameters.parameter_violations:type_name -> google.dataflow.v1beta3.InvalidTemplateParameters.ParameterViolation
	14, // 36: google.dataflow.v1beta3.TemplatesService.CreateJobFromTemplate:input_type -> google.dataflow.v1beta3.CreateJobFromTemplateRequest
	18, // 37: google.dataflow.v1beta3.TemplatesService.LaunchTemplate:input_type -> google.dataflow.v1beta3.LaunchTemplateRequest
	15, // 38: google.dataflow.v1beta3.TemplatesService.GetTemplate:input_type -> google.dataflow.v1beta3.GetTemplateRequest
	8,  // 39: google.dataflow.v1beta3.FlexTemplatesService.LaunchFlexTemplate:input_type -> google.dataflow.v1beta3.LaunchFlexTemplateRequest
	32, // 40: google.dataflow.v1beta3.TemplatesService.CreateJobFromTemplate:output_type -> google.dataflow.v1beta3.Job
	19, // 41: google.dataflow.v1beta3.TemplatesService.LaunchTemplate:output_type -> google.dataflow.v1beta3.LaunchTemplateResponse
	16, // 42: google.dataflow.v1beta3.TemplatesService.GetTemplate:output_type -> google.dataflow.v1beta3.GetTemplateResponse
	4,  // 43: google.dataflow.v1beta3.FlexTemplatesService.LaunchFlexTemplate:output_type -> google.dataflow.v1beta3.LaunchFlexTemplateResponse
	40, // [40:44] is the sub-list for method output_type
	36, // [36:40] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_google_dataflow_v1beta3_templates_proto_init() }
func file_google_dataflow_v1beta3_templates_proto_init() {
	if File_google_dataflow_v1beta3_templates_proto != nil {
		return
	}
	file_google_dataflow_v1beta3_environment_proto_init()
	file_google_dataflow_v1beta3_jobs_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_dataflow_v1beta3_templates_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchFlexTemplateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchFlexTemplateParameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FlexTemplateRuntimeEnvironment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchFlexTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeEnvironment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ParameterMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TemplateMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SDKInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateJobFromTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTemplateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchTemplateParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchTemplateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InvalidTemplateParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DynamicTemplateLaunchParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_templates_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InvalidTemplateParameters_ParameterViolation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_dataflow_v1beta3_templates_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*LaunchFlexTemplateParameter_ContainerSpec)(nil),
		(*LaunchFlexTemplateParameter_ContainerSpecGcsPath)(nil),
	}
	file_google_dataflow_v1beta3_templates_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*CreateJobFromTemplateRequest_GcsPath)(nil),
	}
	file_google_dataflow_v1beta3_templates_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*GetTemplateRequest_GcsPath)(nil),
	}
	file_google_dataflow_v1beta3_templates_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*LaunchTemplateRequest_GcsPath)(nil),
		(*LaunchTemplateRequest_DynamicTemplate)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_dataflow_v1beta3_templates_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   28,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_google_dataflow_v1beta3_templates_proto_goTypes,
		DependencyIndexes: file_google_dataflow_v1beta3_templates_proto_depIdxs,
		EnumInfos:         file_google_dataflow_v1beta3_templates_proto_enumTypes,
		MessageInfos:      file_google_dataflow_v1beta3_templates_proto_msgTypes,
	}.Build()
	File_google_dataflow_v1beta3_templates_proto = out.File
	file_google_dataflow_v1beta3_templates_proto_rawDesc = nil
	file_google_dataflow_v1beta3_templates_proto_goTypes = nil
	file_google_dataflow_v1beta3_templates_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TemplatesServiceClient is the client API for TemplatesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TemplatesServiceClient interface {
	// Creates a Cloud Dataflow job from a template.
	CreateJobFromTemplate(ctx context.Context, in *CreateJobFromTemplateRequest, opts ...grpc.CallOption) (*Job, error)
	// Launch a template.
	LaunchTemplate(ctx context.Context, in *LaunchTemplateRequest, opts ...grpc.CallOption) (*LaunchTemplateResponse, error)
	// Get the template associated with a template.
	GetTemplate(ctx context.Context, in *GetTemplateRequest, opts ...grpc.CallOption) (*GetTemplateResponse, error)
}

type templatesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTemplatesServiceClient(cc grpc.ClientConnInterface) TemplatesServiceClient {
	return &templatesServiceClient{cc}
}

func (c *templatesServiceClient) CreateJobFromTemplate(ctx context.Context, in *CreateJobFromTemplateRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.TemplatesService/CreateJobFromTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *templatesServiceClient) LaunchTemplate(ctx context.Context, in *LaunchTemplateRequest, opts ...grpc.CallOption) (*LaunchTemplateResponse, error) {
	out := new(LaunchTemplateResponse)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.TemplatesService/LaunchTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *templatesServiceClient) GetTemplate(ctx context.Context, in *GetTemplateRequest, opts ...grpc.CallOption) (*GetTemplateResponse, error) {
	out := new(GetTemplateResponse)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.TemplatesService/GetTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TemplatesServiceServer is the server API for TemplatesService service.
type TemplatesServiceServer interface {
	// Creates a Cloud Dataflow job from a template.
	CreateJobFromTemplate(context.Context, *CreateJobFromTemplateRequest) (*Job, error)
	// Launch a template.
	LaunchTemplate(context.Context, *LaunchTemplateRequest) (*LaunchTemplateResponse, error)
	// Get the template associated with a template.
	GetTemplate(context.Context, *GetTemplateRequest) (*GetTemplateResponse, error)
}

// UnimplementedTemplatesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTemplatesServiceServer struct {
}

func (*UnimplementedTemplatesServiceServer) CreateJobFromTemplate(context.Context, *CreateJobFromTemplateRequest) (*Job, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateJobFromTemplate not implemented")
}
func (*UnimplementedTemplatesServiceServer) LaunchTemplate(context.Context, *LaunchTemplateRequest) (*LaunchTemplateResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method LaunchTemplate not implemented")
}
func (*UnimplementedTemplatesServiceServer) GetTemplate(context.Context, *GetTemplateRequest) (*GetTemplateResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetTemplate not implemented")
}

func RegisterTemplatesServiceServer(s *grpc.Server, srv TemplatesServiceServer) {
	s.RegisterService(&_TemplatesService_serviceDesc, srv)
}

func _TemplatesService_CreateJobFromTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobFromTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TemplatesServiceServer).CreateJobFromTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.TemplatesService/CreateJobFromTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TemplatesServiceServer).CreateJobFromTemplate(ctx, req.(*CreateJobFromTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TemplatesService_LaunchTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LaunchTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TemplatesServiceServer).LaunchTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.TemplatesService/LaunchTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TemplatesServiceServer).LaunchTemplate(ctx, req.(*LaunchTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TemplatesService_GetTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TemplatesServiceServer).GetTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.TemplatesService/GetTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TemplatesServiceServer).GetTemplate(ctx, req.(*GetTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TemplatesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.dataflow.v1beta3.TemplatesService",
	HandlerType: (*TemplatesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateJobFromTemplate",
			Handler:    _TemplatesService_CreateJobFromTemplate_Handler,
		},
		{
			MethodName: "LaunchTemplate",
			Handler:    _TemplatesService_LaunchTemplate_Handler,
		},
		{
			MethodName: "GetTemplate",
			Handler:    _TemplatesService_GetTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/dataflow/v1beta3/templates.proto",
}

// FlexTemplatesServiceClient is the client API for FlexTemplatesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FlexTemplatesServiceClient interface {
	// Launch a job with a FlexTemplate.
	LaunchFlexTemplate(ctx context.Context, in *LaunchFlexTemplateRequest, opts ...grpc.CallOption) (*LaunchFlexTemplateResponse, error)
}

type flexTemplatesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFlexTemplatesServiceClient(cc grpc.ClientConnInterface) FlexTemplatesServiceClient {
	return &flexTemplatesServiceClient{cc}
}

func (c *flexTemplatesServiceClient) LaunchFlexTemplate(ctx context.Context, in *LaunchFlexTemplateRequest, opts ...grpc.CallOption) (*LaunchFlexTemplateResponse, error) {
	out := new(LaunchFlexTemplateResponse)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.FlexTemplatesService/LaunchFlexTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FlexTemplatesServiceServer is the server API for FlexTemplatesService service.
type FlexTemplatesServiceServer interface {
	// Launch a job with a FlexTemplate.
	LaunchFlexTemplate(context.Context, *LaunchFlexTemplateRequest) (*LaunchFlexTemplateResponse, error)
}

// UnimplementedFlexTemplatesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedFlexTemplatesServiceServer struct {
}

func (*UnimplementedFlexTemplatesServiceServer) LaunchFlexTemplate(context.Context, *LaunchFlexTemplateRequest) (*LaunchFlexTemplateResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method LaunchFlexTemplate not implemented")
}

func RegisterFlexTemplatesServiceServer(s *grpc.Server, srv FlexTemplatesServiceServer) {
	s.RegisterService(&_FlexTemplatesService_serviceDesc, srv)
}

func _FlexTemplatesService_LaunchFlexTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LaunchFlexTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlexTemplatesServiceServer).LaunchFlexTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.FlexTemplatesService/LaunchFlexTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlexTemplatesServiceServer).LaunchFlexTemplate(ctx, req.(*LaunchFlexTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FlexTemplatesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.dataflow.v1beta3.FlexTemplatesService",
	HandlerType: (*FlexTemplatesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "LaunchFlexTemplate",
			Handler:    _FlexTemplatesService_LaunchFlexTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/dataflow/v1beta3/templates.proto",
}
