package terminfo

// Code generated by gen.go. DO NOT EDIT.

// Bool capabilities.
const (
	// The AutoLeftMargin [auto_left_margin, bw] bool capability indicates cub1 wraps from column 0 to last column.
	AutoLeftMargin = iota

	// The AutoRightMargin [auto_right_margin, am] bool capability indicates terminal has automatic margins.
	AutoRightMargin

	// The NoEscCtlc [no_esc_ctlc, xsb] bool capability indicates beehive (f1=escape, f2=ctrl C).
	NoEscCtlc

	// The CeolStandoutGlitch [ceol_standout_glitch, xhp] bool capability indicates standout not erased by overwriting (hp).
	CeolStandoutGlitch

	// The EatNewlineGlitch [eat_newline_glitch, xenl] bool capability indicates newline ignored after 80 cols (concept).
	EatNewlineGlitch

	// The EraseOverstrike [erase_overstrike, eo] bool capability indicates can erase overstrikes with a blank.
	EraseOverstrike

	// The GenericType [generic_type, gn] bool capability indicates generic line type.
	GenericType

	// The HardCopy [hard_copy, hc] bool capability indicates hardcopy terminal.
	HardCopy

	// The HasMetaKey [has_meta_key, km] bool capability indicates Has a meta key (i.e., sets 8th-bit).
	HasMetaKey

	// The HasStatusLine [has_status_line, hs] bool capability indicates has extra status line.
	HasStatusLine

	// The InsertNullGlitch [insert_null_glitch, in] bool capability indicates insert mode distinguishes nulls.
	InsertNullGlitch

	// The MemoryAbove [memory_above, da] bool capability indicates display may be retained above the screen.
	MemoryAbove

	// The MemoryBelow [memory_below, db] bool capability indicates display may be retained below the screen.
	MemoryBelow

	// The MoveInsertMode [move_insert_mode, mir] bool capability indicates safe to move while in insert mode.
	MoveInsertMode

	// The MoveStandoutMode [move_standout_mode, msgr] bool capability indicates safe to move while in standout mode.
	MoveStandoutMode

	// The OverStrike [over_strike, os] bool capability indicates terminal can overstrike.
	OverStrike

	// The StatusLineEscOk [status_line_esc_ok, eslok] bool capability indicates escape can be used on the status line.
	StatusLineEscOk

	// The DestTabsMagicSmso [dest_tabs_magic_smso, xt] bool capability indicates tabs destructive, magic so char (t1061).
	DestTabsMagicSmso

	// The TildeGlitch [tilde_glitch, hz] bool capability indicates cannot print ~'s (Hazeltine).
	TildeGlitch

	// The TransparentUnderline [transparent_underline, ul] bool capability indicates underline character overstrikes.
	TransparentUnderline

	// The XonXoff [xon_xoff, xon] bool capability indicates terminal uses xon/xoff handshaking.
	XonXoff

	// The NeedsXonXoff [needs_xon_xoff, nxon] bool capability indicates padding will not work, xon/xoff required.
	NeedsXonXoff

	// The PrtrSilent [prtr_silent, mc5i] bool capability indicates printer will not echo on screen.
	PrtrSilent

	// The HardCursor [hard_cursor, chts] bool capability indicates cursor is hard to see.
	HardCursor

	// The NonRevRmcup [non_rev_rmcup, nrrmc] bool capability indicates smcup does not reverse rmcup.
	NonRevRmcup

	// The NoPadChar [no_pad_char, npc] bool capability indicates pad character does not exist.
	NoPadChar

	// The NonDestScrollRegion [non_dest_scroll_region, ndscr] bool capability indicates scrolling region is non-destructive.
	NonDestScrollRegion

	// The CanChange [can_change, ccc] bool capability indicates terminal can re-define existing colors.
	CanChange

	// The BackColorErase [back_color_erase, bce] bool capability indicates screen erased with background color.
	BackColorErase

	// The HueLightnessSaturation [hue_lightness_saturation, hls] bool capability indicates terminal uses only HLS color notation (Tektronix).
	HueLightnessSaturation

	// The ColAddrGlitch [col_addr_glitch, xhpa] bool capability indicates only positive motion for hpa/mhpa caps.
	ColAddrGlitch

	// The CrCancelsMicroMode [cr_cancels_micro_mode, crxm] bool capability indicates using cr turns off micro mode.
	CrCancelsMicroMode

	// The HasPrintWheel [has_print_wheel, daisy] bool capability indicates printer needs operator to change character set.
	HasPrintWheel

	// The RowAddrGlitch [row_addr_glitch, xvpa] bool capability indicates only positive motion for vpa/mvpa caps.
	RowAddrGlitch

	// The SemiAutoRightMargin [semi_auto_right_margin, sam] bool capability indicates printing in last column causes cr.
	SemiAutoRightMargin

	// The CpiChangesRes [cpi_changes_res, cpix] bool capability indicates changing character pitch changes resolution.
	CpiChangesRes

	// The LpiChangesRes [lpi_changes_res, lpix] bool capability indicates changing line pitch changes resolution.
	LpiChangesRes

	// The BackspacesWithBs [backspaces_with_bs, OTbs] bool capability indicates uses ^H to move left.
	BackspacesWithBs

	// The CrtNoScrolling [crt_no_scrolling, OTns] bool capability indicates crt cannot scroll.
	CrtNoScrolling

	// The NoCorrectlyWorkingCr [no_correctly_working_cr, OTnc] bool capability indicates no way to go to start of line.
	NoCorrectlyWorkingCr

	// The GnuHasMetaKey [gnu_has_meta_key, OTMT] bool capability indicates has meta key.
	GnuHasMetaKey

	// The LinefeedIsNewline [linefeed_is_newline, OTNL] bool capability indicates move down with \n.
	LinefeedIsNewline

	// The HasHardwareTabs [has_hardware_tabs, OTpt] bool capability indicates has 8-char tabs invoked with ^I.
	HasHardwareTabs

	// The ReturnDoesClrEol [return_does_clr_eol, OTxr] bool capability indicates return clears the line.
	ReturnDoesClrEol
)

// Num capabilities.
const (
	// The Columns [columns, cols] num capability is number of columns in a line.
	Columns = iota

	// The InitTabs [init_tabs, it] num capability is tabs initially every # spaces.
	InitTabs

	// The Lines [lines, lines] num capability is number of lines on screen or page.
	Lines

	// The LinesOfMemory [lines_of_memory, lm] num capability is lines of memory if > line. 0 means varies.
	LinesOfMemory

	// The MagicCookieGlitch [magic_cookie_glitch, xmc] num capability is number of blank characters left by smso or rmso.
	MagicCookieGlitch

	// The PaddingBaudRate [padding_baud_rate, pb] num capability is lowest baud rate where padding needed.
	PaddingBaudRate

	// The VirtualTerminal [virtual_terminal, vt] num capability is virtual terminal number (CB/unix).
	VirtualTerminal

	// The WidthStatusLine [width_status_line, wsl] num capability is number of columns in status line.
	WidthStatusLine

	// The NumLabels [num_labels, nlab] num capability is number of labels on screen.
	NumLabels

	// The LabelHeight [label_height, lh] num capability is rows in each label.
	LabelHeight

	// The LabelWidth [label_width, lw] num capability is columns in each label.
	LabelWidth

	// The MaxAttributes [max_attributes, ma] num capability is maximum combined attributes terminal can handle.
	MaxAttributes

	// The MaximumWindows [maximum_windows, wnum] num capability is maximum number of definable windows.
	MaximumWindows

	// The MaxColors [max_colors, colors] num capability is maximum number of colors on screen.
	MaxColors

	// The MaxPairs [max_pairs, pairs] num capability is maximum number of color-pairs on the screen.
	MaxPairs

	// The NoColorVideo [no_color_video, ncv] num capability is video attributes that cannot be used with colors.
	NoColorVideo

	// The BufferCapacity [buffer_capacity, bufsz] num capability is numbers of bytes buffered before printing.
	BufferCapacity

	// The DotVertSpacing [dot_vert_spacing, spinv] num capability is spacing of pins vertically in pins per inch.
	DotVertSpacing

	// The DotHorzSpacing [dot_horz_spacing, spinh] num capability is spacing of dots horizontally in dots per inch.
	DotHorzSpacing

	// The MaxMicroAddress [max_micro_address, maddr] num capability is maximum value in micro_..._address.
	MaxMicroAddress

	// The MaxMicroJump [max_micro_jump, mjump] num capability is maximum value in parm_..._micro.
	MaxMicroJump

	// The MicroColSize [micro_col_size, mcs] num capability is character step size when in micro mode.
	MicroColSize

	// The MicroLineSize [micro_line_size, mls] num capability is line step size when in micro mode.
	MicroLineSize

	// The NumberOfPins [number_of_pins, npins] num capability is numbers of pins in print-head.
	NumberOfPins

	// The OutputResChar [output_res_char, orc] num capability is horizontal resolution in units per line.
	OutputResChar

	// The OutputResLine [output_res_line, orl] num capability is vertical resolution in units per line.
	OutputResLine

	// The OutputResHorzInch [output_res_horz_inch, orhi] num capability is horizontal resolution in units per inch.
	OutputResHorzInch

	// The OutputResVertInch [output_res_vert_inch, orvi] num capability is vertical resolution in units per inch.
	OutputResVertInch

	// The PrintRate [print_rate, cps] num capability is print rate in characters per second.
	PrintRate

	// The WideCharSize [wide_char_size, widcs] num capability is character step size when in double wide mode.
	WideCharSize

	// The Buttons [buttons, btns] num capability is number of buttons on mouse.
	Buttons

	// The BitImageEntwining [bit_image_entwining, bitwin] num capability is number of passes for each bit-image row.
	BitImageEntwining

	// The BitImageType [bit_image_type, bitype] num capability is type of bit-image device.
	BitImageType

	// The MagicCookieGlitchUl [magic_cookie_glitch_ul, OTug] num capability is number of blanks left by ul.
	MagicCookieGlitchUl

	// The CarriageReturnDelay [carriage_return_delay, OTdC] num capability is pad needed for CR.
	CarriageReturnDelay

	// The NewLineDelay [new_line_delay, OTdN] num capability is pad needed for LF.
	NewLineDelay

	// The BackspaceDelay [backspace_delay, OTdB] num capability is padding required for ^H.
	BackspaceDelay

	// The HorizontalTabDelay [horizontal_tab_delay, OTdT] num capability is padding required for ^I.
	HorizontalTabDelay

	// The NumberOfFunctionKeys [number_of_function_keys, OTkn] num capability is count of function keys.
	NumberOfFunctionKeys
)

// String capabilities.
const (
	// The BackTab [back_tab, cbt] string capability is the back tab (P).
	BackTab = iota

	// The Bell [bell, bel] string capability is the audible signal (bell) (P).
	Bell

	// The CarriageReturn [carriage_return, cr] string capability is the carriage return (P*) (P*).
	CarriageReturn

	// The ChangeScrollRegion [change_scroll_region, csr] string capability is the change region to line #1 to line #2 (P).
	ChangeScrollRegion

	// The ClearAllTabs [clear_all_tabs, tbc] string capability is the clear all tab stops (P).
	ClearAllTabs

	// The ClearScreen [clear_screen, clear] string capability is the clear screen and home cursor (P*).
	ClearScreen

	// The ClrEol [clr_eol, el] string capability is the clear to end of line (P).
	ClrEol

	// The ClrEos [clr_eos, ed] string capability is the clear to end of screen (P*).
	ClrEos

	// The ColumnAddress [column_address, hpa] string capability is the horizontal position #1, absolute (P).
	ColumnAddress

	// The CommandCharacter [command_character, cmdch] string capability is the terminal settable cmd character in prototype !?.
	CommandCharacter

	// The CursorAddress [cursor_address, cup] string capability is the move to row #1 columns #2.
	CursorAddress

	// The CursorDown [cursor_down, cud1] string capability is the down one line.
	CursorDown

	// The CursorHome [cursor_home, home] string capability is the home cursor (if no cup).
	CursorHome

	// The CursorInvisible [cursor_invisible, civis] string capability is the make cursor invisible.
	CursorInvisible

	// The CursorLeft [cursor_left, cub1] string capability is the move left one space.
	CursorLeft

	// The CursorMemAddress [cursor_mem_address, mrcup] string capability is the memory relative cursor addressing, move to row #1 columns #2.
	CursorMemAddress

	// The CursorNormal [cursor_normal, cnorm] string capability is the make cursor appear normal (undo civis/cvvis).
	CursorNormal

	// The CursorRight [cursor_right, cuf1] string capability is the non-destructive space (move right one space).
	CursorRight

	// The CursorToLl [cursor_to_ll, ll] string capability is the last line, first column (if no cup).
	CursorToLl

	// The CursorUp [cursor_up, cuu1] string capability is the up one line.
	CursorUp

	// The CursorVisible [cursor_visible, cvvis] string capability is the make cursor very visible.
	CursorVisible

	// The DeleteCharacter [delete_character, dch1] string capability is the delete character (P*).
	DeleteCharacter

	// The DeleteLine [delete_line, dl1] string capability is the delete line (P*).
	DeleteLine

	// The DisStatusLine [dis_status_line, dsl] string capability is the disable status line.
	DisStatusLine

	// The DownHalfLine [down_half_line, hd] string capability is the half a line down.
	DownHalfLine

	// The EnterAltCharsetMode [enter_alt_charset_mode, smacs] string capability is the start alternate character set (P).
	EnterAltCharsetMode

	// The EnterBlinkMode [enter_blink_mode, blink] string capability is the turn on blinking.
	EnterBlinkMode

	// The EnterBoldMode [enter_bold_mode, bold] string capability is the turn on bold (extra bright) mode.
	EnterBoldMode

	// The EnterCaMode [enter_ca_mode, smcup] string capability is the string to start programs using cup.
	EnterCaMode

	// The EnterDeleteMode [enter_delete_mode, smdc] string capability is the enter delete mode.
	EnterDeleteMode

	// The EnterDimMode [enter_dim_mode, dim] string capability is the turn on half-bright mode.
	EnterDimMode

	// The EnterInsertMode [enter_insert_mode, smir] string capability is the enter insert mode.
	EnterInsertMode

	// The EnterSecureMode [enter_secure_mode, invis] string capability is the turn on blank mode (characters invisible).
	EnterSecureMode

	// The EnterProtectedMode [enter_protected_mode, prot] string capability is the turn on protected mode.
	EnterProtectedMode

	// The EnterReverseMode [enter_reverse_mode, rev] string capability is the turn on reverse video mode.
	EnterReverseMode

	// The EnterStandoutMode [enter_standout_mode, smso] string capability is the begin standout mode.
	EnterStandoutMode

	// The EnterUnderlineMode [enter_underline_mode, smul] string capability is the begin underline mode.
	EnterUnderlineMode

	// The EraseChars [erase_chars, ech] string capability is the erase #1 characters (P).
	EraseChars

	// The ExitAltCharsetMode [exit_alt_charset_mode, rmacs] string capability is the end alternate character set (P).
	ExitAltCharsetMode

	// The ExitAttributeMode [exit_attribute_mode, sgr0] string capability is the turn off all attributes.
	ExitAttributeMode

	// The ExitCaMode [exit_ca_mode, rmcup] string capability is the strings to end programs using cup.
	ExitCaMode

	// The ExitDeleteMode [exit_delete_mode, rmdc] string capability is the end delete mode.
	ExitDeleteMode

	// The ExitInsertMode [exit_insert_mode, rmir] string capability is the exit insert mode.
	ExitInsertMode

	// The ExitStandoutMode [exit_standout_mode, rmso] string capability is the exit standout mode.
	ExitStandoutMode

	// The ExitUnderlineMode [exit_underline_mode, rmul] string capability is the exit underline mode.
	ExitUnderlineMode

	// The FlashScreen [flash_screen, flash] string capability is the visible bell (may not move cursor).
	FlashScreen

	// The FormFeed [form_feed, ff] string capability is the hardcopy terminal page eject (P*).
	FormFeed

	// The FromStatusLine [from_status_line, fsl] string capability is the return from status line.
	FromStatusLine

	// The Init1string [init_1string, is1] string capability is the initialization string.
	Init1string

	// The Init2string [init_2string, is2] string capability is the initialization string.
	Init2string

	// The Init3string [init_3string, is3] string capability is the initialization string.
	Init3string

	// The InitFile [init_file, if] string capability is the name of initialization file.
	InitFile

	// The InsertCharacter [insert_character, ich1] string capability is the insert character (P).
	InsertCharacter

	// The InsertLine [insert_line, il1] string capability is the insert line (P*).
	InsertLine

	// The InsertPadding [insert_padding, ip] string capability is the insert padding after inserted character.
	InsertPadding

	// The KeyBackspace [key_backspace, kbs] string capability is the backspace key.
	KeyBackspace

	// The KeyCatab [key_catab, ktbc] string capability is the clear-all-tabs key.
	KeyCatab

	// The KeyClear [key_clear, kclr] string capability is the clear-screen or erase key.
	KeyClear

	// The KeyCtab [key_ctab, kctab] string capability is the clear-tab key.
	KeyCtab

	// The KeyDc [key_dc, kdch1] string capability is the delete-character key.
	KeyDc

	// The KeyDl [key_dl, kdl1] string capability is the delete-line key.
	KeyDl

	// The KeyDown [key_down, kcud1] string capability is the down-arrow key.
	KeyDown

	// The KeyEic [key_eic, krmir] string capability is the sent by rmir or smir in insert mode.
	KeyEic

	// The KeyEol [key_eol, kel] string capability is the clear-to-end-of-line key.
	KeyEol

	// The KeyEos [key_eos, ked] string capability is the clear-to-end-of-screen key.
	KeyEos

	// The KeyF0 [key_f0, kf0] string capability is the F0 function key.
	KeyF0

	// The KeyF1 [key_f1, kf1] string capability is the F1 function key.
	KeyF1

	// The KeyF10 [key_f10, kf10] string capability is the F10 function key.
	KeyF10

	// The KeyF2 [key_f2, kf2] string capability is the F2 function key.
	KeyF2

	// The KeyF3 [key_f3, kf3] string capability is the F3 function key.
	KeyF3

	// The KeyF4 [key_f4, kf4] string capability is the F4 function key.
	KeyF4

	// The KeyF5 [key_f5, kf5] string capability is the F5 function key.
	KeyF5

	// The KeyF6 [key_f6, kf6] string capability is the F6 function key.
	KeyF6

	// The KeyF7 [key_f7, kf7] string capability is the F7 function key.
	KeyF7

	// The KeyF8 [key_f8, kf8] string capability is the F8 function key.
	KeyF8

	// The KeyF9 [key_f9, kf9] string capability is the F9 function key.
	KeyF9

	// The KeyHome [key_home, khome] string capability is the home key.
	KeyHome

	// The KeyIc [key_ic, kich1] string capability is the insert-character key.
	KeyIc

	// The KeyIl [key_il, kil1] string capability is the insert-line key.
	KeyIl

	// The KeyLeft [key_left, kcub1] string capability is the left-arrow key.
	KeyLeft

	// The KeyLl [key_ll, kll] string capability is the lower-left key (home down).
	KeyLl

	// The KeyNpage [key_npage, knp] string capability is the next-page key.
	KeyNpage

	// The KeyPpage [key_ppage, kpp] string capability is the previous-page key.
	KeyPpage

	// The KeyRight [key_right, kcuf1] string capability is the right-arrow key.
	KeyRight

	// The KeySf [key_sf, kind] string capability is the scroll-forward key.
	KeySf

	// The KeySr [key_sr, kri] string capability is the scroll-backward key.
	KeySr

	// The KeyStab [key_stab, khts] string capability is the set-tab key.
	KeyStab

	// The KeyUp [key_up, kcuu1] string capability is the up-arrow key.
	KeyUp

	// The KeypadLocal [keypad_local, rmkx] string capability is the leave 'keyboard_transmit' mode.
	KeypadLocal

	// The KeypadXmit [keypad_xmit, smkx] string capability is the enter 'keyboard_transmit' mode.
	KeypadXmit

	// The LabF0 [lab_f0, lf0] string capability is the label on function key f0 if not f0.
	LabF0

	// The LabF1 [lab_f1, lf1] string capability is the label on function key f1 if not f1.
	LabF1

	// The LabF10 [lab_f10, lf10] string capability is the label on function key f10 if not f10.
	LabF10

	// The LabF2 [lab_f2, lf2] string capability is the label on function key f2 if not f2.
	LabF2

	// The LabF3 [lab_f3, lf3] string capability is the label on function key f3 if not f3.
	LabF3

	// The LabF4 [lab_f4, lf4] string capability is the label on function key f4 if not f4.
	LabF4

	// The LabF5 [lab_f5, lf5] string capability is the label on function key f5 if not f5.
	LabF5

	// The LabF6 [lab_f6, lf6] string capability is the label on function key f6 if not f6.
	LabF6

	// The LabF7 [lab_f7, lf7] string capability is the label on function key f7 if not f7.
	LabF7

	// The LabF8 [lab_f8, lf8] string capability is the label on function key f8 if not f8.
	LabF8

	// The LabF9 [lab_f9, lf9] string capability is the label on function key f9 if not f9.
	LabF9

	// The MetaOff [meta_off, rmm] string capability is the turn off meta mode.
	MetaOff

	// The MetaOn [meta_on, smm] string capability is the turn on meta mode (8th-bit on).
	MetaOn

	// The Newline [newline, nel] string capability is the newline (behave like cr followed by lf).
	Newline

	// The PadChar [pad_char, pad] string capability is the padding char (instead of null).
	PadChar

	// The ParmDch [parm_dch, dch] string capability is the delete #1 characters (P*).
	ParmDch

	// The ParmDeleteLine [parm_delete_line, dl] string capability is the delete #1 lines (P*).
	ParmDeleteLine

	// The ParmDownCursor [parm_down_cursor, cud] string capability is the down #1 lines (P*).
	ParmDownCursor

	// The ParmIch [parm_ich, ich] string capability is the insert #1 characters (P*).
	ParmIch

	// The ParmIndex [parm_index, indn] string capability is the scroll forward #1 lines (P).
	ParmIndex

	// The ParmInsertLine [parm_insert_line, il] string capability is the insert #1 lines (P*).
	ParmInsertLine

	// The ParmLeftCursor [parm_left_cursor, cub] string capability is the move #1 characters to the left (P).
	ParmLeftCursor

	// The ParmRightCursor [parm_right_cursor, cuf] string capability is the move #1 characters to the right (P*).
	ParmRightCursor

	// The ParmRindex [parm_rindex, rin] string capability is the scroll back #1 lines (P).
	ParmRindex

	// The ParmUpCursor [parm_up_cursor, cuu] string capability is the up #1 lines (P*).
	ParmUpCursor

	// The PkeyKey [pkey_key, pfkey] string capability is the program function key #1 to type string #2.
	PkeyKey

	// The PkeyLocal [pkey_local, pfloc] string capability is the program function key #1 to execute string #2.
	PkeyLocal

	// The PkeyXmit [pkey_xmit, pfx] string capability is the program function key #1 to transmit string #2.
	PkeyXmit

	// The PrintScreen [print_screen, mc0] string capability is the print contents of screen.
	PrintScreen

	// The PrtrOff [prtr_off, mc4] string capability is the turn off printer.
	PrtrOff

	// The PrtrOn [prtr_on, mc5] string capability is the turn on printer.
	PrtrOn

	// The RepeatChar [repeat_char, rep] string capability is the repeat char #1 #2 times (P*).
	RepeatChar

	// The Reset1string [reset_1string, rs1] string capability is the reset string.
	Reset1string

	// The Reset2string [reset_2string, rs2] string capability is the reset string.
	Reset2string

	// The Reset3string [reset_3string, rs3] string capability is the reset string.
	Reset3string

	// The ResetFile [reset_file, rf] string capability is the name of reset file.
	ResetFile

	// The RestoreCursor [restore_cursor, rc] string capability is the restore cursor to position of last save_cursor.
	RestoreCursor

	// The RowAddress [row_address, vpa] string capability is the vertical position #1 absolute (P).
	RowAddress

	// The SaveCursor [save_cursor, sc] string capability is the save current cursor position (P).
	SaveCursor

	// The ScrollForward [scroll_forward, ind] string capability is the scroll text up (P).
	ScrollForward

	// The ScrollReverse [scroll_reverse, ri] string capability is the scroll text down (P).
	ScrollReverse

	// The SetAttributes [set_attributes, sgr] string capability is the define video attributes #1-#9 (PG9).
	SetAttributes

	// The SetTab [set_tab, hts] string capability is the set a tab in every row, current columns.
	SetTab

	// The SetWindow [set_window, wind] string capability is the current window is lines #1-#2 cols #3-#4.
	SetWindow

	// The Tab [tab, ht] string capability is the tab to next 8-space hardware tab stop.
	Tab

	// The ToStatusLine [to_status_line, tsl] string capability is the move to status line, column #1.
	ToStatusLine

	// The UnderlineChar [underline_char, uc] string capability is the underline char and move past it.
	UnderlineChar

	// The UpHalfLine [up_half_line, hu] string capability is the half a line up.
	UpHalfLine

	// The InitProg [init_prog, iprog] string capability is the path name of program for initialization.
	InitProg

	// The KeyA1 [key_a1, ka1] string capability is the upper left of keypad.
	KeyA1

	// The KeyA3 [key_a3, ka3] string capability is the upper right of keypad.
	KeyA3

	// The KeyB2 [key_b2, kb2] string capability is the center of keypad.
	KeyB2

	// The KeyC1 [key_c1, kc1] string capability is the lower left of keypad.
	KeyC1

	// The KeyC3 [key_c3, kc3] string capability is the lower right of keypad.
	KeyC3

	// The PrtrNon [prtr_non, mc5p] string capability is the turn on printer for #1 bytes.
	PrtrNon

	// The CharPadding [char_padding, rmp] string capability is the like ip but when in insert mode.
	CharPadding

	// The AcsChars [acs_chars, acsc] string capability is the graphics charset pairs, based on vt100.
	AcsChars

	// The PlabNorm [plab_norm, pln] string capability is the program label #1 to show string #2.
	PlabNorm

	// The KeyBtab [key_btab, kcbt] string capability is the back-tab key.
	KeyBtab

	// The EnterXonMode [enter_xon_mode, smxon] string capability is the turn on xon/xoff handshaking.
	EnterXonMode

	// The ExitXonMode [exit_xon_mode, rmxon] string capability is the turn off xon/xoff handshaking.
	ExitXonMode

	// The EnterAmMode [enter_am_mode, smam] string capability is the turn on automatic margins.
	EnterAmMode

	// The ExitAmMode [exit_am_mode, rmam] string capability is the turn off automatic margins.
	ExitAmMode

	// The XonCharacter [xon_character, xonc] string capability is the XON character.
	XonCharacter

	// The XoffCharacter [xoff_character, xoffc] string capability is the XOFF character.
	XoffCharacter

	// The EnaAcs [ena_acs, enacs] string capability is the enable alternate char set.
	EnaAcs

	// The LabelOn [label_on, smln] string capability is the turn on soft labels.
	LabelOn

	// The LabelOff [label_off, rmln] string capability is the turn off soft labels.
	LabelOff

	// The KeyBeg [key_beg, kbeg] string capability is the begin key.
	KeyBeg

	// The KeyCancel [key_cancel, kcan] string capability is the cancel key.
	KeyCancel

	// The KeyClose [key_close, kclo] string capability is the close key.
	KeyClose

	// The KeyCommand [key_command, kcmd] string capability is the command key.
	KeyCommand

	// The KeyCopy [key_copy, kcpy] string capability is the copy key.
	KeyCopy

	// The KeyCreate [key_create, kcrt] string capability is the create key.
	KeyCreate

	// The KeyEnd [key_end, kend] string capability is the end key.
	KeyEnd

	// The KeyEnter [key_enter, kent] string capability is the enter/send key.
	KeyEnter

	// The KeyExit [key_exit, kext] string capability is the exit key.
	KeyExit

	// The KeyFind [key_find, kfnd] string capability is the find key.
	KeyFind

	// The KeyHelp [key_help, khlp] string capability is the help key.
	KeyHelp

	// The KeyMark [key_mark, kmrk] string capability is the mark key.
	KeyMark

	// The KeyMessage [key_message, kmsg] string capability is the message key.
	KeyMessage

	// The KeyMove [key_move, kmov] string capability is the move key.
	KeyMove

	// The KeyNext [key_next, knxt] string capability is the next key.
	KeyNext

	// The KeyOpen [key_open, kopn] string capability is the open key.
	KeyOpen

	// The KeyOptions [key_options, kopt] string capability is the options key.
	KeyOptions

	// The KeyPrevious [key_previous, kprv] string capability is the previous key.
	KeyPrevious

	// The KeyPrint [key_print, kprt] string capability is the print key.
	KeyPrint

	// The KeyRedo [key_redo, krdo] string capability is the redo key.
	KeyRedo

	// The KeyReference [key_reference, kref] string capability is the reference key.
	KeyReference

	// The KeyRefresh [key_refresh, krfr] string capability is the refresh key.
	KeyRefresh

	// The KeyReplace [key_replace, krpl] string capability is the replace key.
	KeyReplace

	// The KeyRestart [key_restart, krst] string capability is the restart key.
	KeyRestart

	// The KeyResume [key_resume, kres] string capability is the resume key.
	KeyResume

	// The KeySave [key_save, ksav] string capability is the save key.
	KeySave

	// The KeySuspend [key_suspend, kspd] string capability is the suspend key.
	KeySuspend

	// The KeyUndo [key_undo, kund] string capability is the undo key.
	KeyUndo

	// The KeySbeg [key_sbeg, kBEG] string capability is the shifted begin key.
	KeySbeg

	// The KeyScancel [key_scancel, kCAN] string capability is the shifted cancel key.
	KeyScancel

	// The KeyScommand [key_scommand, kCMD] string capability is the shifted command key.
	KeyScommand

	// The KeyScopy [key_scopy, kCPY] string capability is the shifted copy key.
	KeyScopy

	// The KeyScreate [key_screate, kCRT] string capability is the shifted create key.
	KeyScreate

	// The KeySdc [key_sdc, kDC] string capability is the shifted delete-character key.
	KeySdc

	// The KeySdl [key_sdl, kDL] string capability is the shifted delete-line key.
	KeySdl

	// The KeySelect [key_select, kslt] string capability is the select key.
	KeySelect

	// The KeySend [key_send, kEND] string capability is the shifted end key.
	KeySend

	// The KeySeol [key_seol, kEOL] string capability is the shifted clear-to-end-of-line key.
	KeySeol

	// The KeySexit [key_sexit, kEXT] string capability is the shifted exit key.
	KeySexit

	// The KeySfind [key_sfind, kFND] string capability is the shifted find key.
	KeySfind

	// The KeyShelp [key_shelp, kHLP] string capability is the shifted help key.
	KeyShelp

	// The KeyShome [key_shome, kHOM] string capability is the shifted home key.
	KeyShome

	// The KeySic [key_sic, kIC] string capability is the shifted insert-character key.
	KeySic

	// The KeySleft [key_sleft, kLFT] string capability is the shifted left-arrow key.
	KeySleft

	// The KeySmessage [key_smessage, kMSG] string capability is the shifted message key.
	KeySmessage

	// The KeySmove [key_smove, kMOV] string capability is the shifted move key.
	KeySmove

	// The KeySnext [key_snext, kNXT] string capability is the shifted next key.
	KeySnext

	// The KeySoptions [key_soptions, kOPT] string capability is the shifted options key.
	KeySoptions

	// The KeySprevious [key_sprevious, kPRV] string capability is the shifted previous key.
	KeySprevious

	// The KeySprint [key_sprint, kPRT] string capability is the shifted print key.
	KeySprint

	// The KeySredo [key_sredo, kRDO] string capability is the shifted redo key.
	KeySredo

	// The KeySreplace [key_sreplace, kRPL] string capability is the shifted replace key.
	KeySreplace

	// The KeySright [key_sright, kRIT] string capability is the shifted right-arrow key.
	KeySright

	// The KeySrsume [key_srsume, kRES] string capability is the shifted resume key.
	KeySrsume

	// The KeySsave [key_ssave, kSAV] string capability is the shifted save key.
	KeySsave

	// The KeySsuspend [key_ssuspend, kSPD] string capability is the shifted suspend key.
	KeySsuspend

	// The KeySundo [key_sundo, kUND] string capability is the shifted undo key.
	KeySundo

	// The ReqForInput [req_for_input, rfi] string capability is the send next input char (for ptys).
	ReqForInput

	// The KeyF11 [key_f11, kf11] string capability is the F11 function key.
	KeyF11

	// The KeyF12 [key_f12, kf12] string capability is the F12 function key.
	KeyF12

	// The KeyF13 [key_f13, kf13] string capability is the F13 function key.
	KeyF13

	// The KeyF14 [key_f14, kf14] string capability is the F14 function key.
	KeyF14

	// The KeyF15 [key_f15, kf15] string capability is the F15 function key.
	KeyF15

	// The KeyF16 [key_f16, kf16] string capability is the F16 function key.
	KeyF16

	// The KeyF17 [key_f17, kf17] string capability is the F17 function key.
	KeyF17

	// The KeyF18 [key_f18, kf18] string capability is the F18 function key.
	KeyF18

	// The KeyF19 [key_f19, kf19] string capability is the F19 function key.
	KeyF19

	// The KeyF20 [key_f20, kf20] string capability is the F20 function key.
	KeyF20

	// The KeyF21 [key_f21, kf21] string capability is the F21 function key.
	KeyF21

	// The KeyF22 [key_f22, kf22] string capability is the F22 function key.
	KeyF22

	// The KeyF23 [key_f23, kf23] string capability is the F23 function key.
	KeyF23

	// The KeyF24 [key_f24, kf24] string capability is the F24 function key.
	KeyF24

	// The KeyF25 [key_f25, kf25] string capability is the F25 function key.
	KeyF25

	// The KeyF26 [key_f26, kf26] string capability is the F26 function key.
	KeyF26

	// The KeyF27 [key_f27, kf27] string capability is the F27 function key.
	KeyF27

	// The KeyF28 [key_f28, kf28] string capability is the F28 function key.
	KeyF28

	// The KeyF29 [key_f29, kf29] string capability is the F29 function key.
	KeyF29

	// The KeyF30 [key_f30, kf30] string capability is the F30 function key.
	KeyF30

	// The KeyF31 [key_f31, kf31] string capability is the F31 function key.
	KeyF31

	// The KeyF32 [key_f32, kf32] string capability is the F32 function key.
	KeyF32

	// The KeyF33 [key_f33, kf33] string capability is the F33 function key.
	KeyF33

	// The KeyF34 [key_f34, kf34] string capability is the F34 function key.
	KeyF34

	// The KeyF35 [key_f35, kf35] string capability is the F35 function key.
	KeyF35

	// The KeyF36 [key_f36, kf36] string capability is the F36 function key.
	KeyF36

	// The KeyF37 [key_f37, kf37] string capability is the F37 function key.
	KeyF37

	// The KeyF38 [key_f38, kf38] string capability is the F38 function key.
	KeyF38

	// The KeyF39 [key_f39, kf39] string capability is the F39 function key.
	KeyF39

	// The KeyF40 [key_f40, kf40] string capability is the F40 function key.
	KeyF40

	// The KeyF41 [key_f41, kf41] string capability is the F41 function key.
	KeyF41

	// The KeyF42 [key_f42, kf42] string capability is the F42 function key.
	KeyF42

	// The KeyF43 [key_f43, kf43] string capability is the F43 function key.
	KeyF43

	// The KeyF44 [key_f44, kf44] string capability is the F44 function key.
	KeyF44

	// The KeyF45 [key_f45, kf45] string capability is the F45 function key.
	KeyF45

	// The KeyF46 [key_f46, kf46] string capability is the F46 function key.
	KeyF46

	// The KeyF47 [key_f47, kf47] string capability is the F47 function key.
	KeyF47

	// The KeyF48 [key_f48, kf48] string capability is the F48 function key.
	KeyF48

	// The KeyF49 [key_f49, kf49] string capability is the F49 function key.
	KeyF49

	// The KeyF50 [key_f50, kf50] string capability is the F50 function key.
	KeyF50

	// The KeyF51 [key_f51, kf51] string capability is the F51 function key.
	KeyF51

	// The KeyF52 [key_f52, kf52] string capability is the F52 function key.
	KeyF52

	// The KeyF53 [key_f53, kf53] string capability is the F53 function key.
	KeyF53

	// The KeyF54 [key_f54, kf54] string capability is the F54 function key.
	KeyF54

	// The KeyF55 [key_f55, kf55] string capability is the F55 function key.
	KeyF55

	// The KeyF56 [key_f56, kf56] string capability is the F56 function key.
	KeyF56

	// The KeyF57 [key_f57, kf57] string capability is the F57 function key.
	KeyF57

	// The KeyF58 [key_f58, kf58] string capability is the F58 function key.
	KeyF58

	// The KeyF59 [key_f59, kf59] string capability is the F59 function key.
	KeyF59

	// The KeyF60 [key_f60, kf60] string capability is the F60 function key.
	KeyF60

	// The KeyF61 [key_f61, kf61] string capability is the F61 function key.
	KeyF61

	// The KeyF62 [key_f62, kf62] string capability is the F62 function key.
	KeyF62

	// The KeyF63 [key_f63, kf63] string capability is the F63 function key.
	KeyF63

	// The ClrBol [clr_bol, el1] string capability is the Clear to beginning of line.
	ClrBol

	// The ClearMargins [clear_margins, mgc] string capability is the clear right and left soft margins.
	ClearMargins

	// The SetLeftMargin [set_left_margin, smgl] string capability is the set left soft margin at current column.	 See smgl. (ML is not in BSD termcap).
	SetLeftMargin

	// The SetRightMargin [set_right_margin, smgr] string capability is the set right soft margin at current column.
	SetRightMargin

	// The LabelFormat [label_format, fln] string capability is the label format.
	LabelFormat

	// The SetClock [set_clock, sclk] string capability is the set clock, #1 hrs #2 mins #3 secs.
	SetClock

	// The DisplayClock [display_clock, dclk] string capability is the display clock.
	DisplayClock

	// The RemoveClock [remove_clock, rmclk] string capability is the remove clock.
	RemoveClock

	// The CreateWindow [create_window, cwin] string capability is the define a window #1 from #2,#3 to #4,#5.
	CreateWindow

	// The GotoWindow [goto_window, wingo] string capability is the go to window #1.
	GotoWindow

	// The Hangup [hangup, hup] string capability is the hang-up phone.
	Hangup

	// The DialPhone [dial_phone, dial] string capability is the dial number #1.
	DialPhone

	// The QuickDial [quick_dial, qdial] string capability is the dial number #1 without checking.
	QuickDial

	// The Tone [tone, tone] string capability is the select touch tone dialing.
	Tone

	// The Pulse [pulse, pulse] string capability is the select pulse dialing.
	Pulse

	// The FlashHook [flash_hook, hook] string capability is the flash switch hook.
	FlashHook

	// The FixedPause [fixed_pause, pause] string capability is the pause for 2-3 seconds.
	FixedPause

	// The WaitTone [wait_tone, wait] string capability is the wait for dial-tone.
	WaitTone

	// The User0 [user0, u0] string capability is the User string #0.
	User0

	// The User1 [user1, u1] string capability is the User string #1.
	User1

	// The User2 [user2, u2] string capability is the User string #2.
	User2

	// The User3 [user3, u3] string capability is the User string #3.
	User3

	// The User4 [user4, u4] string capability is the User string #4.
	User4

	// The User5 [user5, u5] string capability is the User string #5.
	User5

	// The User6 [user6, u6] string capability is the User string #6.
	User6

	// The User7 [user7, u7] string capability is the User string #7.
	User7

	// The User8 [user8, u8] string capability is the User string #8.
	User8

	// The User9 [user9, u9] string capability is the User string #9.
	User9

	// The OrigPair [orig_pair, op] string capability is the Set default pair to its original value.
	OrigPair

	// The OrigColors [orig_colors, oc] string capability is the Set all color pairs to the original ones.
	OrigColors

	// The InitializeColor [initialize_color, initc] string capability is the initialize color #1 to (#2,#3,#4).
	InitializeColor

	// The InitializePair [initialize_pair, initp] string capability is the Initialize color pair #1 to fg=(#2,#3,#4), bg=(#5,#6,#7).
	InitializePair

	// The SetColorPair [set_color_pair, scp] string capability is the Set current color pair to #1.
	SetColorPair

	// The SetForeground [set_foreground, setf] string capability is the Set foreground color #1.
	SetForeground

	// The SetBackground [set_background, setb] string capability is the Set background color #1.
	SetBackground

	// The ChangeCharPitch [change_char_pitch, cpi] string capability is the Change number of characters per inch to #1.
	ChangeCharPitch

	// The ChangeLinePitch [change_line_pitch, lpi] string capability is the Change number of lines per inch to #1.
	ChangeLinePitch

	// The ChangeResHorz [change_res_horz, chr] string capability is the Change horizontal resolution to #1.
	ChangeResHorz

	// The ChangeResVert [change_res_vert, cvr] string capability is the Change vertical resolution to #1.
	ChangeResVert

	// The DefineChar [define_char, defc] string capability is the Define a character #1, #2 dots wide, descender #3.
	DefineChar

	// The EnterDoublewideMode [enter_doublewide_mode, swidm] string capability is the Enter double-wide mode.
	EnterDoublewideMode

	// The EnterDraftQuality [enter_draft_quality, sdrfq] string capability is the Enter draft-quality mode.
	EnterDraftQuality

	// The EnterItalicsMode [enter_italics_mode, sitm] string capability is the Enter italic mode.
	EnterItalicsMode

	// The EnterLeftwardMode [enter_leftward_mode, slm] string capability is the Start leftward carriage motion.
	EnterLeftwardMode

	// The EnterMicroMode [enter_micro_mode, smicm] string capability is the Start micro-motion mode.
	EnterMicroMode

	// The EnterNearLetterQuality [enter_near_letter_quality, snlq] string capability is the Enter NLQ mode.
	EnterNearLetterQuality

	// The EnterNormalQuality [enter_normal_quality, snrmq] string capability is the Enter normal-quality mode.
	EnterNormalQuality

	// The EnterShadowMode [enter_shadow_mode, sshm] string capability is the Enter shadow-print mode.
	EnterShadowMode

	// The EnterSubscriptMode [enter_subscript_mode, ssubm] string capability is the Enter subscript mode.
	EnterSubscriptMode

	// The EnterSuperscriptMode [enter_superscript_mode, ssupm] string capability is the Enter superscript mode.
	EnterSuperscriptMode

	// The EnterUpwardMode [enter_upward_mode, sum] string capability is the Start upward carriage motion.
	EnterUpwardMode

	// The ExitDoublewideMode [exit_doublewide_mode, rwidm] string capability is the End double-wide mode.
	ExitDoublewideMode

	// The ExitItalicsMode [exit_italics_mode, ritm] string capability is the End italic mode.
	ExitItalicsMode

	// The ExitLeftwardMode [exit_leftward_mode, rlm] string capability is the End left-motion mode.
	ExitLeftwardMode

	// The ExitMicroMode [exit_micro_mode, rmicm] string capability is the End micro-motion mode.
	ExitMicroMode

	// The ExitShadowMode [exit_shadow_mode, rshm] string capability is the End shadow-print mode.
	ExitShadowMode

	// The ExitSubscriptMode [exit_subscript_mode, rsubm] string capability is the End subscript mode.
	ExitSubscriptMode

	// The ExitSuperscriptMode [exit_superscript_mode, rsupm] string capability is the End superscript mode.
	ExitSuperscriptMode

	// The ExitUpwardMode [exit_upward_mode, rum] string capability is the End reverse character motion.
	ExitUpwardMode

	// The MicroColumnAddress [micro_column_address, mhpa] string capability is the Like column_address in micro mode.
	MicroColumnAddress

	// The MicroDown [micro_down, mcud1] string capability is the Like cursor_down in micro mode.
	MicroDown

	// The MicroLeft [micro_left, mcub1] string capability is the Like cursor_left in micro mode.
	MicroLeft

	// The MicroRight [micro_right, mcuf1] string capability is the Like cursor_right in micro mode.
	MicroRight

	// The MicroRowAddress [micro_row_address, mvpa] string capability is the Like row_address #1 in micro mode.
	MicroRowAddress

	// The MicroUp [micro_up, mcuu1] string capability is the Like cursor_up in micro mode.
	MicroUp

	// The OrderOfPins [order_of_pins, porder] string capability is the Match software bits to print-head pins.
	OrderOfPins

	// The ParmDownMicro [parm_down_micro, mcud] string capability is the Like parm_down_cursor in micro mode.
	ParmDownMicro

	// The ParmLeftMicro [parm_left_micro, mcub] string capability is the Like parm_left_cursor in micro mode.
	ParmLeftMicro

	// The ParmRightMicro [parm_right_micro, mcuf] string capability is the Like parm_right_cursor in micro mode.
	ParmRightMicro

	// The ParmUpMicro [parm_up_micro, mcuu] string capability is the Like parm_up_cursor in micro mode.
	ParmUpMicro

	// The SelectCharSet [select_char_set, scs] string capability is the Select character set, #1.
	SelectCharSet

	// The SetBottomMargin [set_bottom_margin, smgb] string capability is the Set bottom margin at current line.
	SetBottomMargin

	// The SetBottomMarginParm [set_bottom_margin_parm, smgbp] string capability is the Set bottom margin at line #1 or (if smgtp is not given) #2 lines from bottom.
	SetBottomMarginParm

	// The SetLeftMarginParm [set_left_margin_parm, smglp] string capability is the Set left (right) margin at column #1.
	SetLeftMarginParm

	// The SetRightMarginParm [set_right_margin_parm, smgrp] string capability is the Set right margin at column #1.
	SetRightMarginParm

	// The SetTopMargin [set_top_margin, smgt] string capability is the Set top margin at current line.
	SetTopMargin

	// The SetTopMarginParm [set_top_margin_parm, smgtp] string capability is the Set top (bottom) margin at row #1.
	SetTopMarginParm

	// The StartBitImage [start_bit_image, sbim] string capability is the Start printing bit image graphics.
	StartBitImage

	// The StartCharSetDef [start_char_set_def, scsd] string capability is the Start character set definition #1, with #2 characters in the set.
	StartCharSetDef

	// The StopBitImage [stop_bit_image, rbim] string capability is the Stop printing bit image graphics.
	StopBitImage

	// The StopCharSetDef [stop_char_set_def, rcsd] string capability is the End definition of character set #1.
	StopCharSetDef

	// The SubscriptCharacters [subscript_characters, subcs] string capability is the List of subscriptable characters.
	SubscriptCharacters

	// The SuperscriptCharacters [superscript_characters, supcs] string capability is the List of superscriptable characters.
	SuperscriptCharacters

	// The TheseCauseCr [these_cause_cr, docr] string capability is the Printing any of these characters causes CR.
	TheseCauseCr

	// The ZeroMotion [zero_motion, zerom] string capability is the No motion for subsequent character.
	ZeroMotion

	// The CharSetNames [char_set_names, csnm] string capability is the Produce #1'th item from list of character set names.
	CharSetNames

	// The KeyMouse [key_mouse, kmous] string capability is the Mouse event has occurred.
	KeyMouse

	// The MouseInfo [mouse_info, minfo] string capability is the Mouse status information.
	MouseInfo

	// The ReqMousePos [req_mouse_pos, reqmp] string capability is the Request mouse position.
	ReqMousePos

	// The GetMouse [get_mouse, getm] string capability is the Curses should get button events, parameter #1 not documented.
	GetMouse

	// The SetAForeground [set_a_foreground, setaf] string capability is the Set foreground color to #1, using ANSI escape.
	SetAForeground

	// The SetABackground [set_a_background, setab] string capability is the Set background color to #1, using ANSI escape.
	SetABackground

	// The PkeyPlab [pkey_plab, pfxl] string capability is the Program function key #1 to type string #2 and show string #3.
	PkeyPlab

	// The DeviceType [device_type, devt] string capability is the Indicate language/codeset support.
	DeviceType

	// The CodeSetInit [code_set_init, csin] string capability is the Init sequence for multiple codesets.
	CodeSetInit

	// The Set0DesSeq [set0_des_seq, s0ds] string capability is the Shift to codeset 0 (EUC set 0, ASCII).
	Set0DesSeq

	// The Set1DesSeq [set1_des_seq, s1ds] string capability is the Shift to codeset 1.
	Set1DesSeq

	// The Set2DesSeq [set2_des_seq, s2ds] string capability is the Shift to codeset 2.
	Set2DesSeq

	// The Set3DesSeq [set3_des_seq, s3ds] string capability is the Shift to codeset 3.
	Set3DesSeq

	// The SetLrMargin [set_lr_margin, smglr] string capability is the Set both left and right margins to #1, #2.  (ML is not in BSD termcap).
	SetLrMargin

	// The SetTbMargin [set_tb_margin, smgtb] string capability is the Sets both top and bottom margins to #1, #2.
	SetTbMargin

	// The BitImageRepeat [bit_image_repeat, birep] string capability is the Repeat bit image cell #1 #2 times.
	BitImageRepeat

	// The BitImageNewline [bit_image_newline, binel] string capability is the Move to next row of the bit image.
	BitImageNewline

	// The BitImageCarriageReturn [bit_image_carriage_return, bicr] string capability is the Move to beginning of same row.
	BitImageCarriageReturn

	// The ColorNames [color_names, colornm] string capability is the Give name for color #1.
	ColorNames

	// The DefineBitImageRegion [define_bit_image_region, defbi] string capability is the Define rectangular bit image region.
	DefineBitImageRegion

	// The EndBitImageRegion [end_bit_image_region, endbi] string capability is the End a bit-image region.
	EndBitImageRegion

	// The SetColorBand [set_color_band, setcolor] string capability is the Change to ribbon color #1.
	SetColorBand

	// The SetPageLength [set_page_length, slines] string capability is the Set page length to #1 lines.
	SetPageLength

	// The DisplayPcChar [display_pc_char, dispc] string capability is the Display PC character #1.
	DisplayPcChar

	// The EnterPcCharsetMode [enter_pc_charset_mode, smpch] string capability is the Enter PC character display mode.
	EnterPcCharsetMode

	// The ExitPcCharsetMode [exit_pc_charset_mode, rmpch] string capability is the Exit PC character display mode.
	ExitPcCharsetMode

	// The EnterScancodeMode [enter_scancode_mode, smsc] string capability is the Enter PC scancode mode.
	EnterScancodeMode

	// The ExitScancodeMode [exit_scancode_mode, rmsc] string capability is the Exit PC scancode mode.
	ExitScancodeMode

	// The PcTermOptions [pc_term_options, pctrm] string capability is the PC terminal options.
	PcTermOptions

	// The ScancodeEscape [scancode_escape, scesc] string capability is the Escape for scancode emulation.
	ScancodeEscape

	// The AltScancodeEsc [alt_scancode_esc, scesa] string capability is the Alternate escape for scancode emulation.
	AltScancodeEsc

	// The EnterHorizontalHlMode [enter_horizontal_hl_mode, ehhlm] string capability is the Enter horizontal highlight mode.
	EnterHorizontalHlMode

	// The EnterLeftHlMode [enter_left_hl_mode, elhlm] string capability is the Enter left highlight mode.
	EnterLeftHlMode

	// The EnterLowHlMode [enter_low_hl_mode, elohlm] string capability is the Enter low highlight mode.
	EnterLowHlMode

	// The EnterRightHlMode [enter_right_hl_mode, erhlm] string capability is the Enter right highlight mode.
	EnterRightHlMode

	// The EnterTopHlMode [enter_top_hl_mode, ethlm] string capability is the Enter top highlight mode.
	EnterTopHlMode

	// The EnterVerticalHlMode [enter_vertical_hl_mode, evhlm] string capability is the Enter vertical highlight mode.
	EnterVerticalHlMode

	// The SetAAttributes [set_a_attributes, sgr1] string capability is the Define second set of video attributes #1-#6.
	SetAAttributes

	// The SetPglenInch [set_pglen_inch, slength] string capability is the Set page length to #1 hundredth of an inch (some implementations use sL for termcap).
	SetPglenInch

	// The TermcapInit2 [termcap_init2, OTi2] string capability is the secondary initialization string.
	TermcapInit2

	// The TermcapReset [termcap_reset, OTrs] string capability is the terminal reset string.
	TermcapReset

	// The LinefeedIfNotLf [linefeed_if_not_lf, OTnl] string capability is the use to move down.
	LinefeedIfNotLf

	// The BackspaceIfNotBs [backspace_if_not_bs, OTbc] string capability is the move left, if not ^H.
	BackspaceIfNotBs

	// The OtherNonFunctionKeys [other_non_function_keys, OTko] string capability is the list of self-mapped keycaps.
	OtherNonFunctionKeys

	// The ArrowKeyMap [arrow_key_map, OTma] string capability is the map arrow keys rogue(1) motion keys.
	ArrowKeyMap

	// The AcsUlcorner [acs_ulcorner, OTG2] string capability is the single upper left.
	AcsUlcorner

	// The AcsLlcorner [acs_llcorner, OTG3] string capability is the single lower left.
	AcsLlcorner

	// The AcsUrcorner [acs_urcorner, OTG1] string capability is the single upper right.
	AcsUrcorner

	// The AcsLrcorner [acs_lrcorner, OTG4] string capability is the single lower right.
	AcsLrcorner

	// The AcsLtee [acs_ltee, OTGR] string capability is the tee pointing right.
	AcsLtee

	// The AcsRtee [acs_rtee, OTGL] string capability is the tee pointing left.
	AcsRtee

	// The AcsBtee [acs_btee, OTGU] string capability is the tee pointing up.
	AcsBtee

	// The AcsTtee [acs_ttee, OTGD] string capability is the tee pointing down.
	AcsTtee

	// The AcsHline [acs_hline, OTGH] string capability is the single horizontal line.
	AcsHline

	// The AcsVline [acs_vline, OTGV] string capability is the single vertical line.
	AcsVline

	// The AcsPlus [acs_plus, OTGC] string capability is the single intersection.
	AcsPlus

	// The MemoryLock [memory_lock, meml] string capability is the lock memory above cursor.
	MemoryLock

	// The MemoryUnlock [memory_unlock, memu] string capability is the unlock memory.
	MemoryUnlock

	// The BoxChars1 [box_chars_1, box1] string capability is the box characters primary set.
	BoxChars1
)

const (
	// CapCountBool is the count of bool capabilities.
	CapCountBool = ReturnDoesClrEol + 1

	// CapCountNum is the count of num capabilities.
	CapCountNum = NumberOfFunctionKeys + 1

	// CapCountString is the count of string capabilities.
	CapCountString = BoxChars1 + 1
)

// boolCapNames are the bool term cap names.
var boolCapNames = [...]string{
	"auto_left_margin", "bw",
	"auto_right_margin", "am",
	"no_esc_ctlc", "xsb",
	"ceol_standout_glitch", "xhp",
	"eat_newline_glitch", "xenl",
	"erase_overstrike", "eo",
	"generic_type", "gn",
	"hard_copy", "hc",
	"has_meta_key", "km",
	"has_status_line", "hs",
	"insert_null_glitch", "in",
	"memory_above", "da",
	"memory_below", "db",
	"move_insert_mode", "mir",
	"move_standout_mode", "msgr",
	"over_strike", "os",
	"status_line_esc_ok", "eslok",
	"dest_tabs_magic_smso", "xt",
	"tilde_glitch", "hz",
	"transparent_underline", "ul",
	"xon_xoff", "xon",
	"needs_xon_xoff", "nxon",
	"prtr_silent", "mc5i",
	"hard_cursor", "chts",
	"non_rev_rmcup", "nrrmc",
	"no_pad_char", "npc",
	"non_dest_scroll_region", "ndscr",
	"can_change", "ccc",
	"back_color_erase", "bce",
	"hue_lightness_saturation", "hls",
	"col_addr_glitch", "xhpa",
	"cr_cancels_micro_mode", "crxm",
	"has_print_wheel", "daisy",
	"row_addr_glitch", "xvpa",
	"semi_auto_right_margin", "sam",
	"cpi_changes_res", "cpix",
	"lpi_changes_res", "lpix",
	"backspaces_with_bs", "OTbs",
	"crt_no_scrolling", "OTns",
	"no_correctly_working_cr", "OTnc",
	"gnu_has_meta_key", "OTMT",
	"linefeed_is_newline", "OTNL",
	"has_hardware_tabs", "OTpt",
	"return_does_clr_eol", "OTxr",
}

// numCapNames are the num term cap names.
var numCapNames = [...]string{
	"columns", "cols",
	"init_tabs", "it",
	"lines", "lines",
	"lines_of_memory", "lm",
	"magic_cookie_glitch", "xmc",
	"padding_baud_rate", "pb",
	"virtual_terminal", "vt",
	"width_status_line", "wsl",
	"num_labels", "nlab",
	"label_height", "lh",
	"label_width", "lw",
	"max_attributes", "ma",
	"maximum_windows", "wnum",
	"max_colors", "colors",
	"max_pairs", "pairs",
	"no_color_video", "ncv",
	"buffer_capacity", "bufsz",
	"dot_vert_spacing", "spinv",
	"dot_horz_spacing", "spinh",
	"max_micro_address", "maddr",
	"max_micro_jump", "mjump",
	"micro_col_size", "mcs",
	"micro_line_size", "mls",
	"number_of_pins", "npins",
	"output_res_char", "orc",
	"output_res_line", "orl",
	"output_res_horz_inch", "orhi",
	"output_res_vert_inch", "orvi",
	"print_rate", "cps",
	"wide_char_size", "widcs",
	"buttons", "btns",
	"bit_image_entwining", "bitwin",
	"bit_image_type", "bitype",
	"magic_cookie_glitch_ul", "OTug",
	"carriage_return_delay", "OTdC",
	"new_line_delay", "OTdN",
	"backspace_delay", "OTdB",
	"horizontal_tab_delay", "OTdT",
	"number_of_function_keys", "OTkn",
}

// stringCapNames are the string term cap names.
var stringCapNames = [...]string{
	"back_tab", "cbt",
	"bell", "bel",
	"carriage_return", "cr",
	"change_scroll_region", "csr",
	"clear_all_tabs", "tbc",
	"clear_screen", "clear",
	"clr_eol", "el",
	"clr_eos", "ed",
	"column_address", "hpa",
	"command_character", "cmdch",
	"cursor_address", "cup",
	"cursor_down", "cud1",
	"cursor_home", "home",
	"cursor_invisible", "civis",
	"cursor_left", "cub1",
	"cursor_mem_address", "mrcup",
	"cursor_normal", "cnorm",
	"cursor_right", "cuf1",
	"cursor_to_ll", "ll",
	"cursor_up", "cuu1",
	"cursor_visible", "cvvis",
	"delete_character", "dch1",
	"delete_line", "dl1",
	"dis_status_line", "dsl",
	"down_half_line", "hd",
	"enter_alt_charset_mode", "smacs",
	"enter_blink_mode", "blink",
	"enter_bold_mode", "bold",
	"enter_ca_mode", "smcup",
	"enter_delete_mode", "smdc",
	"enter_dim_mode", "dim",
	"enter_insert_mode", "smir",
	"enter_secure_mode", "invis",
	"enter_protected_mode", "prot",
	"enter_reverse_mode", "rev",
	"enter_standout_mode", "smso",
	"enter_underline_mode", "smul",
	"erase_chars", "ech",
	"exit_alt_charset_mode", "rmacs",
	"exit_attribute_mode", "sgr0",
	"exit_ca_mode", "rmcup",
	"exit_delete_mode", "rmdc",
	"exit_insert_mode", "rmir",
	"exit_standout_mode", "rmso",
	"exit_underline_mode", "rmul",
	"flash_screen", "flash",
	"form_feed", "ff",
	"from_status_line", "fsl",
	"init_1string", "is1",
	"init_2string", "is2",
	"init_3string", "is3",
	"init_file", "if",
	"insert_character", "ich1",
	"insert_line", "il1",
	"insert_padding", "ip",
	"key_backspace", "kbs",
	"key_catab", "ktbc",
	"key_clear", "kclr",
	"key_ctab", "kctab",
	"key_dc", "kdch1",
	"key_dl", "kdl1",
	"key_down", "kcud1",
	"key_eic", "krmir",
	"key_eol", "kel",
	"key_eos", "ked",
	"key_f0", "kf0",
	"key_f1", "kf1",
	"key_f10", "kf10",
	"key_f2", "kf2",
	"key_f3", "kf3",
	"key_f4", "kf4",
	"key_f5", "kf5",
	"key_f6", "kf6",
	"key_f7", "kf7",
	"key_f8", "kf8",
	"key_f9", "kf9",
	"key_home", "khome",
	"key_ic", "kich1",
	"key_il", "kil1",
	"key_left", "kcub1",
	"key_ll", "kll",
	"key_npage", "knp",
	"key_ppage", "kpp",
	"key_right", "kcuf1",
	"key_sf", "kind",
	"key_sr", "kri",
	"key_stab", "khts",
	"key_up", "kcuu1",
	"keypad_local", "rmkx",
	"keypad_xmit", "smkx",
	"lab_f0", "lf0",
	"lab_f1", "lf1",
	"lab_f10", "lf10",
	"lab_f2", "lf2",
	"lab_f3", "lf3",
	"lab_f4", "lf4",
	"lab_f5", "lf5",
	"lab_f6", "lf6",
	"lab_f7", "lf7",
	"lab_f8", "lf8",
	"lab_f9", "lf9",
	"meta_off", "rmm",
	"meta_on", "smm",
	"newline", "nel",
	"pad_char", "pad",
	"parm_dch", "dch",
	"parm_delete_line", "dl",
	"parm_down_cursor", "cud",
	"parm_ich", "ich",
	"parm_index", "indn",
	"parm_insert_line", "il",
	"parm_left_cursor", "cub",
	"parm_right_cursor", "cuf",
	"parm_rindex", "rin",
	"parm_up_cursor", "cuu",
	"pkey_key", "pfkey",
	"pkey_local", "pfloc",
	"pkey_xmit", "pfx",
	"print_screen", "mc0",
	"prtr_off", "mc4",
	"prtr_on", "mc5",
	"repeat_char", "rep",
	"reset_1string", "rs1",
	"reset_2string", "rs2",
	"reset_3string", "rs3",
	"reset_file", "rf",
	"restore_cursor", "rc",
	"row_address", "vpa",
	"save_cursor", "sc",
	"scroll_forward", "ind",
	"scroll_reverse", "ri",
	"set_attributes", "sgr",
	"set_tab", "hts",
	"set_window", "wind",
	"tab", "ht",
	"to_status_line", "tsl",
	"underline_char", "uc",
	"up_half_line", "hu",
	"init_prog", "iprog",
	"key_a1", "ka1",
	"key_a3", "ka3",
	"key_b2", "kb2",
	"key_c1", "kc1",
	"key_c3", "kc3",
	"prtr_non", "mc5p",
	"char_padding", "rmp",
	"acs_chars", "acsc",
	"plab_norm", "pln",
	"key_btab", "kcbt",
	"enter_xon_mode", "smxon",
	"exit_xon_mode", "rmxon",
	"enter_am_mode", "smam",
	"exit_am_mode", "rmam",
	"xon_character", "xonc",
	"xoff_character", "xoffc",
	"ena_acs", "enacs",
	"label_on", "smln",
	"label_off", "rmln",
	"key_beg", "kbeg",
	"key_cancel", "kcan",
	"key_close", "kclo",
	"key_command", "kcmd",
	"key_copy", "kcpy",
	"key_create", "kcrt",
	"key_end", "kend",
	"key_enter", "kent",
	"key_exit", "kext",
	"key_find", "kfnd",
	"key_help", "khlp",
	"key_mark", "kmrk",
	"key_message", "kmsg",
	"key_move", "kmov",
	"key_next", "knxt",
	"key_open", "kopn",
	"key_options", "kopt",
	"key_previous", "kprv",
	"key_print", "kprt",
	"key_redo", "krdo",
	"key_reference", "kref",
	"key_refresh", "krfr",
	"key_replace", "krpl",
	"key_restart", "krst",
	"key_resume", "kres",
	"key_save", "ksav",
	"key_suspend", "kspd",
	"key_undo", "kund",
	"key_sbeg", "kBEG",
	"key_scancel", "kCAN",
	"key_scommand", "kCMD",
	"key_scopy", "kCPY",
	"key_screate", "kCRT",
	"key_sdc", "kDC",
	"key_sdl", "kDL",
	"key_select", "kslt",
	"key_send", "kEND",
	"key_seol", "kEOL",
	"key_sexit", "kEXT",
	"key_sfind", "kFND",
	"key_shelp", "kHLP",
	"key_shome", "kHOM",
	"key_sic", "kIC",
	"key_sleft", "kLFT",
	"key_smessage", "kMSG",
	"key_smove", "kMOV",
	"key_snext", "kNXT",
	"key_soptions", "kOPT",
	"key_sprevious", "kPRV",
	"key_sprint", "kPRT",
	"key_sredo", "kRDO",
	"key_sreplace", "kRPL",
	"key_sright", "kRIT",
	"key_srsume", "kRES",
	"key_ssave", "kSAV",
	"key_ssuspend", "kSPD",
	"key_sundo", "kUND",
	"req_for_input", "rfi",
	"key_f11", "kf11",
	"key_f12", "kf12",
	"key_f13", "kf13",
	"key_f14", "kf14",
	"key_f15", "kf15",
	"key_f16", "kf16",
	"key_f17", "kf17",
	"key_f18", "kf18",
	"key_f19", "kf19",
	"key_f20", "kf20",
	"key_f21", "kf21",
	"key_f22", "kf22",
	"key_f23", "kf23",
	"key_f24", "kf24",
	"key_f25", "kf25",
	"key_f26", "kf26",
	"key_f27", "kf27",
	"key_f28", "kf28",
	"key_f29", "kf29",
	"key_f30", "kf30",
	"key_f31", "kf31",
	"key_f32", "kf32",
	"key_f33", "kf33",
	"key_f34", "kf34",
	"key_f35", "kf35",
	"key_f36", "kf36",
	"key_f37", "kf37",
	"key_f38", "kf38",
	"key_f39", "kf39",
	"key_f40", "kf40",
	"key_f41", "kf41",
	"key_f42", "kf42",
	"key_f43", "kf43",
	"key_f44", "kf44",
	"key_f45", "kf45",
	"key_f46", "kf46",
	"key_f47", "kf47",
	"key_f48", "kf48",
	"key_f49", "kf49",
	"key_f50", "kf50",
	"key_f51", "kf51",
	"key_f52", "kf52",
	"key_f53", "kf53",
	"key_f54", "kf54",
	"key_f55", "kf55",
	"key_f56", "kf56",
	"key_f57", "kf57",
	"key_f58", "kf58",
	"key_f59", "kf59",
	"key_f60", "kf60",
	"key_f61", "kf61",
	"key_f62", "kf62",
	"key_f63", "kf63",
	"clr_bol", "el1",
	"clear_margins", "mgc",
	"set_left_margin", "smgl",
	"set_right_margin", "smgr",
	"label_format", "fln",
	"set_clock", "sclk",
	"display_clock", "dclk",
	"remove_clock", "rmclk",
	"create_window", "cwin",
	"goto_window", "wingo",
	"hangup", "hup",
	"dial_phone", "dial",
	"quick_dial", "qdial",
	"tone", "tone",
	"pulse", "pulse",
	"flash_hook", "hook",
	"fixed_pause", "pause",
	"wait_tone", "wait",
	"user0", "u0",
	"user1", "u1",
	"user2", "u2",
	"user3", "u3",
	"user4", "u4",
	"user5", "u5",
	"user6", "u6",
	"user7", "u7",
	"user8", "u8",
	"user9", "u9",
	"orig_pair", "op",
	"orig_colors", "oc",
	"initialize_color", "initc",
	"initialize_pair", "initp",
	"set_color_pair", "scp",
	"set_foreground", "setf",
	"set_background", "setb",
	"change_char_pitch", "cpi",
	"change_line_pitch", "lpi",
	"change_res_horz", "chr",
	"change_res_vert", "cvr",
	"define_char", "defc",
	"enter_doublewide_mode", "swidm",
	"enter_draft_quality", "sdrfq",
	"enter_italics_mode", "sitm",
	"enter_leftward_mode", "slm",
	"enter_micro_mode", "smicm",
	"enter_near_letter_quality", "snlq",
	"enter_normal_quality", "snrmq",
	"enter_shadow_mode", "sshm",
	"enter_subscript_mode", "ssubm",
	"enter_superscript_mode", "ssupm",
	"enter_upward_mode", "sum",
	"exit_doublewide_mode", "rwidm",
	"exit_italics_mode", "ritm",
	"exit_leftward_mode", "rlm",
	"exit_micro_mode", "rmicm",
	"exit_shadow_mode", "rshm",
	"exit_subscript_mode", "rsubm",
	"exit_superscript_mode", "rsupm",
	"exit_upward_mode", "rum",
	"micro_column_address", "mhpa",
	"micro_down", "mcud1",
	"micro_left", "mcub1",
	"micro_right", "mcuf1",
	"micro_row_address", "mvpa",
	"micro_up", "mcuu1",
	"order_of_pins", "porder",
	"parm_down_micro", "mcud",
	"parm_left_micro", "mcub",
	"parm_right_micro", "mcuf",
	"parm_up_micro", "mcuu",
	"select_char_set", "scs",
	"set_bottom_margin", "smgb",
	"set_bottom_margin_parm", "smgbp",
	"set_left_margin_parm", "smglp",
	"set_right_margin_parm", "smgrp",
	"set_top_margin", "smgt",
	"set_top_margin_parm", "smgtp",
	"start_bit_image", "sbim",
	"start_char_set_def", "scsd",
	"stop_bit_image", "rbim",
	"stop_char_set_def", "rcsd",
	"subscript_characters", "subcs",
	"superscript_characters", "supcs",
	"these_cause_cr", "docr",
	"zero_motion", "zerom",
	"char_set_names", "csnm",
	"key_mouse", "kmous",
	"mouse_info", "minfo",
	"req_mouse_pos", "reqmp",
	"get_mouse", "getm",
	"set_a_foreground", "setaf",
	"set_a_background", "setab",
	"pkey_plab", "pfxl",
	"device_type", "devt",
	"code_set_init", "csin",
	"set0_des_seq", "s0ds",
	"set1_des_seq", "s1ds",
	"set2_des_seq", "s2ds",
	"set3_des_seq", "s3ds",
	"set_lr_margin", "smglr",
	"set_tb_margin", "smgtb",
	"bit_image_repeat", "birep",
	"bit_image_newline", "binel",
	"bit_image_carriage_return", "bicr",
	"color_names", "colornm",
	"define_bit_image_region", "defbi",
	"end_bit_image_region", "endbi",
	"set_color_band", "setcolor",
	"set_page_length", "slines",
	"display_pc_char", "dispc",
	"enter_pc_charset_mode", "smpch",
	"exit_pc_charset_mode", "rmpch",
	"enter_scancode_mode", "smsc",
	"exit_scancode_mode", "rmsc",
	"pc_term_options", "pctrm",
	"scancode_escape", "scesc",
	"alt_scancode_esc", "scesa",
	"enter_horizontal_hl_mode", "ehhlm",
	"enter_left_hl_mode", "elhlm",
	"enter_low_hl_mode", "elohlm",
	"enter_right_hl_mode", "erhlm",
	"enter_top_hl_mode", "ethlm",
	"enter_vertical_hl_mode", "evhlm",
	"set_a_attributes", "sgr1",
	"set_pglen_inch", "slength",
	"termcap_init2", "OTi2",
	"termcap_reset", "OTrs",
	"linefeed_if_not_lf", "OTnl",
	"backspace_if_not_bs", "OTbc",
	"other_non_function_keys", "OTko",
	"arrow_key_map", "OTma",
	"acs_ulcorner", "OTG2",
	"acs_llcorner", "OTG3",
	"acs_urcorner", "OTG1",
	"acs_lrcorner", "OTG4",
	"acs_ltee", "OTGR",
	"acs_rtee", "OTGL",
	"acs_btee", "OTGU",
	"acs_ttee", "OTGD",
	"acs_hline", "OTGH",
	"acs_vline", "OTGV",
	"acs_plus", "OTGC",
	"memory_lock", "meml",
	"memory_unlock", "memu",
	"box_chars_1", "box1",
}
