// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#include "test/cpp/microbenchmarks/huffman_geometries/decode_huff_9_12_9.h"

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_9_12_9 {
const uint8_t HuffDecoderCommon::table2_0_emit_[10] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74};
const uint8_t HuffDecoderCommon::table2_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table3_0_emit_[36] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20, 0x25,
    0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3d, 0x41,
    0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table3_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29, 0x2d,
    0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59,
    0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85,
    0x89, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table4_0_emit_[22] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20,
    0x25, 0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table4_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00,
    0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2d,
    0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00,
    0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table4_1_emit_[46] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70,
    0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a,
    0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
    0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table4_1_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49,
    0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75,
    0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1,
    0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table4_emit_[2] = {
    table4_0_emit_,
    table4_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table4_ops_[2] = {
    table4_0_ops_,
    table4_1_ops_,
};
const uint8_t HuffDecoderCommon::table5_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29,
    0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35,
    0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41,
    0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4d,
    0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table5_1_emit_[52] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e,
    0x70, 0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table5_1_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d,
    0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55,
    0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69, 0x00, 0x6d,
    0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81, 0x00, 0x85,
    0x00, 0x89, 0x00, 0x8d, 0x00, 0x91, 0x00, 0x95, 0x00, 0x99, 0x00, 0x9d,
    0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa9, 0x00, 0xad, 0x00, 0xb1, 0x00, 0xb5,
    0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table5_emit_[2] = {
    table4_0_emit_,
    table5_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table5_ops_[2] = {
    table5_0_ops_,
    table5_1_ops_,
};
const uint8_t HuffDecoderCommon::table1_0_emit_[2] = {0x30, 0x31};
const uint16_t HuffDecoderCommon::table1_0_ops_[32] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085,
    0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085};
const uint8_t HuffDecoderCommon::table1_1_emit_[2] = {0x32, 0x61};
const uint8_t HuffDecoderCommon::table1_2_emit_[2] = {0x63, 0x65};
const uint8_t HuffDecoderCommon::table1_3_emit_[2] = {0x69, 0x6f};
const uint8_t HuffDecoderCommon::table1_4_emit_[2] = {0x73, 0x74};
const uint8_t HuffDecoderCommon::table1_5_emit_[4] = {0x20, 0x25, 0x2d, 0x2e};
const uint16_t HuffDecoderCommon::table1_5_ops_[32] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086,
    0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
    0x0186, 0x0186, 0x0186, 0x0186, 0x0186, 0x0186, 0x0186, 0x0186};
const uint8_t HuffDecoderCommon::table1_6_emit_[4] = {0x2f, 0x33, 0x34, 0x35};
const uint8_t HuffDecoderCommon::table1_7_emit_[4] = {0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table1_8_emit_[4] = {0x3d, 0x41, 0x5f, 0x62};
const uint8_t HuffDecoderCommon::table1_9_emit_[4] = {0x64, 0x66, 0x67, 0x68};
const uint8_t HuffDecoderCommon::table1_10_emit_[4] = {0x6c, 0x6d, 0x6e, 0x70};
const uint8_t HuffDecoderCommon::table1_11_emit_[6] = {0x72, 0x75, 0x3a,
                                                       0x42, 0x43, 0x44};
const uint16_t HuffDecoderCommon::table1_11_ops_[32] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086,
    0x0107, 0x0107, 0x0107, 0x0107, 0x0187, 0x0187, 0x0187, 0x0187,
    0x0207, 0x0207, 0x0207, 0x0207, 0x0287, 0x0287, 0x0287, 0x0287};
const uint8_t HuffDecoderCommon::table1_12_emit_[8] = {0x45, 0x46, 0x47, 0x48,
                                                       0x49, 0x4a, 0x4b, 0x4c};
const uint16_t HuffDecoderCommon::table1_12_ops_[32] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0087, 0x0087, 0x0087, 0x0087,
    0x0107, 0x0107, 0x0107, 0x0107, 0x0187, 0x0187, 0x0187, 0x0187,
    0x0207, 0x0207, 0x0207, 0x0207, 0x0287, 0x0287, 0x0287, 0x0287,
    0x0307, 0x0307, 0x0307, 0x0307, 0x0387, 0x0387, 0x0387, 0x0387};
const uint8_t HuffDecoderCommon::table1_13_emit_[8] = {0x4d, 0x4e, 0x4f, 0x50,
                                                       0x51, 0x52, 0x53, 0x54};
const uint8_t HuffDecoderCommon::table1_14_emit_[8] = {0x55, 0x56, 0x57, 0x59,
                                                       0x6a, 0x6b, 0x71, 0x76};
const uint8_t HuffDecoderCommon::table1_15_emit_[10] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint16_t HuffDecoderCommon::table1_15_ops_[32] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0087, 0x0087, 0x0087, 0x0087,
    0x0107, 0x0107, 0x0107, 0x0107, 0x0187, 0x0187, 0x0187, 0x0187,
    0x0208, 0x0208, 0x0288, 0x0288, 0x0308, 0x0308, 0x0388, 0x0388,
    0x0408, 0x0408, 0x0488, 0x0488, 0x0019, 0x0029, 0x0039, 0x0049};
const uint8_t* const HuffDecoderCommon::table1_emit_[16] = {
    table1_0_emit_,  table1_1_emit_,  table1_2_emit_,  table1_3_emit_,
    table1_4_emit_,  table1_5_emit_,  table1_6_emit_,  table1_7_emit_,
    table1_8_emit_,  table1_9_emit_,  table1_10_emit_, table1_11_emit_,
    table1_12_emit_, table1_13_emit_, table1_14_emit_, table1_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table1_ops_[16] = {
    table1_0_ops_,  table1_0_ops_,  table1_0_ops_,  table1_0_ops_,
    table1_0_ops_,  table1_5_ops_,  table1_5_ops_,  table1_5_ops_,
    table1_5_ops_,  table1_5_ops_,  table1_5_ops_,  table1_11_ops_,
    table1_12_ops_, table1_12_ops_, table1_12_ops_, table1_15_ops_,
};
const uint8_t HuffDecoderCommon::table12_0_inner_[5] = {0x00, 0x01, 0x05, 0x09,
                                                        0x02};
const uint8_t HuffDecoderCommon::table12_0_outer_[8] = {0, 1, 2, 3, 0, 0, 0, 4};
const uint8_t HuffDecoderCommon::table13_0_emit_[9] = {
    0x7c, 0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e};
const uint8_t HuffDecoderCommon::table13_0_inner_[11] = {
    0x00, 0x01, 0x05, 0x09, 0x0d, 0x11, 0x15, 0x19, 0x1d, 0x21, 0x02};
const uint8_t HuffDecoderCommon::table13_0_outer_[16] = {
    0, 0, 0, 1, 0, 2, 0, 3, 4, 5, 6, 7, 8, 9, 0, 10};
const uint8_t HuffDecoderCommon::table14_0_emit_[11] = {
    0x7c, 0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d};
const uint8_t HuffDecoderCommon::table14_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x05, 0x00, 0x00, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00, 0x15,
    0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x25, 0x29, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table15_0_emit_[14] = {
    0x7c, 0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b,
    0x5d, 0x7e, 0x5e, 0x7d, 0x3c, 0x60, 0x7b};
const uint8_t HuffDecoderCommon::table15_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00,
    0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00,
    0x21, 0x00, 0x25, 0x00, 0x29, 0x2d, 0x31, 0x35, 0x02};
const uint8_t HuffDecoderCommon::table16_0_emit_[33] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61, 0x7c, 0x63, 0x7c,
    0x65, 0x7c, 0x69, 0x7c, 0x6f, 0x7c, 0x73, 0x7c, 0x74, 0x23, 0x3e,
    0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d, 0x3c, 0x60, 0x7b};
const uint8_t HuffDecoderCommon::table16_0_ops_[128] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x56, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5a,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5e, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x62, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x66,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6a, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x6e, 0x01, 0x01, 0x01, 0x72, 0x01, 0x01, 0x01, 0x76,
    0x01, 0x7a, 0x01, 0x7e, 0x01, 0x82, 0x01, 0x03};
const uint8_t HuffDecoderCommon::table17_0_emit_[44] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61, 0x7c, 0x63, 0x7c,
    0x65, 0x7c, 0x69, 0x7c, 0x6f, 0x7c, 0x73, 0x7c, 0x74, 0x7c, 0x20,
    0x7c, 0x25, 0x7c, 0x2d, 0x7c, 0x2e, 0x7c, 0x2f, 0x7c, 0x33, 0x7c,
    0x34, 0x7c, 0x35, 0x7c, 0x36, 0x7c, 0x37, 0x7c, 0x38, 0x7c, 0x39};
const uint8_t HuffDecoderCommon::table17_0_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa9};
const uint8_t HuffDecoderCommon::table17_1_emit_[28] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64,
    0x7c, 0x66, 0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d,
    0x7c, 0x6e, 0x7c, 0x70, 0x7c, 0x72, 0x7c, 0x75};
const uint8_t HuffDecoderCommon::table17_1_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table17_2_emit_[20] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63,
    0x23, 0x65, 0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74};
const uint8_t HuffDecoderCommon::table17_2_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table17_3_emit_[20] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63,
    0x3e, 0x65, 0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74};
const uint8_t HuffDecoderCommon::table17_4_emit_[2] = {0x00, 0x24};
const uint8_t HuffDecoderCommon::table17_4_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06};
const uint8_t HuffDecoderCommon::table17_5_emit_[2] = {0x40, 0x5b};
const uint8_t HuffDecoderCommon::table17_6_emit_[2] = {0x5d, 0x7e};
const uint8_t HuffDecoderCommon::table17_7_emit_[5] = {0x5e, 0x7d, 0x3c, 0x60,
                                                       0x7b};
const uint8_t HuffDecoderCommon::table17_7_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00,
    0x00, 0x0e, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x03};
const uint8_t* const HuffDecoderCommon::table17_emit_[8] = {
    table17_0_emit_, table17_1_emit_, table17_2_emit_, table17_3_emit_,
    table17_4_emit_, table17_5_emit_, table17_6_emit_, table17_7_emit_,
};
const uint8_t* const HuffDecoderCommon::table17_ops_[8] = {
    table17_0_ops_, table17_1_ops_, table17_2_ops_, table17_2_ops_,
    table17_4_ops_, table17_4_ops_, table17_4_ops_, table17_7_ops_,
};
const uint16_t HuffDecoderCommon::table18_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0051, 0x0000, 0x0059, 0x0000, 0x0061, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089,
    0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000, 0x00a9};
const uint8_t HuffDecoderCommon::table18_1_emit_[92] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64, 0x7c, 0x66,
    0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70,
    0x7c, 0x72, 0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44,
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48, 0x7c, 0x49, 0x7c, 0x4a,
    0x7c, 0x4b, 0x7c, 0x4c, 0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f, 0x7c, 0x50,
    0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54, 0x7c, 0x55, 0x7c, 0x56,
    0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b, 0x7c, 0x71, 0x7c, 0x76,
    0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a};
const uint16_t HuffDecoderCommon::table18_1_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9,
    0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109,
    0x0111, 0x0119, 0x0121, 0x0129, 0x0131, 0x0139, 0x0141, 0x0149,
    0x0151, 0x0159, 0x0161, 0x0169, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table18_2_emit_[72] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63, 0x23, 0x65,
    0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74, 0x23, 0x20, 0x23, 0x25,
    0x23, 0x2d, 0x23, 0x2e, 0x23, 0x2f, 0x23, 0x33, 0x23, 0x34, 0x23, 0x35,
    0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39, 0x23, 0x3d, 0x23, 0x41,
    0x23, 0x5f, 0x23, 0x62, 0x23, 0x64, 0x23, 0x66, 0x23, 0x67, 0x23, 0x68,
    0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70, 0x23, 0x72, 0x23, 0x75};
const uint16_t HuffDecoderCommon::table18_2_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9,
    0x00b1, 0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9,
    0x00f1, 0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table18_3_emit_[72] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63, 0x3e, 0x65,
    0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20, 0x3e, 0x25,
    0x3e, 0x2d, 0x3e, 0x2e, 0x3e, 0x2f, 0x3e, 0x33, 0x3e, 0x34, 0x3e, 0x35,
    0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39, 0x3e, 0x3d, 0x3e, 0x41,
    0x3e, 0x5f, 0x3e, 0x62, 0x3e, 0x64, 0x3e, 0x66, 0x3e, 0x67, 0x3e, 0x68,
    0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70, 0x3e, 0x72, 0x3e, 0x75};
const uint8_t HuffDecoderCommon::table18_4_emit_[40] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61, 0x00, 0x63,
    0x00, 0x65, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x74,
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61, 0x24, 0x63,
    0x24, 0x65, 0x24, 0x69, 0x24, 0x6f, 0x24, 0x73, 0x24, 0x74};
const uint16_t HuffDecoderCommon::table18_4_ops_[64] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052};
const uint8_t HuffDecoderCommon::table18_5_emit_[40] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61, 0x40, 0x63,
    0x40, 0x65, 0x40, 0x69, 0x40, 0x6f, 0x40, 0x73, 0x40, 0x74,
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61, 0x5b, 0x63,
    0x5b, 0x65, 0x5b, 0x69, 0x5b, 0x6f, 0x5b, 0x73, 0x5b, 0x74};
const uint8_t HuffDecoderCommon::table18_6_emit_[40] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63,
    0x5d, 0x65, 0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74,
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63,
    0x7e, 0x65, 0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74};
const uint16_t HuffDecoderCommon::table18_7_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table18_emit_[8] = {
    table17_0_emit_, table18_1_emit_, table18_2_emit_, table18_3_emit_,
    table18_4_emit_, table18_5_emit_, table18_6_emit_, table17_7_emit_,
};
const uint16_t* const HuffDecoderCommon::table18_ops_[8] = {
    table18_0_ops_, table18_1_ops_, table18_2_ops_, table18_2_ops_,
    table18_4_ops_, table18_4_ops_, table18_4_ops_, table18_7_ops_,
};
const uint8_t HuffDecoderCommon::table19_0_emit_[16] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61,
    0x7c, 0x63, 0x7c, 0x65, 0x7c, 0x69, 0x7c, 0x6f};
const uint16_t HuffDecoderCommon::table19_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0031,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0039};
const uint8_t HuffDecoderCommon::table19_1_emit_[28] = {
    0x7c, 0x73, 0x7c, 0x74, 0x7c, 0x20, 0x7c, 0x25, 0x7c, 0x2d,
    0x7c, 0x2e, 0x7c, 0x2f, 0x7c, 0x33, 0x7c, 0x34, 0x7c, 0x35,
    0x7c, 0x36, 0x7c, 0x37, 0x7c, 0x38, 0x7c, 0x39};
const uint16_t HuffDecoderCommon::table19_1_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069};
const uint8_t HuffDecoderCommon::table19_2_emit_[36] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64, 0x7c, 0x66,
    0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70,
    0x7c, 0x72, 0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44};
const uint16_t HuffDecoderCommon::table19_2_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089};
const uint8_t HuffDecoderCommon::table19_3_emit_[68] = {
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48, 0x7c, 0x49, 0x7c, 0x4a,
    0x7c, 0x4b, 0x7c, 0x4c, 0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f, 0x7c, 0x50,
    0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54, 0x7c, 0x55, 0x7c, 0x56,
    0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b, 0x7c, 0x71, 0x7c, 0x76,
    0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a, 0x7c, 0x26, 0x7c, 0x2a,
    0x7c, 0x2c, 0x7c, 0x3b, 0x7c, 0x58, 0x7c, 0x5a};
const uint16_t HuffDecoderCommon::table19_3_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079,
    0x0000, 0x0081, 0x0000, 0x0089, 0x0000, 0x0091, 0x0000, 0x0099,
    0x0000, 0x00a1, 0x0000, 0x00a9, 0x0000, 0x00b1, 0x0000, 0x00b9,
    0x0000, 0x00c1, 0x0000, 0x00c9, 0x0000, 0x00d1, 0x0000, 0x00d9,
    0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table19_4_emit_[44] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63, 0x23,
    0x65, 0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74, 0x23, 0x20,
    0x23, 0x25, 0x23, 0x2d, 0x23, 0x2e, 0x23, 0x2f, 0x23, 0x33, 0x23,
    0x34, 0x23, 0x35, 0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39};
const uint8_t HuffDecoderCommon::table19_5_emit_[92] = {
    0x23, 0x3d, 0x23, 0x41, 0x23, 0x5f, 0x23, 0x62, 0x23, 0x64, 0x23, 0x66,
    0x23, 0x67, 0x23, 0x68, 0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70,
    0x23, 0x72, 0x23, 0x75, 0x23, 0x3a, 0x23, 0x42, 0x23, 0x43, 0x23, 0x44,
    0x23, 0x45, 0x23, 0x46, 0x23, 0x47, 0x23, 0x48, 0x23, 0x49, 0x23, 0x4a,
    0x23, 0x4b, 0x23, 0x4c, 0x23, 0x4d, 0x23, 0x4e, 0x23, 0x4f, 0x23, 0x50,
    0x23, 0x51, 0x23, 0x52, 0x23, 0x53, 0x23, 0x54, 0x23, 0x55, 0x23, 0x56,
    0x23, 0x57, 0x23, 0x59, 0x23, 0x6a, 0x23, 0x6b, 0x23, 0x71, 0x23, 0x76,
    0x23, 0x77, 0x23, 0x78, 0x23, 0x79, 0x23, 0x7a};
const uint8_t HuffDecoderCommon::table19_6_emit_[44] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63, 0x3e,
    0x65, 0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20,
    0x3e, 0x25, 0x3e, 0x2d, 0x3e, 0x2e, 0x3e, 0x2f, 0x3e, 0x33, 0x3e,
    0x34, 0x3e, 0x35, 0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39};
const uint8_t HuffDecoderCommon::table19_7_emit_[92] = {
    0x3e, 0x3d, 0x3e, 0x41, 0x3e, 0x5f, 0x3e, 0x62, 0x3e, 0x64, 0x3e, 0x66,
    0x3e, 0x67, 0x3e, 0x68, 0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70,
    0x3e, 0x72, 0x3e, 0x75, 0x3e, 0x3a, 0x3e, 0x42, 0x3e, 0x43, 0x3e, 0x44,
    0x3e, 0x45, 0x3e, 0x46, 0x3e, 0x47, 0x3e, 0x48, 0x3e, 0x49, 0x3e, 0x4a,
    0x3e, 0x4b, 0x3e, 0x4c, 0x3e, 0x4d, 0x3e, 0x4e, 0x3e, 0x4f, 0x3e, 0x50,
    0x3e, 0x51, 0x3e, 0x52, 0x3e, 0x53, 0x3e, 0x54, 0x3e, 0x55, 0x3e, 0x56,
    0x3e, 0x57, 0x3e, 0x59, 0x3e, 0x6a, 0x3e, 0x6b, 0x3e, 0x71, 0x3e, 0x76,
    0x3e, 0x77, 0x3e, 0x78, 0x3e, 0x79, 0x3e, 0x7a};
const uint8_t HuffDecoderCommon::table19_8_emit_[72] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61, 0x00, 0x63, 0x00, 0x65,
    0x00, 0x69, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x74, 0x00, 0x20, 0x00, 0x25,
    0x00, 0x2d, 0x00, 0x2e, 0x00, 0x2f, 0x00, 0x33, 0x00, 0x34, 0x00, 0x35,
    0x00, 0x36, 0x00, 0x37, 0x00, 0x38, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41,
    0x00, 0x5f, 0x00, 0x62, 0x00, 0x64, 0x00, 0x66, 0x00, 0x67, 0x00, 0x68,
    0x00, 0x6c, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x70, 0x00, 0x72, 0x00, 0x75};
const uint8_t HuffDecoderCommon::table19_9_emit_[72] = {
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61, 0x24, 0x63, 0x24, 0x65,
    0x24, 0x69, 0x24, 0x6f, 0x24, 0x73, 0x24, 0x74, 0x24, 0x20, 0x24, 0x25,
    0x24, 0x2d, 0x24, 0x2e, 0x24, 0x2f, 0x24, 0x33, 0x24, 0x34, 0x24, 0x35,
    0x24, 0x36, 0x24, 0x37, 0x24, 0x38, 0x24, 0x39, 0x24, 0x3d, 0x24, 0x41,
    0x24, 0x5f, 0x24, 0x62, 0x24, 0x64, 0x24, 0x66, 0x24, 0x67, 0x24, 0x68,
    0x24, 0x6c, 0x24, 0x6d, 0x24, 0x6e, 0x24, 0x70, 0x24, 0x72, 0x24, 0x75};
const uint8_t HuffDecoderCommon::table19_10_emit_[72] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61, 0x40, 0x63, 0x40, 0x65,
    0x40, 0x69, 0x40, 0x6f, 0x40, 0x73, 0x40, 0x74, 0x40, 0x20, 0x40, 0x25,
    0x40, 0x2d, 0x40, 0x2e, 0x40, 0x2f, 0x40, 0x33, 0x40, 0x34, 0x40, 0x35,
    0x40, 0x36, 0x40, 0x37, 0x40, 0x38, 0x40, 0x39, 0x40, 0x3d, 0x40, 0x41,
    0x40, 0x5f, 0x40, 0x62, 0x40, 0x64, 0x40, 0x66, 0x40, 0x67, 0x40, 0x68,
    0x40, 0x6c, 0x40, 0x6d, 0x40, 0x6e, 0x40, 0x70, 0x40, 0x72, 0x40, 0x75};
const uint8_t HuffDecoderCommon::table19_11_emit_[72] = {
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61, 0x5b, 0x63, 0x5b, 0x65,
    0x5b, 0x69, 0x5b, 0x6f, 0x5b, 0x73, 0x5b, 0x74, 0x5b, 0x20, 0x5b, 0x25,
    0x5b, 0x2d, 0x5b, 0x2e, 0x5b, 0x2f, 0x5b, 0x33, 0x5b, 0x34, 0x5b, 0x35,
    0x5b, 0x36, 0x5b, 0x37, 0x5b, 0x38, 0x5b, 0x39, 0x5b, 0x3d, 0x5b, 0x41,
    0x5b, 0x5f, 0x5b, 0x62, 0x5b, 0x64, 0x5b, 0x66, 0x5b, 0x67, 0x5b, 0x68,
    0x5b, 0x6c, 0x5b, 0x6d, 0x5b, 0x6e, 0x5b, 0x70, 0x5b, 0x72, 0x5b, 0x75};
const uint8_t HuffDecoderCommon::table19_12_emit_[72] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63, 0x5d, 0x65,
    0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74, 0x5d, 0x20, 0x5d, 0x25,
    0x5d, 0x2d, 0x5d, 0x2e, 0x5d, 0x2f, 0x5d, 0x33, 0x5d, 0x34, 0x5d, 0x35,
    0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39, 0x5d, 0x3d, 0x5d, 0x41,
    0x5d, 0x5f, 0x5d, 0x62, 0x5d, 0x64, 0x5d, 0x66, 0x5d, 0x67, 0x5d, 0x68,
    0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70, 0x5d, 0x72, 0x5d, 0x75};
const uint8_t HuffDecoderCommon::table19_13_emit_[72] = {
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63, 0x7e, 0x65,
    0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74, 0x7e, 0x20, 0x7e, 0x25,
    0x7e, 0x2d, 0x7e, 0x2e, 0x7e, 0x2f, 0x7e, 0x33, 0x7e, 0x34, 0x7e, 0x35,
    0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39, 0x7e, 0x3d, 0x7e, 0x41,
    0x7e, 0x5f, 0x7e, 0x62, 0x7e, 0x64, 0x7e, 0x66, 0x7e, 0x67, 0x7e, 0x68,
    0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70, 0x7e, 0x72, 0x7e, 0x75};
const uint8_t HuffDecoderCommon::table19_14_emit_[40] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61, 0x5e, 0x63,
    0x5e, 0x65, 0x5e, 0x69, 0x5e, 0x6f, 0x5e, 0x73, 0x5e, 0x74,
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61, 0x7d, 0x63,
    0x7d, 0x65, 0x7d, 0x69, 0x7d, 0x6f, 0x7d, 0x73, 0x7d, 0x74};
const uint8_t HuffDecoderCommon::table19_15_emit_[6] = {0x3c, 0x60, 0x7b,
                                                        0x5c, 0xc3, 0xd0};
const uint16_t HuffDecoderCommon::table19_15_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x000e, 0x0012, 0x0016, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table19_emit_[16] = {
    table19_0_emit_,  table19_1_emit_,  table19_2_emit_,  table19_3_emit_,
    table19_4_emit_,  table19_5_emit_,  table19_6_emit_,  table19_7_emit_,
    table19_8_emit_,  table19_9_emit_,  table19_10_emit_, table19_11_emit_,
    table19_12_emit_, table19_13_emit_, table19_14_emit_, table19_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table19_ops_[16] = {
    table19_0_ops_, table19_1_ops_, table19_2_ops_, table19_3_ops_,
    table18_0_ops_, table18_1_ops_, table18_0_ops_, table18_1_ops_,
    table18_2_ops_, table18_2_ops_, table18_2_ops_, table18_2_ops_,
    table18_2_ops_, table18_2_ops_, table18_4_ops_, table19_15_ops_,
};
const uint8_t HuffDecoderCommon::table20_0_emit_[8] = {0x7c, 0x30, 0x7c, 0x31,
                                                       0x7c, 0x32, 0x7c, 0x61};
const uint16_t HuffDecoderCommon::table20_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019};
const uint8_t HuffDecoderCommon::table20_1_emit_[8] = {0x7c, 0x63, 0x7c, 0x65,
                                                       0x7c, 0x69, 0x7c, 0x6f};
const uint8_t HuffDecoderCommon::table20_2_emit_[12] = {
    0x7c, 0x73, 0x7c, 0x74, 0x7c, 0x20, 0x7c, 0x25, 0x7c, 0x2d, 0x7c, 0x2e};
const uint16_t HuffDecoderCommon::table20_2_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029};
const uint8_t HuffDecoderCommon::table20_3_emit_[16] = {
    0x7c, 0x2f, 0x7c, 0x33, 0x7c, 0x34, 0x7c, 0x35,
    0x7c, 0x36, 0x7c, 0x37, 0x7c, 0x38, 0x7c, 0x39};
const uint8_t HuffDecoderCommon::table20_4_emit_[16] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62,
    0x7c, 0x64, 0x7c, 0x66, 0x7c, 0x67, 0x7c, 0x68};
const uint8_t HuffDecoderCommon::table20_5_emit_[20] = {
    0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70, 0x7c, 0x72,
    0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44};
const uint16_t HuffDecoderCommon::table20_5_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049};
const uint8_t HuffDecoderCommon::table20_6_emit_[32] = {
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48, 0x7c, 0x49, 0x7c,
    0x4a, 0x7c, 0x4b, 0x7c, 0x4c, 0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f,
    0x7c, 0x50, 0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54};
const uint16_t HuffDecoderCommon::table20_6_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069,
    0x0000, 0x0000, 0x0000, 0x0071, 0x0000, 0x0000, 0x0000, 0x0079};
const uint8_t HuffDecoderCommon::table20_7_emit_[36] = {
    0x7c, 0x55, 0x7c, 0x56, 0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b,
    0x7c, 0x71, 0x7c, 0x76, 0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a,
    0x7c, 0x26, 0x7c, 0x2a, 0x7c, 0x2c, 0x7c, 0x3b, 0x7c, 0x58, 0x7c, 0x5a};
const uint16_t HuffDecoderCommon::table20_7_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079,
    0x0000, 0x0081, 0x0000, 0x0089, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table20_8_emit_[16] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61,
    0x23, 0x63, 0x23, 0x65, 0x23, 0x69, 0x23, 0x6f};
const uint8_t HuffDecoderCommon::table20_9_emit_[28] = {
    0x23, 0x73, 0x23, 0x74, 0x23, 0x20, 0x23, 0x25, 0x23, 0x2d,
    0x23, 0x2e, 0x23, 0x2f, 0x23, 0x33, 0x23, 0x34, 0x23, 0x35,
    0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39};
const uint8_t HuffDecoderCommon::table20_10_emit_[36] = {
    0x23, 0x3d, 0x23, 0x41, 0x23, 0x5f, 0x23, 0x62, 0x23, 0x64, 0x23, 0x66,
    0x23, 0x67, 0x23, 0x68, 0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70,
    0x23, 0x72, 0x23, 0x75, 0x23, 0x3a, 0x23, 0x42, 0x23, 0x43, 0x23, 0x44};
const uint8_t HuffDecoderCommon::table20_11_emit_[68] = {
    0x23, 0x45, 0x23, 0x46, 0x23, 0x47, 0x23, 0x48, 0x23, 0x49, 0x23, 0x4a,
    0x23, 0x4b, 0x23, 0x4c, 0x23, 0x4d, 0x23, 0x4e, 0x23, 0x4f, 0x23, 0x50,
    0x23, 0x51, 0x23, 0x52, 0x23, 0x53, 0x23, 0x54, 0x23, 0x55, 0x23, 0x56,
    0x23, 0x57, 0x23, 0x59, 0x23, 0x6a, 0x23, 0x6b, 0x23, 0x71, 0x23, 0x76,
    0x23, 0x77, 0x23, 0x78, 0x23, 0x79, 0x23, 0x7a, 0x23, 0x26, 0x23, 0x2a,
    0x23, 0x2c, 0x23, 0x3b, 0x23, 0x58, 0x23, 0x5a};
const uint8_t HuffDecoderCommon::table20_12_emit_[16] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61,
    0x3e, 0x63, 0x3e, 0x65, 0x3e, 0x69, 0x3e, 0x6f};
const uint8_t HuffDecoderCommon::table20_13_emit_[28] = {
    0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20, 0x3e, 0x25, 0x3e, 0x2d,
    0x3e, 0x2e, 0x3e, 0x2f, 0x3e, 0x33, 0x3e, 0x34, 0x3e, 0x35,
    0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39};
const uint8_t HuffDecoderCommon::table20_14_emit_[36] = {
    0x3e, 0x3d, 0x3e, 0x41, 0x3e, 0x5f, 0x3e, 0x62, 0x3e, 0x64, 0x3e, 0x66,
    0x3e, 0x67, 0x3e, 0x68, 0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70,
    0x3e, 0x72, 0x3e, 0x75, 0x3e, 0x3a, 0x3e, 0x42, 0x3e, 0x43, 0x3e, 0x44};
const uint8_t HuffDecoderCommon::table20_15_emit_[68] = {
    0x3e, 0x45, 0x3e, 0x46, 0x3e, 0x47, 0x3e, 0x48, 0x3e, 0x49, 0x3e, 0x4a,
    0x3e, 0x4b, 0x3e, 0x4c, 0x3e, 0x4d, 0x3e, 0x4e, 0x3e, 0x4f, 0x3e, 0x50,
    0x3e, 0x51, 0x3e, 0x52, 0x3e, 0x53, 0x3e, 0x54, 0x3e, 0x55, 0x3e, 0x56,
    0x3e, 0x57, 0x3e, 0x59, 0x3e, 0x6a, 0x3e, 0x6b, 0x3e, 0x71, 0x3e, 0x76,
    0x3e, 0x77, 0x3e, 0x78, 0x3e, 0x79, 0x3e, 0x7a, 0x3e, 0x26, 0x3e, 0x2a,
    0x3e, 0x2c, 0x3e, 0x3b, 0x3e, 0x58, 0x3e, 0x5a};
const uint8_t HuffDecoderCommon::table20_16_emit_[44] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61, 0x00, 0x63, 0x00,
    0x65, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x74, 0x00, 0x20,
    0x00, 0x25, 0x00, 0x2d, 0x00, 0x2e, 0x00, 0x2f, 0x00, 0x33, 0x00,
    0x34, 0x00, 0x35, 0x00, 0x36, 0x00, 0x37, 0x00, 0x38, 0x00, 0x39};
const uint8_t HuffDecoderCommon::table20_17_emit_[92] = {
    0x00, 0x3d, 0x00, 0x41, 0x00, 0x5f, 0x00, 0x62, 0x00, 0x64, 0x00, 0x66,
    0x00, 0x67, 0x00, 0x68, 0x00, 0x6c, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x70,
    0x00, 0x72, 0x00, 0x75, 0x00, 0x3a, 0x00, 0x42, 0x00, 0x43, 0x00, 0x44,
    0x00, 0x45, 0x00, 0x46, 0x00, 0x47, 0x00, 0x48, 0x00, 0x49, 0x00, 0x4a,
    0x00, 0x4b, 0x00, 0x4c, 0x00, 0x4d, 0x00, 0x4e, 0x00, 0x4f, 0x00, 0x50,
    0x00, 0x51, 0x00, 0x52, 0x00, 0x53, 0x00, 0x54, 0x00, 0x55, 0x00, 0x56,
    0x00, 0x57, 0x00, 0x59, 0x00, 0x6a, 0x00, 0x6b, 0x00, 0x71, 0x00, 0x76,
    0x00, 0x77, 0x00, 0x78, 0x00, 0x79, 0x00, 0x7a};
const uint8_t HuffDecoderCommon::table20_18_emit_[44] = {
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61, 0x24, 0x63, 0x24,
    0x65, 0x24, 0x69, 0x24, 0x6f, 0x24, 0x73, 0x24, 0x74, 0x24, 0x20,
    0x24, 0x25, 0x24, 0x2d, 0x24, 0x2e, 0x24, 0x2f, 0x24, 0x33, 0x24,
    0x34, 0x24, 0x35, 0x24, 0x36, 0x24, 0x37, 0x24, 0x38, 0x24, 0x39};
const uint8_t HuffDecoderCommon::table20_19_emit_[92] = {
    0x24, 0x3d, 0x24, 0x41, 0x24, 0x5f, 0x24, 0x62, 0x24, 0x64, 0x24, 0x66,
    0x24, 0x67, 0x24, 0x68, 0x24, 0x6c, 0x24, 0x6d, 0x24, 0x6e, 0x24, 0x70,
    0x24, 0x72, 0x24, 0x75, 0x24, 0x3a, 0x24, 0x42, 0x24, 0x43, 0x24, 0x44,
    0x24, 0x45, 0x24, 0x46, 0x24, 0x47, 0x24, 0x48, 0x24, 0x49, 0x24, 0x4a,
    0x24, 0x4b, 0x24, 0x4c, 0x24, 0x4d, 0x24, 0x4e, 0x24, 0x4f, 0x24, 0x50,
    0x24, 0x51, 0x24, 0x52, 0x24, 0x53, 0x24, 0x54, 0x24, 0x55, 0x24, 0x56,
    0x24, 0x57, 0x24, 0x59, 0x24, 0x6a, 0x24, 0x6b, 0x24, 0x71, 0x24, 0x76,
    0x24, 0x77, 0x24, 0x78, 0x24, 0x79, 0x24, 0x7a};
const uint8_t HuffDecoderCommon::table20_20_emit_[44] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61, 0x40, 0x63, 0x40,
    0x65, 0x40, 0x69, 0x40, 0x6f, 0x40, 0x73, 0x40, 0x74, 0x40, 0x20,
    0x40, 0x25, 0x40, 0x2d, 0x40, 0x2e, 0x40, 0x2f, 0x40, 0x33, 0x40,
    0x34, 0x40, 0x35, 0x40, 0x36, 0x40, 0x37, 0x40, 0x38, 0x40, 0x39};
const uint8_t HuffDecoderCommon::table20_21_emit_[92] = {
    0x40, 0x3d, 0x40, 0x41, 0x40, 0x5f, 0x40, 0x62, 0x40, 0x64, 0x40, 0x66,
    0x40, 0x67, 0x40, 0x68, 0x40, 0x6c, 0x40, 0x6d, 0x40, 0x6e, 0x40, 0x70,
    0x40, 0x72, 0x40, 0x75, 0x40, 0x3a, 0x40, 0x42, 0x40, 0x43, 0x40, 0x44,
    0x40, 0x45, 0x40, 0x46, 0x40, 0x47, 0x40, 0x48, 0x40, 0x49, 0x40, 0x4a,
    0x40, 0x4b, 0x40, 0x4c, 0x40, 0x4d, 0x40, 0x4e, 0x40, 0x4f, 0x40, 0x50,
    0x40, 0x51, 0x40, 0x52, 0x40, 0x53, 0x40, 0x54, 0x40, 0x55, 0x40, 0x56,
    0x40, 0x57, 0x40, 0x59, 0x40, 0x6a, 0x40, 0x6b, 0x40, 0x71, 0x40, 0x76,
    0x40, 0x77, 0x40, 0x78, 0x40, 0x79, 0x40, 0x7a};
const uint8_t HuffDecoderCommon::table20_22_emit_[44] = {
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61, 0x5b, 0x63, 0x5b,
    0x65, 0x5b, 0x69, 0x5b, 0x6f, 0x5b, 0x73, 0x5b, 0x74, 0x5b, 0x20,
    0x5b, 0x25, 0x5b, 0x2d, 0x5b, 0x2e, 0x5b, 0x2f, 0x5b, 0x33, 0x5b,
    0x34, 0x5b, 0x35, 0x5b, 0x36, 0x5b, 0x37, 0x5b, 0x38, 0x5b, 0x39};
const uint8_t HuffDecoderCommon::table20_23_emit_[92] = {
    0x5b, 0x3d, 0x5b, 0x41, 0x5b, 0x5f, 0x5b, 0x62, 0x5b, 0x64, 0x5b, 0x66,
    0x5b, 0x67, 0x5b, 0x68, 0x5b, 0x6c, 0x5b, 0x6d, 0x5b, 0x6e, 0x5b, 0x70,
    0x5b, 0x72, 0x5b, 0x75, 0x5b, 0x3a, 0x5b, 0x42, 0x5b, 0x43, 0x5b, 0x44,
    0x5b, 0x45, 0x5b, 0x46, 0x5b, 0x47, 0x5b, 0x48, 0x5b, 0x49, 0x5b, 0x4a,
    0x5b, 0x4b, 0x5b, 0x4c, 0x5b, 0x4d, 0x5b, 0x4e, 0x5b, 0x4f, 0x5b, 0x50,
    0x5b, 0x51, 0x5b, 0x52, 0x5b, 0x53, 0x5b, 0x54, 0x5b, 0x55, 0x5b, 0x56,
    0x5b, 0x57, 0x5b, 0x59, 0x5b, 0x6a, 0x5b, 0x6b, 0x5b, 0x71, 0x5b, 0x76,
    0x5b, 0x77, 0x5b, 0x78, 0x5b, 0x79, 0x5b, 0x7a};
const uint8_t HuffDecoderCommon::table20_24_emit_[44] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63, 0x5d,
    0x65, 0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74, 0x5d, 0x20,
    0x5d, 0x25, 0x5d, 0x2d, 0x5d, 0x2e, 0x5d, 0x2f, 0x5d, 0x33, 0x5d,
    0x34, 0x5d, 0x35, 0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39};
const uint8_t HuffDecoderCommon::table20_25_emit_[92] = {
    0x5d, 0x3d, 0x5d, 0x41, 0x5d, 0x5f, 0x5d, 0x62, 0x5d, 0x64, 0x5d, 0x66,
    0x5d, 0x67, 0x5d, 0x68, 0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70,
    0x5d, 0x72, 0x5d, 0x75, 0x5d, 0x3a, 0x5d, 0x42, 0x5d, 0x43, 0x5d, 0x44,
    0x5d, 0x45, 0x5d, 0x46, 0x5d, 0x47, 0x5d, 0x48, 0x5d, 0x49, 0x5d, 0x4a,
    0x5d, 0x4b, 0x5d, 0x4c, 0x5d, 0x4d, 0x5d, 0x4e, 0x5d, 0x4f, 0x5d, 0x50,
    0x5d, 0x51, 0x5d, 0x52, 0x5d, 0x53, 0x5d, 0x54, 0x5d, 0x55, 0x5d, 0x56,
    0x5d, 0x57, 0x5d, 0x59, 0x5d, 0x6a, 0x5d, 0x6b, 0x5d, 0x71, 0x5d, 0x76,
    0x5d, 0x77, 0x5d, 0x78, 0x5d, 0x79, 0x5d, 0x7a};
const uint8_t HuffDecoderCommon::table20_26_emit_[44] = {
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63, 0x7e,
    0x65, 0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74, 0x7e, 0x20,
    0x7e, 0x25, 0x7e, 0x2d, 0x7e, 0x2e, 0x7e, 0x2f, 0x7e, 0x33, 0x7e,
    0x34, 0x7e, 0x35, 0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39};
const uint8_t HuffDecoderCommon::table20_27_emit_[92] = {
    0x7e, 0x3d, 0x7e, 0x41, 0x7e, 0x5f, 0x7e, 0x62, 0x7e, 0x64, 0x7e, 0x66,
    0x7e, 0x67, 0x7e, 0x68, 0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70,
    0x7e, 0x72, 0x7e, 0x75, 0x7e, 0x3a, 0x7e, 0x42, 0x7e, 0x43, 0x7e, 0x44,
    0x7e, 0x45, 0x7e, 0x46, 0x7e, 0x47, 0x7e, 0x48, 0x7e, 0x49, 0x7e, 0x4a,
    0x7e, 0x4b, 0x7e, 0x4c, 0x7e, 0x4d, 0x7e, 0x4e, 0x7e, 0x4f, 0x7e, 0x50,
    0x7e, 0x51, 0x7e, 0x52, 0x7e, 0x53, 0x7e, 0x54, 0x7e, 0x55, 0x7e, 0x56,
    0x7e, 0x57, 0x7e, 0x59, 0x7e, 0x6a, 0x7e, 0x6b, 0x7e, 0x71, 0x7e, 0x76,
    0x7e, 0x77, 0x7e, 0x78, 0x7e, 0x79, 0x7e, 0x7a};
const uint8_t HuffDecoderCommon::table20_28_emit_[72] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61, 0x5e, 0x63, 0x5e, 0x65,
    0x5e, 0x69, 0x5e, 0x6f, 0x5e, 0x73, 0x5e, 0x74, 0x5e, 0x20, 0x5e, 0x25,
    0x5e, 0x2d, 0x5e, 0x2e, 0x5e, 0x2f, 0x5e, 0x33, 0x5e, 0x34, 0x5e, 0x35,
    0x5e, 0x36, 0x5e, 0x37, 0x5e, 0x38, 0x5e, 0x39, 0x5e, 0x3d, 0x5e, 0x41,
    0x5e, 0x5f, 0x5e, 0x62, 0x5e, 0x64, 0x5e, 0x66, 0x5e, 0x67, 0x5e, 0x68,
    0x5e, 0x6c, 0x5e, 0x6d, 0x5e, 0x6e, 0x5e, 0x70, 0x5e, 0x72, 0x5e, 0x75};
const uint8_t HuffDecoderCommon::table20_29_emit_[72] = {
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61, 0x7d, 0x63, 0x7d, 0x65,
    0x7d, 0x69, 0x7d, 0x6f, 0x7d, 0x73, 0x7d, 0x74, 0x7d, 0x20, 0x7d, 0x25,
    0x7d, 0x2d, 0x7d, 0x2e, 0x7d, 0x2f, 0x7d, 0x33, 0x7d, 0x34, 0x7d, 0x35,
    0x7d, 0x36, 0x7d, 0x37, 0x7d, 0x38, 0x7d, 0x39, 0x7d, 0x3d, 0x7d, 0x41,
    0x7d, 0x5f, 0x7d, 0x62, 0x7d, 0x64, 0x7d, 0x66, 0x7d, 0x67, 0x7d, 0x68,
    0x7d, 0x6c, 0x7d, 0x6d, 0x7d, 0x6e, 0x7d, 0x70, 0x7d, 0x72, 0x7d, 0x75};
const uint8_t HuffDecoderCommon::table20_30_emit_[40] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63,
    0x3c, 0x65, 0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74,
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63,
    0x60, 0x65, 0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74};
const uint8_t HuffDecoderCommon::table20_31_emit_[31] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b,
    0x65, 0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x5c, 0xc3,
    0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2};
const uint16_t HuffDecoderCommon::table20_31_ops_[64] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0052, 0x0000, 0x0056, 0x0000, 0x005a, 0x005e, 0x0062,
    0x0066, 0x006a, 0x006e, 0x0072, 0x0076, 0x007a, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table20_emit_[32] = {
    table20_0_emit_,  table20_1_emit_,  table20_2_emit_,  table20_3_emit_,
    table20_4_emit_,  table20_5_emit_,  table20_6_emit_,  table20_7_emit_,
    table20_8_emit_,  table20_9_emit_,  table20_10_emit_, table20_11_emit_,
    table20_12_emit_, table20_13_emit_, table20_14_emit_, table20_15_emit_,
    table20_16_emit_, table20_17_emit_, table20_18_emit_, table20_19_emit_,
    table20_20_emit_, table20_21_emit_, table20_22_emit_, table20_23_emit_,
    table20_24_emit_, table20_25_emit_, table20_26_emit_, table20_27_emit_,
    table20_28_emit_, table20_29_emit_, table20_30_emit_, table20_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table20_ops_[32] = {
    table20_0_ops_, table20_0_ops_, table20_2_ops_, table19_0_ops_,
    table19_0_ops_, table20_5_ops_, table20_6_ops_, table20_7_ops_,
    table19_0_ops_, table19_1_ops_, table19_2_ops_, table19_3_ops_,
    table19_0_ops_, table19_1_ops_, table19_2_ops_, table19_3_ops_,
    table18_0_ops_, table18_1_ops_, table18_0_ops_, table18_1_ops_,
    table18_0_ops_, table18_1_ops_, table18_0_ops_, table18_1_ops_,
    table18_0_ops_, table18_1_ops_, table18_0_ops_, table18_1_ops_,
    table18_2_ops_, table18_2_ops_, table18_4_ops_, table20_31_ops_,
};
const uint8_t HuffDecoderCommon::table10_0_emit_[1] = {0x7c};
const uint16_t HuffDecoderCommon::table10_0_ops_[128] = {
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002};
const uint8_t HuffDecoderCommon::table10_8_emit_[1] = {0x23};
const uint16_t HuffDecoderCommon::table10_8_ops_[128] = {
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003};
const uint8_t HuffDecoderCommon::table10_12_emit_[1] = {0x3e};
const uint8_t HuffDecoderCommon::table10_16_emit_[1] = {0x00};
const uint16_t HuffDecoderCommon::table10_16_ops_[128] = {
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004};
const uint8_t HuffDecoderCommon::table10_18_emit_[1] = {0x24};
const uint8_t HuffDecoderCommon::table10_20_emit_[1] = {0x40};
const uint8_t HuffDecoderCommon::table10_22_emit_[1] = {0x5b};
const uint8_t HuffDecoderCommon::table10_24_emit_[1] = {0x5d};
const uint8_t HuffDecoderCommon::table10_26_emit_[1] = {0x7e};
const uint8_t HuffDecoderCommon::table10_28_emit_[1] = {0x5e};
const uint16_t HuffDecoderCommon::table10_28_ops_[128] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005};
const uint8_t HuffDecoderCommon::table10_29_emit_[1] = {0x7d};
const uint8_t HuffDecoderCommon::table10_30_emit_[2] = {0x3c, 0x60};
const uint16_t HuffDecoderCommon::table10_30_ops_[128] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206};
const uint8_t HuffDecoderCommon::table10_31_emit_[25] = {
    0x7b, 0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8,
    0xc2, 0xe0, 0xe2, 0x99, 0xa1, 0xa7, 0xac, 0xb0, 0xb1,
    0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6};
const uint16_t HuffDecoderCommon::table10_31_ops_[128] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x020a, 0x020a, 0x020a, 0x020a, 0x040a, 0x040a, 0x040a, 0x040a,
    0x060a, 0x060a, 0x060a, 0x060a, 0x080b, 0x080b, 0x0a0b, 0x0a0b, 0x0c0b,
    0x0c0b, 0x0e0b, 0x0e0b, 0x100b, 0x100b, 0x120b, 0x120b, 0x140b, 0x140b,
    0x160b, 0x160b, 0x180c, 0x1a0c, 0x1c0c, 0x1e0c, 0x200c, 0x220c, 0x240c,
    0x260c, 0x280c, 0x2a0c, 0x2c0c, 0x2e0c, 0x300c, 0x001c, 0x002c, 0x003c,
    0x004c, 0x005c, 0x006c, 0x007c, 0x008c, 0x009c, 0x00ac, 0x00bc, 0x00cc,
    0x00dc, 0x00ec, 0x00fc, 0x010c, 0x011c, 0x012c, 0x013c, 0x014c, 0x015c,
    0x016c, 0x017c};
const uint8_t* const HuffDecoderCommon::table10_emit_[32] = {
    table10_0_emit_,  table10_0_emit_,  table10_0_emit_,  table10_0_emit_,
    table10_0_emit_,  table10_0_emit_,  table10_0_emit_,  table10_0_emit_,
    table10_8_emit_,  table10_8_emit_,  table10_8_emit_,  table10_8_emit_,
    table10_12_emit_, table10_12_emit_, table10_12_emit_, table10_12_emit_,
    table10_16_emit_, table10_16_emit_, table10_18_emit_, table10_18_emit_,
    table10_20_emit_, table10_20_emit_, table10_22_emit_, table10_22_emit_,
    table10_24_emit_, table10_24_emit_, table10_26_emit_, table10_26_emit_,
    table10_28_emit_, table10_29_emit_, table10_30_emit_, table10_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table10_ops_[32] = {
    table10_0_ops_,  table10_0_ops_,  table10_0_ops_,  table10_0_ops_,
    table10_0_ops_,  table10_0_ops_,  table10_0_ops_,  table10_0_ops_,
    table10_8_ops_,  table10_8_ops_,  table10_8_ops_,  table10_8_ops_,
    table10_8_ops_,  table10_8_ops_,  table10_8_ops_,  table10_8_ops_,
    table10_16_ops_, table10_16_ops_, table10_16_ops_, table10_16_ops_,
    table10_16_ops_, table10_16_ops_, table10_16_ops_, table10_16_ops_,
    table10_16_ops_, table10_16_ops_, table10_16_ops_, table10_16_ops_,
    table10_28_ops_, table10_28_ops_, table10_30_ops_, table10_31_ops_,
};
const uint8_t HuffDecoderCommon::table42_0_emit_[6] = {0xab, 0xce, 0xd7,
                                                       0xe1, 0xec, 0xed};
const uint8_t HuffDecoderCommon::table42_0_inner_[7] = {0x00, 0x02, 0x04, 0x06,
                                                        0x08, 0x0a, 0x01};
const uint8_t HuffDecoderCommon::table41_0_emit_[10] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb};
const uint8_t HuffDecoderCommon::table41_0_inner_[10] = {
    0x03, 0x0b, 0x13, 0x1b, 0x23, 0x2b, 0x34, 0x3c, 0x44, 0x4c};
const uint8_t HuffDecoderCommon::table43_0_emit_[7] = {0xef, 0x09, 0x8e, 0x90,
                                                       0x91, 0x94, 0x9f};
const uint8_t HuffDecoderCommon::table43_0_inner_[7] = {0x02, 0x07, 0x0b, 0x0f,
                                                        0x13, 0x17, 0x1b};
const uint8_t HuffDecoderCommon::table46_0_emit_[15] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5,
    0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff};
const uint8_t HuffDecoderCommon::table46_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x28,
    0x2c, 0x30, 0x34, 0x38, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table47_0_emit_[34] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee, 0xf0,
    0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1,
    0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe};
const uint8_t HuffDecoderCommon::table47_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x3d, 0x41, 0x45,
    0x49, 0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71,
    0x75, 0x79, 0x7d, 0x81, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table48_0_emit_[63] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee,
    0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde,
    0xdf, 0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd,
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0b, 0x0c, 0x0e,
    0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a,
    0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint8_t HuffDecoderCommon::table48_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x39,
    0x00, 0x3d, 0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51,
    0x00, 0x55, 0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69,
    0x00, 0x6d, 0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81,
    0x00, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1, 0xa5, 0xa9, 0xad,
    0xb1, 0xb5, 0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0xd1, 0xd5, 0xd9, 0xdd,
    0xe1, 0xe5, 0xe9, 0xed, 0xf1, 0xf5, 0xf9, 0x02};
const uint8_t HuffDecoderCommon::table49_0_ops_[256] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39,
    0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x45,
    0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x51,
    0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x59, 0x00, 0x00, 0x00, 0x5d,
    0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x00, 0x69,
    0x00, 0x00, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x71, 0x00, 0x00, 0x00, 0x75,
    0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0x7d, 0x00, 0x00, 0x00, 0x81,
    0x00, 0x00, 0x00, 0x85, 0x00, 0x89, 0x00, 0x8d, 0x00, 0x91, 0x00, 0x95,
    0x00, 0x99, 0x00, 0x9d, 0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa9, 0x00, 0xad,
    0x00, 0xb1, 0x00, 0xb5, 0x00, 0xb9, 0x00, 0xbd, 0x00, 0xc1, 0x00, 0xc5,
    0x00, 0xc9, 0x00, 0xcd, 0x00, 0xd1, 0x00, 0xd5, 0x00, 0xd9, 0x00, 0xdd,
    0x00, 0xe1, 0x00, 0xe5, 0x00, 0xe9, 0x00, 0xed, 0x00, 0xf1, 0x00, 0xf5,
    0x00, 0xf9, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table45_0_emit_[2] = {0xc0, 0xc1};
const uint16_t HuffDecoderCommon::table45_0_ops_[32] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025,
    0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025};
const uint8_t HuffDecoderCommon::table45_1_emit_[2] = {0xc8, 0xc9};
const uint8_t HuffDecoderCommon::table45_2_emit_[2] = {0xca, 0xcd};
const uint8_t HuffDecoderCommon::table45_3_emit_[2] = {0xd2, 0xd5};
const uint8_t HuffDecoderCommon::table45_4_emit_[2] = {0xda, 0xdb};
const uint8_t HuffDecoderCommon::table45_5_emit_[2] = {0xee, 0xf0};
const uint8_t HuffDecoderCommon::table45_6_emit_[2] = {0xf2, 0xf3};
const uint8_t HuffDecoderCommon::table45_7_emit_[3] = {0xff, 0xcb, 0xcc};
const uint16_t HuffDecoderCommon::table45_7_ops_[32] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046};
const uint8_t HuffDecoderCommon::table45_8_emit_[4] = {0xd3, 0xd4, 0xd6, 0xdd};
const uint16_t HuffDecoderCommon::table45_8_ops_[32] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
    0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066};
const uint8_t HuffDecoderCommon::table45_9_emit_[4] = {0xde, 0xdf, 0xf1, 0xf4};
const uint8_t HuffDecoderCommon::table45_10_emit_[4] = {0xf5, 0xf6, 0xf7, 0xf8};
const uint8_t HuffDecoderCommon::table45_11_emit_[4] = {0xfa, 0xfb, 0xfc, 0xfd};
const uint8_t HuffDecoderCommon::table45_12_emit_[7] = {0xfe, 0x02, 0x03, 0x04,
                                                        0x05, 0x06, 0x07};
const uint16_t HuffDecoderCommon::table45_12_ops_[32] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0047, 0x0047, 0x0047, 0x0047,
    0x0067, 0x0067, 0x0067, 0x0067, 0x0087, 0x0087, 0x0087, 0x0087,
    0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00c7, 0x00c7, 0x00c7, 0x00c7};
const uint8_t HuffDecoderCommon::table45_13_emit_[8] = {0x08, 0x0b, 0x0c, 0x0e,
                                                        0x0f, 0x10, 0x11, 0x12};
const uint16_t HuffDecoderCommon::table45_13_ops_[32] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0047, 0x0047, 0x0047, 0x0047, 0x0067, 0x0067, 0x0067, 0x0067,
    0x0087, 0x0087, 0x0087, 0x0087, 0x00a7, 0x00a7, 0x00a7, 0x00a7,
    0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00e7, 0x00e7, 0x00e7, 0x00e7};
const uint8_t HuffDecoderCommon::table45_14_emit_[8] = {0x13, 0x14, 0x15, 0x17,
                                                        0x18, 0x19, 0x1a, 0x1b};
const uint8_t HuffDecoderCommon::table45_15_emit_[10] = {
    0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9, 0x0a, 0x0d, 0x16};
const uint16_t HuffDecoderCommon::table45_15_ops_[32] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0047, 0x0047, 0x0047, 0x0047, 0x0067, 0x0067, 0x0067, 0x0067,
    0x0087, 0x0087, 0x0087, 0x0087, 0x00a7, 0x00a7, 0x00a7, 0x00a7,
    0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00e9, 0x0109, 0x0129, 0x0019};
const uint8_t* const HuffDecoderCommon::table45_emit_[16] = {
    table45_0_emit_,  table45_1_emit_,  table45_2_emit_,  table45_3_emit_,
    table45_4_emit_,  table45_5_emit_,  table45_6_emit_,  table45_7_emit_,
    table45_8_emit_,  table45_9_emit_,  table45_10_emit_, table45_11_emit_,
    table45_12_emit_, table45_13_emit_, table45_14_emit_, table45_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table45_ops_[16] = {
    table45_0_ops_,  table45_0_ops_,  table45_0_ops_,  table45_0_ops_,
    table45_0_ops_,  table45_0_ops_,  table45_0_ops_,  table45_7_ops_,
    table45_8_ops_,  table45_8_ops_,  table45_8_ops_,  table45_8_ops_,
    table45_12_ops_, table45_13_ops_, table45_13_ops_, table45_15_ops_,
};
}  // namespace geometry_9_12_9
}  // namespace grpc_core
