// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: openfga/v1/authzmodel.proto

package openfgav1

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on AuthorizationModel with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AuthorizationModel) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AuthorizationModel with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AuthorizationModelMultiError, or nil if none found.
func (m *AuthorizationModel) ValidateAll() error {
	return m.validate(true)
}

func (m *AuthorizationModel) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_AuthorizationModel_Id_Pattern.MatchString(m.GetId()) {
		err := AuthorizationModelValidationError{
			field:  "Id",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_AuthorizationModel_SchemaVersion_Pattern.MatchString(m.GetSchemaVersion()) {
		err := AuthorizationModelValidationError{
			field:  "SchemaVersion",
			reason: "value does not match regex pattern \"^[1-9].[1-9]$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetTypeDefinitions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AuthorizationModelValidationError{
						field:  fmt.Sprintf("TypeDefinitions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AuthorizationModelValidationError{
						field:  fmt.Sprintf("TypeDefinitions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AuthorizationModelValidationError{
					field:  fmt.Sprintf("TypeDefinitions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetConditions()) > 25 {
		err := AuthorizationModelValidationError{
			field:  "Conditions",
			reason: "value must contain no more than 25 pair(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	{
		sorted_keys := make([]string, len(m.GetConditions()))
		i := 0
		for key := range m.GetConditions() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetConditions()[key]
			_ = val

			if !_AuthorizationModel_Conditions_Pattern.MatchString(key) {
				err := AuthorizationModelValidationError{
					field:  fmt.Sprintf("Conditions[%v]", key),
					reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, AuthorizationModelValidationError{
							field:  fmt.Sprintf("Conditions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, AuthorizationModelValidationError{
							field:  fmt.Sprintf("Conditions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return AuthorizationModelValidationError{
						field:  fmt.Sprintf("Conditions[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if len(errors) > 0 {
		return AuthorizationModelMultiError(errors)
	}

	return nil
}

// AuthorizationModelMultiError is an error wrapping multiple validation errors
// returned by AuthorizationModel.ValidateAll() if the designated constraints
// aren't met.
type AuthorizationModelMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AuthorizationModelMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AuthorizationModelMultiError) AllErrors() []error { return m }

// AuthorizationModelValidationError is the validation error returned by
// AuthorizationModel.Validate if the designated constraints aren't met.
type AuthorizationModelValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AuthorizationModelValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AuthorizationModelValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AuthorizationModelValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AuthorizationModelValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AuthorizationModelValidationError) ErrorName() string {
	return "AuthorizationModelValidationError"
}

// Error satisfies the builtin error interface
func (e AuthorizationModelValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAuthorizationModel.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AuthorizationModelValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AuthorizationModelValidationError{}

var _AuthorizationModel_Id_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _AuthorizationModel_SchemaVersion_Pattern = regexp.MustCompile("^[1-9].[1-9]$")

var _AuthorizationModel_Conditions_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

// Validate checks the field values on TypeDefinition with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TypeDefinition) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TypeDefinition with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TypeDefinitionMultiError,
// or nil if none found.
func (m *TypeDefinition) ValidateAll() error {
	return m.validate(true)
}

func (m *TypeDefinition) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_TypeDefinition_Type_Pattern.MatchString(m.GetType()) {
		err := TypeDefinitionValidationError{
			field:  "Type",
			reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,254}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	{
		sorted_keys := make([]string, len(m.GetRelations()))
		i := 0
		for key := range m.GetRelations() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetRelations()[key]
			_ = val

			if !_TypeDefinition_Relations_Pattern.MatchString(key) {
				err := TypeDefinitionValidationError{
					field:  fmt.Sprintf("Relations[%v]", key),
					reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, TypeDefinitionValidationError{
							field:  fmt.Sprintf("Relations[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, TypeDefinitionValidationError{
							field:  fmt.Sprintf("Relations[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return TypeDefinitionValidationError{
						field:  fmt.Sprintf("Relations[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TypeDefinitionValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TypeDefinitionValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TypeDefinitionValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TypeDefinitionMultiError(errors)
	}

	return nil
}

// TypeDefinitionMultiError is an error wrapping multiple validation errors
// returned by TypeDefinition.ValidateAll() if the designated constraints
// aren't met.
type TypeDefinitionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TypeDefinitionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TypeDefinitionMultiError) AllErrors() []error { return m }

// TypeDefinitionValidationError is the validation error returned by
// TypeDefinition.Validate if the designated constraints aren't met.
type TypeDefinitionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TypeDefinitionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TypeDefinitionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TypeDefinitionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TypeDefinitionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TypeDefinitionValidationError) ErrorName() string { return "TypeDefinitionValidationError" }

// Error satisfies the builtin error interface
func (e TypeDefinitionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTypeDefinition.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TypeDefinitionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TypeDefinitionValidationError{}

var _TypeDefinition_Type_Pattern = regexp.MustCompile("^[^:#@\\s]{1,254}$")

var _TypeDefinition_Relations_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

// Validate checks the field values on Relation with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Relation) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Relation with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RelationMultiError, or nil
// if none found.
func (m *Relation) ValidateAll() error {
	return m.validate(true)
}

func (m *Relation) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_Relation_Name_Pattern.MatchString(m.GetName()) {
		err := RelationValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetRewrite() == nil {
		err := RelationValidationError{
			field:  "Rewrite",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetRewrite()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RelationValidationError{
					field:  "Rewrite",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RelationValidationError{
					field:  "Rewrite",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRewrite()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RelationValidationError{
				field:  "Rewrite",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTypeInfo()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RelationValidationError{
					field:  "TypeInfo",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RelationValidationError{
					field:  "TypeInfo",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTypeInfo()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RelationValidationError{
				field:  "TypeInfo",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RelationMultiError(errors)
	}

	return nil
}

// RelationMultiError is an error wrapping multiple validation errors returned
// by Relation.ValidateAll() if the designated constraints aren't met.
type RelationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationMultiError) AllErrors() []error { return m }

// RelationValidationError is the validation error returned by
// Relation.Validate if the designated constraints aren't met.
type RelationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationValidationError) ErrorName() string { return "RelationValidationError" }

// Error satisfies the builtin error interface
func (e RelationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationValidationError{}

var _Relation_Name_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

// Validate checks the field values on RelationTypeInfo with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *RelationTypeInfo) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationTypeInfo with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RelationTypeInfoMultiError, or nil if none found.
func (m *RelationTypeInfo) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationTypeInfo) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetDirectlyRelatedUserTypes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RelationTypeInfoValidationError{
						field:  fmt.Sprintf("DirectlyRelatedUserTypes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RelationTypeInfoValidationError{
						field:  fmt.Sprintf("DirectlyRelatedUserTypes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RelationTypeInfoValidationError{
					field:  fmt.Sprintf("DirectlyRelatedUserTypes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return RelationTypeInfoMultiError(errors)
	}

	return nil
}

// RelationTypeInfoMultiError is an error wrapping multiple validation errors
// returned by RelationTypeInfo.ValidateAll() if the designated constraints
// aren't met.
type RelationTypeInfoMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationTypeInfoMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationTypeInfoMultiError) AllErrors() []error { return m }

// RelationTypeInfoValidationError is the validation error returned by
// RelationTypeInfo.Validate if the designated constraints aren't met.
type RelationTypeInfoValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationTypeInfoValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationTypeInfoValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationTypeInfoValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationTypeInfoValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationTypeInfoValidationError) ErrorName() string { return "RelationTypeInfoValidationError" }

// Error satisfies the builtin error interface
func (e RelationTypeInfoValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationTypeInfo.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationTypeInfoValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationTypeInfoValidationError{}

// Validate checks the field values on Metadata with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Metadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Metadata with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in MetadataMultiError, or nil
// if none found.
func (m *Metadata) ValidateAll() error {
	return m.validate(true)
}

func (m *Metadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	{
		sorted_keys := make([]string, len(m.GetRelations()))
		i := 0
		for key := range m.GetRelations() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetRelations()[key]
			_ = val

			// no validation rules for Relations[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, MetadataValidationError{
							field:  fmt.Sprintf("Relations[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, MetadataValidationError{
							field:  fmt.Sprintf("Relations[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return MetadataValidationError{
						field:  fmt.Sprintf("Relations[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if m.GetModule() != "" {

		if !_Metadata_Module_Pattern.MatchString(m.GetModule()) {
			err := MetadataValidationError{
				field:  "Module",
				reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetSourceInfo()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, MetadataValidationError{
					field:  "SourceInfo",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, MetadataValidationError{
					field:  "SourceInfo",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSourceInfo()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return MetadataValidationError{
				field:  "SourceInfo",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return MetadataMultiError(errors)
	}

	return nil
}

// MetadataMultiError is an error wrapping multiple validation errors returned
// by Metadata.ValidateAll() if the designated constraints aren't met.
type MetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m MetadataMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m MetadataMultiError) AllErrors() []error { return m }

// MetadataValidationError is the validation error returned by
// Metadata.Validate if the designated constraints aren't met.
type MetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MetadataValidationError) ErrorName() string { return "MetadataValidationError" }

// Error satisfies the builtin error interface
func (e MetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MetadataValidationError{}

var _Metadata_Module_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

// Validate checks the field values on SourceInfo with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *SourceInfo) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SourceInfo with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in SourceInfoMultiError, or
// nil if none found.
func (m *SourceInfo) ValidateAll() error {
	return m.validate(true)
}

func (m *SourceInfo) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetFile() != "" {

		if !_SourceInfo_File_Pattern.MatchString(m.GetFile()) {
			err := SourceInfoValidationError{
				field:  "File",
				reason: "value does not match regex pattern \"^[a-zA-Z0-9_\\\\-\\\\/]{1,100}\\\\.fga$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return SourceInfoMultiError(errors)
	}

	return nil
}

// SourceInfoMultiError is an error wrapping multiple validation errors
// returned by SourceInfo.ValidateAll() if the designated constraints aren't met.
type SourceInfoMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SourceInfoMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SourceInfoMultiError) AllErrors() []error { return m }

// SourceInfoValidationError is the validation error returned by
// SourceInfo.Validate if the designated constraints aren't met.
type SourceInfoValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SourceInfoValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SourceInfoValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SourceInfoValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SourceInfoValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SourceInfoValidationError) ErrorName() string { return "SourceInfoValidationError" }

// Error satisfies the builtin error interface
func (e SourceInfoValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSourceInfo.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SourceInfoValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SourceInfoValidationError{}

var _SourceInfo_File_Pattern = regexp.MustCompile("^[a-zA-Z0-9_\\-\\/]{1,100}\\.fga$")

// Validate checks the field values on RelationMetadata with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *RelationMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationMetadata with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RelationMetadataMultiError, or nil if none found.
func (m *RelationMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetDirectlyRelatedUserTypes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RelationMetadataValidationError{
						field:  fmt.Sprintf("DirectlyRelatedUserTypes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RelationMetadataValidationError{
						field:  fmt.Sprintf("DirectlyRelatedUserTypes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RelationMetadataValidationError{
					field:  fmt.Sprintf("DirectlyRelatedUserTypes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if m.GetModule() != "" {

		if !_RelationMetadata_Module_Pattern.MatchString(m.GetModule()) {
			err := RelationMetadataValidationError{
				field:  "Module",
				reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetSourceInfo()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RelationMetadataValidationError{
					field:  "SourceInfo",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RelationMetadataValidationError{
					field:  "SourceInfo",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSourceInfo()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RelationMetadataValidationError{
				field:  "SourceInfo",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RelationMetadataMultiError(errors)
	}

	return nil
}

// RelationMetadataMultiError is an error wrapping multiple validation errors
// returned by RelationMetadata.ValidateAll() if the designated constraints
// aren't met.
type RelationMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationMetadataMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationMetadataMultiError) AllErrors() []error { return m }

// RelationMetadataValidationError is the validation error returned by
// RelationMetadata.Validate if the designated constraints aren't met.
type RelationMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationMetadataValidationError) ErrorName() string { return "RelationMetadataValidationError" }

// Error satisfies the builtin error interface
func (e RelationMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationMetadataValidationError{}

var _RelationMetadata_Module_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

// Validate checks the field values on RelationReference with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *RelationReference) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationReference with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RelationReferenceMultiError, or nil if none found.
func (m *RelationReference) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationReference) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_RelationReference_Type_Pattern.MatchString(m.GetType()) {
		err := RelationReferenceValidationError{
			field:  "Type",
			reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,254}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetCondition() != "" {

		if !_RelationReference_Condition_Pattern.MatchString(m.GetCondition()) {
			err := RelationReferenceValidationError{
				field:  "Condition",
				reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	switch v := m.RelationOrWildcard.(type) {
	case *RelationReference_Relation:
		if v == nil {
			err := RelationReferenceValidationError{
				field:  "RelationOrWildcard",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if m.GetRelation() != "" {

			if !_RelationReference_Relation_Pattern.MatchString(m.GetRelation()) {
				err := RelationReferenceValidationError{
					field:  "Relation",
					reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}

	case *RelationReference_Wildcard:
		if v == nil {
			err := RelationReferenceValidationError{
				field:  "RelationOrWildcard",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetWildcard()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RelationReferenceValidationError{
						field:  "Wildcard",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RelationReferenceValidationError{
						field:  "Wildcard",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetWildcard()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RelationReferenceValidationError{
					field:  "Wildcard",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return RelationReferenceMultiError(errors)
	}

	return nil
}

// RelationReferenceMultiError is an error wrapping multiple validation errors
// returned by RelationReference.ValidateAll() if the designated constraints
// aren't met.
type RelationReferenceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationReferenceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationReferenceMultiError) AllErrors() []error { return m }

// RelationReferenceValidationError is the validation error returned by
// RelationReference.Validate if the designated constraints aren't met.
type RelationReferenceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationReferenceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationReferenceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationReferenceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationReferenceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationReferenceValidationError) ErrorName() string {
	return "RelationReferenceValidationError"
}

// Error satisfies the builtin error interface
func (e RelationReferenceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationReference.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationReferenceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationReferenceValidationError{}

var _RelationReference_Type_Pattern = regexp.MustCompile("^[^:#@\\s]{1,254}$")

var _RelationReference_Relation_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

var _RelationReference_Condition_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

// Validate checks the field values on Wildcard with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Wildcard) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Wildcard with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in WildcardMultiError, or nil
// if none found.
func (m *Wildcard) ValidateAll() error {
	return m.validate(true)
}

func (m *Wildcard) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return WildcardMultiError(errors)
	}

	return nil
}

// WildcardMultiError is an error wrapping multiple validation errors returned
// by Wildcard.ValidateAll() if the designated constraints aren't met.
type WildcardMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WildcardMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WildcardMultiError) AllErrors() []error { return m }

// WildcardValidationError is the validation error returned by
// Wildcard.Validate if the designated constraints aren't met.
type WildcardValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WildcardValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WildcardValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WildcardValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WildcardValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WildcardValidationError) ErrorName() string { return "WildcardValidationError" }

// Error satisfies the builtin error interface
func (e WildcardValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWildcard.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WildcardValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WildcardValidationError{}

// Validate checks the field values on Usersets with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Usersets) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Usersets with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in UsersetsMultiError, or nil
// if none found.
func (m *Usersets) ValidateAll() error {
	return m.validate(true)
}

func (m *Usersets) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetChild() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetsValidationError{
						field:  fmt.Sprintf("Child[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetsValidationError{
						field:  fmt.Sprintf("Child[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetsValidationError{
					field:  fmt.Sprintf("Child[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return UsersetsMultiError(errors)
	}

	return nil
}

// UsersetsMultiError is an error wrapping multiple validation errors returned
// by Usersets.ValidateAll() if the designated constraints aren't met.
type UsersetsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UsersetsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UsersetsMultiError) AllErrors() []error { return m }

// UsersetsValidationError is the validation error returned by
// Usersets.Validate if the designated constraints aren't met.
type UsersetsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UsersetsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UsersetsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UsersetsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UsersetsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UsersetsValidationError) ErrorName() string { return "UsersetsValidationError" }

// Error satisfies the builtin error interface
func (e UsersetsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUsersets.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UsersetsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UsersetsValidationError{}

// Validate checks the field values on Difference with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Difference) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Difference with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in DifferenceMultiError, or
// nil if none found.
func (m *Difference) ValidateAll() error {
	return m.validate(true)
}

func (m *Difference) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetBase() == nil {
		err := DifferenceValidationError{
			field:  "Base",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetBase()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DifferenceValidationError{
					field:  "Base",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DifferenceValidationError{
					field:  "Base",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBase()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DifferenceValidationError{
				field:  "Base",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetSubtract() == nil {
		err := DifferenceValidationError{
			field:  "Subtract",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetSubtract()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DifferenceValidationError{
					field:  "Subtract",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DifferenceValidationError{
					field:  "Subtract",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSubtract()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DifferenceValidationError{
				field:  "Subtract",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return DifferenceMultiError(errors)
	}

	return nil
}

// DifferenceMultiError is an error wrapping multiple validation errors
// returned by Difference.ValidateAll() if the designated constraints aren't met.
type DifferenceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DifferenceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DifferenceMultiError) AllErrors() []error { return m }

// DifferenceValidationError is the validation error returned by
// Difference.Validate if the designated constraints aren't met.
type DifferenceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DifferenceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DifferenceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DifferenceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DifferenceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DifferenceValidationError) ErrorName() string { return "DifferenceValidationError" }

// Error satisfies the builtin error interface
func (e DifferenceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDifference.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DifferenceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DifferenceValidationError{}

// Validate checks the field values on Userset with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Userset) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Userset with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in UsersetMultiError, or nil if none found.
func (m *Userset) ValidateAll() error {
	return m.validate(true)
}

func (m *Userset) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Userset.(type) {
	case *Userset_This:
		if v == nil {
			err := UsersetValidationError{
				field:  "Userset",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetThis()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetValidationError{
						field:  "This",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetValidationError{
						field:  "This",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetThis()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetValidationError{
					field:  "This",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Userset_ComputedUserset:
		if v == nil {
			err := UsersetValidationError{
				field:  "Userset",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetComputedUserset()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetValidationError{
						field:  "ComputedUserset",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetValidationError{
						field:  "ComputedUserset",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetComputedUserset()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetValidationError{
					field:  "ComputedUserset",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Userset_TupleToUserset:
		if v == nil {
			err := UsersetValidationError{
				field:  "Userset",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTupleToUserset()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetValidationError{
						field:  "TupleToUserset",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetValidationError{
						field:  "TupleToUserset",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTupleToUserset()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetValidationError{
					field:  "TupleToUserset",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Userset_Union:
		if v == nil {
			err := UsersetValidationError{
				field:  "Userset",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnion()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetValidationError{
						field:  "Union",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetValidationError{
						field:  "Union",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnion()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetValidationError{
					field:  "Union",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Userset_Intersection:
		if v == nil {
			err := UsersetValidationError{
				field:  "Userset",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetIntersection()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetValidationError{
						field:  "Intersection",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetValidationError{
						field:  "Intersection",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetIntersection()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetValidationError{
					field:  "Intersection",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Userset_Difference:
		if v == nil {
			err := UsersetValidationError{
				field:  "Userset",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetDifference()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetValidationError{
						field:  "Difference",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetValidationError{
						field:  "Difference",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetDifference()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetValidationError{
					field:  "Difference",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return UsersetMultiError(errors)
	}

	return nil
}

// UsersetMultiError is an error wrapping multiple validation errors returned
// by Userset.ValidateAll() if the designated constraints aren't met.
type UsersetMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UsersetMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UsersetMultiError) AllErrors() []error { return m }

// UsersetValidationError is the validation error returned by Userset.Validate
// if the designated constraints aren't met.
type UsersetValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UsersetValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UsersetValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UsersetValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UsersetValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UsersetValidationError) ErrorName() string { return "UsersetValidationError" }

// Error satisfies the builtin error interface
func (e UsersetValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserset.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UsersetValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UsersetValidationError{}

// Validate checks the field values on DirectUserset with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *DirectUserset) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DirectUserset with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in DirectUsersetMultiError, or
// nil if none found.
func (m *DirectUserset) ValidateAll() error {
	return m.validate(true)
}

func (m *DirectUserset) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return DirectUsersetMultiError(errors)
	}

	return nil
}

// DirectUsersetMultiError is an error wrapping multiple validation errors
// returned by DirectUserset.ValidateAll() if the designated constraints
// aren't met.
type DirectUsersetMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DirectUsersetMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DirectUsersetMultiError) AllErrors() []error { return m }

// DirectUsersetValidationError is the validation error returned by
// DirectUserset.Validate if the designated constraints aren't met.
type DirectUsersetValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DirectUsersetValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DirectUsersetValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DirectUsersetValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DirectUsersetValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DirectUsersetValidationError) ErrorName() string { return "DirectUsersetValidationError" }

// Error satisfies the builtin error interface
func (e DirectUsersetValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDirectUserset.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DirectUsersetValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DirectUsersetValidationError{}

// Validate checks the field values on ObjectRelation with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ObjectRelation) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ObjectRelation with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ObjectRelationMultiError,
// or nil if none found.
func (m *ObjectRelation) ValidateAll() error {
	return m.validate(true)
}

func (m *ObjectRelation) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetObject()) > 256 {
		err := ObjectRelationValidationError{
			field:  "Object",
			reason: "value length must be at most 256 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetRelation()) > 50 {
		err := ObjectRelationValidationError{
			field:  "Relation",
			reason: "value length must be at most 50 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ObjectRelationMultiError(errors)
	}

	return nil
}

// ObjectRelationMultiError is an error wrapping multiple validation errors
// returned by ObjectRelation.ValidateAll() if the designated constraints
// aren't met.
type ObjectRelationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ObjectRelationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ObjectRelationMultiError) AllErrors() []error { return m }

// ObjectRelationValidationError is the validation error returned by
// ObjectRelation.Validate if the designated constraints aren't met.
type ObjectRelationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ObjectRelationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ObjectRelationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ObjectRelationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ObjectRelationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ObjectRelationValidationError) ErrorName() string { return "ObjectRelationValidationError" }

// Error satisfies the builtin error interface
func (e ObjectRelationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sObjectRelation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ObjectRelationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ObjectRelationValidationError{}

// Validate checks the field values on ComputedUserset with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ComputedUserset) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ComputedUserset with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ComputedUsersetMultiError, or nil if none found.
func (m *ComputedUserset) ValidateAll() error {
	return m.validate(true)
}

func (m *ComputedUserset) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetRelation()) > 50 {
		err := ComputedUsersetValidationError{
			field:  "Relation",
			reason: "value length must be at most 50 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ComputedUsersetMultiError(errors)
	}

	return nil
}

// ComputedUsersetMultiError is an error wrapping multiple validation errors
// returned by ComputedUserset.ValidateAll() if the designated constraints
// aren't met.
type ComputedUsersetMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ComputedUsersetMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ComputedUsersetMultiError) AllErrors() []error { return m }

// ComputedUsersetValidationError is the validation error returned by
// ComputedUserset.Validate if the designated constraints aren't met.
type ComputedUsersetValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ComputedUsersetValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ComputedUsersetValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ComputedUsersetValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ComputedUsersetValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ComputedUsersetValidationError) ErrorName() string { return "ComputedUsersetValidationError" }

// Error satisfies the builtin error interface
func (e ComputedUsersetValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sComputedUserset.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ComputedUsersetValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ComputedUsersetValidationError{}

// Validate checks the field values on TupleToUserset with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TupleToUserset) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TupleToUserset with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TupleToUsersetMultiError,
// or nil if none found.
func (m *TupleToUserset) ValidateAll() error {
	return m.validate(true)
}

func (m *TupleToUserset) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetTupleset() == nil {
		err := TupleToUsersetValidationError{
			field:  "Tupleset",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetTupleset()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleToUsersetValidationError{
					field:  "Tupleset",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleToUsersetValidationError{
					field:  "Tupleset",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTupleset()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleToUsersetValidationError{
				field:  "Tupleset",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetComputedUserset() == nil {
		err := TupleToUsersetValidationError{
			field:  "ComputedUserset",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetComputedUserset()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleToUsersetValidationError{
					field:  "ComputedUserset",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleToUsersetValidationError{
					field:  "ComputedUserset",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetComputedUserset()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleToUsersetValidationError{
				field:  "ComputedUserset",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TupleToUsersetMultiError(errors)
	}

	return nil
}

// TupleToUsersetMultiError is an error wrapping multiple validation errors
// returned by TupleToUserset.ValidateAll() if the designated constraints
// aren't met.
type TupleToUsersetMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TupleToUsersetMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TupleToUsersetMultiError) AllErrors() []error { return m }

// TupleToUsersetValidationError is the validation error returned by
// TupleToUserset.Validate if the designated constraints aren't met.
type TupleToUsersetValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TupleToUsersetValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TupleToUsersetValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TupleToUsersetValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TupleToUsersetValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TupleToUsersetValidationError) ErrorName() string { return "TupleToUsersetValidationError" }

// Error satisfies the builtin error interface
func (e TupleToUsersetValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTupleToUserset.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TupleToUsersetValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TupleToUsersetValidationError{}

// Validate checks the field values on Condition with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Condition) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Condition with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ConditionMultiError, or nil
// if none found.
func (m *Condition) ValidateAll() error {
	return m.validate(true)
}

func (m *Condition) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_Condition_Name_Pattern.MatchString(m.GetName()) {
		err := ConditionValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetExpression()) > 512 {
		err := ConditionValidationError{
			field:  "Expression",
			reason: "value length must be at most 512 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetParameters()) > 25 {
		err := ConditionValidationError{
			field:  "Parameters",
			reason: "value must contain no more than 25 pair(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	{
		sorted_keys := make([]string, len(m.GetParameters()))
		i := 0
		for key := range m.GetParameters() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetParameters()[key]
			_ = val

			if !_Condition_Parameters_Pattern.MatchString(key) {
				err := ConditionValidationError{
					field:  fmt.Sprintf("Parameters[%v]", key),
					reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, ConditionValidationError{
							field:  fmt.Sprintf("Parameters[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, ConditionValidationError{
							field:  fmt.Sprintf("Parameters[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return ConditionValidationError{
						field:  fmt.Sprintf("Parameters[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConditionValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConditionValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConditionValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ConditionMultiError(errors)
	}

	return nil
}

// ConditionMultiError is an error wrapping multiple validation errors returned
// by Condition.ValidateAll() if the designated constraints aren't met.
type ConditionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ConditionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ConditionMultiError) AllErrors() []error { return m }

// ConditionValidationError is the validation error returned by
// Condition.Validate if the designated constraints aren't met.
type ConditionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConditionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConditionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConditionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConditionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConditionValidationError) ErrorName() string { return "ConditionValidationError" }

// Error satisfies the builtin error interface
func (e ConditionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCondition.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConditionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConditionValidationError{}

var _Condition_Name_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

var _Condition_Parameters_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

// Validate checks the field values on ConditionMetadata with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ConditionMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ConditionMetadata with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ConditionMetadataMultiError, or nil if none found.
func (m *ConditionMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *ConditionMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetModule() != "" {

		if !_ConditionMetadata_Module_Pattern.MatchString(m.GetModule()) {
			err := ConditionMetadataValidationError{
				field:  "Module",
				reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetSourceInfo()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConditionMetadataValidationError{
					field:  "SourceInfo",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConditionMetadataValidationError{
					field:  "SourceInfo",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSourceInfo()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConditionMetadataValidationError{
				field:  "SourceInfo",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ConditionMetadataMultiError(errors)
	}

	return nil
}

// ConditionMetadataMultiError is an error wrapping multiple validation errors
// returned by ConditionMetadata.ValidateAll() if the designated constraints
// aren't met.
type ConditionMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ConditionMetadataMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ConditionMetadataMultiError) AllErrors() []error { return m }

// ConditionMetadataValidationError is the validation error returned by
// ConditionMetadata.Validate if the designated constraints aren't met.
type ConditionMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConditionMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConditionMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConditionMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConditionMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConditionMetadataValidationError) ErrorName() string {
	return "ConditionMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e ConditionMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConditionMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConditionMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConditionMetadataValidationError{}

var _ConditionMetadata_Module_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

// Validate checks the field values on ConditionParamTypeRef with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ConditionParamTypeRef) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ConditionParamTypeRef with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ConditionParamTypeRefMultiError, or nil if none found.
func (m *ConditionParamTypeRef) ValidateAll() error {
	return m.validate(true)
}

func (m *ConditionParamTypeRef) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := ConditionParamTypeRef_TypeName_name[int32(m.GetTypeName())]; !ok {
		err := ConditionParamTypeRefValidationError{
			field:  "TypeName",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetGenericTypes()) > 5 {
		err := ConditionParamTypeRefValidationError{
			field:  "GenericTypes",
			reason: "value must contain no more than 5 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetGenericTypes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ConditionParamTypeRefValidationError{
						field:  fmt.Sprintf("GenericTypes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ConditionParamTypeRefValidationError{
						field:  fmt.Sprintf("GenericTypes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ConditionParamTypeRefValidationError{
					field:  fmt.Sprintf("GenericTypes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ConditionParamTypeRefMultiError(errors)
	}

	return nil
}

// ConditionParamTypeRefMultiError is an error wrapping multiple validation
// errors returned by ConditionParamTypeRef.ValidateAll() if the designated
// constraints aren't met.
type ConditionParamTypeRefMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ConditionParamTypeRefMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ConditionParamTypeRefMultiError) AllErrors() []error { return m }

// ConditionParamTypeRefValidationError is the validation error returned by
// ConditionParamTypeRef.Validate if the designated constraints aren't met.
type ConditionParamTypeRefValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConditionParamTypeRefValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConditionParamTypeRefValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConditionParamTypeRefValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConditionParamTypeRefValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConditionParamTypeRefValidationError) ErrorName() string {
	return "ConditionParamTypeRefValidationError"
}

// Error satisfies the builtin error interface
func (e ConditionParamTypeRefValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConditionParamTypeRef.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConditionParamTypeRefValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConditionParamTypeRefValidationError{}
