/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class ActionSetRegistry
implements IExtensionChangeHandler {
    private ArrayList<ActionSetDescriptor> children = new ArrayList();
    private Map<String, ArrayList<String>> mapPartToActionSetIds = new HashMap<String, ArrayList<String>>();
    private Map<String, ArrayList<IActionSetDescriptor>> mapPartToActionSets = new HashMap<String, ArrayList<IActionSetDescriptor>>();
    private IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);

    public ActionSetRegistry() {
        PlatformUI.getWorkbench().getExtensionTracker().registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint[])new IExtensionPoint[]{this.getActionSetExtensionPoint(), this.getActionSetPartAssociationExtensionPoint()}));
        this.readFromRegistry();
    }

    private IExtensionPoint getActionSetPartAssociationExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "actionSetPartAssociations");
    }

    private IExtensionPoint getActionSetExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "actionSets");
    }

    private void addActionSet(ActionSetDescriptor desc) {
        this.children.add(desc);
        Context actionSetContext = this.contextService.getContext(desc.getId());
        if (!actionSetContext.isDefined()) {
            actionSetContext.define(desc.getLabel(), desc.getDescription(), "org.eclipse.ui.contexts.actionSet");
        }
    }

    private void removeActionSet(IActionSetDescriptor desc) {
        Context actionSetContext = this.contextService.getContext(desc.getId());
        if (actionSetContext.isDefined()) {
            actionSetContext.undefine();
        }
        this.children.remove(desc);
    }

    private Object addAssociation(String actionSetId, String partId) {
        ArrayList<String> actionSets = this.mapPartToActionSetIds.get(partId);
        if (actionSets == null) {
            actionSets = new ArrayList();
            this.mapPartToActionSetIds.put(partId, actionSets);
        }
        actionSets.add(actionSetId);
        return new ActionSetPartAssociation(partId, actionSetId);
    }

    public IActionSetDescriptor findActionSet(String id) {
        for (IActionSetDescriptor iActionSetDescriptor : this.children) {
            if (!iActionSetDescriptor.getId().equals(id)) continue;
            return iActionSetDescriptor;
        }
        return null;
    }

    public IActionSetDescriptor[] getActionSets() {
        return this.children.toArray(new IActionSetDescriptor[this.children.size()]);
    }

    public IActionSetDescriptor[] getActionSetsFor(String partId) {
        ArrayList<IActionSetDescriptor> actionSets = this.mapPartToActionSets.get(partId);
        if (actionSets != null) {
            return actionSets.toArray(new IActionSetDescriptor[actionSets.size()]);
        }
        ArrayList<String> actionSetIds = this.mapPartToActionSetIds.get(partId);
        if (actionSetIds == null) {
            return new IActionSetDescriptor[0];
        }
        actionSets = new ArrayList(actionSetIds.size());
        for (String actionSetId : actionSetIds) {
            IActionSetDescriptor actionSet = this.findActionSet(actionSetId);
            if (actionSet != null) {
                actionSets.add(actionSet);
                continue;
            }
            WorkbenchPlugin.log("Unable to associate action set with part: " + partId + ". Action set " + actionSetId + " not found.");
        }
        this.mapPartToActionSets.put(partId, actionSets);
        return actionSets.toArray(new IActionSetDescriptor[actionSets.size()]);
    }

    private void readFromRegistry() {
        IExtension extension;
        IExtension[] iExtensionArray = this.getActionSetExtensionPoint().getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            extension = iExtensionArray[n2];
            this.addActionSets(PlatformUI.getWorkbench().getExtensionTracker(), extension);
            ++n2;
        }
        iExtensionArray = this.getActionSetPartAssociationExtensionPoint().getExtensions();
        n = iExtensionArray.length;
        n2 = 0;
        while (n2 < n) {
            extension = iExtensionArray[n2];
            this.addActionSetPartAssociations(PlatformUI.getWorkbench().getExtensionTracker(), extension);
            ++n2;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        String extensionPointUniqueIdentifier = extension.getExtensionPointUniqueIdentifier();
        if (extensionPointUniqueIdentifier.equals(this.getActionSetExtensionPoint().getUniqueIdentifier())) {
            this.addActionSets(tracker, extension);
        } else if (extensionPointUniqueIdentifier.equals(this.getActionSetPartAssociationExtensionPoint().getUniqueIdentifier())) {
            this.addActionSetPartAssociations(tracker, extension);
        }
    }

    private void addActionSetPartAssociations(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("actionSetPartAssociation")) {
                String actionSetId = element.getAttribute("targetID");
                IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    if (child.getName().equals("part")) {
                        Object trackingObject;
                        String partId = child.getAttribute("id");
                        if (partId != null && (trackingObject = this.addAssociation(actionSetId, partId)) != null) {
                            tracker.registerObject(extension, trackingObject, 0);
                        }
                    } else {
                        WorkbenchPlugin.log("Unable to process element: " + child.getName() + " in action set part associations extension: " + extension.getUniqueIdentifier());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.mapPartToActionSets.clear();
    }

    private void addActionSets(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("actionSet")) {
                try {
                    ActionSetDescriptor desc = new ActionSetDescriptor(element);
                    this.addActionSet(desc);
                    tracker.registerObject(extension, (Object)desc, 2);
                }
                catch (CoreException e) {
                    WorkbenchPlugin.log("Unable to create action set descriptor.", e.getStatus());
                }
            }
            ++n2;
        }
        this.mapPartToActionSets.clear();
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        String extensionPointUniqueIdentifier = extension.getExtensionPointUniqueIdentifier();
        if (extensionPointUniqueIdentifier.equals(this.getActionSetExtensionPoint().getUniqueIdentifier())) {
            this.removeActionSets(objects);
        } else if (extensionPointUniqueIdentifier.equals(this.getActionSetPartAssociationExtensionPoint().getUniqueIdentifier())) {
            this.removeActionSetPartAssociations(objects);
        }
    }

    private void removeActionSetPartAssociations(Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ActionSetPartAssociation) {
                ActionSetPartAssociation association = (ActionSetPartAssociation)object;
                String actionSetId = association.actionSetId;
                ArrayList<String> actionSets = this.mapPartToActionSetIds.get(association.partId);
                if (actionSets == null) {
                    return;
                }
                actionSets.remove(actionSetId);
                if (actionSets.isEmpty()) {
                    this.mapPartToActionSetIds.remove(association.partId);
                }
            }
            ++n2;
        }
        this.mapPartToActionSets.clear();
    }

    private void removeActionSets(Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IActionSetDescriptor) {
                IActionSetDescriptor desc = (IActionSetDescriptor)object;
                this.removeActionSet(desc);
                Iterator<ArrayList<String>> j = this.mapPartToActionSetIds.values().iterator();
                while (j.hasNext()) {
                    ArrayList<String> list = j.next();
                    list.remove(desc.getId());
                    if (!list.isEmpty()) continue;
                    j.remove();
                }
            }
            ++n2;
        }
        this.mapPartToActionSets.clear();
    }

    private static class ActionSetPartAssociation {
        String partId;
        String actionSetId;

        public ActionSetPartAssociation(String partId, String actionSetId) {
            this.partId = partId;
            this.actionSetId = actionSetId;
        }
    }
}

