#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1981
#define LARGE_STATE_COUNT 446
#define SYMBOL_COUNT 355
#define ALIAS_COUNT 3
#define TOKEN_COUNT 157
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 39
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 132

enum ts_symbol_identifiers {
  sym_identifier = 1,
  aux_sym_preproc_include_token1 = 2,
  aux_sym_preproc_include_token2 = 3,
  aux_sym_preproc_def_token1 = 4,
  anon_sym_LPAREN = 5,
  anon_sym_DOT_DOT_DOT = 6,
  anon_sym_COMMA = 7,
  anon_sym_RPAREN = 8,
  aux_sym_preproc_if_token1 = 9,
  anon_sym_LF = 10,
  aux_sym_preproc_if_token2 = 11,
  aux_sym_preproc_ifdef_token1 = 12,
  aux_sym_preproc_ifdef_token2 = 13,
  aux_sym_preproc_else_token1 = 14,
  aux_sym_preproc_elif_token1 = 15,
  aux_sym_preproc_elifdef_token1 = 16,
  aux_sym_preproc_elifdef_token2 = 17,
  sym_preproc_arg = 18,
  sym_preproc_directive = 19,
  anon_sym_LPAREN2 = 20,
  anon_sym_defined = 21,
  anon_sym_BANG = 22,
  anon_sym_TILDE = 23,
  anon_sym_DASH = 24,
  anon_sym_PLUS = 25,
  anon_sym_STAR = 26,
  anon_sym_SLASH = 27,
  anon_sym_PERCENT = 28,
  anon_sym_PIPE_PIPE = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE = 31,
  anon_sym_CARET = 32,
  anon_sym_AMP = 33,
  anon_sym_EQ_EQ = 34,
  anon_sym_BANG_EQ = 35,
  anon_sym_GT = 36,
  anon_sym_GT_EQ = 37,
  anon_sym_LT_EQ = 38,
  anon_sym_LT = 39,
  anon_sym_LT_LT = 40,
  anon_sym_GT_GT = 41,
  anon_sym_SEMI = 42,
  anon_sym___extension__ = 43,
  anon_sym_typedef = 44,
  anon_sym_extern = 45,
  anon_sym___attribute__ = 46,
  anon_sym_COLON_COLON = 47,
  anon_sym_LBRACK_LBRACK = 48,
  anon_sym_RBRACK_RBRACK = 49,
  anon_sym___declspec = 50,
  anon_sym___based = 51,
  anon_sym___cdecl = 52,
  anon_sym___clrcall = 53,
  anon_sym___stdcall = 54,
  anon_sym___fastcall = 55,
  anon_sym___thiscall = 56,
  anon_sym___vectorcall = 57,
  sym_ms_restrict_modifier = 58,
  sym_ms_unsigned_ptr_modifier = 59,
  sym_ms_signed_ptr_modifier = 60,
  anon_sym__unaligned = 61,
  anon_sym___unaligned = 62,
  anon_sym_LBRACE = 63,
  anon_sym_RBRACE = 64,
  anon_sym_signed = 65,
  anon_sym_unsigned = 66,
  anon_sym_long = 67,
  anon_sym_short = 68,
  anon_sym_LBRACK = 69,
  anon_sym_static = 70,
  anon_sym_RBRACK = 71,
  anon_sym_EQ = 72,
  anon_sym_auto = 73,
  anon_sym_register = 74,
  anon_sym_inline = 75,
  anon_sym___inline = 76,
  anon_sym___inline__ = 77,
  anon_sym___forceinline = 78,
  anon_sym_thread_local = 79,
  anon_sym___thread = 80,
  anon_sym_const = 81,
  anon_sym_constexpr = 82,
  anon_sym_volatile = 83,
  anon_sym_restrict = 84,
  anon_sym___restrict__ = 85,
  anon_sym__Atomic = 86,
  anon_sym__Noreturn = 87,
  anon_sym_noreturn = 88,
  anon_sym_alignas = 89,
  anon_sym__Alignas = 90,
  sym_primitive_type = 91,
  anon_sym_enum = 92,
  anon_sym_COLON = 93,
  anon_sym_struct = 94,
  anon_sym_union = 95,
  anon_sym_if = 96,
  anon_sym_else = 97,
  anon_sym_switch = 98,
  anon_sym_case = 99,
  anon_sym_default = 100,
  anon_sym_while = 101,
  anon_sym_do = 102,
  anon_sym_for = 103,
  anon_sym_return = 104,
  anon_sym_break = 105,
  anon_sym_continue = 106,
  anon_sym_goto = 107,
  anon_sym___try = 108,
  anon_sym___except = 109,
  anon_sym___finally = 110,
  anon_sym___leave = 111,
  anon_sym_QMARK = 112,
  anon_sym_STAR_EQ = 113,
  anon_sym_SLASH_EQ = 114,
  anon_sym_PERCENT_EQ = 115,
  anon_sym_PLUS_EQ = 116,
  anon_sym_DASH_EQ = 117,
  anon_sym_LT_LT_EQ = 118,
  anon_sym_GT_GT_EQ = 119,
  anon_sym_AMP_EQ = 120,
  anon_sym_CARET_EQ = 121,
  anon_sym_PIPE_EQ = 122,
  anon_sym_DASH_DASH = 123,
  anon_sym_PLUS_PLUS = 124,
  anon_sym_sizeof = 125,
  anon_sym___alignof__ = 126,
  anon_sym___alignof = 127,
  anon_sym__alignof = 128,
  anon_sym_alignof = 129,
  anon_sym__Alignof = 130,
  anon_sym_offsetof = 131,
  anon_sym__Generic = 132,
  anon_sym_asm = 133,
  anon_sym___asm__ = 134,
  anon_sym_DOT = 135,
  anon_sym_DASH_GT = 136,
  sym_number_literal = 137,
  anon_sym_L_SQUOTE = 138,
  anon_sym_u_SQUOTE = 139,
  anon_sym_U_SQUOTE = 140,
  anon_sym_u8_SQUOTE = 141,
  anon_sym_SQUOTE = 142,
  aux_sym_char_literal_token1 = 143,
  anon_sym_L_DQUOTE = 144,
  anon_sym_u_DQUOTE = 145,
  anon_sym_U_DQUOTE = 146,
  anon_sym_u8_DQUOTE = 147,
  anon_sym_DQUOTE = 148,
  aux_sym_string_literal_token1 = 149,
  sym_escape_sequence = 150,
  sym_system_lib_string = 151,
  sym_true = 152,
  sym_false = 153,
  anon_sym_NULL = 154,
  anon_sym_nullptr = 155,
  sym_comment = 156,
  sym_translation_unit = 157,
  sym__top_level_item = 158,
  sym__block_item = 159,
  sym_preproc_include = 160,
  sym_preproc_def = 161,
  sym_preproc_function_def = 162,
  sym_preproc_params = 163,
  sym_preproc_call = 164,
  sym_preproc_if = 165,
  sym_preproc_ifdef = 166,
  sym_preproc_else = 167,
  sym_preproc_elif = 168,
  sym_preproc_elifdef = 169,
  sym_preproc_if_in_field_declaration_list = 170,
  sym_preproc_ifdef_in_field_declaration_list = 171,
  sym_preproc_else_in_field_declaration_list = 172,
  sym_preproc_elif_in_field_declaration_list = 173,
  sym_preproc_elifdef_in_field_declaration_list = 174,
  sym_preproc_if_in_enumerator_list = 175,
  sym_preproc_ifdef_in_enumerator_list = 176,
  sym_preproc_else_in_enumerator_list = 177,
  sym_preproc_elif_in_enumerator_list = 178,
  sym_preproc_elifdef_in_enumerator_list = 179,
  sym_preproc_if_in_enumerator_list_no_comma = 180,
  sym_preproc_ifdef_in_enumerator_list_no_comma = 181,
  sym_preproc_else_in_enumerator_list_no_comma = 182,
  sym_preproc_elif_in_enumerator_list_no_comma = 183,
  sym_preproc_elifdef_in_enumerator_list_no_comma = 184,
  sym__preproc_expression = 185,
  sym_preproc_parenthesized_expression = 186,
  sym_preproc_defined = 187,
  sym_preproc_unary_expression = 188,
  sym_preproc_call_expression = 189,
  sym_preproc_argument_list = 190,
  sym_preproc_binary_expression = 191,
  sym_function_definition = 192,
  sym__old_style_function_definition = 193,
  sym_declaration = 194,
  sym_type_definition = 195,
  sym__type_definition_type = 196,
  sym__type_definition_declarators = 197,
  sym__declaration_modifiers = 198,
  sym__declaration_specifiers = 199,
  sym_linkage_specification = 200,
  sym_attribute_specifier = 201,
  sym_attribute = 202,
  sym_attribute_declaration = 203,
  sym_ms_declspec_modifier = 204,
  sym_ms_based_modifier = 205,
  sym_ms_call_modifier = 206,
  sym_ms_unaligned_ptr_modifier = 207,
  sym_ms_pointer_modifier = 208,
  sym_declaration_list = 209,
  sym__declarator = 210,
  sym__declaration_declarator = 211,
  sym__field_declarator = 212,
  sym__type_declarator = 213,
  sym__abstract_declarator = 214,
  sym_parenthesized_declarator = 215,
  sym_parenthesized_field_declarator = 216,
  sym_parenthesized_type_declarator = 217,
  sym_abstract_parenthesized_declarator = 218,
  sym_attributed_declarator = 219,
  sym_attributed_field_declarator = 220,
  sym_attributed_type_declarator = 221,
  sym_pointer_declarator = 222,
  sym_pointer_field_declarator = 223,
  sym_pointer_type_declarator = 224,
  sym_abstract_pointer_declarator = 225,
  sym_function_declarator = 226,
  sym__function_declaration_declarator = 227,
  sym_function_field_declarator = 228,
  sym_function_type_declarator = 229,
  sym_abstract_function_declarator = 230,
  sym__old_style_function_declarator = 231,
  sym_array_declarator = 232,
  sym_array_field_declarator = 233,
  sym_array_type_declarator = 234,
  sym_abstract_array_declarator = 235,
  sym_init_declarator = 236,
  sym_compound_statement = 237,
  sym_storage_class_specifier = 238,
  sym_type_qualifier = 239,
  sym_alignas_qualifier = 240,
  sym_type_specifier = 241,
  sym_sized_type_specifier = 242,
  sym_enum_specifier = 243,
  sym_enumerator_list = 244,
  sym_struct_specifier = 245,
  sym_union_specifier = 246,
  sym_field_declaration_list = 247,
  sym__field_declaration_list_item = 248,
  sym_field_declaration = 249,
  sym__field_declaration_declarator = 250,
  sym_bitfield_clause = 251,
  sym_enumerator = 252,
  sym_variadic_parameter = 253,
  sym_parameter_list = 254,
  sym__old_style_parameter_list = 255,
  sym_parameter_declaration = 256,
  sym_attributed_statement = 257,
  sym_statement = 258,
  sym__top_level_statement = 259,
  sym_labeled_statement = 260,
  sym__top_level_expression_statement = 261,
  sym_expression_statement = 262,
  sym_if_statement = 263,
  sym_else_clause = 264,
  sym_switch_statement = 265,
  sym_case_statement = 266,
  sym_while_statement = 267,
  sym_do_statement = 268,
  sym_for_statement = 269,
  sym__for_statement_body = 270,
  sym_return_statement = 271,
  sym_break_statement = 272,
  sym_continue_statement = 273,
  sym_goto_statement = 274,
  sym_seh_try_statement = 275,
  sym_seh_except_clause = 276,
  sym_seh_finally_clause = 277,
  sym_seh_leave_statement = 278,
  sym_expression = 279,
  sym__string = 280,
  sym_comma_expression = 281,
  sym_conditional_expression = 282,
  sym_assignment_expression = 283,
  sym_pointer_expression = 284,
  sym_unary_expression = 285,
  sym_binary_expression = 286,
  sym_update_expression = 287,
  sym_cast_expression = 288,
  sym_type_descriptor = 289,
  sym_sizeof_expression = 290,
  sym_alignof_expression = 291,
  sym_offsetof_expression = 292,
  sym_generic_expression = 293,
  sym_subscript_expression = 294,
  sym_call_expression = 295,
  sym_gnu_asm_expression = 296,
  sym_gnu_asm_qualifier = 297,
  sym_gnu_asm_output_operand_list = 298,
  sym_gnu_asm_output_operand = 299,
  sym_gnu_asm_input_operand_list = 300,
  sym_gnu_asm_input_operand = 301,
  sym_gnu_asm_clobber_list = 302,
  sym_gnu_asm_goto_list = 303,
  sym_argument_list = 304,
  sym_field_expression = 305,
  sym_compound_literal_expression = 306,
  sym_parenthesized_expression = 307,
  sym_initializer_list = 308,
  sym_initializer_pair = 309,
  sym_subscript_designator = 310,
  sym_subscript_range_designator = 311,
  sym_field_designator = 312,
  sym_char_literal = 313,
  sym_concatenated_string = 314,
  sym_string_literal = 315,
  sym_null = 316,
  sym__empty_declaration = 317,
  sym_macro_type_specifier = 318,
  aux_sym_translation_unit_repeat1 = 319,
  aux_sym_preproc_params_repeat1 = 320,
  aux_sym_preproc_if_repeat1 = 321,
  aux_sym_preproc_if_in_field_declaration_list_repeat1 = 322,
  aux_sym_preproc_if_in_enumerator_list_repeat1 = 323,
  aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1 = 324,
  aux_sym_preproc_argument_list_repeat1 = 325,
  aux_sym__old_style_function_definition_repeat1 = 326,
  aux_sym_declaration_repeat1 = 327,
  aux_sym_type_definition_repeat1 = 328,
  aux_sym__type_definition_type_repeat1 = 329,
  aux_sym__type_definition_declarators_repeat1 = 330,
  aux_sym__declaration_specifiers_repeat1 = 331,
  aux_sym_attribute_declaration_repeat1 = 332,
  aux_sym_attributed_declarator_repeat1 = 333,
  aux_sym_pointer_declarator_repeat1 = 334,
  aux_sym_function_declarator_repeat1 = 335,
  aux_sym_array_declarator_repeat1 = 336,
  aux_sym_sized_type_specifier_repeat1 = 337,
  aux_sym_enumerator_list_repeat1 = 338,
  aux_sym__field_declaration_declarator_repeat1 = 339,
  aux_sym_parameter_list_repeat1 = 340,
  aux_sym__old_style_parameter_list_repeat1 = 341,
  aux_sym_case_statement_repeat1 = 342,
  aux_sym_generic_expression_repeat1 = 343,
  aux_sym_gnu_asm_expression_repeat1 = 344,
  aux_sym_gnu_asm_output_operand_list_repeat1 = 345,
  aux_sym_gnu_asm_input_operand_list_repeat1 = 346,
  aux_sym_gnu_asm_clobber_list_repeat1 = 347,
  aux_sym_gnu_asm_goto_list_repeat1 = 348,
  aux_sym_argument_list_repeat1 = 349,
  aux_sym_initializer_list_repeat1 = 350,
  aux_sym_initializer_pair_repeat1 = 351,
  aux_sym_char_literal_repeat1 = 352,
  aux_sym_concatenated_string_repeat1 = 353,
  aux_sym_string_literal_repeat1 = 354,
  alias_sym_field_identifier = 355,
  alias_sym_statement_identifier = 356,
  alias_sym_type_identifier = 357,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [aux_sym_preproc_include_token1] = "#include",
  [aux_sym_preproc_include_token2] = "preproc_include_token2",
  [aux_sym_preproc_def_token1] = "#define",
  [anon_sym_LPAREN] = "(",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [aux_sym_preproc_if_token1] = "#if",
  [anon_sym_LF] = "\n",
  [aux_sym_preproc_if_token2] = "#endif",
  [aux_sym_preproc_ifdef_token1] = "#ifdef",
  [aux_sym_preproc_ifdef_token2] = "#ifndef",
  [aux_sym_preproc_else_token1] = "#else",
  [aux_sym_preproc_elif_token1] = "#elif",
  [aux_sym_preproc_elifdef_token1] = "#elifdef",
  [aux_sym_preproc_elifdef_token2] = "#elifndef",
  [sym_preproc_arg] = "preproc_arg",
  [sym_preproc_directive] = "preproc_directive",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_defined] = "defined",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_SEMI] = ";",
  [anon_sym___extension__] = "__extension__",
  [anon_sym_typedef] = "typedef",
  [anon_sym_extern] = "extern",
  [anon_sym___attribute__] = "__attribute__",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym___declspec] = "__declspec",
  [anon_sym___based] = "__based",
  [anon_sym___cdecl] = "__cdecl",
  [anon_sym___clrcall] = "__clrcall",
  [anon_sym___stdcall] = "__stdcall",
  [anon_sym___fastcall] = "__fastcall",
  [anon_sym___thiscall] = "__thiscall",
  [anon_sym___vectorcall] = "__vectorcall",
  [sym_ms_restrict_modifier] = "ms_restrict_modifier",
  [sym_ms_unsigned_ptr_modifier] = "ms_unsigned_ptr_modifier",
  [sym_ms_signed_ptr_modifier] = "ms_signed_ptr_modifier",
  [anon_sym__unaligned] = "_unaligned",
  [anon_sym___unaligned] = "__unaligned",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_long] = "long",
  [anon_sym_short] = "short",
  [anon_sym_LBRACK] = "[",
  [anon_sym_static] = "static",
  [anon_sym_RBRACK] = "]",
  [anon_sym_EQ] = "=",
  [anon_sym_auto] = "auto",
  [anon_sym_register] = "register",
  [anon_sym_inline] = "inline",
  [anon_sym___inline] = "__inline",
  [anon_sym___inline__] = "__inline__",
  [anon_sym___forceinline] = "__forceinline",
  [anon_sym_thread_local] = "thread_local",
  [anon_sym___thread] = "__thread",
  [anon_sym_const] = "const",
  [anon_sym_constexpr] = "constexpr",
  [anon_sym_volatile] = "volatile",
  [anon_sym_restrict] = "restrict",
  [anon_sym___restrict__] = "__restrict__",
  [anon_sym__Atomic] = "_Atomic",
  [anon_sym__Noreturn] = "_Noreturn",
  [anon_sym_noreturn] = "noreturn",
  [anon_sym_alignas] = "alignas",
  [anon_sym__Alignas] = "_Alignas",
  [sym_primitive_type] = "primitive_type",
  [anon_sym_enum] = "enum",
  [anon_sym_COLON] = ":",
  [anon_sym_struct] = "struct",
  [anon_sym_union] = "union",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_for] = "for",
  [anon_sym_return] = "return",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_goto] = "goto",
  [anon_sym___try] = "__try",
  [anon_sym___except] = "__except",
  [anon_sym___finally] = "__finally",
  [anon_sym___leave] = "__leave",
  [anon_sym_QMARK] = "\?",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_sizeof] = "sizeof",
  [anon_sym___alignof__] = "__alignof__",
  [anon_sym___alignof] = "__alignof",
  [anon_sym__alignof] = "_alignof",
  [anon_sym_alignof] = "alignof",
  [anon_sym__Alignof] = "_Alignof",
  [anon_sym_offsetof] = "offsetof",
  [anon_sym__Generic] = "_Generic",
  [anon_sym_asm] = "asm",
  [anon_sym___asm__] = "__asm__",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH_GT] = "->",
  [sym_number_literal] = "number_literal",
  [anon_sym_L_SQUOTE] = "L'",
  [anon_sym_u_SQUOTE] = "u'",
  [anon_sym_U_SQUOTE] = "U'",
  [anon_sym_u8_SQUOTE] = "u8'",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_char_literal_token1] = "character",
  [anon_sym_L_DQUOTE] = "L\"",
  [anon_sym_u_DQUOTE] = "u\"",
  [anon_sym_U_DQUOTE] = "U\"",
  [anon_sym_u8_DQUOTE] = "u8\"",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_content",
  [sym_escape_sequence] = "escape_sequence",
  [sym_system_lib_string] = "system_lib_string",
  [sym_true] = "true",
  [sym_false] = "false",
  [anon_sym_NULL] = "NULL",
  [anon_sym_nullptr] = "nullptr",
  [sym_comment] = "comment",
  [sym_translation_unit] = "translation_unit",
  [sym__top_level_item] = "_top_level_item",
  [sym__block_item] = "_block_item",
  [sym_preproc_include] = "preproc_include",
  [sym_preproc_def] = "preproc_def",
  [sym_preproc_function_def] = "preproc_function_def",
  [sym_preproc_params] = "preproc_params",
  [sym_preproc_call] = "preproc_call",
  [sym_preproc_if] = "preproc_if",
  [sym_preproc_ifdef] = "preproc_ifdef",
  [sym_preproc_else] = "preproc_else",
  [sym_preproc_elif] = "preproc_elif",
  [sym_preproc_elifdef] = "preproc_elifdef",
  [sym_preproc_if_in_field_declaration_list] = "preproc_if",
  [sym_preproc_ifdef_in_field_declaration_list] = "preproc_ifdef",
  [sym_preproc_else_in_field_declaration_list] = "preproc_else",
  [sym_preproc_elif_in_field_declaration_list] = "preproc_elif",
  [sym_preproc_elifdef_in_field_declaration_list] = "preproc_elifdef",
  [sym_preproc_if_in_enumerator_list] = "preproc_if",
  [sym_preproc_ifdef_in_enumerator_list] = "preproc_ifdef",
  [sym_preproc_else_in_enumerator_list] = "preproc_else",
  [sym_preproc_elif_in_enumerator_list] = "preproc_elif",
  [sym_preproc_elifdef_in_enumerator_list] = "preproc_elifdef",
  [sym_preproc_if_in_enumerator_list_no_comma] = "preproc_if",
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = "preproc_ifdef",
  [sym_preproc_else_in_enumerator_list_no_comma] = "preproc_else",
  [sym_preproc_elif_in_enumerator_list_no_comma] = "preproc_elif",
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = "preproc_elifdef",
  [sym__preproc_expression] = "_preproc_expression",
  [sym_preproc_parenthesized_expression] = "parenthesized_expression",
  [sym_preproc_defined] = "preproc_defined",
  [sym_preproc_unary_expression] = "unary_expression",
  [sym_preproc_call_expression] = "call_expression",
  [sym_preproc_argument_list] = "argument_list",
  [sym_preproc_binary_expression] = "binary_expression",
  [sym_function_definition] = "function_definition",
  [sym__old_style_function_definition] = "function_definition",
  [sym_declaration] = "declaration",
  [sym_type_definition] = "type_definition",
  [sym__type_definition_type] = "_type_definition_type",
  [sym__type_definition_declarators] = "_type_definition_declarators",
  [sym__declaration_modifiers] = "_declaration_modifiers",
  [sym__declaration_specifiers] = "_declaration_specifiers",
  [sym_linkage_specification] = "linkage_specification",
  [sym_attribute_specifier] = "attribute_specifier",
  [sym_attribute] = "attribute",
  [sym_attribute_declaration] = "attribute_declaration",
  [sym_ms_declspec_modifier] = "ms_declspec_modifier",
  [sym_ms_based_modifier] = "ms_based_modifier",
  [sym_ms_call_modifier] = "ms_call_modifier",
  [sym_ms_unaligned_ptr_modifier] = "ms_unaligned_ptr_modifier",
  [sym_ms_pointer_modifier] = "ms_pointer_modifier",
  [sym_declaration_list] = "declaration_list",
  [sym__declarator] = "_declarator",
  [sym__declaration_declarator] = "_declaration_declarator",
  [sym__field_declarator] = "_field_declarator",
  [sym__type_declarator] = "_type_declarator",
  [sym__abstract_declarator] = "_abstract_declarator",
  [sym_parenthesized_declarator] = "parenthesized_declarator",
  [sym_parenthesized_field_declarator] = "parenthesized_declarator",
  [sym_parenthesized_type_declarator] = "parenthesized_declarator",
  [sym_abstract_parenthesized_declarator] = "abstract_parenthesized_declarator",
  [sym_attributed_declarator] = "attributed_declarator",
  [sym_attributed_field_declarator] = "attributed_declarator",
  [sym_attributed_type_declarator] = "attributed_declarator",
  [sym_pointer_declarator] = "pointer_declarator",
  [sym_pointer_field_declarator] = "pointer_declarator",
  [sym_pointer_type_declarator] = "pointer_declarator",
  [sym_abstract_pointer_declarator] = "abstract_pointer_declarator",
  [sym_function_declarator] = "function_declarator",
  [sym__function_declaration_declarator] = "function_declarator",
  [sym_function_field_declarator] = "function_declarator",
  [sym_function_type_declarator] = "function_declarator",
  [sym_abstract_function_declarator] = "abstract_function_declarator",
  [sym__old_style_function_declarator] = "function_declarator",
  [sym_array_declarator] = "array_declarator",
  [sym_array_field_declarator] = "array_declarator",
  [sym_array_type_declarator] = "array_declarator",
  [sym_abstract_array_declarator] = "abstract_array_declarator",
  [sym_init_declarator] = "init_declarator",
  [sym_compound_statement] = "compound_statement",
  [sym_storage_class_specifier] = "storage_class_specifier",
  [sym_type_qualifier] = "type_qualifier",
  [sym_alignas_qualifier] = "alignas_qualifier",
  [sym_type_specifier] = "type_specifier",
  [sym_sized_type_specifier] = "sized_type_specifier",
  [sym_enum_specifier] = "enum_specifier",
  [sym_enumerator_list] = "enumerator_list",
  [sym_struct_specifier] = "struct_specifier",
  [sym_union_specifier] = "union_specifier",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym__field_declaration_list_item] = "_field_declaration_list_item",
  [sym_field_declaration] = "field_declaration",
  [sym__field_declaration_declarator] = "_field_declaration_declarator",
  [sym_bitfield_clause] = "bitfield_clause",
  [sym_enumerator] = "enumerator",
  [sym_variadic_parameter] = "variadic_parameter",
  [sym_parameter_list] = "parameter_list",
  [sym__old_style_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_attributed_statement] = "attributed_statement",
  [sym_statement] = "statement",
  [sym__top_level_statement] = "_top_level_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym__top_level_expression_statement] = "expression_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_clause] = "else_clause",
  [sym_switch_statement] = "switch_statement",
  [sym_case_statement] = "case_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_for_statement] = "for_statement",
  [sym__for_statement_body] = "_for_statement_body",
  [sym_return_statement] = "return_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_seh_try_statement] = "seh_try_statement",
  [sym_seh_except_clause] = "seh_except_clause",
  [sym_seh_finally_clause] = "seh_finally_clause",
  [sym_seh_leave_statement] = "seh_leave_statement",
  [sym_expression] = "expression",
  [sym__string] = "_string",
  [sym_comma_expression] = "comma_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_pointer_expression] = "pointer_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_update_expression] = "update_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_type_descriptor] = "type_descriptor",
  [sym_sizeof_expression] = "sizeof_expression",
  [sym_alignof_expression] = "alignof_expression",
  [sym_offsetof_expression] = "offsetof_expression",
  [sym_generic_expression] = "generic_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_call_expression] = "call_expression",
  [sym_gnu_asm_expression] = "gnu_asm_expression",
  [sym_gnu_asm_qualifier] = "gnu_asm_qualifier",
  [sym_gnu_asm_output_operand_list] = "gnu_asm_output_operand_list",
  [sym_gnu_asm_output_operand] = "gnu_asm_output_operand",
  [sym_gnu_asm_input_operand_list] = "gnu_asm_input_operand_list",
  [sym_gnu_asm_input_operand] = "gnu_asm_input_operand",
  [sym_gnu_asm_clobber_list] = "gnu_asm_clobber_list",
  [sym_gnu_asm_goto_list] = "gnu_asm_goto_list",
  [sym_argument_list] = "argument_list",
  [sym_field_expression] = "field_expression",
  [sym_compound_literal_expression] = "compound_literal_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_initializer_list] = "initializer_list",
  [sym_initializer_pair] = "initializer_pair",
  [sym_subscript_designator] = "subscript_designator",
  [sym_subscript_range_designator] = "subscript_range_designator",
  [sym_field_designator] = "field_designator",
  [sym_char_literal] = "char_literal",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string_literal] = "string_literal",
  [sym_null] = "null",
  [sym__empty_declaration] = "_empty_declaration",
  [sym_macro_type_specifier] = "macro_type_specifier",
  [aux_sym_translation_unit_repeat1] = "translation_unit_repeat1",
  [aux_sym_preproc_params_repeat1] = "preproc_params_repeat1",
  [aux_sym_preproc_if_repeat1] = "preproc_if_repeat1",
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = "preproc_if_in_field_declaration_list_repeat1",
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = "preproc_if_in_enumerator_list_repeat1",
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = "preproc_if_in_enumerator_list_no_comma_repeat1",
  [aux_sym_preproc_argument_list_repeat1] = "preproc_argument_list_repeat1",
  [aux_sym__old_style_function_definition_repeat1] = "_old_style_function_definition_repeat1",
  [aux_sym_declaration_repeat1] = "declaration_repeat1",
  [aux_sym_type_definition_repeat1] = "type_definition_repeat1",
  [aux_sym__type_definition_type_repeat1] = "_type_definition_type_repeat1",
  [aux_sym__type_definition_declarators_repeat1] = "_type_definition_declarators_repeat1",
  [aux_sym__declaration_specifiers_repeat1] = "_declaration_specifiers_repeat1",
  [aux_sym_attribute_declaration_repeat1] = "attribute_declaration_repeat1",
  [aux_sym_attributed_declarator_repeat1] = "attributed_declarator_repeat1",
  [aux_sym_pointer_declarator_repeat1] = "pointer_declarator_repeat1",
  [aux_sym_function_declarator_repeat1] = "function_declarator_repeat1",
  [aux_sym_array_declarator_repeat1] = "array_declarator_repeat1",
  [aux_sym_sized_type_specifier_repeat1] = "sized_type_specifier_repeat1",
  [aux_sym_enumerator_list_repeat1] = "enumerator_list_repeat1",
  [aux_sym__field_declaration_declarator_repeat1] = "_field_declaration_declarator_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym__old_style_parameter_list_repeat1] = "_old_style_parameter_list_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_generic_expression_repeat1] = "generic_expression_repeat1",
  [aux_sym_gnu_asm_expression_repeat1] = "gnu_asm_expression_repeat1",
  [aux_sym_gnu_asm_output_operand_list_repeat1] = "gnu_asm_output_operand_list_repeat1",
  [aux_sym_gnu_asm_input_operand_list_repeat1] = "gnu_asm_input_operand_list_repeat1",
  [aux_sym_gnu_asm_clobber_list_repeat1] = "gnu_asm_clobber_list_repeat1",
  [aux_sym_gnu_asm_goto_list_repeat1] = "gnu_asm_goto_list_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_initializer_list_repeat1] = "initializer_list_repeat1",
  [aux_sym_initializer_pair_repeat1] = "initializer_pair_repeat1",
  [aux_sym_char_literal_repeat1] = "char_literal_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [aux_sym_preproc_include_token1] = aux_sym_preproc_include_token1,
  [aux_sym_preproc_include_token2] = aux_sym_preproc_include_token2,
  [aux_sym_preproc_def_token1] = aux_sym_preproc_def_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_preproc_if_token1] = aux_sym_preproc_if_token1,
  [anon_sym_LF] = anon_sym_LF,
  [aux_sym_preproc_if_token2] = aux_sym_preproc_if_token2,
  [aux_sym_preproc_ifdef_token1] = aux_sym_preproc_ifdef_token1,
  [aux_sym_preproc_ifdef_token2] = aux_sym_preproc_ifdef_token2,
  [aux_sym_preproc_else_token1] = aux_sym_preproc_else_token1,
  [aux_sym_preproc_elif_token1] = aux_sym_preproc_elif_token1,
  [aux_sym_preproc_elifdef_token1] = aux_sym_preproc_elifdef_token1,
  [aux_sym_preproc_elifdef_token2] = aux_sym_preproc_elifdef_token2,
  [sym_preproc_arg] = sym_preproc_arg,
  [sym_preproc_directive] = sym_preproc_directive,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_defined] = anon_sym_defined,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym___extension__] = anon_sym___extension__,
  [anon_sym_typedef] = anon_sym_typedef,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym___attribute__] = anon_sym___attribute__,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym___declspec] = anon_sym___declspec,
  [anon_sym___based] = anon_sym___based,
  [anon_sym___cdecl] = anon_sym___cdecl,
  [anon_sym___clrcall] = anon_sym___clrcall,
  [anon_sym___stdcall] = anon_sym___stdcall,
  [anon_sym___fastcall] = anon_sym___fastcall,
  [anon_sym___thiscall] = anon_sym___thiscall,
  [anon_sym___vectorcall] = anon_sym___vectorcall,
  [sym_ms_restrict_modifier] = sym_ms_restrict_modifier,
  [sym_ms_unsigned_ptr_modifier] = sym_ms_unsigned_ptr_modifier,
  [sym_ms_signed_ptr_modifier] = sym_ms_signed_ptr_modifier,
  [anon_sym__unaligned] = anon_sym__unaligned,
  [anon_sym___unaligned] = anon_sym___unaligned,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_auto] = anon_sym_auto,
  [anon_sym_register] = anon_sym_register,
  [anon_sym_inline] = anon_sym_inline,
  [anon_sym___inline] = anon_sym___inline,
  [anon_sym___inline__] = anon_sym___inline__,
  [anon_sym___forceinline] = anon_sym___forceinline,
  [anon_sym_thread_local] = anon_sym_thread_local,
  [anon_sym___thread] = anon_sym___thread,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_constexpr] = anon_sym_constexpr,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_restrict] = anon_sym_restrict,
  [anon_sym___restrict__] = anon_sym___restrict__,
  [anon_sym__Atomic] = anon_sym__Atomic,
  [anon_sym__Noreturn] = anon_sym__Noreturn,
  [anon_sym_noreturn] = anon_sym_noreturn,
  [anon_sym_alignas] = anon_sym_alignas,
  [anon_sym__Alignas] = anon_sym__Alignas,
  [sym_primitive_type] = sym_primitive_type,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym___try] = anon_sym___try,
  [anon_sym___except] = anon_sym___except,
  [anon_sym___finally] = anon_sym___finally,
  [anon_sym___leave] = anon_sym___leave,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_sizeof] = anon_sym_sizeof,
  [anon_sym___alignof__] = anon_sym___alignof__,
  [anon_sym___alignof] = anon_sym___alignof,
  [anon_sym__alignof] = anon_sym__alignof,
  [anon_sym_alignof] = anon_sym_alignof,
  [anon_sym__Alignof] = anon_sym__Alignof,
  [anon_sym_offsetof] = anon_sym_offsetof,
  [anon_sym__Generic] = anon_sym__Generic,
  [anon_sym_asm] = anon_sym_asm,
  [anon_sym___asm__] = anon_sym___asm__,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [sym_number_literal] = sym_number_literal,
  [anon_sym_L_SQUOTE] = anon_sym_L_SQUOTE,
  [anon_sym_u_SQUOTE] = anon_sym_u_SQUOTE,
  [anon_sym_U_SQUOTE] = anon_sym_U_SQUOTE,
  [anon_sym_u8_SQUOTE] = anon_sym_u8_SQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_char_literal_token1] = aux_sym_char_literal_token1,
  [anon_sym_L_DQUOTE] = anon_sym_L_DQUOTE,
  [anon_sym_u_DQUOTE] = anon_sym_u_DQUOTE,
  [anon_sym_U_DQUOTE] = anon_sym_U_DQUOTE,
  [anon_sym_u8_DQUOTE] = anon_sym_u8_DQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_system_lib_string] = sym_system_lib_string,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [anon_sym_NULL] = anon_sym_NULL,
  [anon_sym_nullptr] = anon_sym_nullptr,
  [sym_comment] = sym_comment,
  [sym_translation_unit] = sym_translation_unit,
  [sym__top_level_item] = sym__top_level_item,
  [sym__block_item] = sym__block_item,
  [sym_preproc_include] = sym_preproc_include,
  [sym_preproc_def] = sym_preproc_def,
  [sym_preproc_function_def] = sym_preproc_function_def,
  [sym_preproc_params] = sym_preproc_params,
  [sym_preproc_call] = sym_preproc_call,
  [sym_preproc_if] = sym_preproc_if,
  [sym_preproc_ifdef] = sym_preproc_ifdef,
  [sym_preproc_else] = sym_preproc_else,
  [sym_preproc_elif] = sym_preproc_elif,
  [sym_preproc_elifdef] = sym_preproc_elifdef,
  [sym_preproc_if_in_field_declaration_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_field_declaration_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_field_declaration_list] = sym_preproc_else,
  [sym_preproc_elif_in_field_declaration_list] = sym_preproc_elif,
  [sym_preproc_elifdef_in_field_declaration_list] = sym_preproc_elifdef,
  [sym_preproc_if_in_enumerator_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_enumerator_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_enumerator_list] = sym_preproc_else,
  [sym_preproc_elif_in_enumerator_list] = sym_preproc_elif,
  [sym_preproc_elifdef_in_enumerator_list] = sym_preproc_elifdef,
  [sym_preproc_if_in_enumerator_list_no_comma] = sym_preproc_if,
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = sym_preproc_ifdef,
  [sym_preproc_else_in_enumerator_list_no_comma] = sym_preproc_else,
  [sym_preproc_elif_in_enumerator_list_no_comma] = sym_preproc_elif,
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = sym_preproc_elifdef,
  [sym__preproc_expression] = sym__preproc_expression,
  [sym_preproc_parenthesized_expression] = sym_parenthesized_expression,
  [sym_preproc_defined] = sym_preproc_defined,
  [sym_preproc_unary_expression] = sym_unary_expression,
  [sym_preproc_call_expression] = sym_call_expression,
  [sym_preproc_argument_list] = sym_argument_list,
  [sym_preproc_binary_expression] = sym_binary_expression,
  [sym_function_definition] = sym_function_definition,
  [sym__old_style_function_definition] = sym_function_definition,
  [sym_declaration] = sym_declaration,
  [sym_type_definition] = sym_type_definition,
  [sym__type_definition_type] = sym__type_definition_type,
  [sym__type_definition_declarators] = sym__type_definition_declarators,
  [sym__declaration_modifiers] = sym__declaration_modifiers,
  [sym__declaration_specifiers] = sym__declaration_specifiers,
  [sym_linkage_specification] = sym_linkage_specification,
  [sym_attribute_specifier] = sym_attribute_specifier,
  [sym_attribute] = sym_attribute,
  [sym_attribute_declaration] = sym_attribute_declaration,
  [sym_ms_declspec_modifier] = sym_ms_declspec_modifier,
  [sym_ms_based_modifier] = sym_ms_based_modifier,
  [sym_ms_call_modifier] = sym_ms_call_modifier,
  [sym_ms_unaligned_ptr_modifier] = sym_ms_unaligned_ptr_modifier,
  [sym_ms_pointer_modifier] = sym_ms_pointer_modifier,
  [sym_declaration_list] = sym_declaration_list,
  [sym__declarator] = sym__declarator,
  [sym__declaration_declarator] = sym__declaration_declarator,
  [sym__field_declarator] = sym__field_declarator,
  [sym__type_declarator] = sym__type_declarator,
  [sym__abstract_declarator] = sym__abstract_declarator,
  [sym_parenthesized_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_field_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_type_declarator] = sym_parenthesized_declarator,
  [sym_abstract_parenthesized_declarator] = sym_abstract_parenthesized_declarator,
  [sym_attributed_declarator] = sym_attributed_declarator,
  [sym_attributed_field_declarator] = sym_attributed_declarator,
  [sym_attributed_type_declarator] = sym_attributed_declarator,
  [sym_pointer_declarator] = sym_pointer_declarator,
  [sym_pointer_field_declarator] = sym_pointer_declarator,
  [sym_pointer_type_declarator] = sym_pointer_declarator,
  [sym_abstract_pointer_declarator] = sym_abstract_pointer_declarator,
  [sym_function_declarator] = sym_function_declarator,
  [sym__function_declaration_declarator] = sym_function_declarator,
  [sym_function_field_declarator] = sym_function_declarator,
  [sym_function_type_declarator] = sym_function_declarator,
  [sym_abstract_function_declarator] = sym_abstract_function_declarator,
  [sym__old_style_function_declarator] = sym_function_declarator,
  [sym_array_declarator] = sym_array_declarator,
  [sym_array_field_declarator] = sym_array_declarator,
  [sym_array_type_declarator] = sym_array_declarator,
  [sym_abstract_array_declarator] = sym_abstract_array_declarator,
  [sym_init_declarator] = sym_init_declarator,
  [sym_compound_statement] = sym_compound_statement,
  [sym_storage_class_specifier] = sym_storage_class_specifier,
  [sym_type_qualifier] = sym_type_qualifier,
  [sym_alignas_qualifier] = sym_alignas_qualifier,
  [sym_type_specifier] = sym_type_specifier,
  [sym_sized_type_specifier] = sym_sized_type_specifier,
  [sym_enum_specifier] = sym_enum_specifier,
  [sym_enumerator_list] = sym_enumerator_list,
  [sym_struct_specifier] = sym_struct_specifier,
  [sym_union_specifier] = sym_union_specifier,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym__field_declaration_list_item] = sym__field_declaration_list_item,
  [sym_field_declaration] = sym_field_declaration,
  [sym__field_declaration_declarator] = sym__field_declaration_declarator,
  [sym_bitfield_clause] = sym_bitfield_clause,
  [sym_enumerator] = sym_enumerator,
  [sym_variadic_parameter] = sym_variadic_parameter,
  [sym_parameter_list] = sym_parameter_list,
  [sym__old_style_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_attributed_statement] = sym_attributed_statement,
  [sym_statement] = sym_statement,
  [sym__top_level_statement] = sym__top_level_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym__top_level_expression_statement] = sym_expression_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_clause] = sym_else_clause,
  [sym_switch_statement] = sym_switch_statement,
  [sym_case_statement] = sym_case_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_for_statement] = sym_for_statement,
  [sym__for_statement_body] = sym__for_statement_body,
  [sym_return_statement] = sym_return_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_seh_try_statement] = sym_seh_try_statement,
  [sym_seh_except_clause] = sym_seh_except_clause,
  [sym_seh_finally_clause] = sym_seh_finally_clause,
  [sym_seh_leave_statement] = sym_seh_leave_statement,
  [sym_expression] = sym_expression,
  [sym__string] = sym__string,
  [sym_comma_expression] = sym_comma_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_pointer_expression] = sym_pointer_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_type_descriptor] = sym_type_descriptor,
  [sym_sizeof_expression] = sym_sizeof_expression,
  [sym_alignof_expression] = sym_alignof_expression,
  [sym_offsetof_expression] = sym_offsetof_expression,
  [sym_generic_expression] = sym_generic_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_gnu_asm_expression] = sym_gnu_asm_expression,
  [sym_gnu_asm_qualifier] = sym_gnu_asm_qualifier,
  [sym_gnu_asm_output_operand_list] = sym_gnu_asm_output_operand_list,
  [sym_gnu_asm_output_operand] = sym_gnu_asm_output_operand,
  [sym_gnu_asm_input_operand_list] = sym_gnu_asm_input_operand_list,
  [sym_gnu_asm_input_operand] = sym_gnu_asm_input_operand,
  [sym_gnu_asm_clobber_list] = sym_gnu_asm_clobber_list,
  [sym_gnu_asm_goto_list] = sym_gnu_asm_goto_list,
  [sym_argument_list] = sym_argument_list,
  [sym_field_expression] = sym_field_expression,
  [sym_compound_literal_expression] = sym_compound_literal_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_initializer_list] = sym_initializer_list,
  [sym_initializer_pair] = sym_initializer_pair,
  [sym_subscript_designator] = sym_subscript_designator,
  [sym_subscript_range_designator] = sym_subscript_range_designator,
  [sym_field_designator] = sym_field_designator,
  [sym_char_literal] = sym_char_literal,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string_literal] = sym_string_literal,
  [sym_null] = sym_null,
  [sym__empty_declaration] = sym__empty_declaration,
  [sym_macro_type_specifier] = sym_macro_type_specifier,
  [aux_sym_translation_unit_repeat1] = aux_sym_translation_unit_repeat1,
  [aux_sym_preproc_params_repeat1] = aux_sym_preproc_params_repeat1,
  [aux_sym_preproc_if_repeat1] = aux_sym_preproc_if_repeat1,
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = aux_sym_preproc_if_in_field_declaration_list_repeat1,
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = aux_sym_preproc_if_in_enumerator_list_repeat1,
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1,
  [aux_sym_preproc_argument_list_repeat1] = aux_sym_preproc_argument_list_repeat1,
  [aux_sym__old_style_function_definition_repeat1] = aux_sym__old_style_function_definition_repeat1,
  [aux_sym_declaration_repeat1] = aux_sym_declaration_repeat1,
  [aux_sym_type_definition_repeat1] = aux_sym_type_definition_repeat1,
  [aux_sym__type_definition_type_repeat1] = aux_sym__type_definition_type_repeat1,
  [aux_sym__type_definition_declarators_repeat1] = aux_sym__type_definition_declarators_repeat1,
  [aux_sym__declaration_specifiers_repeat1] = aux_sym__declaration_specifiers_repeat1,
  [aux_sym_attribute_declaration_repeat1] = aux_sym_attribute_declaration_repeat1,
  [aux_sym_attributed_declarator_repeat1] = aux_sym_attributed_declarator_repeat1,
  [aux_sym_pointer_declarator_repeat1] = aux_sym_pointer_declarator_repeat1,
  [aux_sym_function_declarator_repeat1] = aux_sym_function_declarator_repeat1,
  [aux_sym_array_declarator_repeat1] = aux_sym_array_declarator_repeat1,
  [aux_sym_sized_type_specifier_repeat1] = aux_sym_sized_type_specifier_repeat1,
  [aux_sym_enumerator_list_repeat1] = aux_sym_enumerator_list_repeat1,
  [aux_sym__field_declaration_declarator_repeat1] = aux_sym__field_declaration_declarator_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym__old_style_parameter_list_repeat1] = aux_sym__old_style_parameter_list_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym_generic_expression_repeat1] = aux_sym_generic_expression_repeat1,
  [aux_sym_gnu_asm_expression_repeat1] = aux_sym_gnu_asm_expression_repeat1,
  [aux_sym_gnu_asm_output_operand_list_repeat1] = aux_sym_gnu_asm_output_operand_list_repeat1,
  [aux_sym_gnu_asm_input_operand_list_repeat1] = aux_sym_gnu_asm_input_operand_list_repeat1,
  [aux_sym_gnu_asm_clobber_list_repeat1] = aux_sym_gnu_asm_clobber_list_repeat1,
  [aux_sym_gnu_asm_goto_list_repeat1] = aux_sym_gnu_asm_goto_list_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_initializer_list_repeat1] = aux_sym_initializer_list_repeat1,
  [aux_sym_initializer_pair_repeat1] = aux_sym_initializer_pair_repeat1,
  [aux_sym_char_literal_repeat1] = aux_sym_char_literal_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_preproc_include_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_include_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_def_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_else_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elif_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [sym_preproc_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_directive] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defined] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___extension__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___attribute__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___declspec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___based] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___cdecl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___clrcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___stdcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___fastcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thiscall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___vectorcall] = {
    .visible = true,
    .named = false,
  },
  [sym_ms_restrict_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unsigned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_signed_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_auto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_register] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___inline__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___forceinline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thread_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thread] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constexpr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_restrict] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___restrict__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Atomic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Noreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alignas] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Alignas] = {
    .visible = true,
    .named = false,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___leave] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sizeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___alignof__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_offsetof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Generic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___asm__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_char_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_system_lib_string] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nullptr] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_translation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_item] = {
    .visible = false,
    .named = true,
  },
  [sym__block_item] = {
    .visible = false,
    .named = true,
  },
  [sym_preproc_include] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_params] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym__preproc_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_preproc_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_defined] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__type_definition_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_definition_declarators] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_modifiers] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_linkage_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_declspec_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_based_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_call_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unaligned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_pointer_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__declaration_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym__field_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__type_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__abstract_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__function_declaration_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_init_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_class_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_alignas_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_specifier] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_sized_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_union_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_list_item] = {
    .visible = false,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_bitfield_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__top_level_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_statement_body] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_leave_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__string] = {
    .visible = false,
    .named = true,
  },
  [sym_comma_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym_sizeof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_alignof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_offsetof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_clobber_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_goto_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_literal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_range_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_field_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_char_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_macro_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_translation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__old_style_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_definition_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_definition_declarators_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__declaration_specifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attributed_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pointer_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sized_type_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__field_declaration_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__old_style_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_output_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_input_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_clobber_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_goto_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_pair_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_char_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_assembly_code = 4,
  field_body = 5,
  field_clobbers = 6,
  field_condition = 7,
  field_consequence = 8,
  field_constraint = 9,
  field_declarator = 10,
  field_designator = 11,
  field_directive = 12,
  field_end = 13,
  field_field = 14,
  field_filter = 15,
  field_function = 16,
  field_goto_labels = 17,
  field_index = 18,
  field_initializer = 19,
  field_input_operands = 20,
  field_label = 21,
  field_left = 22,
  field_member = 23,
  field_name = 24,
  field_operand = 25,
  field_operator = 26,
  field_output_operands = 27,
  field_parameters = 28,
  field_path = 29,
  field_prefix = 30,
  field_register = 31,
  field_right = 32,
  field_size = 33,
  field_start = 34,
  field_symbol = 35,
  field_type = 36,
  field_underlying_type = 37,
  field_update = 38,
  field_value = 39,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_assembly_code] = "assembly_code",
  [field_body] = "body",
  [field_clobbers] = "clobbers",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_declarator] = "declarator",
  [field_designator] = "designator",
  [field_directive] = "directive",
  [field_end] = "end",
  [field_field] = "field",
  [field_filter] = "filter",
  [field_function] = "function",
  [field_goto_labels] = "goto_labels",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_input_operands] = "input_operands",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_output_operands] = "output_operands",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_prefix] = "prefix",
  [field_register] = "register",
  [field_right] = "right",
  [field_size] = "size",
  [field_start] = "start",
  [field_symbol] = "symbol",
  [field_type] = "type",
  [field_underlying_type] = "underlying_type",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 3},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 1},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 1},
  [10] = {.index = 3, .length = 1},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 2},
  [14] = {.index = 17, .length = 1},
  [15] = {.index = 17, .length = 1},
  [16] = {.index = 18, .length = 1},
  [17] = {.index = 8, .length = 1},
  [18] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 2},
  [20] = {.index = 23, .length = 1},
  [22] = {.index = 24, .length = 1},
  [23] = {.index = 25, .length = 2},
  [24] = {.index = 27, .length = 2},
  [25] = {.index = 29, .length = 1},
  [26] = {.index = 30, .length = 1},
  [27] = {.index = 31, .length = 2},
  [28] = {.index = 33, .length = 2},
  [29] = {.index = 35, .length = 1},
  [30] = {.index = 36, .length = 3},
  [31] = {.index = 39, .length = 1},
  [32] = {.index = 40, .length = 1},
  [33] = {.index = 41, .length = 3},
  [34] = {.index = 44, .length = 2},
  [35] = {.index = 46, .length = 2},
  [36] = {.index = 48, .length = 5},
  [37] = {.index = 53, .length = 3},
  [38] = {.index = 56, .length = 2},
  [39] = {.index = 58, .length = 2},
  [40] = {.index = 60, .length = 1},
  [41] = {.index = 61, .length = 2},
  [42] = {.index = 63, .length = 1},
  [43] = {.index = 64, .length = 2},
  [44] = {.index = 66, .length = 2},
  [45] = {.index = 68, .length = 2},
  [46] = {.index = 70, .length = 2},
  [47] = {.index = 72, .length = 2},
  [48] = {.index = 74, .length = 2},
  [49] = {.index = 76, .length = 2},
  [50] = {.index = 78, .length = 2},
  [52] = {.index = 80, .length = 2},
  [53] = {.index = 82, .length = 1},
  [54] = {.index = 83, .length = 1},
  [55] = {.index = 84, .length = 3},
  [56] = {.index = 87, .length = 1},
  [57] = {.index = 88, .length = 1},
  [58] = {.index = 89, .length = 1},
  [59] = {.index = 90, .length = 2},
  [60] = {.index = 92, .length = 1},
  [61] = {.index = 93, .length = 3},
  [62] = {.index = 96, .length = 3},
  [63] = {.index = 99, .length = 2},
  [64] = {.index = 101, .length = 3},
  [65] = {.index = 104, .length = 2},
  [66] = {.index = 106, .length = 5},
  [67] = {.index = 111, .length = 3},
  [68] = {.index = 114, .length = 5},
  [69] = {.index = 119, .length = 2},
  [70] = {.index = 121, .length = 2},
  [71] = {.index = 123, .length = 3},
  [72] = {.index = 126, .length = 2},
  [73] = {.index = 128, .length = 2},
  [74] = {.index = 130, .length = 1},
  [75] = {.index = 131, .length = 2},
  [76] = {.index = 133, .length = 2},
  [77] = {.index = 135, .length = 2},
  [78] = {.index = 137, .length = 3},
  [79] = {.index = 140, .length = 2},
  [80] = {.index = 142, .length = 2},
  [81] = {.index = 144, .length = 2},
  [82] = {.index = 146, .length = 1},
  [83] = {.index = 147, .length = 2},
  [84] = {.index = 149, .length = 2},
  [85] = {.index = 151, .length = 4},
  [86] = {.index = 155, .length = 1},
  [87] = {.index = 156, .length = 2},
  [88] = {.index = 158, .length = 1},
  [89] = {.index = 159, .length = 1},
  [90] = {.index = 160, .length = 4},
  [91] = {.index = 164, .length = 4},
  [92] = {.index = 168, .length = 2},
  [93] = {.index = 170, .length = 2},
  [94] = {.index = 172, .length = 3},
  [95] = {.index = 175, .length = 5},
  [96] = {.index = 180, .length = 3},
  [97] = {.index = 183, .length = 2},
  [98] = {.index = 185, .length = 1},
  [100] = {.index = 186, .length = 2},
  [101] = {.index = 188, .length = 2},
  [102] = {.index = 190, .length = 2},
  [103] = {.index = 192, .length = 3},
  [104] = {.index = 195, .length = 2},
  [105] = {.index = 197, .length = 2},
  [106] = {.index = 199, .length = 2},
  [107] = {.index = 201, .length = 2},
  [108] = {.index = 203, .length = 3},
  [109] = {.index = 206, .length = 2},
  [110] = {.index = 208, .length = 1},
  [111] = {.index = 209, .length = 5},
  [112] = {.index = 214, .length = 2},
  [113] = {.index = 216, .length = 3},
  [114] = {.index = 219, .length = 2},
  [115] = {.index = 219, .length = 2},
  [116] = {.index = 221, .length = 3},
  [117] = {.index = 224, .length = 2},
  [118] = {.index = 226, .length = 1},
  [119] = {.index = 227, .length = 4},
  [120] = {.index = 231, .length = 3},
  [121] = {.index = 234, .length = 2},
  [122] = {.index = 236, .length = 2},
  [123] = {.index = 35, .length = 1},
  [124] = {.index = 238, .length = 5},
  [125] = {.index = 243, .length = 4},
  [126] = {.index = 247, .length = 2},
  [127] = {.index = 249, .length = 2},
  [128] = {.index = 251, .length = 2},
  [129] = {.index = 253, .length = 5},
  [130] = {.index = 258, .length = 2},
  [131] = {.index = 260, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 0, .inherited = true},
    {field_declarator, 0, .inherited = true},
    {field_type, 0, .inherited = true},
  [3] =
    {field_type, 0},
  [4] =
    {field_directive, 0},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_name, 0},
  [8] =
    {field_name, 1},
  [9] =
    {field_body, 1},
  [10] =
    {field_value, 1},
  [11] =
    {field_declarator, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
  [13] =
    {field_argument, 0},
    {field_operator, 1},
  [15] =
    {field_arguments, 1},
    {field_function, 0},
  [17] =
    {field_type, 1},
  [18] =
    {field_path, 1},
  [19] =
    {field_argument, 1},
    {field_directive, 0},
  [21] =
    {field_declarator, 1},
    {field_type, 0},
  [23] =
    {field_parameters, 0},
  [24] =
    {field_declarator, 0},
  [25] =
    {field_body, 2},
    {field_value, 1},
  [27] =
    {field_body, 2},
    {field_name, 1},
  [29] =
    {field_name, 2},
  [30] =
    {field_body, 2},
  [31] =
    {field_condition, 1},
    {field_consequence, 2},
  [33] =
    {field_body, 2},
    {field_condition, 1},
  [35] =
    {field_label, 1},
  [36] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [39] =
    {field_label, 0},
  [40] =
    {field_declarator, 1},
  [41] =
    {field_body, 2},
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [44] =
    {field_declarator, 0},
    {field_parameters, 1},
  [46] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [48] =
    {field_body, 2},
    {field_declarator, 1},
    {field_declarator, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [53] =
    {field_argument, 0},
    {field_field, 2},
    {field_operator, 1},
  [56] =
    {field_name, 1},
    {field_value, 2},
  [58] =
    {field_name, 1},
    {field_parameters, 2},
  [60] =
    {field_condition, 1},
  [61] =
    {field_alternative, 2},
    {field_name, 1},
  [63] =
    {field_type, 0, .inherited = true},
  [64] =
    {field_declarator, 2},
    {field_type, 0},
  [66] =
    {field_left, 0},
    {field_right, 2},
  [68] =
    {field_type, 1},
    {field_value, 3},
  [70] =
    {field_declarator, 2},
    {field_type, 1},
  [72] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [74] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [76] =
    {field_name, 2},
    {field_prefix, 0},
  [78] =
    {field_name, 1},
    {field_underlying_type, 3},
  [80] =
    {field_body, 3},
    {field_name, 2},
  [82] =
    {field_name, 3},
  [83] =
    {field_body, 3},
  [84] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [87] =
    {field_initializer, 0},
  [88] =
    {field_type, 2},
  [89] =
    {field_assembly_code, 2},
  [90] =
    {field_name, 0},
    {field_type, 2},
  [92] =
    {field_declarator, 2},
  [93] =
    {field_body, 3},
    {field_declarator, 2},
    {field_type, 0, .inherited = true},
  [96] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_type, 0, .inherited = true},
  [99] =
    {field_declarator, 0},
    {field_value, 2},
  [101] =
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
    {field_type, 0, .inherited = true},
  [104] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [106] =
    {field_body, 3},
    {field_declarator, 1},
    {field_declarator, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [111] =
    {field_body, 3},
    {field_declarator, 2},
    {field_type, 1, .inherited = true},
  [114] =
    {field_body, 3},
    {field_declarator, 2},
    {field_declarator, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [119] =
    {field_argument, 0},
    {field_index, 2},
  [121] =
    {field_alternative, 3},
    {field_condition, 0},
  [123] =
    {field_name, 1},
    {field_parameters, 2},
    {field_value, 3},
  [126] =
    {field_alternative, 3},
    {field_condition, 1},
  [128] =
    {field_alternative, 3},
    {field_name, 1},
  [130] =
    {field_size, 1},
  [131] =
    {field_declarator, 3},
    {field_type, 1},
  [133] =
    {field_declarator, 3, .inherited = true},
    {field_type, 2, .inherited = true},
  [135] =
    {field_name, 0},
    {field_value, 2},
  [137] =
    {field_body, 4},
    {field_name, 1},
    {field_underlying_type, 3},
  [140] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [142] =
    {field_body, 4},
    {field_name, 3},
  [144] =
    {field_body, 1},
    {field_condition, 3},
  [146] =
    {field_update, 2},
  [147] =
    {field_initializer, 0},
    {field_update, 2},
  [149] =
    {field_condition, 1},
    {field_initializer, 0},
  [151] =
    {field_body, 4},
    {field_condition, 2, .inherited = true},
    {field_initializer, 2, .inherited = true},
    {field_update, 2, .inherited = true},
  [155] =
    {field_operand, 1},
  [156] =
    {field_assembly_code, 2},
    {field_output_operands, 3},
  [158] =
    {field_assembly_code, 3},
  [159] =
    {field_declarator, 3},
  [160] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3},
    {field_type, 0, .inherited = true},
  [164] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3, .inherited = true},
    {field_type, 0, .inherited = true},
  [168] =
    {field_declarator, 0},
    {field_size, 2},
  [170] =
    {field_declarator, 1},
    {field_declarator, 2},
  [172] =
    {field_body, 4},
    {field_declarator, 3},
    {field_type, 1, .inherited = true},
  [175] =
    {field_body, 4},
    {field_declarator, 2},
    {field_declarator, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [180] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [183] =
    {field_alternative, 4},
    {field_condition, 1},
  [185] =
    {field_size, 2},
  [186] =
    {field_body, 2},
    {field_filter, 1},
  [188] =
    {field_declarator, 0},
    {field_declarator, 2, .inherited = true},
  [190] =
    {field_condition, 1},
    {field_update, 3},
  [192] =
    {field_condition, 1},
    {field_initializer, 0},
    {field_update, 3},
  [195] =
    {field_initializer, 0},
    {field_update, 3},
  [197] =
    {field_condition, 2},
    {field_initializer, 0},
  [199] =
    {field_member, 4},
    {field_type, 2},
  [201] =
    {field_operand, 1},
    {field_operand, 2, .inherited = true},
  [203] =
    {field_assembly_code, 2},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [206] =
    {field_assembly_code, 3},
    {field_output_operands, 4},
  [208] =
    {field_declarator, 4},
  [209] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3},
    {field_declarator, 4, .inherited = true},
    {field_type, 0, .inherited = true},
  [214] =
    {field_declarator, 0},
    {field_size, 3},
  [216] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3},
  [219] =
    {field_designator, 0},
    {field_value, 2},
  [221] =
    {field_condition, 2},
    {field_initializer, 0},
    {field_update, 4},
  [224] =
    {field_operand, 0, .inherited = true},
    {field_operand, 1, .inherited = true},
  [226] =
    {field_register, 1},
  [227] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [231] =
    {field_assembly_code, 3},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [234] =
    {field_constraint, 0},
    {field_value, 2},
  [236] =
    {field_register, 1},
    {field_register, 2, .inherited = true},
  [238] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_goto_labels, 6},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [243] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [247] =
    {field_end, 3},
    {field_start, 1},
  [249] =
    {field_register, 0, .inherited = true},
    {field_register, 1, .inherited = true},
  [251] =
    {field_label, 1},
    {field_label, 2, .inherited = true},
  [253] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_goto_labels, 7},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [258] =
    {field_label, 0, .inherited = true},
    {field_label, 1, .inherited = true},
  [260] =
    {field_constraint, 3},
    {field_symbol, 1},
    {field_value, 5},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [7] = {
    [1] = alias_sym_type_identifier,
  },
  [10] = {
    [0] = alias_sym_type_identifier,
  },
  [15] = {
    [1] = alias_sym_type_identifier,
  },
  [21] = {
    [0] = sym_primitive_type,
  },
  [24] = {
    [1] = alias_sym_type_identifier,
  },
  [25] = {
    [2] = alias_sym_type_identifier,
  },
  [29] = {
    [1] = alias_sym_statement_identifier,
  },
  [31] = {
    [0] = alias_sym_statement_identifier,
  },
  [37] = {
    [2] = alias_sym_field_identifier,
  },
  [50] = {
    [1] = alias_sym_type_identifier,
  },
  [51] = {
    [0] = alias_sym_field_identifier,
  },
  [52] = {
    [2] = alias_sym_type_identifier,
  },
  [53] = {
    [3] = alias_sym_type_identifier,
  },
  [78] = {
    [1] = alias_sym_type_identifier,
  },
  [80] = {
    [3] = alias_sym_type_identifier,
  },
  [99] = {
    [1] = alias_sym_field_identifier,
  },
  [106] = {
    [4] = alias_sym_field_identifier,
  },
  [114] = {
    [0] = alias_sym_field_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 4,
  [7] = 7,
  [8] = 8,
  [9] = 8,
  [10] = 7,
  [11] = 2,
  [12] = 4,
  [13] = 7,
  [14] = 8,
  [15] = 8,
  [16] = 4,
  [17] = 2,
  [18] = 2,
  [19] = 19,
  [20] = 7,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 23,
  [28] = 28,
  [29] = 28,
  [30] = 25,
  [31] = 22,
  [32] = 25,
  [33] = 28,
  [34] = 24,
  [35] = 23,
  [36] = 36,
  [37] = 24,
  [38] = 25,
  [39] = 24,
  [40] = 22,
  [41] = 23,
  [42] = 28,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 46,
  [51] = 47,
  [52] = 47,
  [53] = 48,
  [54] = 46,
  [55] = 49,
  [56] = 49,
  [57] = 45,
  [58] = 45,
  [59] = 46,
  [60] = 48,
  [61] = 47,
  [62] = 48,
  [63] = 49,
  [64] = 45,
  [65] = 49,
  [66] = 48,
  [67] = 46,
  [68] = 47,
  [69] = 45,
  [70] = 70,
  [71] = 70,
  [72] = 70,
  [73] = 70,
  [74] = 70,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 88,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 77,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 75,
  [144] = 75,
  [145] = 75,
  [146] = 87,
  [147] = 94,
  [148] = 107,
  [149] = 108,
  [150] = 105,
  [151] = 106,
  [152] = 106,
  [153] = 91,
  [154] = 108,
  [155] = 91,
  [156] = 101,
  [157] = 103,
  [158] = 96,
  [159] = 112,
  [160] = 101,
  [161] = 89,
  [162] = 77,
  [163] = 102,
  [164] = 110,
  [165] = 99,
  [166] = 101,
  [167] = 78,
  [168] = 98,
  [169] = 78,
  [170] = 79,
  [171] = 97,
  [172] = 112,
  [173] = 80,
  [174] = 79,
  [175] = 80,
  [176] = 81,
  [177] = 110,
  [178] = 82,
  [179] = 89,
  [180] = 83,
  [181] = 84,
  [182] = 94,
  [183] = 85,
  [184] = 86,
  [185] = 113,
  [186] = 96,
  [187] = 100,
  [188] = 102,
  [189] = 97,
  [190] = 98,
  [191] = 99,
  [192] = 113,
  [193] = 100,
  [194] = 76,
  [195] = 93,
  [196] = 94,
  [197] = 86,
  [198] = 89,
  [199] = 90,
  [200] = 97,
  [201] = 98,
  [202] = 99,
  [203] = 88,
  [204] = 102,
  [205] = 92,
  [206] = 95,
  [207] = 85,
  [208] = 81,
  [209] = 82,
  [210] = 109,
  [211] = 103,
  [212] = 109,
  [213] = 83,
  [214] = 87,
  [215] = 95,
  [216] = 92,
  [217] = 84,
  [218] = 105,
  [219] = 84,
  [220] = 85,
  [221] = 107,
  [222] = 86,
  [223] = 93,
  [224] = 103,
  [225] = 78,
  [226] = 105,
  [227] = 110,
  [228] = 77,
  [229] = 112,
  [230] = 107,
  [231] = 91,
  [232] = 108,
  [233] = 106,
  [234] = 100,
  [235] = 79,
  [236] = 96,
  [237] = 80,
  [238] = 83,
  [239] = 82,
  [240] = 93,
  [241] = 76,
  [242] = 90,
  [243] = 113,
  [244] = 90,
  [245] = 88,
  [246] = 76,
  [247] = 95,
  [248] = 92,
  [249] = 81,
  [250] = 109,
  [251] = 87,
  [252] = 114,
  [253] = 140,
  [254] = 116,
  [255] = 120,
  [256] = 125,
  [257] = 136,
  [258] = 129,
  [259] = 115,
  [260] = 130,
  [261] = 133,
  [262] = 123,
  [263] = 132,
  [264] = 129,
  [265] = 130,
  [266] = 120,
  [267] = 123,
  [268] = 125,
  [269] = 136,
  [270] = 124,
  [271] = 140,
  [272] = 126,
  [273] = 122,
  [274] = 121,
  [275] = 119,
  [276] = 118,
  [277] = 128,
  [278] = 131,
  [279] = 134,
  [280] = 137,
  [281] = 139,
  [282] = 117,
  [283] = 135,
  [284] = 117,
  [285] = 126,
  [286] = 142,
  [287] = 127,
  [288] = 141,
  [289] = 122,
  [290] = 142,
  [291] = 141,
  [292] = 132,
  [293] = 135,
  [294] = 133,
  [295] = 114,
  [296] = 139,
  [297] = 138,
  [298] = 127,
  [299] = 119,
  [300] = 118,
  [301] = 137,
  [302] = 131,
  [303] = 121,
  [304] = 128,
  [305] = 138,
  [306] = 124,
  [307] = 134,
  [308] = 116,
  [309] = 115,
  [310] = 310,
  [311] = 119,
  [312] = 310,
  [313] = 135,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 314,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 315,
  [322] = 322,
  [323] = 320,
  [324] = 322,
  [325] = 325,
  [326] = 315,
  [327] = 320,
  [328] = 325,
  [329] = 319,
  [330] = 318,
  [331] = 319,
  [332] = 325,
  [333] = 320,
  [334] = 316,
  [335] = 322,
  [336] = 315,
  [337] = 318,
  [338] = 318,
  [339] = 316,
  [340] = 316,
  [341] = 322,
  [342] = 318,
  [343] = 319,
  [344] = 320,
  [345] = 319,
  [346] = 316,
  [347] = 314,
  [348] = 315,
  [349] = 314,
  [350] = 322,
  [351] = 325,
  [352] = 314,
  [353] = 142,
  [354] = 133,
  [355] = 128,
  [356] = 121,
  [357] = 132,
  [358] = 141,
  [359] = 359,
  [360] = 114,
  [361] = 131,
  [362] = 118,
  [363] = 363,
  [364] = 124,
  [365] = 127,
  [366] = 136,
  [367] = 134,
  [368] = 123,
  [369] = 139,
  [370] = 115,
  [371] = 138,
  [372] = 137,
  [373] = 129,
  [374] = 117,
  [375] = 125,
  [376] = 116,
  [377] = 126,
  [378] = 130,
  [379] = 120,
  [380] = 380,
  [381] = 310,
  [382] = 382,
  [383] = 382,
  [384] = 382,
  [385] = 385,
  [386] = 385,
  [387] = 382,
  [388] = 385,
  [389] = 382,
  [390] = 385,
  [391] = 382,
  [392] = 385,
  [393] = 385,
  [394] = 394,
  [395] = 394,
  [396] = 396,
  [397] = 397,
  [398] = 310,
  [399] = 310,
  [400] = 75,
  [401] = 401,
  [402] = 401,
  [403] = 401,
  [404] = 401,
  [405] = 405,
  [406] = 401,
  [407] = 401,
  [408] = 401,
  [409] = 401,
  [410] = 410,
  [411] = 411,
  [412] = 310,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 424,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 429,
  [433] = 425,
  [434] = 424,
  [435] = 435,
  [436] = 430,
  [437] = 430,
  [438] = 429,
  [439] = 425,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 444,
  [449] = 449,
  [450] = 444,
  [451] = 451,
  [452] = 452,
  [453] = 452,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 457,
  [462] = 462,
  [463] = 459,
  [464] = 464,
  [465] = 458,
  [466] = 457,
  [467] = 467,
  [468] = 468,
  [469] = 459,
  [470] = 464,
  [471] = 464,
  [472] = 457,
  [473] = 473,
  [474] = 474,
  [475] = 458,
  [476] = 457,
  [477] = 477,
  [478] = 478,
  [479] = 458,
  [480] = 480,
  [481] = 459,
  [482] = 482,
  [483] = 459,
  [484] = 457,
  [485] = 411,
  [486] = 464,
  [487] = 459,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 499,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 505,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 503,
  [514] = 514,
  [515] = 508,
  [516] = 504,
  [517] = 517,
  [518] = 503,
  [519] = 519,
  [520] = 520,
  [521] = 510,
  [522] = 505,
  [523] = 523,
  [524] = 511,
  [525] = 517,
  [526] = 520,
  [527] = 508,
  [528] = 509,
  [529] = 512,
  [530] = 514,
  [531] = 514,
  [532] = 505,
  [533] = 533,
  [534] = 514,
  [535] = 535,
  [536] = 508,
  [537] = 504,
  [538] = 504,
  [539] = 539,
  [540] = 504,
  [541] = 501,
  [542] = 542,
  [543] = 505,
  [544] = 542,
  [545] = 512,
  [546] = 512,
  [547] = 509,
  [548] = 548,
  [549] = 520,
  [550] = 517,
  [551] = 507,
  [552] = 512,
  [553] = 535,
  [554] = 542,
  [555] = 542,
  [556] = 514,
  [557] = 517,
  [558] = 520,
  [559] = 520,
  [560] = 560,
  [561] = 517,
  [562] = 520,
  [563] = 563,
  [564] = 517,
  [565] = 512,
  [566] = 501,
  [567] = 510,
  [568] = 542,
  [569] = 508,
  [570] = 501,
  [571] = 560,
  [572] = 507,
  [573] = 523,
  [574] = 548,
  [575] = 504,
  [576] = 535,
  [577] = 507,
  [578] = 560,
  [579] = 501,
  [580] = 548,
  [581] = 523,
  [582] = 503,
  [583] = 510,
  [584] = 510,
  [585] = 585,
  [586] = 523,
  [587] = 587,
  [588] = 503,
  [589] = 503,
  [590] = 548,
  [591] = 505,
  [592] = 592,
  [593] = 593,
  [594] = 501,
  [595] = 507,
  [596] = 542,
  [597] = 597,
  [598] = 511,
  [599] = 508,
  [600] = 535,
  [601] = 523,
  [602] = 560,
  [603] = 539,
  [604] = 560,
  [605] = 535,
  [606] = 560,
  [607] = 535,
  [608] = 507,
  [609] = 510,
  [610] = 563,
  [611] = 548,
  [612] = 612,
  [613] = 613,
  [614] = 523,
  [615] = 548,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 636,
  [638] = 638,
  [639] = 636,
  [640] = 633,
  [641] = 636,
  [642] = 633,
  [643] = 635,
  [644] = 638,
  [645] = 635,
  [646] = 646,
  [647] = 635,
  [648] = 638,
  [649] = 638,
  [650] = 633,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 654,
  [656] = 396,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 397,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 659,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 619,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 687,
  [692] = 678,
  [693] = 678,
  [694] = 687,
  [695] = 695,
  [696] = 678,
  [697] = 687,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 619,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 699,
  [708] = 700,
  [709] = 709,
  [710] = 396,
  [711] = 397,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 720,
  [726] = 726,
  [727] = 720,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 720,
  [732] = 732,
  [733] = 720,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 619,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 760,
  [785] = 785,
  [786] = 786,
  [787] = 785,
  [788] = 117,
  [789] = 785,
  [790] = 135,
  [791] = 785,
  [792] = 132,
  [793] = 668,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 745,
  [798] = 798,
  [799] = 138,
  [800] = 754,
  [801] = 748,
  [802] = 778,
  [803] = 119,
  [804] = 804,
  [805] = 116,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 757,
  [810] = 810,
  [811] = 758,
  [812] = 765,
  [813] = 766,
  [814] = 770,
  [815] = 775,
  [816] = 816,
  [817] = 817,
  [818] = 776,
  [819] = 819,
  [820] = 668,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 621,
  [827] = 620,
  [828] = 798,
  [829] = 796,
  [830] = 686,
  [831] = 754,
  [832] = 832,
  [833] = 138,
  [834] = 116,
  [835] = 135,
  [836] = 132,
  [837] = 745,
  [838] = 680,
  [839] = 778,
  [840] = 748,
  [841] = 685,
  [842] = 776,
  [843] = 775,
  [844] = 119,
  [845] = 770,
  [846] = 766,
  [847] = 798,
  [848] = 765,
  [849] = 760,
  [850] = 758,
  [851] = 817,
  [852] = 117,
  [853] = 816,
  [854] = 786,
  [855] = 808,
  [856] = 138,
  [857] = 810,
  [858] = 808,
  [859] = 807,
  [860] = 860,
  [861] = 806,
  [862] = 804,
  [863] = 135,
  [864] = 832,
  [865] = 832,
  [866] = 832,
  [867] = 795,
  [868] = 757,
  [869] = 794,
  [870] = 695,
  [871] = 689,
  [872] = 796,
  [873] = 117,
  [874] = 807,
  [875] = 132,
  [876] = 806,
  [877] = 116,
  [878] = 878,
  [879] = 810,
  [880] = 816,
  [881] = 795,
  [882] = 119,
  [883] = 786,
  [884] = 884,
  [885] = 817,
  [886] = 794,
  [887] = 804,
  [888] = 684,
  [889] = 688,
  [890] = 682,
  [891] = 668,
  [892] = 690,
  [893] = 681,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 98,
  [902] = 97,
  [903] = 100,
  [904] = 99,
  [905] = 78,
  [906] = 101,
  [907] = 113,
  [908] = 79,
  [909] = 909,
  [910] = 910,
  [911] = 80,
  [912] = 94,
  [913] = 100,
  [914] = 914,
  [915] = 113,
  [916] = 99,
  [917] = 98,
  [918] = 97,
  [919] = 919,
  [920] = 94,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 101,
  [926] = 926,
  [927] = 926,
  [928] = 78,
  [929] = 79,
  [930] = 926,
  [931] = 931,
  [932] = 80,
  [933] = 926,
  [934] = 934,
  [935] = 935,
  [936] = 754,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 757,
  [941] = 745,
  [942] = 748,
  [943] = 943,
  [944] = 760,
  [945] = 776,
  [946] = 778,
  [947] = 775,
  [948] = 770,
  [949] = 758,
  [950] = 766,
  [951] = 765,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 778,
  [956] = 776,
  [957] = 758,
  [958] = 766,
  [959] = 754,
  [960] = 765,
  [961] = 745,
  [962] = 962,
  [963] = 748,
  [964] = 757,
  [965] = 770,
  [966] = 775,
  [967] = 760,
  [968] = 968,
  [969] = 969,
  [970] = 970,
  [971] = 971,
  [972] = 971,
  [973] = 973,
  [974] = 971,
  [975] = 971,
  [976] = 976,
  [977] = 976,
  [978] = 976,
  [979] = 976,
  [980] = 980,
  [981] = 981,
  [982] = 982,
  [983] = 983,
  [984] = 984,
  [985] = 985,
  [986] = 986,
  [987] = 987,
  [988] = 988,
  [989] = 989,
  [990] = 983,
  [991] = 991,
  [992] = 992,
  [993] = 993,
  [994] = 994,
  [995] = 995,
  [996] = 996,
  [997] = 995,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 998,
  [1002] = 1002,
  [1003] = 825,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 754,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 819,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 778,
  [1013] = 1013,
  [1014] = 1004,
  [1015] = 1015,
  [1016] = 758,
  [1017] = 1013,
  [1018] = 1018,
  [1019] = 1004,
  [1020] = 1005,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1005,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 770,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1004,
  [1030] = 760,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1013,
  [1034] = 1013,
  [1035] = 1005,
  [1036] = 939,
  [1037] = 765,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 776,
  [1041] = 1005,
  [1042] = 766,
  [1043] = 745,
  [1044] = 1021,
  [1045] = 757,
  [1046] = 1005,
  [1047] = 1047,
  [1048] = 775,
  [1049] = 1049,
  [1050] = 748,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1051,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1057,
  [1066] = 1057,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1057,
  [1070] = 1070,
  [1071] = 1057,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 860,
  [1080] = 884,
  [1081] = 878,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 750,
  [1091] = 773,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1098,
  [1100] = 1098,
  [1101] = 1098,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 755,
  [1105] = 744,
  [1106] = 1106,
  [1107] = 1103,
  [1108] = 1108,
  [1109] = 1103,
  [1110] = 1108,
  [1111] = 1103,
  [1112] = 1112,
  [1113] = 1108,
  [1114] = 750,
  [1115] = 1103,
  [1116] = 1102,
  [1117] = 1097,
  [1118] = 1106,
  [1119] = 1103,
  [1120] = 1106,
  [1121] = 773,
  [1122] = 751,
  [1123] = 752,
  [1124] = 782,
  [1125] = 1106,
  [1126] = 783,
  [1127] = 774,
  [1128] = 769,
  [1129] = 1102,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1156,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1163,
  [1166] = 1159,
  [1167] = 1167,
  [1168] = 1155,
  [1169] = 1154,
  [1170] = 1149,
  [1171] = 1153,
  [1172] = 1167,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1175,
  [1176] = 1164,
  [1177] = 1152,
  [1178] = 1151,
  [1179] = 1147,
  [1180] = 1164,
  [1181] = 1142,
  [1182] = 1148,
  [1183] = 675,
  [1184] = 1148,
  [1185] = 1148,
  [1186] = 1135,
  [1187] = 1136,
  [1188] = 991,
  [1189] = 984,
  [1190] = 1190,
  [1191] = 1145,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1173,
  [1196] = 1138,
  [1197] = 1144,
  [1198] = 1198,
  [1199] = 1143,
  [1200] = 675,
  [1201] = 1140,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1194,
  [1205] = 981,
  [1206] = 1206,
  [1207] = 1161,
  [1208] = 1208,
  [1209] = 1134,
  [1210] = 1206,
  [1211] = 1211,
  [1212] = 1150,
  [1213] = 986,
  [1214] = 819,
  [1215] = 1194,
  [1216] = 1206,
  [1217] = 1206,
  [1218] = 1211,
  [1219] = 1211,
  [1220] = 1132,
  [1221] = 1141,
  [1222] = 1133,
  [1223] = 1203,
  [1224] = 1224,
  [1225] = 1211,
  [1226] = 1226,
  [1227] = 1226,
  [1228] = 1226,
  [1229] = 1226,
  [1230] = 1230,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1234,
  [1235] = 1233,
  [1236] = 1233,
  [1237] = 1233,
  [1238] = 1234,
  [1239] = 1234,
  [1240] = 1234,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1247,
  [1248] = 1248,
  [1249] = 1249,
  [1250] = 1250,
  [1251] = 1251,
  [1252] = 1252,
  [1253] = 1247,
  [1254] = 1254,
  [1255] = 1255,
  [1256] = 1247,
  [1257] = 1257,
  [1258] = 1258,
  [1259] = 1259,
  [1260] = 1258,
  [1261] = 1261,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1265,
  [1266] = 1266,
  [1267] = 1266,
  [1268] = 1266,
  [1269] = 1266,
  [1270] = 1270,
  [1271] = 1258,
  [1272] = 1272,
  [1273] = 1273,
  [1274] = 1258,
  [1275] = 1258,
  [1276] = 1276,
  [1277] = 1258,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 1282,
  [1283] = 1281,
  [1284] = 1284,
  [1285] = 1285,
  [1286] = 1286,
  [1287] = 1287,
  [1288] = 1288,
  [1289] = 1289,
  [1290] = 1290,
  [1291] = 1291,
  [1292] = 1292,
  [1293] = 1293,
  [1294] = 1294,
  [1295] = 1295,
  [1296] = 1296,
  [1297] = 1297,
  [1298] = 1281,
  [1299] = 1281,
  [1300] = 1300,
  [1301] = 1301,
  [1302] = 1302,
  [1303] = 1303,
  [1304] = 1304,
  [1305] = 1305,
  [1306] = 1306,
  [1307] = 1307,
  [1308] = 1308,
  [1309] = 1309,
  [1310] = 1310,
  [1311] = 1311,
  [1312] = 1312,
  [1313] = 1313,
  [1314] = 1314,
  [1315] = 1315,
  [1316] = 1316,
  [1317] = 1317,
  [1318] = 1318,
  [1319] = 1318,
  [1320] = 1320,
  [1321] = 1321,
  [1322] = 1322,
  [1323] = 1323,
  [1324] = 1318,
  [1325] = 1325,
  [1326] = 1318,
  [1327] = 1327,
  [1328] = 1328,
  [1329] = 1329,
  [1330] = 1330,
  [1331] = 1329,
  [1332] = 1330,
  [1333] = 1329,
  [1334] = 1334,
  [1335] = 1334,
  [1336] = 1329,
  [1337] = 1337,
  [1338] = 1338,
  [1339] = 1334,
  [1340] = 1340,
  [1341] = 1341,
  [1342] = 1342,
  [1343] = 1330,
  [1344] = 1330,
  [1345] = 1345,
  [1346] = 1334,
  [1347] = 1347,
  [1348] = 1348,
  [1349] = 1349,
  [1350] = 1350,
  [1351] = 1348,
  [1352] = 1352,
  [1353] = 1353,
  [1354] = 1354,
  [1355] = 1355,
  [1356] = 1355,
  [1357] = 1357,
  [1358] = 1348,
  [1359] = 1359,
  [1360] = 1360,
  [1361] = 1361,
  [1362] = 1350,
  [1363] = 1363,
  [1364] = 1364,
  [1365] = 1348,
  [1366] = 1350,
  [1367] = 1367,
  [1368] = 1368,
  [1369] = 1369,
  [1370] = 1370,
  [1371] = 1355,
  [1372] = 1372,
  [1373] = 1355,
  [1374] = 1350,
  [1375] = 1375,
  [1376] = 1376,
  [1377] = 1377,
  [1378] = 1378,
  [1379] = 1379,
  [1380] = 1380,
  [1381] = 1381,
  [1382] = 1382,
  [1383] = 1383,
  [1384] = 1384,
  [1385] = 1385,
  [1386] = 1386,
  [1387] = 1387,
  [1388] = 1388,
  [1389] = 1389,
  [1390] = 1390,
  [1391] = 1391,
  [1392] = 1392,
  [1393] = 1393,
  [1394] = 1394,
  [1395] = 1395,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1398,
  [1399] = 1399,
  [1400] = 1400,
  [1401] = 1400,
  [1402] = 1402,
  [1403] = 1403,
  [1404] = 1404,
  [1405] = 1405,
  [1406] = 1406,
  [1407] = 1407,
  [1408] = 1408,
  [1409] = 1409,
  [1410] = 1400,
  [1411] = 1411,
  [1412] = 1412,
  [1413] = 1413,
  [1414] = 1414,
  [1415] = 1415,
  [1416] = 1416,
  [1417] = 1417,
  [1418] = 1418,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1400,
  [1422] = 1422,
  [1423] = 1418,
  [1424] = 1418,
  [1425] = 1425,
  [1426] = 1426,
  [1427] = 1418,
  [1428] = 1400,
  [1429] = 1418,
  [1430] = 1430,
  [1431] = 1400,
  [1432] = 1432,
  [1433] = 1433,
  [1434] = 1418,
  [1435] = 1435,
  [1436] = 1436,
  [1437] = 1437,
  [1438] = 1438,
  [1439] = 1439,
  [1440] = 1440,
  [1441] = 1441,
  [1442] = 1442,
  [1443] = 1443,
  [1444] = 1444,
  [1445] = 1445,
  [1446] = 1446,
  [1447] = 1447,
  [1448] = 1448,
  [1449] = 1449,
  [1450] = 1450,
  [1451] = 1451,
  [1452] = 1452,
  [1453] = 1453,
  [1454] = 1454,
  [1455] = 1455,
  [1456] = 1456,
  [1457] = 1457,
  [1458] = 1458,
  [1459] = 1459,
  [1460] = 1457,
  [1461] = 1461,
  [1462] = 1462,
  [1463] = 1463,
  [1464] = 1464,
  [1465] = 1465,
  [1466] = 1466,
  [1467] = 1467,
  [1468] = 1468,
  [1469] = 1461,
  [1470] = 1457,
  [1471] = 1471,
  [1472] = 1465,
  [1473] = 1473,
  [1474] = 1474,
  [1475] = 1462,
  [1476] = 1459,
  [1477] = 1477,
  [1478] = 1478,
  [1479] = 1473,
  [1480] = 1459,
  [1481] = 1462,
  [1482] = 1482,
  [1483] = 1461,
  [1484] = 1484,
  [1485] = 1485,
  [1486] = 1486,
  [1487] = 1457,
  [1488] = 1459,
  [1489] = 1489,
  [1490] = 1490,
  [1491] = 1462,
  [1492] = 1492,
  [1493] = 1493,
  [1494] = 1465,
  [1495] = 1495,
  [1496] = 1465,
  [1497] = 1473,
  [1498] = 1461,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1473,
  [1502] = 1471,
  [1503] = 1471,
  [1504] = 1504,
  [1505] = 1505,
  [1506] = 1473,
  [1507] = 1507,
  [1508] = 1490,
  [1509] = 1490,
  [1510] = 1489,
  [1511] = 1511,
  [1512] = 1512,
  [1513] = 1513,
  [1514] = 1473,
  [1515] = 1515,
  [1516] = 1516,
  [1517] = 1517,
  [1518] = 1459,
  [1519] = 1473,
  [1520] = 1489,
  [1521] = 1521,
  [1522] = 1522,
  [1523] = 1523,
  [1524] = 1524,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1531,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1529,
  [1539] = 1539,
  [1540] = 1540,
  [1541] = 1541,
  [1542] = 1542,
  [1543] = 1543,
  [1544] = 1544,
  [1545] = 1528,
  [1546] = 1546,
  [1547] = 1546,
  [1548] = 1548,
  [1549] = 1549,
  [1550] = 1544,
  [1551] = 1551,
  [1552] = 1552,
  [1553] = 1548,
  [1554] = 1521,
  [1555] = 1551,
  [1556] = 1552,
  [1557] = 1529,
  [1558] = 1537,
  [1559] = 1559,
  [1560] = 1542,
  [1561] = 1561,
  [1562] = 1543,
  [1563] = 1546,
  [1564] = 1549,
  [1565] = 1544,
  [1566] = 1542,
  [1567] = 1548,
  [1568] = 1521,
  [1569] = 1551,
  [1570] = 1529,
  [1571] = 1537,
  [1572] = 1540,
  [1573] = 1573,
  [1574] = 1542,
  [1575] = 1552,
  [1576] = 1576,
  [1577] = 1577,
  [1578] = 1543,
  [1579] = 1546,
  [1580] = 1549,
  [1581] = 1543,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1586,
  [1589] = 1543,
  [1590] = 1529,
  [1591] = 1549,
  [1592] = 1584,
  [1593] = 1546,
  [1594] = 1594,
  [1595] = 1548,
  [1596] = 1596,
  [1597] = 1521,
  [1598] = 1598,
  [1599] = 1549,
  [1600] = 1600,
  [1601] = 1551,
  [1602] = 1585,
  [1603] = 1603,
  [1604] = 1604,
  [1605] = 1605,
  [1606] = 1526,
  [1607] = 1544,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 1372,
  [1611] = 1551,
  [1612] = 1521,
  [1613] = 1549,
  [1614] = 1548,
  [1615] = 1546,
  [1616] = 1543,
  [1617] = 1551,
  [1618] = 1618,
  [1619] = 1521,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1548,
  [1624] = 1584,
  [1625] = 1540,
  [1626] = 1626,
  [1627] = 1627,
  [1628] = 1628,
  [1629] = 1561,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1542,
  [1636] = 1636,
  [1637] = 1542,
  [1638] = 1638,
  [1639] = 1639,
  [1640] = 1526,
  [1641] = 1529,
  [1642] = 1585,
  [1643] = 1643,
  [1644] = 1644,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1655,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 1657,
  [1659] = 1659,
  [1660] = 1659,
  [1661] = 1650,
  [1662] = 1657,
  [1663] = 1655,
  [1664] = 1664,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1651,
  [1668] = 1653,
  [1669] = 1659,
  [1670] = 1650,
  [1671] = 1655,
  [1672] = 1672,
  [1673] = 1653,
  [1674] = 1674,
  [1675] = 1654,
  [1676] = 1651,
  [1677] = 1649,
  [1678] = 1646,
  [1679] = 1679,
  [1680] = 1655,
  [1681] = 1681,
  [1682] = 1682,
  [1683] = 1659,
  [1684] = 1684,
  [1685] = 1659,
  [1686] = 1650,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1656,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 1645,
  [1694] = 1694,
  [1695] = 1695,
  [1696] = 1655,
  [1697] = 1697,
  [1698] = 1654,
  [1699] = 1674,
  [1700] = 1651,
  [1701] = 1649,
  [1702] = 1646,
  [1703] = 1666,
  [1704] = 1704,
  [1705] = 1674,
  [1706] = 1656,
  [1707] = 1707,
  [1708] = 1645,
  [1709] = 1645,
  [1710] = 1649,
  [1711] = 1711,
  [1712] = 1712,
  [1713] = 1654,
  [1714] = 1674,
  [1715] = 1715,
  [1716] = 1674,
  [1717] = 1645,
  [1718] = 1645,
  [1719] = 1653,
  [1720] = 1720,
  [1721] = 1674,
  [1722] = 1656,
  [1723] = 1657,
  [1724] = 1653,
  [1725] = 1725,
  [1726] = 1657,
  [1727] = 1645,
  [1728] = 1649,
  [1729] = 1674,
  [1730] = 1654,
  [1731] = 1731,
  [1732] = 1732,
  [1733] = 1733,
  [1734] = 1734,
  [1735] = 1734,
  [1736] = 1736,
  [1737] = 1737,
  [1738] = 1738,
  [1739] = 1739,
  [1740] = 1740,
  [1741] = 1741,
  [1742] = 1742,
  [1743] = 1743,
  [1744] = 1744,
  [1745] = 1745,
  [1746] = 1746,
  [1747] = 1747,
  [1748] = 1748,
  [1749] = 1740,
  [1750] = 1750,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1753,
  [1754] = 1754,
  [1755] = 1739,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 1731,
  [1761] = 1761,
  [1762] = 1762,
  [1763] = 1747,
  [1764] = 1734,
  [1765] = 1765,
  [1766] = 1757,
  [1767] = 1767,
  [1768] = 1731,
  [1769] = 1743,
  [1770] = 1770,
  [1771] = 1771,
  [1772] = 1772,
  [1773] = 1773,
  [1774] = 1774,
  [1775] = 1731,
  [1776] = 1776,
  [1777] = 1774,
  [1778] = 1747,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1772,
  [1782] = 1741,
  [1783] = 1757,
  [1784] = 1743,
  [1785] = 1747,
  [1786] = 1740,
  [1787] = 1771,
  [1788] = 1788,
  [1789] = 1752,
  [1790] = 986,
  [1791] = 1731,
  [1792] = 1747,
  [1793] = 991,
  [1794] = 1743,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1797,
  [1798] = 1798,
  [1799] = 1759,
  [1800] = 1762,
  [1801] = 1767,
  [1802] = 1731,
  [1803] = 1803,
  [1804] = 1771,
  [1805] = 1805,
  [1806] = 1741,
  [1807] = 1743,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1747,
  [1811] = 1767,
  [1812] = 1812,
  [1813] = 984,
  [1814] = 1814,
  [1815] = 1815,
  [1816] = 1816,
  [1817] = 1774,
  [1818] = 1818,
  [1819] = 1744,
  [1820] = 1820,
  [1821] = 1821,
  [1822] = 1822,
  [1823] = 1767,
  [1824] = 1824,
  [1825] = 1762,
  [1826] = 1759,
  [1827] = 1827,
  [1828] = 1772,
  [1829] = 1757,
  [1830] = 1830,
  [1831] = 1752,
  [1832] = 1740,
  [1833] = 1833,
  [1834] = 1746,
  [1835] = 1835,
  [1836] = 1836,
  [1837] = 1752,
  [1838] = 1798,
  [1839] = 1839,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 1842,
  [1843] = 1843,
  [1844] = 1844,
  [1845] = 1736,
  [1846] = 1734,
  [1847] = 1847,
  [1848] = 1848,
  [1849] = 1849,
  [1850] = 1850,
  [1851] = 1788,
  [1852] = 1852,
  [1853] = 1853,
  [1854] = 1854,
  [1855] = 1751,
  [1856] = 1856,
  [1857] = 1857,
  [1858] = 1858,
  [1859] = 1859,
  [1860] = 1759,
  [1861] = 1861,
  [1862] = 1762,
  [1863] = 1863,
  [1864] = 1864,
  [1865] = 1865,
  [1866] = 1866,
  [1867] = 1865,
  [1868] = 1865,
  [1869] = 1869,
  [1870] = 1795,
  [1871] = 1767,
  [1872] = 1872,
  [1873] = 1873,
  [1874] = 1788,
  [1875] = 1747,
  [1876] = 1876,
  [1877] = 1796,
  [1878] = 1797,
  [1879] = 1820,
  [1880] = 1880,
  [1881] = 1795,
  [1882] = 1882,
  [1883] = 1780,
  [1884] = 1780,
  [1885] = 1773,
  [1886] = 1805,
  [1887] = 1745,
  [1888] = 1773,
  [1889] = 1889,
  [1890] = 1890,
  [1891] = 981,
  [1892] = 1731,
  [1893] = 1741,
  [1894] = 1894,
  [1895] = 1895,
  [1896] = 1896,
  [1897] = 1843,
  [1898] = 1739,
  [1899] = 1736,
  [1900] = 1745,
  [1901] = 1901,
  [1902] = 1902,
  [1903] = 1903,
  [1904] = 1904,
  [1905] = 1905,
  [1906] = 1906,
  [1907] = 1796,
  [1908] = 1797,
  [1909] = 1909,
  [1910] = 1910,
  [1911] = 1911,
  [1912] = 1751,
  [1913] = 1805,
  [1914] = 1914,
  [1915] = 1739,
  [1916] = 1889,
  [1917] = 1857,
  [1918] = 1918,
  [1919] = 1919,
  [1920] = 1736,
  [1921] = 1921,
  [1922] = 1922,
  [1923] = 621,
  [1924] = 1924,
  [1925] = 1925,
  [1926] = 1926,
  [1927] = 1927,
  [1928] = 1796,
  [1929] = 1751,
  [1930] = 1734,
  [1931] = 1931,
  [1932] = 1796,
  [1933] = 1796,
  [1934] = 1857,
  [1935] = 1771,
  [1936] = 1936,
  [1937] = 1937,
  [1938] = 1938,
  [1939] = 1939,
  [1940] = 1940,
  [1941] = 1746,
  [1942] = 1918,
  [1943] = 1744,
  [1944] = 1746,
  [1945] = 1767,
  [1946] = 1946,
  [1947] = 1947,
  [1948] = 1743,
  [1949] = 1848,
  [1950] = 1950,
  [1951] = 1805,
  [1952] = 1774,
  [1953] = 1772,
  [1954] = 1744,
  [1955] = 1955,
  [1956] = 1788,
  [1957] = 1818,
  [1958] = 1940,
  [1959] = 1940,
  [1960] = 1960,
  [1961] = 1757,
  [1962] = 1848,
  [1963] = 1788,
  [1964] = 1843,
  [1965] = 1965,
  [1966] = 1736,
  [1967] = 1743,
  [1968] = 1788,
  [1969] = 1969,
  [1970] = 1848,
  [1971] = 1939,
  [1972] = 1972,
  [1973] = 1734,
  [1974] = 1974,
  [1975] = 1940,
  [1976] = 1976,
  [1977] = 1797,
  [1978] = 1940,
  [1979] = 620,
  [1980] = 1796,
};

static TSCharacterRange sym_number_literal_character_set_13[] = {
  {'0', '9'}, {'B', 'B'}, {'D', 'D'}, {'F', 'F'}, {'L', 'L'}, {'U', 'U'}, {'W', 'W'}, {'b', 'b'},
  {'d', 'd'}, {'f', 'f'}, {'l', 'l'}, {'u', 'u'}, {'w', 'w'},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'$', '$'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba},
  {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5},
  {0x3f7, 0x481}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a},
  {0x66e, 0x66f}, {0x671, 0x6d3}, {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710},
  {0x712, 0x72f}, {0x74d, 0x7a5}, {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a},
  {0x824, 0x824}, {0x828, 0x828}, {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939},
  {0x93d, 0x93d}, {0x950, 0x950}, {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0},
  {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc},
  {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c},
  {0xa5e, 0xa5e}, {0xa72, 0xa74}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9},
  {0xabd, 0xabd}, {0xad0, 0xad0}, {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30},
  {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a},
  {0xb8e, 0xb90}, {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9},
  {0xbd0, 0xbd0}, {0xc05, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d},
  {0xc60, 0xc61}, {0xc80, 0xc80}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd},
  {0xcdd, 0xcde}, {0xce0, 0xce1}, {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e},
  {0xd54, 0xd56}, {0xd5f, 0xd61}, {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6},
  {0xe01, 0xe30}, {0xe32, 0xe32}, {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5},
  {0xea7, 0xeb0}, {0xeb2, 0xeb2}, {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47},
  {0xf49, 0xf6c}, {0xf88, 0xf8c}, {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066},
  {0x106e, 0x1070}, {0x1075, 0x1081}, {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248},
  {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5},
  {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f},
  {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711},
  {0x171f, 0x1731}, {0x1740, 0x1751}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878},
  {0x1880, 0x18a8}, {0x18aa, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9},
  {0x1a00, 0x1a16}, {0x1a20, 0x1a54}, {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5},
  {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3},
  {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57},
  {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4},
  {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f},
  {0x2090, 0x209c}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126},
  {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee},
  {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6},
  {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007},
  {0x3021, 0x3029}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f},
  {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f},
  {0xa62a, 0xa62b}, {0xa640, 0xa66e}, {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1},
  {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3},
  {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf},
  {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a},
  {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea},
  {0xaaf2, 0xaaf4}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69},
  {0xab70, 0xabe2}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17},
  {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1},
  {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77},
  {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe},
  {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d},
  {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a},
  {0x10350, 0x10375}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb},
  {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1},
  {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba},
  {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e},
  {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13},
  {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55},
  {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1},
  {0x10f00, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072},
  {0x11075, 0x11075}, {0x11083, 0x110af}, {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176},
  {0x11183, 0x111b2}, {0x111c1, 0x111c4}, {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286},
  {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328},
  {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a},
  {0x1145f, 0x11461}, {0x11480, 0x114af}, {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644},
  {0x11680, 0x116aa}, {0x116b8, 0x116b8}, {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909},
  {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1},
  {0x119e3, 0x119e3}, {0x11a00, 0x11a00}, {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8},
  {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e}, {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46},
  {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33},
  {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646},
  {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f},
  {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5},
  {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155},
  {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c},
  {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505},
  {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550},
  {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e},
  {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c},
  {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee},
  {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24},
  {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49},
  {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d},
  {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e},
  {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d},
  {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'$', '$'}, {'0', '9'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5},
  {0xb7, 0xb7}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec},
  {0x2ee, 0x2ee}, {0x300, 0x374}, {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1},
  {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd},
  {0x5bf, 0x5bf}, {0x5c1, 0x5c2}, {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669},
  {0x66e, 0x6d3}, {0x6d5, 0x6dc}, {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5},
  {0x7fa, 0x7fa}, {0x7fd, 0x7fd}, {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1},
  {0x8e3, 0x963}, {0x966, 0x96f}, {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2},
  {0x9b6, 0x9b9}, {0x9bc, 0x9c4}, {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1},
  {0x9fc, 0x9fc}, {0x9fe, 0x9fe}, {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33},
  {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c},
  {0xa5e, 0xa5e}, {0xa66, 0xa75}, {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3},
  {0xab5, 0xab9}, {0xabc, 0xac5}, {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff},
  {0xb01, 0xb03}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44},
  {0xb47, 0xb48}, {0xb4b, 0xb4d}, {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83},
  {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa},
  {0xbae, 0xbb9}, {0xbbe, 0xbc2}, {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a},
  {0xc5d, 0xc5d}, {0xc60, 0xc63}, {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3},
  {0xcb5, 0xcb9}, {0xcbc, 0xcc4}, {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef},
  {0xcf1, 0xcf3}, {0xd00, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63},
  {0xd66, 0xd6f}, {0xd7a, 0xd7f}, {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6},
  {0xdca, 0xdca}, {0xdcf, 0xdd4}, {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e},
  {0xe50, 0xe59}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4},
  {0xec6, 0xec6}, {0xec8, 0xece}, {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35},
  {0xf37, 0xf37}, {0xf39, 0xf39}, {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6},
  {0x1000, 0x1049}, {0x1050, 0x109d}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d},
  {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be},
  {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371},
  {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8},
  {0x1700, 0x1715}, {0x171f, 0x1734}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7},
  {0x17dc, 0x17dd}, {0x17e0, 0x17e9}, {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e},
  {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b},
  {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c},
  {0x1b50, 0x1b59}, {0x1b6b, 0x1b73}, {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba},
  {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57},
  {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4},
  {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040},
  {0x2054, 0x2054}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27},
  {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe},
  {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d},
  {0xa67f, 0xa6f1}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827},
  {0xa82c, 0xa82c}, {0xa840, 0xa873}, {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953},
  {0xa960, 0xa97c}, {0xa980, 0xa9c0}, {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76},
  {0xaa7a, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26},
  {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6},
  {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c},
  {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7},
  {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77},
  {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a},
  {0xff65, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a},
  {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0},
  {0x102e0, 0x102e0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5},
  {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a},
  {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755},
  {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838},
  {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939},
  {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a},
  {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72},
  {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac},
  {0x10eb0, 0x10eb1}, {0x10efd, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046},
  {0x11066, 0x11075}, {0x1107f, 0x110ba}, {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147},
  {0x11150, 0x11173}, {0x11176, 0x11176}, {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237},
  {0x1123e, 0x11241}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9},
  {0x11300, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344},
  {0x11347, 0x11348}, {0x1134b, 0x1134d}, {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a},
  {0x11450, 0x11459}, {0x1145e, 0x11461}, {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd},
  {0x11600, 0x11640}, {0x11644, 0x11644}, {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739},
  {0x11740, 0x11746}, {0x11800, 0x1183a}, {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935},
  {0x11937, 0x11938}, {0x1193b, 0x11943}, {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e},
  {0x11a47, 0x11a47}, {0x11a50, 0x11a99}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59},
  {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d},
  {0x11d3f, 0x11d47}, {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9},
  {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10}, {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e},
  {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69},
  {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9}, {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77},
  {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1},
  {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132},
  {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99},
  {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad},
  {0x1d242, 0x1d244}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9},
  {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e},
  {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714},
  {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff},
  {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c}, {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a},
  {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c},
  {0x1e130, 0x1e13d}, {0x1e140, 0x1e149}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb},
  {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f},
  {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42},
  {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59},
  {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77},
  {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9},
  {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a},
  {0x31350, 0x323af}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(120);
      ADVANCE_MAP(
        '!', 187,
        '"', 286,
        '#', 75,
        '%', 204,
        '&', 213,
        '\'', 277,
        '(', 124,
        ')', 127,
        '*', 200,
        '+', 195,
        ',', 126,
        '-', 190,
        '.', 253,
        '/', 202,
        '0', 259,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        'L', 298,
        'U', 300,
        '[', 233,
        '\\', 2,
        ']', 234,
        '^', 210,
        'u', 302,
        '{', 230,
        '|', 207,
        '}', 231,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(118);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(43);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(43);
      if (lookahead == '\r') SKIP(1);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(46);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(46);
      if (lookahead == '\r') SKIP(3);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(45);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(45);
      if (lookahead == '\r') SKIP(5);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(47);
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(47);
      if (lookahead == '\r') SKIP(7);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(49);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(49);
      if (lookahead == '\r') SKIP(9);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(53);
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(53);
      if (lookahead == '\r') SKIP(11);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(52);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(52);
      if (lookahead == '\r') SKIP(13);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(57);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(57);
      if (lookahead == '\r') SKIP(15);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(50);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(50);
      if (lookahead == '\r') SKIP(17);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(51);
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(51);
      if (lookahead == '\r') SKIP(19);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(48);
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(48);
      if (lookahead == '\r') SKIP(21);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(25);
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(25);
      if (lookahead == '\r') SKIP(23);
      END_STATE();
    case 25:
      ADVANCE_MAP(
        '\n', 129,
        '!', 68,
        '%', 203,
        '&', 212,
        '(', 185,
        '*', 199,
        '+', 194,
        '-', 189,
        '/', 201,
        '<', 221,
        '=', 69,
        '>', 217,
      );
      if (lookahead == '\\') SKIP(24);
      if (lookahead == '^') ADVANCE(209);
      if (lookahead == '|') ADVANCE(208);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(25);
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(56);
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(56);
      if (lookahead == '\r') SKIP(26);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(54);
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(54);
      if (lookahead == '\r') SKIP(28);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(55);
      if (lookahead == '"') ADVANCE(286);
      if (lookahead == '/') ADVANCE(287);
      if (lookahead == '\\') ADVANCE(31);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(290);
      if (lookahead != 0) ADVANCE(291);
      END_STATE();
    case 31:
      if (lookahead == '\n') ADVANCE(293);
      if (lookahead == '\r') ADVANCE(292);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      if (lookahead == 'x') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(295);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 32:
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '\r') ADVANCE(36);
      if (lookahead == '(') ADVANCE(124);
      if (lookahead == '/') ADVANCE(150);
      if (lookahead == '\\') ADVANCE(145);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(66);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 33:
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '\r') ADVANCE(36);
      if (lookahead == '/') ADVANCE(150);
      if (lookahead == '\\') ADVANCE(145);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(66);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 34:
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '\r') ADVANCE(35);
      if (lookahead == '(') ADVANCE(185);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') SKIP(39);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(59);
      END_STATE();
    case 35:
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '(') ADVANCE(185);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') SKIP(39);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59);
      END_STATE();
    case 36:
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '/') ADVANCE(150);
      if (lookahead == '\\') ADVANCE(145);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(66);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(58);
      if (lookahead == '\'') ADVANCE(277);
      if (lookahead == '/') ADVANCE(280);
      if (lookahead == '\\') ADVANCE(279);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(281);
      if (lookahead != 0) ADVANCE(278);
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(59);
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(59);
      if (lookahead == '\r') SKIP(38);
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(44);
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(44);
      if (lookahead == '\r') SKIP(40);
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 42:
      if (lookahead == '\r') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(313);
      if (lookahead != 0) ADVANCE(318);
      END_STATE();
    case 43:
      ADVANCE_MAP(
        '!', 187,
        '"', 286,
        '#', 75,
        '%', 204,
        '&', 213,
        '\'', 277,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 195,
        ',', 126,
        '-', 190,
        '.', 253,
        '/', 202,
        '0', 259,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        'L', 298,
        'U', 300,
        '[', 233,
        '\\', 2,
        ']', 234,
        '^', 210,
        'u', 302,
        '{', 230,
        '|', 207,
        '}', 231,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(43);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 44:
      ADVANCE_MAP(
        '!', 187,
        '"', 286,
        '#', 83,
        '%', 204,
        '&', 213,
        '\'', 277,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 195,
        ',', 126,
        '-', 190,
        '.', 253,
        '/', 202,
        '0', 259,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        'L', 298,
        'U', 300,
        '[', 232,
        '\\', 41,
        ']', 234,
        '^', 210,
        'u', 302,
        '{', 230,
        '|', 207,
        '}', 231,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(44);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 45:
      ADVANCE_MAP(
        '!', 186,
        '"', 286,
        '#', 75,
        '&', 211,
        '\'', 277,
        '(', 185,
        '*', 199,
        '+', 196,
        ',', 126,
        '-', 191,
        '.', 96,
        '/', 60,
        '0', 259,
        ':', 67,
        ';', 226,
        'L', 298,
        'U', 300,
        '[', 73,
        '\\', 6,
        ']', 74,
        'u', 302,
        '{', 230,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(45);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 46:
      ADVANCE_MAP(
        '!', 186,
        '"', 286,
        '#', 79,
        '&', 211,
        '\'', 277,
        '(', 185,
        ')', 127,
        '*', 199,
        '+', 196,
        ',', 126,
        '-', 191,
        '.', 254,
        '/', 60,
        '0', 259,
        ':', 237,
        ';', 226,
        '=', 235,
        'L', 298,
        'U', 300,
        '[', 233,
        '\\', 4,
        ']', 234,
        'u', 302,
        '{', 230,
        '}', 231,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(46);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 47:
      ADVANCE_MAP(
        '!', 186,
        '"', 286,
        '#', 77,
        '&', 211,
        '\'', 277,
        '(', 185,
        '*', 199,
        '+', 196,
        '-', 191,
        '.', 96,
        '/', 60,
        '0', 259,
        ';', 226,
        'L', 298,
        'U', 300,
        '[', 73,
        '\\', 8,
        'u', 302,
        '{', 230,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(47);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 48:
      ADVANCE_MAP(
        '!', 186,
        '\'', 277,
        '(', 185,
        ')', 127,
        '+', 198,
        '-', 193,
        '.', 96,
        '/', 60,
        '0', 259,
        'L', 306,
        'U', 307,
        '\\', 22,
        'u', 308,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 49:
      ADVANCE_MAP(
        '!', 68,
        '"', 286,
        '#', 83,
        '%', 204,
        '&', 213,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 197,
        ',', 126,
        '-', 192,
        '.', 252,
        '/', 202,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        'L', 299,
        'U', 301,
        '[', 233,
        '\\', 10,
        ']', 234,
        '^', 210,
        'u', 303,
        '|', 207,
        '}', 231,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(49);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 50:
      ADVANCE_MAP(
        '!', 68,
        '#', 83,
        '%', 204,
        '&', 213,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 197,
        ',', 126,
        '-', 192,
        '.', 252,
        '/', 202,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        '[', 233,
        '\\', 18,
        ']', 234,
        '^', 210,
        '{', 230,
        '|', 207,
        '}', 231,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(50);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 51:
      ADVANCE_MAP(
        '!', 68,
        '#', 83,
        '%', 204,
        '&', 213,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 197,
        ',', 126,
        '-', 192,
        '.', 251,
        '/', 202,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        '[', 232,
        '\\', 20,
        ']', 74,
        '^', 210,
        '|', 207,
        '}', 231,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(51);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 52:
      ADVANCE_MAP(
        '!', 68,
        '#', 80,
        '%', 203,
        '&', 212,
        '(', 185,
        ')', 127,
        '*', 199,
        '+', 194,
        ',', 126,
        '-', 189,
        '/', 201,
        ';', 226,
        '<', 221,
        '=', 236,
        '>', 217,
        '[', 233,
        '\\', 14,
        '^', 209,
        '{', 230,
        '|', 208,
        '}', 231,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(52);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 53:
      ADVANCE_MAP(
        '!', 68,
        '#', 76,
        '%', 204,
        '&', 213,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 197,
        ',', 126,
        '-', 192,
        '.', 252,
        '/', 202,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        '[', 233,
        '\\', 12,
        '^', 210,
        '{', 230,
        '|', 207,
        '}', 231,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 54:
      if (lookahead == '"') ADVANCE(286);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '<') ADVANCE(70);
      if (lookahead == 'L') ADVANCE(299);
      if (lookahead == 'U') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead == 'u') ADVANCE(303);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(54);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 55:
      if (lookahead == '"') ADVANCE(286);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') ADVANCE(31);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55);
      END_STATE();
    case 56:
      if (lookahead == '#') ADVANCE(93);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '}') ADVANCE(231);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 57:
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(16);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 58:
      if (lookahead == '\'') ADVANCE(277);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') ADVANCE(31);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(58);
      END_STATE();
    case 59:
      if (lookahead == '(') ADVANCE(185);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') SKIP(39);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59);
      END_STATE();
    case 60:
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '/') ADVANCE(318);
      END_STATE();
    case 61:
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '/') ADVANCE(311);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 62:
      if (lookahead == '*') ADVANCE(61);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 63:
      if (lookahead == '*') ADVANCE(61);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 64:
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(257);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(258);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(267);
      END_STATE();
    case 65:
      if (lookahead == '.') ADVANCE(125);
      END_STATE();
    case 66:
      if (lookahead == '/') ADVANCE(150);
      if (lookahead == '\\') ADVANCE(145);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(66);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 67:
      if (lookahead == ':') ADVANCE(227);
      END_STATE();
    case 68:
      if (lookahead == '=') ADVANCE(215);
      END_STATE();
    case 69:
      if (lookahead == '=') ADVANCE(214);
      END_STATE();
    case 70:
      if (lookahead == '>') ADVANCE(296);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(70);
      END_STATE();
    case 71:
      if (lookahead == '>') ADVANCE(297);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(70);
      END_STATE();
    case 72:
      if (lookahead == 'U') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 73:
      if (lookahead == '[') ADVANCE(228);
      END_STATE();
    case 74:
      if (lookahead == ']') ADVANCE(229);
      END_STATE();
    case 75:
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'e') ADVANCE(179);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 76:
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'e') ADVANCE(179);
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 77:
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'e') ADVANCE(181);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 78:
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'e') ADVANCE(181);
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 79:
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 80:
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 81:
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 82:
      if (lookahead == 'd') ADVANCE(86);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(83);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(134);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 87:
      if (lookahead == 'f') ADVANCE(136);
      END_STATE();
    case 88:
      if (lookahead == 'f') ADVANCE(130);
      END_STATE();
    case 89:
      if (lookahead == 'f') ADVANCE(138);
      END_STATE();
    case 90:
      if (lookahead == 'f') ADVANCE(140);
      END_STATE();
    case 91:
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 's') ADVANCE(84);
      END_STATE();
    case 92:
      if (lookahead == 'i') ADVANCE(88);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(91);
      if (lookahead == 'n') ADVANCE(81);
      END_STATE();
    case 95:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 96:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(256);
      END_STATE();
    case 97:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(258);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(267);
      END_STATE();
    case 98:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(310);
      END_STATE();
    case 99:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(264);
      END_STATE();
    case 100:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(267);
      END_STATE();
    case 101:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(262);
      END_STATE();
    case 102:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(292);
      END_STATE();
    case 103:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(98);
      END_STATE();
    case 104:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(102);
      END_STATE();
    case 105:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(103);
      END_STATE();
    case 106:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(104);
      END_STATE();
    case 107:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(105);
      END_STATE();
    case 108:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(106);
      END_STATE();
    case 109:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(107);
      END_STATE();
    case 110:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(108);
      END_STATE();
    case 111:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(109);
      END_STATE();
    case 112:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(110);
      END_STATE();
    case 113:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 114:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(112);
      END_STATE();
    case 115:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(113);
      END_STATE();
    case 116:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(114);
      END_STATE();
    case 117:
      if (lookahead != 0 &&
          lookahead != '*') ADVANCE(152);
      END_STATE();
    case 118:
      if (eof) ADVANCE(120);
      ADVANCE_MAP(
        '!', 187,
        '"', 286,
        '#', 75,
        '%', 204,
        '&', 213,
        '\'', 277,
        '(', 185,
        ')', 127,
        '*', 200,
        '+', 195,
        ',', 126,
        '-', 190,
        '.', 253,
        '/', 202,
        '0', 259,
        ':', 237,
        ';', 226,
        '<', 220,
        '=', 236,
        '>', 216,
        '?', 238,
        'L', 298,
        'U', 300,
        '[', 233,
        '\\', 2,
        ']', 234,
        '^', 210,
        'u', 302,
        '{', 230,
        '|', 207,
        '}', 231,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(118);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 119:
      if (eof) ADVANCE(120);
      ADVANCE_MAP(
        '!', 186,
        '"', 286,
        '#', 79,
        '&', 211,
        '\'', 277,
        '(', 185,
        ')', 127,
        '*', 199,
        '+', 196,
        ',', 126,
        '-', 191,
        '.', 254,
        '/', 60,
        '0', 259,
        ':', 237,
        ';', 226,
        '=', 235,
        'L', 298,
        'U', 300,
        '[', 233,
        '\\', 4,
        ']', 234,
        'u', 302,
        '{', 230,
        '}', 231,
        '~', 188,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(119);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(310);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_preproc_include_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_preproc_include_token2);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_preproc_def_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_preproc_if_token1);
      if (lookahead == 'd') ADVANCE(163);
      if (lookahead == 'n') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(129);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(85);
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(165);
      if (lookahead == 'n') ADVANCE(158);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(62);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '/') ADVANCE(311);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(62);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(318);
      if (lookahead == '\r') ADVANCE(312);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(314);
      if (lookahead != 0) ADVANCE(316);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(66);
      if (lookahead == '\r') ADVANCE(146);
      if (lookahead == '/') ADVANCE(117);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(66);
      if (lookahead == '/') ADVANCE(117);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\r') ADVANCE(153);
      if (lookahead == '/') ADVANCE(117);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\r') ADVANCE(151);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\r') ADVANCE(317);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(314);
      if (lookahead != 0) ADVANCE(316);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(143);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(152);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0) ADVANCE(143);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '/') ADVANCE(117);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(152);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '/') ADVANCE(117);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'c') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(128);
      if (lookahead == 'n') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(170);
      if (lookahead == 's') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(171);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(177);
      if (lookahead == 'n') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'u') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(215);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(249);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(259);
      if (lookahead == '=') ADVANCE(243);
      if (lookahead == '>') ADVANCE(255);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(249);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(259);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(249);
      if (lookahead == '=') ADVANCE(243);
      if (lookahead == '>') ADVANCE(255);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(259);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(250);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(259);
      if (lookahead == '=') ADVANCE(242);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(250);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(259);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(250);
      if (lookahead == '=') ADVANCE(242);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(259);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(239);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '/') ADVANCE(318);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '/') ADVANCE(318);
      if (lookahead == '=') ADVANCE(240);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(241);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(248);
      if (lookahead == '|') ADVANCE(205);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(205);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(247);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(206);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(206);
      if (lookahead == '=') ADVANCE(246);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(218);
      if (lookahead == '>') ADVANCE(225);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(218);
      if (lookahead == '>') ADVANCE(224);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(223);
      if (lookahead == '=') ADVANCE(219);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(222);
      if (lookahead == '=') ADVANCE(219);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(244);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(245);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(228);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(214);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(65);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(256);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(256);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(96);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(256);
      if (set_contains(sym_number_literal_character_set_13, 13, lookahead)) ADVANCE(272);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 97,
        '.', 270,
        'B', 266,
        'b', 266,
        'E', 265,
        'e', 265,
        'P', 269,
        'p', 269,
        'X', 100,
        'x', 100,
        'A', 267,
        'C', 267,
        'a', 267,
        'c', 267,
        'D', 267,
        'F', 267,
        'd', 267,
        'f', 267,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(258);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 97,
        '.', 270,
        'E', 265,
        'e', 265,
        'P', 269,
        'p', 269,
        'A', 267,
        'C', 267,
        'a', 267,
        'c', 267,
        'B', 267,
        'D', 267,
        'F', 267,
        'b', 267,
        'd', 267,
        'f', 267,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(258);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 95,
        '.', 270,
        'B', 268,
        'b', 268,
        'X', 64,
        'x', 64,
        'E', 269,
        'P', 269,
        'e', 269,
        'p', 269,
        'D', 272,
        'F', 272,
        'L', 272,
        'U', 272,
        'W', 272,
        'd', 272,
        'f', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 95,
        '.', 270,
        'B', 271,
        'b', 271,
        'X', 100,
        'x', 100,
        'E', 269,
        'P', 269,
        'e', 269,
        'p', 269,
        'D', 272,
        'F', 272,
        'L', 272,
        'U', 272,
        'W', 272,
        'd', 272,
        'f', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(261);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(95);
      if (lookahead == '.') ADVANCE(270);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_number_literal_character_set_13, 13, lookahead)) ADVANCE(272);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 101,
        'B', 262,
        'D', 262,
        'F', 262,
        'b', 262,
        'd', 262,
        'f', 262,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(262);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 99,
        '+', 101,
        '-', 101,
        'E', 263,
        'e', 263,
        'P', 269,
        'p', 269,
        'B', 264,
        'D', 264,
        'F', 264,
        'b', 264,
        'd', 264,
        'f', 264,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(264);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 99,
        'E', 263,
        'e', 263,
        'P', 269,
        'p', 269,
        'B', 264,
        'D', 264,
        'F', 264,
        'b', 264,
        'd', 264,
        'f', 264,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(264);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 100,
        '.', 270,
        '+', 101,
        '-', 101,
        'E', 265,
        'e', 265,
        'P', 269,
        'p', 269,
        'B', 267,
        'D', 267,
        'F', 267,
        'b', 267,
        'd', 267,
        'f', 267,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(267);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 100,
        '.', 270,
        'E', 265,
        'e', 265,
        'P', 269,
        'p', 269,
        'A', 267,
        'C', 267,
        'a', 267,
        'c', 267,
        'B', 267,
        'D', 267,
        'F', 267,
        'b', 267,
        'd', 267,
        'f', 267,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(258);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 100,
        '.', 270,
        'E', 265,
        'e', 265,
        'P', 269,
        'p', 269,
        'B', 267,
        'D', 267,
        'F', 267,
        'b', 267,
        'd', 267,
        'f', 267,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(267);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(260);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_number_literal_character_set_13, 13, lookahead)) ADVANCE(272);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '+', 101,
        '-', 101,
        'B', 262,
        'D', 262,
        'F', 262,
        'b', 262,
        'd', 262,
        'f', 262,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(262);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        'E', 263,
        'e', 263,
        'P', 269,
        'p', 269,
        'B', 264,
        'D', 264,
        'F', 264,
        'b', 264,
        'd', 264,
        'f', 264,
        'L', 272,
        'U', 272,
        'W', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(264);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(261);
      if (set_contains(sym_number_literal_character_set_13, 13, lookahead)) ADVANCE(272);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        'B', 272,
        'D', 272,
        'F', 272,
        'L', 272,
        'U', 272,
        'W', 272,
        'b', 272,
        'd', 272,
        'f', 272,
        'l', 272,
        'u', 272,
        'w', 272,
      );
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_L_SQUOTE);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_u_SQUOTE);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_U_SQUOTE);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_u8_SQUOTE);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '\n') ADVANCE(293);
      if (lookahead == '\r') ADVANCE(292);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      if (lookahead == 'x') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(295);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '/') ADVANCE(318);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '\\') ADVANCE(31);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_L_DQUOTE);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_u_DQUOTE);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_U_DQUOTE);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_u8_DQUOTE);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(289);
      if (lookahead == '/') ADVANCE(291);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(291);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(288);
      if (lookahead == '/') ADVANCE(291);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(289);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(288);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(289);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '/') ADVANCE(287);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(290);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(291);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(291);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(31);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(292);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(294);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_system_lib_string);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_system_lib_string);
      if (lookahead == '>') ADVANCE(296);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(70);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(282);
      if (lookahead == '\'') ADVANCE(273);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(282);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(284);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(284);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(283);
      if (lookahead == '\'') ADVANCE(274);
      if (lookahead == '8') ADVANCE(304);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(283);
      if (lookahead == '8') ADVANCE(305);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(285);
      if (lookahead == '\'') ADVANCE(276);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(285);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(273);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(274);
      if (lookahead == '8') ADVANCE(309);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(276);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(310);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(318);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead != 0) ADVANCE(316);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\r') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(313);
      if (lookahead != 0) ADVANCE(318);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\r') ADVANCE(317);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(314);
      if (lookahead != 0) ADVANCE(316);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(318);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(316);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(316);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead != 0) ADVANCE(316);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(318);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead != 0) ADVANCE(318);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '\\') SKIP(4);
      if (lookahead == '_') ADVANCE(5);
      if (lookahead == 'a') ADVANCE(6);
      if (lookahead == 'b') ADVANCE(7);
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 'd') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(10);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'g') ADVANCE(12);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'm') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(16);
      if (lookahead == 'o') ADVANCE(17);
      if (lookahead == 'p') ADVANCE(18);
      if (lookahead == 'r') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      if (lookahead == 't') ADVANCE(21);
      if (lookahead == 'u') ADVANCE(22);
      if (lookahead == 'v') ADVANCE(23);
      if (lookahead == 'w') ADVANCE(24);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'A') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'U') ADVANCE(26);
      END_STATE();
    case 3:
      if (lookahead == 'R') ADVANCE(27);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(0);
      if (lookahead == '\r') SKIP(28);
      END_STATE();
    case 5:
      if (lookahead == 'A') ADVANCE(29);
      if (lookahead == 'G') ADVANCE(30);
      if (lookahead == 'N') ADVANCE(31);
      if (lookahead == '_') ADVANCE(32);
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(35);
      if (lookahead == 's') ADVANCE(36);
      if (lookahead == 'u') ADVANCE(37);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(40);
      if (lookahead == 'h') ADVANCE(41);
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'o') ADVANCE(44);
      END_STATE();
    case 10:
      if (lookahead == 'l') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(47);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(48);
      if (lookahead == 'l') ADVANCE(49);
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 12:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 14:
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 17:
      if (lookahead == 'f') ADVANCE(58);
      END_STATE();
    case 18:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(62);
      if (lookahead == 's') ADVANCE(63);
      if (lookahead == 't') ADVANCE(64);
      if (lookahead == 'w') ADVANCE(65);
      END_STATE();
    case 21:
      if (lookahead == 'h') ADVANCE(66);
      if (lookahead == 'r') ADVANCE(67);
      if (lookahead == 'y') ADVANCE(68);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(69);
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 23:
      if (lookahead == 'o') ADVANCE(71);
      END_STATE();
    case 24:
      if (lookahead == 'h') ADVANCE(72);
      END_STATE();
    case 25:
      if (lookahead == 'L') ADVANCE(73);
      END_STATE();
    case 26:
      if (lookahead == 'L') ADVANCE(74);
      END_STATE();
    case 27:
      if (lookahead == 'U') ADVANCE(75);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(0);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(76);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(78);
      END_STATE();
    case 31:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 32:
      ADVANCE_MAP(
        'a', 80,
        'b', 81,
        'c', 82,
        'd', 83,
        'e', 84,
        'f', 85,
        'i', 86,
        'l', 87,
        'r', 88,
        's', 89,
        't', 90,
        'u', 91,
        'v', 92,
      );
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(94);
      END_STATE();
    case 35:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 36:
      if (lookahead == 'm') ADVANCE(96);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(98);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 40:
      if (lookahead == 's') ADVANCE(100);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 42:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(103);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(104);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(105);
      END_STATE();
    case 46:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 49:
      if (lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(110);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(112);
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 55:
      if (lookahead == 'x') ADVANCE(115);
      END_STATE();
    case 56:
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 58:
      if (lookahead == 'f') ADVANCE(118);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(119);
      END_STATE();
    case 60:
      if (lookahead == 'g') ADVANCE(120);
      if (lookahead == 's') ADVANCE(121);
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 61:
      if (lookahead == 'o') ADVANCE(123);
      END_STATE();
    case 62:
      if (lookahead == 'g') ADVANCE(124);
      if (lookahead == 'z') ADVANCE(125);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(127);
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(129);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 67:
      if (lookahead == 'u') ADVANCE(131);
      END_STATE();
    case 68:
      if (lookahead == 'p') ADVANCE(132);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(133);
      END_STATE();
    case 70:
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == 's') ADVANCE(135);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'l') ADVANCE(137);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(138);
      END_STATE();
    case 73:
      if (lookahead == 'S') ADVANCE(139);
      END_STATE();
    case 74:
      if (lookahead == 'L') ADVANCE(140);
      END_STATE();
    case 75:
      if (lookahead == 'E') ADVANCE(141);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 77:
      if (lookahead == 'o') ADVANCE(143);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 79:
      if (lookahead == 'r') ADVANCE(145);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(146);
      if (lookahead == 's') ADVANCE(147);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 82:
      if (lookahead == 'd') ADVANCE(150);
      if (lookahead == 'l') ADVANCE(151);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 84:
      if (lookahead == 'x') ADVANCE(153);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(154);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 86:
      if (lookahead == 'n') ADVANCE(157);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 89:
      if (lookahead == 'p') ADVANCE(160);
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 90:
      if (lookahead == 'h') ADVANCE(162);
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 91:
      if (lookahead == 'n') ADVANCE(164);
      if (lookahead == 'p') ADVANCE(165);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 94:
      if (lookahead == 'a') ADVANCE(168);
      END_STATE();
    case 95:
      if (lookahead == 'g') ADVANCE(169);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_asm);
      END_STATE();
    case 97:
      if (lookahead == 'o') ADVANCE(170);
      END_STATE();
    case 98:
      if (lookahead == 'l') ADVANCE(171);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(172);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 102:
      if (lookahead == 's') ADVANCE(175);
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(177);
      if (lookahead == 'i') ADVANCE(178);
      END_STATE();
    case 104:
      if (lookahead == 'b') ADVANCE(179);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 106:
      if (lookahead == 'm') ADVANCE(181);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 111:
      if (lookahead == 'o') ADVANCE(185);
      END_STATE();
    case 112:
      if (lookahead == 'i') ADVANCE(186);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(187);
      if (lookahead == '3') ADVANCE(188);
      if (lookahead == '6') ADVANCE(189);
      if (lookahead == '8') ADVANCE(190);
      if (lookahead == 'p') ADVANCE(191);
      END_STATE();
    case 114:
      if (lookahead == 'g') ADVANCE(192);
      END_STATE();
    case 115:
      if (lookahead == '_') ADVANCE(193);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 117:
      if (lookahead == 'l') ADVANCE(195);
      END_STATE();
    case 118:
      if (lookahead == 's') ADVANCE(196);
      END_STATE();
    case 119:
      if (lookahead == 'd') ADVANCE(197);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(198);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 122:
      if (lookahead == 'u') ADVANCE(200);
      END_STATE();
    case 123:
      if (lookahead == 'r') ADVANCE(201);
      END_STATE();
    case 124:
      if (lookahead == 'n') ADVANCE(202);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 126:
      if (lookahead == 'z') ADVANCE(204);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(205);
      END_STATE();
    case 128:
      if (lookahead == 'u') ADVANCE(206);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(209);
      END_STATE();
    case 133:
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 134:
      if (lookahead == 'o') ADVANCE(211);
      END_STATE();
    case 135:
      if (lookahead == 'i') ADVANCE(212);
      END_STATE();
    case 136:
      if (lookahead == 'd') ADVANCE(171);
      END_STATE();
    case 137:
      if (lookahead == 'a') ADVANCE(213);
      END_STATE();
    case 138:
      if (lookahead == 'l') ADVANCE(214);
      END_STATE();
    case 139:
      if (lookahead == 'E') ADVANCE(215);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_NULL);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 142:
      if (lookahead == 'g') ADVANCE(216);
      END_STATE();
    case 143:
      if (lookahead == 'm') ADVANCE(217);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 146:
      if (lookahead == 'i') ADVANCE(220);
      END_STATE();
    case 147:
      if (lookahead == 'm') ADVANCE(221);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(222);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(224);
      END_STATE();
    case 151:
      if (lookahead == 'r') ADVANCE(225);
      END_STATE();
    case 152:
      if (lookahead == 'c') ADVANCE(226);
      END_STATE();
    case 153:
      if (lookahead == 'c') ADVANCE(227);
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 154:
      if (lookahead == 's') ADVANCE(229);
      END_STATE();
    case 155:
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(231);
      END_STATE();
    case 157:
      if (lookahead == 'l') ADVANCE(232);
      END_STATE();
    case 158:
      if (lookahead == 'a') ADVANCE(233);
      END_STATE();
    case 159:
      if (lookahead == 's') ADVANCE(234);
      END_STATE();
    case 160:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 161:
      if (lookahead == 'd') ADVANCE(236);
      END_STATE();
    case 162:
      if (lookahead == 'i') ADVANCE(237);
      if (lookahead == 'r') ADVANCE(238);
      END_STATE();
    case 163:
      if (lookahead == 'y') ADVANCE(239);
      END_STATE();
    case 164:
      if (lookahead == 'a') ADVANCE(240);
      END_STATE();
    case 165:
      if (lookahead == 't') ADVANCE(241);
      END_STATE();
    case 166:
      if (lookahead == 'c') ADVANCE(242);
      END_STATE();
    case 167:
      if (lookahead == 'g') ADVANCE(243);
      END_STATE();
    case 168:
      if (lookahead == 'l') ADVANCE(244);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(245);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_auto);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_primitive_type);
      END_STATE();
    case 172:
      if (lookahead == 'k') ADVANCE(246);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(247);
      if (lookahead == '3') ADVANCE(248);
      if (lookahead == '6') ADVANCE(249);
      if (lookahead == '8') ADVANCE(250);
      if (lookahead == 'p') ADVANCE(251);
      END_STATE();
    case 175:
      if (lookahead == 't') ADVANCE(252);
      END_STATE();
    case 176:
      if (lookahead == 'i') ADVANCE(253);
      END_STATE();
    case 177:
      if (lookahead == 'u') ADVANCE(254);
      END_STATE();
    case 178:
      if (lookahead == 'n') ADVANCE(255);
      END_STATE();
    case 179:
      if (lookahead == 'l') ADVANCE(256);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(257);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 184:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 186:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 187:
      if (lookahead == '6') ADVANCE(259);
      END_STATE();
    case 188:
      if (lookahead == '2') ADVANCE(260);
      END_STATE();
    case 189:
      if (lookahead == '4') ADVANCE(261);
      END_STATE();
    case 190:
      if (lookahead == '_') ADVANCE(262);
      END_STATE();
    case 191:
      if (lookahead == 't') ADVANCE(263);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 193:
      if (lookahead == 'a') ADVANCE(264);
      END_STATE();
    case 194:
      if (lookahead == 't') ADVANCE(265);
      END_STATE();
    case 195:
      if (lookahead == 'p') ADVANCE(266);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 197:
      if (lookahead == 'i') ADVANCE(268);
      END_STATE();
    case 198:
      if (lookahead == 's') ADVANCE(269);
      END_STATE();
    case 199:
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 200:
      if (lookahead == 'r') ADVANCE(271);
      END_STATE();
    case 201:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 202:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 203:
      if (lookahead == '_') ADVANCE(274);
      if (lookahead == 'o') ADVANCE(275);
      END_STATE();
    case 204:
      if (lookahead == 'e') ADVANCE(276);
      END_STATE();
    case 205:
      if (lookahead == 'i') ADVANCE(277);
      END_STATE();
    case 206:
      if (lookahead == 'c') ADVANCE(278);
      END_STATE();
    case 207:
      if (lookahead == 'c') ADVANCE(279);
      END_STATE();
    case 208:
      if (lookahead == 'a') ADVANCE(280);
      END_STATE();
    case 209:
      if (lookahead == 'd') ADVANCE(281);
      END_STATE();
    case 210:
      if (lookahead == '1') ADVANCE(282);
      if (lookahead == '3') ADVANCE(283);
      if (lookahead == '6') ADVANCE(284);
      if (lookahead == '8') ADVANCE(285);
      if (lookahead == 'p') ADVANCE(286);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(287);
      END_STATE();
    case 212:
      if (lookahead == 'g') ADVANCE(288);
      END_STATE();
    case 213:
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(290);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 216:
      if (lookahead == 'n') ADVANCE(291);
      END_STATE();
    case 217:
      if (lookahead == 'i') ADVANCE(292);
      END_STATE();
    case 218:
      if (lookahead == 'r') ADVANCE(293);
      END_STATE();
    case 219:
      if (lookahead == 't') ADVANCE(294);
      END_STATE();
    case 220:
      if (lookahead == 'g') ADVANCE(295);
      END_STATE();
    case 221:
      if (lookahead == '_') ADVANCE(296);
      END_STATE();
    case 222:
      if (lookahead == 'r') ADVANCE(297);
      END_STATE();
    case 223:
      if (lookahead == 'e') ADVANCE(298);
      END_STATE();
    case 224:
      if (lookahead == 'c') ADVANCE(299);
      END_STATE();
    case 225:
      if (lookahead == 'c') ADVANCE(300);
      END_STATE();
    case 226:
      if (lookahead == 'l') ADVANCE(301);
      END_STATE();
    case 227:
      if (lookahead == 'e') ADVANCE(302);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(303);
      END_STATE();
    case 229:
      if (lookahead == 't') ADVANCE(304);
      END_STATE();
    case 230:
      if (lookahead == 'a') ADVANCE(305);
      END_STATE();
    case 231:
      if (lookahead == 'c') ADVANCE(306);
      END_STATE();
    case 232:
      if (lookahead == 'i') ADVANCE(307);
      END_STATE();
    case 233:
      if (lookahead == 'v') ADVANCE(308);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(309);
      END_STATE();
    case 235:
      if (lookahead == 'r') ADVANCE(310);
      END_STATE();
    case 236:
      if (lookahead == 'c') ADVANCE(311);
      END_STATE();
    case 237:
      if (lookahead == 's') ADVANCE(312);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(313);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym___try);
      END_STATE();
    case 240:
      if (lookahead == 'l') ADVANCE(314);
      END_STATE();
    case 241:
      if (lookahead == 'r') ADVANCE(315);
      END_STATE();
    case 242:
      if (lookahead == 't') ADVANCE(316);
      END_STATE();
    case 243:
      if (lookahead == 'n') ADVANCE(317);
      END_STATE();
    case 244:
      if (lookahead == 'i') ADVANCE(318);
      END_STATE();
    case 245:
      if (lookahead == 'a') ADVANCE(319);
      if (lookahead == 'o') ADVANCE(320);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 247:
      if (lookahead == '6') ADVANCE(321);
      END_STATE();
    case 248:
      if (lookahead == '2') ADVANCE(322);
      END_STATE();
    case 249:
      if (lookahead == '4') ADVANCE(323);
      END_STATE();
    case 250:
      if (lookahead == '_') ADVANCE(324);
      END_STATE();
    case 251:
      if (lookahead == 't') ADVANCE(325);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_const);
      if (lookahead == 'e') ADVANCE(326);
      END_STATE();
    case 253:
      if (lookahead == 'n') ADVANCE(327);
      END_STATE();
    case 254:
      if (lookahead == 'l') ADVANCE(328);
      END_STATE();
    case 255:
      if (lookahead == 'e') ADVANCE(329);
      END_STATE();
    case 256:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 257:
      if (lookahead == 'n') ADVANCE(330);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(331);
      END_STATE();
    case 259:
      if (lookahead == '_') ADVANCE(332);
      END_STATE();
    case 260:
      if (lookahead == '_') ADVANCE(333);
      END_STATE();
    case 261:
      if (lookahead == '_') ADVANCE(334);
      END_STATE();
    case 262:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 263:
      if (lookahead == 'r') ADVANCE(335);
      END_STATE();
    case 264:
      if (lookahead == 'l') ADVANCE(336);
      END_STATE();
    case 265:
      if (lookahead == 'u') ADVANCE(337);
      END_STATE();
    case 266:
      if (lookahead == 't') ADVANCE(338);
      END_STATE();
    case 267:
      if (lookahead == 't') ADVANCE(339);
      END_STATE();
    case 268:
      if (lookahead == 'f') ADVANCE(340);
      END_STATE();
    case 269:
      if (lookahead == 't') ADVANCE(341);
      END_STATE();
    case 270:
      if (lookahead == 'i') ADVANCE(342);
      END_STATE();
    case 271:
      if (lookahead == 'n') ADVANCE(343);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 273:
      if (lookahead == 'd') ADVANCE(344);
      END_STATE();
    case 274:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 275:
      if (lookahead == 'f') ADVANCE(345);
      END_STATE();
    case 276:
      if (lookahead == '_') ADVANCE(346);
      END_STATE();
    case 277:
      if (lookahead == 'c') ADVANCE(347);
      END_STATE();
    case 278:
      if (lookahead == 't') ADVANCE(348);
      END_STATE();
    case 279:
      if (lookahead == 'h') ADVANCE(349);
      END_STATE();
    case 280:
      if (lookahead == 'd') ADVANCE(350);
      END_STATE();
    case 281:
      if (lookahead == 'e') ADVANCE(351);
      END_STATE();
    case 282:
      if (lookahead == '6') ADVANCE(352);
      END_STATE();
    case 283:
      if (lookahead == '2') ADVANCE(353);
      END_STATE();
    case 284:
      if (lookahead == '4') ADVANCE(354);
      END_STATE();
    case 285:
      if (lookahead == '_') ADVANCE(355);
      END_STATE();
    case 286:
      if (lookahead == 't') ADVANCE(356);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 288:
      if (lookahead == 'n') ADVANCE(357);
      END_STATE();
    case 289:
      if (lookahead == 'i') ADVANCE(358);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 291:
      if (lookahead == 'a') ADVANCE(359);
      if (lookahead == 'o') ADVANCE(360);
      END_STATE();
    case 292:
      if (lookahead == 'c') ADVANCE(361);
      END_STATE();
    case 293:
      if (lookahead == 'i') ADVANCE(362);
      END_STATE();
    case 294:
      if (lookahead == 'u') ADVANCE(363);
      END_STATE();
    case 295:
      if (lookahead == 'n') ADVANCE(364);
      END_STATE();
    case 296:
      if (lookahead == '_') ADVANCE(365);
      END_STATE();
    case 297:
      if (lookahead == 'i') ADVANCE(366);
      END_STATE();
    case 298:
      if (lookahead == 'd') ADVANCE(367);
      END_STATE();
    case 299:
      if (lookahead == 'l') ADVANCE(368);
      END_STATE();
    case 300:
      if (lookahead == 'a') ADVANCE(369);
      END_STATE();
    case 301:
      if (lookahead == 's') ADVANCE(370);
      END_STATE();
    case 302:
      if (lookahead == 'p') ADVANCE(371);
      END_STATE();
    case 303:
      if (lookahead == 'n') ADVANCE(372);
      END_STATE();
    case 304:
      if (lookahead == 'c') ADVANCE(373);
      END_STATE();
    case 305:
      if (lookahead == 'l') ADVANCE(374);
      END_STATE();
    case 306:
      if (lookahead == 'e') ADVANCE(375);
      END_STATE();
    case 307:
      if (lookahead == 'n') ADVANCE(376);
      END_STATE();
    case 308:
      if (lookahead == 'e') ADVANCE(377);
      END_STATE();
    case 309:
      if (lookahead == 'r') ADVANCE(378);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_ms_signed_ptr_modifier);
      END_STATE();
    case 311:
      if (lookahead == 'a') ADVANCE(379);
      END_STATE();
    case 312:
      if (lookahead == 'c') ADVANCE(380);
      END_STATE();
    case 313:
      if (lookahead == 'a') ADVANCE(381);
      END_STATE();
    case 314:
      if (lookahead == 'i') ADVANCE(382);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_ms_unsigned_ptr_modifier);
      END_STATE();
    case 316:
      if (lookahead == 'o') ADVANCE(383);
      END_STATE();
    case 317:
      if (lookahead == 'o') ADVANCE(384);
      END_STATE();
    case 318:
      if (lookahead == 'g') ADVANCE(385);
      END_STATE();
    case 319:
      if (lookahead == 's') ADVANCE(386);
      END_STATE();
    case 320:
      if (lookahead == 'f') ADVANCE(387);
      END_STATE();
    case 321:
      if (lookahead == '_') ADVANCE(388);
      END_STATE();
    case 322:
      if (lookahead == '_') ADVANCE(389);
      END_STATE();
    case 323:
      if (lookahead == '_') ADVANCE(390);
      END_STATE();
    case 324:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 325:
      if (lookahead == 'r') ADVANCE(391);
      END_STATE();
    case 326:
      if (lookahead == 'x') ADVANCE(392);
      END_STATE();
    case 327:
      if (lookahead == 'u') ADVANCE(393);
      END_STATE();
    case 328:
      if (lookahead == 't') ADVANCE(394);
      END_STATE();
    case 329:
      if (lookahead == 'd') ADVANCE(395);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_extern);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_inline);
      END_STATE();
    case 332:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 333:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 334:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 335:
      if (lookahead == '_') ADVANCE(396);
      END_STATE();
    case 336:
      if (lookahead == 'i') ADVANCE(397);
      END_STATE();
    case 337:
      if (lookahead == 'r') ADVANCE(398);
      END_STATE();
    case 338:
      if (lookahead == 'r') ADVANCE(399);
      END_STATE();
    case 339:
      if (lookahead == 'o') ADVANCE(400);
      END_STATE();
    case 340:
      if (lookahead == 'f') ADVANCE(401);
      END_STATE();
    case 341:
      if (lookahead == 'e') ADVANCE(402);
      END_STATE();
    case 342:
      if (lookahead == 'c') ADVANCE(403);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_sizeof);
      END_STATE();
    case 346:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 350:
      if (lookahead == '_') ADVANCE(404);
      END_STATE();
    case 351:
      if (lookahead == 'f') ADVANCE(405);
      END_STATE();
    case 352:
      if (lookahead == '_') ADVANCE(406);
      END_STATE();
    case 353:
      if (lookahead == '_') ADVANCE(407);
      END_STATE();
    case 354:
      if (lookahead == '_') ADVANCE(408);
      END_STATE();
    case 355:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 356:
      if (lookahead == 'r') ADVANCE(409);
      END_STATE();
    case 357:
      if (lookahead == 'e') ADVANCE(410);
      END_STATE();
    case 358:
      if (lookahead == 'l') ADVANCE(411);
      END_STATE();
    case 359:
      if (lookahead == 's') ADVANCE(412);
      END_STATE();
    case 360:
      if (lookahead == 'f') ADVANCE(413);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym__Atomic);
      END_STATE();
    case 362:
      if (lookahead == 'c') ADVANCE(414);
      END_STATE();
    case 363:
      if (lookahead == 'r') ADVANCE(415);
      END_STATE();
    case 364:
      if (lookahead == 'o') ADVANCE(416);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym___asm__);
      END_STATE();
    case 366:
      if (lookahead == 'b') ADVANCE(417);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym___based);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym___cdecl);
      END_STATE();
    case 369:
      if (lookahead == 'l') ADVANCE(418);
      END_STATE();
    case 370:
      if (lookahead == 'p') ADVANCE(419);
      END_STATE();
    case 371:
      if (lookahead == 't') ADVANCE(420);
      END_STATE();
    case 372:
      if (lookahead == 's') ADVANCE(421);
      END_STATE();
    case 373:
      if (lookahead == 'a') ADVANCE(422);
      END_STATE();
    case 374:
      if (lookahead == 'l') ADVANCE(423);
      END_STATE();
    case 375:
      if (lookahead == 'i') ADVANCE(424);
      END_STATE();
    case 376:
      if (lookahead == 'e') ADVANCE(425);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym___leave);
      END_STATE();
    case 378:
      if (lookahead == 'i') ADVANCE(426);
      END_STATE();
    case 379:
      if (lookahead == 'l') ADVANCE(427);
      END_STATE();
    case 380:
      if (lookahead == 'a') ADVANCE(428);
      END_STATE();
    case 381:
      if (lookahead == 'd') ADVANCE(429);
      END_STATE();
    case 382:
      if (lookahead == 'g') ADVANCE(430);
      END_STATE();
    case 383:
      if (lookahead == 'r') ADVANCE(431);
      END_STATE();
    case 384:
      if (lookahead == 'f') ADVANCE(432);
      END_STATE();
    case 385:
      if (lookahead == 'n') ADVANCE(433);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_alignas);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_alignof);
      END_STATE();
    case 388:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 389:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 390:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 391:
      if (lookahead == '_') ADVANCE(434);
      END_STATE();
    case 392:
      if (lookahead == 'p') ADVANCE(435);
      END_STATE();
    case 393:
      if (lookahead == 'e') ADVANCE(436);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_defined);
      END_STATE();
    case 396:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 397:
      if (lookahead == 'g') ADVANCE(437);
      END_STATE();
    case 398:
      if (lookahead == 'n') ADVANCE(438);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(anon_sym_nullptr);
      if (lookahead == '_') ADVANCE(439);
      END_STATE();
    case 400:
      if (lookahead == 'f') ADVANCE(440);
      END_STATE();
    case 401:
      if (lookahead == '_') ADVANCE(441);
      END_STATE();
    case 402:
      if (lookahead == 'r') ADVANCE(442);
      END_STATE();
    case 403:
      if (lookahead == 't') ADVANCE(443);
      END_STATE();
    case 404:
      if (lookahead == 'l') ADVANCE(444);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym_typedef);
      END_STATE();
    case 406:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 407:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 408:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 409:
      if (lookahead == '_') ADVANCE(445);
      END_STATE();
    case 410:
      if (lookahead == 'd') ADVANCE(446);
      END_STATE();
    case 411:
      if (lookahead == 'e') ADVANCE(447);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym__Alignas);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym__Alignof);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym__Generic);
      END_STATE();
    case 415:
      if (lookahead == 'n') ADVANCE(448);
      END_STATE();
    case 416:
      if (lookahead == 'f') ADVANCE(449);
      END_STATE();
    case 417:
      if (lookahead == 'u') ADVANCE(450);
      END_STATE();
    case 418:
      if (lookahead == 'l') ADVANCE(451);
      END_STATE();
    case 419:
      if (lookahead == 'e') ADVANCE(452);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym___except);
      END_STATE();
    case 421:
      if (lookahead == 'i') ADVANCE(453);
      END_STATE();
    case 422:
      if (lookahead == 'l') ADVANCE(454);
      END_STATE();
    case 423:
      if (lookahead == 'y') ADVANCE(455);
      END_STATE();
    case 424:
      if (lookahead == 'n') ADVANCE(456);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym___inline);
      if (lookahead == '_') ADVANCE(457);
      END_STATE();
    case 426:
      if (lookahead == 'c') ADVANCE(458);
      END_STATE();
    case 427:
      if (lookahead == 'l') ADVANCE(459);
      END_STATE();
    case 428:
      if (lookahead == 'l') ADVANCE(460);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym___thread);
      END_STATE();
    case 430:
      if (lookahead == 'n') ADVANCE(461);
      END_STATE();
    case 431:
      if (lookahead == 'c') ADVANCE(462);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym__alignof);
      END_STATE();
    case 433:
      if (lookahead == 'e') ADVANCE(463);
      END_STATE();
    case 434:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 435:
      if (lookahead == 'r') ADVANCE(464);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 437:
      if (lookahead == 'n') ADVANCE(465);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_noreturn);
      END_STATE();
    case 439:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_offsetof);
      END_STATE();
    case 441:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_register);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_restrict);
      END_STATE();
    case 444:
      if (lookahead == 'o') ADVANCE(466);
      END_STATE();
    case 445:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym__Noreturn);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym___alignof);
      if (lookahead == '_') ADVANCE(467);
      END_STATE();
    case 450:
      if (lookahead == 't') ADVANCE(468);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym___clrcall);
      END_STATE();
    case 452:
      if (lookahead == 'c') ADVANCE(469);
      END_STATE();
    case 453:
      if (lookahead == 'o') ADVANCE(470);
      END_STATE();
    case 454:
      if (lookahead == 'l') ADVANCE(471);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym___finally);
      END_STATE();
    case 456:
      if (lookahead == 'l') ADVANCE(472);
      END_STATE();
    case 457:
      if (lookahead == '_') ADVANCE(473);
      END_STATE();
    case 458:
      if (lookahead == 't') ADVANCE(474);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym___stdcall);
      END_STATE();
    case 460:
      if (lookahead == 'l') ADVANCE(475);
      END_STATE();
    case 461:
      if (lookahead == 'e') ADVANCE(476);
      END_STATE();
    case 462:
      if (lookahead == 'a') ADVANCE(477);
      END_STATE();
    case 463:
      if (lookahead == 'd') ADVANCE(478);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_constexpr);
      END_STATE();
    case 465:
      if (lookahead == '_') ADVANCE(479);
      END_STATE();
    case 466:
      if (lookahead == 'c') ADVANCE(480);
      END_STATE();
    case 467:
      if (lookahead == '_') ADVANCE(481);
      END_STATE();
    case 468:
      if (lookahead == 'e') ADVANCE(482);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym___declspec);
      END_STATE();
    case 470:
      if (lookahead == 'n') ADVANCE(483);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym___fastcall);
      END_STATE();
    case 472:
      if (lookahead == 'i') ADVANCE(484);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym___inline__);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(sym_ms_restrict_modifier);
      if (lookahead == '_') ADVANCE(485);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym___thiscall);
      END_STATE();
    case 476:
      if (lookahead == 'd') ADVANCE(486);
      END_STATE();
    case 477:
      if (lookahead == 'l') ADVANCE(487);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym__unaligned);
      END_STATE();
    case 479:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 480:
      if (lookahead == 'a') ADVANCE(488);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym___alignof__);
      END_STATE();
    case 482:
      if (lookahead == '_') ADVANCE(489);
      END_STATE();
    case 483:
      if (lookahead == '_') ADVANCE(490);
      END_STATE();
    case 484:
      if (lookahead == 'n') ADVANCE(491);
      END_STATE();
    case 485:
      if (lookahead == '_') ADVANCE(492);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym___unaligned);
      END_STATE();
    case 487:
      if (lookahead == 'l') ADVANCE(493);
      END_STATE();
    case 488:
      if (lookahead == 'l') ADVANCE(494);
      END_STATE();
    case 489:
      if (lookahead == '_') ADVANCE(495);
      END_STATE();
    case 490:
      if (lookahead == '_') ADVANCE(496);
      END_STATE();
    case 491:
      if (lookahead == 'e') ADVANCE(497);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym___restrict__);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym___vectorcall);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(anon_sym_thread_local);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(anon_sym___attribute__);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(anon_sym___extension__);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(anon_sym___forceinline);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 119},
  [2] = {.lex_state = 45},
  [3] = {.lex_state = 45},
  [4] = {.lex_state = 45},
  [5] = {.lex_state = 45},
  [6] = {.lex_state = 45},
  [7] = {.lex_state = 45},
  [8] = {.lex_state = 45},
  [9] = {.lex_state = 45},
  [10] = {.lex_state = 45},
  [11] = {.lex_state = 45},
  [12] = {.lex_state = 45},
  [13] = {.lex_state = 45},
  [14] = {.lex_state = 45},
  [15] = {.lex_state = 45},
  [16] = {.lex_state = 45},
  [17] = {.lex_state = 45},
  [18] = {.lex_state = 45},
  [19] = {.lex_state = 45},
  [20] = {.lex_state = 45},
  [21] = {.lex_state = 45},
  [22] = {.lex_state = 45},
  [23] = {.lex_state = 119},
  [24] = {.lex_state = 119},
  [25] = {.lex_state = 119},
  [26] = {.lex_state = 47},
  [27] = {.lex_state = 119},
  [28] = {.lex_state = 119},
  [29] = {.lex_state = 119},
  [30] = {.lex_state = 119},
  [31] = {.lex_state = 47},
  [32] = {.lex_state = 119},
  [33] = {.lex_state = 119},
  [34] = {.lex_state = 119},
  [35] = {.lex_state = 119},
  [36] = {.lex_state = 47},
  [37] = {.lex_state = 119},
  [38] = {.lex_state = 119},
  [39] = {.lex_state = 119},
  [40] = {.lex_state = 119},
  [41] = {.lex_state = 119},
  [42] = {.lex_state = 119},
  [43] = {.lex_state = 119},
  [44] = {.lex_state = 119},
  [45] = {.lex_state = 45},
  [46] = {.lex_state = 45},
  [47] = {.lex_state = 45},
  [48] = {.lex_state = 45},
  [49] = {.lex_state = 45},
  [50] = {.lex_state = 47},
  [51] = {.lex_state = 47},
  [52] = {.lex_state = 119},
  [53] = {.lex_state = 47},
  [54] = {.lex_state = 119},
  [55] = {.lex_state = 47},
  [56] = {.lex_state = 119},
  [57] = {.lex_state = 119},
  [58] = {.lex_state = 47},
  [59] = {.lex_state = 119},
  [60] = {.lex_state = 119},
  [61] = {.lex_state = 119},
  [62] = {.lex_state = 119},
  [63] = {.lex_state = 119},
  [64] = {.lex_state = 119},
  [65] = {.lex_state = 119},
  [66] = {.lex_state = 119},
  [67] = {.lex_state = 119},
  [68] = {.lex_state = 119},
  [69] = {.lex_state = 119},
  [70] = {.lex_state = 119},
  [71] = {.lex_state = 119},
  [72] = {.lex_state = 119},
  [73] = {.lex_state = 119},
  [74] = {.lex_state = 119},
  [75] = {.lex_state = 45},
  [76] = {.lex_state = 45},
  [77] = {.lex_state = 119},
  [78] = {.lex_state = 45},
  [79] = {.lex_state = 45},
  [80] = {.lex_state = 45},
  [81] = {.lex_state = 45},
  [82] = {.lex_state = 45},
  [83] = {.lex_state = 45},
  [84] = {.lex_state = 45},
  [85] = {.lex_state = 45},
  [86] = {.lex_state = 45},
  [87] = {.lex_state = 45},
  [88] = {.lex_state = 45},
  [89] = {.lex_state = 45},
  [90] = {.lex_state = 45},
  [91] = {.lex_state = 45},
  [92] = {.lex_state = 45},
  [93] = {.lex_state = 45},
  [94] = {.lex_state = 45},
  [95] = {.lex_state = 45},
  [96] = {.lex_state = 45},
  [97] = {.lex_state = 45},
  [98] = {.lex_state = 45},
  [99] = {.lex_state = 45},
  [100] = {.lex_state = 45},
  [101] = {.lex_state = 45},
  [102] = {.lex_state = 45},
  [103] = {.lex_state = 45},
  [104] = {.lex_state = 119},
  [105] = {.lex_state = 45},
  [106] = {.lex_state = 45},
  [107] = {.lex_state = 45},
  [108] = {.lex_state = 45},
  [109] = {.lex_state = 45},
  [110] = {.lex_state = 45},
  [111] = {.lex_state = 45},
  [112] = {.lex_state = 45},
  [113] = {.lex_state = 45},
  [114] = {.lex_state = 45},
  [115] = {.lex_state = 45},
  [116] = {.lex_state = 45},
  [117] = {.lex_state = 45},
  [118] = {.lex_state = 45},
  [119] = {.lex_state = 45},
  [120] = {.lex_state = 45},
  [121] = {.lex_state = 45},
  [122] = {.lex_state = 45},
  [123] = {.lex_state = 45},
  [124] = {.lex_state = 45},
  [125] = {.lex_state = 45},
  [126] = {.lex_state = 45},
  [127] = {.lex_state = 45},
  [128] = {.lex_state = 45},
  [129] = {.lex_state = 45},
  [130] = {.lex_state = 45},
  [131] = {.lex_state = 45},
  [132] = {.lex_state = 45},
  [133] = {.lex_state = 45},
  [134] = {.lex_state = 45},
  [135] = {.lex_state = 45},
  [136] = {.lex_state = 45},
  [137] = {.lex_state = 45},
  [138] = {.lex_state = 45},
  [139] = {.lex_state = 45},
  [140] = {.lex_state = 45},
  [141] = {.lex_state = 45},
  [142] = {.lex_state = 45},
  [143] = {.lex_state = 47},
  [144] = {.lex_state = 119},
  [145] = {.lex_state = 119},
  [146] = {.lex_state = 119},
  [147] = {.lex_state = 47},
  [148] = {.lex_state = 119},
  [149] = {.lex_state = 119},
  [150] = {.lex_state = 119},
  [151] = {.lex_state = 119},
  [152] = {.lex_state = 119},
  [153] = {.lex_state = 119},
  [154] = {.lex_state = 119},
  [155] = {.lex_state = 119},
  [156] = {.lex_state = 119},
  [157] = {.lex_state = 119},
  [158] = {.lex_state = 119},
  [159] = {.lex_state = 119},
  [160] = {.lex_state = 119},
  [161] = {.lex_state = 119},
  [162] = {.lex_state = 119},
  [163] = {.lex_state = 119},
  [164] = {.lex_state = 119},
  [165] = {.lex_state = 119},
  [166] = {.lex_state = 47},
  [167] = {.lex_state = 47},
  [168] = {.lex_state = 119},
  [169] = {.lex_state = 119},
  [170] = {.lex_state = 47},
  [171] = {.lex_state = 119},
  [172] = {.lex_state = 119},
  [173] = {.lex_state = 47},
  [174] = {.lex_state = 119},
  [175] = {.lex_state = 119},
  [176] = {.lex_state = 119},
  [177] = {.lex_state = 119},
  [178] = {.lex_state = 119},
  [179] = {.lex_state = 119},
  [180] = {.lex_state = 119},
  [181] = {.lex_state = 119},
  [182] = {.lex_state = 119},
  [183] = {.lex_state = 119},
  [184] = {.lex_state = 119},
  [185] = {.lex_state = 119},
  [186] = {.lex_state = 119},
  [187] = {.lex_state = 119},
  [188] = {.lex_state = 119},
  [189] = {.lex_state = 47},
  [190] = {.lex_state = 47},
  [191] = {.lex_state = 47},
  [192] = {.lex_state = 47},
  [193] = {.lex_state = 47},
  [194] = {.lex_state = 119},
  [195] = {.lex_state = 119},
  [196] = {.lex_state = 119},
  [197] = {.lex_state = 119},
  [198] = {.lex_state = 47},
  [199] = {.lex_state = 119},
  [200] = {.lex_state = 119},
  [201] = {.lex_state = 119},
  [202] = {.lex_state = 119},
  [203] = {.lex_state = 119},
  [204] = {.lex_state = 47},
  [205] = {.lex_state = 119},
  [206] = {.lex_state = 119},
  [207] = {.lex_state = 119},
  [208] = {.lex_state = 47},
  [209] = {.lex_state = 47},
  [210] = {.lex_state = 119},
  [211] = {.lex_state = 119},
  [212] = {.lex_state = 119},
  [213] = {.lex_state = 47},
  [214] = {.lex_state = 119},
  [215] = {.lex_state = 119},
  [216] = {.lex_state = 119},
  [217] = {.lex_state = 47},
  [218] = {.lex_state = 119},
  [219] = {.lex_state = 119},
  [220] = {.lex_state = 47},
  [221] = {.lex_state = 119},
  [222] = {.lex_state = 47},
  [223] = {.lex_state = 119},
  [224] = {.lex_state = 47},
  [225] = {.lex_state = 119},
  [226] = {.lex_state = 47},
  [227] = {.lex_state = 47},
  [228] = {.lex_state = 47},
  [229] = {.lex_state = 47},
  [230] = {.lex_state = 47},
  [231] = {.lex_state = 47},
  [232] = {.lex_state = 47},
  [233] = {.lex_state = 47},
  [234] = {.lex_state = 119},
  [235] = {.lex_state = 119},
  [236] = {.lex_state = 47},
  [237] = {.lex_state = 119},
  [238] = {.lex_state = 119},
  [239] = {.lex_state = 119},
  [240] = {.lex_state = 47},
  [241] = {.lex_state = 47},
  [242] = {.lex_state = 47},
  [243] = {.lex_state = 119},
  [244] = {.lex_state = 119},
  [245] = {.lex_state = 47},
  [246] = {.lex_state = 119},
  [247] = {.lex_state = 47},
  [248] = {.lex_state = 47},
  [249] = {.lex_state = 119},
  [250] = {.lex_state = 47},
  [251] = {.lex_state = 47},
  [252] = {.lex_state = 47},
  [253] = {.lex_state = 119},
  [254] = {.lex_state = 119},
  [255] = {.lex_state = 119},
  [256] = {.lex_state = 119},
  [257] = {.lex_state = 119},
  [258] = {.lex_state = 119},
  [259] = {.lex_state = 47},
  [260] = {.lex_state = 47},
  [261] = {.lex_state = 47},
  [262] = {.lex_state = 47},
  [263] = {.lex_state = 119},
  [264] = {.lex_state = 47},
  [265] = {.lex_state = 119},
  [266] = {.lex_state = 47},
  [267] = {.lex_state = 119},
  [268] = {.lex_state = 47},
  [269] = {.lex_state = 47},
  [270] = {.lex_state = 47},
  [271] = {.lex_state = 47},
  [272] = {.lex_state = 47},
  [273] = {.lex_state = 47},
  [274] = {.lex_state = 119},
  [275] = {.lex_state = 119},
  [276] = {.lex_state = 119},
  [277] = {.lex_state = 47},
  [278] = {.lex_state = 47},
  [279] = {.lex_state = 47},
  [280] = {.lex_state = 47},
  [281] = {.lex_state = 47},
  [282] = {.lex_state = 119},
  [283] = {.lex_state = 47},
  [284] = {.lex_state = 47},
  [285] = {.lex_state = 119},
  [286] = {.lex_state = 47},
  [287] = {.lex_state = 119},
  [288] = {.lex_state = 47},
  [289] = {.lex_state = 119},
  [290] = {.lex_state = 119},
  [291] = {.lex_state = 119},
  [292] = {.lex_state = 47},
  [293] = {.lex_state = 119},
  [294] = {.lex_state = 119},
  [295] = {.lex_state = 119},
  [296] = {.lex_state = 119},
  [297] = {.lex_state = 119},
  [298] = {.lex_state = 47},
  [299] = {.lex_state = 47},
  [300] = {.lex_state = 47},
  [301] = {.lex_state = 119},
  [302] = {.lex_state = 119},
  [303] = {.lex_state = 47},
  [304] = {.lex_state = 119},
  [305] = {.lex_state = 47},
  [306] = {.lex_state = 119},
  [307] = {.lex_state = 119},
  [308] = {.lex_state = 47},
  [309] = {.lex_state = 119},
  [310] = {.lex_state = 44},
  [311] = {.lex_state = 119},
  [312] = {.lex_state = 44},
  [313] = {.lex_state = 119},
  [314] = {.lex_state = 119},
  [315] = {.lex_state = 119},
  [316] = {.lex_state = 119},
  [317] = {.lex_state = 119},
  [318] = {.lex_state = 119},
  [319] = {.lex_state = 119},
  [320] = {.lex_state = 119},
  [321] = {.lex_state = 119},
  [322] = {.lex_state = 119},
  [323] = {.lex_state = 119},
  [324] = {.lex_state = 119},
  [325] = {.lex_state = 119},
  [326] = {.lex_state = 119},
  [327] = {.lex_state = 119},
  [328] = {.lex_state = 119},
  [329] = {.lex_state = 119},
  [330] = {.lex_state = 119},
  [331] = {.lex_state = 119},
  [332] = {.lex_state = 119},
  [333] = {.lex_state = 119},
  [334] = {.lex_state = 119},
  [335] = {.lex_state = 119},
  [336] = {.lex_state = 119},
  [337] = {.lex_state = 119},
  [338] = {.lex_state = 119},
  [339] = {.lex_state = 119},
  [340] = {.lex_state = 119},
  [341] = {.lex_state = 119},
  [342] = {.lex_state = 119},
  [343] = {.lex_state = 119},
  [344] = {.lex_state = 119},
  [345] = {.lex_state = 119},
  [346] = {.lex_state = 119},
  [347] = {.lex_state = 119},
  [348] = {.lex_state = 119},
  [349] = {.lex_state = 119},
  [350] = {.lex_state = 119},
  [351] = {.lex_state = 119},
  [352] = {.lex_state = 119},
  [353] = {.lex_state = 119},
  [354] = {.lex_state = 119},
  [355] = {.lex_state = 119},
  [356] = {.lex_state = 119},
  [357] = {.lex_state = 119},
  [358] = {.lex_state = 119},
  [359] = {.lex_state = 119},
  [360] = {.lex_state = 119},
  [361] = {.lex_state = 119},
  [362] = {.lex_state = 119},
  [363] = {.lex_state = 119},
  [364] = {.lex_state = 119},
  [365] = {.lex_state = 119},
  [366] = {.lex_state = 119},
  [367] = {.lex_state = 119},
  [368] = {.lex_state = 119},
  [369] = {.lex_state = 119},
  [370] = {.lex_state = 119},
  [371] = {.lex_state = 119},
  [372] = {.lex_state = 119},
  [373] = {.lex_state = 119},
  [374] = {.lex_state = 119},
  [375] = {.lex_state = 119},
  [376] = {.lex_state = 119},
  [377] = {.lex_state = 119},
  [378] = {.lex_state = 119},
  [379] = {.lex_state = 119},
  [380] = {.lex_state = 119},
  [381] = {.lex_state = 44},
  [382] = {.lex_state = 119},
  [383] = {.lex_state = 119},
  [384] = {.lex_state = 119},
  [385] = {.lex_state = 119},
  [386] = {.lex_state = 119},
  [387] = {.lex_state = 119},
  [388] = {.lex_state = 119},
  [389] = {.lex_state = 119},
  [390] = {.lex_state = 119},
  [391] = {.lex_state = 119},
  [392] = {.lex_state = 119},
  [393] = {.lex_state = 119},
  [394] = {.lex_state = 119},
  [395] = {.lex_state = 119},
  [396] = {.lex_state = 119},
  [397] = {.lex_state = 119},
  [398] = {.lex_state = 44},
  [399] = {.lex_state = 44},
  [400] = {.lex_state = 119},
  [401] = {.lex_state = 49},
  [402] = {.lex_state = 49},
  [403] = {.lex_state = 49},
  [404] = {.lex_state = 49},
  [405] = {.lex_state = 119},
  [406] = {.lex_state = 49},
  [407] = {.lex_state = 49},
  [408] = {.lex_state = 49},
  [409] = {.lex_state = 49},
  [410] = {.lex_state = 49},
  [411] = {.lex_state = 49},
  [412] = {.lex_state = 44},
  [413] = {.lex_state = 53},
  [414] = {.lex_state = 119},
  [415] = {.lex_state = 119},
  [416] = {.lex_state = 119},
  [417] = {.lex_state = 119},
  [418] = {.lex_state = 119},
  [419] = {.lex_state = 119},
  [420] = {.lex_state = 119},
  [421] = {.lex_state = 119},
  [422] = {.lex_state = 119},
  [423] = {.lex_state = 119},
  [424] = {.lex_state = 53},
  [425] = {.lex_state = 53},
  [426] = {.lex_state = 53},
  [427] = {.lex_state = 53},
  [428] = {.lex_state = 53},
  [429] = {.lex_state = 53},
  [430] = {.lex_state = 53},
  [431] = {.lex_state = 53},
  [432] = {.lex_state = 53},
  [433] = {.lex_state = 53},
  [434] = {.lex_state = 53},
  [435] = {.lex_state = 53},
  [436] = {.lex_state = 53},
  [437] = {.lex_state = 53},
  [438] = {.lex_state = 53},
  [439] = {.lex_state = 53},
  [440] = {.lex_state = 119},
  [441] = {.lex_state = 53},
  [442] = {.lex_state = 119},
  [443] = {.lex_state = 119},
  [444] = {.lex_state = 53},
  [445] = {.lex_state = 119},
  [446] = {.lex_state = 52},
  [447] = {.lex_state = 57},
  [448] = {.lex_state = 57},
  [449] = {.lex_state = 57},
  [450] = {.lex_state = 52},
  [451] = {.lex_state = 52},
  [452] = {.lex_state = 119},
  [453] = {.lex_state = 119},
  [454] = {.lex_state = 119},
  [455] = {.lex_state = 119},
  [456] = {.lex_state = 119},
  [457] = {.lex_state = 119},
  [458] = {.lex_state = 119},
  [459] = {.lex_state = 119},
  [460] = {.lex_state = 119},
  [461] = {.lex_state = 119},
  [462] = {.lex_state = 119},
  [463] = {.lex_state = 119},
  [464] = {.lex_state = 53},
  [465] = {.lex_state = 119},
  [466] = {.lex_state = 119},
  [467] = {.lex_state = 119},
  [468] = {.lex_state = 119},
  [469] = {.lex_state = 119},
  [470] = {.lex_state = 53},
  [471] = {.lex_state = 53},
  [472] = {.lex_state = 119},
  [473] = {.lex_state = 119},
  [474] = {.lex_state = 119},
  [475] = {.lex_state = 119},
  [476] = {.lex_state = 119},
  [477] = {.lex_state = 119},
  [478] = {.lex_state = 119},
  [479] = {.lex_state = 119},
  [480] = {.lex_state = 119},
  [481] = {.lex_state = 119},
  [482] = {.lex_state = 119},
  [483] = {.lex_state = 119},
  [484] = {.lex_state = 119},
  [485] = {.lex_state = 49},
  [486] = {.lex_state = 53},
  [487] = {.lex_state = 119},
  [488] = {.lex_state = 119},
  [489] = {.lex_state = 119},
  [490] = {.lex_state = 119},
  [491] = {.lex_state = 119},
  [492] = {.lex_state = 119},
  [493] = {.lex_state = 119},
  [494] = {.lex_state = 119},
  [495] = {.lex_state = 119},
  [496] = {.lex_state = 119},
  [497] = {.lex_state = 119},
  [498] = {.lex_state = 119},
  [499] = {.lex_state = 119},
  [500] = {.lex_state = 119},
  [501] = {.lex_state = 119},
  [502] = {.lex_state = 119},
  [503] = {.lex_state = 119},
  [504] = {.lex_state = 119},
  [505] = {.lex_state = 119},
  [506] = {.lex_state = 119},
  [507] = {.lex_state = 119},
  [508] = {.lex_state = 119},
  [509] = {.lex_state = 119},
  [510] = {.lex_state = 119},
  [511] = {.lex_state = 119},
  [512] = {.lex_state = 119},
  [513] = {.lex_state = 119},
  [514] = {.lex_state = 119},
  [515] = {.lex_state = 119},
  [516] = {.lex_state = 119},
  [517] = {.lex_state = 119},
  [518] = {.lex_state = 119},
  [519] = {.lex_state = 119},
  [520] = {.lex_state = 119},
  [521] = {.lex_state = 119},
  [522] = {.lex_state = 119},
  [523] = {.lex_state = 119},
  [524] = {.lex_state = 119},
  [525] = {.lex_state = 119},
  [526] = {.lex_state = 119},
  [527] = {.lex_state = 119},
  [528] = {.lex_state = 119},
  [529] = {.lex_state = 119},
  [530] = {.lex_state = 119},
  [531] = {.lex_state = 119},
  [532] = {.lex_state = 119},
  [533] = {.lex_state = 119},
  [534] = {.lex_state = 119},
  [535] = {.lex_state = 119},
  [536] = {.lex_state = 119},
  [537] = {.lex_state = 119},
  [538] = {.lex_state = 119},
  [539] = {.lex_state = 119},
  [540] = {.lex_state = 119},
  [541] = {.lex_state = 119},
  [542] = {.lex_state = 119},
  [543] = {.lex_state = 119},
  [544] = {.lex_state = 119},
  [545] = {.lex_state = 119},
  [546] = {.lex_state = 119},
  [547] = {.lex_state = 119},
  [548] = {.lex_state = 119},
  [549] = {.lex_state = 119},
  [550] = {.lex_state = 119},
  [551] = {.lex_state = 119},
  [552] = {.lex_state = 119},
  [553] = {.lex_state = 119},
  [554] = {.lex_state = 119},
  [555] = {.lex_state = 119},
  [556] = {.lex_state = 119},
  [557] = {.lex_state = 119},
  [558] = {.lex_state = 119},
  [559] = {.lex_state = 119},
  [560] = {.lex_state = 119},
  [561] = {.lex_state = 119},
  [562] = {.lex_state = 119},
  [563] = {.lex_state = 119},
  [564] = {.lex_state = 119},
  [565] = {.lex_state = 119},
  [566] = {.lex_state = 119},
  [567] = {.lex_state = 119},
  [568] = {.lex_state = 119},
  [569] = {.lex_state = 119},
  [570] = {.lex_state = 119},
  [571] = {.lex_state = 119},
  [572] = {.lex_state = 119},
  [573] = {.lex_state = 119},
  [574] = {.lex_state = 119},
  [575] = {.lex_state = 119},
  [576] = {.lex_state = 119},
  [577] = {.lex_state = 119},
  [578] = {.lex_state = 119},
  [579] = {.lex_state = 119},
  [580] = {.lex_state = 119},
  [581] = {.lex_state = 119},
  [582] = {.lex_state = 119},
  [583] = {.lex_state = 119},
  [584] = {.lex_state = 119},
  [585] = {.lex_state = 119},
  [586] = {.lex_state = 119},
  [587] = {.lex_state = 119},
  [588] = {.lex_state = 119},
  [589] = {.lex_state = 119},
  [590] = {.lex_state = 119},
  [591] = {.lex_state = 119},
  [592] = {.lex_state = 119},
  [593] = {.lex_state = 119},
  [594] = {.lex_state = 119},
  [595] = {.lex_state = 119},
  [596] = {.lex_state = 119},
  [597] = {.lex_state = 119},
  [598] = {.lex_state = 119},
  [599] = {.lex_state = 119},
  [600] = {.lex_state = 119},
  [601] = {.lex_state = 119},
  [602] = {.lex_state = 119},
  [603] = {.lex_state = 119},
  [604] = {.lex_state = 119},
  [605] = {.lex_state = 119},
  [606] = {.lex_state = 119},
  [607] = {.lex_state = 119},
  [608] = {.lex_state = 119},
  [609] = {.lex_state = 119},
  [610] = {.lex_state = 119},
  [611] = {.lex_state = 119},
  [612] = {.lex_state = 119},
  [613] = {.lex_state = 119},
  [614] = {.lex_state = 119},
  [615] = {.lex_state = 119},
  [616] = {.lex_state = 49},
  [617] = {.lex_state = 49},
  [618] = {.lex_state = 49},
  [619] = {.lex_state = 49},
  [620] = {.lex_state = 49},
  [621] = {.lex_state = 49},
  [622] = {.lex_state = 50},
  [623] = {.lex_state = 50},
  [624] = {.lex_state = 50},
  [625] = {.lex_state = 50},
  [626] = {.lex_state = 53},
  [627] = {.lex_state = 50},
  [628] = {.lex_state = 50},
  [629] = {.lex_state = 50},
  [630] = {.lex_state = 50},
  [631] = {.lex_state = 50},
  [632] = {.lex_state = 50},
  [633] = {.lex_state = 53},
  [634] = {.lex_state = 53},
  [635] = {.lex_state = 53},
  [636] = {.lex_state = 53},
  [637] = {.lex_state = 53},
  [638] = {.lex_state = 53},
  [639] = {.lex_state = 53},
  [640] = {.lex_state = 53},
  [641] = {.lex_state = 53},
  [642] = {.lex_state = 53},
  [643] = {.lex_state = 53},
  [644] = {.lex_state = 53},
  [645] = {.lex_state = 53},
  [646] = {.lex_state = 53},
  [647] = {.lex_state = 53},
  [648] = {.lex_state = 53},
  [649] = {.lex_state = 53},
  [650] = {.lex_state = 53},
  [651] = {.lex_state = 53},
  [652] = {.lex_state = 53},
  [653] = {.lex_state = 53},
  [654] = {.lex_state = 119},
  [655] = {.lex_state = 50},
  [656] = {.lex_state = 119},
  [657] = {.lex_state = 53},
  [658] = {.lex_state = 119},
  [659] = {.lex_state = 49},
  [660] = {.lex_state = 119},
  [661] = {.lex_state = 50},
  [662] = {.lex_state = 50},
  [663] = {.lex_state = 50},
  [664] = {.lex_state = 50},
  [665] = {.lex_state = 50},
  [666] = {.lex_state = 50},
  [667] = {.lex_state = 50},
  [668] = {.lex_state = 50},
  [669] = {.lex_state = 50},
  [670] = {.lex_state = 50},
  [671] = {.lex_state = 50},
  [672] = {.lex_state = 50},
  [673] = {.lex_state = 50},
  [674] = {.lex_state = 50},
  [675] = {.lex_state = 50},
  [676] = {.lex_state = 50},
  [677] = {.lex_state = 50},
  [678] = {.lex_state = 53},
  [679] = {.lex_state = 49},
  [680] = {.lex_state = 50},
  [681] = {.lex_state = 51},
  [682] = {.lex_state = 51},
  [683] = {.lex_state = 49},
  [684] = {.lex_state = 50},
  [685] = {.lex_state = 50},
  [686] = {.lex_state = 50},
  [687] = {.lex_state = 53},
  [688] = {.lex_state = 51},
  [689] = {.lex_state = 50},
  [690] = {.lex_state = 51},
  [691] = {.lex_state = 53},
  [692] = {.lex_state = 53},
  [693] = {.lex_state = 53},
  [694] = {.lex_state = 53},
  [695] = {.lex_state = 50},
  [696] = {.lex_state = 53},
  [697] = {.lex_state = 53},
  [698] = {.lex_state = 53},
  [699] = {.lex_state = 119},
  [700] = {.lex_state = 119},
  [701] = {.lex_state = 49},
  [702] = {.lex_state = 53},
  [703] = {.lex_state = 53},
  [704] = {.lex_state = 53},
  [705] = {.lex_state = 53},
  [706] = {.lex_state = 53},
  [707] = {.lex_state = 53},
  [708] = {.lex_state = 53},
  [709] = {.lex_state = 53},
  [710] = {.lex_state = 53},
  [711] = {.lex_state = 53},
  [712] = {.lex_state = 53},
  [713] = {.lex_state = 53},
  [714] = {.lex_state = 53},
  [715] = {.lex_state = 53},
  [716] = {.lex_state = 53},
  [717] = {.lex_state = 53},
  [718] = {.lex_state = 53},
  [719] = {.lex_state = 53},
  [720] = {.lex_state = 49},
  [721] = {.lex_state = 53},
  [722] = {.lex_state = 53},
  [723] = {.lex_state = 53},
  [724] = {.lex_state = 53},
  [725] = {.lex_state = 49},
  [726] = {.lex_state = 53},
  [727] = {.lex_state = 49},
  [728] = {.lex_state = 53},
  [729] = {.lex_state = 49},
  [730] = {.lex_state = 53},
  [731] = {.lex_state = 49},
  [732] = {.lex_state = 53},
  [733] = {.lex_state = 49},
  [734] = {.lex_state = 53},
  [735] = {.lex_state = 53},
  [736] = {.lex_state = 53},
  [737] = {.lex_state = 53},
  [738] = {.lex_state = 53},
  [739] = {.lex_state = 49},
  [740] = {.lex_state = 53},
  [741] = {.lex_state = 53},
  [742] = {.lex_state = 53},
  [743] = {.lex_state = 53},
  [744] = {.lex_state = 53},
  [745] = {.lex_state = 50},
  [746] = {.lex_state = 53},
  [747] = {.lex_state = 53},
  [748] = {.lex_state = 50},
  [749] = {.lex_state = 53},
  [750] = {.lex_state = 53},
  [751] = {.lex_state = 53},
  [752] = {.lex_state = 53},
  [753] = {.lex_state = 53},
  [754] = {.lex_state = 50},
  [755] = {.lex_state = 53},
  [756] = {.lex_state = 53},
  [757] = {.lex_state = 50},
  [758] = {.lex_state = 50},
  [759] = {.lex_state = 53},
  [760] = {.lex_state = 50},
  [761] = {.lex_state = 53},
  [762] = {.lex_state = 53},
  [763] = {.lex_state = 53},
  [764] = {.lex_state = 53},
  [765] = {.lex_state = 50},
  [766] = {.lex_state = 50},
  [767] = {.lex_state = 53},
  [768] = {.lex_state = 53},
  [769] = {.lex_state = 53},
  [770] = {.lex_state = 50},
  [771] = {.lex_state = 53},
  [772] = {.lex_state = 53},
  [773] = {.lex_state = 53},
  [774] = {.lex_state = 53},
  [775] = {.lex_state = 50},
  [776] = {.lex_state = 50},
  [777] = {.lex_state = 53},
  [778] = {.lex_state = 50},
  [779] = {.lex_state = 53},
  [780] = {.lex_state = 53},
  [781] = {.lex_state = 53},
  [782] = {.lex_state = 53},
  [783] = {.lex_state = 53},
  [784] = {.lex_state = 53},
  [785] = {.lex_state = 53},
  [786] = {.lex_state = 53},
  [787] = {.lex_state = 53},
  [788] = {.lex_state = 53},
  [789] = {.lex_state = 53},
  [790] = {.lex_state = 53},
  [791] = {.lex_state = 53},
  [792] = {.lex_state = 53},
  [793] = {.lex_state = 50},
  [794] = {.lex_state = 53},
  [795] = {.lex_state = 53},
  [796] = {.lex_state = 53},
  [797] = {.lex_state = 53},
  [798] = {.lex_state = 53},
  [799] = {.lex_state = 53},
  [800] = {.lex_state = 53},
  [801] = {.lex_state = 53},
  [802] = {.lex_state = 53},
  [803] = {.lex_state = 53},
  [804] = {.lex_state = 53},
  [805] = {.lex_state = 53},
  [806] = {.lex_state = 53},
  [807] = {.lex_state = 53},
  [808] = {.lex_state = 53},
  [809] = {.lex_state = 53},
  [810] = {.lex_state = 53},
  [811] = {.lex_state = 53},
  [812] = {.lex_state = 53},
  [813] = {.lex_state = 53},
  [814] = {.lex_state = 53},
  [815] = {.lex_state = 53},
  [816] = {.lex_state = 53},
  [817] = {.lex_state = 53},
  [818] = {.lex_state = 53},
  [819] = {.lex_state = 53},
  [820] = {.lex_state = 53},
  [821] = {.lex_state = 53},
  [822] = {.lex_state = 53},
  [823] = {.lex_state = 53},
  [824] = {.lex_state = 53},
  [825] = {.lex_state = 53},
  [826] = {.lex_state = 53},
  [827] = {.lex_state = 53},
  [828] = {.lex_state = 52},
  [829] = {.lex_state = 57},
  [830] = {.lex_state = 49},
  [831] = {.lex_state = 49},
  [832] = {.lex_state = 49},
  [833] = {.lex_state = 57},
  [834] = {.lex_state = 57},
  [835] = {.lex_state = 52},
  [836] = {.lex_state = 52},
  [837] = {.lex_state = 49},
  [838] = {.lex_state = 49},
  [839] = {.lex_state = 49},
  [840] = {.lex_state = 49},
  [841] = {.lex_state = 49},
  [842] = {.lex_state = 49},
  [843] = {.lex_state = 49},
  [844] = {.lex_state = 52},
  [845] = {.lex_state = 49},
  [846] = {.lex_state = 49},
  [847] = {.lex_state = 57},
  [848] = {.lex_state = 49},
  [849] = {.lex_state = 49},
  [850] = {.lex_state = 49},
  [851] = {.lex_state = 57},
  [852] = {.lex_state = 57},
  [853] = {.lex_state = 57},
  [854] = {.lex_state = 52},
  [855] = {.lex_state = 52},
  [856] = {.lex_state = 52},
  [857] = {.lex_state = 57},
  [858] = {.lex_state = 57},
  [859] = {.lex_state = 57},
  [860] = {.lex_state = 53},
  [861] = {.lex_state = 57},
  [862] = {.lex_state = 57},
  [863] = {.lex_state = 57},
  [864] = {.lex_state = 49},
  [865] = {.lex_state = 49},
  [866] = {.lex_state = 49},
  [867] = {.lex_state = 57},
  [868] = {.lex_state = 49},
  [869] = {.lex_state = 57},
  [870] = {.lex_state = 49},
  [871] = {.lex_state = 49},
  [872] = {.lex_state = 52},
  [873] = {.lex_state = 52},
  [874] = {.lex_state = 52},
  [875] = {.lex_state = 57},
  [876] = {.lex_state = 52},
  [877] = {.lex_state = 52},
  [878] = {.lex_state = 53},
  [879] = {.lex_state = 52},
  [880] = {.lex_state = 52},
  [881] = {.lex_state = 52},
  [882] = {.lex_state = 57},
  [883] = {.lex_state = 57},
  [884] = {.lex_state = 53},
  [885] = {.lex_state = 52},
  [886] = {.lex_state = 52},
  [887] = {.lex_state = 52},
  [888] = {.lex_state = 49},
  [889] = {.lex_state = 49},
  [890] = {.lex_state = 49},
  [891] = {.lex_state = 49},
  [892] = {.lex_state = 49},
  [893] = {.lex_state = 49},
  [894] = {.lex_state = 53},
  [895] = {.lex_state = 53},
  [896] = {.lex_state = 53},
  [897] = {.lex_state = 53},
  [898] = {.lex_state = 49},
  [899] = {.lex_state = 53},
  [900] = {.lex_state = 53},
  [901] = {.lex_state = 119},
  [902] = {.lex_state = 119},
  [903] = {.lex_state = 119},
  [904] = {.lex_state = 119},
  [905] = {.lex_state = 119},
  [906] = {.lex_state = 119},
  [907] = {.lex_state = 119},
  [908] = {.lex_state = 119},
  [909] = {.lex_state = 53},
  [910] = {.lex_state = 53},
  [911] = {.lex_state = 119},
  [912] = {.lex_state = 119},
  [913] = {.lex_state = 53},
  [914] = {.lex_state = 53},
  [915] = {.lex_state = 53},
  [916] = {.lex_state = 53},
  [917] = {.lex_state = 53},
  [918] = {.lex_state = 53},
  [919] = {.lex_state = 53},
  [920] = {.lex_state = 53},
  [921] = {.lex_state = 53},
  [922] = {.lex_state = 53},
  [923] = {.lex_state = 53},
  [924] = {.lex_state = 53},
  [925] = {.lex_state = 53},
  [926] = {.lex_state = 53},
  [927] = {.lex_state = 53},
  [928] = {.lex_state = 53},
  [929] = {.lex_state = 53},
  [930] = {.lex_state = 53},
  [931] = {.lex_state = 53},
  [932] = {.lex_state = 53},
  [933] = {.lex_state = 53},
  [934] = {.lex_state = 53},
  [935] = {.lex_state = 53},
  [936] = {.lex_state = 50},
  [937] = {.lex_state = 53},
  [938] = {.lex_state = 53},
  [939] = {.lex_state = 50},
  [940] = {.lex_state = 50},
  [941] = {.lex_state = 50},
  [942] = {.lex_state = 50},
  [943] = {.lex_state = 53},
  [944] = {.lex_state = 50},
  [945] = {.lex_state = 50},
  [946] = {.lex_state = 50},
  [947] = {.lex_state = 50},
  [948] = {.lex_state = 50},
  [949] = {.lex_state = 50},
  [950] = {.lex_state = 50},
  [951] = {.lex_state = 50},
  [952] = {.lex_state = 53},
  [953] = {.lex_state = 53},
  [954] = {.lex_state = 53},
  [955] = {.lex_state = 53},
  [956] = {.lex_state = 53},
  [957] = {.lex_state = 53},
  [958] = {.lex_state = 53},
  [959] = {.lex_state = 53},
  [960] = {.lex_state = 53},
  [961] = {.lex_state = 53},
  [962] = {.lex_state = 53},
  [963] = {.lex_state = 53},
  [964] = {.lex_state = 53},
  [965] = {.lex_state = 53},
  [966] = {.lex_state = 53},
  [967] = {.lex_state = 53},
  [968] = {.lex_state = 53},
  [969] = {.lex_state = 53},
  [970] = {.lex_state = 53},
  [971] = {.lex_state = 53},
  [972] = {.lex_state = 53},
  [973] = {.lex_state = 53},
  [974] = {.lex_state = 53},
  [975] = {.lex_state = 53},
  [976] = {.lex_state = 53},
  [977] = {.lex_state = 53},
  [978] = {.lex_state = 53},
  [979] = {.lex_state = 53},
  [980] = {.lex_state = 53},
  [981] = {.lex_state = 52},
  [982] = {.lex_state = 53},
  [983] = {.lex_state = 53},
  [984] = {.lex_state = 52},
  [985] = {.lex_state = 53},
  [986] = {.lex_state = 52},
  [987] = {.lex_state = 53},
  [988] = {.lex_state = 53},
  [989] = {.lex_state = 53},
  [990] = {.lex_state = 53},
  [991] = {.lex_state = 52},
  [992] = {.lex_state = 49},
  [993] = {.lex_state = 49},
  [994] = {.lex_state = 53},
  [995] = {.lex_state = 49},
  [996] = {.lex_state = 49},
  [997] = {.lex_state = 49},
  [998] = {.lex_state = 49},
  [999] = {.lex_state = 53},
  [1000] = {.lex_state = 53},
  [1001] = {.lex_state = 49},
  [1002] = {.lex_state = 49},
  [1003] = {.lex_state = 53},
  [1004] = {.lex_state = 49},
  [1005] = {.lex_state = 49},
  [1006] = {.lex_state = 49},
  [1007] = {.lex_state = 49},
  [1008] = {.lex_state = 49},
  [1009] = {.lex_state = 53},
  [1010] = {.lex_state = 49},
  [1011] = {.lex_state = 49},
  [1012] = {.lex_state = 49},
  [1013] = {.lex_state = 49},
  [1014] = {.lex_state = 49},
  [1015] = {.lex_state = 49},
  [1016] = {.lex_state = 49},
  [1017] = {.lex_state = 49},
  [1018] = {.lex_state = 49},
  [1019] = {.lex_state = 49},
  [1020] = {.lex_state = 49},
  [1021] = {.lex_state = 49},
  [1022] = {.lex_state = 49},
  [1023] = {.lex_state = 49},
  [1024] = {.lex_state = 49},
  [1025] = {.lex_state = 49},
  [1026] = {.lex_state = 49},
  [1027] = {.lex_state = 49},
  [1028] = {.lex_state = 49},
  [1029] = {.lex_state = 49},
  [1030] = {.lex_state = 49},
  [1031] = {.lex_state = 49},
  [1032] = {.lex_state = 49},
  [1033] = {.lex_state = 49},
  [1034] = {.lex_state = 49},
  [1035] = {.lex_state = 49},
  [1036] = {.lex_state = 49},
  [1037] = {.lex_state = 49},
  [1038] = {.lex_state = 49},
  [1039] = {.lex_state = 49},
  [1040] = {.lex_state = 49},
  [1041] = {.lex_state = 49},
  [1042] = {.lex_state = 49},
  [1043] = {.lex_state = 49},
  [1044] = {.lex_state = 49},
  [1045] = {.lex_state = 49},
  [1046] = {.lex_state = 49},
  [1047] = {.lex_state = 49},
  [1048] = {.lex_state = 49},
  [1049] = {.lex_state = 49},
  [1050] = {.lex_state = 49},
  [1051] = {.lex_state = 49},
  [1052] = {.lex_state = 49},
  [1053] = {.lex_state = 49},
  [1054] = {.lex_state = 49},
  [1055] = {.lex_state = 49},
  [1056] = {.lex_state = 49},
  [1057] = {.lex_state = 49},
  [1058] = {.lex_state = 49},
  [1059] = {.lex_state = 49},
  [1060] = {.lex_state = 49},
  [1061] = {.lex_state = 49},
  [1062] = {.lex_state = 49},
  [1063] = {.lex_state = 49},
  [1064] = {.lex_state = 49},
  [1065] = {.lex_state = 49},
  [1066] = {.lex_state = 49},
  [1067] = {.lex_state = 49},
  [1068] = {.lex_state = 49},
  [1069] = {.lex_state = 49},
  [1070] = {.lex_state = 49},
  [1071] = {.lex_state = 49},
  [1072] = {.lex_state = 49},
  [1073] = {.lex_state = 53},
  [1074] = {.lex_state = 53},
  [1075] = {.lex_state = 53},
  [1076] = {.lex_state = 49},
  [1077] = {.lex_state = 53},
  [1078] = {.lex_state = 49},
  [1079] = {.lex_state = 53},
  [1080] = {.lex_state = 53},
  [1081] = {.lex_state = 53},
  [1082] = {.lex_state = 53},
  [1083] = {.lex_state = 53},
  [1084] = {.lex_state = 53},
  [1085] = {.lex_state = 53},
  [1086] = {.lex_state = 53},
  [1087] = {.lex_state = 53},
  [1088] = {.lex_state = 53},
  [1089] = {.lex_state = 53},
  [1090] = {.lex_state = 53},
  [1091] = {.lex_state = 53},
  [1092] = {.lex_state = 53},
  [1093] = {.lex_state = 53},
  [1094] = {.lex_state = 53},
  [1095] = {.lex_state = 53},
  [1096] = {.lex_state = 53},
  [1097] = {.lex_state = 52},
  [1098] = {.lex_state = 53},
  [1099] = {.lex_state = 53},
  [1100] = {.lex_state = 53},
  [1101] = {.lex_state = 53},
  [1102] = {.lex_state = 52},
  [1103] = {.lex_state = 53},
  [1104] = {.lex_state = 53},
  [1105] = {.lex_state = 53},
  [1106] = {.lex_state = 53},
  [1107] = {.lex_state = 53},
  [1108] = {.lex_state = 48},
  [1109] = {.lex_state = 53},
  [1110] = {.lex_state = 48},
  [1111] = {.lex_state = 53},
  [1112] = {.lex_state = 53},
  [1113] = {.lex_state = 48},
  [1114] = {.lex_state = 53},
  [1115] = {.lex_state = 53},
  [1116] = {.lex_state = 52},
  [1117] = {.lex_state = 25},
  [1118] = {.lex_state = 53},
  [1119] = {.lex_state = 53},
  [1120] = {.lex_state = 53},
  [1121] = {.lex_state = 53},
  [1122] = {.lex_state = 53},
  [1123] = {.lex_state = 53},
  [1124] = {.lex_state = 53},
  [1125] = {.lex_state = 53},
  [1126] = {.lex_state = 53},
  [1127] = {.lex_state = 53},
  [1128] = {.lex_state = 53},
  [1129] = {.lex_state = 52},
  [1130] = {.lex_state = 48},
  [1131] = {.lex_state = 48},
  [1132] = {.lex_state = 52},
  [1133] = {.lex_state = 52},
  [1134] = {.lex_state = 52},
  [1135] = {.lex_state = 52},
  [1136] = {.lex_state = 52},
  [1137] = {.lex_state = 48},
  [1138] = {.lex_state = 52},
  [1139] = {.lex_state = 53},
  [1140] = {.lex_state = 52},
  [1141] = {.lex_state = 52},
  [1142] = {.lex_state = 48},
  [1143] = {.lex_state = 52},
  [1144] = {.lex_state = 52},
  [1145] = {.lex_state = 52},
  [1146] = {.lex_state = 52},
  [1147] = {.lex_state = 48},
  [1148] = {.lex_state = 48},
  [1149] = {.lex_state = 48},
  [1150] = {.lex_state = 52},
  [1151] = {.lex_state = 48},
  [1152] = {.lex_state = 48},
  [1153] = {.lex_state = 48},
  [1154] = {.lex_state = 48},
  [1155] = {.lex_state = 48},
  [1156] = {.lex_state = 48},
  [1157] = {.lex_state = 48},
  [1158] = {.lex_state = 48},
  [1159] = {.lex_state = 48},
  [1160] = {.lex_state = 48},
  [1161] = {.lex_state = 52},
  [1162] = {.lex_state = 48},
  [1163] = {.lex_state = 48},
  [1164] = {.lex_state = 48},
  [1165] = {.lex_state = 48},
  [1166] = {.lex_state = 48},
  [1167] = {.lex_state = 48},
  [1168] = {.lex_state = 48},
  [1169] = {.lex_state = 48},
  [1170] = {.lex_state = 48},
  [1171] = {.lex_state = 48},
  [1172] = {.lex_state = 48},
  [1173] = {.lex_state = 52},
  [1174] = {.lex_state = 48},
  [1175] = {.lex_state = 48},
  [1176] = {.lex_state = 48},
  [1177] = {.lex_state = 48},
  [1178] = {.lex_state = 48},
  [1179] = {.lex_state = 48},
  [1180] = {.lex_state = 48},
  [1181] = {.lex_state = 48},
  [1182] = {.lex_state = 48},
  [1183] = {.lex_state = 52},
  [1184] = {.lex_state = 48},
  [1185] = {.lex_state = 48},
  [1186] = {.lex_state = 25},
  [1187] = {.lex_state = 25},
  [1188] = {.lex_state = 25},
  [1189] = {.lex_state = 25},
  [1190] = {.lex_state = 25},
  [1191] = {.lex_state = 25},
  [1192] = {.lex_state = 25},
  [1193] = {.lex_state = 25},
  [1194] = {.lex_state = 25},
  [1195] = {.lex_state = 25},
  [1196] = {.lex_state = 25},
  [1197] = {.lex_state = 25},
  [1198] = {.lex_state = 25},
  [1199] = {.lex_state = 25},
  [1200] = {.lex_state = 25},
  [1201] = {.lex_state = 25},
  [1202] = {.lex_state = 25},
  [1203] = {.lex_state = 52},
  [1204] = {.lex_state = 25},
  [1205] = {.lex_state = 25},
  [1206] = {.lex_state = 25},
  [1207] = {.lex_state = 25},
  [1208] = {.lex_state = 25},
  [1209] = {.lex_state = 25},
  [1210] = {.lex_state = 25},
  [1211] = {.lex_state = 53},
  [1212] = {.lex_state = 25},
  [1213] = {.lex_state = 25},
  [1214] = {.lex_state = 53},
  [1215] = {.lex_state = 25},
  [1216] = {.lex_state = 25},
  [1217] = {.lex_state = 25},
  [1218] = {.lex_state = 53},
  [1219] = {.lex_state = 53},
  [1220] = {.lex_state = 25},
  [1221] = {.lex_state = 25},
  [1222] = {.lex_state = 25},
  [1223] = {.lex_state = 52},
  [1224] = {.lex_state = 25},
  [1225] = {.lex_state = 53},
  [1226] = {.lex_state = 53},
  [1227] = {.lex_state = 53},
  [1228] = {.lex_state = 53},
  [1229] = {.lex_state = 53},
  [1230] = {.lex_state = 53},
  [1231] = {.lex_state = 53},
  [1232] = {.lex_state = 53},
  [1233] = {.lex_state = 53},
  [1234] = {.lex_state = 53},
  [1235] = {.lex_state = 53},
  [1236] = {.lex_state = 53},
  [1237] = {.lex_state = 53},
  [1238] = {.lex_state = 53},
  [1239] = {.lex_state = 53},
  [1240] = {.lex_state = 53},
  [1241] = {.lex_state = 53},
  [1242] = {.lex_state = 53},
  [1243] = {.lex_state = 53},
  [1244] = {.lex_state = 53},
  [1245] = {.lex_state = 53},
  [1246] = {.lex_state = 53},
  [1247] = {.lex_state = 53},
  [1248] = {.lex_state = 53},
  [1249] = {.lex_state = 53},
  [1250] = {.lex_state = 50},
  [1251] = {.lex_state = 50},
  [1252] = {.lex_state = 50},
  [1253] = {.lex_state = 53},
  [1254] = {.lex_state = 50},
  [1255] = {.lex_state = 53},
  [1256] = {.lex_state = 53},
  [1257] = {.lex_state = 53},
  [1258] = {.lex_state = 53},
  [1259] = {.lex_state = 53},
  [1260] = {.lex_state = 53},
  [1261] = {.lex_state = 53},
  [1262] = {.lex_state = 56},
  [1263] = {.lex_state = 53},
  [1264] = {.lex_state = 53},
  [1265] = {.lex_state = 53},
  [1266] = {.lex_state = 53},
  [1267] = {.lex_state = 53},
  [1268] = {.lex_state = 53},
  [1269] = {.lex_state = 53},
  [1270] = {.lex_state = 53},
  [1271] = {.lex_state = 53},
  [1272] = {.lex_state = 53},
  [1273] = {.lex_state = 53},
  [1274] = {.lex_state = 53},
  [1275] = {.lex_state = 53},
  [1276] = {.lex_state = 56},
  [1277] = {.lex_state = 53},
  [1278] = {.lex_state = 53},
  [1279] = {.lex_state = 53},
  [1280] = {.lex_state = 53},
  [1281] = {.lex_state = 53},
  [1282] = {.lex_state = 50},
  [1283] = {.lex_state = 53},
  [1284] = {.lex_state = 56},
  [1285] = {.lex_state = 53},
  [1286] = {.lex_state = 50},
  [1287] = {.lex_state = 50},
  [1288] = {.lex_state = 53},
  [1289] = {.lex_state = 53},
  [1290] = {.lex_state = 53},
  [1291] = {.lex_state = 53},
  [1292] = {.lex_state = 50},
  [1293] = {.lex_state = 53},
  [1294] = {.lex_state = 50},
  [1295] = {.lex_state = 53},
  [1296] = {.lex_state = 50},
  [1297] = {.lex_state = 53},
  [1298] = {.lex_state = 53},
  [1299] = {.lex_state = 53},
  [1300] = {.lex_state = 50},
  [1301] = {.lex_state = 50},
  [1302] = {.lex_state = 50},
  [1303] = {.lex_state = 53},
  [1304] = {.lex_state = 50},
  [1305] = {.lex_state = 50},
  [1306] = {.lex_state = 50},
  [1307] = {.lex_state = 50},
  [1308] = {.lex_state = 50},
  [1309] = {.lex_state = 49},
  [1310] = {.lex_state = 53},
  [1311] = {.lex_state = 0},
  [1312] = {.lex_state = 53},
  [1313] = {.lex_state = 53},
  [1314] = {.lex_state = 53},
  [1315] = {.lex_state = 53},
  [1316] = {.lex_state = 53},
  [1317] = {.lex_state = 53},
  [1318] = {.lex_state = 119},
  [1319] = {.lex_state = 119},
  [1320] = {.lex_state = 53},
  [1321] = {.lex_state = 53},
  [1322] = {.lex_state = 53},
  [1323] = {.lex_state = 53},
  [1324] = {.lex_state = 119},
  [1325] = {.lex_state = 53},
  [1326] = {.lex_state = 119},
  [1327] = {.lex_state = 0},
  [1328] = {.lex_state = 53},
  [1329] = {.lex_state = 54},
  [1330] = {.lex_state = 119},
  [1331] = {.lex_state = 54},
  [1332] = {.lex_state = 119},
  [1333] = {.lex_state = 54},
  [1334] = {.lex_state = 119},
  [1335] = {.lex_state = 119},
  [1336] = {.lex_state = 54},
  [1337] = {.lex_state = 49},
  [1338] = {.lex_state = 49},
  [1339] = {.lex_state = 119},
  [1340] = {.lex_state = 119},
  [1341] = {.lex_state = 53},
  [1342] = {.lex_state = 49},
  [1343] = {.lex_state = 119},
  [1344] = {.lex_state = 119},
  [1345] = {.lex_state = 53},
  [1346] = {.lex_state = 119},
  [1347] = {.lex_state = 53},
  [1348] = {.lex_state = 119},
  [1349] = {.lex_state = 53},
  [1350] = {.lex_state = 119},
  [1351] = {.lex_state = 119},
  [1352] = {.lex_state = 53},
  [1353] = {.lex_state = 53},
  [1354] = {.lex_state = 50},
  [1355] = {.lex_state = 119},
  [1356] = {.lex_state = 119},
  [1357] = {.lex_state = 53},
  [1358] = {.lex_state = 119},
  [1359] = {.lex_state = 0},
  [1360] = {.lex_state = 50},
  [1361] = {.lex_state = 53},
  [1362] = {.lex_state = 119},
  [1363] = {.lex_state = 119},
  [1364] = {.lex_state = 53},
  [1365] = {.lex_state = 119},
  [1366] = {.lex_state = 119},
  [1367] = {.lex_state = 53},
  [1368] = {.lex_state = 0},
  [1369] = {.lex_state = 53},
  [1370] = {.lex_state = 53},
  [1371] = {.lex_state = 119},
  [1372] = {.lex_state = 50},
  [1373] = {.lex_state = 119},
  [1374] = {.lex_state = 119},
  [1375] = {.lex_state = 53},
  [1376] = {.lex_state = 119},
  [1377] = {.lex_state = 53},
  [1378] = {.lex_state = 53},
  [1379] = {.lex_state = 53},
  [1380] = {.lex_state = 53},
  [1381] = {.lex_state = 119},
  [1382] = {.lex_state = 53},
  [1383] = {.lex_state = 53},
  [1384] = {.lex_state = 0},
  [1385] = {.lex_state = 53},
  [1386] = {.lex_state = 119},
  [1387] = {.lex_state = 0},
  [1388] = {.lex_state = 50},
  [1389] = {.lex_state = 119},
  [1390] = {.lex_state = 53},
  [1391] = {.lex_state = 53},
  [1392] = {.lex_state = 53},
  [1393] = {.lex_state = 119},
  [1394] = {.lex_state = 119},
  [1395] = {.lex_state = 53},
  [1396] = {.lex_state = 53},
  [1397] = {.lex_state = 119},
  [1398] = {.lex_state = 53},
  [1399] = {.lex_state = 56},
  [1400] = {.lex_state = 53},
  [1401] = {.lex_state = 53},
  [1402] = {.lex_state = 119},
  [1403] = {.lex_state = 53},
  [1404] = {.lex_state = 0},
  [1405] = {.lex_state = 56},
  [1406] = {.lex_state = 0},
  [1407] = {.lex_state = 56},
  [1408] = {.lex_state = 53},
  [1409] = {.lex_state = 0},
  [1410] = {.lex_state = 53},
  [1411] = {.lex_state = 56},
  [1412] = {.lex_state = 119},
  [1413] = {.lex_state = 119},
  [1414] = {.lex_state = 119},
  [1415] = {.lex_state = 56},
  [1416] = {.lex_state = 56},
  [1417] = {.lex_state = 53},
  [1418] = {.lex_state = 53},
  [1419] = {.lex_state = 119},
  [1420] = {.lex_state = 56},
  [1421] = {.lex_state = 53},
  [1422] = {.lex_state = 119},
  [1423] = {.lex_state = 53},
  [1424] = {.lex_state = 53},
  [1425] = {.lex_state = 119},
  [1426] = {.lex_state = 56},
  [1427] = {.lex_state = 53},
  [1428] = {.lex_state = 53},
  [1429] = {.lex_state = 53},
  [1430] = {.lex_state = 119},
  [1431] = {.lex_state = 53},
  [1432] = {.lex_state = 56},
  [1433] = {.lex_state = 50},
  [1434] = {.lex_state = 53},
  [1435] = {.lex_state = 56},
  [1436] = {.lex_state = 56},
  [1437] = {.lex_state = 119},
  [1438] = {.lex_state = 119},
  [1439] = {.lex_state = 119},
  [1440] = {.lex_state = 119},
  [1441] = {.lex_state = 53},
  [1442] = {.lex_state = 119},
  [1443] = {.lex_state = 119},
  [1444] = {.lex_state = 53},
  [1445] = {.lex_state = 119},
  [1446] = {.lex_state = 119},
  [1447] = {.lex_state = 119},
  [1448] = {.lex_state = 119},
  [1449] = {.lex_state = 53},
  [1450] = {.lex_state = 50},
  [1451] = {.lex_state = 45},
  [1452] = {.lex_state = 119},
  [1453] = {.lex_state = 53},
  [1454] = {.lex_state = 119},
  [1455] = {.lex_state = 119},
  [1456] = {.lex_state = 119},
  [1457] = {.lex_state = 53},
  [1458] = {.lex_state = 53},
  [1459] = {.lex_state = 53},
  [1460] = {.lex_state = 53},
  [1461] = {.lex_state = 53},
  [1462] = {.lex_state = 53},
  [1463] = {.lex_state = 53},
  [1464] = {.lex_state = 0},
  [1465] = {.lex_state = 53},
  [1466] = {.lex_state = 45},
  [1467] = {.lex_state = 53},
  [1468] = {.lex_state = 53},
  [1469] = {.lex_state = 53},
  [1470] = {.lex_state = 53},
  [1471] = {.lex_state = 30},
  [1472] = {.lex_state = 53},
  [1473] = {.lex_state = 32},
  [1474] = {.lex_state = 0},
  [1475] = {.lex_state = 53},
  [1476] = {.lex_state = 53},
  [1477] = {.lex_state = 119},
  [1478] = {.lex_state = 53},
  [1479] = {.lex_state = 32},
  [1480] = {.lex_state = 53},
  [1481] = {.lex_state = 53},
  [1482] = {.lex_state = 0},
  [1483] = {.lex_state = 53},
  [1484] = {.lex_state = 37},
  [1485] = {.lex_state = 30},
  [1486] = {.lex_state = 0},
  [1487] = {.lex_state = 53},
  [1488] = {.lex_state = 53},
  [1489] = {.lex_state = 30},
  [1490] = {.lex_state = 37},
  [1491] = {.lex_state = 53},
  [1492] = {.lex_state = 50},
  [1493] = {.lex_state = 50},
  [1494] = {.lex_state = 53},
  [1495] = {.lex_state = 50},
  [1496] = {.lex_state = 53},
  [1497] = {.lex_state = 32},
  [1498] = {.lex_state = 53},
  [1499] = {.lex_state = 50},
  [1500] = {.lex_state = 0},
  [1501] = {.lex_state = 32},
  [1502] = {.lex_state = 30},
  [1503] = {.lex_state = 30},
  [1504] = {.lex_state = 0},
  [1505] = {.lex_state = 0},
  [1506] = {.lex_state = 32},
  [1507] = {.lex_state = 0},
  [1508] = {.lex_state = 37},
  [1509] = {.lex_state = 37},
  [1510] = {.lex_state = 30},
  [1511] = {.lex_state = 53},
  [1512] = {.lex_state = 53},
  [1513] = {.lex_state = 0},
  [1514] = {.lex_state = 32},
  [1515] = {.lex_state = 53},
  [1516] = {.lex_state = 0},
  [1517] = {.lex_state = 119},
  [1518] = {.lex_state = 53},
  [1519] = {.lex_state = 32},
  [1520] = {.lex_state = 30},
  [1521] = {.lex_state = 0},
  [1522] = {.lex_state = 0},
  [1523] = {.lex_state = 0},
  [1524] = {.lex_state = 53},
  [1525] = {.lex_state = 0},
  [1526] = {.lex_state = 53},
  [1527] = {.lex_state = 0},
  [1528] = {.lex_state = 0},
  [1529] = {.lex_state = 0},
  [1530] = {.lex_state = 0},
  [1531] = {.lex_state = 0},
  [1532] = {.lex_state = 0},
  [1533] = {.lex_state = 0},
  [1534] = {.lex_state = 0},
  [1535] = {.lex_state = 0},
  [1536] = {.lex_state = 0},
  [1537] = {.lex_state = 45},
  [1538] = {.lex_state = 0},
  [1539] = {.lex_state = 53},
  [1540] = {.lex_state = 37},
  [1541] = {.lex_state = 0},
  [1542] = {.lex_state = 0},
  [1543] = {.lex_state = 0},
  [1544] = {.lex_state = 34},
  [1545] = {.lex_state = 0},
  [1546] = {.lex_state = 0},
  [1547] = {.lex_state = 0},
  [1548] = {.lex_state = 0},
  [1549] = {.lex_state = 0},
  [1550] = {.lex_state = 34},
  [1551] = {.lex_state = 0},
  [1552] = {.lex_state = 53},
  [1553] = {.lex_state = 0},
  [1554] = {.lex_state = 0},
  [1555] = {.lex_state = 0},
  [1556] = {.lex_state = 53},
  [1557] = {.lex_state = 0},
  [1558] = {.lex_state = 45},
  [1559] = {.lex_state = 53},
  [1560] = {.lex_state = 0},
  [1561] = {.lex_state = 0},
  [1562] = {.lex_state = 0},
  [1563] = {.lex_state = 0},
  [1564] = {.lex_state = 0},
  [1565] = {.lex_state = 34},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 0},
  [1568] = {.lex_state = 0},
  [1569] = {.lex_state = 0},
  [1570] = {.lex_state = 0},
  [1571] = {.lex_state = 45},
  [1572] = {.lex_state = 37},
  [1573] = {.lex_state = 0},
  [1574] = {.lex_state = 0},
  [1575] = {.lex_state = 53},
  [1576] = {.lex_state = 0},
  [1577] = {.lex_state = 0},
  [1578] = {.lex_state = 0},
  [1579] = {.lex_state = 0},
  [1580] = {.lex_state = 0},
  [1581] = {.lex_state = 0},
  [1582] = {.lex_state = 53},
  [1583] = {.lex_state = 0},
  [1584] = {.lex_state = 0},
  [1585] = {.lex_state = 45},
  [1586] = {.lex_state = 0},
  [1587] = {.lex_state = 0},
  [1588] = {.lex_state = 0},
  [1589] = {.lex_state = 0},
  [1590] = {.lex_state = 0},
  [1591] = {.lex_state = 0},
  [1592] = {.lex_state = 0},
  [1593] = {.lex_state = 0},
  [1594] = {.lex_state = 0},
  [1595] = {.lex_state = 0},
  [1596] = {.lex_state = 0},
  [1597] = {.lex_state = 0},
  [1598] = {.lex_state = 0},
  [1599] = {.lex_state = 0},
  [1600] = {.lex_state = 0},
  [1601] = {.lex_state = 0},
  [1602] = {.lex_state = 45},
  [1603] = {.lex_state = 0},
  [1604] = {.lex_state = 0},
  [1605] = {.lex_state = 0},
  [1606] = {.lex_state = 53},
  [1607] = {.lex_state = 34},
  [1608] = {.lex_state = 0},
  [1609] = {.lex_state = 0},
  [1610] = {.lex_state = 0},
  [1611] = {.lex_state = 0},
  [1612] = {.lex_state = 0},
  [1613] = {.lex_state = 0},
  [1614] = {.lex_state = 0},
  [1615] = {.lex_state = 0},
  [1616] = {.lex_state = 0},
  [1617] = {.lex_state = 0},
  [1618] = {.lex_state = 0},
  [1619] = {.lex_state = 0},
  [1620] = {.lex_state = 0},
  [1621] = {.lex_state = 0},
  [1622] = {.lex_state = 53},
  [1623] = {.lex_state = 0},
  [1624] = {.lex_state = 0},
  [1625] = {.lex_state = 37},
  [1626] = {.lex_state = 0},
  [1627] = {.lex_state = 0},
  [1628] = {.lex_state = 0},
  [1629] = {.lex_state = 0},
  [1630] = {.lex_state = 0},
  [1631] = {.lex_state = 0},
  [1632] = {.lex_state = 0},
  [1633] = {.lex_state = 0},
  [1634] = {.lex_state = 0},
  [1635] = {.lex_state = 0},
  [1636] = {.lex_state = 45},
  [1637] = {.lex_state = 0},
  [1638] = {.lex_state = 53},
  [1639] = {.lex_state = 0},
  [1640] = {.lex_state = 53},
  [1641] = {.lex_state = 0},
  [1642] = {.lex_state = 45},
  [1643] = {.lex_state = 0},
  [1644] = {.lex_state = 0},
  [1645] = {.lex_state = 33},
  [1646] = {.lex_state = 53},
  [1647] = {.lex_state = 45},
  [1648] = {.lex_state = 0},
  [1649] = {.lex_state = 119},
  [1650] = {.lex_state = 119},
  [1651] = {.lex_state = 119},
  [1652] = {.lex_state = 45},
  [1653] = {.lex_state = 0},
  [1654] = {.lex_state = 119},
  [1655] = {.lex_state = 0},
  [1656] = {.lex_state = 0},
  [1657] = {.lex_state = 0},
  [1658] = {.lex_state = 0},
  [1659] = {.lex_state = 119},
  [1660] = {.lex_state = 119},
  [1661] = {.lex_state = 119},
  [1662] = {.lex_state = 0},
  [1663] = {.lex_state = 0},
  [1664] = {.lex_state = 0},
  [1665] = {.lex_state = 0},
  [1666] = {.lex_state = 53},
  [1667] = {.lex_state = 119},
  [1668] = {.lex_state = 0},
  [1669] = {.lex_state = 119},
  [1670] = {.lex_state = 119},
  [1671] = {.lex_state = 0},
  [1672] = {.lex_state = 53},
  [1673] = {.lex_state = 0},
  [1674] = {.lex_state = 33},
  [1675] = {.lex_state = 119},
  [1676] = {.lex_state = 119},
  [1677] = {.lex_state = 119},
  [1678] = {.lex_state = 53},
  [1679] = {.lex_state = 119},
  [1680] = {.lex_state = 0},
  [1681] = {.lex_state = 53},
  [1682] = {.lex_state = 45},
  [1683] = {.lex_state = 119},
  [1684] = {.lex_state = 0},
  [1685] = {.lex_state = 119},
  [1686] = {.lex_state = 119},
  [1687] = {.lex_state = 0},
  [1688] = {.lex_state = 0},
  [1689] = {.lex_state = 0},
  [1690] = {.lex_state = 0},
  [1691] = {.lex_state = 0},
  [1692] = {.lex_state = 33},
  [1693] = {.lex_state = 33},
  [1694] = {.lex_state = 119},
  [1695] = {.lex_state = 0},
  [1696] = {.lex_state = 0},
  [1697] = {.lex_state = 33},
  [1698] = {.lex_state = 119},
  [1699] = {.lex_state = 33},
  [1700] = {.lex_state = 119},
  [1701] = {.lex_state = 119},
  [1702] = {.lex_state = 53},
  [1703] = {.lex_state = 53},
  [1704] = {.lex_state = 0},
  [1705] = {.lex_state = 33},
  [1706] = {.lex_state = 0},
  [1707] = {.lex_state = 0},
  [1708] = {.lex_state = 33},
  [1709] = {.lex_state = 33},
  [1710] = {.lex_state = 119},
  [1711] = {.lex_state = 0},
  [1712] = {.lex_state = 33},
  [1713] = {.lex_state = 119},
  [1714] = {.lex_state = 33},
  [1715] = {.lex_state = 53},
  [1716] = {.lex_state = 33},
  [1717] = {.lex_state = 33},
  [1718] = {.lex_state = 33},
  [1719] = {.lex_state = 0},
  [1720] = {.lex_state = 0},
  [1721] = {.lex_state = 33},
  [1722] = {.lex_state = 0},
  [1723] = {.lex_state = 0},
  [1724] = {.lex_state = 0},
  [1725] = {.lex_state = 0},
  [1726] = {.lex_state = 0},
  [1727] = {.lex_state = 33},
  [1728] = {.lex_state = 119},
  [1729] = {.lex_state = 33},
  [1730] = {.lex_state = 119},
  [1731] = {.lex_state = 34},
  [1732] = {.lex_state = 0},
  [1733] = {.lex_state = 44},
  [1734] = {.lex_state = 0},
  [1735] = {.lex_state = 0},
  [1736] = {.lex_state = 0},
  [1737] = {.lex_state = 0},
  [1738] = {.lex_state = 44},
  [1739] = {.lex_state = 44},
  [1740] = {.lex_state = 0},
  [1741] = {.lex_state = 44},
  [1742] = {.lex_state = 44},
  [1743] = {.lex_state = 34},
  [1744] = {.lex_state = 44},
  [1745] = {.lex_state = 44},
  [1746] = {.lex_state = 44},
  [1747] = {.lex_state = 34},
  [1748] = {.lex_state = 0},
  [1749] = {.lex_state = 0},
  [1750] = {.lex_state = 44},
  [1751] = {.lex_state = 0},
  [1752] = {.lex_state = 0},
  [1753] = {.lex_state = 0},
  [1754] = {.lex_state = 53},
  [1755] = {.lex_state = 44},
  [1756] = {.lex_state = 44},
  [1757] = {.lex_state = 0},
  [1758] = {.lex_state = 0},
  [1759] = {.lex_state = 0},
  [1760] = {.lex_state = 34},
  [1761] = {.lex_state = 0},
  [1762] = {.lex_state = 0},
  [1763] = {.lex_state = 34},
  [1764] = {.lex_state = 0},
  [1765] = {.lex_state = 53},
  [1766] = {.lex_state = 0},
  [1767] = {.lex_state = 0},
  [1768] = {.lex_state = 34},
  [1769] = {.lex_state = 34},
  [1770] = {.lex_state = 0},
  [1771] = {.lex_state = 34},
  [1772] = {.lex_state = 0},
  [1773] = {.lex_state = 0},
  [1774] = {.lex_state = 0},
  [1775] = {.lex_state = 34},
  [1776] = {.lex_state = 44},
  [1777] = {.lex_state = 0},
  [1778] = {.lex_state = 34},
  [1779] = {.lex_state = 44},
  [1780] = {.lex_state = 44},
  [1781] = {.lex_state = 0},
  [1782] = {.lex_state = 44},
  [1783] = {.lex_state = 0},
  [1784] = {.lex_state = 34},
  [1785] = {.lex_state = 34},
  [1786] = {.lex_state = 0},
  [1787] = {.lex_state = 34},
  [1788] = {.lex_state = 0},
  [1789] = {.lex_state = 0},
  [1790] = {.lex_state = 34},
  [1791] = {.lex_state = 34},
  [1792] = {.lex_state = 34},
  [1793] = {.lex_state = 34},
  [1794] = {.lex_state = 34},
  [1795] = {.lex_state = 44},
  [1796] = {.lex_state = 53},
  [1797] = {.lex_state = 53},
  [1798] = {.lex_state = 53},
  [1799] = {.lex_state = 0},
  [1800] = {.lex_state = 0},
  [1801] = {.lex_state = 0},
  [1802] = {.lex_state = 34},
  [1803] = {.lex_state = 53},
  [1804] = {.lex_state = 34},
  [1805] = {.lex_state = 53},
  [1806] = {.lex_state = 44},
  [1807] = {.lex_state = 34},
  [1808] = {.lex_state = 0},
  [1809] = {.lex_state = 0},
  [1810] = {.lex_state = 34},
  [1811] = {.lex_state = 0},
  [1812] = {.lex_state = 0},
  [1813] = {.lex_state = 34},
  [1814] = {.lex_state = 0},
  [1815] = {.lex_state = 53},
  [1816] = {.lex_state = 0},
  [1817] = {.lex_state = 0},
  [1818] = {.lex_state = 0},
  [1819] = {.lex_state = 44},
  [1820] = {.lex_state = 0},
  [1821] = {.lex_state = 53},
  [1822] = {.lex_state = 53},
  [1823] = {.lex_state = 0},
  [1824] = {.lex_state = 119},
  [1825] = {.lex_state = 0},
  [1826] = {.lex_state = 0},
  [1827] = {.lex_state = 0},
  [1828] = {.lex_state = 0},
  [1829] = {.lex_state = 0},
  [1830] = {.lex_state = 119},
  [1831] = {.lex_state = 0},
  [1832] = {.lex_state = 0},
  [1833] = {.lex_state = 53},
  [1834] = {.lex_state = 44},
  [1835] = {.lex_state = 0},
  [1836] = {.lex_state = 0},
  [1837] = {.lex_state = 0},
  [1838] = {.lex_state = 53},
  [1839] = {.lex_state = 44},
  [1840] = {.lex_state = 0},
  [1841] = {.lex_state = 53},
  [1842] = {.lex_state = 0},
  [1843] = {.lex_state = 53},
  [1844] = {.lex_state = 0},
  [1845] = {.lex_state = 0},
  [1846] = {.lex_state = 0},
  [1847] = {.lex_state = 0},
  [1848] = {.lex_state = 53},
  [1849] = {.lex_state = 0},
  [1850] = {.lex_state = 0},
  [1851] = {.lex_state = 0},
  [1852] = {.lex_state = 0},
  [1853] = {.lex_state = 0},
  [1854] = {.lex_state = 44},
  [1855] = {.lex_state = 0},
  [1856] = {.lex_state = 0},
  [1857] = {.lex_state = 0},
  [1858] = {.lex_state = 44},
  [1859] = {.lex_state = 44},
  [1860] = {.lex_state = 0},
  [1861] = {.lex_state = 44},
  [1862] = {.lex_state = 0},
  [1863] = {.lex_state = 53},
  [1864] = {.lex_state = 53},
  [1865] = {.lex_state = 44},
  [1866] = {.lex_state = 0},
  [1867] = {.lex_state = 44},
  [1868] = {.lex_state = 44},
  [1869] = {.lex_state = 44},
  [1870] = {.lex_state = 44},
  [1871] = {.lex_state = 0},
  [1872] = {.lex_state = 0},
  [1873] = {.lex_state = 0},
  [1874] = {.lex_state = 0},
  [1875] = {.lex_state = 34},
  [1876] = {.lex_state = 0},
  [1877] = {.lex_state = 53},
  [1878] = {.lex_state = 53},
  [1879] = {.lex_state = 0},
  [1880] = {.lex_state = 0},
  [1881] = {.lex_state = 44},
  [1882] = {.lex_state = 0},
  [1883] = {.lex_state = 44},
  [1884] = {.lex_state = 44},
  [1885] = {.lex_state = 0},
  [1886] = {.lex_state = 53},
  [1887] = {.lex_state = 44},
  [1888] = {.lex_state = 0},
  [1889] = {.lex_state = 0},
  [1890] = {.lex_state = 0},
  [1891] = {.lex_state = 34},
  [1892] = {.lex_state = 34},
  [1893] = {.lex_state = 44},
  [1894] = {.lex_state = 0},
  [1895] = {.lex_state = 44},
  [1896] = {.lex_state = 44},
  [1897] = {.lex_state = 53},
  [1898] = {.lex_state = 44},
  [1899] = {.lex_state = 0},
  [1900] = {.lex_state = 44},
  [1901] = {.lex_state = 44},
  [1902] = {.lex_state = 53},
  [1903] = {.lex_state = 44},
  [1904] = {.lex_state = 44},
  [1905] = {.lex_state = 44},
  [1906] = {.lex_state = 0},
  [1907] = {.lex_state = 53},
  [1908] = {.lex_state = 53},
  [1909] = {.lex_state = 119},
  [1910] = {.lex_state = 53},
  [1911] = {.lex_state = 0},
  [1912] = {.lex_state = 0},
  [1913] = {.lex_state = 53},
  [1914] = {.lex_state = 53},
  [1915] = {.lex_state = 44},
  [1916] = {.lex_state = 0},
  [1917] = {.lex_state = 0},
  [1918] = {.lex_state = 53},
  [1919] = {.lex_state = 0},
  [1920] = {.lex_state = 0},
  [1921] = {.lex_state = 44},
  [1922] = {.lex_state = 0},
  [1923] = {.lex_state = 34},
  [1924] = {.lex_state = 44},
  [1925] = {.lex_state = 44},
  [1926] = {.lex_state = 44},
  [1927] = {.lex_state = 0},
  [1928] = {.lex_state = 53},
  [1929] = {.lex_state = 0},
  [1930] = {.lex_state = 0},
  [1931] = {.lex_state = 44},
  [1932] = {.lex_state = 53},
  [1933] = {.lex_state = 53},
  [1934] = {.lex_state = 0},
  [1935] = {.lex_state = 34},
  [1936] = {.lex_state = 53},
  [1937] = {.lex_state = 119},
  [1938] = {.lex_state = 0},
  [1939] = {.lex_state = 119},
  [1940] = {.lex_state = 119},
  [1941] = {.lex_state = 44},
  [1942] = {.lex_state = 53},
  [1943] = {.lex_state = 44},
  [1944] = {.lex_state = 44},
  [1945] = {.lex_state = 0},
  [1946] = {.lex_state = 119},
  [1947] = {.lex_state = 119},
  [1948] = {.lex_state = 34},
  [1949] = {.lex_state = 53},
  [1950] = {.lex_state = 119},
  [1951] = {.lex_state = 53},
  [1952] = {.lex_state = 0},
  [1953] = {.lex_state = 0},
  [1954] = {.lex_state = 44},
  [1955] = {.lex_state = 53},
  [1956] = {.lex_state = 0},
  [1957] = {.lex_state = 0},
  [1958] = {.lex_state = 119},
  [1959] = {.lex_state = 119},
  [1960] = {.lex_state = 53},
  [1961] = {.lex_state = 0},
  [1962] = {.lex_state = 53},
  [1963] = {.lex_state = 0},
  [1964] = {.lex_state = 53},
  [1965] = {.lex_state = 0},
  [1966] = {.lex_state = 0},
  [1967] = {.lex_state = 34},
  [1968] = {.lex_state = 0},
  [1969] = {.lex_state = 0},
  [1970] = {.lex_state = 53},
  [1971] = {.lex_state = 119},
  [1972] = {.lex_state = 119},
  [1973] = {.lex_state = 0},
  [1974] = {.lex_state = 119},
  [1975] = {.lex_state = 119},
  [1976] = {.lex_state = 53},
  [1977] = {.lex_state = 53},
  [1978] = {.lex_state = 119},
  [1979] = {.lex_state = 34},
  [1980] = {.lex_state = 53},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [aux_sym_preproc_include_token1] = ACTIONS(1),
    [aux_sym_preproc_def_token1] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [aux_sym_preproc_if_token1] = ACTIONS(1),
    [aux_sym_preproc_if_token2] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1),
    [aux_sym_preproc_else_token1] = ACTIONS(1),
    [aux_sym_preproc_elif_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1),
    [sym_preproc_directive] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_defined] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym___extension__] = ACTIONS(1),
    [anon_sym_typedef] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym___attribute__] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym___declspec] = ACTIONS(1),
    [anon_sym___based] = ACTIONS(1),
    [anon_sym___cdecl] = ACTIONS(1),
    [anon_sym___clrcall] = ACTIONS(1),
    [anon_sym___stdcall] = ACTIONS(1),
    [anon_sym___fastcall] = ACTIONS(1),
    [anon_sym___thiscall] = ACTIONS(1),
    [anon_sym___vectorcall] = ACTIONS(1),
    [sym_ms_restrict_modifier] = ACTIONS(1),
    [sym_ms_unsigned_ptr_modifier] = ACTIONS(1),
    [sym_ms_signed_ptr_modifier] = ACTIONS(1),
    [anon_sym__unaligned] = ACTIONS(1),
    [anon_sym___unaligned] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_auto] = ACTIONS(1),
    [anon_sym_register] = ACTIONS(1),
    [anon_sym_inline] = ACTIONS(1),
    [anon_sym___inline] = ACTIONS(1),
    [anon_sym___inline__] = ACTIONS(1),
    [anon_sym___forceinline] = ACTIONS(1),
    [anon_sym_thread_local] = ACTIONS(1),
    [anon_sym___thread] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_constexpr] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_restrict] = ACTIONS(1),
    [anon_sym___restrict__] = ACTIONS(1),
    [anon_sym__Atomic] = ACTIONS(1),
    [anon_sym__Noreturn] = ACTIONS(1),
    [anon_sym_noreturn] = ACTIONS(1),
    [anon_sym_alignas] = ACTIONS(1),
    [anon_sym__Alignas] = ACTIONS(1),
    [sym_primitive_type] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym___try] = ACTIONS(1),
    [anon_sym___except] = ACTIONS(1),
    [anon_sym___finally] = ACTIONS(1),
    [anon_sym___leave] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_sizeof] = ACTIONS(1),
    [anon_sym___alignof__] = ACTIONS(1),
    [anon_sym___alignof] = ACTIONS(1),
    [anon_sym__alignof] = ACTIONS(1),
    [anon_sym_alignof] = ACTIONS(1),
    [anon_sym__Alignof] = ACTIONS(1),
    [anon_sym_offsetof] = ACTIONS(1),
    [anon_sym__Generic] = ACTIONS(1),
    [anon_sym_asm] = ACTIONS(1),
    [anon_sym___asm__] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [sym_number_literal] = ACTIONS(1),
    [anon_sym_L_SQUOTE] = ACTIONS(1),
    [anon_sym_u_SQUOTE] = ACTIONS(1),
    [anon_sym_U_SQUOTE] = ACTIONS(1),
    [anon_sym_u8_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_L_DQUOTE] = ACTIONS(1),
    [anon_sym_u_DQUOTE] = ACTIONS(1),
    [anon_sym_U_DQUOTE] = ACTIONS(1),
    [anon_sym_u8_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [anon_sym_NULL] = ACTIONS(1),
    [anon_sym_nullptr] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_translation_unit] = STATE(1938),
    [sym__top_level_item] = STATE(43),
    [sym_preproc_include] = STATE(43),
    [sym_preproc_def] = STATE(43),
    [sym_preproc_function_def] = STATE(43),
    [sym_preproc_call] = STATE(43),
    [sym_preproc_if] = STATE(43),
    [sym_preproc_ifdef] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym__old_style_function_definition] = STATE(359),
    [sym_declaration] = STATE(43),
    [sym_type_definition] = STATE(43),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1101),
    [sym_linkage_specification] = STATE(43),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(697),
    [sym_compound_statement] = STATE(43),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(785),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(380),
    [sym__top_level_statement] = STATE(43),
    [sym_labeled_statement] = STATE(43),
    [sym__top_level_expression_statement] = STATE(43),
    [sym_if_statement] = STATE(43),
    [sym_switch_statement] = STATE(43),
    [sym_case_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_do_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_return_statement] = STATE(43),
    [sym_break_statement] = STATE(43),
    [sym_continue_statement] = STATE(43),
    [sym_goto_statement] = STATE(43),
    [sym_expression] = STATE(1078),
    [sym__string] = STATE(1076),
    [sym_conditional_expression] = STATE(1076),
    [sym_assignment_expression] = STATE(1076),
    [sym_pointer_expression] = STATE(898),
    [sym_unary_expression] = STATE(1076),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(1076),
    [sym_cast_expression] = STATE(1076),
    [sym_sizeof_expression] = STATE(1076),
    [sym_alignof_expression] = STATE(1076),
    [sym_offsetof_expression] = STATE(1076),
    [sym_generic_expression] = STATE(1076),
    [sym_subscript_expression] = STATE(898),
    [sym_call_expression] = STATE(898),
    [sym_gnu_asm_expression] = STATE(1076),
    [sym_field_expression] = STATE(898),
    [sym_compound_literal_expression] = STATE(1076),
    [sym_parenthesized_expression] = STATE(898),
    [sym_char_literal] = STATE(1076),
    [sym_concatenated_string] = STATE(1076),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(1076),
    [sym__empty_declaration] = STATE(43),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_translation_unit_repeat1] = STATE(43),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(347),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [aux_sym_preproc_include_token1] = ACTIONS(9),
    [aux_sym_preproc_def_token1] = ACTIONS(11),
    [aux_sym_preproc_if_token1] = ACTIONS(13),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(15),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(15),
    [sym_preproc_directive] = ACTIONS(17),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(31),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(63),
    [anon_sym_default] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_do] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_continue] = ACTIONS(77),
    [anon_sym_goto] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(93),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1834),
    [sym_preproc_elif] = STATE(1834),
    [sym_preproc_elifdef] = STATE(1834),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(111),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__block_item] = STATE(21),
    [sym_preproc_include] = STATE(21),
    [sym_preproc_def] = STATE(21),
    [sym_preproc_function_def] = STATE(21),
    [sym_preproc_call] = STATE(21),
    [sym_preproc_if] = STATE(21),
    [sym_preproc_ifdef] = STATE(21),
    [sym_preproc_else] = STATE(1738),
    [sym_preproc_elif] = STATE(1738),
    [sym_preproc_elifdef] = STATE(1738),
    [sym_function_definition] = STATE(21),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(21),
    [sym_type_definition] = STATE(21),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(21),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(21),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(21),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(21),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(163),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__block_item] = STATE(15),
    [sym_preproc_include] = STATE(15),
    [sym_preproc_def] = STATE(15),
    [sym_preproc_function_def] = STATE(15),
    [sym_preproc_call] = STATE(15),
    [sym_preproc_if] = STATE(15),
    [sym_preproc_ifdef] = STATE(15),
    [sym_preproc_else] = STATE(1744),
    [sym_preproc_elif] = STATE(1744),
    [sym_preproc_elifdef] = STATE(1744),
    [sym_function_definition] = STATE(15),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(15),
    [sym_type_definition] = STATE(15),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(15),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(15),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(15),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(15),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(165),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1839),
    [sym_preproc_elif] = STATE(1839),
    [sym_preproc_elifdef] = STATE(1839),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(167),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__block_item] = STATE(9),
    [sym_preproc_include] = STATE(9),
    [sym_preproc_def] = STATE(9),
    [sym_preproc_function_def] = STATE(9),
    [sym_preproc_call] = STATE(9),
    [sym_preproc_if] = STATE(9),
    [sym_preproc_ifdef] = STATE(9),
    [sym_preproc_else] = STATE(1819),
    [sym_preproc_elif] = STATE(1819),
    [sym_preproc_elifdef] = STATE(1819),
    [sym_function_definition] = STATE(9),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(9),
    [sym_type_definition] = STATE(9),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(9),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(9),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(9),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(9),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(169),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__block_item] = STATE(17),
    [sym_preproc_include] = STATE(17),
    [sym_preproc_def] = STATE(17),
    [sym_preproc_function_def] = STATE(17),
    [sym_preproc_call] = STATE(17),
    [sym_preproc_if] = STATE(17),
    [sym_preproc_ifdef] = STATE(17),
    [sym_preproc_else] = STATE(1782),
    [sym_preproc_elif] = STATE(1782),
    [sym_preproc_elifdef] = STATE(1782),
    [sym_function_definition] = STATE(17),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(17),
    [sym_type_definition] = STATE(17),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(17),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(17),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(17),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(17),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(171),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1915),
    [sym_preproc_elif] = STATE(1915),
    [sym_preproc_elifdef] = STATE(1915),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(173),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1739),
    [sym_preproc_elif] = STATE(1739),
    [sym_preproc_elifdef] = STATE(1739),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(175),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__block_item] = STATE(11),
    [sym_preproc_include] = STATE(11),
    [sym_preproc_def] = STATE(11),
    [sym_preproc_function_def] = STATE(11),
    [sym_preproc_call] = STATE(11),
    [sym_preproc_if] = STATE(11),
    [sym_preproc_ifdef] = STATE(11),
    [sym_preproc_else] = STATE(1893),
    [sym_preproc_elif] = STATE(1893),
    [sym_preproc_elifdef] = STATE(1893),
    [sym_function_definition] = STATE(11),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(11),
    [sym_type_definition] = STATE(11),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(11),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(11),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(11),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(11),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(177),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1944),
    [sym_preproc_elif] = STATE(1944),
    [sym_preproc_elifdef] = STATE(1944),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(179),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__block_item] = STATE(8),
    [sym_preproc_include] = STATE(8),
    [sym_preproc_def] = STATE(8),
    [sym_preproc_function_def] = STATE(8),
    [sym_preproc_call] = STATE(8),
    [sym_preproc_if] = STATE(8),
    [sym_preproc_ifdef] = STATE(8),
    [sym_preproc_else] = STATE(1954),
    [sym_preproc_elif] = STATE(1954),
    [sym_preproc_elifdef] = STATE(1954),
    [sym_function_definition] = STATE(8),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(8),
    [sym_type_definition] = STATE(8),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(8),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(8),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(8),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(8),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(181),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__block_item] = STATE(2),
    [sym_preproc_include] = STATE(2),
    [sym_preproc_def] = STATE(2),
    [sym_preproc_function_def] = STATE(2),
    [sym_preproc_call] = STATE(2),
    [sym_preproc_if] = STATE(2),
    [sym_preproc_ifdef] = STATE(2),
    [sym_preproc_else] = STATE(1806),
    [sym_preproc_elif] = STATE(1806),
    [sym_preproc_elifdef] = STATE(1806),
    [sym_function_definition] = STATE(2),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(2),
    [sym_type_definition] = STATE(2),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(2),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(2),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(2),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(2),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(183),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1898),
    [sym_preproc_elif] = STATE(1898),
    [sym_preproc_elifdef] = STATE(1898),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(185),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1755),
    [sym_preproc_elif] = STATE(1755),
    [sym_preproc_elifdef] = STATE(1755),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(187),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__block_item] = STATE(14),
    [sym_preproc_include] = STATE(14),
    [sym_preproc_def] = STATE(14),
    [sym_preproc_function_def] = STATE(14),
    [sym_preproc_call] = STATE(14),
    [sym_preproc_if] = STATE(14),
    [sym_preproc_ifdef] = STATE(14),
    [sym_preproc_else] = STATE(1943),
    [sym_preproc_elif] = STATE(1943),
    [sym_preproc_elifdef] = STATE(1943),
    [sym_function_definition] = STATE(14),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(14),
    [sym_type_definition] = STATE(14),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(14),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(14),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(14),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(14),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1746),
    [sym_preproc_elif] = STATE(1746),
    [sym_preproc_elifdef] = STATE(1746),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(191),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1941),
    [sym_preproc_elif] = STATE(1941),
    [sym_preproc_elifdef] = STATE(1941),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(193),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__block_item] = STATE(5),
    [sym_preproc_include] = STATE(5),
    [sym_preproc_def] = STATE(5),
    [sym_preproc_function_def] = STATE(5),
    [sym_preproc_call] = STATE(5),
    [sym_preproc_if] = STATE(5),
    [sym_preproc_ifdef] = STATE(5),
    [sym_preproc_else] = STATE(1779),
    [sym_preproc_elif] = STATE(1779),
    [sym_preproc_elifdef] = STATE(1779),
    [sym_function_definition] = STATE(5),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(5),
    [sym_type_definition] = STATE(5),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(5),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(5),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(5),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(5),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(195),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__block_item] = STATE(18),
    [sym_preproc_include] = STATE(18),
    [sym_preproc_def] = STATE(18),
    [sym_preproc_function_def] = STATE(18),
    [sym_preproc_call] = STATE(18),
    [sym_preproc_if] = STATE(18),
    [sym_preproc_ifdef] = STATE(18),
    [sym_preproc_else] = STATE(1741),
    [sym_preproc_elif] = STATE(1741),
    [sym_preproc_elifdef] = STATE(1741),
    [sym_function_definition] = STATE(18),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(18),
    [sym_type_definition] = STATE(18),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(18),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(18),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(18),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(18),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(197),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1733),
    [sym_preproc_elif] = STATE(1733),
    [sym_preproc_elifdef] = STATE(1733),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(103),
    [aux_sym_preproc_include_token1] = ACTIONS(105),
    [aux_sym_preproc_def_token1] = ACTIONS(107),
    [aux_sym_preproc_if_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token2] = ACTIONS(199),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(113),
    [aux_sym_preproc_else_token1] = ACTIONS(115),
    [aux_sym_preproc_elif_token1] = ACTIONS(117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(119),
    [sym_preproc_directive] = ACTIONS(121),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(129),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(122),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1098),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(687),
    [sym_compound_statement] = STATE(112),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(789),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(140),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(112),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_switch_statement] = STATE(112),
    [sym_case_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_goto_statement] = STATE(112),
    [sym_seh_try_statement] = STATE(112),
    [sym_seh_leave_statement] = STATE(112),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(201),
    [aux_sym_preproc_include_token1] = ACTIONS(204),
    [aux_sym_preproc_def_token1] = ACTIONS(207),
    [aux_sym_preproc_if_token1] = ACTIONS(210),
    [aux_sym_preproc_if_token2] = ACTIONS(213),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(215),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(215),
    [aux_sym_preproc_else_token1] = ACTIONS(213),
    [aux_sym_preproc_elif_token1] = ACTIONS(213),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(213),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(213),
    [sym_preproc_directive] = ACTIONS(218),
    [anon_sym_LPAREN2] = ACTIONS(221),
    [anon_sym_BANG] = ACTIONS(224),
    [anon_sym_TILDE] = ACTIONS(224),
    [anon_sym_DASH] = ACTIONS(227),
    [anon_sym_PLUS] = ACTIONS(227),
    [anon_sym_STAR] = ACTIONS(230),
    [anon_sym_AMP] = ACTIONS(230),
    [anon_sym_SEMI] = ACTIONS(233),
    [anon_sym___extension__] = ACTIONS(236),
    [anon_sym_typedef] = ACTIONS(239),
    [anon_sym_extern] = ACTIONS(242),
    [anon_sym___attribute__] = ACTIONS(245),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(248),
    [anon_sym___declspec] = ACTIONS(251),
    [anon_sym___cdecl] = ACTIONS(254),
    [anon_sym___clrcall] = ACTIONS(254),
    [anon_sym___stdcall] = ACTIONS(254),
    [anon_sym___fastcall] = ACTIONS(254),
    [anon_sym___thiscall] = ACTIONS(254),
    [anon_sym___vectorcall] = ACTIONS(254),
    [anon_sym_LBRACE] = ACTIONS(257),
    [anon_sym_signed] = ACTIONS(260),
    [anon_sym_unsigned] = ACTIONS(260),
    [anon_sym_long] = ACTIONS(260),
    [anon_sym_short] = ACTIONS(260),
    [anon_sym_static] = ACTIONS(263),
    [anon_sym_auto] = ACTIONS(263),
    [anon_sym_register] = ACTIONS(263),
    [anon_sym_inline] = ACTIONS(263),
    [anon_sym___inline] = ACTIONS(263),
    [anon_sym___inline__] = ACTIONS(263),
    [anon_sym___forceinline] = ACTIONS(263),
    [anon_sym_thread_local] = ACTIONS(263),
    [anon_sym___thread] = ACTIONS(263),
    [anon_sym_const] = ACTIONS(266),
    [anon_sym_constexpr] = ACTIONS(266),
    [anon_sym_volatile] = ACTIONS(266),
    [anon_sym_restrict] = ACTIONS(266),
    [anon_sym___restrict__] = ACTIONS(266),
    [anon_sym__Atomic] = ACTIONS(266),
    [anon_sym__Noreturn] = ACTIONS(266),
    [anon_sym_noreturn] = ACTIONS(266),
    [anon_sym_alignas] = ACTIONS(269),
    [anon_sym__Alignas] = ACTIONS(269),
    [sym_primitive_type] = ACTIONS(272),
    [anon_sym_enum] = ACTIONS(275),
    [anon_sym_struct] = ACTIONS(278),
    [anon_sym_union] = ACTIONS(281),
    [anon_sym_if] = ACTIONS(284),
    [anon_sym_switch] = ACTIONS(287),
    [anon_sym_case] = ACTIONS(290),
    [anon_sym_default] = ACTIONS(293),
    [anon_sym_while] = ACTIONS(296),
    [anon_sym_do] = ACTIONS(299),
    [anon_sym_for] = ACTIONS(302),
    [anon_sym_return] = ACTIONS(305),
    [anon_sym_break] = ACTIONS(308),
    [anon_sym_continue] = ACTIONS(311),
    [anon_sym_goto] = ACTIONS(314),
    [anon_sym___try] = ACTIONS(317),
    [anon_sym___leave] = ACTIONS(320),
    [anon_sym_DASH_DASH] = ACTIONS(323),
    [anon_sym_PLUS_PLUS] = ACTIONS(323),
    [anon_sym_sizeof] = ACTIONS(326),
    [anon_sym___alignof__] = ACTIONS(329),
    [anon_sym___alignof] = ACTIONS(329),
    [anon_sym__alignof] = ACTIONS(329),
    [anon_sym_alignof] = ACTIONS(329),
    [anon_sym__Alignof] = ACTIONS(329),
    [anon_sym_offsetof] = ACTIONS(332),
    [anon_sym__Generic] = ACTIONS(335),
    [anon_sym_asm] = ACTIONS(338),
    [anon_sym___asm__] = ACTIONS(338),
    [sym_number_literal] = ACTIONS(341),
    [anon_sym_L_SQUOTE] = ACTIONS(344),
    [anon_sym_u_SQUOTE] = ACTIONS(344),
    [anon_sym_U_SQUOTE] = ACTIONS(344),
    [anon_sym_u8_SQUOTE] = ACTIONS(344),
    [anon_sym_SQUOTE] = ACTIONS(344),
    [anon_sym_L_DQUOTE] = ACTIONS(347),
    [anon_sym_u_DQUOTE] = ACTIONS(347),
    [anon_sym_U_DQUOTE] = ACTIONS(347),
    [anon_sym_u8_DQUOTE] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(347),
    [sym_true] = ACTIONS(350),
    [sym_false] = ACTIONS(350),
    [anon_sym_NULL] = ACTIONS(353),
    [anon_sym_nullptr] = ACTIONS(353),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__block_item] = STATE(40),
    [sym_preproc_include] = STATE(40),
    [sym_preproc_def] = STATE(40),
    [sym_preproc_function_def] = STATE(40),
    [sym_preproc_call] = STATE(40),
    [sym_preproc_if] = STATE(40),
    [sym_preproc_ifdef] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(40),
    [sym_type_definition] = STATE(40),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(40),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(40),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(40),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(40),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(378),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__block_item] = STATE(27),
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(27),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(406),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__block_item] = STATE(42),
    [sym_preproc_include] = STATE(42),
    [sym_preproc_def] = STATE(42),
    [sym_preproc_function_def] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym_preproc_if] = STATE(42),
    [sym_preproc_ifdef] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(42),
    [sym_type_definition] = STATE(42),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(42),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(42),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(42),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(42),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(408),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__block_item] = STATE(31),
    [sym_preproc_include] = STATE(31),
    [sym_preproc_def] = STATE(31),
    [sym_preproc_function_def] = STATE(31),
    [sym_preproc_call] = STATE(31),
    [sym_preproc_if] = STATE(31),
    [sym_preproc_ifdef] = STATE(31),
    [sym_function_definition] = STATE(31),
    [sym__old_style_function_definition] = STATE(273),
    [sym_declaration] = STATE(31),
    [sym_type_definition] = STATE(31),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1099),
    [sym_linkage_specification] = STATE(31),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(691),
    [sym_compound_statement] = STATE(229),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(787),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(271),
    [sym_statement] = STATE(31),
    [sym_labeled_statement] = STATE(229),
    [sym_expression_statement] = STATE(229),
    [sym_if_statement] = STATE(229),
    [sym_switch_statement] = STATE(229),
    [sym_case_statement] = STATE(229),
    [sym_while_statement] = STATE(229),
    [sym_do_statement] = STATE(229),
    [sym_for_statement] = STATE(229),
    [sym_return_statement] = STATE(229),
    [sym_break_statement] = STATE(229),
    [sym_continue_statement] = STATE(229),
    [sym_goto_statement] = STATE(229),
    [sym_seh_try_statement] = STATE(229),
    [sym_seh_leave_statement] = STATE(229),
    [sym_expression] = STATE(1004),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1799),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(31),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(31),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(317),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(410),
    [aux_sym_preproc_include_token1] = ACTIONS(412),
    [aux_sym_preproc_def_token1] = ACTIONS(414),
    [aux_sym_preproc_if_token1] = ACTIONS(416),
    [aux_sym_preproc_if_token2] = ACTIONS(418),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(420),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(420),
    [sym_preproc_directive] = ACTIONS(422),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(424),
    [anon_sym___extension__] = ACTIONS(426),
    [anon_sym_typedef] = ACTIONS(428),
    [anon_sym_extern] = ACTIONS(430),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(432),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(434),
    [anon_sym_switch] = ACTIONS(436),
    [anon_sym_case] = ACTIONS(438),
    [anon_sym_default] = ACTIONS(440),
    [anon_sym_while] = ACTIONS(442),
    [anon_sym_do] = ACTIONS(444),
    [anon_sym_for] = ACTIONS(446),
    [anon_sym_return] = ACTIONS(448),
    [anon_sym_break] = ACTIONS(450),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_goto] = ACTIONS(454),
    [anon_sym___try] = ACTIONS(456),
    [anon_sym___leave] = ACTIONS(458),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__block_item] = STATE(40),
    [sym_preproc_include] = STATE(40),
    [sym_preproc_def] = STATE(40),
    [sym_preproc_function_def] = STATE(40),
    [sym_preproc_call] = STATE(40),
    [sym_preproc_if] = STATE(40),
    [sym_preproc_ifdef] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(40),
    [sym_type_definition] = STATE(40),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(40),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(40),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(40),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(40),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(460),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__block_item] = STATE(40),
    [sym_preproc_include] = STATE(40),
    [sym_preproc_def] = STATE(40),
    [sym_preproc_function_def] = STATE(40),
    [sym_preproc_call] = STATE(40),
    [sym_preproc_if] = STATE(40),
    [sym_preproc_ifdef] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(40),
    [sym_type_definition] = STATE(40),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(40),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(40),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(40),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(40),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(462),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__block_item] = STATE(40),
    [sym_preproc_include] = STATE(40),
    [sym_preproc_def] = STATE(40),
    [sym_preproc_function_def] = STATE(40),
    [sym_preproc_call] = STATE(40),
    [sym_preproc_if] = STATE(40),
    [sym_preproc_ifdef] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(40),
    [sym_type_definition] = STATE(40),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(40),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(40),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(40),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(40),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(464),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__block_item] = STATE(28),
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_function_definition] = STATE(28),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(28),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(28),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(28),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(466),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__block_item] = STATE(31),
    [sym_preproc_include] = STATE(31),
    [sym_preproc_def] = STATE(31),
    [sym_preproc_function_def] = STATE(31),
    [sym_preproc_call] = STATE(31),
    [sym_preproc_if] = STATE(31),
    [sym_preproc_ifdef] = STATE(31),
    [sym_function_definition] = STATE(31),
    [sym__old_style_function_definition] = STATE(273),
    [sym_declaration] = STATE(31),
    [sym_type_definition] = STATE(31),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1099),
    [sym_linkage_specification] = STATE(31),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(691),
    [sym_compound_statement] = STATE(229),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(787),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(271),
    [sym_statement] = STATE(31),
    [sym_labeled_statement] = STATE(229),
    [sym_expression_statement] = STATE(229),
    [sym_if_statement] = STATE(229),
    [sym_switch_statement] = STATE(229),
    [sym_case_statement] = STATE(229),
    [sym_while_statement] = STATE(229),
    [sym_do_statement] = STATE(229),
    [sym_for_statement] = STATE(229),
    [sym_return_statement] = STATE(229),
    [sym_break_statement] = STATE(229),
    [sym_continue_statement] = STATE(229),
    [sym_goto_statement] = STATE(229),
    [sym_seh_try_statement] = STATE(229),
    [sym_seh_leave_statement] = STATE(229),
    [sym_expression] = STATE(1004),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1799),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(31),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(31),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(317),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(468),
    [aux_sym_preproc_include_token1] = ACTIONS(471),
    [aux_sym_preproc_def_token1] = ACTIONS(474),
    [aux_sym_preproc_if_token1] = ACTIONS(477),
    [aux_sym_preproc_if_token2] = ACTIONS(213),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(480),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(480),
    [sym_preproc_directive] = ACTIONS(483),
    [anon_sym_LPAREN2] = ACTIONS(221),
    [anon_sym_BANG] = ACTIONS(224),
    [anon_sym_TILDE] = ACTIONS(224),
    [anon_sym_DASH] = ACTIONS(227),
    [anon_sym_PLUS] = ACTIONS(227),
    [anon_sym_STAR] = ACTIONS(230),
    [anon_sym_AMP] = ACTIONS(230),
    [anon_sym_SEMI] = ACTIONS(486),
    [anon_sym___extension__] = ACTIONS(489),
    [anon_sym_typedef] = ACTIONS(492),
    [anon_sym_extern] = ACTIONS(495),
    [anon_sym___attribute__] = ACTIONS(245),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(248),
    [anon_sym___declspec] = ACTIONS(251),
    [anon_sym___cdecl] = ACTIONS(254),
    [anon_sym___clrcall] = ACTIONS(254),
    [anon_sym___stdcall] = ACTIONS(254),
    [anon_sym___fastcall] = ACTIONS(254),
    [anon_sym___thiscall] = ACTIONS(254),
    [anon_sym___vectorcall] = ACTIONS(254),
    [anon_sym_LBRACE] = ACTIONS(498),
    [anon_sym_signed] = ACTIONS(260),
    [anon_sym_unsigned] = ACTIONS(260),
    [anon_sym_long] = ACTIONS(260),
    [anon_sym_short] = ACTIONS(260),
    [anon_sym_static] = ACTIONS(263),
    [anon_sym_auto] = ACTIONS(263),
    [anon_sym_register] = ACTIONS(263),
    [anon_sym_inline] = ACTIONS(263),
    [anon_sym___inline] = ACTIONS(263),
    [anon_sym___inline__] = ACTIONS(263),
    [anon_sym___forceinline] = ACTIONS(263),
    [anon_sym_thread_local] = ACTIONS(263),
    [anon_sym___thread] = ACTIONS(263),
    [anon_sym_const] = ACTIONS(266),
    [anon_sym_constexpr] = ACTIONS(266),
    [anon_sym_volatile] = ACTIONS(266),
    [anon_sym_restrict] = ACTIONS(266),
    [anon_sym___restrict__] = ACTIONS(266),
    [anon_sym__Atomic] = ACTIONS(266),
    [anon_sym__Noreturn] = ACTIONS(266),
    [anon_sym_noreturn] = ACTIONS(266),
    [anon_sym_alignas] = ACTIONS(269),
    [anon_sym__Alignas] = ACTIONS(269),
    [sym_primitive_type] = ACTIONS(272),
    [anon_sym_enum] = ACTIONS(275),
    [anon_sym_struct] = ACTIONS(278),
    [anon_sym_union] = ACTIONS(281),
    [anon_sym_if] = ACTIONS(501),
    [anon_sym_switch] = ACTIONS(504),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(510),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_do] = ACTIONS(516),
    [anon_sym_for] = ACTIONS(519),
    [anon_sym_return] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(525),
    [anon_sym_continue] = ACTIONS(528),
    [anon_sym_goto] = ACTIONS(531),
    [anon_sym___try] = ACTIONS(534),
    [anon_sym___leave] = ACTIONS(537),
    [anon_sym_DASH_DASH] = ACTIONS(323),
    [anon_sym_PLUS_PLUS] = ACTIONS(323),
    [anon_sym_sizeof] = ACTIONS(326),
    [anon_sym___alignof__] = ACTIONS(329),
    [anon_sym___alignof] = ACTIONS(329),
    [anon_sym__alignof] = ACTIONS(329),
    [anon_sym_alignof] = ACTIONS(329),
    [anon_sym__Alignof] = ACTIONS(329),
    [anon_sym_offsetof] = ACTIONS(332),
    [anon_sym__Generic] = ACTIONS(335),
    [anon_sym_asm] = ACTIONS(338),
    [anon_sym___asm__] = ACTIONS(338),
    [sym_number_literal] = ACTIONS(341),
    [anon_sym_L_SQUOTE] = ACTIONS(344),
    [anon_sym_u_SQUOTE] = ACTIONS(344),
    [anon_sym_U_SQUOTE] = ACTIONS(344),
    [anon_sym_u8_SQUOTE] = ACTIONS(344),
    [anon_sym_SQUOTE] = ACTIONS(344),
    [anon_sym_L_DQUOTE] = ACTIONS(347),
    [anon_sym_u_DQUOTE] = ACTIONS(347),
    [anon_sym_U_DQUOTE] = ACTIONS(347),
    [anon_sym_u8_DQUOTE] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(347),
    [sym_true] = ACTIONS(350),
    [sym_false] = ACTIONS(350),
    [anon_sym_NULL] = ACTIONS(353),
    [anon_sym_nullptr] = ACTIONS(353),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__block_item] = STATE(33),
    [sym_preproc_include] = STATE(33),
    [sym_preproc_def] = STATE(33),
    [sym_preproc_function_def] = STATE(33),
    [sym_preproc_call] = STATE(33),
    [sym_preproc_if] = STATE(33),
    [sym_preproc_ifdef] = STATE(33),
    [sym_function_definition] = STATE(33),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(33),
    [sym_type_definition] = STATE(33),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(33),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(33),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(33),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(33),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(540),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__block_item] = STATE(40),
    [sym_preproc_include] = STATE(40),
    [sym_preproc_def] = STATE(40),
    [sym_preproc_function_def] = STATE(40),
    [sym_preproc_call] = STATE(40),
    [sym_preproc_if] = STATE(40),
    [sym_preproc_ifdef] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(40),
    [sym_type_definition] = STATE(40),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(40),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(40),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(40),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(40),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__block_item] = STATE(41),
    [sym_preproc_include] = STATE(41),
    [sym_preproc_def] = STATE(41),
    [sym_preproc_function_def] = STATE(41),
    [sym_preproc_call] = STATE(41),
    [sym_preproc_if] = STATE(41),
    [sym_preproc_ifdef] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(41),
    [sym_type_definition] = STATE(41),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(41),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(41),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(41),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(41),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(544),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__block_item] = STATE(40),
    [sym_preproc_include] = STATE(40),
    [sym_preproc_def] = STATE(40),
    [sym_preproc_function_def] = STATE(40),
    [sym_preproc_call] = STATE(40),
    [sym_preproc_if] = STATE(40),
    [sym_preproc_ifdef] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(40),
    [sym_type_definition] = STATE(40),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(40),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(40),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(40),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(40),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(546),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__block_item] = STATE(26),
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(273),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1099),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(691),
    [sym_compound_statement] = STATE(229),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(787),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(271),
    [sym_statement] = STATE(26),
    [sym_labeled_statement] = STATE(229),
    [sym_expression_statement] = STATE(229),
    [sym_if_statement] = STATE(229),
    [sym_switch_statement] = STATE(229),
    [sym_case_statement] = STATE(229),
    [sym_while_statement] = STATE(229),
    [sym_do_statement] = STATE(229),
    [sym_for_statement] = STATE(229),
    [sym_return_statement] = STATE(229),
    [sym_break_statement] = STATE(229),
    [sym_continue_statement] = STATE(229),
    [sym_goto_statement] = STATE(229),
    [sym_seh_try_statement] = STATE(229),
    [sym_seh_leave_statement] = STATE(229),
    [sym_expression] = STATE(1004),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1799),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(317),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(410),
    [aux_sym_preproc_include_token1] = ACTIONS(412),
    [aux_sym_preproc_def_token1] = ACTIONS(414),
    [aux_sym_preproc_if_token1] = ACTIONS(416),
    [aux_sym_preproc_if_token2] = ACTIONS(548),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(420),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(420),
    [sym_preproc_directive] = ACTIONS(422),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(424),
    [anon_sym___extension__] = ACTIONS(426),
    [anon_sym_typedef] = ACTIONS(428),
    [anon_sym_extern] = ACTIONS(430),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(432),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(434),
    [anon_sym_switch] = ACTIONS(436),
    [anon_sym_case] = ACTIONS(438),
    [anon_sym_default] = ACTIONS(440),
    [anon_sym_while] = ACTIONS(442),
    [anon_sym_do] = ACTIONS(444),
    [anon_sym_for] = ACTIONS(446),
    [anon_sym_return] = ACTIONS(448),
    [anon_sym_break] = ACTIONS(450),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_goto] = ACTIONS(454),
    [anon_sym___try] = ACTIONS(456),
    [anon_sym___leave] = ACTIONS(458),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__block_item] = STATE(23),
    [sym_preproc_include] = STATE(23),
    [sym_preproc_def] = STATE(23),
    [sym_preproc_function_def] = STATE(23),
    [sym_preproc_call] = STATE(23),
    [sym_preproc_if] = STATE(23),
    [sym_preproc_ifdef] = STATE(23),
    [sym_function_definition] = STATE(23),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(23),
    [sym_type_definition] = STATE(23),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(23),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(23),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(23),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(23),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(550),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__block_item] = STATE(29),
    [sym_preproc_include] = STATE(29),
    [sym_preproc_def] = STATE(29),
    [sym_preproc_function_def] = STATE(29),
    [sym_preproc_call] = STATE(29),
    [sym_preproc_if] = STATE(29),
    [sym_preproc_ifdef] = STATE(29),
    [sym_function_definition] = STATE(29),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(29),
    [sym_type_definition] = STATE(29),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(29),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(29),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(29),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(29),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(552),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__block_item] = STATE(35),
    [sym_preproc_include] = STATE(35),
    [sym_preproc_def] = STATE(35),
    [sym_preproc_function_def] = STATE(35),
    [sym_preproc_call] = STATE(35),
    [sym_preproc_if] = STATE(35),
    [sym_preproc_ifdef] = STATE(35),
    [sym_function_definition] = STATE(35),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(35),
    [sym_type_definition] = STATE(35),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(35),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(35),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(35),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(35),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(554),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__block_item] = STATE(40),
    [sym_preproc_include] = STATE(40),
    [sym_preproc_def] = STATE(40),
    [sym_preproc_function_def] = STATE(40),
    [sym_preproc_call] = STATE(40),
    [sym_preproc_if] = STATE(40),
    [sym_preproc_ifdef] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(40),
    [sym_type_definition] = STATE(40),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(40),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(40),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(40),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(40),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(556),
    [aux_sym_preproc_include_token1] = ACTIONS(559),
    [aux_sym_preproc_def_token1] = ACTIONS(562),
    [aux_sym_preproc_if_token1] = ACTIONS(565),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(568),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(568),
    [sym_preproc_directive] = ACTIONS(571),
    [anon_sym_LPAREN2] = ACTIONS(221),
    [anon_sym_BANG] = ACTIONS(224),
    [anon_sym_TILDE] = ACTIONS(224),
    [anon_sym_DASH] = ACTIONS(227),
    [anon_sym_PLUS] = ACTIONS(227),
    [anon_sym_STAR] = ACTIONS(230),
    [anon_sym_AMP] = ACTIONS(230),
    [anon_sym_SEMI] = ACTIONS(574),
    [anon_sym___extension__] = ACTIONS(577),
    [anon_sym_typedef] = ACTIONS(580),
    [anon_sym_extern] = ACTIONS(583),
    [anon_sym___attribute__] = ACTIONS(245),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(248),
    [anon_sym___declspec] = ACTIONS(251),
    [anon_sym___cdecl] = ACTIONS(254),
    [anon_sym___clrcall] = ACTIONS(254),
    [anon_sym___stdcall] = ACTIONS(254),
    [anon_sym___fastcall] = ACTIONS(254),
    [anon_sym___thiscall] = ACTIONS(254),
    [anon_sym___vectorcall] = ACTIONS(254),
    [anon_sym_LBRACE] = ACTIONS(586),
    [anon_sym_RBRACE] = ACTIONS(589),
    [anon_sym_signed] = ACTIONS(260),
    [anon_sym_unsigned] = ACTIONS(260),
    [anon_sym_long] = ACTIONS(260),
    [anon_sym_short] = ACTIONS(260),
    [anon_sym_static] = ACTIONS(263),
    [anon_sym_auto] = ACTIONS(263),
    [anon_sym_register] = ACTIONS(263),
    [anon_sym_inline] = ACTIONS(263),
    [anon_sym___inline] = ACTIONS(263),
    [anon_sym___inline__] = ACTIONS(263),
    [anon_sym___forceinline] = ACTIONS(263),
    [anon_sym_thread_local] = ACTIONS(263),
    [anon_sym___thread] = ACTIONS(263),
    [anon_sym_const] = ACTIONS(266),
    [anon_sym_constexpr] = ACTIONS(266),
    [anon_sym_volatile] = ACTIONS(266),
    [anon_sym_restrict] = ACTIONS(266),
    [anon_sym___restrict__] = ACTIONS(266),
    [anon_sym__Atomic] = ACTIONS(266),
    [anon_sym__Noreturn] = ACTIONS(266),
    [anon_sym_noreturn] = ACTIONS(266),
    [anon_sym_alignas] = ACTIONS(269),
    [anon_sym__Alignas] = ACTIONS(269),
    [sym_primitive_type] = ACTIONS(272),
    [anon_sym_enum] = ACTIONS(275),
    [anon_sym_struct] = ACTIONS(278),
    [anon_sym_union] = ACTIONS(281),
    [anon_sym_if] = ACTIONS(591),
    [anon_sym_switch] = ACTIONS(594),
    [anon_sym_case] = ACTIONS(597),
    [anon_sym_default] = ACTIONS(600),
    [anon_sym_while] = ACTIONS(603),
    [anon_sym_do] = ACTIONS(606),
    [anon_sym_for] = ACTIONS(609),
    [anon_sym_return] = ACTIONS(612),
    [anon_sym_break] = ACTIONS(615),
    [anon_sym_continue] = ACTIONS(618),
    [anon_sym_goto] = ACTIONS(621),
    [anon_sym___try] = ACTIONS(624),
    [anon_sym___leave] = ACTIONS(627),
    [anon_sym_DASH_DASH] = ACTIONS(323),
    [anon_sym_PLUS_PLUS] = ACTIONS(323),
    [anon_sym_sizeof] = ACTIONS(326),
    [anon_sym___alignof__] = ACTIONS(329),
    [anon_sym___alignof] = ACTIONS(329),
    [anon_sym__alignof] = ACTIONS(329),
    [anon_sym_alignof] = ACTIONS(329),
    [anon_sym__Alignof] = ACTIONS(329),
    [anon_sym_offsetof] = ACTIONS(332),
    [anon_sym__Generic] = ACTIONS(335),
    [anon_sym_asm] = ACTIONS(338),
    [anon_sym___asm__] = ACTIONS(338),
    [sym_number_literal] = ACTIONS(341),
    [anon_sym_L_SQUOTE] = ACTIONS(344),
    [anon_sym_u_SQUOTE] = ACTIONS(344),
    [anon_sym_U_SQUOTE] = ACTIONS(344),
    [anon_sym_u8_SQUOTE] = ACTIONS(344),
    [anon_sym_SQUOTE] = ACTIONS(344),
    [anon_sym_L_DQUOTE] = ACTIONS(347),
    [anon_sym_u_DQUOTE] = ACTIONS(347),
    [anon_sym_U_DQUOTE] = ACTIONS(347),
    [anon_sym_u8_DQUOTE] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(347),
    [sym_true] = ACTIONS(350),
    [sym_false] = ACTIONS(350),
    [anon_sym_NULL] = ACTIONS(353),
    [anon_sym_nullptr] = ACTIONS(353),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__block_item] = STATE(40),
    [sym_preproc_include] = STATE(40),
    [sym_preproc_def] = STATE(40),
    [sym_preproc_function_def] = STATE(40),
    [sym_preproc_call] = STATE(40),
    [sym_preproc_if] = STATE(40),
    [sym_preproc_ifdef] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(40),
    [sym_type_definition] = STATE(40),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(40),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(40),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(40),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(40),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(630),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__block_item] = STATE(40),
    [sym_preproc_include] = STATE(40),
    [sym_preproc_def] = STATE(40),
    [sym_preproc_function_def] = STATE(40),
    [sym_preproc_call] = STATE(40),
    [sym_preproc_if] = STATE(40),
    [sym_preproc_ifdef] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym__old_style_function_definition] = STATE(289),
    [sym_declaration] = STATE(40),
    [sym_type_definition] = STATE(40),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1100),
    [sym_linkage_specification] = STATE(40),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(172),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(791),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(253),
    [sym_statement] = STATE(40),
    [sym_labeled_statement] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_case_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_goto_statement] = STATE(172),
    [sym_seh_try_statement] = STATE(172),
    [sym_seh_leave_statement] = STATE(172),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym__empty_declaration] = STATE(40),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_preproc_if_repeat1] = STATE(40),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(356),
    [aux_sym_preproc_include_token1] = ACTIONS(358),
    [aux_sym_preproc_def_token1] = ACTIONS(360),
    [aux_sym_preproc_if_token1] = ACTIONS(362),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(364),
    [sym_preproc_directive] = ACTIONS(366),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(374),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(632),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__top_level_item] = STATE(44),
    [sym_preproc_include] = STATE(44),
    [sym_preproc_def] = STATE(44),
    [sym_preproc_function_def] = STATE(44),
    [sym_preproc_call] = STATE(44),
    [sym_preproc_if] = STATE(44),
    [sym_preproc_ifdef] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__old_style_function_definition] = STATE(359),
    [sym_declaration] = STATE(44),
    [sym_type_definition] = STATE(44),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1101),
    [sym_linkage_specification] = STATE(44),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(697),
    [sym_compound_statement] = STATE(44),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(785),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(380),
    [sym__top_level_statement] = STATE(44),
    [sym_labeled_statement] = STATE(44),
    [sym__top_level_expression_statement] = STATE(44),
    [sym_if_statement] = STATE(44),
    [sym_switch_statement] = STATE(44),
    [sym_case_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_do_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_return_statement] = STATE(44),
    [sym_break_statement] = STATE(44),
    [sym_continue_statement] = STATE(44),
    [sym_goto_statement] = STATE(44),
    [sym_expression] = STATE(1078),
    [sym__string] = STATE(1076),
    [sym_conditional_expression] = STATE(1076),
    [sym_assignment_expression] = STATE(1076),
    [sym_pointer_expression] = STATE(898),
    [sym_unary_expression] = STATE(1076),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(1076),
    [sym_cast_expression] = STATE(1076),
    [sym_sizeof_expression] = STATE(1076),
    [sym_alignof_expression] = STATE(1076),
    [sym_offsetof_expression] = STATE(1076),
    [sym_generic_expression] = STATE(1076),
    [sym_subscript_expression] = STATE(898),
    [sym_call_expression] = STATE(898),
    [sym_gnu_asm_expression] = STATE(1076),
    [sym_field_expression] = STATE(898),
    [sym_compound_literal_expression] = STATE(1076),
    [sym_parenthesized_expression] = STATE(898),
    [sym_char_literal] = STATE(1076),
    [sym_concatenated_string] = STATE(1076),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(1076),
    [sym__empty_declaration] = STATE(44),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_translation_unit_repeat1] = STATE(44),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(347),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [ts_builtin_sym_end] = ACTIONS(634),
    [sym_identifier] = ACTIONS(7),
    [aux_sym_preproc_include_token1] = ACTIONS(9),
    [aux_sym_preproc_def_token1] = ACTIONS(11),
    [aux_sym_preproc_if_token1] = ACTIONS(13),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(15),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(15),
    [sym_preproc_directive] = ACTIONS(17),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(31),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(39),
    [anon_sym___clrcall] = ACTIONS(39),
    [anon_sym___stdcall] = ACTIONS(39),
    [anon_sym___fastcall] = ACTIONS(39),
    [anon_sym___thiscall] = ACTIONS(39),
    [anon_sym___vectorcall] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(63),
    [anon_sym_default] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_do] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_continue] = ACTIONS(77),
    [anon_sym_goto] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(93),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(99),
    [sym_false] = ACTIONS(99),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__top_level_item] = STATE(44),
    [sym_preproc_include] = STATE(44),
    [sym_preproc_def] = STATE(44),
    [sym_preproc_function_def] = STATE(44),
    [sym_preproc_call] = STATE(44),
    [sym_preproc_if] = STATE(44),
    [sym_preproc_ifdef] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__old_style_function_definition] = STATE(359),
    [sym_declaration] = STATE(44),
    [sym_type_definition] = STATE(44),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1101),
    [sym_linkage_specification] = STATE(44),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_ms_call_modifier] = STATE(697),
    [sym_compound_statement] = STATE(44),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(785),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(380),
    [sym__top_level_statement] = STATE(44),
    [sym_labeled_statement] = STATE(44),
    [sym__top_level_expression_statement] = STATE(44),
    [sym_if_statement] = STATE(44),
    [sym_switch_statement] = STATE(44),
    [sym_case_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_do_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_return_statement] = STATE(44),
    [sym_break_statement] = STATE(44),
    [sym_continue_statement] = STATE(44),
    [sym_goto_statement] = STATE(44),
    [sym_expression] = STATE(1078),
    [sym__string] = STATE(1076),
    [sym_conditional_expression] = STATE(1076),
    [sym_assignment_expression] = STATE(1076),
    [sym_pointer_expression] = STATE(898),
    [sym_unary_expression] = STATE(1076),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(1076),
    [sym_cast_expression] = STATE(1076),
    [sym_sizeof_expression] = STATE(1076),
    [sym_alignof_expression] = STATE(1076),
    [sym_offsetof_expression] = STATE(1076),
    [sym_generic_expression] = STATE(1076),
    [sym_subscript_expression] = STATE(898),
    [sym_call_expression] = STATE(898),
    [sym_gnu_asm_expression] = STATE(1076),
    [sym_field_expression] = STATE(898),
    [sym_compound_literal_expression] = STATE(1076),
    [sym_parenthesized_expression] = STATE(898),
    [sym_char_literal] = STATE(1076),
    [sym_concatenated_string] = STATE(1076),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(1076),
    [sym__empty_declaration] = STATE(44),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym_translation_unit_repeat1] = STATE(44),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(347),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [ts_builtin_sym_end] = ACTIONS(636),
    [sym_identifier] = ACTIONS(638),
    [aux_sym_preproc_include_token1] = ACTIONS(641),
    [aux_sym_preproc_def_token1] = ACTIONS(644),
    [aux_sym_preproc_if_token1] = ACTIONS(647),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(650),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(650),
    [sym_preproc_directive] = ACTIONS(653),
    [anon_sym_LPAREN2] = ACTIONS(656),
    [anon_sym_BANG] = ACTIONS(659),
    [anon_sym_TILDE] = ACTIONS(659),
    [anon_sym_DASH] = ACTIONS(662),
    [anon_sym_PLUS] = ACTIONS(662),
    [anon_sym_STAR] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(665),
    [anon_sym___extension__] = ACTIONS(668),
    [anon_sym_typedef] = ACTIONS(671),
    [anon_sym_extern] = ACTIONS(674),
    [anon_sym___attribute__] = ACTIONS(677),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(680),
    [anon_sym___declspec] = ACTIONS(683),
    [anon_sym___cdecl] = ACTIONS(686),
    [anon_sym___clrcall] = ACTIONS(686),
    [anon_sym___stdcall] = ACTIONS(686),
    [anon_sym___fastcall] = ACTIONS(686),
    [anon_sym___thiscall] = ACTIONS(686),
    [anon_sym___vectorcall] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(689),
    [anon_sym_signed] = ACTIONS(692),
    [anon_sym_unsigned] = ACTIONS(692),
    [anon_sym_long] = ACTIONS(692),
    [anon_sym_short] = ACTIONS(692),
    [anon_sym_static] = ACTIONS(695),
    [anon_sym_auto] = ACTIONS(695),
    [anon_sym_register] = ACTIONS(695),
    [anon_sym_inline] = ACTIONS(695),
    [anon_sym___inline] = ACTIONS(695),
    [anon_sym___inline__] = ACTIONS(695),
    [anon_sym___forceinline] = ACTIONS(695),
    [anon_sym_thread_local] = ACTIONS(695),
    [anon_sym___thread] = ACTIONS(695),
    [anon_sym_const] = ACTIONS(698),
    [anon_sym_constexpr] = ACTIONS(698),
    [anon_sym_volatile] = ACTIONS(698),
    [anon_sym_restrict] = ACTIONS(698),
    [anon_sym___restrict__] = ACTIONS(698),
    [anon_sym__Atomic] = ACTIONS(698),
    [anon_sym__Noreturn] = ACTIONS(698),
    [anon_sym_noreturn] = ACTIONS(698),
    [anon_sym_alignas] = ACTIONS(701),
    [anon_sym__Alignas] = ACTIONS(701),
    [sym_primitive_type] = ACTIONS(704),
    [anon_sym_enum] = ACTIONS(707),
    [anon_sym_struct] = ACTIONS(710),
    [anon_sym_union] = ACTIONS(713),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_switch] = ACTIONS(719),
    [anon_sym_case] = ACTIONS(722),
    [anon_sym_default] = ACTIONS(725),
    [anon_sym_while] = ACTIONS(728),
    [anon_sym_do] = ACTIONS(731),
    [anon_sym_for] = ACTIONS(734),
    [anon_sym_return] = ACTIONS(737),
    [anon_sym_break] = ACTIONS(740),
    [anon_sym_continue] = ACTIONS(743),
    [anon_sym_goto] = ACTIONS(746),
    [anon_sym_DASH_DASH] = ACTIONS(749),
    [anon_sym_PLUS_PLUS] = ACTIONS(749),
    [anon_sym_sizeof] = ACTIONS(752),
    [anon_sym___alignof__] = ACTIONS(755),
    [anon_sym___alignof] = ACTIONS(755),
    [anon_sym__alignof] = ACTIONS(755),
    [anon_sym_alignof] = ACTIONS(755),
    [anon_sym__Alignof] = ACTIONS(755),
    [anon_sym_offsetof] = ACTIONS(758),
    [anon_sym__Generic] = ACTIONS(761),
    [anon_sym_asm] = ACTIONS(764),
    [anon_sym___asm__] = ACTIONS(764),
    [sym_number_literal] = ACTIONS(767),
    [anon_sym_L_SQUOTE] = ACTIONS(770),
    [anon_sym_u_SQUOTE] = ACTIONS(770),
    [anon_sym_U_SQUOTE] = ACTIONS(770),
    [anon_sym_u8_SQUOTE] = ACTIONS(770),
    [anon_sym_SQUOTE] = ACTIONS(770),
    [anon_sym_L_DQUOTE] = ACTIONS(773),
    [anon_sym_u_DQUOTE] = ACTIONS(773),
    [anon_sym_U_DQUOTE] = ACTIONS(773),
    [anon_sym_u8_DQUOTE] = ACTIONS(773),
    [anon_sym_DQUOTE] = ACTIONS(773),
    [sym_true] = ACTIONS(776),
    [sym_false] = ACTIONS(776),
    [anon_sym_NULL] = ACTIONS(779),
    [anon_sym_nullptr] = ACTIONS(779),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym_declaration] = STATE(45),
    [sym_type_definition] = STATE(45),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1119),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(45),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(45),
    [sym_labeled_statement] = STATE(45),
    [sym_expression_statement] = STATE(45),
    [sym_if_statement] = STATE(45),
    [sym_switch_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_do_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_return_statement] = STATE(45),
    [sym_break_statement] = STATE(45),
    [sym_continue_statement] = STATE(45),
    [sym_goto_statement] = STATE(45),
    [sym_seh_try_statement] = STATE(45),
    [sym_seh_leave_statement] = STATE(45),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(45),
    [sym_identifier] = ACTIONS(782),
    [aux_sym_preproc_include_token1] = ACTIONS(785),
    [aux_sym_preproc_def_token1] = ACTIONS(785),
    [aux_sym_preproc_if_token1] = ACTIONS(785),
    [aux_sym_preproc_if_token2] = ACTIONS(785),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(785),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(785),
    [aux_sym_preproc_else_token1] = ACTIONS(785),
    [aux_sym_preproc_elif_token1] = ACTIONS(785),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(785),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(785),
    [sym_preproc_directive] = ACTIONS(785),
    [anon_sym_LPAREN2] = ACTIONS(787),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_TILDE] = ACTIONS(790),
    [anon_sym_DASH] = ACTIONS(793),
    [anon_sym_PLUS] = ACTIONS(793),
    [anon_sym_STAR] = ACTIONS(796),
    [anon_sym_AMP] = ACTIONS(796),
    [anon_sym_SEMI] = ACTIONS(799),
    [anon_sym___extension__] = ACTIONS(802),
    [anon_sym_typedef] = ACTIONS(805),
    [anon_sym_extern] = ACTIONS(808),
    [anon_sym___attribute__] = ACTIONS(811),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym___declspec] = ACTIONS(817),
    [anon_sym___cdecl] = ACTIONS(785),
    [anon_sym___clrcall] = ACTIONS(785),
    [anon_sym___stdcall] = ACTIONS(785),
    [anon_sym___fastcall] = ACTIONS(785),
    [anon_sym___thiscall] = ACTIONS(785),
    [anon_sym___vectorcall] = ACTIONS(785),
    [anon_sym_LBRACE] = ACTIONS(820),
    [anon_sym_signed] = ACTIONS(823),
    [anon_sym_unsigned] = ACTIONS(823),
    [anon_sym_long] = ACTIONS(823),
    [anon_sym_short] = ACTIONS(823),
    [anon_sym_static] = ACTIONS(808),
    [anon_sym_auto] = ACTIONS(808),
    [anon_sym_register] = ACTIONS(808),
    [anon_sym_inline] = ACTIONS(808),
    [anon_sym___inline] = ACTIONS(808),
    [anon_sym___inline__] = ACTIONS(808),
    [anon_sym___forceinline] = ACTIONS(808),
    [anon_sym_thread_local] = ACTIONS(808),
    [anon_sym___thread] = ACTIONS(808),
    [anon_sym_const] = ACTIONS(826),
    [anon_sym_constexpr] = ACTIONS(826),
    [anon_sym_volatile] = ACTIONS(826),
    [anon_sym_restrict] = ACTIONS(826),
    [anon_sym___restrict__] = ACTIONS(826),
    [anon_sym__Atomic] = ACTIONS(826),
    [anon_sym__Noreturn] = ACTIONS(826),
    [anon_sym_noreturn] = ACTIONS(826),
    [anon_sym_alignas] = ACTIONS(829),
    [anon_sym__Alignas] = ACTIONS(829),
    [sym_primitive_type] = ACTIONS(832),
    [anon_sym_enum] = ACTIONS(835),
    [anon_sym_struct] = ACTIONS(838),
    [anon_sym_union] = ACTIONS(841),
    [anon_sym_if] = ACTIONS(844),
    [anon_sym_else] = ACTIONS(785),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_case] = ACTIONS(785),
    [anon_sym_default] = ACTIONS(785),
    [anon_sym_while] = ACTIONS(850),
    [anon_sym_do] = ACTIONS(853),
    [anon_sym_for] = ACTIONS(856),
    [anon_sym_return] = ACTIONS(859),
    [anon_sym_break] = ACTIONS(862),
    [anon_sym_continue] = ACTIONS(865),
    [anon_sym_goto] = ACTIONS(868),
    [anon_sym___try] = ACTIONS(871),
    [anon_sym___leave] = ACTIONS(874),
    [anon_sym_DASH_DASH] = ACTIONS(877),
    [anon_sym_PLUS_PLUS] = ACTIONS(877),
    [anon_sym_sizeof] = ACTIONS(880),
    [anon_sym___alignof__] = ACTIONS(883),
    [anon_sym___alignof] = ACTIONS(883),
    [anon_sym__alignof] = ACTIONS(883),
    [anon_sym_alignof] = ACTIONS(883),
    [anon_sym__Alignof] = ACTIONS(883),
    [anon_sym_offsetof] = ACTIONS(886),
    [anon_sym__Generic] = ACTIONS(889),
    [anon_sym_asm] = ACTIONS(892),
    [anon_sym___asm__] = ACTIONS(892),
    [sym_number_literal] = ACTIONS(895),
    [anon_sym_L_SQUOTE] = ACTIONS(898),
    [anon_sym_u_SQUOTE] = ACTIONS(898),
    [anon_sym_U_SQUOTE] = ACTIONS(898),
    [anon_sym_u8_SQUOTE] = ACTIONS(898),
    [anon_sym_SQUOTE] = ACTIONS(898),
    [anon_sym_L_DQUOTE] = ACTIONS(901),
    [anon_sym_u_DQUOTE] = ACTIONS(901),
    [anon_sym_U_DQUOTE] = ACTIONS(901),
    [anon_sym_u8_DQUOTE] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(901),
    [sym_true] = ACTIONS(904),
    [sym_false] = ACTIONS(904),
    [anon_sym_NULL] = ACTIONS(907),
    [anon_sym_nullptr] = ACTIONS(907),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym_declaration] = STATE(45),
    [sym_type_definition] = STATE(45),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1119),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(45),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(45),
    [sym_labeled_statement] = STATE(45),
    [sym_expression_statement] = STATE(45),
    [sym_if_statement] = STATE(45),
    [sym_switch_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_do_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_return_statement] = STATE(45),
    [sym_break_statement] = STATE(45),
    [sym_continue_statement] = STATE(45),
    [sym_goto_statement] = STATE(45),
    [sym_seh_try_statement] = STATE(45),
    [sym_seh_leave_statement] = STATE(45),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(45),
    [sym_identifier] = ACTIONS(910),
    [aux_sym_preproc_include_token1] = ACTIONS(912),
    [aux_sym_preproc_def_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token2] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(912),
    [aux_sym_preproc_else_token1] = ACTIONS(912),
    [aux_sym_preproc_elif_token1] = ACTIONS(912),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(912),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(912),
    [sym_preproc_directive] = ACTIONS(912),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(912),
    [anon_sym___clrcall] = ACTIONS(912),
    [anon_sym___stdcall] = ACTIONS(912),
    [anon_sym___fastcall] = ACTIONS(912),
    [anon_sym___thiscall] = ACTIONS(912),
    [anon_sym___vectorcall] = ACTIONS(912),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_else] = ACTIONS(912),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(912),
    [anon_sym_default] = ACTIONS(912),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_declaration] = STATE(49),
    [sym_type_definition] = STATE(49),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1119),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(49),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(49),
    [sym_labeled_statement] = STATE(49),
    [sym_expression_statement] = STATE(49),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_while_statement] = STATE(49),
    [sym_do_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_return_statement] = STATE(49),
    [sym_break_statement] = STATE(49),
    [sym_continue_statement] = STATE(49),
    [sym_goto_statement] = STATE(49),
    [sym_seh_try_statement] = STATE(49),
    [sym_seh_leave_statement] = STATE(49),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(49),
    [sym_identifier] = ACTIONS(910),
    [aux_sym_preproc_include_token1] = ACTIONS(914),
    [aux_sym_preproc_def_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token2] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(914),
    [aux_sym_preproc_else_token1] = ACTIONS(914),
    [aux_sym_preproc_elif_token1] = ACTIONS(914),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(914),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(914),
    [sym_preproc_directive] = ACTIONS(914),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(914),
    [anon_sym___clrcall] = ACTIONS(914),
    [anon_sym___stdcall] = ACTIONS(914),
    [anon_sym___fastcall] = ACTIONS(914),
    [anon_sym___thiscall] = ACTIONS(914),
    [anon_sym___vectorcall] = ACTIONS(914),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_else] = ACTIONS(914),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(914),
    [anon_sym_default] = ACTIONS(914),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym_declaration] = STATE(46),
    [sym_type_definition] = STATE(46),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1119),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(46),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(46),
    [sym_labeled_statement] = STATE(46),
    [sym_expression_statement] = STATE(46),
    [sym_if_statement] = STATE(46),
    [sym_switch_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_do_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_return_statement] = STATE(46),
    [sym_break_statement] = STATE(46),
    [sym_continue_statement] = STATE(46),
    [sym_goto_statement] = STATE(46),
    [sym_seh_try_statement] = STATE(46),
    [sym_seh_leave_statement] = STATE(46),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(46),
    [sym_identifier] = ACTIONS(910),
    [aux_sym_preproc_include_token1] = ACTIONS(916),
    [aux_sym_preproc_def_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token2] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(916),
    [aux_sym_preproc_else_token1] = ACTIONS(916),
    [aux_sym_preproc_elif_token1] = ACTIONS(916),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(916),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(916),
    [sym_preproc_directive] = ACTIONS(916),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(916),
    [anon_sym___clrcall] = ACTIONS(916),
    [anon_sym___stdcall] = ACTIONS(916),
    [anon_sym___fastcall] = ACTIONS(916),
    [anon_sym___thiscall] = ACTIONS(916),
    [anon_sym___vectorcall] = ACTIONS(916),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_else] = ACTIONS(916),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(916),
    [anon_sym_default] = ACTIONS(916),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym_declaration] = STATE(45),
    [sym_type_definition] = STATE(45),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1119),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(45),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(45),
    [sym_labeled_statement] = STATE(45),
    [sym_expression_statement] = STATE(45),
    [sym_if_statement] = STATE(45),
    [sym_switch_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_do_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_return_statement] = STATE(45),
    [sym_break_statement] = STATE(45),
    [sym_continue_statement] = STATE(45),
    [sym_goto_statement] = STATE(45),
    [sym_seh_try_statement] = STATE(45),
    [sym_seh_leave_statement] = STATE(45),
    [sym_expression] = STATE(1029),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1759),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(45),
    [sym_identifier] = ACTIONS(910),
    [aux_sym_preproc_include_token1] = ACTIONS(918),
    [aux_sym_preproc_def_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token2] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(918),
    [aux_sym_preproc_else_token1] = ACTIONS(918),
    [aux_sym_preproc_elif_token1] = ACTIONS(918),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(918),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(918),
    [sym_preproc_directive] = ACTIONS(918),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym___extension__] = ACTIONS(125),
    [anon_sym_typedef] = ACTIONS(127),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(918),
    [anon_sym___clrcall] = ACTIONS(918),
    [anon_sym___stdcall] = ACTIONS(918),
    [anon_sym___fastcall] = ACTIONS(918),
    [anon_sym___thiscall] = ACTIONS(918),
    [anon_sym___vectorcall] = ACTIONS(918),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_else] = ACTIONS(918),
    [anon_sym_switch] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(918),
    [anon_sym_default] = ACTIONS(918),
    [anon_sym_while] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(145),
    [anon_sym_return] = ACTIONS(147),
    [anon_sym_break] = ACTIONS(149),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_goto] = ACTIONS(153),
    [anon_sym___try] = ACTIONS(155),
    [anon_sym___leave] = ACTIONS(157),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1107),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(58),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym_seh_try_statement] = STATE(58),
    [sym_seh_leave_statement] = STATE(58),
    [sym_expression] = STATE(1004),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1799),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(317),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(58),
    [sym_identifier] = ACTIONS(920),
    [aux_sym_preproc_include_token1] = ACTIONS(912),
    [aux_sym_preproc_def_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token2] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(912),
    [sym_preproc_directive] = ACTIONS(912),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(424),
    [anon_sym___extension__] = ACTIONS(426),
    [anon_sym_typedef] = ACTIONS(428),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(912),
    [anon_sym___clrcall] = ACTIONS(912),
    [anon_sym___stdcall] = ACTIONS(912),
    [anon_sym___fastcall] = ACTIONS(912),
    [anon_sym___thiscall] = ACTIONS(912),
    [anon_sym___vectorcall] = ACTIONS(912),
    [anon_sym_LBRACE] = ACTIONS(432),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(434),
    [anon_sym_else] = ACTIONS(912),
    [anon_sym_switch] = ACTIONS(436),
    [anon_sym_case] = ACTIONS(912),
    [anon_sym_default] = ACTIONS(912),
    [anon_sym_while] = ACTIONS(442),
    [anon_sym_do] = ACTIONS(444),
    [anon_sym_for] = ACTIONS(446),
    [anon_sym_return] = ACTIONS(448),
    [anon_sym_break] = ACTIONS(450),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_goto] = ACTIONS(454),
    [anon_sym___try] = ACTIONS(456),
    [anon_sym___leave] = ACTIONS(458),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_declaration] = STATE(55),
    [sym_type_definition] = STATE(55),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1107),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(55),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(55),
    [sym_labeled_statement] = STATE(55),
    [sym_expression_statement] = STATE(55),
    [sym_if_statement] = STATE(55),
    [sym_switch_statement] = STATE(55),
    [sym_while_statement] = STATE(55),
    [sym_do_statement] = STATE(55),
    [sym_for_statement] = STATE(55),
    [sym_return_statement] = STATE(55),
    [sym_break_statement] = STATE(55),
    [sym_continue_statement] = STATE(55),
    [sym_goto_statement] = STATE(55),
    [sym_seh_try_statement] = STATE(55),
    [sym_seh_leave_statement] = STATE(55),
    [sym_expression] = STATE(1004),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1799),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(317),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(55),
    [sym_identifier] = ACTIONS(920),
    [aux_sym_preproc_include_token1] = ACTIONS(914),
    [aux_sym_preproc_def_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token2] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(914),
    [sym_preproc_directive] = ACTIONS(914),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(424),
    [anon_sym___extension__] = ACTIONS(426),
    [anon_sym_typedef] = ACTIONS(428),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(914),
    [anon_sym___clrcall] = ACTIONS(914),
    [anon_sym___stdcall] = ACTIONS(914),
    [anon_sym___fastcall] = ACTIONS(914),
    [anon_sym___thiscall] = ACTIONS(914),
    [anon_sym___vectorcall] = ACTIONS(914),
    [anon_sym_LBRACE] = ACTIONS(432),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(434),
    [anon_sym_else] = ACTIONS(914),
    [anon_sym_switch] = ACTIONS(436),
    [anon_sym_case] = ACTIONS(914),
    [anon_sym_default] = ACTIONS(914),
    [anon_sym_while] = ACTIONS(442),
    [anon_sym_do] = ACTIONS(444),
    [anon_sym_for] = ACTIONS(446),
    [anon_sym_return] = ACTIONS(448),
    [anon_sym_break] = ACTIONS(450),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_goto] = ACTIONS(454),
    [anon_sym___try] = ACTIONS(456),
    [anon_sym___leave] = ACTIONS(458),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym_declaration] = STATE(63),
    [sym_type_definition] = STATE(63),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1109),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(63),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(63),
    [sym_labeled_statement] = STATE(63),
    [sym_expression_statement] = STATE(63),
    [sym_if_statement] = STATE(63),
    [sym_switch_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_do_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_return_statement] = STATE(63),
    [sym_break_statement] = STATE(63),
    [sym_continue_statement] = STATE(63),
    [sym_goto_statement] = STATE(63),
    [sym_seh_try_statement] = STATE(63),
    [sym_seh_leave_statement] = STATE(63),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(63),
    [sym_identifier] = ACTIONS(922),
    [aux_sym_preproc_include_token1] = ACTIONS(914),
    [aux_sym_preproc_def_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(914),
    [sym_preproc_directive] = ACTIONS(914),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(914),
    [anon_sym___clrcall] = ACTIONS(914),
    [anon_sym___stdcall] = ACTIONS(914),
    [anon_sym___fastcall] = ACTIONS(914),
    [anon_sym___thiscall] = ACTIONS(914),
    [anon_sym___vectorcall] = ACTIONS(914),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(924),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_else] = ACTIONS(914),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(914),
    [anon_sym_default] = ACTIONS(914),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_declaration] = STATE(50),
    [sym_type_definition] = STATE(50),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1107),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(50),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(50),
    [sym_labeled_statement] = STATE(50),
    [sym_expression_statement] = STATE(50),
    [sym_if_statement] = STATE(50),
    [sym_switch_statement] = STATE(50),
    [sym_while_statement] = STATE(50),
    [sym_do_statement] = STATE(50),
    [sym_for_statement] = STATE(50),
    [sym_return_statement] = STATE(50),
    [sym_break_statement] = STATE(50),
    [sym_continue_statement] = STATE(50),
    [sym_goto_statement] = STATE(50),
    [sym_seh_try_statement] = STATE(50),
    [sym_seh_leave_statement] = STATE(50),
    [sym_expression] = STATE(1004),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1799),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(317),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(50),
    [sym_identifier] = ACTIONS(920),
    [aux_sym_preproc_include_token1] = ACTIONS(916),
    [aux_sym_preproc_def_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token2] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(916),
    [sym_preproc_directive] = ACTIONS(916),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(424),
    [anon_sym___extension__] = ACTIONS(426),
    [anon_sym_typedef] = ACTIONS(428),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(916),
    [anon_sym___clrcall] = ACTIONS(916),
    [anon_sym___stdcall] = ACTIONS(916),
    [anon_sym___fastcall] = ACTIONS(916),
    [anon_sym___thiscall] = ACTIONS(916),
    [anon_sym___vectorcall] = ACTIONS(916),
    [anon_sym_LBRACE] = ACTIONS(432),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(434),
    [anon_sym_else] = ACTIONS(916),
    [anon_sym_switch] = ACTIONS(436),
    [anon_sym_case] = ACTIONS(916),
    [anon_sym_default] = ACTIONS(916),
    [anon_sym_while] = ACTIONS(442),
    [anon_sym_do] = ACTIONS(444),
    [anon_sym_for] = ACTIONS(446),
    [anon_sym_return] = ACTIONS(448),
    [anon_sym_break] = ACTIONS(450),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_goto] = ACTIONS(454),
    [anon_sym___try] = ACTIONS(456),
    [anon_sym___leave] = ACTIONS(458),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_declaration] = STATE(57),
    [sym_type_definition] = STATE(57),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1115),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(57),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(57),
    [sym_labeled_statement] = STATE(57),
    [sym_expression_statement] = STATE(57),
    [sym_if_statement] = STATE(57),
    [sym_switch_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_do_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_return_statement] = STATE(57),
    [sym_break_statement] = STATE(57),
    [sym_continue_statement] = STATE(57),
    [sym_goto_statement] = STATE(57),
    [sym_seh_try_statement] = STATE(57),
    [sym_seh_leave_statement] = STATE(57),
    [sym_expression] = STATE(1019),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1826),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(347),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(57),
    [ts_builtin_sym_end] = ACTIONS(926),
    [sym_identifier] = ACTIONS(928),
    [aux_sym_preproc_include_token1] = ACTIONS(912),
    [aux_sym_preproc_def_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(912),
    [sym_preproc_directive] = ACTIONS(912),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(930),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(912),
    [anon_sym___clrcall] = ACTIONS(912),
    [anon_sym___stdcall] = ACTIONS(912),
    [anon_sym___fastcall] = ACTIONS(912),
    [anon_sym___thiscall] = ACTIONS(912),
    [anon_sym___vectorcall] = ACTIONS(912),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_else] = ACTIONS(912),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(912),
    [anon_sym_default] = ACTIONS(912),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_do] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_continue] = ACTIONS(77),
    [anon_sym_goto] = ACTIONS(79),
    [anon_sym___try] = ACTIONS(932),
    [anon_sym___leave] = ACTIONS(934),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1107),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(58),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym_seh_try_statement] = STATE(58),
    [sym_seh_leave_statement] = STATE(58),
    [sym_expression] = STATE(1004),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1799),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(317),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(58),
    [sym_identifier] = ACTIONS(920),
    [aux_sym_preproc_include_token1] = ACTIONS(918),
    [aux_sym_preproc_def_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token2] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(918),
    [sym_preproc_directive] = ACTIONS(918),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(424),
    [anon_sym___extension__] = ACTIONS(426),
    [anon_sym_typedef] = ACTIONS(428),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(918),
    [anon_sym___clrcall] = ACTIONS(918),
    [anon_sym___stdcall] = ACTIONS(918),
    [anon_sym___fastcall] = ACTIONS(918),
    [anon_sym___thiscall] = ACTIONS(918),
    [anon_sym___vectorcall] = ACTIONS(918),
    [anon_sym_LBRACE] = ACTIONS(432),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(434),
    [anon_sym_else] = ACTIONS(918),
    [anon_sym_switch] = ACTIONS(436),
    [anon_sym_case] = ACTIONS(918),
    [anon_sym_default] = ACTIONS(918),
    [anon_sym_while] = ACTIONS(442),
    [anon_sym_do] = ACTIONS(444),
    [anon_sym_for] = ACTIONS(446),
    [anon_sym_return] = ACTIONS(448),
    [anon_sym_break] = ACTIONS(450),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_goto] = ACTIONS(454),
    [anon_sym___try] = ACTIONS(456),
    [anon_sym___leave] = ACTIONS(458),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym_declaration] = STATE(57),
    [sym_type_definition] = STATE(57),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1115),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(57),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(57),
    [sym_labeled_statement] = STATE(57),
    [sym_expression_statement] = STATE(57),
    [sym_if_statement] = STATE(57),
    [sym_switch_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_do_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_return_statement] = STATE(57),
    [sym_break_statement] = STATE(57),
    [sym_continue_statement] = STATE(57),
    [sym_goto_statement] = STATE(57),
    [sym_seh_try_statement] = STATE(57),
    [sym_seh_leave_statement] = STATE(57),
    [sym_expression] = STATE(1019),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1826),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(347),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(57),
    [ts_builtin_sym_end] = ACTIONS(936),
    [sym_identifier] = ACTIONS(928),
    [aux_sym_preproc_include_token1] = ACTIONS(918),
    [aux_sym_preproc_def_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(918),
    [sym_preproc_directive] = ACTIONS(918),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(930),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(918),
    [anon_sym___clrcall] = ACTIONS(918),
    [anon_sym___stdcall] = ACTIONS(918),
    [anon_sym___fastcall] = ACTIONS(918),
    [anon_sym___thiscall] = ACTIONS(918),
    [anon_sym___vectorcall] = ACTIONS(918),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_else] = ACTIONS(918),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(918),
    [anon_sym_default] = ACTIONS(918),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_do] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_continue] = ACTIONS(77),
    [anon_sym_goto] = ACTIONS(79),
    [anon_sym___try] = ACTIONS(932),
    [anon_sym___leave] = ACTIONS(934),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_declaration] = STATE(57),
    [sym_type_definition] = STATE(57),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1115),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(57),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(57),
    [sym_labeled_statement] = STATE(57),
    [sym_expression_statement] = STATE(57),
    [sym_if_statement] = STATE(57),
    [sym_switch_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_do_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_return_statement] = STATE(57),
    [sym_break_statement] = STATE(57),
    [sym_continue_statement] = STATE(57),
    [sym_goto_statement] = STATE(57),
    [sym_seh_try_statement] = STATE(57),
    [sym_seh_leave_statement] = STATE(57),
    [sym_expression] = STATE(1019),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1826),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(347),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(57),
    [ts_builtin_sym_end] = ACTIONS(938),
    [sym_identifier] = ACTIONS(940),
    [aux_sym_preproc_include_token1] = ACTIONS(785),
    [aux_sym_preproc_def_token1] = ACTIONS(785),
    [aux_sym_preproc_if_token1] = ACTIONS(785),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(785),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(785),
    [sym_preproc_directive] = ACTIONS(785),
    [anon_sym_LPAREN2] = ACTIONS(787),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_TILDE] = ACTIONS(790),
    [anon_sym_DASH] = ACTIONS(793),
    [anon_sym_PLUS] = ACTIONS(793),
    [anon_sym_STAR] = ACTIONS(796),
    [anon_sym_AMP] = ACTIONS(796),
    [anon_sym_SEMI] = ACTIONS(943),
    [anon_sym___extension__] = ACTIONS(946),
    [anon_sym_typedef] = ACTIONS(949),
    [anon_sym_extern] = ACTIONS(808),
    [anon_sym___attribute__] = ACTIONS(811),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym___declspec] = ACTIONS(817),
    [anon_sym___cdecl] = ACTIONS(785),
    [anon_sym___clrcall] = ACTIONS(785),
    [anon_sym___stdcall] = ACTIONS(785),
    [anon_sym___fastcall] = ACTIONS(785),
    [anon_sym___thiscall] = ACTIONS(785),
    [anon_sym___vectorcall] = ACTIONS(785),
    [anon_sym_LBRACE] = ACTIONS(952),
    [anon_sym_signed] = ACTIONS(823),
    [anon_sym_unsigned] = ACTIONS(823),
    [anon_sym_long] = ACTIONS(823),
    [anon_sym_short] = ACTIONS(823),
    [anon_sym_static] = ACTIONS(808),
    [anon_sym_auto] = ACTIONS(808),
    [anon_sym_register] = ACTIONS(808),
    [anon_sym_inline] = ACTIONS(808),
    [anon_sym___inline] = ACTIONS(808),
    [anon_sym___inline__] = ACTIONS(808),
    [anon_sym___forceinline] = ACTIONS(808),
    [anon_sym_thread_local] = ACTIONS(808),
    [anon_sym___thread] = ACTIONS(808),
    [anon_sym_const] = ACTIONS(826),
    [anon_sym_constexpr] = ACTIONS(826),
    [anon_sym_volatile] = ACTIONS(826),
    [anon_sym_restrict] = ACTIONS(826),
    [anon_sym___restrict__] = ACTIONS(826),
    [anon_sym__Atomic] = ACTIONS(826),
    [anon_sym__Noreturn] = ACTIONS(826),
    [anon_sym_noreturn] = ACTIONS(826),
    [anon_sym_alignas] = ACTIONS(829),
    [anon_sym__Alignas] = ACTIONS(829),
    [sym_primitive_type] = ACTIONS(832),
    [anon_sym_enum] = ACTIONS(835),
    [anon_sym_struct] = ACTIONS(838),
    [anon_sym_union] = ACTIONS(841),
    [anon_sym_if] = ACTIONS(955),
    [anon_sym_else] = ACTIONS(785),
    [anon_sym_switch] = ACTIONS(958),
    [anon_sym_case] = ACTIONS(785),
    [anon_sym_default] = ACTIONS(785),
    [anon_sym_while] = ACTIONS(961),
    [anon_sym_do] = ACTIONS(964),
    [anon_sym_for] = ACTIONS(967),
    [anon_sym_return] = ACTIONS(970),
    [anon_sym_break] = ACTIONS(973),
    [anon_sym_continue] = ACTIONS(976),
    [anon_sym_goto] = ACTIONS(979),
    [anon_sym___try] = ACTIONS(982),
    [anon_sym___leave] = ACTIONS(985),
    [anon_sym_DASH_DASH] = ACTIONS(877),
    [anon_sym_PLUS_PLUS] = ACTIONS(877),
    [anon_sym_sizeof] = ACTIONS(880),
    [anon_sym___alignof__] = ACTIONS(883),
    [anon_sym___alignof] = ACTIONS(883),
    [anon_sym__alignof] = ACTIONS(883),
    [anon_sym_alignof] = ACTIONS(883),
    [anon_sym__Alignof] = ACTIONS(883),
    [anon_sym_offsetof] = ACTIONS(886),
    [anon_sym__Generic] = ACTIONS(889),
    [anon_sym_asm] = ACTIONS(892),
    [anon_sym___asm__] = ACTIONS(892),
    [sym_number_literal] = ACTIONS(895),
    [anon_sym_L_SQUOTE] = ACTIONS(898),
    [anon_sym_u_SQUOTE] = ACTIONS(898),
    [anon_sym_U_SQUOTE] = ACTIONS(898),
    [anon_sym_u8_SQUOTE] = ACTIONS(898),
    [anon_sym_SQUOTE] = ACTIONS(898),
    [anon_sym_L_DQUOTE] = ACTIONS(901),
    [anon_sym_u_DQUOTE] = ACTIONS(901),
    [anon_sym_U_DQUOTE] = ACTIONS(901),
    [anon_sym_u8_DQUOTE] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(901),
    [sym_true] = ACTIONS(904),
    [sym_false] = ACTIONS(904),
    [anon_sym_NULL] = ACTIONS(907),
    [anon_sym_nullptr] = ACTIONS(907),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1107),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(58),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym_seh_try_statement] = STATE(58),
    [sym_seh_leave_statement] = STATE(58),
    [sym_expression] = STATE(1004),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1799),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(317),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(58),
    [sym_identifier] = ACTIONS(988),
    [aux_sym_preproc_include_token1] = ACTIONS(785),
    [aux_sym_preproc_def_token1] = ACTIONS(785),
    [aux_sym_preproc_if_token1] = ACTIONS(785),
    [aux_sym_preproc_if_token2] = ACTIONS(785),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(785),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(785),
    [sym_preproc_directive] = ACTIONS(785),
    [anon_sym_LPAREN2] = ACTIONS(787),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_TILDE] = ACTIONS(790),
    [anon_sym_DASH] = ACTIONS(793),
    [anon_sym_PLUS] = ACTIONS(793),
    [anon_sym_STAR] = ACTIONS(796),
    [anon_sym_AMP] = ACTIONS(796),
    [anon_sym_SEMI] = ACTIONS(991),
    [anon_sym___extension__] = ACTIONS(994),
    [anon_sym_typedef] = ACTIONS(997),
    [anon_sym_extern] = ACTIONS(808),
    [anon_sym___attribute__] = ACTIONS(811),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym___declspec] = ACTIONS(817),
    [anon_sym___cdecl] = ACTIONS(785),
    [anon_sym___clrcall] = ACTIONS(785),
    [anon_sym___stdcall] = ACTIONS(785),
    [anon_sym___fastcall] = ACTIONS(785),
    [anon_sym___thiscall] = ACTIONS(785),
    [anon_sym___vectorcall] = ACTIONS(785),
    [anon_sym_LBRACE] = ACTIONS(1000),
    [anon_sym_signed] = ACTIONS(823),
    [anon_sym_unsigned] = ACTIONS(823),
    [anon_sym_long] = ACTIONS(823),
    [anon_sym_short] = ACTIONS(823),
    [anon_sym_static] = ACTIONS(808),
    [anon_sym_auto] = ACTIONS(808),
    [anon_sym_register] = ACTIONS(808),
    [anon_sym_inline] = ACTIONS(808),
    [anon_sym___inline] = ACTIONS(808),
    [anon_sym___inline__] = ACTIONS(808),
    [anon_sym___forceinline] = ACTIONS(808),
    [anon_sym_thread_local] = ACTIONS(808),
    [anon_sym___thread] = ACTIONS(808),
    [anon_sym_const] = ACTIONS(826),
    [anon_sym_constexpr] = ACTIONS(826),
    [anon_sym_volatile] = ACTIONS(826),
    [anon_sym_restrict] = ACTIONS(826),
    [anon_sym___restrict__] = ACTIONS(826),
    [anon_sym__Atomic] = ACTIONS(826),
    [anon_sym__Noreturn] = ACTIONS(826),
    [anon_sym_noreturn] = ACTIONS(826),
    [anon_sym_alignas] = ACTIONS(829),
    [anon_sym__Alignas] = ACTIONS(829),
    [sym_primitive_type] = ACTIONS(832),
    [anon_sym_enum] = ACTIONS(835),
    [anon_sym_struct] = ACTIONS(838),
    [anon_sym_union] = ACTIONS(841),
    [anon_sym_if] = ACTIONS(1003),
    [anon_sym_else] = ACTIONS(785),
    [anon_sym_switch] = ACTIONS(1006),
    [anon_sym_case] = ACTIONS(785),
    [anon_sym_default] = ACTIONS(785),
    [anon_sym_while] = ACTIONS(1009),
    [anon_sym_do] = ACTIONS(1012),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_return] = ACTIONS(1018),
    [anon_sym_break] = ACTIONS(1021),
    [anon_sym_continue] = ACTIONS(1024),
    [anon_sym_goto] = ACTIONS(1027),
    [anon_sym___try] = ACTIONS(1030),
    [anon_sym___leave] = ACTIONS(1033),
    [anon_sym_DASH_DASH] = ACTIONS(877),
    [anon_sym_PLUS_PLUS] = ACTIONS(877),
    [anon_sym_sizeof] = ACTIONS(880),
    [anon_sym___alignof__] = ACTIONS(883),
    [anon_sym___alignof] = ACTIONS(883),
    [anon_sym__alignof] = ACTIONS(883),
    [anon_sym_alignof] = ACTIONS(883),
    [anon_sym__Alignof] = ACTIONS(883),
    [anon_sym_offsetof] = ACTIONS(886),
    [anon_sym__Generic] = ACTIONS(889),
    [anon_sym_asm] = ACTIONS(892),
    [anon_sym___asm__] = ACTIONS(892),
    [sym_number_literal] = ACTIONS(895),
    [anon_sym_L_SQUOTE] = ACTIONS(898),
    [anon_sym_u_SQUOTE] = ACTIONS(898),
    [anon_sym_U_SQUOTE] = ACTIONS(898),
    [anon_sym_u8_SQUOTE] = ACTIONS(898),
    [anon_sym_SQUOTE] = ACTIONS(898),
    [anon_sym_L_DQUOTE] = ACTIONS(901),
    [anon_sym_u_DQUOTE] = ACTIONS(901),
    [anon_sym_U_DQUOTE] = ACTIONS(901),
    [anon_sym_u8_DQUOTE] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(901),
    [sym_true] = ACTIONS(904),
    [sym_false] = ACTIONS(904),
    [anon_sym_NULL] = ACTIONS(907),
    [anon_sym_nullptr] = ACTIONS(907),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_declaration] = STATE(64),
    [sym_type_definition] = STATE(64),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1109),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(64),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(64),
    [sym_labeled_statement] = STATE(64),
    [sym_expression_statement] = STATE(64),
    [sym_if_statement] = STATE(64),
    [sym_switch_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_do_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_return_statement] = STATE(64),
    [sym_break_statement] = STATE(64),
    [sym_continue_statement] = STATE(64),
    [sym_goto_statement] = STATE(64),
    [sym_seh_try_statement] = STATE(64),
    [sym_seh_leave_statement] = STATE(64),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(64),
    [sym_identifier] = ACTIONS(922),
    [aux_sym_preproc_include_token1] = ACTIONS(912),
    [aux_sym_preproc_def_token1] = ACTIONS(912),
    [aux_sym_preproc_if_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(912),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(912),
    [sym_preproc_directive] = ACTIONS(912),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(912),
    [anon_sym___clrcall] = ACTIONS(912),
    [anon_sym___stdcall] = ACTIONS(912),
    [anon_sym___fastcall] = ACTIONS(912),
    [anon_sym___thiscall] = ACTIONS(912),
    [anon_sym___vectorcall] = ACTIONS(912),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(926),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_else] = ACTIONS(912),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(912),
    [anon_sym_default] = ACTIONS(912),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym_declaration] = STATE(54),
    [sym_type_definition] = STATE(54),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1115),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(54),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(54),
    [sym_labeled_statement] = STATE(54),
    [sym_expression_statement] = STATE(54),
    [sym_if_statement] = STATE(54),
    [sym_switch_statement] = STATE(54),
    [sym_while_statement] = STATE(54),
    [sym_do_statement] = STATE(54),
    [sym_for_statement] = STATE(54),
    [sym_return_statement] = STATE(54),
    [sym_break_statement] = STATE(54),
    [sym_continue_statement] = STATE(54),
    [sym_goto_statement] = STATE(54),
    [sym_seh_try_statement] = STATE(54),
    [sym_seh_leave_statement] = STATE(54),
    [sym_expression] = STATE(1019),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1826),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(347),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(54),
    [ts_builtin_sym_end] = ACTIONS(1036),
    [sym_identifier] = ACTIONS(928),
    [aux_sym_preproc_include_token1] = ACTIONS(916),
    [aux_sym_preproc_def_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(916),
    [sym_preproc_directive] = ACTIONS(916),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(930),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(916),
    [anon_sym___clrcall] = ACTIONS(916),
    [anon_sym___stdcall] = ACTIONS(916),
    [anon_sym___fastcall] = ACTIONS(916),
    [anon_sym___thiscall] = ACTIONS(916),
    [anon_sym___vectorcall] = ACTIONS(916),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_else] = ACTIONS(916),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(916),
    [anon_sym_default] = ACTIONS(916),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_do] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_continue] = ACTIONS(77),
    [anon_sym_goto] = ACTIONS(79),
    [anon_sym___try] = ACTIONS(932),
    [anon_sym___leave] = ACTIONS(934),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym_declaration] = STATE(56),
    [sym_type_definition] = STATE(56),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1115),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(56),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(56),
    [sym_labeled_statement] = STATE(56),
    [sym_expression_statement] = STATE(56),
    [sym_if_statement] = STATE(56),
    [sym_switch_statement] = STATE(56),
    [sym_while_statement] = STATE(56),
    [sym_do_statement] = STATE(56),
    [sym_for_statement] = STATE(56),
    [sym_return_statement] = STATE(56),
    [sym_break_statement] = STATE(56),
    [sym_continue_statement] = STATE(56),
    [sym_goto_statement] = STATE(56),
    [sym_seh_try_statement] = STATE(56),
    [sym_seh_leave_statement] = STATE(56),
    [sym_expression] = STATE(1019),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1826),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(347),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(56),
    [ts_builtin_sym_end] = ACTIONS(924),
    [sym_identifier] = ACTIONS(928),
    [aux_sym_preproc_include_token1] = ACTIONS(914),
    [aux_sym_preproc_def_token1] = ACTIONS(914),
    [aux_sym_preproc_if_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(914),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(914),
    [sym_preproc_directive] = ACTIONS(914),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(930),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(914),
    [anon_sym___clrcall] = ACTIONS(914),
    [anon_sym___stdcall] = ACTIONS(914),
    [anon_sym___fastcall] = ACTIONS(914),
    [anon_sym___thiscall] = ACTIONS(914),
    [anon_sym___vectorcall] = ACTIONS(914),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_else] = ACTIONS(914),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(914),
    [anon_sym_default] = ACTIONS(914),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_do] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_continue] = ACTIONS(77),
    [anon_sym_goto] = ACTIONS(79),
    [anon_sym___try] = ACTIONS(932),
    [anon_sym___leave] = ACTIONS(934),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym_declaration] = STATE(59),
    [sym_type_definition] = STATE(59),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1109),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(59),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(59),
    [sym_labeled_statement] = STATE(59),
    [sym_expression_statement] = STATE(59),
    [sym_if_statement] = STATE(59),
    [sym_switch_statement] = STATE(59),
    [sym_while_statement] = STATE(59),
    [sym_do_statement] = STATE(59),
    [sym_for_statement] = STATE(59),
    [sym_return_statement] = STATE(59),
    [sym_break_statement] = STATE(59),
    [sym_continue_statement] = STATE(59),
    [sym_goto_statement] = STATE(59),
    [sym_seh_try_statement] = STATE(59),
    [sym_seh_leave_statement] = STATE(59),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(59),
    [sym_identifier] = ACTIONS(922),
    [aux_sym_preproc_include_token1] = ACTIONS(916),
    [aux_sym_preproc_def_token1] = ACTIONS(916),
    [aux_sym_preproc_if_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(916),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(916),
    [sym_preproc_directive] = ACTIONS(916),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(916),
    [anon_sym___clrcall] = ACTIONS(916),
    [anon_sym___stdcall] = ACTIONS(916),
    [anon_sym___fastcall] = ACTIONS(916),
    [anon_sym___thiscall] = ACTIONS(916),
    [anon_sym___vectorcall] = ACTIONS(916),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(1036),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_else] = ACTIONS(916),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(916),
    [anon_sym_default] = ACTIONS(916),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym_declaration] = STATE(64),
    [sym_type_definition] = STATE(64),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1109),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(64),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(64),
    [sym_labeled_statement] = STATE(64),
    [sym_expression_statement] = STATE(64),
    [sym_if_statement] = STATE(64),
    [sym_switch_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_do_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_return_statement] = STATE(64),
    [sym_break_statement] = STATE(64),
    [sym_continue_statement] = STATE(64),
    [sym_goto_statement] = STATE(64),
    [sym_seh_try_statement] = STATE(64),
    [sym_seh_leave_statement] = STATE(64),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(64),
    [sym_identifier] = ACTIONS(922),
    [aux_sym_preproc_include_token1] = ACTIONS(918),
    [aux_sym_preproc_def_token1] = ACTIONS(918),
    [aux_sym_preproc_if_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(918),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(918),
    [sym_preproc_directive] = ACTIONS(918),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(370),
    [anon_sym_typedef] = ACTIONS(372),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym___cdecl] = ACTIONS(918),
    [anon_sym___clrcall] = ACTIONS(918),
    [anon_sym___stdcall] = ACTIONS(918),
    [anon_sym___fastcall] = ACTIONS(918),
    [anon_sym___thiscall] = ACTIONS(918),
    [anon_sym___vectorcall] = ACTIONS(918),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(936),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_else] = ACTIONS(918),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(918),
    [anon_sym_default] = ACTIONS(918),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_goto] = ACTIONS(400),
    [anon_sym___try] = ACTIONS(402),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym_declaration] = STATE(64),
    [sym_type_definition] = STATE(64),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1109),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(64),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(64),
    [sym_labeled_statement] = STATE(64),
    [sym_expression_statement] = STATE(64),
    [sym_if_statement] = STATE(64),
    [sym_switch_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_do_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_return_statement] = STATE(64),
    [sym_break_statement] = STATE(64),
    [sym_continue_statement] = STATE(64),
    [sym_goto_statement] = STATE(64),
    [sym_seh_try_statement] = STATE(64),
    [sym_seh_leave_statement] = STATE(64),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(352),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(64),
    [sym_identifier] = ACTIONS(1038),
    [aux_sym_preproc_include_token1] = ACTIONS(785),
    [aux_sym_preproc_def_token1] = ACTIONS(785),
    [aux_sym_preproc_if_token1] = ACTIONS(785),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(785),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(785),
    [sym_preproc_directive] = ACTIONS(785),
    [anon_sym_LPAREN2] = ACTIONS(787),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_TILDE] = ACTIONS(790),
    [anon_sym_DASH] = ACTIONS(793),
    [anon_sym_PLUS] = ACTIONS(793),
    [anon_sym_STAR] = ACTIONS(796),
    [anon_sym_AMP] = ACTIONS(796),
    [anon_sym_SEMI] = ACTIONS(1041),
    [anon_sym___extension__] = ACTIONS(1044),
    [anon_sym_typedef] = ACTIONS(1047),
    [anon_sym_extern] = ACTIONS(808),
    [anon_sym___attribute__] = ACTIONS(811),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym___declspec] = ACTIONS(817),
    [anon_sym___cdecl] = ACTIONS(785),
    [anon_sym___clrcall] = ACTIONS(785),
    [anon_sym___stdcall] = ACTIONS(785),
    [anon_sym___fastcall] = ACTIONS(785),
    [anon_sym___thiscall] = ACTIONS(785),
    [anon_sym___vectorcall] = ACTIONS(785),
    [anon_sym_LBRACE] = ACTIONS(1050),
    [anon_sym_RBRACE] = ACTIONS(938),
    [anon_sym_signed] = ACTIONS(823),
    [anon_sym_unsigned] = ACTIONS(823),
    [anon_sym_long] = ACTIONS(823),
    [anon_sym_short] = ACTIONS(823),
    [anon_sym_static] = ACTIONS(808),
    [anon_sym_auto] = ACTIONS(808),
    [anon_sym_register] = ACTIONS(808),
    [anon_sym_inline] = ACTIONS(808),
    [anon_sym___inline] = ACTIONS(808),
    [anon_sym___inline__] = ACTIONS(808),
    [anon_sym___forceinline] = ACTIONS(808),
    [anon_sym_thread_local] = ACTIONS(808),
    [anon_sym___thread] = ACTIONS(808),
    [anon_sym_const] = ACTIONS(826),
    [anon_sym_constexpr] = ACTIONS(826),
    [anon_sym_volatile] = ACTIONS(826),
    [anon_sym_restrict] = ACTIONS(826),
    [anon_sym___restrict__] = ACTIONS(826),
    [anon_sym__Atomic] = ACTIONS(826),
    [anon_sym__Noreturn] = ACTIONS(826),
    [anon_sym_noreturn] = ACTIONS(826),
    [anon_sym_alignas] = ACTIONS(829),
    [anon_sym__Alignas] = ACTIONS(829),
    [sym_primitive_type] = ACTIONS(832),
    [anon_sym_enum] = ACTIONS(835),
    [anon_sym_struct] = ACTIONS(838),
    [anon_sym_union] = ACTIONS(841),
    [anon_sym_if] = ACTIONS(1053),
    [anon_sym_else] = ACTIONS(785),
    [anon_sym_switch] = ACTIONS(1056),
    [anon_sym_case] = ACTIONS(785),
    [anon_sym_default] = ACTIONS(785),
    [anon_sym_while] = ACTIONS(1059),
    [anon_sym_do] = ACTIONS(1062),
    [anon_sym_for] = ACTIONS(1065),
    [anon_sym_return] = ACTIONS(1068),
    [anon_sym_break] = ACTIONS(1071),
    [anon_sym_continue] = ACTIONS(1074),
    [anon_sym_goto] = ACTIONS(1077),
    [anon_sym___try] = ACTIONS(1080),
    [anon_sym___leave] = ACTIONS(1083),
    [anon_sym_DASH_DASH] = ACTIONS(877),
    [anon_sym_PLUS_PLUS] = ACTIONS(877),
    [anon_sym_sizeof] = ACTIONS(880),
    [anon_sym___alignof__] = ACTIONS(883),
    [anon_sym___alignof] = ACTIONS(883),
    [anon_sym__alignof] = ACTIONS(883),
    [anon_sym_alignof] = ACTIONS(883),
    [anon_sym__Alignof] = ACTIONS(883),
    [anon_sym_offsetof] = ACTIONS(886),
    [anon_sym__Generic] = ACTIONS(889),
    [anon_sym_asm] = ACTIONS(892),
    [anon_sym___asm__] = ACTIONS(892),
    [sym_number_literal] = ACTIONS(895),
    [anon_sym_L_SQUOTE] = ACTIONS(898),
    [anon_sym_u_SQUOTE] = ACTIONS(898),
    [anon_sym_U_SQUOTE] = ACTIONS(898),
    [anon_sym_u8_SQUOTE] = ACTIONS(898),
    [anon_sym_SQUOTE] = ACTIONS(898),
    [anon_sym_L_DQUOTE] = ACTIONS(901),
    [anon_sym_u_DQUOTE] = ACTIONS(901),
    [anon_sym_U_DQUOTE] = ACTIONS(901),
    [anon_sym_u8_DQUOTE] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(901),
    [sym_true] = ACTIONS(904),
    [sym_false] = ACTIONS(904),
    [anon_sym_NULL] = ACTIONS(907),
    [anon_sym_nullptr] = ACTIONS(907),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym_declaration] = STATE(69),
    [sym_type_definition] = STATE(69),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1115),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(69),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(69),
    [sym_labeled_statement] = STATE(69),
    [sym_expression_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_return_statement] = STATE(69),
    [sym_break_statement] = STATE(69),
    [sym_continue_statement] = STATE(69),
    [sym_goto_statement] = STATE(69),
    [sym_seh_try_statement] = STATE(69),
    [sym_seh_leave_statement] = STATE(69),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(1086),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(1088),
    [anon_sym_else] = ACTIONS(918),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(1090),
    [anon_sym_do] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(1092),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_continue] = ACTIONS(77),
    [anon_sym_goto] = ACTIONS(79),
    [anon_sym___try] = ACTIONS(1094),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym_declaration] = STATE(67),
    [sym_type_definition] = STATE(67),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1115),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(67),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(67),
    [sym_labeled_statement] = STATE(67),
    [sym_expression_statement] = STATE(67),
    [sym_if_statement] = STATE(67),
    [sym_switch_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_do_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_return_statement] = STATE(67),
    [sym_break_statement] = STATE(67),
    [sym_continue_statement] = STATE(67),
    [sym_goto_statement] = STATE(67),
    [sym_seh_try_statement] = STATE(67),
    [sym_seh_leave_statement] = STATE(67),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(67),
    [sym_identifier] = ACTIONS(1086),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(1088),
    [anon_sym_else] = ACTIONS(916),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(1090),
    [anon_sym_do] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(1092),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_continue] = ACTIONS(77),
    [anon_sym_goto] = ACTIONS(79),
    [anon_sym___try] = ACTIONS(1094),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_declaration] = STATE(69),
    [sym_type_definition] = STATE(69),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1115),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(69),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(69),
    [sym_labeled_statement] = STATE(69),
    [sym_expression_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_return_statement] = STATE(69),
    [sym_break_statement] = STATE(69),
    [sym_continue_statement] = STATE(69),
    [sym_goto_statement] = STATE(69),
    [sym_seh_try_statement] = STATE(69),
    [sym_seh_leave_statement] = STATE(69),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(1086),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(1088),
    [anon_sym_else] = ACTIONS(912),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(1090),
    [anon_sym_do] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(1092),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_continue] = ACTIONS(77),
    [anon_sym_goto] = ACTIONS(79),
    [anon_sym___try] = ACTIONS(1094),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym_declaration] = STATE(65),
    [sym_type_definition] = STATE(65),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1115),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(65),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(65),
    [sym_labeled_statement] = STATE(65),
    [sym_expression_statement] = STATE(65),
    [sym_if_statement] = STATE(65),
    [sym_switch_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_do_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_return_statement] = STATE(65),
    [sym_break_statement] = STATE(65),
    [sym_continue_statement] = STATE(65),
    [sym_goto_statement] = STATE(65),
    [sym_seh_try_statement] = STATE(65),
    [sym_seh_leave_statement] = STATE(65),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(65),
    [sym_identifier] = ACTIONS(1086),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym___extension__] = ACTIONS(27),
    [anon_sym_typedef] = ACTIONS(29),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(35),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(1088),
    [anon_sym_else] = ACTIONS(914),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(1090),
    [anon_sym_do] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(1092),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_continue] = ACTIONS(77),
    [anon_sym_goto] = ACTIONS(79),
    [anon_sym___try] = ACTIONS(1094),
    [anon_sym___leave] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_declaration] = STATE(69),
    [sym_type_definition] = STATE(69),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1115),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(405),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_compound_statement] = STATE(69),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym_attributed_statement] = STATE(69),
    [sym_labeled_statement] = STATE(69),
    [sym_expression_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_return_statement] = STATE(69),
    [sym_break_statement] = STATE(69),
    [sym_continue_statement] = STATE(69),
    [sym_goto_statement] = STATE(69),
    [sym_seh_try_statement] = STATE(69),
    [sym_seh_leave_statement] = STATE(69),
    [sym_expression] = STATE(1014),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1860),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_attributed_declarator_repeat1] = STATE(314),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [aux_sym_case_statement_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(1096),
    [anon_sym_LPAREN2] = ACTIONS(787),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_TILDE] = ACTIONS(790),
    [anon_sym_DASH] = ACTIONS(793),
    [anon_sym_PLUS] = ACTIONS(793),
    [anon_sym_STAR] = ACTIONS(796),
    [anon_sym_AMP] = ACTIONS(796),
    [anon_sym_SEMI] = ACTIONS(1041),
    [anon_sym___extension__] = ACTIONS(946),
    [anon_sym_typedef] = ACTIONS(949),
    [anon_sym_extern] = ACTIONS(808),
    [anon_sym___attribute__] = ACTIONS(811),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym___declspec] = ACTIONS(817),
    [anon_sym_LBRACE] = ACTIONS(952),
    [anon_sym_signed] = ACTIONS(823),
    [anon_sym_unsigned] = ACTIONS(823),
    [anon_sym_long] = ACTIONS(823),
    [anon_sym_short] = ACTIONS(823),
    [anon_sym_static] = ACTIONS(808),
    [anon_sym_auto] = ACTIONS(808),
    [anon_sym_register] = ACTIONS(808),
    [anon_sym_inline] = ACTIONS(808),
    [anon_sym___inline] = ACTIONS(808),
    [anon_sym___inline__] = ACTIONS(808),
    [anon_sym___forceinline] = ACTIONS(808),
    [anon_sym_thread_local] = ACTIONS(808),
    [anon_sym___thread] = ACTIONS(808),
    [anon_sym_const] = ACTIONS(826),
    [anon_sym_constexpr] = ACTIONS(826),
    [anon_sym_volatile] = ACTIONS(826),
    [anon_sym_restrict] = ACTIONS(826),
    [anon_sym___restrict__] = ACTIONS(826),
    [anon_sym__Atomic] = ACTIONS(826),
    [anon_sym__Noreturn] = ACTIONS(826),
    [anon_sym_noreturn] = ACTIONS(826),
    [anon_sym_alignas] = ACTIONS(829),
    [anon_sym__Alignas] = ACTIONS(829),
    [sym_primitive_type] = ACTIONS(832),
    [anon_sym_enum] = ACTIONS(835),
    [anon_sym_struct] = ACTIONS(838),
    [anon_sym_union] = ACTIONS(841),
    [anon_sym_if] = ACTIONS(1099),
    [anon_sym_else] = ACTIONS(785),
    [anon_sym_switch] = ACTIONS(958),
    [anon_sym_while] = ACTIONS(1102),
    [anon_sym_do] = ACTIONS(964),
    [anon_sym_for] = ACTIONS(1105),
    [anon_sym_return] = ACTIONS(970),
    [anon_sym_break] = ACTIONS(973),
    [anon_sym_continue] = ACTIONS(976),
    [anon_sym_goto] = ACTIONS(979),
    [anon_sym___try] = ACTIONS(1108),
    [anon_sym___leave] = ACTIONS(1083),
    [anon_sym_DASH_DASH] = ACTIONS(877),
    [anon_sym_PLUS_PLUS] = ACTIONS(877),
    [anon_sym_sizeof] = ACTIONS(880),
    [anon_sym___alignof__] = ACTIONS(883),
    [anon_sym___alignof] = ACTIONS(883),
    [anon_sym__alignof] = ACTIONS(883),
    [anon_sym_alignof] = ACTIONS(883),
    [anon_sym__Alignof] = ACTIONS(883),
    [anon_sym_offsetof] = ACTIONS(886),
    [anon_sym__Generic] = ACTIONS(889),
    [anon_sym_asm] = ACTIONS(892),
    [anon_sym___asm__] = ACTIONS(892),
    [sym_number_literal] = ACTIONS(895),
    [anon_sym_L_SQUOTE] = ACTIONS(898),
    [anon_sym_u_SQUOTE] = ACTIONS(898),
    [anon_sym_U_SQUOTE] = ACTIONS(898),
    [anon_sym_u8_SQUOTE] = ACTIONS(898),
    [anon_sym_SQUOTE] = ACTIONS(898),
    [anon_sym_L_DQUOTE] = ACTIONS(901),
    [anon_sym_u_DQUOTE] = ACTIONS(901),
    [anon_sym_U_DQUOTE] = ACTIONS(901),
    [anon_sym_u8_DQUOTE] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(901),
    [sym_true] = ACTIONS(904),
    [sym_false] = ACTIONS(904),
    [anon_sym_NULL] = ACTIONS(907),
    [anon_sym_nullptr] = ACTIONS(907),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_declaration] = STATE(456),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1111),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(698),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym__for_statement_body] = STATE(1845),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1969),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(1111),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1113),
    [anon_sym___extension__] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1115),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_declaration] = STATE(456),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1111),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(698),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym__for_statement_body] = STATE(1920),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1969),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(1111),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1113),
    [anon_sym___extension__] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1115),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym_declaration] = STATE(456),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1111),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(698),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym__for_statement_body] = STATE(1966),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1969),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(1111),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1113),
    [anon_sym___extension__] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1115),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym_declaration] = STATE(456),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1111),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(698),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym__for_statement_body] = STATE(1899),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1969),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(1111),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1113),
    [anon_sym___extension__] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1115),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [sym_declaration] = STATE(456),
    [sym__declaration_modifiers] = STATE(698),
    [sym__declaration_specifiers] = STATE(1111),
    [sym_attribute_specifier] = STATE(698),
    [sym_attribute_declaration] = STATE(698),
    [sym_ms_declspec_modifier] = STATE(698),
    [sym_storage_class_specifier] = STATE(698),
    [sym_type_qualifier] = STATE(698),
    [sym_alignas_qualifier] = STATE(708),
    [sym_type_specifier] = STATE(716),
    [sym_sized_type_specifier] = STATE(771),
    [sym_enum_specifier] = STATE(771),
    [sym_struct_specifier] = STATE(771),
    [sym_union_specifier] = STATE(771),
    [sym__for_statement_body] = STATE(1736),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(672),
    [sym_comma_expression] = STATE(1969),
    [sym_conditional_expression] = STATE(672),
    [sym_assignment_expression] = STATE(672),
    [sym_pointer_expression] = STATE(820),
    [sym_unary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_cast_expression] = STATE(672),
    [sym_sizeof_expression] = STATE(672),
    [sym_alignof_expression] = STATE(672),
    [sym_offsetof_expression] = STATE(672),
    [sym_generic_expression] = STATE(672),
    [sym_subscript_expression] = STATE(820),
    [sym_call_expression] = STATE(820),
    [sym_gnu_asm_expression] = STATE(672),
    [sym_field_expression] = STATE(820),
    [sym_compound_literal_expression] = STATE(672),
    [sym_parenthesized_expression] = STATE(820),
    [sym_char_literal] = STATE(672),
    [sym_concatenated_string] = STATE(672),
    [sym_string_literal] = STATE(659),
    [sym_null] = STATE(672),
    [sym_macro_type_specifier] = STATE(771),
    [aux_sym__declaration_specifiers_repeat1] = STATE(698),
    [aux_sym_sized_type_specifier_repeat1] = STATE(773),
    [sym_identifier] = ACTIONS(1111),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1113),
    [anon_sym___extension__] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(45),
    [anon_sym___attribute__] = ACTIONS(33),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1115),
    [anon_sym___declspec] = ACTIONS(37),
    [anon_sym_signed] = ACTIONS(43),
    [anon_sym_unsigned] = ACTIONS(43),
    [anon_sym_long] = ACTIONS(43),
    [anon_sym_short] = ACTIONS(43),
    [anon_sym_static] = ACTIONS(45),
    [anon_sym_auto] = ACTIONS(45),
    [anon_sym_register] = ACTIONS(45),
    [anon_sym_inline] = ACTIONS(45),
    [anon_sym___inline] = ACTIONS(45),
    [anon_sym___inline__] = ACTIONS(45),
    [anon_sym___forceinline] = ACTIONS(45),
    [anon_sym_thread_local] = ACTIONS(45),
    [anon_sym___thread] = ACTIONS(45),
    [anon_sym_const] = ACTIONS(47),
    [anon_sym_constexpr] = ACTIONS(47),
    [anon_sym_volatile] = ACTIONS(47),
    [anon_sym_restrict] = ACTIONS(47),
    [anon_sym___restrict__] = ACTIONS(47),
    [anon_sym__Atomic] = ACTIONS(47),
    [anon_sym__Noreturn] = ACTIONS(47),
    [anon_sym_noreturn] = ACTIONS(47),
    [anon_sym_alignas] = ACTIONS(49),
    [anon_sym__Alignas] = ACTIONS(49),
    [sym_primitive_type] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_struct] = ACTIONS(55),
    [anon_sym_union] = ACTIONS(57),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_sizeof] = ACTIONS(83),
    [anon_sym___alignof__] = ACTIONS(85),
    [anon_sym___alignof] = ACTIONS(85),
    [anon_sym__alignof] = ACTIONS(85),
    [anon_sym_alignof] = ACTIONS(85),
    [anon_sym__Alignof] = ACTIONS(85),
    [anon_sym_offsetof] = ACTIONS(87),
    [anon_sym__Generic] = ACTIONS(89),
    [anon_sym_asm] = ACTIONS(91),
    [anon_sym___asm__] = ACTIONS(91),
    [sym_number_literal] = ACTIONS(159),
    [anon_sym_L_SQUOTE] = ACTIONS(95),
    [anon_sym_u_SQUOTE] = ACTIONS(95),
    [anon_sym_U_SQUOTE] = ACTIONS(95),
    [anon_sym_u8_SQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(97),
    [anon_sym_u_DQUOTE] = ACTIONS(97),
    [anon_sym_U_DQUOTE] = ACTIONS(97),
    [anon_sym_u8_DQUOTE] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(97),
    [sym_true] = ACTIONS(161),
    [sym_false] = ACTIONS(161),
    [anon_sym_NULL] = ACTIONS(101),
    [anon_sym_nullptr] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [sym_else_clause] = STATE(103),
    [sym_identifier] = ACTIONS(1117),
    [aux_sym_preproc_include_token1] = ACTIONS(1117),
    [aux_sym_preproc_def_token1] = ACTIONS(1117),
    [aux_sym_preproc_if_token1] = ACTIONS(1117),
    [aux_sym_preproc_if_token2] = ACTIONS(1117),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1117),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1117),
    [aux_sym_preproc_else_token1] = ACTIONS(1117),
    [aux_sym_preproc_elif_token1] = ACTIONS(1117),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1117),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1117),
    [sym_preproc_directive] = ACTIONS(1117),
    [anon_sym_LPAREN2] = ACTIONS(1119),
    [anon_sym_BANG] = ACTIONS(1119),
    [anon_sym_TILDE] = ACTIONS(1119),
    [anon_sym_DASH] = ACTIONS(1117),
    [anon_sym_PLUS] = ACTIONS(1117),
    [anon_sym_STAR] = ACTIONS(1119),
    [anon_sym_AMP] = ACTIONS(1119),
    [anon_sym_SEMI] = ACTIONS(1119),
    [anon_sym___extension__] = ACTIONS(1117),
    [anon_sym_typedef] = ACTIONS(1117),
    [anon_sym_extern] = ACTIONS(1117),
    [anon_sym___attribute__] = ACTIONS(1117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1119),
    [anon_sym___declspec] = ACTIONS(1117),
    [anon_sym___cdecl] = ACTIONS(1117),
    [anon_sym___clrcall] = ACTIONS(1117),
    [anon_sym___stdcall] = ACTIONS(1117),
    [anon_sym___fastcall] = ACTIONS(1117),
    [anon_sym___thiscall] = ACTIONS(1117),
    [anon_sym___vectorcall] = ACTIONS(1117),
    [anon_sym_LBRACE] = ACTIONS(1119),
    [anon_sym_signed] = ACTIONS(1117),
    [anon_sym_unsigned] = ACTIONS(1117),
    [anon_sym_long] = ACTIONS(1117),
    [anon_sym_short] = ACTIONS(1117),
    [anon_sym_static] = ACTIONS(1117),
    [anon_sym_auto] = ACTIONS(1117),
    [anon_sym_register] = ACTIONS(1117),
    [anon_sym_inline] = ACTIONS(1117),
    [anon_sym___inline] = ACTIONS(1117),
    [anon_sym___inline__] = ACTIONS(1117),
    [anon_sym___forceinline] = ACTIONS(1117),
    [anon_sym_thread_local] = ACTIONS(1117),
    [anon_sym___thread] = ACTIONS(1117),
    [anon_sym_const] = ACTIONS(1117),
    [anon_sym_constexpr] = ACTIONS(1117),
    [anon_sym_volatile] = ACTIONS(1117),
    [anon_sym_restrict] = ACTIONS(1117),
    [anon_sym___restrict__] = ACTIONS(1117),
    [anon_sym__Atomic] = ACTIONS(1117),
    [anon_sym__Noreturn] = ACTIONS(1117),
    [anon_sym_noreturn] = ACTIONS(1117),
    [anon_sym_alignas] = ACTIONS(1117),
    [anon_sym__Alignas] = ACTIONS(1117),
    [sym_primitive_type] = ACTIONS(1117),
    [anon_sym_enum] = ACTIONS(1117),
    [anon_sym_struct] = ACTIONS(1117),
    [anon_sym_union] = ACTIONS(1117),
    [anon_sym_if] = ACTIONS(1117),
    [anon_sym_else] = ACTIONS(1121),
    [anon_sym_switch] = ACTIONS(1117),
    [anon_sym_case] = ACTIONS(1117),
    [anon_sym_default] = ACTIONS(1117),
    [anon_sym_while] = ACTIONS(1117),
    [anon_sym_do] = ACTIONS(1117),
    [anon_sym_for] = ACTIONS(1117),
    [anon_sym_return] = ACTIONS(1117),
    [anon_sym_break] = ACTIONS(1117),
    [anon_sym_continue] = ACTIONS(1117),
    [anon_sym_goto] = ACTIONS(1117),
    [anon_sym___try] = ACTIONS(1117),
    [anon_sym___leave] = ACTIONS(1117),
    [anon_sym_DASH_DASH] = ACTIONS(1119),
    [anon_sym_PLUS_PLUS] = ACTIONS(1119),
    [anon_sym_sizeof] = ACTIONS(1117),
    [anon_sym___alignof__] = ACTIONS(1117),
    [anon_sym___alignof] = ACTIONS(1117),
    [anon_sym__alignof] = ACTIONS(1117),
    [anon_sym_alignof] = ACTIONS(1117),
    [anon_sym__Alignof] = ACTIONS(1117),
    [anon_sym_offsetof] = ACTIONS(1117),
    [anon_sym__Generic] = ACTIONS(1117),
    [anon_sym_asm] = ACTIONS(1117),
    [anon_sym___asm__] = ACTIONS(1117),
    [sym_number_literal] = ACTIONS(1119),
    [anon_sym_L_SQUOTE] = ACTIONS(1119),
    [anon_sym_u_SQUOTE] = ACTIONS(1119),
    [anon_sym_U_SQUOTE] = ACTIONS(1119),
    [anon_sym_u8_SQUOTE] = ACTIONS(1119),
    [anon_sym_SQUOTE] = ACTIONS(1119),
    [anon_sym_L_DQUOTE] = ACTIONS(1119),
    [anon_sym_u_DQUOTE] = ACTIONS(1119),
    [anon_sym_U_DQUOTE] = ACTIONS(1119),
    [anon_sym_u8_DQUOTE] = ACTIONS(1119),
    [anon_sym_DQUOTE] = ACTIONS(1119),
    [sym_true] = ACTIONS(1117),
    [sym_false] = ACTIONS(1117),
    [anon_sym_NULL] = ACTIONS(1117),
    [anon_sym_nullptr] = ACTIONS(1117),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym_identifier] = ACTIONS(1123),
    [aux_sym_preproc_include_token1] = ACTIONS(1123),
    [aux_sym_preproc_def_token1] = ACTIONS(1123),
    [aux_sym_preproc_if_token1] = ACTIONS(1123),
    [aux_sym_preproc_if_token2] = ACTIONS(1123),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1123),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1123),
    [aux_sym_preproc_else_token1] = ACTIONS(1123),
    [aux_sym_preproc_elif_token1] = ACTIONS(1123),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1123),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1123),
    [sym_preproc_directive] = ACTIONS(1123),
    [anon_sym_LPAREN2] = ACTIONS(1125),
    [anon_sym_BANG] = ACTIONS(1125),
    [anon_sym_TILDE] = ACTIONS(1125),
    [anon_sym_DASH] = ACTIONS(1123),
    [anon_sym_PLUS] = ACTIONS(1123),
    [anon_sym_STAR] = ACTIONS(1125),
    [anon_sym_AMP] = ACTIONS(1125),
    [anon_sym_SEMI] = ACTIONS(1125),
    [anon_sym___extension__] = ACTIONS(1123),
    [anon_sym_typedef] = ACTIONS(1123),
    [anon_sym_extern] = ACTIONS(1123),
    [anon_sym___attribute__] = ACTIONS(1123),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1125),
    [anon_sym___declspec] = ACTIONS(1123),
    [anon_sym___cdecl] = ACTIONS(1123),
    [anon_sym___clrcall] = ACTIONS(1123),
    [anon_sym___stdcall] = ACTIONS(1123),
    [anon_sym___fastcall] = ACTIONS(1123),
    [anon_sym___thiscall] = ACTIONS(1123),
    [anon_sym___vectorcall] = ACTIONS(1123),
    [anon_sym_LBRACE] = ACTIONS(1125),
    [anon_sym_signed] = ACTIONS(1123),
    [anon_sym_unsigned] = ACTIONS(1123),
    [anon_sym_long] = ACTIONS(1123),
    [anon_sym_short] = ACTIONS(1123),
    [anon_sym_static] = ACTIONS(1123),
    [anon_sym_auto] = ACTIONS(1123),
    [anon_sym_register] = ACTIONS(1123),
    [anon_sym_inline] = ACTIONS(1123),
    [anon_sym___inline] = ACTIONS(1123),
    [anon_sym___inline__] = ACTIONS(1123),
    [anon_sym___forceinline] = ACTIONS(1123),
    [anon_sym_thread_local] = ACTIONS(1123),
    [anon_sym___thread] = ACTIONS(1123),
    [anon_sym_const] = ACTIONS(1123),
    [anon_sym_constexpr] = ACTIONS(1123),
    [anon_sym_volatile] = ACTIONS(1123),
    [anon_sym_restrict] = ACTIONS(1123),
    [anon_sym___restrict__] = ACTIONS(1123),
    [anon_sym__Atomic] = ACTIONS(1123),
    [anon_sym__Noreturn] = ACTIONS(1123),
    [anon_sym_noreturn] = ACTIONS(1123),
    [anon_sym_alignas] = ACTIONS(1123),
    [anon_sym__Alignas] = ACTIONS(1123),
    [sym_primitive_type] = ACTIONS(1123),
    [anon_sym_enum] = ACTIONS(1123),
    [anon_sym_struct] = ACTIONS(1123),
    [anon_sym_union] = ACTIONS(1123),
    [anon_sym_if] = ACTIONS(1123),
    [anon_sym_else] = ACTIONS(1123),
    [anon_sym_switch] = ACTIONS(1123),
    [anon_sym_case] = ACTIONS(1123),
    [anon_sym_default] = ACTIONS(1123),
    [anon_sym_while] = ACTIONS(1123),
    [anon_sym_do] = ACTIONS(1123),
    [anon_sym_for] = ACTIONS(1123),
    [anon_sym_return] = ACTIONS(1123),
    [anon_sym_break] = ACTIONS(1123),
    [anon_sym_continue] = ACTIONS(1123),
    [anon_sym_goto] = ACTIONS(1123),
    [anon_sym___try] = ACTIONS(1123),
    [anon_sym___leave] = ACTIONS(1123),
    [anon_sym_DASH_DASH] = ACTIONS(1125),
    [anon_sym_PLUS_PLUS] = ACTIONS(1125),
    [anon_sym_sizeof] = ACTIONS(1123),
    [anon_sym___alignof__] = ACTIONS(1123),
    [anon_sym___alignof] = ACTIONS(1123),
    [anon_sym__alignof] = ACTIONS(1123),
    [anon_sym_alignof] = ACTIONS(1123),
    [anon_sym__Alignof] = ACTIONS(1123),
    [anon_sym_offsetof] = ACTIONS(1123),
    [anon_sym__Generic] = ACTIONS(1123),
    [anon_sym_asm] = ACTIONS(1123),
    [anon_sym___asm__] = ACTIONS(1123),
    [sym_number_literal] = ACTIONS(1125),
    [anon_sym_L_SQUOTE] = ACTIONS(1125),
    [anon_sym_u_SQUOTE] = ACTIONS(1125),
    [anon_sym_U_SQUOTE] = ACTIONS(1125),
    [anon_sym_u8_SQUOTE] = ACTIONS(1125),
    [anon_sym_SQUOTE] = ACTIONS(1125),
    [anon_sym_L_DQUOTE] = ACTIONS(1125),
    [anon_sym_u_DQUOTE] = ACTIONS(1125),
    [anon_sym_U_DQUOTE] = ACTIONS(1125),
    [anon_sym_u8_DQUOTE] = ACTIONS(1125),
    [anon_sym_DQUOTE] = ACTIONS(1125),
    [sym_true] = ACTIONS(1123),
    [sym_false] = ACTIONS(1123),
    [anon_sym_NULL] = ACTIONS(1123),
    [anon_sym_nullptr] = ACTIONS(1123),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [ts_builtin_sym_end] = ACTIONS(1127),
    [sym_identifier] = ACTIONS(1129),
    [aux_sym_preproc_include_token1] = ACTIONS(1129),
    [aux_sym_preproc_def_token1] = ACTIONS(1129),
    [anon_sym_COMMA] = ACTIONS(1127),
    [anon_sym_RPAREN] = ACTIONS(1127),
    [aux_sym_preproc_if_token1] = ACTIONS(1129),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1129),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1129),
    [sym_preproc_directive] = ACTIONS(1129),
    [anon_sym_LPAREN2] = ACTIONS(1127),
    [anon_sym_BANG] = ACTIONS(1127),
    [anon_sym_TILDE] = ACTIONS(1127),
    [anon_sym_DASH] = ACTIONS(1129),
    [anon_sym_PLUS] = ACTIONS(1129),
    [anon_sym_STAR] = ACTIONS(1127),
    [anon_sym_AMP] = ACTIONS(1127),
    [anon_sym_SEMI] = ACTIONS(1127),
    [anon_sym___extension__] = ACTIONS(1129),
    [anon_sym_typedef] = ACTIONS(1129),
    [anon_sym_extern] = ACTIONS(1129),
    [anon_sym___attribute__] = ACTIONS(1129),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1127),
    [anon_sym___declspec] = ACTIONS(1129),
    [anon_sym___cdecl] = ACTIONS(1129),
    [anon_sym___clrcall] = ACTIONS(1129),
    [anon_sym___stdcall] = ACTIONS(1129),
    [anon_sym___fastcall] = ACTIONS(1129),
    [anon_sym___thiscall] = ACTIONS(1129),
    [anon_sym___vectorcall] = ACTIONS(1129),
    [anon_sym_LBRACE] = ACTIONS(1127),
    [anon_sym_signed] = ACTIONS(1129),
    [anon_sym_unsigned] = ACTIONS(1129),
    [anon_sym_long] = ACTIONS(1129),
    [anon_sym_short] = ACTIONS(1129),
    [anon_sym_static] = ACTIONS(1129),
    [anon_sym_auto] = ACTIONS(1129),
    [anon_sym_register] = ACTIONS(1129),
    [anon_sym_inline] = ACTIONS(1129),
    [anon_sym___inline] = ACTIONS(1129),
    [anon_sym___inline__] = ACTIONS(1129),
    [anon_sym___forceinline] = ACTIONS(1129),
    [anon_sym_thread_local] = ACTIONS(1129),
    [anon_sym___thread] = ACTIONS(1129),
    [anon_sym_const] = ACTIONS(1129),
    [anon_sym_constexpr] = ACTIONS(1129),
    [anon_sym_volatile] = ACTIONS(1129),
    [anon_sym_restrict] = ACTIONS(1129),
    [anon_sym___restrict__] = ACTIONS(1129),
    [anon_sym__Atomic] = ACTIONS(1129),
    [anon_sym__Noreturn] = ACTIONS(1129),
    [anon_sym_noreturn] = ACTIONS(1129),
    [anon_sym_alignas] = ACTIONS(1129),
    [anon_sym__Alignas] = ACTIONS(1129),
    [sym_primitive_type] = ACTIONS(1129),
    [anon_sym_enum] = ACTIONS(1129),
    [anon_sym_struct] = ACTIONS(1129),
    [anon_sym_union] = ACTIONS(1129),
    [anon_sym_if] = ACTIONS(1129),
    [anon_sym_else] = ACTIONS(1129),
    [anon_sym_switch] = ACTIONS(1129),
    [anon_sym_case] = ACTIONS(1129),
    [anon_sym_default] = ACTIONS(1129),
    [anon_sym_while] = ACTIONS(1129),
    [anon_sym_do] = ACTIONS(1129),
    [anon_sym_for] = ACTIONS(1129),
    [anon_sym_return] = ACTIONS(1129),
    [anon_sym_break] = ACTIONS(1129),
    [anon_sym_continue] = ACTIONS(1129),
    [anon_sym_goto] = ACTIONS(1129),
    [anon_sym___try] = ACTIONS(1129),
    [anon_sym___except] = ACTIONS(1129),
    [anon_sym___finally] = ACTIONS(1129),
    [anon_sym___leave] = ACTIONS(1129),
    [anon_sym_DASH_DASH] = ACTIONS(1127),
    [anon_sym_PLUS_PLUS] = ACTIONS(1127),
    [anon_sym_sizeof] = ACTIONS(1129),
    [anon_sym___alignof__] = ACTIONS(1129),
    [anon_sym___alignof] = ACTIONS(1129),
    [anon_sym__alignof] = ACTIONS(1129),
    [anon_sym_alignof] = ACTIONS(1129),
    [anon_sym__Alignof] = ACTIONS(1129),
    [anon_sym_offsetof] = ACTIONS(1129),
    [anon_sym__Generic] = ACTIONS(1129),
    [anon_sym_asm] = ACTIONS(1129),
    [anon_sym___asm__] = ACTIONS(1129),
    [sym_number_literal] = ACTIONS(1127),
    [anon_sym_L_SQUOTE] = ACTIONS(1127),
    [anon_sym_u_SQUOTE] = ACTIONS(1127),
    [anon_sym_U_SQUOTE] = ACTIONS(1127),
    [anon_sym_u8_SQUOTE] = ACTIONS(1127),
    [anon_sym_SQUOTE] = ACTIONS(1127),
    [anon_sym_L_DQUOTE] = ACTIONS(1127),
    [anon_sym_u_DQUOTE] = ACTIONS(1127),
    [anon_sym_U_DQUOTE] = ACTIONS(1127),
    [anon_sym_u8_DQUOTE] = ACTIONS(1127),
    [anon_sym_DQUOTE] = ACTIONS(1127),
    [sym_true] = ACTIONS(1129),
    [sym_false] = ACTIONS(1129),
    [anon_sym_NULL] = ACTIONS(1129),
    [anon_sym_nullptr] = ACTIONS(1129),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_identifier] = ACTIONS(1131),
    [aux_sym_preproc_include_token1] = ACTIONS(1131),
    [aux_sym_preproc_def_token1] = ACTIONS(1131),
    [aux_sym_preproc_if_token1] = ACTIONS(1131),
    [aux_sym_preproc_if_token2] = ACTIONS(1131),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1131),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1131),
    [aux_sym_preproc_else_token1] = ACTIONS(1131),
    [aux_sym_preproc_elif_token1] = ACTIONS(1131),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1131),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1131),
    [sym_preproc_directive] = ACTIONS(1131),
    [anon_sym_LPAREN2] = ACTIONS(1133),
    [anon_sym_BANG] = ACTIONS(1133),
    [anon_sym_TILDE] = ACTIONS(1133),
    [anon_sym_DASH] = ACTIONS(1131),
    [anon_sym_PLUS] = ACTIONS(1131),
    [anon_sym_STAR] = ACTIONS(1133),
    [anon_sym_AMP] = ACTIONS(1133),
    [anon_sym_SEMI] = ACTIONS(1133),
    [anon_sym___extension__] = ACTIONS(1131),
    [anon_sym_typedef] = ACTIONS(1131),
    [anon_sym_extern] = ACTIONS(1131),
    [anon_sym___attribute__] = ACTIONS(1131),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1133),
    [anon_sym___declspec] = ACTIONS(1131),
    [anon_sym___cdecl] = ACTIONS(1131),
    [anon_sym___clrcall] = ACTIONS(1131),
    [anon_sym___stdcall] = ACTIONS(1131),
    [anon_sym___fastcall] = ACTIONS(1131),
    [anon_sym___thiscall] = ACTIONS(1131),
    [anon_sym___vectorcall] = ACTIONS(1131),
    [anon_sym_LBRACE] = ACTIONS(1133),
    [anon_sym_signed] = ACTIONS(1131),
    [anon_sym_unsigned] = ACTIONS(1131),
    [anon_sym_long] = ACTIONS(1131),
    [anon_sym_short] = ACTIONS(1131),
    [anon_sym_static] = ACTIONS(1131),
    [anon_sym_auto] = ACTIONS(1131),
    [anon_sym_register] = ACTIONS(1131),
    [anon_sym_inline] = ACTIONS(1131),
    [anon_sym___inline] = ACTIONS(1131),
    [anon_sym___inline__] = ACTIONS(1131),
    [anon_sym___forceinline] = ACTIONS(1131),
    [anon_sym_thread_local] = ACTIONS(1131),
    [anon_sym___thread] = ACTIONS(1131),
    [anon_sym_const] = ACTIONS(1131),
    [anon_sym_constexpr] = ACTIONS(1131),
    [anon_sym_volatile] = ACTIONS(1131),
    [anon_sym_restrict] = ACTIONS(1131),
    [anon_sym___restrict__] = ACTIONS(1131),
    [anon_sym__Atomic] = ACTIONS(1131),
    [anon_sym__Noreturn] = ACTIONS(1131),
    [anon_sym_noreturn] = ACTIONS(1131),
    [anon_sym_alignas] = ACTIONS(1131),
    [anon_sym__Alignas] = ACTIONS(1131),
    [sym_primitive_type] = ACTIONS(1131),
    [anon_sym_enum] = ACTIONS(1131),
    [anon_sym_struct] = ACTIONS(1131),
    [anon_sym_union] = ACTIONS(1131),
    [anon_sym_if] = ACTIONS(1131),
    [anon_sym_else] = ACTIONS(1131),
    [anon_sym_switch] = ACTIONS(1131),
    [anon_sym_case] = ACTIONS(1131),
    [anon_sym_default] = ACTIONS(1131),
    [anon_sym_while] = ACTIONS(1131),
    [anon_sym_do] = ACTIONS(1131),
    [anon_sym_for] = ACTIONS(1131),
    [anon_sym_return] = ACTIONS(1131),
    [anon_sym_break] = ACTIONS(1131),
    [anon_sym_continue] = ACTIONS(1131),
    [anon_sym_goto] = ACTIONS(1131),
    [anon_sym___try] = ACTIONS(1131),
    [anon_sym___leave] = ACTIONS(1131),
    [anon_sym_DASH_DASH] = ACTIONS(1133),
    [anon_sym_PLUS_PLUS] = ACTIONS(1133),
    [anon_sym_sizeof] = ACTIONS(1131),
    [anon_sym___alignof__] = ACTIONS(1131),
    [anon_sym___alignof] = ACTIONS(1131),
    [anon_sym__alignof] = ACTIONS(1131),
    [anon_sym_alignof] = ACTIONS(1131),
    [anon_sym__Alignof] = ACTIONS(1131),
    [anon_sym_offsetof] = ACTIONS(1131),
    [anon_sym__Generic] = ACTIONS(1131),
    [anon_sym_asm] = ACTIONS(1131),
    [anon_sym___asm__] = ACTIONS(1131),
    [sym_number_literal] = ACTIONS(1133),
    [anon_sym_L_SQUOTE] = ACTIONS(1133),
    [anon_sym_u_SQUOTE] = ACTIONS(1133),
    [anon_sym_U_SQUOTE] = ACTIONS(1133),
    [anon_sym_u8_SQUOTE] = ACTIONS(1133),
    [anon_sym_SQUOTE] = ACTIONS(1133),
    [anon_sym_L_DQUOTE] = ACTIONS(1133),
    [anon_sym_u_DQUOTE] = ACTIONS(1133),
    [anon_sym_U_DQUOTE] = ACTIONS(1133),
    [anon_sym_u8_DQUOTE] = ACTIONS(1133),
    [anon_sym_DQUOTE] = ACTIONS(1133),
    [sym_true] = ACTIONS(1131),
    [sym_false] = ACTIONS(1131),
    [anon_sym_NULL] = ACTIONS(1131),
    [anon_sym_nullptr] = ACTIONS(1131),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym_identifier] = ACTIONS(1131),
    [aux_sym_preproc_include_token1] = ACTIONS(1131),
    [aux_sym_preproc_def_token1] = ACTIONS(1131),
    [aux_sym_preproc_if_token1] = ACTIONS(1131),
    [aux_sym_preproc_if_token2] = ACTIONS(1131),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1131),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1131),
    [aux_sym_preproc_else_token1] = ACTIONS(1131),
    [aux_sym_preproc_elif_token1] = ACTIONS(1131),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1131),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1131),
    [sym_preproc_directive] = ACTIONS(1131),
    [anon_sym_LPAREN2] = ACTIONS(1133),
    [anon_sym_BANG] = ACTIONS(1133),
    [anon_sym_TILDE] = ACTIONS(1133),
    [anon_sym_DASH] = ACTIONS(1131),
    [anon_sym_PLUS] = ACTIONS(1131),
    [anon_sym_STAR] = ACTIONS(1133),
    [anon_sym_AMP] = ACTIONS(1133),
    [anon_sym_SEMI] = ACTIONS(1133),
    [anon_sym___extension__] = ACTIONS(1131),
    [anon_sym_typedef] = ACTIONS(1131),
    [anon_sym_extern] = ACTIONS(1131),
    [anon_sym___attribute__] = ACTIONS(1131),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1133),
    [anon_sym___declspec] = ACTIONS(1131),
    [anon_sym___cdecl] = ACTIONS(1131),
    [anon_sym___clrcall] = ACTIONS(1131),
    [anon_sym___stdcall] = ACTIONS(1131),
    [anon_sym___fastcall] = ACTIONS(1131),
    [anon_sym___thiscall] = ACTIONS(1131),
    [anon_sym___vectorcall] = ACTIONS(1131),
    [anon_sym_LBRACE] = ACTIONS(1133),
    [anon_sym_signed] = ACTIONS(1131),
    [anon_sym_unsigned] = ACTIONS(1131),
    [anon_sym_long] = ACTIONS(1131),
    [anon_sym_short] = ACTIONS(1131),
    [anon_sym_static] = ACTIONS(1131),
    [anon_sym_auto] = ACTIONS(1131),
    [anon_sym_register] = ACTIONS(1131),
    [anon_sym_inline] = ACTIONS(1131),
    [anon_sym___inline] = ACTIONS(1131),
    [anon_sym___inline__] = ACTIONS(1131),
    [anon_sym___forceinline] = ACTIONS(1131),
    [anon_sym_thread_local] = ACTIONS(1131),
    [anon_sym___thread] = ACTIONS(1131),
    [anon_sym_const] = ACTIONS(1131),
    [anon_sym_constexpr] = ACTIONS(1131),
    [anon_sym_volatile] = ACTIONS(1131),
    [anon_sym_restrict] = ACTIONS(1131),
    [anon_sym___restrict__] = ACTIONS(1131),
    [anon_sym__Atomic] = ACTIONS(1131),
    [anon_sym__Noreturn] = ACTIONS(1131),
    [anon_sym_noreturn] = ACTIONS(1131),
    [anon_sym_alignas] = ACTIONS(1131),
    [anon_sym__Alignas] = ACTIONS(1131),
    [sym_primitive_type] = ACTIONS(1131),
    [anon_sym_enum] = ACTIONS(1131),
    [anon_sym_struct] = ACTIONS(1131),
    [anon_sym_union] = ACTIONS(1131),
    [anon_sym_if] = ACTIONS(1131),
    [anon_sym_else] = ACTIONS(1131),
    [anon_sym_switch] = ACTIONS(1131),
    [anon_sym_case] = ACTIONS(1131),
    [anon_sym_default] = ACTIONS(1131),
    [anon_sym_while] = ACTIONS(1131),
    [anon_sym_do] = ACTIONS(1131),
    [anon_sym_for] = ACTIONS(1131),
    [anon_sym_return] = ACTIONS(1131),
    [anon_sym_break] = ACTIONS(1131),
    [anon_sym_continue] = ACTIONS(1131),
    [anon_sym_goto] = ACTIONS(1131),
    [anon_sym___try] = ACTIONS(1131),
    [anon_sym___leave] = ACTIONS(1131),
    [anon_sym_DASH_DASH] = ACTIONS(1133),
    [anon_sym_PLUS_PLUS] = ACTIONS(1133),
    [anon_sym_sizeof] = ACTIONS(1131),
    [anon_sym___alignof__] = ACTIONS(1131),
    [anon_sym___alignof] = ACTIONS(1131),
    [anon_sym__alignof] = ACTIONS(1131),
    [anon_sym_alignof] = ACTIONS(1131),
    [anon_sym__Alignof] = ACTIONS(1131),
    [anon_sym_offsetof] = ACTIONS(1131),
    [anon_sym__Generic] = ACTIONS(1131),
    [anon_sym_asm] = ACTIONS(1131),
    [anon_sym___asm__] = ACTIONS(1131),
    [sym_number_literal] = ACTIONS(1133),
    [anon_sym_L_SQUOTE] = ACTIONS(1133),
    [anon_sym_u_SQUOTE] = ACTIONS(1133),
    [anon_sym_U_SQUOTE] = ACTIONS(1133),
    [anon_sym_u8_SQUOTE] = ACTIONS(1133),
    [anon_sym_SQUOTE] = ACTIONS(1133),
    [anon_sym_L_DQUOTE] = ACTIONS(1133),
    [anon_sym_u_DQUOTE] = ACTIONS(1133),
    [anon_sym_U_DQUOTE] = ACTIONS(1133),
    [anon_sym_u8_DQUOTE] = ACTIONS(1133),
    [anon_sym_DQUOTE] = ACTIONS(1133),
    [sym_true] = ACTIONS(1131),
    [sym_false] = ACTIONS(1131),
    [anon_sym_NULL] = ACTIONS(1131),
    [anon_sym_nullptr] = ACTIONS(1131),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [sym_identifier] = ACTIONS(1135),
    [aux_sym_preproc_include_token1] = ACTIONS(1135),
    [aux_sym_preproc_def_token1] = ACTIONS(1135),
    [aux_sym_preproc_if_token1] = ACTIONS(1135),
    [aux_sym_preproc_if_token2] = ACTIONS(1135),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1135),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1135),
    [aux_sym_preproc_else_token1] = ACTIONS(1135),
    [aux_sym_preproc_elif_token1] = ACTIONS(1135),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1135),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1135),
    [sym_preproc_directive] = ACTIONS(1135),
    [anon_sym_LPAREN2] = ACTIONS(1137),
    [anon_sym_BANG] = ACTIONS(1137),
    [anon_sym_TILDE] = ACTIONS(1137),
    [anon_sym_DASH] = ACTIONS(1135),
    [anon_sym_PLUS] = ACTIONS(1135),
    [anon_sym_STAR] = ACTIONS(1137),
    [anon_sym_AMP] = ACTIONS(1137),
    [anon_sym_SEMI] = ACTIONS(1137),
    [anon_sym___extension__] = ACTIONS(1135),
    [anon_sym_typedef] = ACTIONS(1135),
    [anon_sym_extern] = ACTIONS(1135),
    [anon_sym___attribute__] = ACTIONS(1135),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1137),
    [anon_sym___declspec] = ACTIONS(1135),
    [anon_sym___cdecl] = ACTIONS(1135),
    [anon_sym___clrcall] = ACTIONS(1135),
    [anon_sym___stdcall] = ACTIONS(1135),
    [anon_sym___fastcall] = ACTIONS(1135),
    [anon_sym___thiscall] = ACTIONS(1135),
    [anon_sym___vectorcall] = ACTIONS(1135),
    [anon_sym_LBRACE] = ACTIONS(1137),
    [anon_sym_signed] = ACTIONS(1135),
    [anon_sym_unsigned] = ACTIONS(1135),
    [anon_sym_long] = ACTIONS(1135),
    [anon_sym_short] = ACTIONS(1135),
    [anon_sym_static] = ACTIONS(1135),
    [anon_sym_auto] = ACTIONS(1135),
    [anon_sym_register] = ACTIONS(1135),
    [anon_sym_inline] = ACTIONS(1135),
    [anon_sym___inline] = ACTIONS(1135),
    [anon_sym___inline__] = ACTIONS(1135),
    [anon_sym___forceinline] = ACTIONS(1135),
    [anon_sym_thread_local] = ACTIONS(1135),
    [anon_sym___thread] = ACTIONS(1135),
    [anon_sym_const] = ACTIONS(1135),
    [anon_sym_constexpr] = ACTIONS(1135),
    [anon_sym_volatile] = ACTIONS(1135),
    [anon_sym_restrict] = ACTIONS(1135),
    [anon_sym___restrict__] = ACTIONS(1135),
    [anon_sym__Atomic] = ACTIONS(1135),
    [anon_sym__Noreturn] = ACTIONS(1135),
    [anon_sym_noreturn] = ACTIONS(1135),
    [anon_sym_alignas] = ACTIONS(1135),
    [anon_sym__Alignas] = ACTIONS(1135),
    [sym_primitive_type] = ACTIONS(1135),
    [anon_sym_enum] = ACTIONS(1135),
    [anon_sym_struct] = ACTIONS(1135),
    [anon_sym_union] = ACTIONS(1135),
    [anon_sym_if] = ACTIONS(1135),
    [anon_sym_else] = ACTIONS(1135),
    [anon_sym_switch] = ACTIONS(1135),
    [anon_sym_case] = ACTIONS(1135),
    [anon_sym_default] = ACTIONS(1135),
    [anon_sym_while] = ACTIONS(1135),
    [anon_sym_do] = ACTIONS(1135),
    [anon_sym_for] = ACTIONS(1135),
    [anon_sym_return] = ACTIONS(1135),
    [anon_sym_break] = ACTIONS(1135),
    [anon_sym_continue] = ACTIONS(1135),
    [anon_sym_goto] = ACTIONS(1135),
    [anon_sym___try] = ACTIONS(1135),
    [anon_sym___leave] = ACTIONS(1135),
    [anon_sym_DASH_DASH] = ACTIONS(1137),
    [anon_sym_PLUS_PLUS] = ACTIONS(1137),
    [anon_sym_sizeof] = ACTIONS(1135),
    [anon_sym___alignof__] = ACTIONS(1135),
    [anon_sym___alignof] = ACTIONS(1135),
    [anon_sym__alignof] = ACTIONS(1135),
    [anon_sym_alignof] = ACTIONS(1135),
    [anon_sym__Alignof] = ACTIONS(1135),
    [anon_sym_offsetof] = ACTIONS(1135),
    [anon_sym__Generic] = ACTIONS(1135),
    [anon_sym_asm] = ACTIONS(1135),
    [anon_sym___asm__] = ACTIONS(1135),
    [sym_number_literal] = ACTIONS(1137),
    [anon_sym_L_SQUOTE] = ACTIONS(1137),
    [anon_sym_u_SQUOTE] = ACTIONS(1137),
    [anon_sym_U_SQUOTE] = ACTIONS(1137),
    [anon_sym_u8_SQUOTE] = ACTIONS(1137),
    [anon_sym_SQUOTE] = ACTIONS(1137),
    [anon_sym_L_DQUOTE] = ACTIONS(1137),
    [anon_sym_u_DQUOTE] = ACTIONS(1137),
    [anon_sym_U_DQUOTE] = ACTIONS(1137),
    [anon_sym_u8_DQUOTE] = ACTIONS(1137),
    [anon_sym_DQUOTE] = ACTIONS(1137),
    [sym_true] = ACTIONS(1135),
    [sym_false] = ACTIONS(1135),
    [anon_sym_NULL] = ACTIONS(1135),
    [anon_sym_nullptr] = ACTIONS(1135),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [sym_identifier] = ACTIONS(1139),
    [aux_sym_preproc_include_token1] = ACTIONS(1139),
    [aux_sym_preproc_def_token1] = ACTIONS(1139),
    [aux_sym_preproc_if_token1] = ACTIONS(1139),
    [aux_sym_preproc_if_token2] = ACTIONS(1139),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1139),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1139),
    [aux_sym_preproc_else_token1] = ACTIONS(1139),
    [aux_sym_preproc_elif_token1] = ACTIONS(1139),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1139),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1139),
    [sym_preproc_directive] = ACTIONS(1139),
    [anon_sym_LPAREN2] = ACTIONS(1141),
    [anon_sym_BANG] = ACTIONS(1141),
    [anon_sym_TILDE] = ACTIONS(1141),
    [anon_sym_DASH] = ACTIONS(1139),
    [anon_sym_PLUS] = ACTIONS(1139),
    [anon_sym_STAR] = ACTIONS(1141),
    [anon_sym_AMP] = ACTIONS(1141),
    [anon_sym_SEMI] = ACTIONS(1141),
    [anon_sym___extension__] = ACTIONS(1139),
    [anon_sym_typedef] = ACTIONS(1139),
    [anon_sym_extern] = ACTIONS(1139),
    [anon_sym___attribute__] = ACTIONS(1139),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1141),
    [anon_sym___declspec] = ACTIONS(1139),
    [anon_sym___cdecl] = ACTIONS(1139),
    [anon_sym___clrcall] = ACTIONS(1139),
    [anon_sym___stdcall] = ACTIONS(1139),
    [anon_sym___fastcall] = ACTIONS(1139),
    [anon_sym___thiscall] = ACTIONS(1139),
    [anon_sym___vectorcall] = ACTIONS(1139),
    [anon_sym_LBRACE] = ACTIONS(1141),
    [anon_sym_signed] = ACTIONS(1139),
    [anon_sym_unsigned] = ACTIONS(1139),
    [anon_sym_long] = ACTIONS(1139),
    [anon_sym_short] = ACTIONS(1139),
    [anon_sym_static] = ACTIONS(1139),
    [anon_sym_auto] = ACTIONS(1139),
    [anon_sym_register] = ACTIONS(1139),
    [anon_sym_inline] = ACTIONS(1139),
    [anon_sym___inline] = ACTIONS(1139),
    [anon_sym___inline__] = ACTIONS(1139),
    [anon_sym___forceinline] = ACTIONS(1139),
    [anon_sym_thread_local] = ACTIONS(1139),
    [anon_sym___thread] = ACTIONS(1139),
    [anon_sym_const] = ACTIONS(1139),
    [anon_sym_constexpr] = ACTIONS(1139),
    [anon_sym_volatile] = ACTIONS(1139),
    [anon_sym_restrict] = ACTIONS(1139),
    [anon_sym___restrict__] = ACTIONS(1139),
    [anon_sym__Atomic] = ACTIONS(1139),
    [anon_sym__Noreturn] = ACTIONS(1139),
    [anon_sym_noreturn] = ACTIONS(1139),
    [anon_sym_alignas] = ACTIONS(1139),
    [anon_sym__Alignas] = ACTIONS(1139),
    [sym_primitive_type] = ACTIONS(1139),
    [anon_sym_enum] = ACTIONS(1139),
    [anon_sym_struct] = ACTIONS(1139),
    [anon_sym_union] = ACTIONS(1139),
    [anon_sym_if] = ACTIONS(1139),
    [anon_sym_else] = ACTIONS(1139),
    [anon_sym_switch] = ACTIONS(1139),
    [anon_sym_case] = ACTIONS(1139),
    [anon_sym_default] = ACTIONS(1139),
    [anon_sym_while] = ACTIONS(1139),
    [anon_sym_do] = ACTIONS(1139),
    [anon_sym_for] = ACTIONS(1139),
    [anon_sym_return] = ACTIONS(1139),
    [anon_sym_break] = ACTIONS(1139),
    [anon_sym_continue] = ACTIONS(1139),
    [anon_sym_goto] = ACTIONS(1139),
    [anon_sym___try] = ACTIONS(1139),
    [anon_sym___leave] = ACTIONS(1139),
    [anon_sym_DASH_DASH] = ACTIONS(1141),
    [anon_sym_PLUS_PLUS] = ACTIONS(1141),
    [anon_sym_sizeof] = ACTIONS(1139),
    [anon_sym___alignof__] = ACTIONS(1139),
    [anon_sym___alignof] = ACTIONS(1139),
    [anon_sym__alignof] = ACTIONS(1139),
    [anon_sym_alignof] = ACTIONS(1139),
    [anon_sym__Alignof] = ACTIONS(1139),
    [anon_sym_offsetof] = ACTIONS(1139),
    [anon_sym__Generic] = ACTIONS(1139),
    [anon_sym_asm] = ACTIONS(1139),
    [anon_sym___asm__] = ACTIONS(1139),
    [sym_number_literal] = ACTIONS(1141),
    [anon_sym_L_SQUOTE] = ACTIONS(1141),
    [anon_sym_u_SQUOTE] = ACTIONS(1141),
    [anon_sym_U_SQUOTE] = ACTIONS(1141),
    [anon_sym_u8_SQUOTE] = ACTIONS(1141),
    [anon_sym_SQUOTE] = ACTIONS(1141),
    [anon_sym_L_DQUOTE] = ACTIONS(1141),
    [anon_sym_u_DQUOTE] = ACTIONS(1141),
    [anon_sym_U_DQUOTE] = ACTIONS(1141),
    [anon_sym_u8_DQUOTE] = ACTIONS(1141),
    [anon_sym_DQUOTE] = ACTIONS(1141),
    [sym_true] = ACTIONS(1139),
    [sym_false] = ACTIONS(1139),
    [anon_sym_NULL] = ACTIONS(1139),
    [anon_sym_nullptr] = ACTIONS(1139),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [sym_identifier] = ACTIONS(1143),
    [aux_sym_preproc_include_token1] = ACTIONS(1143),
    [aux_sym_preproc_def_token1] = ACTIONS(1143),
    [aux_sym_preproc_if_token1] = ACTIONS(1143),
    [aux_sym_preproc_if_token2] = ACTIONS(1143),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1143),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1143),
    [aux_sym_preproc_else_token1] = ACTIONS(1143),
    [aux_sym_preproc_elif_token1] = ACTIONS(1143),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1143),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1143),
    [sym_preproc_directive] = ACTIONS(1143),
    [anon_sym_LPAREN2] = ACTIONS(1145),
    [anon_sym_BANG] = ACTIONS(1145),
    [anon_sym_TILDE] = ACTIONS(1145),
    [anon_sym_DASH] = ACTIONS(1143),
    [anon_sym_PLUS] = ACTIONS(1143),
    [anon_sym_STAR] = ACTIONS(1145),
    [anon_sym_AMP] = ACTIONS(1145),
    [anon_sym_SEMI] = ACTIONS(1145),
    [anon_sym___extension__] = ACTIONS(1143),
    [anon_sym_typedef] = ACTIONS(1143),
    [anon_sym_extern] = ACTIONS(1143),
    [anon_sym___attribute__] = ACTIONS(1143),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1145),
    [anon_sym___declspec] = ACTIONS(1143),
    [anon_sym___cdecl] = ACTIONS(1143),
    [anon_sym___clrcall] = ACTIONS(1143),
    [anon_sym___stdcall] = ACTIONS(1143),
    [anon_sym___fastcall] = ACTIONS(1143),
    [anon_sym___thiscall] = ACTIONS(1143),
    [anon_sym___vectorcall] = ACTIONS(1143),
    [anon_sym_LBRACE] = ACTIONS(1145),
    [anon_sym_signed] = ACTIONS(1143),
    [anon_sym_unsigned] = ACTIONS(1143),
    [anon_sym_long] = ACTIONS(1143),
    [anon_sym_short] = ACTIONS(1143),
    [anon_sym_static] = ACTIONS(1143),
    [anon_sym_auto] = ACTIONS(1143),
    [anon_sym_register] = ACTIONS(1143),
    [anon_sym_inline] = ACTIONS(1143),
    [anon_sym___inline] = ACTIONS(1143),
    [anon_sym___inline__] = ACTIONS(1143),
    [anon_sym___forceinline] = ACTIONS(1143),
    [anon_sym_thread_local] = ACTIONS(1143),
    [anon_sym___thread] = ACTIONS(1143),
    [anon_sym_const] = ACTIONS(1143),
    [anon_sym_constexpr] = ACTIONS(1143),
    [anon_sym_volatile] = ACTIONS(1143),
    [anon_sym_restrict] = ACTIONS(1143),
    [anon_sym___restrict__] = ACTIONS(1143),
    [anon_sym__Atomic] = ACTIONS(1143),
    [anon_sym__Noreturn] = ACTIONS(1143),
    [anon_sym_noreturn] = ACTIONS(1143),
    [anon_sym_alignas] = ACTIONS(1143),
    [anon_sym__Alignas] = ACTIONS(1143),
    [sym_primitive_type] = ACTIONS(1143),
    [anon_sym_enum] = ACTIONS(1143),
    [anon_sym_struct] = ACTIONS(1143),
    [anon_sym_union] = ACTIONS(1143),
    [anon_sym_if] = ACTIONS(1143),
    [anon_sym_else] = ACTIONS(1143),
    [anon_sym_switch] = ACTIONS(1143),
    [anon_sym_case] = ACTIONS(1143),
    [anon_sym_default] = ACTIONS(1143),
    [anon_sym_while] = ACTIONS(1143),
    [anon_sym_do] = ACTIONS(1143),
    [anon_sym_for] = ACTIONS(1143),
    [anon_sym_return] = ACTIONS(1143),
    [anon_sym_break] = ACTIONS(1143),
    [anon_sym_continue] = ACTIONS(1143),
    [anon_sym_goto] = ACTIONS(1143),
    [anon_sym___try] = ACTIONS(1143),
    [anon_sym___leave] = ACTIONS(1143),
    [anon_sym_DASH_DASH] = ACTIONS(1145),
    [anon_sym_PLUS_PLUS] = ACTIONS(1145),
    [anon_sym_sizeof] = ACTIONS(1143),
    [anon_sym___alignof__] = ACTIONS(1143),
    [anon_sym___alignof] = ACTIONS(1143),
    [anon_sym__alignof] = ACTIONS(1143),
    [anon_sym_alignof] = ACTIONS(1143),
    [anon_sym__Alignof] = ACTIONS(1143),
    [anon_sym_offsetof] = ACTIONS(1143),
    [anon_sym__Generic] = ACTIONS(1143),
    [anon_sym_asm] = ACTIONS(1143),
    [anon_sym___asm__] = ACTIONS(1143),
    [sym_number_literal] = ACTIONS(1145),
    [anon_sym_L_SQUOTE] = ACTIONS(1145),
    [anon_sym_u_SQUOTE] = ACTIONS(1145),
    [anon_sym_U_SQUOTE] = ACTIONS(1145),
    [anon_sym_u8_SQUOTE] = ACTIONS(1145),
    [anon_sym_SQUOTE] = ACTIONS(1145),
    [anon_sym_L_DQUOTE] = ACTIONS(1145),
    [anon_sym_u_DQUOTE] = ACTIONS(1145),
    [anon_sym_U_DQUOTE] = ACTIONS(1145),
    [anon_sym_u8_DQUOTE] = ACTIONS(1145),
    [anon_sym_DQUOTE] = ACTIONS(1145),
    [sym_true] = ACTIONS(1143),
    [sym_false] = ACTIONS(1143),
    [anon_sym_NULL] = ACTIONS(1143),
    [anon_sym_nullptr] = ACTIONS(1143),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [sym_identifier] = ACTIONS(1147),
    [aux_sym_preproc_include_token1] = ACTIONS(1147),
    [aux_sym_preproc_def_token1] = ACTIONS(1147),
    [aux_sym_preproc_if_token1] = ACTIONS(1147),
    [aux_sym_preproc_if_token2] = ACTIONS(1147),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1147),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1147),
    [aux_sym_preproc_else_token1] = ACTIONS(1147),
    [aux_sym_preproc_elif_token1] = ACTIONS(1147),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1147),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1147),
    [sym_preproc_directive] = ACTIONS(1147),
    [anon_sym_LPAREN2] = ACTIONS(1149),
    [anon_sym_BANG] = ACTIONS(1149),
    [anon_sym_TILDE] = ACTIONS(1149),
    [anon_sym_DASH] = ACTIONS(1147),
    [anon_sym_PLUS] = ACTIONS(1147),
    [anon_sym_STAR] = ACTIONS(1149),
    [anon_sym_AMP] = ACTIONS(1149),
    [anon_sym_SEMI] = ACTIONS(1149),
    [anon_sym___extension__] = ACTIONS(1147),
    [anon_sym_typedef] = ACTIONS(1147),
    [anon_sym_extern] = ACTIONS(1147),
    [anon_sym___attribute__] = ACTIONS(1147),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1149),
    [anon_sym___declspec] = ACTIONS(1147),
    [anon_sym___cdecl] = ACTIONS(1147),
    [anon_sym___clrcall] = ACTIONS(1147),
    [anon_sym___stdcall] = ACTIONS(1147),
    [anon_sym___fastcall] = ACTIONS(1147),
    [anon_sym___thiscall] = ACTIONS(1147),
    [anon_sym___vectorcall] = ACTIONS(1147),
    [anon_sym_LBRACE] = ACTIONS(1149),
    [anon_sym_signed] = ACTIONS(1147),
    [anon_sym_unsigned] = ACTIONS(1147),
    [anon_sym_long] = ACTIONS(1147),
    [anon_sym_short] = ACTIONS(1147),
    [anon_sym_static] = ACTIONS(1147),
    [anon_sym_auto] = ACTIONS(1147),
    [anon_sym_register] = ACTIONS(1147),
    [anon_sym_inline] = ACTIONS(1147),
    [anon_sym___inline] = ACTIONS(1147),
    [anon_sym___inline__] = ACTIONS(1147),
    [anon_sym___forceinline] = ACTIONS(1147),
    [anon_sym_thread_local] = ACTIONS(1147),
    [anon_sym___thread] = ACTIONS(1147),
    [anon_sym_const] = ACTIONS(1147),
    [anon_sym_constexpr] = ACTIONS(1147),
    [anon_sym_volatile] = ACTIONS(1147),
    [anon_sym_restrict] = ACTIONS(1147),
    [anon_sym___restrict__] = ACTIONS(1147),
    [anon_sym__Atomic] = ACTIONS(1147),
    [anon_sym__Noreturn] = ACTIONS(1147),
    [anon_sym_noreturn] = ACTIONS(1147),
    [anon_sym_alignas] = ACTIONS(1147),
    [anon_sym__Alignas] = ACTIONS(1147),
    [sym_primitive_type] = ACTIONS(1147),
    [anon_sym_enum] = ACTIONS(1147),
    [anon_sym_struct] = ACTIONS(1147),
    [anon_sym_union] = ACTIONS(1147),
    [anon_sym_if] = ACTIONS(1147),
    [anon_sym_else] = ACTIONS(1147),
    [anon_sym_switch] = ACTIONS(1147),
    [anon_sym_case] = ACTIONS(1147),
    [anon_sym_default] = ACTIONS(1147),
    [anon_sym_while] = ACTIONS(1147),
    [anon_sym_do] = ACTIONS(1147),
    [anon_sym_for] = ACTIONS(1147),
    [anon_sym_return] = ACTIONS(1147),
    [anon_sym_break] = ACTIONS(1147),
    [anon_sym_continue] = ACTIONS(1147),
    [anon_sym_goto] = ACTIONS(1147),
    [anon_sym___try] = ACTIONS(1147),
    [anon_sym___leave] = ACTIONS(1147),
    [anon_sym_DASH_DASH] = ACTIONS(1149),
    [anon_sym_PLUS_PLUS] = ACTIONS(1149),
    [anon_sym_sizeof] = ACTIONS(1147),
    [anon_sym___alignof__] = ACTIONS(1147),
    [anon_sym___alignof] = ACTIONS(1147),
    [anon_sym__alignof] = ACTIONS(1147),
    [anon_sym_alignof] = ACTIONS(1147),
    [anon_sym__Alignof] = ACTIONS(1147),
    [anon_sym_offsetof] = ACTIONS(1147),
    [anon_sym__Generic] = ACTIONS(1147),
    [anon_sym_asm] = ACTIONS(1147),
    [anon_sym___asm__] = ACTIONS(1147),
    [sym_number_literal] = ACTIONS(1149),
    [anon_sym_L_SQUOTE] = ACTIONS(1149),
    [anon_sym_u_SQUOTE] = ACTIONS(1149),
    [anon_sym_U_SQUOTE] = ACTIONS(1149),
    [anon_sym_u8_SQUOTE] = ACTIONS(1149),
    [anon_sym_SQUOTE] = ACTIONS(1149),
    [anon_sym_L_DQUOTE] = ACTIONS(1149),
    [anon_sym_u_DQUOTE] = ACTIONS(1149),
    [anon_sym_U_DQUOTE] = ACTIONS(1149),
    [anon_sym_u8_DQUOTE] = ACTIONS(1149),
    [anon_sym_DQUOTE] = ACTIONS(1149),
    [sym_true] = ACTIONS(1147),
    [sym_false] = ACTIONS(1147),
    [anon_sym_NULL] = ACTIONS(1147),
    [anon_sym_nullptr] = ACTIONS(1147),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [sym_identifier] = ACTIONS(1151),
    [aux_sym_preproc_include_token1] = ACTIONS(1151),
    [aux_sym_preproc_def_token1] = ACTIONS(1151),
    [aux_sym_preproc_if_token1] = ACTIONS(1151),
    [aux_sym_preproc_if_token2] = ACTIONS(1151),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1151),
    [aux_sym_preproc_else_token1] = ACTIONS(1151),
    [aux_sym_preproc_elif_token1] = ACTIONS(1151),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1151),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1151),
    [sym_preproc_directive] = ACTIONS(1151),
    [anon_sym_LPAREN2] = ACTIONS(1153),
    [anon_sym_BANG] = ACTIONS(1153),
    [anon_sym_TILDE] = ACTIONS(1153),
    [anon_sym_DASH] = ACTIONS(1151),
    [anon_sym_PLUS] = ACTIONS(1151),
    [anon_sym_STAR] = ACTIONS(1153),
    [anon_sym_AMP] = ACTIONS(1153),
    [anon_sym_SEMI] = ACTIONS(1153),
    [anon_sym___extension__] = ACTIONS(1151),
    [anon_sym_typedef] = ACTIONS(1151),
    [anon_sym_extern] = ACTIONS(1151),
    [anon_sym___attribute__] = ACTIONS(1151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1153),
    [anon_sym___declspec] = ACTIONS(1151),
    [anon_sym___cdecl] = ACTIONS(1151),
    [anon_sym___clrcall] = ACTIONS(1151),
    [anon_sym___stdcall] = ACTIONS(1151),
    [anon_sym___fastcall] = ACTIONS(1151),
    [anon_sym___thiscall] = ACTIONS(1151),
    [anon_sym___vectorcall] = ACTIONS(1151),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_signed] = ACTIONS(1151),
    [anon_sym_unsigned] = ACTIONS(1151),
    [anon_sym_long] = ACTIONS(1151),
    [anon_sym_short] = ACTIONS(1151),
    [anon_sym_static] = ACTIONS(1151),
    [anon_sym_auto] = ACTIONS(1151),
    [anon_sym_register] = ACTIONS(1151),
    [anon_sym_inline] = ACTIONS(1151),
    [anon_sym___inline] = ACTIONS(1151),
    [anon_sym___inline__] = ACTIONS(1151),
    [anon_sym___forceinline] = ACTIONS(1151),
    [anon_sym_thread_local] = ACTIONS(1151),
    [anon_sym___thread] = ACTIONS(1151),
    [anon_sym_const] = ACTIONS(1151),
    [anon_sym_constexpr] = ACTIONS(1151),
    [anon_sym_volatile] = ACTIONS(1151),
    [anon_sym_restrict] = ACTIONS(1151),
    [anon_sym___restrict__] = ACTIONS(1151),
    [anon_sym__Atomic] = ACTIONS(1151),
    [anon_sym__Noreturn] = ACTIONS(1151),
    [anon_sym_noreturn] = ACTIONS(1151),
    [anon_sym_alignas] = ACTIONS(1151),
    [anon_sym__Alignas] = ACTIONS(1151),
    [sym_primitive_type] = ACTIONS(1151),
    [anon_sym_enum] = ACTIONS(1151),
    [anon_sym_struct] = ACTIONS(1151),
    [anon_sym_union] = ACTIONS(1151),
    [anon_sym_if] = ACTIONS(1151),
    [anon_sym_else] = ACTIONS(1151),
    [anon_sym_switch] = ACTIONS(1151),
    [anon_sym_case] = ACTIONS(1151),
    [anon_sym_default] = ACTIONS(1151),
    [anon_sym_while] = ACTIONS(1151),
    [anon_sym_do] = ACTIONS(1151),
    [anon_sym_for] = ACTIONS(1151),
    [anon_sym_return] = ACTIONS(1151),
    [anon_sym_break] = ACTIONS(1151),
    [anon_sym_continue] = ACTIONS(1151),
    [anon_sym_goto] = ACTIONS(1151),
    [anon_sym___try] = ACTIONS(1151),
    [anon_sym___leave] = ACTIONS(1151),
    [anon_sym_DASH_DASH] = ACTIONS(1153),
    [anon_sym_PLUS_PLUS] = ACTIONS(1153),
    [anon_sym_sizeof] = ACTIONS(1151),
    [anon_sym___alignof__] = ACTIONS(1151),
    [anon_sym___alignof] = ACTIONS(1151),
    [anon_sym__alignof] = ACTIONS(1151),
    [anon_sym_alignof] = ACTIONS(1151),
    [anon_sym__Alignof] = ACTIONS(1151),
    [anon_sym_offsetof] = ACTIONS(1151),
    [anon_sym__Generic] = ACTIONS(1151),
    [anon_sym_asm] = ACTIONS(1151),
    [anon_sym___asm__] = ACTIONS(1151),
    [sym_number_literal] = ACTIONS(1153),
    [anon_sym_L_SQUOTE] = ACTIONS(1153),
    [anon_sym_u_SQUOTE] = ACTIONS(1153),
    [anon_sym_U_SQUOTE] = ACTIONS(1153),
    [anon_sym_u8_SQUOTE] = ACTIONS(1153),
    [anon_sym_SQUOTE] = ACTIONS(1153),
    [anon_sym_L_DQUOTE] = ACTIONS(1153),
    [anon_sym_u_DQUOTE] = ACTIONS(1153),
    [anon_sym_U_DQUOTE] = ACTIONS(1153),
    [anon_sym_u8_DQUOTE] = ACTIONS(1153),
    [anon_sym_DQUOTE] = ACTIONS(1153),
    [sym_true] = ACTIONS(1151),
    [sym_false] = ACTIONS(1151),
    [anon_sym_NULL] = ACTIONS(1151),
    [anon_sym_nullptr] = ACTIONS(1151),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [sym_identifier] = ACTIONS(1155),
    [aux_sym_preproc_include_token1] = ACTIONS(1155),
    [aux_sym_preproc_def_token1] = ACTIONS(1155),
    [aux_sym_preproc_if_token1] = ACTIONS(1155),
    [aux_sym_preproc_if_token2] = ACTIONS(1155),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1155),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1155),
    [aux_sym_preproc_else_token1] = ACTIONS(1155),
    [aux_sym_preproc_elif_token1] = ACTIONS(1155),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1155),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1155),
    [sym_preproc_directive] = ACTIONS(1155),
    [anon_sym_LPAREN2] = ACTIONS(1157),
    [anon_sym_BANG] = ACTIONS(1157),
    [anon_sym_TILDE] = ACTIONS(1157),
    [anon_sym_DASH] = ACTIONS(1155),
    [anon_sym_PLUS] = ACTIONS(1155),
    [anon_sym_STAR] = ACTIONS(1157),
    [anon_sym_AMP] = ACTIONS(1157),
    [anon_sym_SEMI] = ACTIONS(1157),
    [anon_sym___extension__] = ACTIONS(1155),
    [anon_sym_typedef] = ACTIONS(1155),
    [anon_sym_extern] = ACTIONS(1155),
    [anon_sym___attribute__] = ACTIONS(1155),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1157),
    [anon_sym___declspec] = ACTIONS(1155),
    [anon_sym___cdecl] = ACTIONS(1155),
    [anon_sym___clrcall] = ACTIONS(1155),
    [anon_sym___stdcall] = ACTIONS(1155),
    [anon_sym___fastcall] = ACTIONS(1155),
    [anon_sym___thiscall] = ACTIONS(1155),
    [anon_sym___vectorcall] = ACTIONS(1155),
    [anon_sym_LBRACE] = ACTIONS(1157),
    [anon_sym_signed] = ACTIONS(1155),
    [anon_sym_unsigned] = ACTIONS(1155),
    [anon_sym_long] = ACTIONS(1155),
    [anon_sym_short] = ACTIONS(1155),
    [anon_sym_static] = ACTIONS(1155),
    [anon_sym_auto] = ACTIONS(1155),
    [anon_sym_register] = ACTIONS(1155),
    [anon_sym_inline] = ACTIONS(1155),
    [anon_sym___inline] = ACTIONS(1155),
    [anon_sym___inline__] = ACTIONS(1155),
    [anon_sym___forceinline] = ACTIONS(1155),
    [anon_sym_thread_local] = ACTIONS(1155),
    [anon_sym___thread] = ACTIONS(1155),
    [anon_sym_const] = ACTIONS(1155),
    [anon_sym_constexpr] = ACTIONS(1155),
    [anon_sym_volatile] = ACTIONS(1155),
    [anon_sym_restrict] = ACTIONS(1155),
    [anon_sym___restrict__] = ACTIONS(1155),
    [anon_sym__Atomic] = ACTIONS(1155),
    [anon_sym__Noreturn] = ACTIONS(1155),
    [anon_sym_noreturn] = ACTIONS(1155),
    [anon_sym_alignas] = ACTIONS(1155),
    [anon_sym__Alignas] = ACTIONS(1155),
    [sym_primitive_type] = ACTIONS(1155),
    [anon_sym_enum] = ACTIONS(1155),
    [anon_sym_struct] = ACTIONS(1155),
    [anon_sym_union] = ACTIONS(1155),
    [anon_sym_if] = ACTIONS(1155),
    [anon_sym_else] = ACTIONS(1155),
    [anon_sym_switch] = ACTIONS(1155),
    [anon_sym_case] = ACTIONS(1155),
    [anon_sym_default] = ACTIONS(1155),
    [anon_sym_while] = ACTIONS(1155),
    [anon_sym_do] = ACTIONS(1155),
    [anon_sym_for] = ACTIONS(1155),
    [anon_sym_return] = ACTIONS(1155),
    [anon_sym_break] = ACTIONS(1155),
    [anon_sym_continue] = ACTIONS(1155),
    [anon_sym_goto] = ACTIONS(1155),
    [anon_sym___try] = ACTIONS(1155),
    [anon_sym___leave] = ACTIONS(1155),
    [anon_sym_DASH_DASH] = ACTIONS(1157),
    [anon_sym_PLUS_PLUS] = ACTIONS(1157),
    [anon_sym_sizeof] = ACTIONS(1155),
    [anon_sym___alignof__] = ACTIONS(1155),
    [anon_sym___alignof] = ACTIONS(1155),
    [anon_sym__alignof] = ACTIONS(1155),
    [anon_sym_alignof] = ACTIONS(1155),
    [anon_sym__Alignof] = ACTIONS(1155),
    [anon_sym_offsetof] = ACTIONS(1155),
    [anon_sym__Generic] = ACTIONS(1155),
    [anon_sym_asm] = ACTIONS(1155),
    [anon_sym___asm__] = ACTIONS(1155),
    [sym_number_literal] = ACTIONS(1157),
    [anon_sym_L_SQUOTE] = ACTIONS(1157),
    [anon_sym_u_SQUOTE] = ACTIONS(1157),
    [anon_sym_U_SQUOTE] = ACTIONS(1157),
    [anon_sym_u8_SQUOTE] = ACTIONS(1157),
    [anon_sym_SQUOTE] = ACTIONS(1157),
    [anon_sym_L_DQUOTE] = ACTIONS(1157),
    [anon_sym_u_DQUOTE] = ACTIONS(1157),
    [anon_sym_U_DQUOTE] = ACTIONS(1157),
    [anon_sym_u8_DQUOTE] = ACTIONS(1157),
    [anon_sym_DQUOTE] = ACTIONS(1157),
    [sym_true] = ACTIONS(1155),
    [sym_false] = ACTIONS(1155),
    [anon_sym_NULL] = ACTIONS(1155),
    [anon_sym_nullptr] = ACTIONS(1155),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [sym_identifier] = ACTIONS(1159),
    [aux_sym_preproc_include_token1] = ACTIONS(1159),
    [aux_sym_preproc_def_token1] = ACTIONS(1159),
    [aux_sym_preproc_if_token1] = ACTIONS(1159),
    [aux_sym_preproc_if_token2] = ACTIONS(1159),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1159),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1159),
    [aux_sym_preproc_else_token1] = ACTIONS(1159),
    [aux_sym_preproc_elif_token1] = ACTIONS(1159),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1159),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1159),
    [sym_preproc_directive] = ACTIONS(1159),
    [anon_sym_LPAREN2] = ACTIONS(1161),
    [anon_sym_BANG] = ACTIONS(1161),
    [anon_sym_TILDE] = ACTIONS(1161),
    [anon_sym_DASH] = ACTIONS(1159),
    [anon_sym_PLUS] = ACTIONS(1159),
    [anon_sym_STAR] = ACTIONS(1161),
    [anon_sym_AMP] = ACTIONS(1161),
    [anon_sym_SEMI] = ACTIONS(1161),
    [anon_sym___extension__] = ACTIONS(1159),
    [anon_sym_typedef] = ACTIONS(1159),
    [anon_sym_extern] = ACTIONS(1159),
    [anon_sym___attribute__] = ACTIONS(1159),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1161),
    [anon_sym___declspec] = ACTIONS(1159),
    [anon_sym___cdecl] = ACTIONS(1159),
    [anon_sym___clrcall] = ACTIONS(1159),
    [anon_sym___stdcall] = ACTIONS(1159),
    [anon_sym___fastcall] = ACTIONS(1159),
    [anon_sym___thiscall] = ACTIONS(1159),
    [anon_sym___vectorcall] = ACTIONS(1159),
    [anon_sym_LBRACE] = ACTIONS(1161),
    [anon_sym_signed] = ACTIONS(1159),
    [anon_sym_unsigned] = ACTIONS(1159),
    [anon_sym_long] = ACTIONS(1159),
    [anon_sym_short] = ACTIONS(1159),
    [anon_sym_static] = ACTIONS(1159),
    [anon_sym_auto] = ACTIONS(1159),
    [anon_sym_register] = ACTIONS(1159),
    [anon_sym_inline] = ACTIONS(1159),
    [anon_sym___inline] = ACTIONS(1159),
    [anon_sym___inline__] = ACTIONS(1159),
    [anon_sym___forceinline] = ACTIONS(1159),
    [anon_sym_thread_local] = ACTIONS(1159),
    [anon_sym___thread] = ACTIONS(1159),
    [anon_sym_const] = ACTIONS(1159),
    [anon_sym_constexpr] = ACTIONS(1159),
    [anon_sym_volatile] = ACTIONS(1159),
    [anon_sym_restrict] = ACTIONS(1159),
    [anon_sym___restrict__] = ACTIONS(1159),
    [anon_sym__Atomic] = ACTIONS(1159),
    [anon_sym__Noreturn] = ACTIONS(1159),
    [anon_sym_noreturn] = ACTIONS(1159),
    [anon_sym_alignas] = ACTIONS(1159),
    [anon_sym__Alignas] = ACTIONS(1159),
    [sym_primitive_type] = ACTIONS(1159),
    [anon_sym_enum] = ACTIONS(1159),
    [anon_sym_struct] = ACTIONS(1159),
    [anon_sym_union] = ACTIONS(1159),
    [anon_sym_if] = ACTIONS(1159),
    [anon_sym_else] = ACTIONS(1159),
    [anon_sym_switch] = ACTIONS(1159),
    [anon_sym_case] = ACTIONS(1159),
    [anon_sym_default] = ACTIONS(1159),
    [anon_sym_while] = ACTIONS(1159),
    [anon_sym_do] = ACTIONS(1159),
    [anon_sym_for] = ACTIONS(1159),
    [anon_sym_return] = ACTIONS(1159),
    [anon_sym_break] = ACTIONS(1159),
    [anon_sym_continue] = ACTIONS(1159),
    [anon_sym_goto] = ACTIONS(1159),
    [anon_sym___try] = ACTIONS(1159),
    [anon_sym___leave] = ACTIONS(1159),
    [anon_sym_DASH_DASH] = ACTIONS(1161),
    [anon_sym_PLUS_PLUS] = ACTIONS(1161),
    [anon_sym_sizeof] = ACTIONS(1159),
    [anon_sym___alignof__] = ACTIONS(1159),
    [anon_sym___alignof] = ACTIONS(1159),
    [anon_sym__alignof] = ACTIONS(1159),
    [anon_sym_alignof] = ACTIONS(1159),
    [anon_sym__Alignof] = ACTIONS(1159),
    [anon_sym_offsetof] = ACTIONS(1159),
    [anon_sym__Generic] = ACTIONS(1159),
    [anon_sym_asm] = ACTIONS(1159),
    [anon_sym___asm__] = ACTIONS(1159),
    [sym_number_literal] = ACTIONS(1161),
    [anon_sym_L_SQUOTE] = ACTIONS(1161),
    [anon_sym_u_SQUOTE] = ACTIONS(1161),
    [anon_sym_U_SQUOTE] = ACTIONS(1161),
    [anon_sym_u8_SQUOTE] = ACTIONS(1161),
    [anon_sym_SQUOTE] = ACTIONS(1161),
    [anon_sym_L_DQUOTE] = ACTIONS(1161),
    [anon_sym_u_DQUOTE] = ACTIONS(1161),
    [anon_sym_U_DQUOTE] = ACTIONS(1161),
    [anon_sym_u8_DQUOTE] = ACTIONS(1161),
    [anon_sym_DQUOTE] = ACTIONS(1161),
    [sym_true] = ACTIONS(1159),
    [sym_false] = ACTIONS(1159),
    [anon_sym_NULL] = ACTIONS(1159),
    [anon_sym_nullptr] = ACTIONS(1159),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [sym_identifier] = ACTIONS(1163),
    [aux_sym_preproc_include_token1] = ACTIONS(1163),
    [aux_sym_preproc_def_token1] = ACTIONS(1163),
    [aux_sym_preproc_if_token1] = ACTIONS(1163),
    [aux_sym_preproc_if_token2] = ACTIONS(1163),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1163),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1163),
    [aux_sym_preproc_else_token1] = ACTIONS(1163),
    [aux_sym_preproc_elif_token1] = ACTIONS(1163),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1163),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1163),
    [sym_preproc_directive] = ACTIONS(1163),
    [anon_sym_LPAREN2] = ACTIONS(1165),
    [anon_sym_BANG] = ACTIONS(1165),
    [anon_sym_TILDE] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1163),
    [anon_sym_PLUS] = ACTIONS(1163),
    [anon_sym_STAR] = ACTIONS(1165),
    [anon_sym_AMP] = ACTIONS(1165),
    [anon_sym_SEMI] = ACTIONS(1165),
    [anon_sym___extension__] = ACTIONS(1163),
    [anon_sym_typedef] = ACTIONS(1163),
    [anon_sym_extern] = ACTIONS(1163),
    [anon_sym___attribute__] = ACTIONS(1163),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1165),
    [anon_sym___declspec] = ACTIONS(1163),
    [anon_sym___cdecl] = ACTIONS(1163),
    [anon_sym___clrcall] = ACTIONS(1163),
    [anon_sym___stdcall] = ACTIONS(1163),
    [anon_sym___fastcall] = ACTIONS(1163),
    [anon_sym___thiscall] = ACTIONS(1163),
    [anon_sym___vectorcall] = ACTIONS(1163),
    [anon_sym_LBRACE] = ACTIONS(1165),
    [anon_sym_signed] = ACTIONS(1163),
    [anon_sym_unsigned] = ACTIONS(1163),
    [anon_sym_long] = ACTIONS(1163),
    [anon_sym_short] = ACTIONS(1163),
    [anon_sym_static] = ACTIONS(1163),
    [anon_sym_auto] = ACTIONS(1163),
    [anon_sym_register] = ACTIONS(1163),
    [anon_sym_inline] = ACTIONS(1163),
    [anon_sym___inline] = ACTIONS(1163),
    [anon_sym___inline__] = ACTIONS(1163),
    [anon_sym___forceinline] = ACTIONS(1163),
    [anon_sym_thread_local] = ACTIONS(1163),
    [anon_sym___thread] = ACTIONS(1163),
    [anon_sym_const] = ACTIONS(1163),
    [anon_sym_constexpr] = ACTIONS(1163),
    [anon_sym_volatile] = ACTIONS(1163),
    [anon_sym_restrict] = ACTIONS(1163),
    [anon_sym___restrict__] = ACTIONS(1163),
    [anon_sym__Atomic] = ACTIONS(1163),
    [anon_sym__Noreturn] = ACTIONS(1163),
    [anon_sym_noreturn] = ACTIONS(1163),
    [anon_sym_alignas] = ACTIONS(1163),
    [anon_sym__Alignas] = ACTIONS(1163),
    [sym_primitive_type] = ACTIONS(1163),
    [anon_sym_enum] = ACTIONS(1163),
    [anon_sym_struct] = ACTIONS(1163),
    [anon_sym_union] = ACTIONS(1163),
    [anon_sym_if] = ACTIONS(1163),
    [anon_sym_else] = ACTIONS(1163),
    [anon_sym_switch] = ACTIONS(1163),
    [anon_sym_case] = ACTIONS(1163),
    [anon_sym_default] = ACTIONS(1163),
    [anon_sym_while] = ACTIONS(1163),
    [anon_sym_do] = ACTIONS(1163),
    [anon_sym_for] = ACTIONS(1163),
    [anon_sym_return] = ACTIONS(1163),
    [anon_sym_break] = ACTIONS(1163),
    [anon_sym_continue] = ACTIONS(1163),
    [anon_sym_goto] = ACTIONS(1163),
    [anon_sym___try] = ACTIONS(1163),
    [anon_sym___leave] = ACTIONS(1163),
    [anon_sym_DASH_DASH] = ACTIONS(1165),
    [anon_sym_PLUS_PLUS] = ACTIONS(1165),
    [anon_sym_sizeof] = ACTIONS(1163),
    [anon_sym___alignof__] = ACTIONS(1163),
    [anon_sym___alignof] = ACTIONS(1163),
    [anon_sym__alignof] = ACTIONS(1163),
    [anon_sym_alignof] = ACTIONS(1163),
    [anon_sym__Alignof] = ACTIONS(1163),
    [anon_sym_offsetof] = ACTIONS(1163),
    [anon_sym__Generic] = ACTIONS(1163),
    [anon_sym_asm] = ACTIONS(1163),
    [anon_sym___asm__] = ACTIONS(1163),
    [sym_number_literal] = ACTIONS(1165),
    [anon_sym_L_SQUOTE] = ACTIONS(1165),
    [anon_sym_u_SQUOTE] = ACTIONS(1165),
    [anon_sym_U_SQUOTE] = ACTIONS(1165),
    [anon_sym_u8_SQUOTE] = ACTIONS(1165),
    [anon_sym_SQUOTE] = ACTIONS(1165),
    [anon_sym_L_DQUOTE] = ACTIONS(1165),
    [anon_sym_u_DQUOTE] = ACTIONS(1165),
    [anon_sym_U_DQUOTE] = ACTIONS(1165),
    [anon_sym_u8_DQUOTE] = ACTIONS(1165),
    [anon_sym_DQUOTE] = ACTIONS(1165),
    [sym_true] = ACTIONS(1163),
    [sym_false] = ACTIONS(1163),
    [anon_sym_NULL] = ACTIONS(1163),
    [anon_sym_nullptr] = ACTIONS(1163),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [sym_identifier] = ACTIONS(1167),
    [aux_sym_preproc_include_token1] = ACTIONS(1167),
    [aux_sym_preproc_def_token1] = ACTIONS(1167),
    [aux_sym_preproc_if_token1] = ACTIONS(1167),
    [aux_sym_preproc_if_token2] = ACTIONS(1167),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1167),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1167),
    [aux_sym_preproc_else_token1] = ACTIONS(1167),
    [aux_sym_preproc_elif_token1] = ACTIONS(1167),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1167),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1167),
    [sym_preproc_directive] = ACTIONS(1167),
    [anon_sym_LPAREN2] = ACTIONS(1169),
    [anon_sym_BANG] = ACTIONS(1169),
    [anon_sym_TILDE] = ACTIONS(1169),
    [anon_sym_DASH] = ACTIONS(1167),
    [anon_sym_PLUS] = ACTIONS(1167),
    [anon_sym_STAR] = ACTIONS(1169),
    [anon_sym_AMP] = ACTIONS(1169),
    [anon_sym_SEMI] = ACTIONS(1169),
    [anon_sym___extension__] = ACTIONS(1167),
    [anon_sym_typedef] = ACTIONS(1167),
    [anon_sym_extern] = ACTIONS(1167),
    [anon_sym___attribute__] = ACTIONS(1167),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1169),
    [anon_sym___declspec] = ACTIONS(1167),
    [anon_sym___cdecl] = ACTIONS(1167),
    [anon_sym___clrcall] = ACTIONS(1167),
    [anon_sym___stdcall] = ACTIONS(1167),
    [anon_sym___fastcall] = ACTIONS(1167),
    [anon_sym___thiscall] = ACTIONS(1167),
    [anon_sym___vectorcall] = ACTIONS(1167),
    [anon_sym_LBRACE] = ACTIONS(1169),
    [anon_sym_signed] = ACTIONS(1167),
    [anon_sym_unsigned] = ACTIONS(1167),
    [anon_sym_long] = ACTIONS(1167),
    [anon_sym_short] = ACTIONS(1167),
    [anon_sym_static] = ACTIONS(1167),
    [anon_sym_auto] = ACTIONS(1167),
    [anon_sym_register] = ACTIONS(1167),
    [anon_sym_inline] = ACTIONS(1167),
    [anon_sym___inline] = ACTIONS(1167),
    [anon_sym___inline__] = ACTIONS(1167),
    [anon_sym___forceinline] = ACTIONS(1167),
    [anon_sym_thread_local] = ACTIONS(1167),
    [anon_sym___thread] = ACTIONS(1167),
    [anon_sym_const] = ACTIONS(1167),
    [anon_sym_constexpr] = ACTIONS(1167),
    [anon_sym_volatile] = ACTIONS(1167),
    [anon_sym_restrict] = ACTIONS(1167),
    [anon_sym___restrict__] = ACTIONS(1167),
    [anon_sym__Atomic] = ACTIONS(1167),
    [anon_sym__Noreturn] = ACTIONS(1167),
    [anon_sym_noreturn] = ACTIONS(1167),
    [anon_sym_alignas] = ACTIONS(1167),
    [anon_sym__Alignas] = ACTIONS(1167),
    [sym_primitive_type] = ACTIONS(1167),
    [anon_sym_enum] = ACTIONS(1167),
    [anon_sym_struct] = ACTIONS(1167),
    [anon_sym_union] = ACTIONS(1167),
    [anon_sym_if] = ACTIONS(1167),
    [anon_sym_else] = ACTIONS(1167),
    [anon_sym_switch] = ACTIONS(1167),
    [anon_sym_case] = ACTIONS(1167),
    [anon_sym_default] = ACTIONS(1167),
    [anon_sym_while] = ACTIONS(1167),
    [anon_sym_do] = ACTIONS(1167),
    [anon_sym_for] = ACTIONS(1167),
    [anon_sym_return] = ACTIONS(1167),
    [anon_sym_break] = ACTIONS(1167),
    [anon_sym_continue] = ACTIONS(1167),
    [anon_sym_goto] = ACTIONS(1167),
    [anon_sym___try] = ACTIONS(1167),
    [anon_sym___leave] = ACTIONS(1167),
    [anon_sym_DASH_DASH] = ACTIONS(1169),
    [anon_sym_PLUS_PLUS] = ACTIONS(1169),
    [anon_sym_sizeof] = ACTIONS(1167),
    [anon_sym___alignof__] = ACTIONS(1167),
    [anon_sym___alignof] = ACTIONS(1167),
    [anon_sym__alignof] = ACTIONS(1167),
    [anon_sym_alignof] = ACTIONS(1167),
    [anon_sym__Alignof] = ACTIONS(1167),
    [anon_sym_offsetof] = ACTIONS(1167),
    [anon_sym__Generic] = ACTIONS(1167),
    [anon_sym_asm] = ACTIONS(1167),
    [anon_sym___asm__] = ACTIONS(1167),
    [sym_number_literal] = ACTIONS(1169),
    [anon_sym_L_SQUOTE] = ACTIONS(1169),
    [anon_sym_u_SQUOTE] = ACTIONS(1169),
    [anon_sym_U_SQUOTE] = ACTIONS(1169),
    [anon_sym_u8_SQUOTE] = ACTIONS(1169),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [anon_sym_L_DQUOTE] = ACTIONS(1169),
    [anon_sym_u_DQUOTE] = ACTIONS(1169),
    [anon_sym_U_DQUOTE] = ACTIONS(1169),
    [anon_sym_u8_DQUOTE] = ACTIONS(1169),
    [anon_sym_DQUOTE] = ACTIONS(1169),
    [sym_true] = ACTIONS(1167),
    [sym_false] = ACTIONS(1167),
    [anon_sym_NULL] = ACTIONS(1167),
    [anon_sym_nullptr] = ACTIONS(1167),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_identifier] = ACTIONS(1171),
    [aux_sym_preproc_include_token1] = ACTIONS(1171),
    [aux_sym_preproc_def_token1] = ACTIONS(1171),
    [aux_sym_preproc_if_token1] = ACTIONS(1171),
    [aux_sym_preproc_if_token2] = ACTIONS(1171),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1171),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1171),
    [aux_sym_preproc_else_token1] = ACTIONS(1171),
    [aux_sym_preproc_elif_token1] = ACTIONS(1171),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1171),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1171),
    [sym_preproc_directive] = ACTIONS(1171),
    [anon_sym_LPAREN2] = ACTIONS(1173),
    [anon_sym_BANG] = ACTIONS(1173),
    [anon_sym_TILDE] = ACTIONS(1173),
    [anon_sym_DASH] = ACTIONS(1171),
    [anon_sym_PLUS] = ACTIONS(1171),
    [anon_sym_STAR] = ACTIONS(1173),
    [anon_sym_AMP] = ACTIONS(1173),
    [anon_sym_SEMI] = ACTIONS(1173),
    [anon_sym___extension__] = ACTIONS(1171),
    [anon_sym_typedef] = ACTIONS(1171),
    [anon_sym_extern] = ACTIONS(1171),
    [anon_sym___attribute__] = ACTIONS(1171),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1173),
    [anon_sym___declspec] = ACTIONS(1171),
    [anon_sym___cdecl] = ACTIONS(1171),
    [anon_sym___clrcall] = ACTIONS(1171),
    [anon_sym___stdcall] = ACTIONS(1171),
    [anon_sym___fastcall] = ACTIONS(1171),
    [anon_sym___thiscall] = ACTIONS(1171),
    [anon_sym___vectorcall] = ACTIONS(1171),
    [anon_sym_LBRACE] = ACTIONS(1173),
    [anon_sym_signed] = ACTIONS(1171),
    [anon_sym_unsigned] = ACTIONS(1171),
    [anon_sym_long] = ACTIONS(1171),
    [anon_sym_short] = ACTIONS(1171),
    [anon_sym_static] = ACTIONS(1171),
    [anon_sym_auto] = ACTIONS(1171),
    [anon_sym_register] = ACTIONS(1171),
    [anon_sym_inline] = ACTIONS(1171),
    [anon_sym___inline] = ACTIONS(1171),
    [anon_sym___inline__] = ACTIONS(1171),
    [anon_sym___forceinline] = ACTIONS(1171),
    [anon_sym_thread_local] = ACTIONS(1171),
    [anon_sym___thread] = ACTIONS(1171),
    [anon_sym_const] = ACTIONS(1171),
    [anon_sym_constexpr] = ACTIONS(1171),
    [anon_sym_volatile] = ACTIONS(1171),
    [anon_sym_restrict] = ACTIONS(1171),
    [anon_sym___restrict__] = ACTIONS(1171),
    [anon_sym__Atomic] = ACTIONS(1171),
    [anon_sym__Noreturn] = ACTIONS(1171),
    [anon_sym_noreturn] = ACTIONS(1171),
    [anon_sym_alignas] = ACTIONS(1171),
    [anon_sym__Alignas] = ACTIONS(1171),
    [sym_primitive_type] = ACTIONS(1171),
    [anon_sym_enum] = ACTIONS(1171),
    [anon_sym_struct] = ACTIONS(1171),
    [anon_sym_union] = ACTIONS(1171),
    [anon_sym_if] = ACTIONS(1171),
    [anon_sym_else] = ACTIONS(1171),
    [anon_sym_switch] = ACTIONS(1171),
    [anon_sym_case] = ACTIONS(1171),
    [anon_sym_default] = ACTIONS(1171),
    [anon_sym_while] = ACTIONS(1171),
    [anon_sym_do] = ACTIONS(1171),
    [anon_sym_for] = ACTIONS(1171),
    [anon_sym_return] = ACTIONS(1171),
    [anon_sym_break] = ACTIONS(1171),
    [anon_sym_continue] = ACTIONS(1171),
    [anon_sym_goto] = ACTIONS(1171),
    [anon_sym___try] = ACTIONS(1171),
    [anon_sym___leave] = ACTIONS(1171),
    [anon_sym_DASH_DASH] = ACTIONS(1173),
    [anon_sym_PLUS_PLUS] = ACTIONS(1173),
    [anon_sym_sizeof] = ACTIONS(1171),
    [anon_sym___alignof__] = ACTIONS(1171),
    [anon_sym___alignof] = ACTIONS(1171),
    [anon_sym__alignof] = ACTIONS(1171),
    [anon_sym_alignof] = ACTIONS(1171),
    [anon_sym__Alignof] = ACTIONS(1171),
    [anon_sym_offsetof] = ACTIONS(1171),
    [anon_sym__Generic] = ACTIONS(1171),
    [anon_sym_asm] = ACTIONS(1171),
    [anon_sym___asm__] = ACTIONS(1171),
    [sym_number_literal] = ACTIONS(1173),
    [anon_sym_L_SQUOTE] = ACTIONS(1173),
    [anon_sym_u_SQUOTE] = ACTIONS(1173),
    [anon_sym_U_SQUOTE] = ACTIONS(1173),
    [anon_sym_u8_SQUOTE] = ACTIONS(1173),
    [anon_sym_SQUOTE] = ACTIONS(1173),
    [anon_sym_L_DQUOTE] = ACTIONS(1173),
    [anon_sym_u_DQUOTE] = ACTIONS(1173),
    [anon_sym_U_DQUOTE] = ACTIONS(1173),
    [anon_sym_u8_DQUOTE] = ACTIONS(1173),
    [anon_sym_DQUOTE] = ACTIONS(1173),
    [sym_true] = ACTIONS(1171),
    [sym_false] = ACTIONS(1171),
    [anon_sym_NULL] = ACTIONS(1171),
    [anon_sym_nullptr] = ACTIONS(1171),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [sym_identifier] = ACTIONS(1175),
    [aux_sym_preproc_include_token1] = ACTIONS(1175),
    [aux_sym_preproc_def_token1] = ACTIONS(1175),
    [aux_sym_preproc_if_token1] = ACTIONS(1175),
    [aux_sym_preproc_if_token2] = ACTIONS(1175),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1175),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1175),
    [aux_sym_preproc_else_token1] = ACTIONS(1175),
    [aux_sym_preproc_elif_token1] = ACTIONS(1175),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1175),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1175),
    [sym_preproc_directive] = ACTIONS(1175),
    [anon_sym_LPAREN2] = ACTIONS(1177),
    [anon_sym_BANG] = ACTIONS(1177),
    [anon_sym_TILDE] = ACTIONS(1177),
    [anon_sym_DASH] = ACTIONS(1175),
    [anon_sym_PLUS] = ACTIONS(1175),
    [anon_sym_STAR] = ACTIONS(1177),
    [anon_sym_AMP] = ACTIONS(1177),
    [anon_sym_SEMI] = ACTIONS(1177),
    [anon_sym___extension__] = ACTIONS(1175),
    [anon_sym_typedef] = ACTIONS(1175),
    [anon_sym_extern] = ACTIONS(1175),
    [anon_sym___attribute__] = ACTIONS(1175),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1177),
    [anon_sym___declspec] = ACTIONS(1175),
    [anon_sym___cdecl] = ACTIONS(1175),
    [anon_sym___clrcall] = ACTIONS(1175),
    [anon_sym___stdcall] = ACTIONS(1175),
    [anon_sym___fastcall] = ACTIONS(1175),
    [anon_sym___thiscall] = ACTIONS(1175),
    [anon_sym___vectorcall] = ACTIONS(1175),
    [anon_sym_LBRACE] = ACTIONS(1177),
    [anon_sym_signed] = ACTIONS(1175),
    [anon_sym_unsigned] = ACTIONS(1175),
    [anon_sym_long] = ACTIONS(1175),
    [anon_sym_short] = ACTIONS(1175),
    [anon_sym_static] = ACTIONS(1175),
    [anon_sym_auto] = ACTIONS(1175),
    [anon_sym_register] = ACTIONS(1175),
    [anon_sym_inline] = ACTIONS(1175),
    [anon_sym___inline] = ACTIONS(1175),
    [anon_sym___inline__] = ACTIONS(1175),
    [anon_sym___forceinline] = ACTIONS(1175),
    [anon_sym_thread_local] = ACTIONS(1175),
    [anon_sym___thread] = ACTIONS(1175),
    [anon_sym_const] = ACTIONS(1175),
    [anon_sym_constexpr] = ACTIONS(1175),
    [anon_sym_volatile] = ACTIONS(1175),
    [anon_sym_restrict] = ACTIONS(1175),
    [anon_sym___restrict__] = ACTIONS(1175),
    [anon_sym__Atomic] = ACTIONS(1175),
    [anon_sym__Noreturn] = ACTIONS(1175),
    [anon_sym_noreturn] = ACTIONS(1175),
    [anon_sym_alignas] = ACTIONS(1175),
    [anon_sym__Alignas] = ACTIONS(1175),
    [sym_primitive_type] = ACTIONS(1175),
    [anon_sym_enum] = ACTIONS(1175),
    [anon_sym_struct] = ACTIONS(1175),
    [anon_sym_union] = ACTIONS(1175),
    [anon_sym_if] = ACTIONS(1175),
    [anon_sym_else] = ACTIONS(1175),
    [anon_sym_switch] = ACTIONS(1175),
    [anon_sym_case] = ACTIONS(1175),
    [anon_sym_default] = ACTIONS(1175),
    [anon_sym_while] = ACTIONS(1175),
    [anon_sym_do] = ACTIONS(1175),
    [anon_sym_for] = ACTIONS(1175),
    [anon_sym_return] = ACTIONS(1175),
    [anon_sym_break] = ACTIONS(1175),
    [anon_sym_continue] = ACTIONS(1175),
    [anon_sym_goto] = ACTIONS(1175),
    [anon_sym___try] = ACTIONS(1175),
    [anon_sym___leave] = ACTIONS(1175),
    [anon_sym_DASH_DASH] = ACTIONS(1177),
    [anon_sym_PLUS_PLUS] = ACTIONS(1177),
    [anon_sym_sizeof] = ACTIONS(1175),
    [anon_sym___alignof__] = ACTIONS(1175),
    [anon_sym___alignof] = ACTIONS(1175),
    [anon_sym__alignof] = ACTIONS(1175),
    [anon_sym_alignof] = ACTIONS(1175),
    [anon_sym__Alignof] = ACTIONS(1175),
    [anon_sym_offsetof] = ACTIONS(1175),
    [anon_sym__Generic] = ACTIONS(1175),
    [anon_sym_asm] = ACTIONS(1175),
    [anon_sym___asm__] = ACTIONS(1175),
    [sym_number_literal] = ACTIONS(1177),
    [anon_sym_L_SQUOTE] = ACTIONS(1177),
    [anon_sym_u_SQUOTE] = ACTIONS(1177),
    [anon_sym_U_SQUOTE] = ACTIONS(1177),
    [anon_sym_u8_SQUOTE] = ACTIONS(1177),
    [anon_sym_SQUOTE] = ACTIONS(1177),
    [anon_sym_L_DQUOTE] = ACTIONS(1177),
    [anon_sym_u_DQUOTE] = ACTIONS(1177),
    [anon_sym_U_DQUOTE] = ACTIONS(1177),
    [anon_sym_u8_DQUOTE] = ACTIONS(1177),
    [anon_sym_DQUOTE] = ACTIONS(1177),
    [sym_true] = ACTIONS(1175),
    [sym_false] = ACTIONS(1175),
    [anon_sym_NULL] = ACTIONS(1175),
    [anon_sym_nullptr] = ACTIONS(1175),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_identifier] = ACTIONS(1179),
    [aux_sym_preproc_include_token1] = ACTIONS(1179),
    [aux_sym_preproc_def_token1] = ACTIONS(1179),
    [aux_sym_preproc_if_token1] = ACTIONS(1179),
    [aux_sym_preproc_if_token2] = ACTIONS(1179),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1179),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1179),
    [aux_sym_preproc_else_token1] = ACTIONS(1179),
    [aux_sym_preproc_elif_token1] = ACTIONS(1179),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1179),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1179),
    [sym_preproc_directive] = ACTIONS(1179),
    [anon_sym_LPAREN2] = ACTIONS(1181),
    [anon_sym_BANG] = ACTIONS(1181),
    [anon_sym_TILDE] = ACTIONS(1181),
    [anon_sym_DASH] = ACTIONS(1179),
    [anon_sym_PLUS] = ACTIONS(1179),
    [anon_sym_STAR] = ACTIONS(1181),
    [anon_sym_AMP] = ACTIONS(1181),
    [anon_sym_SEMI] = ACTIONS(1181),
    [anon_sym___extension__] = ACTIONS(1179),
    [anon_sym_typedef] = ACTIONS(1179),
    [anon_sym_extern] = ACTIONS(1179),
    [anon_sym___attribute__] = ACTIONS(1179),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1181),
    [anon_sym___declspec] = ACTIONS(1179),
    [anon_sym___cdecl] = ACTIONS(1179),
    [anon_sym___clrcall] = ACTIONS(1179),
    [anon_sym___stdcall] = ACTIONS(1179),
    [anon_sym___fastcall] = ACTIONS(1179),
    [anon_sym___thiscall] = ACTIONS(1179),
    [anon_sym___vectorcall] = ACTIONS(1179),
    [anon_sym_LBRACE] = ACTIONS(1181),
    [anon_sym_signed] = ACTIONS(1179),
    [anon_sym_unsigned] = ACTIONS(1179),
    [anon_sym_long] = ACTIONS(1179),
    [anon_sym_short] = ACTIONS(1179),
    [anon_sym_static] = ACTIONS(1179),
    [anon_sym_auto] = ACTIONS(1179),
    [anon_sym_register] = ACTIONS(1179),
    [anon_sym_inline] = ACTIONS(1179),
    [anon_sym___inline] = ACTIONS(1179),
    [anon_sym___inline__] = ACTIONS(1179),
    [anon_sym___forceinline] = ACTIONS(1179),
    [anon_sym_thread_local] = ACTIONS(1179),
    [anon_sym___thread] = ACTIONS(1179),
    [anon_sym_const] = ACTIONS(1179),
    [anon_sym_constexpr] = ACTIONS(1179),
    [anon_sym_volatile] = ACTIONS(1179),
    [anon_sym_restrict] = ACTIONS(1179),
    [anon_sym___restrict__] = ACTIONS(1179),
    [anon_sym__Atomic] = ACTIONS(1179),
    [anon_sym__Noreturn] = ACTIONS(1179),
    [anon_sym_noreturn] = ACTIONS(1179),
    [anon_sym_alignas] = ACTIONS(1179),
    [anon_sym__Alignas] = ACTIONS(1179),
    [sym_primitive_type] = ACTIONS(1179),
    [anon_sym_enum] = ACTIONS(1179),
    [anon_sym_struct] = ACTIONS(1179),
    [anon_sym_union] = ACTIONS(1179),
    [anon_sym_if] = ACTIONS(1179),
    [anon_sym_else] = ACTIONS(1179),
    [anon_sym_switch] = ACTIONS(1179),
    [anon_sym_case] = ACTIONS(1179),
    [anon_sym_default] = ACTIONS(1179),
    [anon_sym_while] = ACTIONS(1179),
    [anon_sym_do] = ACTIONS(1179),
    [anon_sym_for] = ACTIONS(1179),
    [anon_sym_return] = ACTIONS(1179),
    [anon_sym_break] = ACTIONS(1179),
    [anon_sym_continue] = ACTIONS(1179),
    [anon_sym_goto] = ACTIONS(1179),
    [anon_sym___try] = ACTIONS(1179),
    [anon_sym___leave] = ACTIONS(1179),
    [anon_sym_DASH_DASH] = ACTIONS(1181),
    [anon_sym_PLUS_PLUS] = ACTIONS(1181),
    [anon_sym_sizeof] = ACTIONS(1179),
    [anon_sym___alignof__] = ACTIONS(1179),
    [anon_sym___alignof] = ACTIONS(1179),
    [anon_sym__alignof] = ACTIONS(1179),
    [anon_sym_alignof] = ACTIONS(1179),
    [anon_sym__Alignof] = ACTIONS(1179),
    [anon_sym_offsetof] = ACTIONS(1179),
    [anon_sym__Generic] = ACTIONS(1179),
    [anon_sym_asm] = ACTIONS(1179),
    [anon_sym___asm__] = ACTIONS(1179),
    [sym_number_literal] = ACTIONS(1181),
    [anon_sym_L_SQUOTE] = ACTIONS(1181),
    [anon_sym_u_SQUOTE] = ACTIONS(1181),
    [anon_sym_U_SQUOTE] = ACTIONS(1181),
    [anon_sym_u8_SQUOTE] = ACTIONS(1181),
    [anon_sym_SQUOTE] = ACTIONS(1181),
    [anon_sym_L_DQUOTE] = ACTIONS(1181),
    [anon_sym_u_DQUOTE] = ACTIONS(1181),
    [anon_sym_U_DQUOTE] = ACTIONS(1181),
    [anon_sym_u8_DQUOTE] = ACTIONS(1181),
    [anon_sym_DQUOTE] = ACTIONS(1181),
    [sym_true] = ACTIONS(1179),
    [sym_false] = ACTIONS(1179),
    [anon_sym_NULL] = ACTIONS(1179),
    [anon_sym_nullptr] = ACTIONS(1179),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [sym_identifier] = ACTIONS(1183),
    [aux_sym_preproc_include_token1] = ACTIONS(1183),
    [aux_sym_preproc_def_token1] = ACTIONS(1183),
    [aux_sym_preproc_if_token1] = ACTIONS(1183),
    [aux_sym_preproc_if_token2] = ACTIONS(1183),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1183),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1183),
    [aux_sym_preproc_else_token1] = ACTIONS(1183),
    [aux_sym_preproc_elif_token1] = ACTIONS(1183),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1183),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1183),
    [sym_preproc_directive] = ACTIONS(1183),
    [anon_sym_LPAREN2] = ACTIONS(1185),
    [anon_sym_BANG] = ACTIONS(1185),
    [anon_sym_TILDE] = ACTIONS(1185),
    [anon_sym_DASH] = ACTIONS(1183),
    [anon_sym_PLUS] = ACTIONS(1183),
    [anon_sym_STAR] = ACTIONS(1185),
    [anon_sym_AMP] = ACTIONS(1185),
    [anon_sym_SEMI] = ACTIONS(1185),
    [anon_sym___extension__] = ACTIONS(1183),
    [anon_sym_typedef] = ACTIONS(1183),
    [anon_sym_extern] = ACTIONS(1183),
    [anon_sym___attribute__] = ACTIONS(1183),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1185),
    [anon_sym___declspec] = ACTIONS(1183),
    [anon_sym___cdecl] = ACTIONS(1183),
    [anon_sym___clrcall] = ACTIONS(1183),
    [anon_sym___stdcall] = ACTIONS(1183),
    [anon_sym___fastcall] = ACTIONS(1183),
    [anon_sym___thiscall] = ACTIONS(1183),
    [anon_sym___vectorcall] = ACTIONS(1183),
    [anon_sym_LBRACE] = ACTIONS(1185),
    [anon_sym_signed] = ACTIONS(1183),
    [anon_sym_unsigned] = ACTIONS(1183),
    [anon_sym_long] = ACTIONS(1183),
    [anon_sym_short] = ACTIONS(1183),
    [anon_sym_static] = ACTIONS(1183),
    [anon_sym_auto] = ACTIONS(1183),
    [anon_sym_register] = ACTIONS(1183),
    [anon_sym_inline] = ACTIONS(1183),
    [anon_sym___inline] = ACTIONS(1183),
    [anon_sym___inline__] = ACTIONS(1183),
    [anon_sym___forceinline] = ACTIONS(1183),
    [anon_sym_thread_local] = ACTIONS(1183),
    [anon_sym___thread] = ACTIONS(1183),
    [anon_sym_const] = ACTIONS(1183),
    [anon_sym_constexpr] = ACTIONS(1183),
    [anon_sym_volatile] = ACTIONS(1183),
    [anon_sym_restrict] = ACTIONS(1183),
    [anon_sym___restrict__] = ACTIONS(1183),
    [anon_sym__Atomic] = ACTIONS(1183),
    [anon_sym__Noreturn] = ACTIONS(1183),
    [anon_sym_noreturn] = ACTIONS(1183),
    [anon_sym_alignas] = ACTIONS(1183),
    [anon_sym__Alignas] = ACTIONS(1183),
    [sym_primitive_type] = ACTIONS(1183),
    [anon_sym_enum] = ACTIONS(1183),
    [anon_sym_struct] = ACTIONS(1183),
    [anon_sym_union] = ACTIONS(1183),
    [anon_sym_if] = ACTIONS(1183),
    [anon_sym_else] = ACTIONS(1183),
    [anon_sym_switch] = ACTIONS(1183),
    [anon_sym_case] = ACTIONS(1183),
    [anon_sym_default] = ACTIONS(1183),
    [anon_sym_while] = ACTIONS(1183),
    [anon_sym_do] = ACTIONS(1183),
    [anon_sym_for] = ACTIONS(1183),
    [anon_sym_return] = ACTIONS(1183),
    [anon_sym_break] = ACTIONS(1183),
    [anon_sym_continue] = ACTIONS(1183),
    [anon_sym_goto] = ACTIONS(1183),
    [anon_sym___try] = ACTIONS(1183),
    [anon_sym___leave] = ACTIONS(1183),
    [anon_sym_DASH_DASH] = ACTIONS(1185),
    [anon_sym_PLUS_PLUS] = ACTIONS(1185),
    [anon_sym_sizeof] = ACTIONS(1183),
    [anon_sym___alignof__] = ACTIONS(1183),
    [anon_sym___alignof] = ACTIONS(1183),
    [anon_sym__alignof] = ACTIONS(1183),
    [anon_sym_alignof] = ACTIONS(1183),
    [anon_sym__Alignof] = ACTIONS(1183),
    [anon_sym_offsetof] = ACTIONS(1183),
    [anon_sym__Generic] = ACTIONS(1183),
    [anon_sym_asm] = ACTIONS(1183),
    [anon_sym___asm__] = ACTIONS(1183),
    [sym_number_literal] = ACTIONS(1185),
    [anon_sym_L_SQUOTE] = ACTIONS(1185),
    [anon_sym_u_SQUOTE] = ACTIONS(1185),
    [anon_sym_U_SQUOTE] = ACTIONS(1185),
    [anon_sym_u8_SQUOTE] = ACTIONS(1185),
    [anon_sym_SQUOTE] = ACTIONS(1185),
    [anon_sym_L_DQUOTE] = ACTIONS(1185),
    [anon_sym_u_DQUOTE] = ACTIONS(1185),
    [anon_sym_U_DQUOTE] = ACTIONS(1185),
    [anon_sym_u8_DQUOTE] = ACTIONS(1185),
    [anon_sym_DQUOTE] = ACTIONS(1185),
    [sym_true] = ACTIONS(1183),
    [sym_false] = ACTIONS(1183),
    [anon_sym_NULL] = ACTIONS(1183),
    [anon_sym_nullptr] = ACTIONS(1183),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [sym_identifier] = ACTIONS(1187),
    [aux_sym_preproc_include_token1] = ACTIONS(1187),
    [aux_sym_preproc_def_token1] = ACTIONS(1187),
    [aux_sym_preproc_if_token1] = ACTIONS(1187),
    [aux_sym_preproc_if_token2] = ACTIONS(1187),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1187),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1187),
    [aux_sym_preproc_else_token1] = ACTIONS(1187),
    [aux_sym_preproc_elif_token1] = ACTIONS(1187),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1187),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1187),
    [sym_preproc_directive] = ACTIONS(1187),
    [anon_sym_LPAREN2] = ACTIONS(1189),
    [anon_sym_BANG] = ACTIONS(1189),
    [anon_sym_TILDE] = ACTIONS(1189),
    [anon_sym_DASH] = ACTIONS(1187),
    [anon_sym_PLUS] = ACTIONS(1187),
    [anon_sym_STAR] = ACTIONS(1189),
    [anon_sym_AMP] = ACTIONS(1189),
    [anon_sym_SEMI] = ACTIONS(1189),
    [anon_sym___extension__] = ACTIONS(1187),
    [anon_sym_typedef] = ACTIONS(1187),
    [anon_sym_extern] = ACTIONS(1187),
    [anon_sym___attribute__] = ACTIONS(1187),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1189),
    [anon_sym___declspec] = ACTIONS(1187),
    [anon_sym___cdecl] = ACTIONS(1187),
    [anon_sym___clrcall] = ACTIONS(1187),
    [anon_sym___stdcall] = ACTIONS(1187),
    [anon_sym___fastcall] = ACTIONS(1187),
    [anon_sym___thiscall] = ACTIONS(1187),
    [anon_sym___vectorcall] = ACTIONS(1187),
    [anon_sym_LBRACE] = ACTIONS(1189),
    [anon_sym_signed] = ACTIONS(1187),
    [anon_sym_unsigned] = ACTIONS(1187),
    [anon_sym_long] = ACTIONS(1187),
    [anon_sym_short] = ACTIONS(1187),
    [anon_sym_static] = ACTIONS(1187),
    [anon_sym_auto] = ACTIONS(1187),
    [anon_sym_register] = ACTIONS(1187),
    [anon_sym_inline] = ACTIONS(1187),
    [anon_sym___inline] = ACTIONS(1187),
    [anon_sym___inline__] = ACTIONS(1187),
    [anon_sym___forceinline] = ACTIONS(1187),
    [anon_sym_thread_local] = ACTIONS(1187),
    [anon_sym___thread] = ACTIONS(1187),
    [anon_sym_const] = ACTIONS(1187),
    [anon_sym_constexpr] = ACTIONS(1187),
    [anon_sym_volatile] = ACTIONS(1187),
    [anon_sym_restrict] = ACTIONS(1187),
    [anon_sym___restrict__] = ACTIONS(1187),
    [anon_sym__Atomic] = ACTIONS(1187),
    [anon_sym__Noreturn] = ACTIONS(1187),
    [anon_sym_noreturn] = ACTIONS(1187),
    [anon_sym_alignas] = ACTIONS(1187),
    [anon_sym__Alignas] = ACTIONS(1187),
    [sym_primitive_type] = ACTIONS(1187),
    [anon_sym_enum] = ACTIONS(1187),
    [anon_sym_struct] = ACTIONS(1187),
    [anon_sym_union] = ACTIONS(1187),
    [anon_sym_if] = ACTIONS(1187),
    [anon_sym_else] = ACTIONS(1187),
    [anon_sym_switch] = ACTIONS(1187),
    [anon_sym_case] = ACTIONS(1187),
    [anon_sym_default] = ACTIONS(1187),
    [anon_sym_while] = ACTIONS(1187),
    [anon_sym_do] = ACTIONS(1187),
    [anon_sym_for] = ACTIONS(1187),
    [anon_sym_return] = ACTIONS(1187),
    [anon_sym_break] = ACTIONS(1187),
    [anon_sym_continue] = ACTIONS(1187),
    [anon_sym_goto] = ACTIONS(1187),
    [anon_sym___try] = ACTIONS(1187),
    [anon_sym___leave] = ACTIONS(1187),
    [anon_sym_DASH_DASH] = ACTIONS(1189),
    [anon_sym_PLUS_PLUS] = ACTIONS(1189),
    [anon_sym_sizeof] = ACTIONS(1187),
    [anon_sym___alignof__] = ACTIONS(1187),
    [anon_sym___alignof] = ACTIONS(1187),
    [anon_sym__alignof] = ACTIONS(1187),
    [anon_sym_alignof] = ACTIONS(1187),
    [anon_sym__Alignof] = ACTIONS(1187),
    [anon_sym_offsetof] = ACTIONS(1187),
    [anon_sym__Generic] = ACTIONS(1187),
    [anon_sym_asm] = ACTIONS(1187),
    [anon_sym___asm__] = ACTIONS(1187),
    [sym_number_literal] = ACTIONS(1189),
    [anon_sym_L_SQUOTE] = ACTIONS(1189),
    [anon_sym_u_SQUOTE] = ACTIONS(1189),
    [anon_sym_U_SQUOTE] = ACTIONS(1189),
    [anon_sym_u8_SQUOTE] = ACTIONS(1189),
    [anon_sym_SQUOTE] = ACTIONS(1189),
    [anon_sym_L_DQUOTE] = ACTIONS(1189),
    [anon_sym_u_DQUOTE] = ACTIONS(1189),
    [anon_sym_U_DQUOTE] = ACTIONS(1189),
    [anon_sym_u8_DQUOTE] = ACTIONS(1189),
    [anon_sym_DQUOTE] = ACTIONS(1189),
    [sym_true] = ACTIONS(1187),
    [sym_false] = ACTIONS(1187),
    [anon_sym_NULL] = ACTIONS(1187),
    [anon_sym_nullptr] = ACTIONS(1187),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [sym_identifier] = ACTIONS(1191),
    [aux_sym_preproc_include_token1] = ACTIONS(1191),
    [aux_sym_preproc_def_token1] = ACTIONS(1191),
    [aux_sym_preproc_if_token1] = ACTIONS(1191),
    [aux_sym_preproc_if_token2] = ACTIONS(1191),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1191),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1191),
    [aux_sym_preproc_else_token1] = ACTIONS(1191),
    [aux_sym_preproc_elif_token1] = ACTIONS(1191),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1191),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1191),
    [sym_preproc_directive] = ACTIONS(1191),
    [anon_sym_LPAREN2] = ACTIONS(1193),
    [anon_sym_BANG] = ACTIONS(1193),
    [anon_sym_TILDE] = ACTIONS(1193),
    [anon_sym_DASH] = ACTIONS(1191),
    [anon_sym_PLUS] = ACTIONS(1191),
    [anon_sym_STAR] = ACTIONS(1193),
    [anon_sym_AMP] = ACTIONS(1193),
    [anon_sym_SEMI] = ACTIONS(1193),
    [anon_sym___extension__] = ACTIONS(1191),
    [anon_sym_typedef] = ACTIONS(1191),
    [anon_sym_extern] = ACTIONS(1191),
    [anon_sym___attribute__] = ACTIONS(1191),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1193),
    [anon_sym___declspec] = ACTIONS(1191),
    [anon_sym___cdecl] = ACTIONS(1191),
    [anon_sym___clrcall] = ACTIONS(1191),
    [anon_sym___stdcall] = ACTIONS(1191),
    [anon_sym___fastcall] = ACTIONS(1191),
    [anon_sym___thiscall] = ACTIONS(1191),
    [anon_sym___vectorcall] = ACTIONS(1191),
    [anon_sym_LBRACE] = ACTIONS(1193),
    [anon_sym_signed] = ACTIONS(1191),
    [anon_sym_unsigned] = ACTIONS(1191),
    [anon_sym_long] = ACTIONS(1191),
    [anon_sym_short] = ACTIONS(1191),
    [anon_sym_static] = ACTIONS(1191),
    [anon_sym_auto] = ACTIONS(1191),
    [anon_sym_register] = ACTIONS(1191),
    [anon_sym_inline] = ACTIONS(1191),
    [anon_sym___inline] = ACTIONS(1191),
    [anon_sym___inline__] = ACTIONS(1191),
    [anon_sym___forceinline] = ACTIONS(1191),
    [anon_sym_thread_local] = ACTIONS(1191),
    [anon_sym___thread] = ACTIONS(1191),
    [anon_sym_const] = ACTIONS(1191),
    [anon_sym_constexpr] = ACTIONS(1191),
    [anon_sym_volatile] = ACTIONS(1191),
    [anon_sym_restrict] = ACTIONS(1191),
    [anon_sym___restrict__] = ACTIONS(1191),
    [anon_sym__Atomic] = ACTIONS(1191),
    [anon_sym__Noreturn] = ACTIONS(1191),
    [anon_sym_noreturn] = ACTIONS(1191),
    [anon_sym_alignas] = ACTIONS(1191),
    [anon_sym__Alignas] = ACTIONS(1191),
    [sym_primitive_type] = ACTIONS(1191),
    [anon_sym_enum] = ACTIONS(1191),
    [anon_sym_struct] = ACTIONS(1191),
    [anon_sym_union] = ACTIONS(1191),
    [anon_sym_if] = ACTIONS(1191),
    [anon_sym_else] = ACTIONS(1191),
    [anon_sym_switch] = ACTIONS(1191),
    [anon_sym_case] = ACTIONS(1191),
    [anon_sym_default] = ACTIONS(1191),
    [anon_sym_while] = ACTIONS(1191),
    [anon_sym_do] = ACTIONS(1191),
    [anon_sym_for] = ACTIONS(1191),
    [anon_sym_return] = ACTIONS(1191),
    [anon_sym_break] = ACTIONS(1191),
    [anon_sym_continue] = ACTIONS(1191),
    [anon_sym_goto] = ACTIONS(1191),
    [anon_sym___try] = ACTIONS(1191),
    [anon_sym___leave] = ACTIONS(1191),
    [anon_sym_DASH_DASH] = ACTIONS(1193),
    [anon_sym_PLUS_PLUS] = ACTIONS(1193),
    [anon_sym_sizeof] = ACTIONS(1191),
    [anon_sym___alignof__] = ACTIONS(1191),
    [anon_sym___alignof] = ACTIONS(1191),
    [anon_sym__alignof] = ACTIONS(1191),
    [anon_sym_alignof] = ACTIONS(1191),
    [anon_sym__Alignof] = ACTIONS(1191),
    [anon_sym_offsetof] = ACTIONS(1191),
    [anon_sym__Generic] = ACTIONS(1191),
    [anon_sym_asm] = ACTIONS(1191),
    [anon_sym___asm__] = ACTIONS(1191),
    [sym_number_literal] = ACTIONS(1193),
    [anon_sym_L_SQUOTE] = ACTIONS(1193),
    [anon_sym_u_SQUOTE] = ACTIONS(1193),
    [anon_sym_U_SQUOTE] = ACTIONS(1193),
    [anon_sym_u8_SQUOTE] = ACTIONS(1193),
    [anon_sym_SQUOTE] = ACTIONS(1193),
    [anon_sym_L_DQUOTE] = ACTIONS(1193),
    [anon_sym_u_DQUOTE] = ACTIONS(1193),
    [anon_sym_U_DQUOTE] = ACTIONS(1193),
    [anon_sym_u8_DQUOTE] = ACTIONS(1193),
    [anon_sym_DQUOTE] = ACTIONS(1193),
    [sym_true] = ACTIONS(1191),
    [sym_false] = ACTIONS(1191),
    [anon_sym_NULL] = ACTIONS(1191),
    [anon_sym_nullptr] = ACTIONS(1191),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [sym_identifier] = ACTIONS(1195),
    [aux_sym_preproc_include_token1] = ACTIONS(1195),
    [aux_sym_preproc_def_token1] = ACTIONS(1195),
    [aux_sym_preproc_if_token1] = ACTIONS(1195),
    [aux_sym_preproc_if_token2] = ACTIONS(1195),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1195),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1195),
    [aux_sym_preproc_else_token1] = ACTIONS(1195),
    [aux_sym_preproc_elif_token1] = ACTIONS(1195),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1195),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1195),
    [sym_preproc_directive] = ACTIONS(1195),
    [anon_sym_LPAREN2] = ACTIONS(1197),
    [anon_sym_BANG] = ACTIONS(1197),
    [anon_sym_TILDE] = ACTIONS(1197),
    [anon_sym_DASH] = ACTIONS(1195),
    [anon_sym_PLUS] = ACTIONS(1195),
    [anon_sym_STAR] = ACTIONS(1197),
    [anon_sym_AMP] = ACTIONS(1197),
    [anon_sym_SEMI] = ACTIONS(1197),
    [anon_sym___extension__] = ACTIONS(1195),
    [anon_sym_typedef] = ACTIONS(1195),
    [anon_sym_extern] = ACTIONS(1195),
    [anon_sym___attribute__] = ACTIONS(1195),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1197),
    [anon_sym___declspec] = ACTIONS(1195),
    [anon_sym___cdecl] = ACTIONS(1195),
    [anon_sym___clrcall] = ACTIONS(1195),
    [anon_sym___stdcall] = ACTIONS(1195),
    [anon_sym___fastcall] = ACTIONS(1195),
    [anon_sym___thiscall] = ACTIONS(1195),
    [anon_sym___vectorcall] = ACTIONS(1195),
    [anon_sym_LBRACE] = ACTIONS(1197),
    [anon_sym_signed] = ACTIONS(1195),
    [anon_sym_unsigned] = ACTIONS(1195),
    [anon_sym_long] = ACTIONS(1195),
    [anon_sym_short] = ACTIONS(1195),
    [anon_sym_static] = ACTIONS(1195),
    [anon_sym_auto] = ACTIONS(1195),
    [anon_sym_register] = ACTIONS(1195),
    [anon_sym_inline] = ACTIONS(1195),
    [anon_sym___inline] = ACTIONS(1195),
    [anon_sym___inline__] = ACTIONS(1195),
    [anon_sym___forceinline] = ACTIONS(1195),
    [anon_sym_thread_local] = ACTIONS(1195),
    [anon_sym___thread] = ACTIONS(1195),
    [anon_sym_const] = ACTIONS(1195),
    [anon_sym_constexpr] = ACTIONS(1195),
    [anon_sym_volatile] = ACTIONS(1195),
    [anon_sym_restrict] = ACTIONS(1195),
    [anon_sym___restrict__] = ACTIONS(1195),
    [anon_sym__Atomic] = ACTIONS(1195),
    [anon_sym__Noreturn] = ACTIONS(1195),
    [anon_sym_noreturn] = ACTIONS(1195),
    [anon_sym_alignas] = ACTIONS(1195),
    [anon_sym__Alignas] = ACTIONS(1195),
    [sym_primitive_type] = ACTIONS(1195),
    [anon_sym_enum] = ACTIONS(1195),
    [anon_sym_struct] = ACTIONS(1195),
    [anon_sym_union] = ACTIONS(1195),
    [anon_sym_if] = ACTIONS(1195),
    [anon_sym_else] = ACTIONS(1195),
    [anon_sym_switch] = ACTIONS(1195),
    [anon_sym_case] = ACTIONS(1195),
    [anon_sym_default] = ACTIONS(1195),
    [anon_sym_while] = ACTIONS(1195),
    [anon_sym_do] = ACTIONS(1195),
    [anon_sym_for] = ACTIONS(1195),
    [anon_sym_return] = ACTIONS(1195),
    [anon_sym_break] = ACTIONS(1195),
    [anon_sym_continue] = ACTIONS(1195),
    [anon_sym_goto] = ACTIONS(1195),
    [anon_sym___try] = ACTIONS(1195),
    [anon_sym___leave] = ACTIONS(1195),
    [anon_sym_DASH_DASH] = ACTIONS(1197),
    [anon_sym_PLUS_PLUS] = ACTIONS(1197),
    [anon_sym_sizeof] = ACTIONS(1195),
    [anon_sym___alignof__] = ACTIONS(1195),
    [anon_sym___alignof] = ACTIONS(1195),
    [anon_sym__alignof] = ACTIONS(1195),
    [anon_sym_alignof] = ACTIONS(1195),
    [anon_sym__Alignof] = ACTIONS(1195),
    [anon_sym_offsetof] = ACTIONS(1195),
    [anon_sym__Generic] = ACTIONS(1195),
    [anon_sym_asm] = ACTIONS(1195),
    [anon_sym___asm__] = ACTIONS(1195),
    [sym_number_literal] = ACTIONS(1197),
    [anon_sym_L_SQUOTE] = ACTIONS(1197),
    [anon_sym_u_SQUOTE] = ACTIONS(1197),
    [anon_sym_U_SQUOTE] = ACTIONS(1197),
    [anon_sym_u8_SQUOTE] = ACTIONS(1197),
    [anon_sym_SQUOTE] = ACTIONS(1197),
    [anon_sym_L_DQUOTE] = ACTIONS(1197),
    [anon_sym_u_DQUOTE] = ACTIONS(1197),
    [anon_sym_U_DQUOTE] = ACTIONS(1197),
    [anon_sym_u8_DQUOTE] = ACTIONS(1197),
    [anon_sym_DQUOTE] = ACTIONS(1197),
    [sym_true] = ACTIONS(1195),
    [sym_false] = ACTIONS(1195),
    [anon_sym_NULL] = ACTIONS(1195),
    [anon_sym_nullptr] = ACTIONS(1195),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_identifier] = ACTIONS(1199),
    [aux_sym_preproc_include_token1] = ACTIONS(1199),
    [aux_sym_preproc_def_token1] = ACTIONS(1199),
    [aux_sym_preproc_if_token1] = ACTIONS(1199),
    [aux_sym_preproc_if_token2] = ACTIONS(1199),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1199),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1199),
    [aux_sym_preproc_else_token1] = ACTIONS(1199),
    [aux_sym_preproc_elif_token1] = ACTIONS(1199),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1199),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1199),
    [sym_preproc_directive] = ACTIONS(1199),
    [anon_sym_LPAREN2] = ACTIONS(1201),
    [anon_sym_BANG] = ACTIONS(1201),
    [anon_sym_TILDE] = ACTIONS(1201),
    [anon_sym_DASH] = ACTIONS(1199),
    [anon_sym_PLUS] = ACTIONS(1199),
    [anon_sym_STAR] = ACTIONS(1201),
    [anon_sym_AMP] = ACTIONS(1201),
    [anon_sym_SEMI] = ACTIONS(1201),
    [anon_sym___extension__] = ACTIONS(1199),
    [anon_sym_typedef] = ACTIONS(1199),
    [anon_sym_extern] = ACTIONS(1199),
    [anon_sym___attribute__] = ACTIONS(1199),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1201),
    [anon_sym___declspec] = ACTIONS(1199),
    [anon_sym___cdecl] = ACTIONS(1199),
    [anon_sym___clrcall] = ACTIONS(1199),
    [anon_sym___stdcall] = ACTIONS(1199),
    [anon_sym___fastcall] = ACTIONS(1199),
    [anon_sym___thiscall] = ACTIONS(1199),
    [anon_sym___vectorcall] = ACTIONS(1199),
    [anon_sym_LBRACE] = ACTIONS(1201),
    [anon_sym_signed] = ACTIONS(1199),
    [anon_sym_unsigned] = ACTIONS(1199),
    [anon_sym_long] = ACTIONS(1199),
    [anon_sym_short] = ACTIONS(1199),
    [anon_sym_static] = ACTIONS(1199),
    [anon_sym_auto] = ACTIONS(1199),
    [anon_sym_register] = ACTIONS(1199),
    [anon_sym_inline] = ACTIONS(1199),
    [anon_sym___inline] = ACTIONS(1199),
    [anon_sym___inline__] = ACTIONS(1199),
    [anon_sym___forceinline] = ACTIONS(1199),
    [anon_sym_thread_local] = ACTIONS(1199),
    [anon_sym___thread] = ACTIONS(1199),
    [anon_sym_const] = ACTIONS(1199),
    [anon_sym_constexpr] = ACTIONS(1199),
    [anon_sym_volatile] = ACTIONS(1199),
    [anon_sym_restrict] = ACTIONS(1199),
    [anon_sym___restrict__] = ACTIONS(1199),
    [anon_sym__Atomic] = ACTIONS(1199),
    [anon_sym__Noreturn] = ACTIONS(1199),
    [anon_sym_noreturn] = ACTIONS(1199),
    [anon_sym_alignas] = ACTIONS(1199),
    [anon_sym__Alignas] = ACTIONS(1199),
    [sym_primitive_type] = ACTIONS(1199),
    [anon_sym_enum] = ACTIONS(1199),
    [anon_sym_struct] = ACTIONS(1199),
    [anon_sym_union] = ACTIONS(1199),
    [anon_sym_if] = ACTIONS(1199),
    [anon_sym_else] = ACTIONS(1199),
    [anon_sym_switch] = ACTIONS(1199),
    [anon_sym_case] = ACTIONS(1199),
    [anon_sym_default] = ACTIONS(1199),
    [anon_sym_while] = ACTIONS(1199),
    [anon_sym_do] = ACTIONS(1199),
    [anon_sym_for] = ACTIONS(1199),
    [anon_sym_return] = ACTIONS(1199),
    [anon_sym_break] = ACTIONS(1199),
    [anon_sym_continue] = ACTIONS(1199),
    [anon_sym_goto] = ACTIONS(1199),
    [anon_sym___try] = ACTIONS(1199),
    [anon_sym___leave] = ACTIONS(1199),
    [anon_sym_DASH_DASH] = ACTIONS(1201),
    [anon_sym_PLUS_PLUS] = ACTIONS(1201),
    [anon_sym_sizeof] = ACTIONS(1199),
    [anon_sym___alignof__] = ACTIONS(1199),
    [anon_sym___alignof] = ACTIONS(1199),
    [anon_sym__alignof] = ACTIONS(1199),
    [anon_sym_alignof] = ACTIONS(1199),
    [anon_sym__Alignof] = ACTIONS(1199),
    [anon_sym_offsetof] = ACTIONS(1199),
    [anon_sym__Generic] = ACTIONS(1199),
    [anon_sym_asm] = ACTIONS(1199),
    [anon_sym___asm__] = ACTIONS(1199),
    [sym_number_literal] = ACTIONS(1201),
    [anon_sym_L_SQUOTE] = ACTIONS(1201),
    [anon_sym_u_SQUOTE] = ACTIONS(1201),
    [anon_sym_U_SQUOTE] = ACTIONS(1201),
    [anon_sym_u8_SQUOTE] = ACTIONS(1201),
    [anon_sym_SQUOTE] = ACTIONS(1201),
    [anon_sym_L_DQUOTE] = ACTIONS(1201),
    [anon_sym_u_DQUOTE] = ACTIONS(1201),
    [anon_sym_U_DQUOTE] = ACTIONS(1201),
    [anon_sym_u8_DQUOTE] = ACTIONS(1201),
    [anon_sym_DQUOTE] = ACTIONS(1201),
    [sym_true] = ACTIONS(1199),
    [sym_false] = ACTIONS(1199),
    [anon_sym_NULL] = ACTIONS(1199),
    [anon_sym_nullptr] = ACTIONS(1199),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_identifier] = ACTIONS(1191),
    [aux_sym_preproc_include_token1] = ACTIONS(1191),
    [aux_sym_preproc_def_token1] = ACTIONS(1191),
    [aux_sym_preproc_if_token1] = ACTIONS(1191),
    [aux_sym_preproc_if_token2] = ACTIONS(1191),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1191),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1191),
    [aux_sym_preproc_else_token1] = ACTIONS(1191),
    [aux_sym_preproc_elif_token1] = ACTIONS(1191),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1191),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1191),
    [sym_preproc_directive] = ACTIONS(1191),
    [anon_sym_LPAREN2] = ACTIONS(1193),
    [anon_sym_BANG] = ACTIONS(1193),
    [anon_sym_TILDE] = ACTIONS(1193),
    [anon_sym_DASH] = ACTIONS(1191),
    [anon_sym_PLUS] = ACTIONS(1191),
    [anon_sym_STAR] = ACTIONS(1193),
    [anon_sym_AMP] = ACTIONS(1193),
    [anon_sym_SEMI] = ACTIONS(1193),
    [anon_sym___extension__] = ACTIONS(1191),
    [anon_sym_typedef] = ACTIONS(1191),
    [anon_sym_extern] = ACTIONS(1191),
    [anon_sym___attribute__] = ACTIONS(1191),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1193),
    [anon_sym___declspec] = ACTIONS(1191),
    [anon_sym___cdecl] = ACTIONS(1191),
    [anon_sym___clrcall] = ACTIONS(1191),
    [anon_sym___stdcall] = ACTIONS(1191),
    [anon_sym___fastcall] = ACTIONS(1191),
    [anon_sym___thiscall] = ACTIONS(1191),
    [anon_sym___vectorcall] = ACTIONS(1191),
    [anon_sym_LBRACE] = ACTIONS(1193),
    [anon_sym_signed] = ACTIONS(1191),
    [anon_sym_unsigned] = ACTIONS(1191),
    [anon_sym_long] = ACTIONS(1191),
    [anon_sym_short] = ACTIONS(1191),
    [anon_sym_static] = ACTIONS(1191),
    [anon_sym_auto] = ACTIONS(1191),
    [anon_sym_register] = ACTIONS(1191),
    [anon_sym_inline] = ACTIONS(1191),
    [anon_sym___inline] = ACTIONS(1191),
    [anon_sym___inline__] = ACTIONS(1191),
    [anon_sym___forceinline] = ACTIONS(1191),
    [anon_sym_thread_local] = ACTIONS(1191),
    [anon_sym___thread] = ACTIONS(1191),
    [anon_sym_const] = ACTIONS(1191),
    [anon_sym_constexpr] = ACTIONS(1191),
    [anon_sym_volatile] = ACTIONS(1191),
    [anon_sym_restrict] = ACTIONS(1191),
    [anon_sym___restrict__] = ACTIONS(1191),
    [anon_sym__Atomic] = ACTIONS(1191),
    [anon_sym__Noreturn] = ACTIONS(1191),
    [anon_sym_noreturn] = ACTIONS(1191),
    [anon_sym_alignas] = ACTIONS(1191),
    [anon_sym__Alignas] = ACTIONS(1191),
    [sym_primitive_type] = ACTIONS(1191),
    [anon_sym_enum] = ACTIONS(1191),
    [anon_sym_struct] = ACTIONS(1191),
    [anon_sym_union] = ACTIONS(1191),
    [anon_sym_if] = ACTIONS(1191),
    [anon_sym_else] = ACTIONS(1191),
    [anon_sym_switch] = ACTIONS(1191),
    [anon_sym_case] = ACTIONS(1191),
    [anon_sym_default] = ACTIONS(1191),
    [anon_sym_while] = ACTIONS(1191),
    [anon_sym_do] = ACTIONS(1191),
    [anon_sym_for] = ACTIONS(1191),
    [anon_sym_return] = ACTIONS(1191),
    [anon_sym_break] = ACTIONS(1191),
    [anon_sym_continue] = ACTIONS(1191),
    [anon_sym_goto] = ACTIONS(1191),
    [anon_sym___try] = ACTIONS(1191),
    [anon_sym___leave] = ACTIONS(1191),
    [anon_sym_DASH_DASH] = ACTIONS(1193),
    [anon_sym_PLUS_PLUS] = ACTIONS(1193),
    [anon_sym_sizeof] = ACTIONS(1191),
    [anon_sym___alignof__] = ACTIONS(1191),
    [anon_sym___alignof] = ACTIONS(1191),
    [anon_sym__alignof] = ACTIONS(1191),
    [anon_sym_alignof] = ACTIONS(1191),
    [anon_sym__Alignof] = ACTIONS(1191),
    [anon_sym_offsetof] = ACTIONS(1191),
    [anon_sym__Generic] = ACTIONS(1191),
    [anon_sym_asm] = ACTIONS(1191),
    [anon_sym___asm__] = ACTIONS(1191),
    [sym_number_literal] = ACTIONS(1193),
    [anon_sym_L_SQUOTE] = ACTIONS(1193),
    [anon_sym_u_SQUOTE] = ACTIONS(1193),
    [anon_sym_U_SQUOTE] = ACTIONS(1193),
    [anon_sym_u8_SQUOTE] = ACTIONS(1193),
    [anon_sym_SQUOTE] = ACTIONS(1193),
    [anon_sym_L_DQUOTE] = ACTIONS(1193),
    [anon_sym_u_DQUOTE] = ACTIONS(1193),
    [anon_sym_U_DQUOTE] = ACTIONS(1193),
    [anon_sym_u8_DQUOTE] = ACTIONS(1193),
    [anon_sym_DQUOTE] = ACTIONS(1193),
    [sym_true] = ACTIONS(1191),
    [sym_false] = ACTIONS(1191),
    [anon_sym_NULL] = ACTIONS(1191),
    [anon_sym_nullptr] = ACTIONS(1191),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_identifier] = ACTIONS(1203),
    [aux_sym_preproc_include_token1] = ACTIONS(1203),
    [aux_sym_preproc_def_token1] = ACTIONS(1203),
    [aux_sym_preproc_if_token1] = ACTIONS(1203),
    [aux_sym_preproc_if_token2] = ACTIONS(1203),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1203),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1203),
    [aux_sym_preproc_else_token1] = ACTIONS(1203),
    [aux_sym_preproc_elif_token1] = ACTIONS(1203),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1203),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1203),
    [sym_preproc_directive] = ACTIONS(1203),
    [anon_sym_LPAREN2] = ACTIONS(1205),
    [anon_sym_BANG] = ACTIONS(1205),
    [anon_sym_TILDE] = ACTIONS(1205),
    [anon_sym_DASH] = ACTIONS(1203),
    [anon_sym_PLUS] = ACTIONS(1203),
    [anon_sym_STAR] = ACTIONS(1205),
    [anon_sym_AMP] = ACTIONS(1205),
    [anon_sym_SEMI] = ACTIONS(1205),
    [anon_sym___extension__] = ACTIONS(1203),
    [anon_sym_typedef] = ACTIONS(1203),
    [anon_sym_extern] = ACTIONS(1203),
    [anon_sym___attribute__] = ACTIONS(1203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1205),
    [anon_sym___declspec] = ACTIONS(1203),
    [anon_sym___cdecl] = ACTIONS(1203),
    [anon_sym___clrcall] = ACTIONS(1203),
    [anon_sym___stdcall] = ACTIONS(1203),
    [anon_sym___fastcall] = ACTIONS(1203),
    [anon_sym___thiscall] = ACTIONS(1203),
    [anon_sym___vectorcall] = ACTIONS(1203),
    [anon_sym_LBRACE] = ACTIONS(1205),
    [anon_sym_signed] = ACTIONS(1203),
    [anon_sym_unsigned] = ACTIONS(1203),
    [anon_sym_long] = ACTIONS(1203),
    [anon_sym_short] = ACTIONS(1203),
    [anon_sym_static] = ACTIONS(1203),
    [anon_sym_auto] = ACTIONS(1203),
    [anon_sym_register] = ACTIONS(1203),
    [anon_sym_inline] = ACTIONS(1203),
    [anon_sym___inline] = ACTIONS(1203),
    [anon_sym___inline__] = ACTIONS(1203),
    [anon_sym___forceinline] = ACTIONS(1203),
    [anon_sym_thread_local] = ACTIONS(1203),
    [anon_sym___thread] = ACTIONS(1203),
    [anon_sym_const] = ACTIONS(1203),
    [anon_sym_constexpr] = ACTIONS(1203),
    [anon_sym_volatile] = ACTIONS(1203),
    [anon_sym_restrict] = ACTIONS(1203),
    [anon_sym___restrict__] = ACTIONS(1203),
    [anon_sym__Atomic] = ACTIONS(1203),
    [anon_sym__Noreturn] = ACTIONS(1203),
    [anon_sym_noreturn] = ACTIONS(1203),
    [anon_sym_alignas] = ACTIONS(1203),
    [anon_sym__Alignas] = ACTIONS(1203),
    [sym_primitive_type] = ACTIONS(1203),
    [anon_sym_enum] = ACTIONS(1203),
    [anon_sym_struct] = ACTIONS(1203),
    [anon_sym_union] = ACTIONS(1203),
    [anon_sym_if] = ACTIONS(1203),
    [anon_sym_else] = ACTIONS(1203),
    [anon_sym_switch] = ACTIONS(1203),
    [anon_sym_case] = ACTIONS(1203),
    [anon_sym_default] = ACTIONS(1203),
    [anon_sym_while] = ACTIONS(1203),
    [anon_sym_do] = ACTIONS(1203),
    [anon_sym_for] = ACTIONS(1203),
    [anon_sym_return] = ACTIONS(1203),
    [anon_sym_break] = ACTIONS(1203),
    [anon_sym_continue] = ACTIONS(1203),
    [anon_sym_goto] = ACTIONS(1203),
    [anon_sym___try] = ACTIONS(1203),
    [anon_sym___leave] = ACTIONS(1203),
    [anon_sym_DASH_DASH] = ACTIONS(1205),
    [anon_sym_PLUS_PLUS] = ACTIONS(1205),
    [anon_sym_sizeof] = ACTIONS(1203),
    [anon_sym___alignof__] = ACTIONS(1203),
    [anon_sym___alignof] = ACTIONS(1203),
    [anon_sym__alignof] = ACTIONS(1203),
    [anon_sym_alignof] = ACTIONS(1203),
    [anon_sym__Alignof] = ACTIONS(1203),
    [anon_sym_offsetof] = ACTIONS(1203),
    [anon_sym__Generic] = ACTIONS(1203),
    [anon_sym_asm] = ACTIONS(1203),
    [anon_sym___asm__] = ACTIONS(1203),
    [sym_number_literal] = ACTIONS(1205),
    [anon_sym_L_SQUOTE] = ACTIONS(1205),
    [anon_sym_u_SQUOTE] = ACTIONS(1205),
    [anon_sym_U_SQUOTE] = ACTIONS(1205),
    [anon_sym_u8_SQUOTE] = ACTIONS(1205),
    [anon_sym_SQUOTE] = ACTIONS(1205),
    [anon_sym_L_DQUOTE] = ACTIONS(1205),
    [anon_sym_u_DQUOTE] = ACTIONS(1205),
    [anon_sym_U_DQUOTE] = ACTIONS(1205),
    [anon_sym_u8_DQUOTE] = ACTIONS(1205),
    [anon_sym_DQUOTE] = ACTIONS(1205),
    [sym_true] = ACTIONS(1203),
    [sym_false] = ACTIONS(1203),
    [anon_sym_NULL] = ACTIONS(1203),
    [anon_sym_nullptr] = ACTIONS(1203),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [sym_identifier] = ACTIONS(1203),
    [aux_sym_preproc_include_token1] = ACTIONS(1203),
    [aux_sym_preproc_def_token1] = ACTIONS(1203),
    [aux_sym_preproc_if_token1] = ACTIONS(1203),
    [aux_sym_preproc_if_token2] = ACTIONS(1203),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1203),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1203),
    [aux_sym_preproc_else_token1] = ACTIONS(1203),
    [aux_sym_preproc_elif_token1] = ACTIONS(1203),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1203),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1203),
    [sym_preproc_directive] = ACTIONS(1203),
    [anon_sym_LPAREN2] = ACTIONS(1205),
    [anon_sym_BANG] = ACTIONS(1205),
    [anon_sym_TILDE] = ACTIONS(1205),
    [anon_sym_DASH] = ACTIONS(1203),
    [anon_sym_PLUS] = ACTIONS(1203),
    [anon_sym_STAR] = ACTIONS(1205),
    [anon_sym_AMP] = ACTIONS(1205),
    [anon_sym_SEMI] = ACTIONS(1205),
    [anon_sym___extension__] = ACTIONS(1203),
    [anon_sym_typedef] = ACTIONS(1203),
    [anon_sym_extern] = ACTIONS(1203),
    [anon_sym___attribute__] = ACTIONS(1203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1205),
    [anon_sym___declspec] = ACTIONS(1203),
    [anon_sym___cdecl] = ACTIONS(1203),
    [anon_sym___clrcall] = ACTIONS(1203),
    [anon_sym___stdcall] = ACTIONS(1203),
    [anon_sym___fastcall] = ACTIONS(1203),
    [anon_sym___thiscall] = ACTIONS(1203),
    [anon_sym___vectorcall] = ACTIONS(1203),
    [anon_sym_LBRACE] = ACTIONS(1205),
    [anon_sym_signed] = ACTIONS(1203),
    [anon_sym_unsigned] = ACTIONS(1203),
    [anon_sym_long] = ACTIONS(1203),
    [anon_sym_short] = ACTIONS(1203),
    [anon_sym_static] = ACTIONS(1203),
    [anon_sym_auto] = ACTIONS(1203),
    [anon_sym_register] = ACTIONS(1203),
    [anon_sym_inline] = ACTIONS(1203),
    [anon_sym___inline] = ACTIONS(1203),
    [anon_sym___inline__] = ACTIONS(1203),
    [anon_sym___forceinline] = ACTIONS(1203),
    [anon_sym_thread_local] = ACTIONS(1203),
    [anon_sym___thread] = ACTIONS(1203),
    [anon_sym_const] = ACTIONS(1203),
    [anon_sym_constexpr] = ACTIONS(1203),
    [anon_sym_volatile] = ACTIONS(1203),
    [anon_sym_restrict] = ACTIONS(1203),
    [anon_sym___restrict__] = ACTIONS(1203),
    [anon_sym__Atomic] = ACTIONS(1203),
    [anon_sym__Noreturn] = ACTIONS(1203),
    [anon_sym_noreturn] = ACTIONS(1203),
    [anon_sym_alignas] = ACTIONS(1203),
    [anon_sym__Alignas] = ACTIONS(1203),
    [sym_primitive_type] = ACTIONS(1203),
    [anon_sym_enum] = ACTIONS(1203),
    [anon_sym_struct] = ACTIONS(1203),
    [anon_sym_union] = ACTIONS(1203),
    [anon_sym_if] = ACTIONS(1203),
    [anon_sym_else] = ACTIONS(1203),
    [anon_sym_switch] = ACTIONS(1203),
    [anon_sym_case] = ACTIONS(1203),
    [anon_sym_default] = ACTIONS(1203),
    [anon_sym_while] = ACTIONS(1203),
    [anon_sym_do] = ACTIONS(1203),
    [anon_sym_for] = ACTIONS(1203),
    [anon_sym_return] = ACTIONS(1203),
    [anon_sym_break] = ACTIONS(1203),
    [anon_sym_continue] = ACTIONS(1203),
    [anon_sym_goto] = ACTIONS(1203),
    [anon_sym___try] = ACTIONS(1203),
    [anon_sym___leave] = ACTIONS(1203),
    [anon_sym_DASH_DASH] = ACTIONS(1205),
    [anon_sym_PLUS_PLUS] = ACTIONS(1205),
    [anon_sym_sizeof] = ACTIONS(1203),
    [anon_sym___alignof__] = ACTIONS(1203),
    [anon_sym___alignof] = ACTIONS(1203),
    [anon_sym__alignof] = ACTIONS(1203),
    [anon_sym_alignof] = ACTIONS(1203),
    [anon_sym__Alignof] = ACTIONS(1203),
    [anon_sym_offsetof] = ACTIONS(1203),
    [anon_sym__Generic] = ACTIONS(1203),
    [anon_sym_asm] = ACTIONS(1203),
    [anon_sym___asm__] = ACTIONS(1203),
    [sym_number_literal] = ACTIONS(1205),
    [anon_sym_L_SQUOTE] = ACTIONS(1205),
    [anon_sym_u_SQUOTE] = ACTIONS(1205),
    [anon_sym_U_SQUOTE] = ACTIONS(1205),
    [anon_sym_u8_SQUOTE] = ACTIONS(1205),
    [anon_sym_SQUOTE] = ACTIONS(1205),
    [anon_sym_L_DQUOTE] = ACTIONS(1205),
    [anon_sym_u_DQUOTE] = ACTIONS(1205),
    [anon_sym_U_DQUOTE] = ACTIONS(1205),
    [anon_sym_u8_DQUOTE] = ACTIONS(1205),
    [anon_sym_DQUOTE] = ACTIONS(1205),
    [sym_true] = ACTIONS(1203),
    [sym_false] = ACTIONS(1203),
    [anon_sym_NULL] = ACTIONS(1203),
    [anon_sym_nullptr] = ACTIONS(1203),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [sym_identifier] = ACTIONS(1207),
    [aux_sym_preproc_include_token1] = ACTIONS(1207),
    [aux_sym_preproc_def_token1] = ACTIONS(1207),
    [aux_sym_preproc_if_token1] = ACTIONS(1207),
    [aux_sym_preproc_if_token2] = ACTIONS(1207),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1207),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1207),
    [aux_sym_preproc_else_token1] = ACTIONS(1207),
    [aux_sym_preproc_elif_token1] = ACTIONS(1207),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1207),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1207),
    [sym_preproc_directive] = ACTIONS(1207),
    [anon_sym_LPAREN2] = ACTIONS(1209),
    [anon_sym_BANG] = ACTIONS(1209),
    [anon_sym_TILDE] = ACTIONS(1209),
    [anon_sym_DASH] = ACTIONS(1207),
    [anon_sym_PLUS] = ACTIONS(1207),
    [anon_sym_STAR] = ACTIONS(1209),
    [anon_sym_AMP] = ACTIONS(1209),
    [anon_sym_SEMI] = ACTIONS(1209),
    [anon_sym___extension__] = ACTIONS(1207),
    [anon_sym_typedef] = ACTIONS(1207),
    [anon_sym_extern] = ACTIONS(1207),
    [anon_sym___attribute__] = ACTIONS(1207),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1209),
    [anon_sym___declspec] = ACTIONS(1207),
    [anon_sym___cdecl] = ACTIONS(1207),
    [anon_sym___clrcall] = ACTIONS(1207),
    [anon_sym___stdcall] = ACTIONS(1207),
    [anon_sym___fastcall] = ACTIONS(1207),
    [anon_sym___thiscall] = ACTIONS(1207),
    [anon_sym___vectorcall] = ACTIONS(1207),
    [anon_sym_LBRACE] = ACTIONS(1209),
    [anon_sym_signed] = ACTIONS(1207),
    [anon_sym_unsigned] = ACTIONS(1207),
    [anon_sym_long] = ACTIONS(1207),
    [anon_sym_short] = ACTIONS(1207),
    [anon_sym_static] = ACTIONS(1207),
    [anon_sym_auto] = ACTIONS(1207),
    [anon_sym_register] = ACTIONS(1207),
    [anon_sym_inline] = ACTIONS(1207),
    [anon_sym___inline] = ACTIONS(1207),
    [anon_sym___inline__] = ACTIONS(1207),
    [anon_sym___forceinline] = ACTIONS(1207),
    [anon_sym_thread_local] = ACTIONS(1207),
    [anon_sym___thread] = ACTIONS(1207),
    [anon_sym_const] = ACTIONS(1207),
    [anon_sym_constexpr] = ACTIONS(1207),
    [anon_sym_volatile] = ACTIONS(1207),
    [anon_sym_restrict] = ACTIONS(1207),
    [anon_sym___restrict__] = ACTIONS(1207),
    [anon_sym__Atomic] = ACTIONS(1207),
    [anon_sym__Noreturn] = ACTIONS(1207),
    [anon_sym_noreturn] = ACTIONS(1207),
    [anon_sym_alignas] = ACTIONS(1207),
    [anon_sym__Alignas] = ACTIONS(1207),
    [sym_primitive_type] = ACTIONS(1207),
    [anon_sym_enum] = ACTIONS(1207),
    [anon_sym_struct] = ACTIONS(1207),
    [anon_sym_union] = ACTIONS(1207),
    [anon_sym_if] = ACTIONS(1207),
    [anon_sym_else] = ACTIONS(1207),
    [anon_sym_switch] = ACTIONS(1207),
    [anon_sym_case] = ACTIONS(1207),
    [anon_sym_default] = ACTIONS(1207),
    [anon_sym_while] = ACTIONS(1207),
    [anon_sym_do] = ACTIONS(1207),
    [anon_sym_for] = ACTIONS(1207),
    [anon_sym_return] = ACTIONS(1207),
    [anon_sym_break] = ACTIONS(1207),
    [anon_sym_continue] = ACTIONS(1207),
    [anon_sym_goto] = ACTIONS(1207),
    [anon_sym___try] = ACTIONS(1207),
    [anon_sym___leave] = ACTIONS(1207),
    [anon_sym_DASH_DASH] = ACTIONS(1209),
    [anon_sym_PLUS_PLUS] = ACTIONS(1209),
    [anon_sym_sizeof] = ACTIONS(1207),
    [anon_sym___alignof__] = ACTIONS(1207),
    [anon_sym___alignof] = ACTIONS(1207),
    [anon_sym__alignof] = ACTIONS(1207),
    [anon_sym_alignof] = ACTIONS(1207),
    [anon_sym__Alignof] = ACTIONS(1207),
    [anon_sym_offsetof] = ACTIONS(1207),
    [anon_sym__Generic] = ACTIONS(1207),
    [anon_sym_asm] = ACTIONS(1207),
    [anon_sym___asm__] = ACTIONS(1207),
    [sym_number_literal] = ACTIONS(1209),
    [anon_sym_L_SQUOTE] = ACTIONS(1209),
    [anon_sym_u_SQUOTE] = ACTIONS(1209),
    [anon_sym_U_SQUOTE] = ACTIONS(1209),
    [anon_sym_u8_SQUOTE] = ACTIONS(1209),
    [anon_sym_SQUOTE] = ACTIONS(1209),
    [anon_sym_L_DQUOTE] = ACTIONS(1209),
    [anon_sym_u_DQUOTE] = ACTIONS(1209),
    [anon_sym_U_DQUOTE] = ACTIONS(1209),
    [anon_sym_u8_DQUOTE] = ACTIONS(1209),
    [anon_sym_DQUOTE] = ACTIONS(1209),
    [sym_true] = ACTIONS(1207),
    [sym_false] = ACTIONS(1207),
    [anon_sym_NULL] = ACTIONS(1207),
    [anon_sym_nullptr] = ACTIONS(1207),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_identifier] = ACTIONS(1211),
    [aux_sym_preproc_include_token1] = ACTIONS(1211),
    [aux_sym_preproc_def_token1] = ACTIONS(1211),
    [aux_sym_preproc_if_token1] = ACTIONS(1211),
    [aux_sym_preproc_if_token2] = ACTIONS(1211),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1211),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1211),
    [aux_sym_preproc_else_token1] = ACTIONS(1211),
    [aux_sym_preproc_elif_token1] = ACTIONS(1211),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1211),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1211),
    [sym_preproc_directive] = ACTIONS(1211),
    [anon_sym_LPAREN2] = ACTIONS(1213),
    [anon_sym_BANG] = ACTIONS(1213),
    [anon_sym_TILDE] = ACTIONS(1213),
    [anon_sym_DASH] = ACTIONS(1211),
    [anon_sym_PLUS] = ACTIONS(1211),
    [anon_sym_STAR] = ACTIONS(1213),
    [anon_sym_AMP] = ACTIONS(1213),
    [anon_sym_SEMI] = ACTIONS(1213),
    [anon_sym___extension__] = ACTIONS(1211),
    [anon_sym_typedef] = ACTIONS(1211),
    [anon_sym_extern] = ACTIONS(1211),
    [anon_sym___attribute__] = ACTIONS(1211),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1213),
    [anon_sym___declspec] = ACTIONS(1211),
    [anon_sym___cdecl] = ACTIONS(1211),
    [anon_sym___clrcall] = ACTIONS(1211),
    [anon_sym___stdcall] = ACTIONS(1211),
    [anon_sym___fastcall] = ACTIONS(1211),
    [anon_sym___thiscall] = ACTIONS(1211),
    [anon_sym___vectorcall] = ACTIONS(1211),
    [anon_sym_LBRACE] = ACTIONS(1213),
    [anon_sym_signed] = ACTIONS(1211),
    [anon_sym_unsigned] = ACTIONS(1211),
    [anon_sym_long] = ACTIONS(1211),
    [anon_sym_short] = ACTIONS(1211),
    [anon_sym_static] = ACTIONS(1211),
    [anon_sym_auto] = ACTIONS(1211),
    [anon_sym_register] = ACTIONS(1211),
    [anon_sym_inline] = ACTIONS(1211),
    [anon_sym___inline] = ACTIONS(1211),
    [anon_sym___inline__] = ACTIONS(1211),
    [anon_sym___forceinline] = ACTIONS(1211),
    [anon_sym_thread_local] = ACTIONS(1211),
    [anon_sym___thread] = ACTIONS(1211),
    [anon_sym_const] = ACTIONS(1211),
    [anon_sym_constexpr] = ACTIONS(1211),
    [anon_sym_volatile] = ACTIONS(1211),
    [anon_sym_restrict] = ACTIONS(1211),
    [anon_sym___restrict__] = ACTIONS(1211),
    [anon_sym__Atomic] = ACTIONS(1211),
    [anon_sym__Noreturn] = ACTIONS(1211),
    [anon_sym_noreturn] = ACTIONS(1211),
    [anon_sym_alignas] = ACTIONS(1211),
    [anon_sym__Alignas] = ACTIONS(1211),
    [sym_primitive_type] = ACTIONS(1211),
    [anon_sym_enum] = ACTIONS(1211),
    [anon_sym_struct] = ACTIONS(1211),
    [anon_sym_union] = ACTIONS(1211),
    [anon_sym_if] = ACTIONS(1211),
    [anon_sym_else] = ACTIONS(1211),
    [anon_sym_switch] = ACTIONS(1211),
    [anon_sym_case] = ACTIONS(1211),
    [anon_sym_default] = ACTIONS(1211),
    [anon_sym_while] = ACTIONS(1211),
    [anon_sym_do] = ACTIONS(1211),
    [anon_sym_for] = ACTIONS(1211),
    [anon_sym_return] = ACTIONS(1211),
    [anon_sym_break] = ACTIONS(1211),
    [anon_sym_continue] = ACTIONS(1211),
    [anon_sym_goto] = ACTIONS(1211),
    [anon_sym___try] = ACTIONS(1211),
    [anon_sym___leave] = ACTIONS(1211),
    [anon_sym_DASH_DASH] = ACTIONS(1213),
    [anon_sym_PLUS_PLUS] = ACTIONS(1213),
    [anon_sym_sizeof] = ACTIONS(1211),
    [anon_sym___alignof__] = ACTIONS(1211),
    [anon_sym___alignof] = ACTIONS(1211),
    [anon_sym__alignof] = ACTIONS(1211),
    [anon_sym_alignof] = ACTIONS(1211),
    [anon_sym__Alignof] = ACTIONS(1211),
    [anon_sym_offsetof] = ACTIONS(1211),
    [anon_sym__Generic] = ACTIONS(1211),
    [anon_sym_asm] = ACTIONS(1211),
    [anon_sym___asm__] = ACTIONS(1211),
    [sym_number_literal] = ACTIONS(1213),
    [anon_sym_L_SQUOTE] = ACTIONS(1213),
    [anon_sym_u_SQUOTE] = ACTIONS(1213),
    [anon_sym_U_SQUOTE] = ACTIONS(1213),
    [anon_sym_u8_SQUOTE] = ACTIONS(1213),
    [anon_sym_SQUOTE] = ACTIONS(1213),
    [anon_sym_L_DQUOTE] = ACTIONS(1213),
    [anon_sym_u_DQUOTE] = ACTIONS(1213),
    [anon_sym_U_DQUOTE] = ACTIONS(1213),
    [anon_sym_u8_DQUOTE] = ACTIONS(1213),
    [anon_sym_DQUOTE] = ACTIONS(1213),
    [sym_true] = ACTIONS(1211),
    [sym_false] = ACTIONS(1211),
    [anon_sym_NULL] = ACTIONS(1211),
    [anon_sym_nullptr] = ACTIONS(1211),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [sym_identifier] = ACTIONS(1215),
    [aux_sym_preproc_include_token1] = ACTIONS(1215),
    [aux_sym_preproc_def_token1] = ACTIONS(1215),
    [aux_sym_preproc_if_token1] = ACTIONS(1215),
    [aux_sym_preproc_if_token2] = ACTIONS(1215),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1215),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1215),
    [aux_sym_preproc_else_token1] = ACTIONS(1215),
    [aux_sym_preproc_elif_token1] = ACTIONS(1215),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1215),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1215),
    [sym_preproc_directive] = ACTIONS(1215),
    [anon_sym_LPAREN2] = ACTIONS(1217),
    [anon_sym_BANG] = ACTIONS(1217),
    [anon_sym_TILDE] = ACTIONS(1217),
    [anon_sym_DASH] = ACTIONS(1215),
    [anon_sym_PLUS] = ACTIONS(1215),
    [anon_sym_STAR] = ACTIONS(1217),
    [anon_sym_AMP] = ACTIONS(1217),
    [anon_sym_SEMI] = ACTIONS(1217),
    [anon_sym___extension__] = ACTIONS(1215),
    [anon_sym_typedef] = ACTIONS(1215),
    [anon_sym_extern] = ACTIONS(1215),
    [anon_sym___attribute__] = ACTIONS(1215),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1217),
    [anon_sym___declspec] = ACTIONS(1215),
    [anon_sym___cdecl] = ACTIONS(1215),
    [anon_sym___clrcall] = ACTIONS(1215),
    [anon_sym___stdcall] = ACTIONS(1215),
    [anon_sym___fastcall] = ACTIONS(1215),
    [anon_sym___thiscall] = ACTIONS(1215),
    [anon_sym___vectorcall] = ACTIONS(1215),
    [anon_sym_LBRACE] = ACTIONS(1217),
    [anon_sym_signed] = ACTIONS(1215),
    [anon_sym_unsigned] = ACTIONS(1215),
    [anon_sym_long] = ACTIONS(1215),
    [anon_sym_short] = ACTIONS(1215),
    [anon_sym_static] = ACTIONS(1215),
    [anon_sym_auto] = ACTIONS(1215),
    [anon_sym_register] = ACTIONS(1215),
    [anon_sym_inline] = ACTIONS(1215),
    [anon_sym___inline] = ACTIONS(1215),
    [anon_sym___inline__] = ACTIONS(1215),
    [anon_sym___forceinline] = ACTIONS(1215),
    [anon_sym_thread_local] = ACTIONS(1215),
    [anon_sym___thread] = ACTIONS(1215),
    [anon_sym_const] = ACTIONS(1215),
    [anon_sym_constexpr] = ACTIONS(1215),
    [anon_sym_volatile] = ACTIONS(1215),
    [anon_sym_restrict] = ACTIONS(1215),
    [anon_sym___restrict__] = ACTIONS(1215),
    [anon_sym__Atomic] = ACTIONS(1215),
    [anon_sym__Noreturn] = ACTIONS(1215),
    [anon_sym_noreturn] = ACTIONS(1215),
    [anon_sym_alignas] = ACTIONS(1215),
    [anon_sym__Alignas] = ACTIONS(1215),
    [sym_primitive_type] = ACTIONS(1215),
    [anon_sym_enum] = ACTIONS(1215),
    [anon_sym_struct] = ACTIONS(1215),
    [anon_sym_union] = ACTIONS(1215),
    [anon_sym_if] = ACTIONS(1215),
    [anon_sym_else] = ACTIONS(1215),
    [anon_sym_switch] = ACTIONS(1215),
    [anon_sym_case] = ACTIONS(1215),
    [anon_sym_default] = ACTIONS(1215),
    [anon_sym_while] = ACTIONS(1215),
    [anon_sym_do] = ACTIONS(1215),
    [anon_sym_for] = ACTIONS(1215),
    [anon_sym_return] = ACTIONS(1215),
    [anon_sym_break] = ACTIONS(1215),
    [anon_sym_continue] = ACTIONS(1215),
    [anon_sym_goto] = ACTIONS(1215),
    [anon_sym___try] = ACTIONS(1215),
    [anon_sym___leave] = ACTIONS(1215),
    [anon_sym_DASH_DASH] = ACTIONS(1217),
    [anon_sym_PLUS_PLUS] = ACTIONS(1217),
    [anon_sym_sizeof] = ACTIONS(1215),
    [anon_sym___alignof__] = ACTIONS(1215),
    [anon_sym___alignof] = ACTIONS(1215),
    [anon_sym__alignof] = ACTIONS(1215),
    [anon_sym_alignof] = ACTIONS(1215),
    [anon_sym__Alignof] = ACTIONS(1215),
    [anon_sym_offsetof] = ACTIONS(1215),
    [anon_sym__Generic] = ACTIONS(1215),
    [anon_sym_asm] = ACTIONS(1215),
    [anon_sym___asm__] = ACTIONS(1215),
    [sym_number_literal] = ACTIONS(1217),
    [anon_sym_L_SQUOTE] = ACTIONS(1217),
    [anon_sym_u_SQUOTE] = ACTIONS(1217),
    [anon_sym_U_SQUOTE] = ACTIONS(1217),
    [anon_sym_u8_SQUOTE] = ACTIONS(1217),
    [anon_sym_SQUOTE] = ACTIONS(1217),
    [anon_sym_L_DQUOTE] = ACTIONS(1217),
    [anon_sym_u_DQUOTE] = ACTIONS(1217),
    [anon_sym_U_DQUOTE] = ACTIONS(1217),
    [anon_sym_u8_DQUOTE] = ACTIONS(1217),
    [anon_sym_DQUOTE] = ACTIONS(1217),
    [sym_true] = ACTIONS(1215),
    [sym_false] = ACTIONS(1215),
    [anon_sym_NULL] = ACTIONS(1215),
    [anon_sym_nullptr] = ACTIONS(1215),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [sym_identifier] = ACTIONS(1219),
    [aux_sym_preproc_include_token1] = ACTIONS(1219),
    [aux_sym_preproc_def_token1] = ACTIONS(1219),
    [aux_sym_preproc_if_token1] = ACTIONS(1219),
    [aux_sym_preproc_if_token2] = ACTIONS(1219),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1219),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1219),
    [aux_sym_preproc_else_token1] = ACTIONS(1219),
    [aux_sym_preproc_elif_token1] = ACTIONS(1219),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1219),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1219),
    [sym_preproc_directive] = ACTIONS(1219),
    [anon_sym_LPAREN2] = ACTIONS(1221),
    [anon_sym_BANG] = ACTIONS(1221),
    [anon_sym_TILDE] = ACTIONS(1221),
    [anon_sym_DASH] = ACTIONS(1219),
    [anon_sym_PLUS] = ACTIONS(1219),
    [anon_sym_STAR] = ACTIONS(1221),
    [anon_sym_AMP] = ACTIONS(1221),
    [anon_sym_SEMI] = ACTIONS(1221),
    [anon_sym___extension__] = ACTIONS(1219),
    [anon_sym_typedef] = ACTIONS(1219),
    [anon_sym_extern] = ACTIONS(1219),
    [anon_sym___attribute__] = ACTIONS(1219),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1221),
    [anon_sym___declspec] = ACTIONS(1219),
    [anon_sym___cdecl] = ACTIONS(1219),
    [anon_sym___clrcall] = ACTIONS(1219),
    [anon_sym___stdcall] = ACTIONS(1219),
    [anon_sym___fastcall] = ACTIONS(1219),
    [anon_sym___thiscall] = ACTIONS(1219),
    [anon_sym___vectorcall] = ACTIONS(1219),
    [anon_sym_LBRACE] = ACTIONS(1221),
    [anon_sym_signed] = ACTIONS(1219),
    [anon_sym_unsigned] = ACTIONS(1219),
    [anon_sym_long] = ACTIONS(1219),
    [anon_sym_short] = ACTIONS(1219),
    [anon_sym_static] = ACTIONS(1219),
    [anon_sym_auto] = ACTIONS(1219),
    [anon_sym_register] = ACTIONS(1219),
    [anon_sym_inline] = ACTIONS(1219),
    [anon_sym___inline] = ACTIONS(1219),
    [anon_sym___inline__] = ACTIONS(1219),
    [anon_sym___forceinline] = ACTIONS(1219),
    [anon_sym_thread_local] = ACTIONS(1219),
    [anon_sym___thread] = ACTIONS(1219),
    [anon_sym_const] = ACTIONS(1219),
    [anon_sym_constexpr] = ACTIONS(1219),
    [anon_sym_volatile] = ACTIONS(1219),
    [anon_sym_restrict] = ACTIONS(1219),
    [anon_sym___restrict__] = ACTIONS(1219),
    [anon_sym__Atomic] = ACTIONS(1219),
    [anon_sym__Noreturn] = ACTIONS(1219),
    [anon_sym_noreturn] = ACTIONS(1219),
    [anon_sym_alignas] = ACTIONS(1219),
    [anon_sym__Alignas] = ACTIONS(1219),
    [sym_primitive_type] = ACTIONS(1219),
    [anon_sym_enum] = ACTIONS(1219),
    [anon_sym_struct] = ACTIONS(1219),
    [anon_sym_union] = ACTIONS(1219),
    [anon_sym_if] = ACTIONS(1219),
    [anon_sym_else] = ACTIONS(1219),
    [anon_sym_switch] = ACTIONS(1219),
    [anon_sym_case] = ACTIONS(1219),
    [anon_sym_default] = ACTIONS(1219),
    [anon_sym_while] = ACTIONS(1219),
    [anon_sym_do] = ACTIONS(1219),
    [anon_sym_for] = ACTIONS(1219),
    [anon_sym_return] = ACTIONS(1219),
    [anon_sym_break] = ACTIONS(1219),
    [anon_sym_continue] = ACTIONS(1219),
    [anon_sym_goto] = ACTIONS(1219),
    [anon_sym___try] = ACTIONS(1219),
    [anon_sym___leave] = ACTIONS(1219),
    [anon_sym_DASH_DASH] = ACTIONS(1221),
    [anon_sym_PLUS_PLUS] = ACTIONS(1221),
    [anon_sym_sizeof] = ACTIONS(1219),
    [anon_sym___alignof__] = ACTIONS(1219),
    [anon_sym___alignof] = ACTIONS(1219),
    [anon_sym__alignof] = ACTIONS(1219),
    [anon_sym_alignof] = ACTIONS(1219),
    [anon_sym__Alignof] = ACTIONS(1219),
    [anon_sym_offsetof] = ACTIONS(1219),
    [anon_sym__Generic] = ACTIONS(1219),
    [anon_sym_asm] = ACTIONS(1219),
    [anon_sym___asm__] = ACTIONS(1219),
    [sym_number_literal] = ACTIONS(1221),
    [anon_sym_L_SQUOTE] = ACTIONS(1221),
    [anon_sym_u_SQUOTE] = ACTIONS(1221),
    [anon_sym_U_SQUOTE] = ACTIONS(1221),
    [anon_sym_u8_SQUOTE] = ACTIONS(1221),
    [anon_sym_SQUOTE] = ACTIONS(1221),
    [anon_sym_L_DQUOTE] = ACTIONS(1221),
    [anon_sym_u_DQUOTE] = ACTIONS(1221),
    [anon_sym_U_DQUOTE] = ACTIONS(1221),
    [anon_sym_u8_DQUOTE] = ACTIONS(1221),
    [anon_sym_DQUOTE] = ACTIONS(1221),
    [sym_true] = ACTIONS(1219),
    [sym_false] = ACTIONS(1219),
    [anon_sym_NULL] = ACTIONS(1219),
    [anon_sym_nullptr] = ACTIONS(1219),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [ts_builtin_sym_end] = ACTIONS(1169),
    [sym_identifier] = ACTIONS(1167),
    [aux_sym_preproc_include_token1] = ACTIONS(1167),
    [aux_sym_preproc_def_token1] = ACTIONS(1167),
    [anon_sym_COMMA] = ACTIONS(1169),
    [anon_sym_RPAREN] = ACTIONS(1169),
    [aux_sym_preproc_if_token1] = ACTIONS(1167),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1167),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1167),
    [sym_preproc_directive] = ACTIONS(1167),
    [anon_sym_LPAREN2] = ACTIONS(1169),
    [anon_sym_BANG] = ACTIONS(1169),
    [anon_sym_TILDE] = ACTIONS(1169),
    [anon_sym_DASH] = ACTIONS(1167),
    [anon_sym_PLUS] = ACTIONS(1167),
    [anon_sym_STAR] = ACTIONS(1169),
    [anon_sym_AMP] = ACTIONS(1169),
    [anon_sym_SEMI] = ACTIONS(1169),
    [anon_sym___extension__] = ACTIONS(1167),
    [anon_sym_typedef] = ACTIONS(1167),
    [anon_sym_extern] = ACTIONS(1167),
    [anon_sym___attribute__] = ACTIONS(1167),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1169),
    [anon_sym___declspec] = ACTIONS(1167),
    [anon_sym___cdecl] = ACTIONS(1167),
    [anon_sym___clrcall] = ACTIONS(1167),
    [anon_sym___stdcall] = ACTIONS(1167),
    [anon_sym___fastcall] = ACTIONS(1167),
    [anon_sym___thiscall] = ACTIONS(1167),
    [anon_sym___vectorcall] = ACTIONS(1167),
    [anon_sym_LBRACE] = ACTIONS(1169),
    [anon_sym_signed] = ACTIONS(1167),
    [anon_sym_unsigned] = ACTIONS(1167),
    [anon_sym_long] = ACTIONS(1167),
    [anon_sym_short] = ACTIONS(1167),
    [anon_sym_static] = ACTIONS(1167),
    [anon_sym_auto] = ACTIONS(1167),
    [anon_sym_register] = ACTIONS(1167),
    [anon_sym_inline] = ACTIONS(1167),
    [anon_sym___inline] = ACTIONS(1167),
    [anon_sym___inline__] = ACTIONS(1167),
    [anon_sym___forceinline] = ACTIONS(1167),
    [anon_sym_thread_local] = ACTIONS(1167),
    [anon_sym___thread] = ACTIONS(1167),
    [anon_sym_const] = ACTIONS(1167),
    [anon_sym_constexpr] = ACTIONS(1167),
    [anon_sym_volatile] = ACTIONS(1167),
    [anon_sym_restrict] = ACTIONS(1167),
    [anon_sym___restrict__] = ACTIONS(1167),
    [anon_sym__Atomic] = ACTIONS(1167),
    [anon_sym__Noreturn] = ACTIONS(1167),
    [anon_sym_noreturn] = ACTIONS(1167),
    [anon_sym_alignas] = ACTIONS(1167),
    [anon_sym__Alignas] = ACTIONS(1167),
    [sym_primitive_type] = ACTIONS(1167),
    [anon_sym_enum] = ACTIONS(1167),
    [anon_sym_struct] = ACTIONS(1167),
    [anon_sym_union] = ACTIONS(1167),
    [anon_sym_if] = ACTIONS(1167),
    [anon_sym_else] = ACTIONS(1167),
    [anon_sym_switch] = ACTIONS(1167),
    [anon_sym_case] = ACTIONS(1167),
    [anon_sym_default] = ACTIONS(1167),
    [anon_sym_while] = ACTIONS(1167),
    [anon_sym_do] = ACTIONS(1167),
    [anon_sym_for] = ACTIONS(1167),
    [anon_sym_return] = ACTIONS(1167),
    [anon_sym_break] = ACTIONS(1167),
    [anon_sym_continue] = ACTIONS(1167),
    [anon_sym_goto] = ACTIONS(1167),
    [anon_sym___try] = ACTIONS(1167),
    [anon_sym___except] = ACTIONS(1167),
    [anon_sym___finally] = ACTIONS(1167),
    [anon_sym___leave] = ACTIONS(1167),
    [anon_sym_DASH_DASH] = ACTIONS(1169),
    [anon_sym_PLUS_PLUS] = ACTIONS(1169),
    [anon_sym_sizeof] = ACTIONS(1167),
    [anon_sym___alignof__] = ACTIONS(1167),
    [anon_sym___alignof] = ACTIONS(1167),
    [anon_sym__alignof] = ACTIONS(1167),
    [anon_sym_alignof] = ACTIONS(1167),
    [anon_sym__Alignof] = ACTIONS(1167),
    [anon_sym_offsetof] = ACTIONS(1167),
    [anon_sym__Generic] = ACTIONS(1167),
    [anon_sym_asm] = ACTIONS(1167),
    [anon_sym___asm__] = ACTIONS(1167),
    [sym_number_literal] = ACTIONS(1169),
    [anon_sym_L_SQUOTE] = ACTIONS(1169),
    [anon_sym_u_SQUOTE] = ACTIONS(1169),
    [anon_sym_U_SQUOTE] = ACTIONS(1169),
    [anon_sym_u8_SQUOTE] = ACTIONS(1169),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [anon_sym_L_DQUOTE] = ACTIONS(1169),
    [anon_sym_u_DQUOTE] = ACTIONS(1169),
    [anon_sym_U_DQUOTE] = ACTIONS(1169),
    [anon_sym_u8_DQUOTE] = ACTIONS(1169),
    [anon_sym_DQUOTE] = ACTIONS(1169),
    [sym_true] = ACTIONS(1167),
    [sym_false] = ACTIONS(1167),
    [anon_sym_NULL] = ACTIONS(1167),
    [anon_sym_nullptr] = ACTIONS(1167),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [sym_identifier] = ACTIONS(1223),
    [aux_sym_preproc_include_token1] = ACTIONS(1223),
    [aux_sym_preproc_def_token1] = ACTIONS(1223),
    [aux_sym_preproc_if_token1] = ACTIONS(1223),
    [aux_sym_preproc_if_token2] = ACTIONS(1223),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1223),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1223),
    [aux_sym_preproc_else_token1] = ACTIONS(1223),
    [aux_sym_preproc_elif_token1] = ACTIONS(1223),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1223),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1223),
    [sym_preproc_directive] = ACTIONS(1223),
    [anon_sym_LPAREN2] = ACTIONS(1225),
    [anon_sym_BANG] = ACTIONS(1225),
    [anon_sym_TILDE] = ACTIONS(1225),
    [anon_sym_DASH] = ACTIONS(1223),
    [anon_sym_PLUS] = ACTIONS(1223),
    [anon_sym_STAR] = ACTIONS(1225),
    [anon_sym_AMP] = ACTIONS(1225),
    [anon_sym_SEMI] = ACTIONS(1225),
    [anon_sym___extension__] = ACTIONS(1223),
    [anon_sym_typedef] = ACTIONS(1223),
    [anon_sym_extern] = ACTIONS(1223),
    [anon_sym___attribute__] = ACTIONS(1223),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1225),
    [anon_sym___declspec] = ACTIONS(1223),
    [anon_sym___cdecl] = ACTIONS(1223),
    [anon_sym___clrcall] = ACTIONS(1223),
    [anon_sym___stdcall] = ACTIONS(1223),
    [anon_sym___fastcall] = ACTIONS(1223),
    [anon_sym___thiscall] = ACTIONS(1223),
    [anon_sym___vectorcall] = ACTIONS(1223),
    [anon_sym_LBRACE] = ACTIONS(1225),
    [anon_sym_signed] = ACTIONS(1223),
    [anon_sym_unsigned] = ACTIONS(1223),
    [anon_sym_long] = ACTIONS(1223),
    [anon_sym_short] = ACTIONS(1223),
    [anon_sym_static] = ACTIONS(1223),
    [anon_sym_auto] = ACTIONS(1223),
    [anon_sym_register] = ACTIONS(1223),
    [anon_sym_inline] = ACTIONS(1223),
    [anon_sym___inline] = ACTIONS(1223),
    [anon_sym___inline__] = ACTIONS(1223),
    [anon_sym___forceinline] = ACTIONS(1223),
    [anon_sym_thread_local] = ACTIONS(1223),
    [anon_sym___thread] = ACTIONS(1223),
    [anon_sym_const] = ACTIONS(1223),
    [anon_sym_constexpr] = ACTIONS(1223),
    [anon_sym_volatile] = ACTIONS(1223),
    [anon_sym_restrict] = ACTIONS(1223),
    [anon_sym___restrict__] = ACTIONS(1223),
    [anon_sym__Atomic] = ACTIONS(1223),
    [anon_sym__Noreturn] = ACTIONS(1223),
    [anon_sym_noreturn] = ACTIONS(1223),
    [anon_sym_alignas] = ACTIONS(1223),
    [anon_sym__Alignas] = ACTIONS(1223),
    [sym_primitive_type] = ACTIONS(1223),
    [anon_sym_enum] = ACTIONS(1223),
    [anon_sym_struct] = ACTIONS(1223),
    [anon_sym_union] = ACTIONS(1223),
    [anon_sym_if] = ACTIONS(1223),
    [anon_sym_else] = ACTIONS(1223),
    [anon_sym_switch] = ACTIONS(1223),
    [anon_sym_case] = ACTIONS(1223),
    [anon_sym_default] = ACTIONS(1223),
    [anon_sym_while] = ACTIONS(1223),
    [anon_sym_do] = ACTIONS(1223),
    [anon_sym_for] = ACTIONS(1223),
    [anon_sym_return] = ACTIONS(1223),
    [anon_sym_break] = ACTIONS(1223),
    [anon_sym_continue] = ACTIONS(1223),
    [anon_sym_goto] = ACTIONS(1223),
    [anon_sym___try] = ACTIONS(1223),
    [anon_sym___leave] = ACTIONS(1223),
    [anon_sym_DASH_DASH] = ACTIONS(1225),
    [anon_sym_PLUS_PLUS] = ACTIONS(1225),
    [anon_sym_sizeof] = ACTIONS(1223),
    [anon_sym___alignof__] = ACTIONS(1223),
    [anon_sym___alignof] = ACTIONS(1223),
    [anon_sym__alignof] = ACTIONS(1223),
    [anon_sym_alignof] = ACTIONS(1223),
    [anon_sym__Alignof] = ACTIONS(1223),
    [anon_sym_offsetof] = ACTIONS(1223),
    [anon_sym__Generic] = ACTIONS(1223),
    [anon_sym_asm] = ACTIONS(1223),
    [anon_sym___asm__] = ACTIONS(1223),
    [sym_number_literal] = ACTIONS(1225),
    [anon_sym_L_SQUOTE] = ACTIONS(1225),
    [anon_sym_u_SQUOTE] = ACTIONS(1225),
    [anon_sym_U_SQUOTE] = ACTIONS(1225),
    [anon_sym_u8_SQUOTE] = ACTIONS(1225),
    [anon_sym_SQUOTE] = ACTIONS(1225),
    [anon_sym_L_DQUOTE] = ACTIONS(1225),
    [anon_sym_u_DQUOTE] = ACTIONS(1225),
    [anon_sym_U_DQUOTE] = ACTIONS(1225),
    [anon_sym_u8_DQUOTE] = ACTIONS(1225),
    [anon_sym_DQUOTE] = ACTIONS(1225),
    [sym_true] = ACTIONS(1223),
    [sym_false] = ACTIONS(1223),
    [anon_sym_NULL] = ACTIONS(1223),
    [anon_sym_nullptr] = ACTIONS(1223),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [sym_identifier] = ACTIONS(1227),
    [aux_sym_preproc_include_token1] = ACTIONS(1227),
    [aux_sym_preproc_def_token1] = ACTIONS(1227),
    [aux_sym_preproc_if_token1] = ACTIONS(1227),
    [aux_sym_preproc_if_token2] = ACTIONS(1227),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1227),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1227),
    [aux_sym_preproc_else_token1] = ACTIONS(1227),
    [aux_sym_preproc_elif_token1] = ACTIONS(1227),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1227),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1227),
    [sym_preproc_directive] = ACTIONS(1227),
    [anon_sym_LPAREN2] = ACTIONS(1229),
    [anon_sym_BANG] = ACTIONS(1229),
    [anon_sym_TILDE] = ACTIONS(1229),
    [anon_sym_DASH] = ACTIONS(1227),
    [anon_sym_PLUS] = ACTIONS(1227),
    [anon_sym_STAR] = ACTIONS(1229),
    [anon_sym_AMP] = ACTIONS(1229),
    [anon_sym_SEMI] = ACTIONS(1229),
    [anon_sym___extension__] = ACTIONS(1227),
    [anon_sym_typedef] = ACTIONS(1227),
    [anon_sym_extern] = ACTIONS(1227),
    [anon_sym___attribute__] = ACTIONS(1227),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1229),
    [anon_sym___declspec] = ACTIONS(1227),
    [anon_sym___cdecl] = ACTIONS(1227),
    [anon_sym___clrcall] = ACTIONS(1227),
    [anon_sym___stdcall] = ACTIONS(1227),
    [anon_sym___fastcall] = ACTIONS(1227),
    [anon_sym___thiscall] = ACTIONS(1227),
    [anon_sym___vectorcall] = ACTIONS(1227),
    [anon_sym_LBRACE] = ACTIONS(1229),
    [anon_sym_signed] = ACTIONS(1227),
    [anon_sym_unsigned] = ACTIONS(1227),
    [anon_sym_long] = ACTIONS(1227),
    [anon_sym_short] = ACTIONS(1227),
    [anon_sym_static] = ACTIONS(1227),
    [anon_sym_auto] = ACTIONS(1227),
    [anon_sym_register] = ACTIONS(1227),
    [anon_sym_inline] = ACTIONS(1227),
    [anon_sym___inline] = ACTIONS(1227),
    [anon_sym___inline__] = ACTIONS(1227),
    [anon_sym___forceinline] = ACTIONS(1227),
    [anon_sym_thread_local] = ACTIONS(1227),
    [anon_sym___thread] = ACTIONS(1227),
    [anon_sym_const] = ACTIONS(1227),
    [anon_sym_constexpr] = ACTIONS(1227),
    [anon_sym_volatile] = ACTIONS(1227),
    [anon_sym_restrict] = ACTIONS(1227),
    [anon_sym___restrict__] = ACTIONS(1227),
    [anon_sym__Atomic] = ACTIONS(1227),
    [anon_sym__Noreturn] = ACTIONS(1227),
    [anon_sym_noreturn] = ACTIONS(1227),
    [anon_sym_alignas] = ACTIONS(1227),
    [anon_sym__Alignas] = ACTIONS(1227),
    [sym_primitive_type] = ACTIONS(1227),
    [anon_sym_enum] = ACTIONS(1227),
    [anon_sym_struct] = ACTIONS(1227),
    [anon_sym_union] = ACTIONS(1227),
    [anon_sym_if] = ACTIONS(1227),
    [anon_sym_else] = ACTIONS(1227),
    [anon_sym_switch] = ACTIONS(1227),
    [anon_sym_case] = ACTIONS(1227),
    [anon_sym_default] = ACTIONS(1227),
    [anon_sym_while] = ACTIONS(1227),
    [anon_sym_do] = ACTIONS(1227),
    [anon_sym_for] = ACTIONS(1227),
    [anon_sym_return] = ACTIONS(1227),
    [anon_sym_break] = ACTIONS(1227),
    [anon_sym_continue] = ACTIONS(1227),
    [anon_sym_goto] = ACTIONS(1227),
    [anon_sym___try] = ACTIONS(1227),
    [anon_sym___leave] = ACTIONS(1227),
    [anon_sym_DASH_DASH] = ACTIONS(1229),
    [anon_sym_PLUS_PLUS] = ACTIONS(1229),
    [anon_sym_sizeof] = ACTIONS(1227),
    [anon_sym___alignof__] = ACTIONS(1227),
    [anon_sym___alignof] = ACTIONS(1227),
    [anon_sym__alignof] = ACTIONS(1227),
    [anon_sym_alignof] = ACTIONS(1227),
    [anon_sym__Alignof] = ACTIONS(1227),
    [anon_sym_offsetof] = ACTIONS(1227),
    [anon_sym__Generic] = ACTIONS(1227),
    [anon_sym_asm] = ACTIONS(1227),
    [anon_sym___asm__] = ACTIONS(1227),
    [sym_number_literal] = ACTIONS(1229),
    [anon_sym_L_SQUOTE] = ACTIONS(1229),
    [anon_sym_u_SQUOTE] = ACTIONS(1229),
    [anon_sym_U_SQUOTE] = ACTIONS(1229),
    [anon_sym_u8_SQUOTE] = ACTIONS(1229),
    [anon_sym_SQUOTE] = ACTIONS(1229),
    [anon_sym_L_DQUOTE] = ACTIONS(1229),
    [anon_sym_u_DQUOTE] = ACTIONS(1229),
    [anon_sym_U_DQUOTE] = ACTIONS(1229),
    [anon_sym_u8_DQUOTE] = ACTIONS(1229),
    [anon_sym_DQUOTE] = ACTIONS(1229),
    [sym_true] = ACTIONS(1227),
    [sym_false] = ACTIONS(1227),
    [anon_sym_NULL] = ACTIONS(1227),
    [anon_sym_nullptr] = ACTIONS(1227),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [sym_identifier] = ACTIONS(1231),
    [aux_sym_preproc_include_token1] = ACTIONS(1231),
    [aux_sym_preproc_def_token1] = ACTIONS(1231),
    [aux_sym_preproc_if_token1] = ACTIONS(1231),
    [aux_sym_preproc_if_token2] = ACTIONS(1231),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1231),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1231),
    [aux_sym_preproc_else_token1] = ACTIONS(1231),
    [aux_sym_preproc_elif_token1] = ACTIONS(1231),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1231),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1231),
    [sym_preproc_directive] = ACTIONS(1231),
    [anon_sym_LPAREN2] = ACTIONS(1233),
    [anon_sym_BANG] = ACTIONS(1233),
    [anon_sym_TILDE] = ACTIONS(1233),
    [anon_sym_DASH] = ACTIONS(1231),
    [anon_sym_PLUS] = ACTIONS(1231),
    [anon_sym_STAR] = ACTIONS(1233),
    [anon_sym_AMP] = ACTIONS(1233),
    [anon_sym_SEMI] = ACTIONS(1233),
    [anon_sym___extension__] = ACTIONS(1231),
    [anon_sym_typedef] = ACTIONS(1231),
    [anon_sym_extern] = ACTIONS(1231),
    [anon_sym___attribute__] = ACTIONS(1231),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1233),
    [anon_sym___declspec] = ACTIONS(1231),
    [anon_sym___cdecl] = ACTIONS(1231),
    [anon_sym___clrcall] = ACTIONS(1231),
    [anon_sym___stdcall] = ACTIONS(1231),
    [anon_sym___fastcall] = ACTIONS(1231),
    [anon_sym___thiscall] = ACTIONS(1231),
    [anon_sym___vectorcall] = ACTIONS(1231),
    [anon_sym_LBRACE] = ACTIONS(1233),
    [anon_sym_signed] = ACTIONS(1231),
    [anon_sym_unsigned] = ACTIONS(1231),
    [anon_sym_long] = ACTIONS(1231),
    [anon_sym_short] = ACTIONS(1231),
    [anon_sym_static] = ACTIONS(1231),
    [anon_sym_auto] = ACTIONS(1231),
    [anon_sym_register] = ACTIONS(1231),
    [anon_sym_inline] = ACTIONS(1231),
    [anon_sym___inline] = ACTIONS(1231),
    [anon_sym___inline__] = ACTIONS(1231),
    [anon_sym___forceinline] = ACTIONS(1231),
    [anon_sym_thread_local] = ACTIONS(1231),
    [anon_sym___thread] = ACTIONS(1231),
    [anon_sym_const] = ACTIONS(1231),
    [anon_sym_constexpr] = ACTIONS(1231),
    [anon_sym_volatile] = ACTIONS(1231),
    [anon_sym_restrict] = ACTIONS(1231),
    [anon_sym___restrict__] = ACTIONS(1231),
    [anon_sym__Atomic] = ACTIONS(1231),
    [anon_sym__Noreturn] = ACTIONS(1231),
    [anon_sym_noreturn] = ACTIONS(1231),
    [anon_sym_alignas] = ACTIONS(1231),
    [anon_sym__Alignas] = ACTIONS(1231),
    [sym_primitive_type] = ACTIONS(1231),
    [anon_sym_enum] = ACTIONS(1231),
    [anon_sym_struct] = ACTIONS(1231),
    [anon_sym_union] = ACTIONS(1231),
    [anon_sym_if] = ACTIONS(1231),
    [anon_sym_else] = ACTIONS(1231),
    [anon_sym_switch] = ACTIONS(1231),
    [anon_sym_case] = ACTIONS(1231),
    [anon_sym_default] = ACTIONS(1231),
    [anon_sym_while] = ACTIONS(1231),
    [anon_sym_do] = ACTIONS(1231),
    [anon_sym_for] = ACTIONS(1231),
    [anon_sym_return] = ACTIONS(1231),
    [anon_sym_break] = ACTIONS(1231),
    [anon_sym_continue] = ACTIONS(1231),
    [anon_sym_goto] = ACTIONS(1231),
    [anon_sym___try] = ACTIONS(1231),
    [anon_sym___leave] = ACTIONS(1231),
    [anon_sym_DASH_DASH] = ACTIONS(1233),
    [anon_sym_PLUS_PLUS] = ACTIONS(1233),
    [anon_sym_sizeof] = ACTIONS(1231),
    [anon_sym___alignof__] = ACTIONS(1231),
    [anon_sym___alignof] = ACTIONS(1231),
    [anon_sym__alignof] = ACTIONS(1231),
    [anon_sym_alignof] = ACTIONS(1231),
    [anon_sym__Alignof] = ACTIONS(1231),
    [anon_sym_offsetof] = ACTIONS(1231),
    [anon_sym__Generic] = ACTIONS(1231),
    [anon_sym_asm] = ACTIONS(1231),
    [anon_sym___asm__] = ACTIONS(1231),
    [sym_number_literal] = ACTIONS(1233),
    [anon_sym_L_SQUOTE] = ACTIONS(1233),
    [anon_sym_u_SQUOTE] = ACTIONS(1233),
    [anon_sym_U_SQUOTE] = ACTIONS(1233),
    [anon_sym_u8_SQUOTE] = ACTIONS(1233),
    [anon_sym_SQUOTE] = ACTIONS(1233),
    [anon_sym_L_DQUOTE] = ACTIONS(1233),
    [anon_sym_u_DQUOTE] = ACTIONS(1233),
    [anon_sym_U_DQUOTE] = ACTIONS(1233),
    [anon_sym_u8_DQUOTE] = ACTIONS(1233),
    [anon_sym_DQUOTE] = ACTIONS(1233),
    [sym_true] = ACTIONS(1231),
    [sym_false] = ACTIONS(1231),
    [anon_sym_NULL] = ACTIONS(1231),
    [anon_sym_nullptr] = ACTIONS(1231),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [sym_identifier] = ACTIONS(1235),
    [aux_sym_preproc_include_token1] = ACTIONS(1235),
    [aux_sym_preproc_def_token1] = ACTIONS(1235),
    [aux_sym_preproc_if_token1] = ACTIONS(1235),
    [aux_sym_preproc_if_token2] = ACTIONS(1235),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1235),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1235),
    [aux_sym_preproc_else_token1] = ACTIONS(1235),
    [aux_sym_preproc_elif_token1] = ACTIONS(1235),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1235),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1235),
    [sym_preproc_directive] = ACTIONS(1235),
    [anon_sym_LPAREN2] = ACTIONS(1237),
    [anon_sym_BANG] = ACTIONS(1237),
    [anon_sym_TILDE] = ACTIONS(1237),
    [anon_sym_DASH] = ACTIONS(1235),
    [anon_sym_PLUS] = ACTIONS(1235),
    [anon_sym_STAR] = ACTIONS(1237),
    [anon_sym_AMP] = ACTIONS(1237),
    [anon_sym_SEMI] = ACTIONS(1237),
    [anon_sym___extension__] = ACTIONS(1235),
    [anon_sym_typedef] = ACTIONS(1235),
    [anon_sym_extern] = ACTIONS(1235),
    [anon_sym___attribute__] = ACTIONS(1235),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1237),
    [anon_sym___declspec] = ACTIONS(1235),
    [anon_sym___cdecl] = ACTIONS(1235),
    [anon_sym___clrcall] = ACTIONS(1235),
    [anon_sym___stdcall] = ACTIONS(1235),
    [anon_sym___fastcall] = ACTIONS(1235),
    [anon_sym___thiscall] = ACTIONS(1235),
    [anon_sym___vectorcall] = ACTIONS(1235),
    [anon_sym_LBRACE] = ACTIONS(1237),
    [anon_sym_signed] = ACTIONS(1235),
    [anon_sym_unsigned] = ACTIONS(1235),
    [anon_sym_long] = ACTIONS(1235),
    [anon_sym_short] = ACTIONS(1235),
    [anon_sym_static] = ACTIONS(1235),
    [anon_sym_auto] = ACTIONS(1235),
    [anon_sym_register] = ACTIONS(1235),
    [anon_sym_inline] = ACTIONS(1235),
    [anon_sym___inline] = ACTIONS(1235),
    [anon_sym___inline__] = ACTIONS(1235),
    [anon_sym___forceinline] = ACTIONS(1235),
    [anon_sym_thread_local] = ACTIONS(1235),
    [anon_sym___thread] = ACTIONS(1235),
    [anon_sym_const] = ACTIONS(1235),
    [anon_sym_constexpr] = ACTIONS(1235),
    [anon_sym_volatile] = ACTIONS(1235),
    [anon_sym_restrict] = ACTIONS(1235),
    [anon_sym___restrict__] = ACTIONS(1235),
    [anon_sym__Atomic] = ACTIONS(1235),
    [anon_sym__Noreturn] = ACTIONS(1235),
    [anon_sym_noreturn] = ACTIONS(1235),
    [anon_sym_alignas] = ACTIONS(1235),
    [anon_sym__Alignas] = ACTIONS(1235),
    [sym_primitive_type] = ACTIONS(1235),
    [anon_sym_enum] = ACTIONS(1235),
    [anon_sym_struct] = ACTIONS(1235),
    [anon_sym_union] = ACTIONS(1235),
    [anon_sym_if] = ACTIONS(1235),
    [anon_sym_else] = ACTIONS(1235),
    [anon_sym_switch] = ACTIONS(1235),
    [anon_sym_case] = ACTIONS(1235),
    [anon_sym_default] = ACTIONS(1235),
    [anon_sym_while] = ACTIONS(1235),
    [anon_sym_do] = ACTIONS(1235),
    [anon_sym_for] = ACTIONS(1235),
    [anon_sym_return] = ACTIONS(1235),
    [anon_sym_break] = ACTIONS(1235),
    [anon_sym_continue] = ACTIONS(1235),
    [anon_sym_goto] = ACTIONS(1235),
    [anon_sym___try] = ACTIONS(1235),
    [anon_sym___leave] = ACTIONS(1235),
    [anon_sym_DASH_DASH] = ACTIONS(1237),
    [anon_sym_PLUS_PLUS] = ACTIONS(1237),
    [anon_sym_sizeof] = ACTIONS(1235),
    [anon_sym___alignof__] = ACTIONS(1235),
    [anon_sym___alignof] = ACTIONS(1235),
    [anon_sym__alignof] = ACTIONS(1235),
    [anon_sym_alignof] = ACTIONS(1235),
    [anon_sym__Alignof] = ACTIONS(1235),
    [anon_sym_offsetof] = ACTIONS(1235),
    [anon_sym__Generic] = ACTIONS(1235),
    [anon_sym_asm] = ACTIONS(1235),
    [anon_sym___asm__] = ACTIONS(1235),
    [sym_number_literal] = ACTIONS(1237),
    [anon_sym_L_SQUOTE] = ACTIONS(1237),
    [anon_sym_u_SQUOTE] = ACTIONS(1237),
    [anon_sym_U_SQUOTE] = ACTIONS(1237),
    [anon_sym_u8_SQUOTE] = ACTIONS(1237),
    [anon_sym_SQUOTE] = ACTIONS(1237),
    [anon_sym_L_DQUOTE] = ACTIONS(1237),
    [anon_sym_u_DQUOTE] = ACTIONS(1237),
    [anon_sym_U_DQUOTE] = ACTIONS(1237),
    [anon_sym_u8_DQUOTE] = ACTIONS(1237),
    [anon_sym_DQUOTE] = ACTIONS(1237),
    [sym_true] = ACTIONS(1235),
    [sym_false] = ACTIONS(1235),
    [anon_sym_NULL] = ACTIONS(1235),
    [anon_sym_nullptr] = ACTIONS(1235),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [sym_identifier] = ACTIONS(1239),
    [aux_sym_preproc_include_token1] = ACTIONS(1239),
    [aux_sym_preproc_def_token1] = ACTIONS(1239),
    [aux_sym_preproc_if_token1] = ACTIONS(1239),
    [aux_sym_preproc_if_token2] = ACTIONS(1239),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1239),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1239),
    [aux_sym_preproc_else_token1] = ACTIONS(1239),
    [aux_sym_preproc_elif_token1] = ACTIONS(1239),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1239),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1239),
    [sym_preproc_directive] = ACTIONS(1239),
    [anon_sym_LPAREN2] = ACTIONS(1241),
    [anon_sym_BANG] = ACTIONS(1241),
    [anon_sym_TILDE] = ACTIONS(1241),
    [anon_sym_DASH] = ACTIONS(1239),
    [anon_sym_PLUS] = ACTIONS(1239),
    [anon_sym_STAR] = ACTIONS(1241),
    [anon_sym_AMP] = ACTIONS(1241),
    [anon_sym_SEMI] = ACTIONS(1241),
    [anon_sym___extension__] = ACTIONS(1239),
    [anon_sym_typedef] = ACTIONS(1239),
    [anon_sym_extern] = ACTIONS(1239),
    [anon_sym___attribute__] = ACTIONS(1239),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1241),
    [anon_sym___declspec] = ACTIONS(1239),
    [anon_sym___cdecl] = ACTIONS(1239),
    [anon_sym___clrcall] = ACTIONS(1239),
    [anon_sym___stdcall] = ACTIONS(1239),
    [anon_sym___fastcall] = ACTIONS(1239),
    [anon_sym___thiscall] = ACTIONS(1239),
    [anon_sym___vectorcall] = ACTIONS(1239),
    [anon_sym_LBRACE] = ACTIONS(1241),
    [anon_sym_signed] = ACTIONS(1239),
    [anon_sym_unsigned] = ACTIONS(1239),
    [anon_sym_long] = ACTIONS(1239),
    [anon_sym_short] = ACTIONS(1239),
    [anon_sym_static] = ACTIONS(1239),
    [anon_sym_auto] = ACTIONS(1239),
    [anon_sym_register] = ACTIONS(1239),
    [anon_sym_inline] = ACTIONS(1239),
    [anon_sym___inline] = ACTIONS(1239),
    [anon_sym___inline__] = ACTIONS(1239),
    [anon_sym___forceinline] = ACTIONS(1239),
    [anon_sym_thread_local] = ACTIONS(1239),
    [anon_sym___thread] = ACTIONS(1239),
    [anon_sym_const] = ACTIONS(1239),
    [anon_sym_constexpr] = ACTIONS(1239),
    [anon_sym_volatile] = ACTIONS(1239),
    [anon_sym_restrict] = ACTIONS(1239),
    [anon_sym___restrict__] = ACTIONS(1239),
    [anon_sym__Atomic] = ACTIONS(1239),
    [anon_sym__Noreturn] = ACTIONS(1239),
    [anon_sym_noreturn] = ACTIONS(1239),
    [anon_sym_alignas] = ACTIONS(1239),
    [anon_sym__Alignas] = ACTIONS(1239),
    [sym_primitive_type] = ACTIONS(1239),
    [anon_sym_enum] = ACTIONS(1239),
    [anon_sym_struct] = ACTIONS(1239),
    [anon_sym_union] = ACTIONS(1239),
    [anon_sym_if] = ACTIONS(1239),
    [anon_sym_else] = ACTIONS(1239),
    [anon_sym_switch] = ACTIONS(1239),
    [anon_sym_case] = ACTIONS(1239),
    [anon_sym_default] = ACTIONS(1239),
    [anon_sym_while] = ACTIONS(1239),
    [anon_sym_do] = ACTIONS(1239),
    [anon_sym_for] = ACTIONS(1239),
    [anon_sym_return] = ACTIONS(1239),
    [anon_sym_break] = ACTIONS(1239),
    [anon_sym_continue] = ACTIONS(1239),
    [anon_sym_goto] = ACTIONS(1239),
    [anon_sym___try] = ACTIONS(1239),
    [anon_sym___leave] = ACTIONS(1239),
    [anon_sym_DASH_DASH] = ACTIONS(1241),
    [anon_sym_PLUS_PLUS] = ACTIONS(1241),
    [anon_sym_sizeof] = ACTIONS(1239),
    [anon_sym___alignof__] = ACTIONS(1239),
    [anon_sym___alignof] = ACTIONS(1239),
    [anon_sym__alignof] = ACTIONS(1239),
    [anon_sym_alignof] = ACTIONS(1239),
    [anon_sym__Alignof] = ACTIONS(1239),
    [anon_sym_offsetof] = ACTIONS(1239),
    [anon_sym__Generic] = ACTIONS(1239),
    [anon_sym_asm] = ACTIONS(1239),
    [anon_sym___asm__] = ACTIONS(1239),
    [sym_number_literal] = ACTIONS(1241),
    [anon_sym_L_SQUOTE] = ACTIONS(1241),
    [anon_sym_u_SQUOTE] = ACTIONS(1241),
    [anon_sym_U_SQUOTE] = ACTIONS(1241),
    [anon_sym_u8_SQUOTE] = ACTIONS(1241),
    [anon_sym_SQUOTE] = ACTIONS(1241),
    [anon_sym_L_DQUOTE] = ACTIONS(1241),
    [anon_sym_u_DQUOTE] = ACTIONS(1241),
    [anon_sym_U_DQUOTE] = ACTIONS(1241),
    [anon_sym_u8_DQUOTE] = ACTIONS(1241),
    [anon_sym_DQUOTE] = ACTIONS(1241),
    [sym_true] = ACTIONS(1239),
    [sym_false] = ACTIONS(1239),
    [anon_sym_NULL] = ACTIONS(1239),
    [anon_sym_nullptr] = ACTIONS(1239),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [sym_identifier] = ACTIONS(1243),
    [aux_sym_preproc_include_token1] = ACTIONS(1243),
    [aux_sym_preproc_def_token1] = ACTIONS(1243),
    [aux_sym_preproc_if_token1] = ACTIONS(1243),
    [aux_sym_preproc_if_token2] = ACTIONS(1243),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1243),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1243),
    [aux_sym_preproc_else_token1] = ACTIONS(1243),
    [aux_sym_preproc_elif_token1] = ACTIONS(1243),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1243),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1243),
    [sym_preproc_directive] = ACTIONS(1243),
    [anon_sym_LPAREN2] = ACTIONS(1245),
    [anon_sym_BANG] = ACTIONS(1245),
    [anon_sym_TILDE] = ACTIONS(1245),
    [anon_sym_DASH] = ACTIONS(1243),
    [anon_sym_PLUS] = ACTIONS(1243),
    [anon_sym_STAR] = ACTIONS(1245),
    [anon_sym_AMP] = ACTIONS(1245),
    [anon_sym_SEMI] = ACTIONS(1245),
    [anon_sym___extension__] = ACTIONS(1243),
    [anon_sym_typedef] = ACTIONS(1243),
    [anon_sym_extern] = ACTIONS(1243),
    [anon_sym___attribute__] = ACTIONS(1243),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1245),
    [anon_sym___declspec] = ACTIONS(1243),
    [anon_sym___cdecl] = ACTIONS(1243),
    [anon_sym___clrcall] = ACTIONS(1243),
    [anon_sym___stdcall] = ACTIONS(1243),
    [anon_sym___fastcall] = ACTIONS(1243),
    [anon_sym___thiscall] = ACTIONS(1243),
    [anon_sym___vectorcall] = ACTIONS(1243),
    [anon_sym_LBRACE] = ACTIONS(1245),
    [anon_sym_signed] = ACTIONS(1243),
    [anon_sym_unsigned] = ACTIONS(1243),
    [anon_sym_long] = ACTIONS(1243),
    [anon_sym_short] = ACTIONS(1243),
    [anon_sym_static] = ACTIONS(1243),
    [anon_sym_auto] = ACTIONS(1243),
    [anon_sym_register] = ACTIONS(1243),
    [anon_sym_inline] = ACTIONS(1243),
    [anon_sym___inline] = ACTIONS(1243),
    [anon_sym___inline__] = ACTIONS(1243),
    [anon_sym___forceinline] = ACTIONS(1243),
    [anon_sym_thread_local] = ACTIONS(1243),
    [anon_sym___thread] = ACTIONS(1243),
    [anon_sym_const] = ACTIONS(1243),
    [anon_sym_constexpr] = ACTIONS(1243),
    [anon_sym_volatile] = ACTIONS(1243),
    [anon_sym_restrict] = ACTIONS(1243),
    [anon_sym___restrict__] = ACTIONS(1243),
    [anon_sym__Atomic] = ACTIONS(1243),
    [anon_sym__Noreturn] = ACTIONS(1243),
    [anon_sym_noreturn] = ACTIONS(1243),
    [anon_sym_alignas] = ACTIONS(1243),
    [anon_sym__Alignas] = ACTIONS(1243),
    [sym_primitive_type] = ACTIONS(1243),
    [anon_sym_enum] = ACTIONS(1243),
    [anon_sym_struct] = ACTIONS(1243),
    [anon_sym_union] = ACTIONS(1243),
    [anon_sym_if] = ACTIONS(1243),
    [anon_sym_else] = ACTIONS(1243),
    [anon_sym_switch] = ACTIONS(1243),
    [anon_sym_case] = ACTIONS(1243),
    [anon_sym_default] = ACTIONS(1243),
    [anon_sym_while] = ACTIONS(1243),
    [anon_sym_do] = ACTIONS(1243),
    [anon_sym_for] = ACTIONS(1243),
    [anon_sym_return] = ACTIONS(1243),
    [anon_sym_break] = ACTIONS(1243),
    [anon_sym_continue] = ACTIONS(1243),
    [anon_sym_goto] = ACTIONS(1243),
    [anon_sym___try] = ACTIONS(1243),
    [anon_sym___leave] = ACTIONS(1243),
    [anon_sym_DASH_DASH] = ACTIONS(1245),
    [anon_sym_PLUS_PLUS] = ACTIONS(1245),
    [anon_sym_sizeof] = ACTIONS(1243),
    [anon_sym___alignof__] = ACTIONS(1243),
    [anon_sym___alignof] = ACTIONS(1243),
    [anon_sym__alignof] = ACTIONS(1243),
    [anon_sym_alignof] = ACTIONS(1243),
    [anon_sym__Alignof] = ACTIONS(1243),
    [anon_sym_offsetof] = ACTIONS(1243),
    [anon_sym__Generic] = ACTIONS(1243),
    [anon_sym_asm] = ACTIONS(1243),
    [anon_sym___asm__] = ACTIONS(1243),
    [sym_number_literal] = ACTIONS(1245),
    [anon_sym_L_SQUOTE] = ACTIONS(1245),
    [anon_sym_u_SQUOTE] = ACTIONS(1245),
    [anon_sym_U_SQUOTE] = ACTIONS(1245),
    [anon_sym_u8_SQUOTE] = ACTIONS(1245),
    [anon_sym_SQUOTE] = ACTIONS(1245),
    [anon_sym_L_DQUOTE] = ACTIONS(1245),
    [anon_sym_u_DQUOTE] = ACTIONS(1245),
    [anon_sym_U_DQUOTE] = ACTIONS(1245),
    [anon_sym_u8_DQUOTE] = ACTIONS(1245),
    [anon_sym_DQUOTE] = ACTIONS(1245),
    [sym_true] = ACTIONS(1243),
    [sym_false] = ACTIONS(1243),
    [anon_sym_NULL] = ACTIONS(1243),
    [anon_sym_nullptr] = ACTIONS(1243),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [sym_identifier] = ACTIONS(1129),
    [aux_sym_preproc_include_token1] = ACTIONS(1129),
    [aux_sym_preproc_def_token1] = ACTIONS(1129),
    [aux_sym_preproc_if_token1] = ACTIONS(1129),
    [aux_sym_preproc_if_token2] = ACTIONS(1129),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1129),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1129),
    [aux_sym_preproc_else_token1] = ACTIONS(1129),
    [aux_sym_preproc_elif_token1] = ACTIONS(1129),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1129),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1129),
    [sym_preproc_directive] = ACTIONS(1129),
    [anon_sym_LPAREN2] = ACTIONS(1127),
    [anon_sym_BANG] = ACTIONS(1127),
    [anon_sym_TILDE] = ACTIONS(1127),
    [anon_sym_DASH] = ACTIONS(1129),
    [anon_sym_PLUS] = ACTIONS(1129),
    [anon_sym_STAR] = ACTIONS(1127),
    [anon_sym_AMP] = ACTIONS(1127),
    [anon_sym_SEMI] = ACTIONS(1127),
    [anon_sym___extension__] = ACTIONS(1129),
    [anon_sym_typedef] = ACTIONS(1129),
    [anon_sym_extern] = ACTIONS(1129),
    [anon_sym___attribute__] = ACTIONS(1129),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1127),
    [anon_sym___declspec] = ACTIONS(1129),
    [anon_sym___cdecl] = ACTIONS(1129),
    [anon_sym___clrcall] = ACTIONS(1129),
    [anon_sym___stdcall] = ACTIONS(1129),
    [anon_sym___fastcall] = ACTIONS(1129),
    [anon_sym___thiscall] = ACTIONS(1129),
    [anon_sym___vectorcall] = ACTIONS(1129),
    [anon_sym_LBRACE] = ACTIONS(1127),
    [anon_sym_signed] = ACTIONS(1129),
    [anon_sym_unsigned] = ACTIONS(1129),
    [anon_sym_long] = ACTIONS(1129),
    [anon_sym_short] = ACTIONS(1129),
    [anon_sym_static] = ACTIONS(1129),
    [anon_sym_auto] = ACTIONS(1129),
    [anon_sym_register] = ACTIONS(1129),
    [anon_sym_inline] = ACTIONS(1129),
    [anon_sym___inline] = ACTIONS(1129),
    [anon_sym___inline__] = ACTIONS(1129),
    [anon_sym___forceinline] = ACTIONS(1129),
    [anon_sym_thread_local] = ACTIONS(1129),
    [anon_sym___thread] = ACTIONS(1129),
    [anon_sym_const] = ACTIONS(1129),
    [anon_sym_constexpr] = ACTIONS(1129),
    [anon_sym_volatile] = ACTIONS(1129),
    [anon_sym_restrict] = ACTIONS(1129),
    [anon_sym___restrict__] = ACTIONS(1129),
    [anon_sym__Atomic] = ACTIONS(1129),
    [anon_sym__Noreturn] = ACTIONS(1129),
    [anon_sym_noreturn] = ACTIONS(1129),
    [anon_sym_alignas] = ACTIONS(1129),
    [anon_sym__Alignas] = ACTIONS(1129),
    [sym_primitive_type] = ACTIONS(1129),
    [anon_sym_enum] = ACTIONS(1129),
    [anon_sym_struct] = ACTIONS(1129),
    [anon_sym_union] = ACTIONS(1129),
    [anon_sym_if] = ACTIONS(1129),
    [anon_sym_else] = ACTIONS(1129),
    [anon_sym_switch] = ACTIONS(1129),
    [anon_sym_case] = ACTIONS(1129),
    [anon_sym_default] = ACTIONS(1129),
    [anon_sym_while] = ACTIONS(1129),
    [anon_sym_do] = ACTIONS(1129),
    [anon_sym_for] = ACTIONS(1129),
    [anon_sym_return] = ACTIONS(1129),
    [anon_sym_break] = ACTIONS(1129),
    [anon_sym_continue] = ACTIONS(1129),
    [anon_sym_goto] = ACTIONS(1129),
    [anon_sym___try] = ACTIONS(1129),
    [anon_sym___leave] = ACTIONS(1129),
    [anon_sym_DASH_DASH] = ACTIONS(1127),
    [anon_sym_PLUS_PLUS] = ACTIONS(1127),
    [anon_sym_sizeof] = ACTIONS(1129),
    [anon_sym___alignof__] = ACTIONS(1129),
    [anon_sym___alignof] = ACTIONS(1129),
    [anon_sym__alignof] = ACTIONS(1129),
    [anon_sym_alignof] = ACTIONS(1129),
    [anon_sym__Alignof] = ACTIONS(1129),
    [anon_sym_offsetof] = ACTIONS(1129),
    [anon_sym__Generic] = ACTIONS(1129),
    [anon_sym_asm] = ACTIONS(1129),
    [anon_sym___asm__] = ACTIONS(1129),
    [sym_number_literal] = ACTIONS(1127),
    [anon_sym_L_SQUOTE] = ACTIONS(1127),
    [anon_sym_u_SQUOTE] = ACTIONS(1127),
    [anon_sym_U_SQUOTE] = ACTIONS(1127),
    [anon_sym_u8_SQUOTE] = ACTIONS(1127),
    [anon_sym_SQUOTE] = ACTIONS(1127),
    [anon_sym_L_DQUOTE] = ACTIONS(1127),
    [anon_sym_u_DQUOTE] = ACTIONS(1127),
    [anon_sym_U_DQUOTE] = ACTIONS(1127),
    [anon_sym_u8_DQUOTE] = ACTIONS(1127),
    [anon_sym_DQUOTE] = ACTIONS(1127),
    [sym_true] = ACTIONS(1129),
    [sym_false] = ACTIONS(1129),
    [anon_sym_NULL] = ACTIONS(1129),
    [anon_sym_nullptr] = ACTIONS(1129),
    [sym_comment] = ACTIONS(3),
  },
  [112] = {
    [sym_identifier] = ACTIONS(1247),
    [aux_sym_preproc_include_token1] = ACTIONS(1247),
    [aux_sym_preproc_def_token1] = ACTIONS(1247),
    [aux_sym_preproc_if_token1] = ACTIONS(1247),
    [aux_sym_preproc_if_token2] = ACTIONS(1247),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1247),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1247),
    [aux_sym_preproc_else_token1] = ACTIONS(1247),
    [aux_sym_preproc_elif_token1] = ACTIONS(1247),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1247),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1247),
    [sym_preproc_directive] = ACTIONS(1247),
    [anon_sym_LPAREN2] = ACTIONS(1249),
    [anon_sym_BANG] = ACTIONS(1249),
    [anon_sym_TILDE] = ACTIONS(1249),
    [anon_sym_DASH] = ACTIONS(1247),
    [anon_sym_PLUS] = ACTIONS(1247),
    [anon_sym_STAR] = ACTIONS(1249),
    [anon_sym_AMP] = ACTIONS(1249),
    [anon_sym_SEMI] = ACTIONS(1249),
    [anon_sym___extension__] = ACTIONS(1247),
    [anon_sym_typedef] = ACTIONS(1247),
    [anon_sym_extern] = ACTIONS(1247),
    [anon_sym___attribute__] = ACTIONS(1247),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1249),
    [anon_sym___declspec] = ACTIONS(1247),
    [anon_sym___cdecl] = ACTIONS(1247),
    [anon_sym___clrcall] = ACTIONS(1247),
    [anon_sym___stdcall] = ACTIONS(1247),
    [anon_sym___fastcall] = ACTIONS(1247),
    [anon_sym___thiscall] = ACTIONS(1247),
    [anon_sym___vectorcall] = ACTIONS(1247),
    [anon_sym_LBRACE] = ACTIONS(1249),
    [anon_sym_signed] = ACTIONS(1247),
    [anon_sym_unsigned] = ACTIONS(1247),
    [anon_sym_long] = ACTIONS(1247),
    [anon_sym_short] = ACTIONS(1247),
    [anon_sym_static] = ACTIONS(1247),
    [anon_sym_auto] = ACTIONS(1247),
    [anon_sym_register] = ACTIONS(1247),
    [anon_sym_inline] = ACTIONS(1247),
    [anon_sym___inline] = ACTIONS(1247),
    [anon_sym___inline__] = ACTIONS(1247),
    [anon_sym___forceinline] = ACTIONS(1247),
    [anon_sym_thread_local] = ACTIONS(1247),
    [anon_sym___thread] = ACTIONS(1247),
    [anon_sym_const] = ACTIONS(1247),
    [anon_sym_constexpr] = ACTIONS(1247),
    [anon_sym_volatile] = ACTIONS(1247),
    [anon_sym_restrict] = ACTIONS(1247),
    [anon_sym___restrict__] = ACTIONS(1247),
    [anon_sym__Atomic] = ACTIONS(1247),
    [anon_sym__Noreturn] = ACTIONS(1247),
    [anon_sym_noreturn] = ACTIONS(1247),
    [anon_sym_alignas] = ACTIONS(1247),
    [anon_sym__Alignas] = ACTIONS(1247),
    [sym_primitive_type] = ACTIONS(1247),
    [anon_sym_enum] = ACTIONS(1247),
    [anon_sym_struct] = ACTIONS(1247),
    [anon_sym_union] = ACTIONS(1247),
    [anon_sym_if] = ACTIONS(1247),
    [anon_sym_else] = ACTIONS(1247),
    [anon_sym_switch] = ACTIONS(1247),
    [anon_sym_case] = ACTIONS(1247),
    [anon_sym_default] = ACTIONS(1247),
    [anon_sym_while] = ACTIONS(1247),
    [anon_sym_do] = ACTIONS(1247),
    [anon_sym_for] = ACTIONS(1247),
    [anon_sym_return] = ACTIONS(1247),
    [anon_sym_break] = ACTIONS(1247),
    [anon_sym_continue] = ACTIONS(1247),
    [anon_sym_goto] = ACTIONS(1247),
    [anon_sym___try] = ACTIONS(1247),
    [anon_sym___leave] = ACTIONS(1247),
    [anon_sym_DASH_DASH] = ACTIONS(1249),
    [anon_sym_PLUS_PLUS] = ACTIONS(1249),
    [anon_sym_sizeof] = ACTIONS(1247),
    [anon_sym___alignof__] = ACTIONS(1247),
    [anon_sym___alignof] = ACTIONS(1247),
    [anon_sym__alignof] = ACTIONS(1247),
    [anon_sym_alignof] = ACTIONS(1247),
    [anon_sym__Alignof] = ACTIONS(1247),
    [anon_sym_offsetof] = ACTIONS(1247),
    [anon_sym__Generic] = ACTIONS(1247),
    [anon_sym_asm] = ACTIONS(1247),
    [anon_sym___asm__] = ACTIONS(1247),
    [sym_number_literal] = ACTIONS(1249),
    [anon_sym_L_SQUOTE] = ACTIONS(1249),
    [anon_sym_u_SQUOTE] = ACTIONS(1249),
    [anon_sym_U_SQUOTE] = ACTIONS(1249),
    [anon_sym_u8_SQUOTE] = ACTIONS(1249),
    [anon_sym_SQUOTE] = ACTIONS(1249),
    [anon_sym_L_DQUOTE] = ACTIONS(1249),
    [anon_sym_u_DQUOTE] = ACTIONS(1249),
    [anon_sym_U_DQUOTE] = ACTIONS(1249),
    [anon_sym_u8_DQUOTE] = ACTIONS(1249),
    [anon_sym_DQUOTE] = ACTIONS(1249),
    [sym_true] = ACTIONS(1247),
    [sym_false] = ACTIONS(1247),
    [anon_sym_NULL] = ACTIONS(1247),
    [anon_sym_nullptr] = ACTIONS(1247),
    [sym_comment] = ACTIONS(3),
  },
  [113] = {
    [sym_identifier] = ACTIONS(1207),
    [aux_sym_preproc_include_token1] = ACTIONS(1207),
    [aux_sym_preproc_def_token1] = ACTIONS(1207),
    [aux_sym_preproc_if_token1] = ACTIONS(1207),
    [aux_sym_preproc_if_token2] = ACTIONS(1207),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1207),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1207),
    [aux_sym_preproc_else_token1] = ACTIONS(1207),
    [aux_sym_preproc_elif_token1] = ACTIONS(1207),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1207),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1207),
    [sym_preproc_directive] = ACTIONS(1207),
    [anon_sym_LPAREN2] = ACTIONS(1209),
    [anon_sym_BANG] = ACTIONS(1209),
    [anon_sym_TILDE] = ACTIONS(1209),
    [anon_sym_DASH] = ACTIONS(1207),
    [anon_sym_PLUS] = ACTIONS(1207),
    [anon_sym_STAR] = ACTIONS(1209),
    [anon_sym_AMP] = ACTIONS(1209),
    [anon_sym_SEMI] = ACTIONS(1209),
    [anon_sym___extension__] = ACTIONS(1207),
    [anon_sym_typedef] = ACTIONS(1207),
    [anon_sym_extern] = ACTIONS(1207),
    [anon_sym___attribute__] = ACTIONS(1207),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1209),
    [anon_sym___declspec] = ACTIONS(1207),
    [anon_sym___cdecl] = ACTIONS(1207),
    [anon_sym___clrcall] = ACTIONS(1207),
    [anon_sym___stdcall] = ACTIONS(1207),
    [anon_sym___fastcall] = ACTIONS(1207),
    [anon_sym___thiscall] = ACTIONS(1207),
    [anon_sym___vectorcall] = ACTIONS(1207),
    [anon_sym_LBRACE] = ACTIONS(1209),
    [anon_sym_signed] = ACTIONS(1207),
    [anon_sym_unsigned] = ACTIONS(1207),
    [anon_sym_long] = ACTIONS(1207),
    [anon_sym_short] = ACTIONS(1207),
    [anon_sym_static] = ACTIONS(1207),
    [anon_sym_auto] = ACTIONS(1207),
    [anon_sym_register] = ACTIONS(1207),
    [anon_sym_inline] = ACTIONS(1207),
    [anon_sym___inline] = ACTIONS(1207),
    [anon_sym___inline__] = ACTIONS(1207),
    [anon_sym___forceinline] = ACTIONS(1207),
    [anon_sym_thread_local] = ACTIONS(1207),
    [anon_sym___thread] = ACTIONS(1207),
    [anon_sym_const] = ACTIONS(1207),
    [anon_sym_constexpr] = ACTIONS(1207),
    [anon_sym_volatile] = ACTIONS(1207),
    [anon_sym_restrict] = ACTIONS(1207),
    [anon_sym___restrict__] = ACTIONS(1207),
    [anon_sym__Atomic] = ACTIONS(1207),
    [anon_sym__Noreturn] = ACTIONS(1207),
    [anon_sym_noreturn] = ACTIONS(1207),
    [anon_sym_alignas] = ACTIONS(1207),
    [anon_sym__Alignas] = ACTIONS(1207),
    [sym_primitive_type] = ACTIONS(1207),
    [anon_sym_enum] = ACTIONS(1207),
    [anon_sym_struct] = ACTIONS(1207),
    [anon_sym_union] = ACTIONS(1207),
    [anon_sym_if] = ACTIONS(1207),
    [anon_sym_else] = ACTIONS(1207),
    [anon_sym_switch] = ACTIONS(1207),
    [anon_sym_case] = ACTIONS(1207),
    [anon_sym_default] = ACTIONS(1207),
    [anon_sym_while] = ACTIONS(1207),
    [anon_sym_do] = ACTIONS(1207),
    [anon_sym_for] = ACTIONS(1207),
    [anon_sym_return] = ACTIONS(1207),
    [anon_sym_break] = ACTIONS(1207),
    [anon_sym_continue] = ACTIONS(1207),
    [anon_sym_goto] = ACTIONS(1207),
    [anon_sym___try] = ACTIONS(1207),
    [anon_sym___leave] = ACTIONS(1207),
    [anon_sym_DASH_DASH] = ACTIONS(1209),
    [anon_sym_PLUS_PLUS] = ACTIONS(1209),
    [anon_sym_sizeof] = ACTIONS(1207),
    [anon_sym___alignof__] = ACTIONS(1207),
    [anon_sym___alignof] = ACTIONS(1207),
    [anon_sym__alignof] = ACTIONS(1207),
    [anon_sym_alignof] = ACTIONS(1207),
    [anon_sym__Alignof] = ACTIONS(1207),
    [anon_sym_offsetof] = ACTIONS(1207),
    [anon_sym__Generic] = ACTIONS(1207),
    [anon_sym_asm] = ACTIONS(1207),
    [anon_sym___asm__] = ACTIONS(1207),
    [sym_number_literal] = ACTIONS(1209),
    [anon_sym_L_SQUOTE] = ACTIONS(1209),
    [anon_sym_u_SQUOTE] = ACTIONS(1209),
    [anon_sym_U_SQUOTE] = ACTIONS(1209),
    [anon_sym_u8_SQUOTE] = ACTIONS(1209),
    [anon_sym_SQUOTE] = ACTIONS(1209),
    [anon_sym_L_DQUOTE] = ACTIONS(1209),
    [anon_sym_u_DQUOTE] = ACTIONS(1209),
    [anon_sym_U_DQUOTE] = ACTIONS(1209),
    [anon_sym_u8_DQUOTE] = ACTIONS(1209),
    [anon_sym_DQUOTE] = ACTIONS(1209),
    [sym_true] = ACTIONS(1207),
    [sym_false] = ACTIONS(1207),
    [anon_sym_NULL] = ACTIONS(1207),
    [anon_sym_nullptr] = ACTIONS(1207),
    [sym_comment] = ACTIONS(3),
  },
  [114] = {
    [sym_identifier] = ACTIONS(1251),
    [aux_sym_preproc_include_token1] = ACTIONS(1251),
    [aux_sym_preproc_def_token1] = ACTIONS(1251),
    [aux_sym_preproc_if_token1] = ACTIONS(1251),
    [aux_sym_preproc_if_token2] = ACTIONS(1251),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1251),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1251),
    [aux_sym_preproc_else_token1] = ACTIONS(1251),
    [aux_sym_preproc_elif_token1] = ACTIONS(1251),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1251),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1251),
    [sym_preproc_directive] = ACTIONS(1251),
    [anon_sym_LPAREN2] = ACTIONS(1253),
    [anon_sym_BANG] = ACTIONS(1253),
    [anon_sym_TILDE] = ACTIONS(1253),
    [anon_sym_DASH] = ACTIONS(1251),
    [anon_sym_PLUS] = ACTIONS(1251),
    [anon_sym_STAR] = ACTIONS(1253),
    [anon_sym_AMP] = ACTIONS(1253),
    [anon_sym_SEMI] = ACTIONS(1253),
    [anon_sym___extension__] = ACTIONS(1251),
    [anon_sym_typedef] = ACTIONS(1251),
    [anon_sym_extern] = ACTIONS(1251),
    [anon_sym___attribute__] = ACTIONS(1251),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1253),
    [anon_sym___declspec] = ACTIONS(1251),
    [anon_sym___cdecl] = ACTIONS(1251),
    [anon_sym___clrcall] = ACTIONS(1251),
    [anon_sym___stdcall] = ACTIONS(1251),
    [anon_sym___fastcall] = ACTIONS(1251),
    [anon_sym___thiscall] = ACTIONS(1251),
    [anon_sym___vectorcall] = ACTIONS(1251),
    [anon_sym_LBRACE] = ACTIONS(1253),
    [anon_sym_signed] = ACTIONS(1251),
    [anon_sym_unsigned] = ACTIONS(1251),
    [anon_sym_long] = ACTIONS(1251),
    [anon_sym_short] = ACTIONS(1251),
    [anon_sym_static] = ACTIONS(1251),
    [anon_sym_auto] = ACTIONS(1251),
    [anon_sym_register] = ACTIONS(1251),
    [anon_sym_inline] = ACTIONS(1251),
    [anon_sym___inline] = ACTIONS(1251),
    [anon_sym___inline__] = ACTIONS(1251),
    [anon_sym___forceinline] = ACTIONS(1251),
    [anon_sym_thread_local] = ACTIONS(1251),
    [anon_sym___thread] = ACTIONS(1251),
    [anon_sym_const] = ACTIONS(1251),
    [anon_sym_constexpr] = ACTIONS(1251),
    [anon_sym_volatile] = ACTIONS(1251),
    [anon_sym_restrict] = ACTIONS(1251),
    [anon_sym___restrict__] = ACTIONS(1251),
    [anon_sym__Atomic] = ACTIONS(1251),
    [anon_sym__Noreturn] = ACTIONS(1251),
    [anon_sym_noreturn] = ACTIONS(1251),
    [anon_sym_alignas] = ACTIONS(1251),
    [anon_sym__Alignas] = ACTIONS(1251),
    [sym_primitive_type] = ACTIONS(1251),
    [anon_sym_enum] = ACTIONS(1251),
    [anon_sym_struct] = ACTIONS(1251),
    [anon_sym_union] = ACTIONS(1251),
    [anon_sym_if] = ACTIONS(1251),
    [anon_sym_switch] = ACTIONS(1251),
    [anon_sym_case] = ACTIONS(1251),
    [anon_sym_default] = ACTIONS(1251),
    [anon_sym_while] = ACTIONS(1251),
    [anon_sym_do] = ACTIONS(1251),
    [anon_sym_for] = ACTIONS(1251),
    [anon_sym_return] = ACTIONS(1251),
    [anon_sym_break] = ACTIONS(1251),
    [anon_sym_continue] = ACTIONS(1251),
    [anon_sym_goto] = ACTIONS(1251),
    [anon_sym___try] = ACTIONS(1251),
    [anon_sym___leave] = ACTIONS(1251),
    [anon_sym_DASH_DASH] = ACTIONS(1253),
    [anon_sym_PLUS_PLUS] = ACTIONS(1253),
    [anon_sym_sizeof] = ACTIONS(1251),
    [anon_sym___alignof__] = ACTIONS(1251),
    [anon_sym___alignof] = ACTIONS(1251),
    [anon_sym__alignof] = ACTIONS(1251),
    [anon_sym_alignof] = ACTIONS(1251),
    [anon_sym__Alignof] = ACTIONS(1251),
    [anon_sym_offsetof] = ACTIONS(1251),
    [anon_sym__Generic] = ACTIONS(1251),
    [anon_sym_asm] = ACTIONS(1251),
    [anon_sym___asm__] = ACTIONS(1251),
    [sym_number_literal] = ACTIONS(1253),
    [anon_sym_L_SQUOTE] = ACTIONS(1253),
    [anon_sym_u_SQUOTE] = ACTIONS(1253),
    [anon_sym_U_SQUOTE] = ACTIONS(1253),
    [anon_sym_u8_SQUOTE] = ACTIONS(1253),
    [anon_sym_SQUOTE] = ACTIONS(1253),
    [anon_sym_L_DQUOTE] = ACTIONS(1253),
    [anon_sym_u_DQUOTE] = ACTIONS(1253),
    [anon_sym_U_DQUOTE] = ACTIONS(1253),
    [anon_sym_u8_DQUOTE] = ACTIONS(1253),
    [anon_sym_DQUOTE] = ACTIONS(1253),
    [sym_true] = ACTIONS(1251),
    [sym_false] = ACTIONS(1251),
    [anon_sym_NULL] = ACTIONS(1251),
    [anon_sym_nullptr] = ACTIONS(1251),
    [sym_comment] = ACTIONS(3),
  },
  [115] = {
    [sym_identifier] = ACTIONS(1255),
    [aux_sym_preproc_include_token1] = ACTIONS(1255),
    [aux_sym_preproc_def_token1] = ACTIONS(1255),
    [aux_sym_preproc_if_token1] = ACTIONS(1255),
    [aux_sym_preproc_if_token2] = ACTIONS(1255),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1255),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1255),
    [aux_sym_preproc_else_token1] = ACTIONS(1255),
    [aux_sym_preproc_elif_token1] = ACTIONS(1255),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1255),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1255),
    [sym_preproc_directive] = ACTIONS(1255),
    [anon_sym_LPAREN2] = ACTIONS(1257),
    [anon_sym_BANG] = ACTIONS(1257),
    [anon_sym_TILDE] = ACTIONS(1257),
    [anon_sym_DASH] = ACTIONS(1255),
    [anon_sym_PLUS] = ACTIONS(1255),
    [anon_sym_STAR] = ACTIONS(1257),
    [anon_sym_AMP] = ACTIONS(1257),
    [anon_sym_SEMI] = ACTIONS(1257),
    [anon_sym___extension__] = ACTIONS(1255),
    [anon_sym_typedef] = ACTIONS(1255),
    [anon_sym_extern] = ACTIONS(1255),
    [anon_sym___attribute__] = ACTIONS(1255),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1257),
    [anon_sym___declspec] = ACTIONS(1255),
    [anon_sym___cdecl] = ACTIONS(1255),
    [anon_sym___clrcall] = ACTIONS(1255),
    [anon_sym___stdcall] = ACTIONS(1255),
    [anon_sym___fastcall] = ACTIONS(1255),
    [anon_sym___thiscall] = ACTIONS(1255),
    [anon_sym___vectorcall] = ACTIONS(1255),
    [anon_sym_LBRACE] = ACTIONS(1257),
    [anon_sym_signed] = ACTIONS(1255),
    [anon_sym_unsigned] = ACTIONS(1255),
    [anon_sym_long] = ACTIONS(1255),
    [anon_sym_short] = ACTIONS(1255),
    [anon_sym_static] = ACTIONS(1255),
    [anon_sym_auto] = ACTIONS(1255),
    [anon_sym_register] = ACTIONS(1255),
    [anon_sym_inline] = ACTIONS(1255),
    [anon_sym___inline] = ACTIONS(1255),
    [anon_sym___inline__] = ACTIONS(1255),
    [anon_sym___forceinline] = ACTIONS(1255),
    [anon_sym_thread_local] = ACTIONS(1255),
    [anon_sym___thread] = ACTIONS(1255),
    [anon_sym_const] = ACTIONS(1255),
    [anon_sym_constexpr] = ACTIONS(1255),
    [anon_sym_volatile] = ACTIONS(1255),
    [anon_sym_restrict] = ACTIONS(1255),
    [anon_sym___restrict__] = ACTIONS(1255),
    [anon_sym__Atomic] = ACTIONS(1255),
    [anon_sym__Noreturn] = ACTIONS(1255),
    [anon_sym_noreturn] = ACTIONS(1255),
    [anon_sym_alignas] = ACTIONS(1255),
    [anon_sym__Alignas] = ACTIONS(1255),
    [sym_primitive_type] = ACTIONS(1255),
    [anon_sym_enum] = ACTIONS(1255),
    [anon_sym_struct] = ACTIONS(1255),
    [anon_sym_union] = ACTIONS(1255),
    [anon_sym_if] = ACTIONS(1255),
    [anon_sym_switch] = ACTIONS(1255),
    [anon_sym_case] = ACTIONS(1255),
    [anon_sym_default] = ACTIONS(1255),
    [anon_sym_while] = ACTIONS(1255),
    [anon_sym_do] = ACTIONS(1255),
    [anon_sym_for] = ACTIONS(1255),
    [anon_sym_return] = ACTIONS(1255),
    [anon_sym_break] = ACTIONS(1255),
    [anon_sym_continue] = ACTIONS(1255),
    [anon_sym_goto] = ACTIONS(1255),
    [anon_sym___try] = ACTIONS(1255),
    [anon_sym___leave] = ACTIONS(1255),
    [anon_sym_DASH_DASH] = ACTIONS(1257),
    [anon_sym_PLUS_PLUS] = ACTIONS(1257),
    [anon_sym_sizeof] = ACTIONS(1255),
    [anon_sym___alignof__] = ACTIONS(1255),
    [anon_sym___alignof] = ACTIONS(1255),
    [anon_sym__alignof] = ACTIONS(1255),
    [anon_sym_alignof] = ACTIONS(1255),
    [anon_sym__Alignof] = ACTIONS(1255),
    [anon_sym_offsetof] = ACTIONS(1255),
    [anon_sym__Generic] = ACTIONS(1255),
    [anon_sym_asm] = ACTIONS(1255),
    [anon_sym___asm__] = ACTIONS(1255),
    [sym_number_literal] = ACTIONS(1257),
    [anon_sym_L_SQUOTE] = ACTIONS(1257),
    [anon_sym_u_SQUOTE] = ACTIONS(1257),
    [anon_sym_U_SQUOTE] = ACTIONS(1257),
    [anon_sym_u8_SQUOTE] = ACTIONS(1257),
    [anon_sym_SQUOTE] = ACTIONS(1257),
    [anon_sym_L_DQUOTE] = ACTIONS(1257),
    [anon_sym_u_DQUOTE] = ACTIONS(1257),
    [anon_sym_U_DQUOTE] = ACTIONS(1257),
    [anon_sym_u8_DQUOTE] = ACTIONS(1257),
    [anon_sym_DQUOTE] = ACTIONS(1257),
    [sym_true] = ACTIONS(1255),
    [sym_false] = ACTIONS(1255),
    [anon_sym_NULL] = ACTIONS(1255),
    [anon_sym_nullptr] = ACTIONS(1255),
    [sym_comment] = ACTIONS(3),
  },
  [116] = {
    [sym_identifier] = ACTIONS(1259),
    [aux_sym_preproc_include_token1] = ACTIONS(1259),
    [aux_sym_preproc_def_token1] = ACTIONS(1259),
    [aux_sym_preproc_if_token1] = ACTIONS(1259),
    [aux_sym_preproc_if_token2] = ACTIONS(1259),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1259),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1259),
    [aux_sym_preproc_else_token1] = ACTIONS(1259),
    [aux_sym_preproc_elif_token1] = ACTIONS(1259),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1259),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1259),
    [sym_preproc_directive] = ACTIONS(1259),
    [anon_sym_LPAREN2] = ACTIONS(1261),
    [anon_sym_BANG] = ACTIONS(1261),
    [anon_sym_TILDE] = ACTIONS(1261),
    [anon_sym_DASH] = ACTIONS(1259),
    [anon_sym_PLUS] = ACTIONS(1259),
    [anon_sym_STAR] = ACTIONS(1261),
    [anon_sym_AMP] = ACTIONS(1261),
    [anon_sym_SEMI] = ACTIONS(1261),
    [anon_sym___extension__] = ACTIONS(1259),
    [anon_sym_typedef] = ACTIONS(1259),
    [anon_sym_extern] = ACTIONS(1259),
    [anon_sym___attribute__] = ACTIONS(1259),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1261),
    [anon_sym___declspec] = ACTIONS(1259),
    [anon_sym___cdecl] = ACTIONS(1259),
    [anon_sym___clrcall] = ACTIONS(1259),
    [anon_sym___stdcall] = ACTIONS(1259),
    [anon_sym___fastcall] = ACTIONS(1259),
    [anon_sym___thiscall] = ACTIONS(1259),
    [anon_sym___vectorcall] = ACTIONS(1259),
    [anon_sym_LBRACE] = ACTIONS(1261),
    [anon_sym_signed] = ACTIONS(1259),
    [anon_sym_unsigned] = ACTIONS(1259),
    [anon_sym_long] = ACTIONS(1259),
    [anon_sym_short] = ACTIONS(1259),
    [anon_sym_static] = ACTIONS(1259),
    [anon_sym_auto] = ACTIONS(1259),
    [anon_sym_register] = ACTIONS(1259),
    [anon_sym_inline] = ACTIONS(1259),
    [anon_sym___inline] = ACTIONS(1259),
    [anon_sym___inline__] = ACTIONS(1259),
    [anon_sym___forceinline] = ACTIONS(1259),
    [anon_sym_thread_local] = ACTIONS(1259),
    [anon_sym___thread] = ACTIONS(1259),
    [anon_sym_const] = ACTIONS(1259),
    [anon_sym_constexpr] = ACTIONS(1259),
    [anon_sym_volatile] = ACTIONS(1259),
    [anon_sym_restrict] = ACTIONS(1259),
    [anon_sym___restrict__] = ACTIONS(1259),
    [anon_sym__Atomic] = ACTIONS(1259),
    [anon_sym__Noreturn] = ACTIONS(1259),
    [anon_sym_noreturn] = ACTIONS(1259),
    [anon_sym_alignas] = ACTIONS(1259),
    [anon_sym__Alignas] = ACTIONS(1259),
    [sym_primitive_type] = ACTIONS(1259),
    [anon_sym_enum] = ACTIONS(1259),
    [anon_sym_struct] = ACTIONS(1259),
    [anon_sym_union] = ACTIONS(1259),
    [anon_sym_if] = ACTIONS(1259),
    [anon_sym_switch] = ACTIONS(1259),
    [anon_sym_case] = ACTIONS(1259),
    [anon_sym_default] = ACTIONS(1259),
    [anon_sym_while] = ACTIONS(1259),
    [anon_sym_do] = ACTIONS(1259),
    [anon_sym_for] = ACTIONS(1259),
    [anon_sym_return] = ACTIONS(1259),
    [anon_sym_break] = ACTIONS(1259),
    [anon_sym_continue] = ACTIONS(1259),
    [anon_sym_goto] = ACTIONS(1259),
    [anon_sym___try] = ACTIONS(1259),
    [anon_sym___leave] = ACTIONS(1259),
    [anon_sym_DASH_DASH] = ACTIONS(1261),
    [anon_sym_PLUS_PLUS] = ACTIONS(1261),
    [anon_sym_sizeof] = ACTIONS(1259),
    [anon_sym___alignof__] = ACTIONS(1259),
    [anon_sym___alignof] = ACTIONS(1259),
    [anon_sym__alignof] = ACTIONS(1259),
    [anon_sym_alignof] = ACTIONS(1259),
    [anon_sym__Alignof] = ACTIONS(1259),
    [anon_sym_offsetof] = ACTIONS(1259),
    [anon_sym__Generic] = ACTIONS(1259),
    [anon_sym_asm] = ACTIONS(1259),
    [anon_sym___asm__] = ACTIONS(1259),
    [sym_number_literal] = ACTIONS(1261),
    [anon_sym_L_SQUOTE] = ACTIONS(1261),
    [anon_sym_u_SQUOTE] = ACTIONS(1261),
    [anon_sym_U_SQUOTE] = ACTIONS(1261),
    [anon_sym_u8_SQUOTE] = ACTIONS(1261),
    [anon_sym_SQUOTE] = ACTIONS(1261),
    [anon_sym_L_DQUOTE] = ACTIONS(1261),
    [anon_sym_u_DQUOTE] = ACTIONS(1261),
    [anon_sym_U_DQUOTE] = ACTIONS(1261),
    [anon_sym_u8_DQUOTE] = ACTIONS(1261),
    [anon_sym_DQUOTE] = ACTIONS(1261),
    [sym_true] = ACTIONS(1259),
    [sym_false] = ACTIONS(1259),
    [anon_sym_NULL] = ACTIONS(1259),
    [anon_sym_nullptr] = ACTIONS(1259),
    [sym_comment] = ACTIONS(3),
  },
  [117] = {
    [sym_identifier] = ACTIONS(1263),
    [aux_sym_preproc_include_token1] = ACTIONS(1263),
    [aux_sym_preproc_def_token1] = ACTIONS(1263),
    [aux_sym_preproc_if_token1] = ACTIONS(1263),
    [aux_sym_preproc_if_token2] = ACTIONS(1263),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1263),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1263),
    [aux_sym_preproc_else_token1] = ACTIONS(1263),
    [aux_sym_preproc_elif_token1] = ACTIONS(1263),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1263),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1263),
    [sym_preproc_directive] = ACTIONS(1263),
    [anon_sym_LPAREN2] = ACTIONS(1265),
    [anon_sym_BANG] = ACTIONS(1265),
    [anon_sym_TILDE] = ACTIONS(1265),
    [anon_sym_DASH] = ACTIONS(1263),
    [anon_sym_PLUS] = ACTIONS(1263),
    [anon_sym_STAR] = ACTIONS(1265),
    [anon_sym_AMP] = ACTIONS(1265),
    [anon_sym_SEMI] = ACTIONS(1265),
    [anon_sym___extension__] = ACTIONS(1263),
    [anon_sym_typedef] = ACTIONS(1263),
    [anon_sym_extern] = ACTIONS(1263),
    [anon_sym___attribute__] = ACTIONS(1263),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1265),
    [anon_sym___declspec] = ACTIONS(1263),
    [anon_sym___cdecl] = ACTIONS(1263),
    [anon_sym___clrcall] = ACTIONS(1263),
    [anon_sym___stdcall] = ACTIONS(1263),
    [anon_sym___fastcall] = ACTIONS(1263),
    [anon_sym___thiscall] = ACTIONS(1263),
    [anon_sym___vectorcall] = ACTIONS(1263),
    [anon_sym_LBRACE] = ACTIONS(1265),
    [anon_sym_signed] = ACTIONS(1263),
    [anon_sym_unsigned] = ACTIONS(1263),
    [anon_sym_long] = ACTIONS(1263),
    [anon_sym_short] = ACTIONS(1263),
    [anon_sym_static] = ACTIONS(1263),
    [anon_sym_auto] = ACTIONS(1263),
    [anon_sym_register] = ACTIONS(1263),
    [anon_sym_inline] = ACTIONS(1263),
    [anon_sym___inline] = ACTIONS(1263),
    [anon_sym___inline__] = ACTIONS(1263),
    [anon_sym___forceinline] = ACTIONS(1263),
    [anon_sym_thread_local] = ACTIONS(1263),
    [anon_sym___thread] = ACTIONS(1263),
    [anon_sym_const] = ACTIONS(1263),
    [anon_sym_constexpr] = ACTIONS(1263),
    [anon_sym_volatile] = ACTIONS(1263),
    [anon_sym_restrict] = ACTIONS(1263),
    [anon_sym___restrict__] = ACTIONS(1263),
    [anon_sym__Atomic] = ACTIONS(1263),
    [anon_sym__Noreturn] = ACTIONS(1263),
    [anon_sym_noreturn] = ACTIONS(1263),
    [anon_sym_alignas] = ACTIONS(1263),
    [anon_sym__Alignas] = ACTIONS(1263),
    [sym_primitive_type] = ACTIONS(1263),
    [anon_sym_enum] = ACTIONS(1263),
    [anon_sym_struct] = ACTIONS(1263),
    [anon_sym_union] = ACTIONS(1263),
    [anon_sym_if] = ACTIONS(1263),
    [anon_sym_switch] = ACTIONS(1263),
    [anon_sym_case] = ACTIONS(1263),
    [anon_sym_default] = ACTIONS(1263),
    [anon_sym_while] = ACTIONS(1263),
    [anon_sym_do] = ACTIONS(1263),
    [anon_sym_for] = ACTIONS(1263),
    [anon_sym_return] = ACTIONS(1263),
    [anon_sym_break] = ACTIONS(1263),
    [anon_sym_continue] = ACTIONS(1263),
    [anon_sym_goto] = ACTIONS(1263),
    [anon_sym___try] = ACTIONS(1263),
    [anon_sym___leave] = ACTIONS(1263),
    [anon_sym_DASH_DASH] = ACTIONS(1265),
    [anon_sym_PLUS_PLUS] = ACTIONS(1265),
    [anon_sym_sizeof] = ACTIONS(1263),
    [anon_sym___alignof__] = ACTIONS(1263),
    [anon_sym___alignof] = ACTIONS(1263),
    [anon_sym__alignof] = ACTIONS(1263),
    [anon_sym_alignof] = ACTIONS(1263),
    [anon_sym__Alignof] = ACTIONS(1263),
    [anon_sym_offsetof] = ACTIONS(1263),
    [anon_sym__Generic] = ACTIONS(1263),
    [anon_sym_asm] = ACTIONS(1263),
    [anon_sym___asm__] = ACTIONS(1263),
    [sym_number_literal] = ACTIONS(1265),
    [anon_sym_L_SQUOTE] = ACTIONS(1265),
    [anon_sym_u_SQUOTE] = ACTIONS(1265),
    [anon_sym_U_SQUOTE] = ACTIONS(1265),
    [anon_sym_u8_SQUOTE] = ACTIONS(1265),
    [anon_sym_SQUOTE] = ACTIONS(1265),
    [anon_sym_L_DQUOTE] = ACTIONS(1265),
    [anon_sym_u_DQUOTE] = ACTIONS(1265),
    [anon_sym_U_DQUOTE] = ACTIONS(1265),
    [anon_sym_u8_DQUOTE] = ACTIONS(1265),
    [anon_sym_DQUOTE] = ACTIONS(1265),
    [sym_true] = ACTIONS(1263),
    [sym_false] = ACTIONS(1263),
    [anon_sym_NULL] = ACTIONS(1263),
    [anon_sym_nullptr] = ACTIONS(1263),
    [sym_comment] = ACTIONS(3),
  },
  [118] = {
    [sym_identifier] = ACTIONS(1267),
    [aux_sym_preproc_include_token1] = ACTIONS(1267),
    [aux_sym_preproc_def_token1] = ACTIONS(1267),
    [aux_sym_preproc_if_token1] = ACTIONS(1267),
    [aux_sym_preproc_if_token2] = ACTIONS(1267),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1267),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1267),
    [aux_sym_preproc_else_token1] = ACTIONS(1267),
    [aux_sym_preproc_elif_token1] = ACTIONS(1267),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1267),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1267),
    [sym_preproc_directive] = ACTIONS(1267),
    [anon_sym_LPAREN2] = ACTIONS(1269),
    [anon_sym_BANG] = ACTIONS(1269),
    [anon_sym_TILDE] = ACTIONS(1269),
    [anon_sym_DASH] = ACTIONS(1267),
    [anon_sym_PLUS] = ACTIONS(1267),
    [anon_sym_STAR] = ACTIONS(1269),
    [anon_sym_AMP] = ACTIONS(1269),
    [anon_sym_SEMI] = ACTIONS(1269),
    [anon_sym___extension__] = ACTIONS(1267),
    [anon_sym_typedef] = ACTIONS(1267),
    [anon_sym_extern] = ACTIONS(1267),
    [anon_sym___attribute__] = ACTIONS(1267),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1269),
    [anon_sym___declspec] = ACTIONS(1267),
    [anon_sym___cdecl] = ACTIONS(1267),
    [anon_sym___clrcall] = ACTIONS(1267),
    [anon_sym___stdcall] = ACTIONS(1267),
    [anon_sym___fastcall] = ACTIONS(1267),
    [anon_sym___thiscall] = ACTIONS(1267),
    [anon_sym___vectorcall] = ACTIONS(1267),
    [anon_sym_LBRACE] = ACTIONS(1269),
    [anon_sym_signed] = ACTIONS(1267),
    [anon_sym_unsigned] = ACTIONS(1267),
    [anon_sym_long] = ACTIONS(1267),
    [anon_sym_short] = ACTIONS(1267),
    [anon_sym_static] = ACTIONS(1267),
    [anon_sym_auto] = ACTIONS(1267),
    [anon_sym_register] = ACTIONS(1267),
    [anon_sym_inline] = ACTIONS(1267),
    [anon_sym___inline] = ACTIONS(1267),
    [anon_sym___inline__] = ACTIONS(1267),
    [anon_sym___forceinline] = ACTIONS(1267),
    [anon_sym_thread_local] = ACTIONS(1267),
    [anon_sym___thread] = ACTIONS(1267),
    [anon_sym_const] = ACTIONS(1267),
    [anon_sym_constexpr] = ACTIONS(1267),
    [anon_sym_volatile] = ACTIONS(1267),
    [anon_sym_restrict] = ACTIONS(1267),
    [anon_sym___restrict__] = ACTIONS(1267),
    [anon_sym__Atomic] = ACTIONS(1267),
    [anon_sym__Noreturn] = ACTIONS(1267),
    [anon_sym_noreturn] = ACTIONS(1267),
    [anon_sym_alignas] = ACTIONS(1267),
    [anon_sym__Alignas] = ACTIONS(1267),
    [sym_primitive_type] = ACTIONS(1267),
    [anon_sym_enum] = ACTIONS(1267),
    [anon_sym_struct] = ACTIONS(1267),
    [anon_sym_union] = ACTIONS(1267),
    [anon_sym_if] = ACTIONS(1267),
    [anon_sym_switch] = ACTIONS(1267),
    [anon_sym_case] = ACTIONS(1267),
    [anon_sym_default] = ACTIONS(1267),
    [anon_sym_while] = ACTIONS(1267),
    [anon_sym_do] = ACTIONS(1267),
    [anon_sym_for] = ACTIONS(1267),
    [anon_sym_return] = ACTIONS(1267),
    [anon_sym_break] = ACTIONS(1267),
    [anon_sym_continue] = ACTIONS(1267),
    [anon_sym_goto] = ACTIONS(1267),
    [anon_sym___try] = ACTIONS(1267),
    [anon_sym___leave] = ACTIONS(1267),
    [anon_sym_DASH_DASH] = ACTIONS(1269),
    [anon_sym_PLUS_PLUS] = ACTIONS(1269),
    [anon_sym_sizeof] = ACTIONS(1267),
    [anon_sym___alignof__] = ACTIONS(1267),
    [anon_sym___alignof] = ACTIONS(1267),
    [anon_sym__alignof] = ACTIONS(1267),
    [anon_sym_alignof] = ACTIONS(1267),
    [anon_sym__Alignof] = ACTIONS(1267),
    [anon_sym_offsetof] = ACTIONS(1267),
    [anon_sym__Generic] = ACTIONS(1267),
    [a