#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.msm"), aligned (8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[3353]; const double alignment; void * const ptr;}  msm_resource_data = { {
  0107, 0126, 0141, 0162, 0151, 0141, 0156, 0164, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 
  0030, 0000, 0000, 0000, 0310, 0000, 0000, 0000, 0000, 0000, 0000, 0050, 0006, 0000, 0000, 0000, 
  0000, 0000, 0000, 0000, 0001, 0000, 0000, 0000, 0002, 0000, 0000, 0000, 0003, 0000, 0000, 0000, 
  0004, 0000, 0000, 0000, 0005, 0000, 0000, 0000, 0376, 0236, 0033, 0101, 0005, 0000, 0000, 0000, 
  0310, 0000, 0000, 0000, 0024, 0000, 0114, 0000, 0334, 0000, 0000, 0000, 0344, 0000, 0000, 0000, 
  0113, 0120, 0220, 0013, 0002, 0000, 0000, 0000, 0344, 0000, 0000, 0000, 0004, 0000, 0114, 0000, 
  0350, 0000, 0000, 0000, 0354, 0000, 0000, 0000, 0324, 0265, 0002, 0000, 0377, 0377, 0377, 0377, 
  0354, 0000, 0000, 0000, 0001, 0000, 0114, 0000, 0360, 0000, 0000, 0000, 0364, 0000, 0000, 0000, 
  0173, 0250, 0316, 0037, 0000, 0000, 0000, 0000, 0364, 0000, 0000, 0000, 0014, 0000, 0166, 0000, 
  0000, 0001, 0000, 0000, 0034, 0006, 0000, 0000, 0234, 0164, 0275, 0021, 0000, 0000, 0000, 0000, 
  0034, 0006, 0000, 0000, 0016, 0000, 0166, 0000, 0060, 0006, 0000, 0000, 0017, 0015, 0000, 0000, 
  0201, 0321, 0040, 0031, 0001, 0000, 0000, 0000, 0017, 0015, 0000, 0000, 0005, 0000, 0114, 0000, 
  0024, 0015, 0000, 0000, 0030, 0015, 0000, 0000, 0155, 0141, 0164, 0145, 0055, 0163, 0171, 0163, 
  0164, 0145, 0155, 0055, 0155, 0157, 0156, 0151, 0164, 0157, 0162, 0057, 0003, 0000, 0000, 0000, 
  0004, 0000, 0000, 0000, 0157, 0162, 0147, 0057, 0005, 0000, 0000, 0000, 0057, 0000, 0000, 0000, 
  0001, 0000, 0000, 0000, 0151, 0156, 0164, 0145, 0162, 0146, 0141, 0143, 0145, 0056, 0165, 0151, 
  0242, 0073, 0000, 0000, 0001, 0000, 0000, 0000, 0170, 0332, 0355, 0133, 0133, 0163, 0352, 0066, 
  0020, 0176, 0317, 0257, 0160, 0375, 0332, 0161, 0010, 0227, 0320, 0164, 0006, 0070, 0323, 0166, 
  0232, 0364, 0241, 0347, 0114, 0046, 0344, 0114, 0037, 0031, 0331, 0136, 0260, 0212, 0054, 0271, 
  0222, 0314, 0345, 0337, 0237, 0065, 0066, 0004, 0002, 0370, 0102, 0210, 0061, 0224, 0067, 0154, 
  0257, 0054, 0355, 0267, 0253, 0335, 0317, 0253, 0245, 0363, 0145, 0346, 0063, 0143, 0002, 0122, 
  0121, 0301, 0273, 0146, 0375, 0366, 0316, 0064, 0200, 0073, 0302, 0245, 0174, 0324, 0065, 0277, 
  0277, 0076, 0132, 0017, 0346, 0227, 0336, 0115, 0347, 0047, 0313, 0062, 0236, 0200, 0203, 0044, 
  0032, 0134, 0143, 0112, 0265, 0147, 0214, 0030, 0161, 0301, 0150, 0336, 0066, 0037, 0156, 0033, 
  0206, 0145, 0241, 0020, 0345, 0032, 0344, 0220, 0070, 0320, 0353, 0110, 0370, 0057, 0244, 0022, 
  0224, 0301, 0250, 0335, 0065, 0107, 0172, 0374, 0263, 0371, 0066, 0113, 0363, 0266, 0321, 0062, 
  0153, 0275, 0216, 0260, 0377, 0005, 0107, 0033, 0016, 0043, 0112, 0165, 0315, 0047, 0075, 0376, 
  0207, 0162, 0127, 0114, 0115, 0203, 0272, 0135, 0323, 0047, 0224, 0017, 0246, 0361, 0215, 0136, 
  0047, 0220, 0042, 0000, 0251, 0347, 0006, 0047, 0076, 0164, 0115, 0207, 0160, 0153, 0050, 0234, 
  0120, 0231, 0275, 0107, 0302, 0024, 0164, 0152, 0113, 0201, 0055, 0121, 0115, 0065, 0003, 0323, 
  0320, 0222, 0160, 0305, 0210, 0046, 0066, 0303, 0233, 0163, 0300, 0221, 0375, 0271, 0322, 0340, 
  0033, 0137, 0005, 0247, 0132, 0310, 0224, 0127, 0270, 0060, 0044, 0041, 0323, 0326, 0224, 0272, 
  0332, 0063, 0173, 0255, 0326, 0135, 0016, 0141, 0017, 0350, 0310, 0323, 0050, 0375, 0353, 0375, 
  0272, 0264, 0343, 0121, 0346, 0356, 0120, 0375, 0167, 0061, 0133, 0323, 0333, 0306, 0253, 0255, 
  0067, 0117, 0250, 0242, 0270, 0172, 0263, 0367, 0052, 0303, 0064, 0215, 0013, 0200, 0043, 0044, 
  0005, 0256, 0211, 0106, 0263, 0230, 0075, 0264, 0217, 0246, 0016, 0141, 0073, 0226, 0033, 0060, 
  0264, 0252, 0047, 0230, 0013, 0022, 0355, 0126, 0113, 0356, 0356, 0323, 0345, 0233, 0320, 0140, 
  0013, 0061, 0216, 0025, 0342, 0313, 0253, 0143, 0050, 0224, 0041, 0351, 0023, 0071, 0242, 0334, 
  0122, 0232, 0110, 0204, 0276, 0336, 0310, 0026, 0005, 0356, 0346, 0023, 0324, 0042, 0170, 0057, 
  0230, 0151, 0113, 0065, 0127, 0224, 0017, 0105, 0151, 0346, 0364, 0140, 0026, 0220, 0110, 0241, 
  0214, 0127, 0116, 0162, 0312, 0331, 0102, 0242, 0305, 0227, 0176, 0237, 0212, 0222, 0012, 0210, 
  0203, 0061, 0143, 0017, 0104, 0251, 0376, 0263, 0373, 0141, 0055, 0206, 0365, 0235, 0264, 0241, 
  0347, 0101, 0264, 0251, 0211, 0155, 0356, 0000, 0376, 0157, 0142, 0003, 0333, 0204, 0236, 0055, 
  0156, 0225, 0001, 0176, 0074, 0323, 0376, 0100, 0263, 0076, 0164, 0245, 0034, 0242, 0066, 0106, 
  0330, 0266, 0243, 0026, 0261, 0255, 0041, 0145, 0154, 0307, 0264, 0265, 0325, 0230, 0254, 0175, 
  0270, 0362, 0103, 0034, 0354, 0374, 0037, 0234, 0060, 0063, 0234, 0355, 0165, 0332, 0207, 0074, 
  0373, 0172, 0315, 0275, 0230, 0040, 0356, 0200, 0114, 0106, 0045, 0372, 0227, 0107, 0030, 0035, 
  0241, 0136, 0213, 0340, 0126, 0310, 0231, 0226, 0100, 0147, 0315, 0020, 0073, 0134, 0306, 0212, 
  0003, 0241, 0150, 0014, 0360, 0335, 0141, 0136, 0331, 0167, 0244, 0140, 0014, 0334, 0365, 0144, 
  0037, 0071, 0050, 0050, 0005, 0152, 0240, 0222, 0247, 0145, 0144, 0213, 0143, 0173, 0252, 0362, 
  0010, 0152, 0144, 0105, 0041, 0312, 0354, 0121, 0236, 0073, 0016, 0236, 0312, 0200, 0365, 0003, 
  0303, 0112, 0250, 0065, 0016, 0137, 0030, 0016, 0323, 0147, 0142, 0073, 0073, 0276, 0133, 0040, 
  0054, 0376, 0311, 0135, 0143, 0360, 0034, 0217, 0116, 0131, 0157, 0250, 0300, 0042, 0116, 0264, 
  0142, 0213, 0004, 0001, 0020, 0174, 0221, 0003, 0331, 0130, 0034, 0337, 0135, 0044, 0070, 0100, 
  0047, 0240, 0254, 0204, 0342, 0145, 0373, 0127, 0262, 0143, 0021, 0244, 0014, 0375, 0102, 0216, 
  0036, 0301, 0050, 0337, 0261, 0334, 0123, 0071, 0107, 0043, 0335, 0071, 0062, 0227, 0125, 0314, 
  0315, 0162, 0347, 0365, 0105, 0052, 0253, 0102, 0122, 0177, 0136, 0206, 0254, 0102, 0306, 0332, 
  0203, 0312, 0247, 0146, 0177, 0374, 0014, 0273, 0046, 0377, 0242, 0214, 0165, 0077, 0234, 0116, 
  0020, 0126, 0347, 0373, 0154, 0257, 0116, 0167, 0005, 0011, 0115, 0244, 0125, 0025, 0266, 0325, 
  0037, 0317, 0337, 0215, 0277, 0250, 0302, 0017, 0362, 0171, 0312, 0370, 0131, 0022, 0131, 0067, 
  0264, 0044, 0132, 0113, 0212, 0151, 0010, 0324, 0332, 0357, 0144, 0300, 0064, 0376, 0032, 0067, 
  0046, 0204, 0205, 0013, 0267, 0142, 0156, 0124, 0201, 0250, 0255, 0217, 0071, 0063, 0036, 0265, 
  0341, 0220, 0043, 0111, 0002, 0357, 0154, 0167, 0371, 0301, 0156, 0336, 0376, 0160, 0255, 0342, 
  0221, 0211, 0351, 0006, 0222, 0103, 0274, 0121, 0032, 0220, 0223, 0175, 0234, 0076, 0265, 0256, 
  0161, 0377, 0113, 0332, 0354, 0202, 0205, 0076, 0212, 0056, 0041, 0112, 0013, 0231, 0022, 0331, 
  0152, 0056, 0101, 0037, 0047, 0137, 0040, 0050, 0201, 0133, 0370, 0300, 0212, 0271, 0112, 0063, 
  0165, 0311, 0263, 0135, 0103, 0322, 0213, 0010, 0300, 0040, 0146, 0172, 0276, 0160, 0121, 0230, 
  0013, 0176, 0112, 0056, 0204, 0223, 0044, 0144, 0076, 0235, 0301, 0345, 0246, 0072, 0025, 0045, 
  0372, 0347, 0032, 0370, 0174, 0360, 0057, 0060, 0023, 0107, 0132, 0125, 0041, 0023, 0177, 0005, 
  0037, 0223, 0260, 0201, 0206, 0067, 0372, 0123, 0022, 0134, 0263, 0162, 0161, 0347, 0274, 0146, 
  0345, 0174, 0131, 0071, 0072, 0135, 0302, 0004, 0263, 0310, 0134, 0252, 0333, 0302, 0337, 0230, 
  0231, 0124, 0167, 0161, 0254, 0264, 0015, 0361, 0223, 0244, 0356, 0033, 0306, 0013, 0227, 0055, 
  0005, 0337, 0002, 0111, 0070, 0257, 0051, 0066, 0022, 0160, 0273, 0100, 0126, 0157, 0147, 0274, 
  0324, 0023, 0276, 0030, 0001, 0007, 0261, 0253, 0256, 0221, 0043, 0010, 0051, 0334, 0361, 0145, 
  0326, 0066, 0163, 0342, 0225, 0122, 0143, 0307, 0005, 0027, 0015, 0115, 0231, 0241, 0205, 0301, 
  0120, 0133, 0030, 0214, 0210, 0343, 0245, 0223, 0035, 0055, 0202, 0225, 0334, 0201, 0201, 0143, 
  0063, 0003, 0140, 0240, 0075, 0053, 0370, 0343, 0144, 0361, 0271, 0006, 0250, 0037, 0325, 0000, 
  0007, 0034, 0111, 0235, 0342, 0341, 0225, 0362, 0136, 0024, 0345, 0255, 0177, 0220, 0125, 0160, 
  0320, 0027, 0110, 0171, 0043, 0255, 0252, 0100, 0171, 0277, 0201, 0236, 0012, 0071, 0276, 0122, 
  0335, 0342, 0116, 0171, 0245, 0272, 0173, 0330, 0154, 0073, 0067, 0233, 0215, 0140, 0074, 0031, 
  0233, 0155, 0345, 0154, 0225, 0151, 0076, 0134, 0062, 0355, 0215, 0217, 0370, 0160, 0252, 0263, 
  0042, 0137, 0057, 0313, 0125, 0237, 0023, 0377, 0112, 0063, 0203, 0026, 0232, 0260, 0101, 0162, 
  0336, 0352, 0236, 0225, 0055, 0136, 0243, 0245, 0033, 0057, 0311, 0322, 0253, 0141, 0220, 0372, 
  0207, 0015, 0242, 0160, 0357, 0237, 0333, 0256, 0350, 0143, 0104, 0377, 0134, 0374, 0357, 0113, 
  0336, 0020, 0150, 0005, 0175, 0206, 0233, 0241, 0072, 0206, 0070, 0302, 0106, 0300, 0101, 0040, 
  0267, 0341, 0137, 0034, 0120, 0133, 0121, 0327, 0063, 0050, 0235, 0221, 0045, 0077, 0215, 0322, 
  0366, 0156, 0112, 0256, 0156, 0154, 0071, 0114, 0334, 0362, 0334, 0070, 0014, 0346, 0337, 0042, 
  0077, 0360, 0321, 0131, 0336, 0347, 0342, 0200, 0072, 0143, 0220, 0003, 0262, 0172, 0136, 0006, 
  0244, 0233, 0235, 0007, 0355, 0343, 0065, 0163, 0155, 0300, 0176, 0127, 0071, 0330, 0227, 0241, 
  0376, 0202, 0101, 0157, 0225, 0016, 0372, 0045, 0026, 0176, 0076, 0122, 0146, 0313, 0255, 0134, 
  0306, 0262, 0057, 0243, 0050, 0164, 0274, 0126, 0273, 0306, 0061, 0133, 0355, 0242, 0276, 0261, 
  0052, 0124, 0145, 0136, 0100, 0211, 0120, 0072, 0007, 0167, 0332, 0065, 0112, 0353, 0264, 0033, 
  0226, 0327, 0150, 0127, 0106, 0143, 0134, 0073, 0317, 0327, 0363, 0256, 0166, 0156, 0227, 0252, 
  0361, 0265, 0225, 0273, 0102, 0045, 0274, 0002, 0273, 0245, 0171, 0314, 0020, 0062, 0254, 0106, 
  0004, 0171, 0244, 0014, 0214, 0370, 0137, 0070, 0207, 0006, 0221, 0346, 0261, 0202, 0310, 0231, 
  0235, 0074, 0364, 0061, 0160, 0204, 0312, 0046, 0062, 0141, 0207, 0253, 0313, 0112, 0237, 0100, 
  0064, 0076, 0261, 0153, 0054, 0113, 0252, 0170, 0136, 0337, 0276, 0361, 0366, 0117, 0332, 0233, 
  0037, 0325, 0360, 0311, 0023, 0000, 0050, 0165, 0165, 0141, 0171, 0051, 0160, 0162, 0145, 0146, 
  0145, 0162, 0145, 0156, 0143, 0145, 0163, 0056, 0165, 0151, 0000, 0000, 0000, 0000, 0000, 0000, 
  0065, 0123, 0000, 0000, 0001, 0000, 0000, 0000, 0170, 0332, 0355, 0134, 0335, 0162, 0342, 0066, 
  0024, 0276, 0357, 0123, 0250, 0276, 0355, 0050, 0004, 0262, 0155, 0167, 0072, 0301, 0073, 0335, 
  0335, 0046, 0335, 0231, 0266, 0263, 0323, 0354, 0266, 0227, 0036, 0331, 0076, 0140, 0155, 0204, 
  0344, 0112, 0002, 0102, 0257, 0372, 0054, 0175, 0264, 0076, 0111, 0217, 0177, 0010, 0140, 0300, 
  0066, 0004, 0210, 0041, 0334, 0331, 0346, 0110, 0072, 0072, 0377, 0237, 0216, 0206, 0353, 0067, 
  0017, 0003, 0101, 0106, 0240, 0015, 0127, 0262, 0353, 0264, 0057, 0056, 0035, 0002, 0062, 0120, 
  0041, 0227, 0375, 0256, 0363, 0371, 0323, 0015, 0175, 0355, 0274, 0161, 0277, 0272, 0376, 0232, 
  0122, 0162, 0013, 0022, 0064, 0263, 0020, 0222, 0061, 0267, 0021, 0351, 0013, 0026, 0002, 0271, 
  0272, 0270, 0172, 0175, 0321, 0041, 0224, 0042, 0021, 0227, 0026, 0164, 0217, 0005, 0340, 0136, 
  0153, 0370, 0153, 0310, 0065, 0030, 0042, 0270, 0337, 0165, 0372, 0366, 0376, 0033, 0147, 0266, 
  0312, 0325, 0105, 0347, 0225, 0323, 0162, 0257, 0225, 0377, 0005, 0002, 0113, 0002, 0301, 0214, 
  0351, 0072, 0267, 0366, 0376, 0303, 0200, 0365, 0301, 0041, 0074, 0354, 0072, 0074, 0171, 0154, 
  0073, 0356, 0165, 0254, 0125, 0014, 0332, 0116, 0210, 0144, 0003, 0350, 0072, 0043, 0156, 0270, 
  0057, 0300, 0161, 0077, 0351, 0041, 0134, 0267, 0246, 0277, 0056, 0321, 0005, 0114, 0322, 0236, 
  0012, 0206, 0306, 0161, 0157, 0230, 0060, 0145, 0244, 0074, 0120, 0222, 0046, 0217, 0216, 0073, 
  0346, 0062, 0124, 0143, 0032, 0010, 0265, 0070, 0242, 0225, 0261, 0132, 0203, 0345, 0316, 0241, 
  0131, 0216, 0100, 0304, 0324, 0327, 0152, 0154, 0100, 0327, 0143, 0371, 0075, 0147, 0102, 0365, 
  0063, 0236, 0143, 0015, 0075, 0320, 0250, 0161, 0060, 0136, 0230, 0175, 0177, 0012, 0137, 0276, 
  0322, 0041, 0150, 0072, 0346, 0241, 0215, 0034, 0367, 0333, 0022, 0112, 0313, 0055, 0212, 0204, 
  0130, 0315, 0244, 0021, 0314, 0062, 0024, 0120, 0327, 0231, 0000, 0256, 0161, 0067, 0061, 0026, 
  0006, 0344, 0127, 0045, 0271, 0125, 0232, 0174, 0234, 0161, 0130, 0062, 0135, 0010, 0075, 0066, 
  0024, 0166, 0272, 0362, 0253, 0313, 0313, 0032, 0304, 0021, 0360, 0176, 0144, 0221, 0272, 0123, 
  0116, 0155, 0254, 0126, 0023, 0232, 0030, 0075, 0215, 0031, 0262, 0142, 0053, 0125, 0151, 0047, 
  0061, 0320, 0210, 0047, 0224, 0231, 0124, 0347, 0151, 0203, 0210, 0213, 0220, 0244, 0316, 0042, 
  0231, 0240, 0351, 0053, 0132, 0211, 0257, 0036, 0234, 0025, 0332, 0172, 0213, 0237, 0123, 0125, 
  0145, 0023, 0171, 0202, 0115, 0324, 0320, 0076, 0111, 0113, 0003, 0246, 0373, 0134, 0122, 0253, 
  0342, 0162, 0035, 0345, 0164, 0276, 0262, 0126, 0015, 0312, 0111, 0225, 0346, 0050, 0027, 0146, 
  0321, 0277, 0035, 0027, 0035, 0335, 0362, 0200, 0211, 0022, 0172, 0023, 0263, 0000, 0103, 0214, 
  0343, 0166, 0252, 0045, 0303, 0202, 0144, 0132, 0017, 0045, 0317, 0126, 0012, 0150, 0210, 0354, 
  0311, 0242, 0230, 0026, 0007, 0155, 0040, 0253, 0164, 0321, 0265, 0313, 0144, 0153, 0044, 0076, 
  0347, 0371, 0331, 0207, 0245, 0311, 0005, 0363, 0101, 0070, 0356, 0317, 0110, 0123, 0042, 0200, 
  0241, 0001, 0232, 0361, 0110, 0131, 0034, 0003, 0103, 0077, 0010, 0240, 0132, 0165, 0133, 0304, 
  0222, 0012, 0112, 0015, 0001, 0360, 0021, 0030, 0232, 0173, 0105, 0345, 0200, 0064, 0314, 0071, 
  0156, 0026, 0355, 0126, 0106, 0034, 0324, 0355, 0075, 0052, 0167, 0151, 0044, 0074, 0304, 0114, 
  0206, 0325, 0233, 0354, 0161, 0041, 0052, 0331, 0210, 0225, 0341, 0231, 0271, 0055, 0070, 0157, 
  0353, 0161, 0361, 0126, 0256, 0311, 0072, 0012, 0115, 0003, 0176, 0225, 0106, 0337, 0025, 0263, 
  0302, 0111, 0252, 0264, 0335, 0004, 0225, 0266, 0313, 0125, 0172, 0140, 0266, 0160, 0021, 0232, 
  0104, 0164, 0307, 0005, 0031, 0356, 0320, 0044, 0223, 0242, 0112, 0322, 0100, 0211, 0341, 0100, 
  0232, 0156, 0033, 0237, 0223, 0064, 0216, 0017, 0130, 0115, 0055, 0333, 0353, 0255, 0346, 0141, 
  0156, 0255, 0012, 0043, 0244, 0264, 0136, 0077, 0371, 0162, 0210, 0162, 0143, 0323, 0350, 0236, 
  0155, 0211, 0226, 0004, 0371, 0025, 0373, 0373, 0115, 0131, 0360, 0225, 0272, 0317, 0366, 0050, 
  0247, 0157, 0007, 0360, 0227, 0150, 0152, 0056, 0025, 0164, 0243, 0232, 0164, 0045, 0125, 0120, 
  0271, 0346, 0073, 0125, 0232, 0307, 0211, 0260, 0016, 0062, 0130, 0254, 0141, 0305, 0344, 0345, 
  0166, 0160, 0020, 0023, 0330, 0257, 0214, 0332, 0235, 0035, 0132, 0037, 0212, 0162, 0146, 0172, 
  0355, 0327, 0173, 0021, 0277, 0017, 0021, 0033, 0161, 0245, 0017, 0042, 0373, 0205, 0015, 0175, 
  0127, 0307, 0227, 0176, 0111, 0063, 0326, 0032, 0236, 0275, 0074, 0237, 0035, 0302, 0152, 0230, 
  0340, 0175, 0324, 0232, 0261, 0114, 0333, 0022, 0272, 0214, 0243, 0125, 0150, 0340, 0155, 0316, 
  0164, 0131, 0055, 0211, 0162, 0021, 0100, 0005, 0227, 0100, 0007, 0052, 0134, 0261, 0001, 0146, 
  0255, 0346, 0230, 0335, 0301, 0314, 0075, 0347, 0243, 0307, 0031, 0010, 0040, 0043, 0046, 0206, 
  0251, 0135, 0212, 0060, 0301, 0246, 0255, 0371, 0061, 0225, 0371, 0106, 0100, 0317, 0122, 0034, 
  0301, 0202, 0250, 0020, 0374, 0213, 0300, 0100, 0305, 0253, 0351, 0066, 0115, 0022, 0257, 0066, 
  0267, 0125, 0317, 0100, 0220, 0071, 0321, 0001, 0064, 0237, 0143, 0207, 0124, 0361, 0025, 0376, 
  0135, 0151, 0336, 0213, 0042, 0350, 0324, 0316, 0223, 0303, 0070, 0144, 0026, 0274, 0024, 0117, 
  0240, 0172, 0017, 0227, 0057, 0353, 0006, 0313, 0142, 0236, 0154, 0167, 0266, 0166, 0356, 0307, 
  0115, 0036, 0316, 0271, 0327, 0073, 0255, 0367, 0071, 0225, 0074, 0231, 0062, 0205, 0017, 0004, 
  0215, 0117, 0311, 0320, 0374, 0120, 0121, 0100, 0017, 0045, 0246, 0205, 0304, 0225, 0053, 0071, 
  0035, 0110, 0030, 0050, 0311, 0203, 0044, 0207, 0364, 0001, 0215, 0154, 0205, 0060, 0114, 0314, 
  0245, 0134, 0163, 0056, 0362, 0014, 0276, 0274, 0244, 0312, 0073, 0344, 0157, 0036, 0207, 0254, 
  0337, 0302, 0041, 0352, 0040, 0056, 0363, 0071, 0021, 0171, 0063, 0134, 0361, 0277, 0177, 0376, 
  0055, 0233, 0127, 0360, 0201, 0117, 0223, 0003, 0301, 0102, 0275, 0136, 0074, 0077, 0341, 0175, 
  0156, 0115, 0241, 0010, 0334, 0114, 0013, 0355, 0335, 0150, 0241, 0121, 0252, 0177, 0027, 0101, 
  0260, 0200, 0101, 0315, 0100, 0051, 0033, 0125, 0200, 0320, 0125, 0336, 0366, 0223, 0114, 0136, 
  0210, 0227, 0115, 0100, 0064, 0364, 0064, 0230, 0350, 0070, 0201, 0152, 0025, 0017, 0233, 0205, 
  0210, 0120, 0263, 0061, 0345, 0062, 0304, 0202, 0321, 0046, 0265, 0132, 0221, 0174, 0077, 0006, 
  0321, 0336, 0221, 0101, 0004, 0311, 0207, 0055, 0354, 0341, 0107, 0201, 0144, 0304, 0207, 0236, 
  0322, 0100, 0020, 0261, 0342, 0352, 0104, 0151, 0342, 0335, 0043, 0330, 0115, 0236, 0037, 0203, 
  0314, 0331, 0104, 0236, 0313, 0104, 0072, 0273, 0212, 0031, 0112, 0060, 0315, 0315, 0026, 0106, 
  0342, 0275, 0347, 0043, 0036, 0002, 0171, 0367, 0361, 0063, 0031, 0032, 0326, 0007, 0342, 0117, 
  0322, 0227, 0100, 0015, 0245, 0075, 0133, 0306, 0163, 0131, 0306, 0325, 0163, 0244, 0260, 0166, 
  0163, 0363, 0346, 0323, 0241, 0172, 0217, 0203, 0010, 0315, 0121, 0036, 0222, 0354, 0010, 0370, 
  0147, 0022, 0150, 0004, 0062, 0370, 0040, 0061, 0053, 0015, 0322, 0263, 0034, 0162, 0223, 0262, 
  0125, 0062, 0315, 0227, 0241, 0261, 0274, 0067, 0161, 0334, 0344, 0230, 0266, 0204, 0016, 0060, 
  0257, 0305, 0206, 0377, 0135, 0171, 0100, 0133, 0175, 0122, 0120, 0030, 0360, 0220, 0237, 0137, 
  0134, 0236, 0370, 0151, 0302, 0306, 0356, 0324, 0074, 0054, 0135, 0327, 0247, 0052, 0117, 0023, 
  0267, 0161, 0255, 0324, 0304, 0033, 0341, 0140, 0037, 0063, 0326, 0010, 0367, 0346, 0074, 0315, 
  0104, 0152, 0054, 0023, 0020, 0056, 0270, 0261, 0173, 0106, 0340, 0126, 0003, 0170, 0271, 0201, 
  0155, 0352, 0131, 0315, 0302, 0346, 0201, 0126, 0102, 0100, 0370, 0147, 0172, 0047, 0244, 0250, 
  0170, 0223, 0377, 0172, 0214, 0375, 0011, 0023, 0261, 0344, 0226, 0113, 0326, 0322, 0342, 0262, 
  0216, 0361, 0177, 0102, 0255, 0376, 0301, 0141, 0116, 0014, 0363, 0172, 0076, 0214, 0020, 0030, 
  0332, 0245, 0241, 0217, 0063, 0127, 0371, 0010, 0244, 0260, 0230, 0032, 0054, 0121, 0023, 0053, 
  0130, 0335, 0350, 0137, 0272, 0154, 0140, 0100, 0074, 0236, 0222, 0256, 0224, 0302, 0335, 0043, 
  0301, 0242, 0105, 0114, 0203, 0052, 0235, 0315, 0320, 0132, 0121, 0102, 0235, 0140, 0041, 0327, 
  0350, 0105, 0027, 0274, 0234, 0044, 0046, 0217, 0363, 0060, 0337, 0251, 0033, 0340, 0223, 0076, 
  0133, 0203, 0342, 0372, 0042, 0150, 0257, 0024, 0055, 0316, 0100, 0263, 0036, 0367, 0322, 0312, 
  0073, 0357, 0112, 0153, 0060, 0152, 0250, 0203, 0163, 0157, 0362, 0171, 0172, 0223, 0063, 0361, 
  0367, 0065, 0213, 0243, 0146, 0001, 0236, 0047, 0001, 0231, 0342, 0316, 0016, 0331, 0277, 0254, 
  0271, 0277, 0365, 0176, 0173, 0233, 0262, 0174, 0006, 0071, 0307, 0000, 0162, 0226, 0014, 0255, 
  0241, 0015, 0323, 0203, 0037, 0063, 0154, 0333, 0200, 0235, 0011, 0264, 0320, 0212, 0075, 0255, 
  0056, 0354, 0154, 0233, 0347, 0056, 0254, 0273, 0102, 0030, 0307, 0326, 0205, 0135, 0277, 0205, 
  0163, 0027, 0366, 0324, 0273, 0260, 0076, 0112, 0151, 0233, 0166, 0312, 0135, 0244, 0306, 0104, 
  0202, 0035, 0053, 0175, 0117, 0114, 0014, 0220, 0100, 0113, 0222, 0314, 0166, 0232, 0275, 0224, 
  0272, 0301, 0365, 0004, 0032, 0266, 0057, 0247, 0347, 0122, 0271, 0150, 0355, 0033, 0332, 0233, 
  0301, 0355, 0105, 0350, 0330, 0204, 0334, 0371, 0373, 0224, 0243, 0215, 0254, 0157, 0215, 0170, 
  0366, 0007, 0312, 0053, 0113, 0332, 0020, 0106, 0374, 0014, 0311, 0237, 0011, 0222, 0117, 0205, 
  0177, 0074, 0227, 0205, 0213, 0034, 0037, 0025, 0324, 0256, 0161, 0125, 0370, 0014, 0266, 0033, 
  0003, 0266, 0227, 0114, 0355, 0310, 0301, 0366, 0336, 0100, 0364, 0124, 0120, 0047, 0174, 0215, 
  0171, 0151, 0213, 0057, 0027, 0076, 0057, 0211, 0342, 0330, 0300, 0363, 0272, 0015, 0234, 0241, 
  0363, 0251, 0103, 0147, 0046, 0204, 0067, 0325, 0176, 0172, 0167, 0165, 0023, 0000, 0235, 0342, 
  0147, 0017, 0247, 0040, 0230, 0232, 0201, 0230, 0364, 0117, 0000, 0316, 0330, 0371, 0214, 0235, 
  0137, 0310, 0175, 0305, 0251, 0343, 0274, 0324, 0333, 0212, 0213, 0373, 0077, 0052, 0334, 0161, 
  0276, 0323, 0170, 0012, 0056, 0167, 0302, 0067, 0032, 0367, 0350, 0247, 0315, 0271, 0370, 0170, 
  0063, 0053, 0033, 0236, 0347, 0362, 0143, 0310, 0315, 0175, 0162, 0051, 0116, 0302, 0370, 0144, 
  0357, 0077, 0116, 0265, 0377, 0242, 0157, 0077, 0256, 0120, 0364, 0013, 0276, 0000, 0231, 0233, 
  0004, 0115, 0044, 0062, 0102, 0031, 0235, 0357, 0077, 0036, 0305, 0242, 0263, 0126, 0105, 0147, 
  0227, 0235, 0234, 0004, 0274, 0171, 0071, 0170, 0153, 0114, 0063, 0047, 0115, 0015, 0167, 0313, 
  0210, 0162, 0133, 0041, 0075, 0245, 0237, 0323, 0314, 0276, 0136, 0315, 0320, 0271, 0247, 0177, 
  0161, 0232, 0176, 0310, 0341, 0174, 0226, 0120, 0115, 0341, 0235, 0150, 0060, 0261, 0222, 0006, 
  0127, 0240, 0355, 0166, 0366, 0277, 0207, 0171, 0243, 0036, 0113, 0321, 0171, 0312, 0222, 0201, 
  0337, 0073, 0356, 0374, 0137, 0175, 0055, 0015, 0154, 0025, 0131, 0230, 0361, 0070, 0373, 0163, 
  0313, 0257, 0376, 0007, 0112, 0344, 0157, 0105, 0000, 0050, 0165, 0165, 0141, 0171, 0051, 0155, 
  0141, 0164, 0145, 0057, 0000, 0000, 0000, 0000
} };

static GStaticResource static_resource = { msm_resource_data.data, sizeof (msm_resource_data.data) - 1 /* nul terminator */, NULL, NULL, NULL };

G_MODULE_EXPORT
GResource *msm_get_resource (void);
GResource *msm_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/* GLIB - Library of useful routines for C programming
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GLib Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GLib Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GLib at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __G_CONSTRUCTOR_H__
#define __G_CONSTRUCTOR_H__

/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a usable way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER) && (_MSC_VER >= 1500)
/* Visual studio 2008 and later has _Pragma */

/*
 * Only try to include gslist.h if not already included via glib.h,
 * so that items using gconstructor.h outside of GLib (such as
 * GResources) continue to build properly.
 */
#ifndef __G_LIB_H__
#include "gslist.h"
#endif

#include <stdlib.h>

#define G_HAS_CONSTRUCTORS 1

/* We do some weird things to avoid the constructors being optimized
 * away on VS2015 if WholeProgramOptimization is enabled. First we
 * make a reference to the array from the wrapper to make sure its
 * references. Then we use a pragma to make sure the wrapper function
 * symbol is always included at the link stage. Also, the symbols
 * need to be extern (but not dllexport), even though they are not
 * really used from another object file.
 */

/* We need to account for differences between the mangling of symbols
 * for x86 and x64/ARM/ARM64 programs, as symbols on x86 are prefixed
 * with an underscore but symbols on x64/ARM/ARM64 are not.
 */
#ifdef _M_IX86
#define G_MSVC_SYMBOL_PREFIX "_"
#else
#define G_MSVC_SYMBOL_PREFIX ""
#endif

#define G_DEFINE_CONSTRUCTOR(_func) G_MSVC_CTOR (_func, G_MSVC_SYMBOL_PREFIX)
#define G_DEFINE_DESTRUCTOR(_func) G_MSVC_DTOR (_func, G_MSVC_SYMBOL_PREFIX)

#define G_MSVC_CTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _wrapper(void);              \
  int _func ## _wrapper(void) { _func(); g_slist_find (NULL,  _array ## _func); return 0; } \
  __pragma(comment(linker,"/include:" _sym_prefix # _func "_wrapper")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _wrapper;

#define G_MSVC_DTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _constructor(void);              \
  int _func ## _constructor(void) { atexit (_func); g_slist_find (NULL,  _array ## _func); return 0; } \
   __pragma(comment(linker,"/include:" _sym_prefix # _func "_constructor")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _constructor;

#elif defined (_MSC_VER)

#define G_HAS_CONSTRUCTORS 1

/* Pre Visual studio 2008 must use #pragma section */
#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (*p)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */
#endif /* __G_CONSTRUCTOR_H__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(msmresource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(msmresource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(msmresource_destructor)
#endif
G_DEFINE_DESTRUCTOR(msmresource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void msmresource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void msmresource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
