/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.event.UninstallerListener;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.os.unix.ShellScript;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Destroyer
extends Thread {
    private boolean forceDestroy;
    private String installPath;
    private AbstractUIProgressHandler handler;

    public Destroyer(String string, boolean bl, AbstractUIProgressHandler abstractUIProgressHandler) {
        super("IzPack - Destroyer");
        this.installPath = string;
        this.forceDestroy = bl;
        this.handler = abstractUIProgressHandler;
    }

    @Override
    public void run() {
        try {
            Object object;
            List[] listArray = this.getListenerLists();
            ArrayList<ExecutableFile> arrayList = this.getExecutablesList();
            FileExecutor fileExecutor = new FileExecutor(arrayList);
            fileExecutor.executeFiles(2, this.handler);
            ArrayList<File> arrayList2 = this.getFilesList();
            int n = arrayList2.size();
            this.informListeners(listArray[0], 1, arrayList2, this.handler);
            this.handler.startAction("destroy", n);
            for (int i = 0; i < n; ++i) {
                object = arrayList2.get(i);
                this.informListeners(listArray[1], 3, object, this.handler);
                ((File)object).delete();
                this.informListeners(listArray[1], 4, object, this.handler);
                this.handler.progress(i, ((File)object).getAbsolutePath());
            }
            this.informListeners(listArray[0], 2, arrayList2, this.handler);
            if (OsVersion.IS_UNIX) {
                ArrayList<String> arrayList3 = this.getRootScripts();
                object = arrayList3.iterator();
                while (object.hasNext()) {
                    this.execRootScript((String)object.next());
                }
            }
            this.handler.progress(n, "[ cleanups ]");
            this.cleanup(new File(this.installPath));
            this.handler.stopAction();
        }
        catch (Throwable throwable) {
            this.handler.stopAction();
            throwable.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.handler.emitError("exception caught", stringWriter.toString());
        }
    }

    private ArrayList<File> getFilesList() throws Exception {
        TreeSet treeSet = new TreeSet(Collections.reverseOrder());
        InputStream inputStream = Destroyer.class.getResourceAsStream("/install.log");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        bufferedReader.readLine();
        String string = bufferedReader.readLine();
        while (string != null) {
            treeSet.add(new File(string));
            string = bufferedReader.readLine();
        }
        return new ArrayList<File>(treeSet);
    }

    private ArrayList<ExecutableFile> getExecutablesList() throws Exception {
        ArrayList<ExecutableFile> arrayList = new ArrayList<ExecutableFile>();
        ObjectInputStream objectInputStream = new ObjectInputStream(Destroyer.class.getResourceAsStream("/executables"));
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            ExecutableFile executableFile = (ExecutableFile)objectInputStream.readObject();
            arrayList.add(executableFile);
        }
        return arrayList;
    }

    private ArrayList<String> getRootScripts() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (true) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(Destroyer.class.getResourceAsStream("/rootscript" + Integer.toString(n)));
                arrayList.add(objectInputStream.readUTF());
            }
            catch (Exception exception) {
                Debug.log("Last RootScript Index=" + n);
                break;
            }
            ++n;
        }
        return arrayList;
    }

    private void execRootScript(String string) {
        if (!"".equals(string)) {
            Debug.log("Will Execute: " + string);
            try {
                String string2 = ShellScript.execAndDelete(new StringBuffer(string), File.createTempFile(this.getClass().getName(), Long.toString(System.currentTimeMillis()) + ".sh").toString());
                Debug.log("Result: " + string2);
            }
            catch (Exception exception) {
                Debug.log("Exeption during su remove: " + exception.getMessage());
            }
        }
    }

    private void cleanup(File file) throws Exception {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    this.cleanup(fileArray[i]);
                }
            }
            file.delete();
        } else if (this.forceDestroy) {
            file.delete();
        }
    }

    private List[] getListenerLists() throws Exception {
        List[] listArray = new ArrayList[]{new ArrayList(), new ArrayList()};
        InputStream inputStream = Destroyer.class.getResourceAsStream("/uninstallerListeners");
        if (inputStream != null) {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            List list = (List)objectInputStream.readObject();
            objectInputStream.close();
            Iterator iterator = list.iterator();
            while (iterator != null && iterator.hasNext()) {
                Class<?> clazz = Class.forName((String)iterator.next());
                UninstallerListener uninstallerListener = (UninstallerListener)clazz.newInstance();
                if (uninstallerListener.isFileListener()) {
                    ((ArrayList)listArray[1]).add(uninstallerListener);
                }
                ((ArrayList)listArray[0]).add(uninstallerListener);
            }
        }
        return listArray;
    }

    private void informListeners(List list, int n, Object object, AbstractUIProgressHandler abstractUIProgressHandler) {
        Iterator iterator = list.iterator();
        UninstallerListener uninstallerListener = null;
        while (iterator.hasNext()) {
            try {
                uninstallerListener = (UninstallerListener)iterator.next();
                switch (n) {
                    case 1: {
                        uninstallerListener.beforeDeletion((List)object, abstractUIProgressHandler);
                        break;
                    }
                    case 2: {
                        uninstallerListener.afterDeletion((List)object, abstractUIProgressHandler);
                        break;
                    }
                    case 3: {
                        uninstallerListener.beforeDelete((File)object, abstractUIProgressHandler);
                        break;
                    }
                    case 4: {
                        uninstallerListener.afterDelete((File)object, abstractUIProgressHandler);
                    }
                }
            }
            catch (Throwable throwable) {
                abstractUIProgressHandler.emitError("Skipping custom action because exception caught during " + uninstallerListener.getClass().getName(), throwable.toString());
            }
        }
    }
}

