#! /usr/bin/env python3

import yoda
from math import isclose

e1 = yoda.Estimate0D(path="/foo", title="MyTitle")
e2 = yoda.Estimate0D()

val = 1
errs = [-4., 5.]
e1.set(val, errs)
assert isclose(e1.val(), 1)
assert isclose(e1.errDown(), errs[0])
assert isclose(e1.errUp(), errs[1])

val = -0.2
e2.setVal(val)
assert isclose(e2.val(), val)
err = 2.
e2.setErr(err)
assert isclose(e2.errDown(), err)
assert isclose(e2.errUp(), err)

print(e2.relErr(), e2.totalErr())
assert isclose(e2.relErr()[0], 10.)
assert isclose(e2.relErr()[1], 10.)
assert isclose(e2.totalErr()[0], 0.)
assert isclose(e2.totalErr()[1], 2.)

yoda.write([e1,e2], "e0d.yoda")
aos = yoda.read("e0d.yoda")
for _, ao in aos.items():
    print(ao)

yoda.writeFLAT([e1,e2], "e0d.dat")
aos = yoda.read("e0d.dat")
for _, ao in aos.items():
    print(ao)

# Check that the bin scaling is done properly
s1 = e1.mkScatter()
if not isclose(e1.val(), s1.point(0).val(0)):
    raise Exception(f"FAIL mkScatter() bin0 value={e1.val()} -> bin0 value={s1.point(0).y()}")
if not isclose(e1.err()[1], s1.point(0).xErrs()[1]):
    raise Exception(f"FAIL mkScatter() err={e1.err()[1]} -> point0 xErr={s1.point(0).xErrs()[1]}")

# Check asymmetric errors
eneg, epos = e1.totalErr()
sneg, spos = s1.point(0).xErrs()
if not isclose(abs(eneg), sneg) or not isclose(epos, spos):
    raise Exception(f"FAIL mkScatter() bin0 err=({eneg},{epos}) -> point0 err=({sneg},{spos})")

