/*
  Copyright (C) 2009 to 2013 Chris Vine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef TRAY_ICON_H
#define TRAY_ICON_H

#include "prog_defs.h"

#include <gtk/gtk.h>

#include <c++-gtk-utils/emitter.h>
#include <c++-gtk-utils/gobj_handle.h>


class TrayIcon {
public:
  enum MenuItem {null_action, prefs, devices, about, quit};
private:
  GobjHandle<GtkStatusIcon> status_icon;
  GobjHandle<GtkWidget> menu;

  void popup_item_impl(MenuItem);
public:
  // Objects of this class are not for copying
  TrayIcon(const TrayIcon&) = delete;
  TrayIcon& operator=(const TrayIcon&) = delete;

  class CB;
  friend class CB;

  Emitter activate_cb;
  EmitterArg<MenuItem> popup_cb;

  bool is_embedded();

  void set_tooltip(const gchar* text) {
#if GTK_CHECK_VERSION(2, 16, 0)
    gtk_status_icon_set_tooltip_text(status_icon, text);
#else
    gtk_status_icon_set_tooltip(status_icon, text);
#endif
  }

  TrayIcon();
};

#endif
