/*
  Copyright (C) 2009 to 2012 and 2015 Chris Vine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef PROG_DEFS_H
#define PROG_DEFS_H

#include <unistd.h>
#include <config.h>

// deal with any configuration issues arising from config.h

#ifndef ENABLE_NLS
inline const char* gettext(const char* text) {
  return text;
}
#endif

#ifndef HAVE_SSIZE_T
typedef signed int ssize_t;
#endif

// define some common exit codes

#define INVALID_OPTION_ERROR 10
#define CONFIG_ERROR 11
#define EXEC_ERROR 12
#define FORK_ERROR 13

// configuration file which will be searched for in $HOME/"."RCFILE
#define RC_FILE "mount-gtkrc"

#include <string>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>

#include <c++-gtk-utils/gobj_handle.h>

namespace Cgu {}
using namespace Cgu;

namespace Error {
  enum ReportMode {unset, none, dialog, libnotify};
}

struct ProgConfig {
  std::string rc_filename;
  GKeyFile* key_file;
  GobjHandle<GdkPixbuf> window_icon;
  bool beep;
  Error::ReportMode error_mode;
  bool libnotify_fail;
  bool tray_icon;
  bool tooltip;
};

// defined in main.cpp
extern ProgConfig prog_config;

// generic beep() function defined in main.cpp
void beep();

// general function for writing an error defined in main.cpp
void write_error(const char* msg, bool notify = false);

// same, but it frees its argument after being written
// (say for use where being passed between threads)
inline void write_error_del(const char* message, bool notify = false) {
  write_error(message, notify);
  free(const_cast<char*>(message));
}

// function to strip leading and trailing white space in main.cpp
void strip(std::string& text);

#endif
