// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/osconfig/agentendpoint/v1beta/agentendpoint.proto

package agentendpoint

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A request message to receive task notifications.
type ReceiveTaskNotificationRequest struct {
	// Required. This is the GCE instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. The version of the agent making the request.
	AgentVersion         string   `protobuf:"bytes,2,opt,name=agent_version,json=agentVersion,proto3" json:"agent_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceiveTaskNotificationRequest) Reset()         { *m = ReceiveTaskNotificationRequest{} }
func (m *ReceiveTaskNotificationRequest) String() string { return proto.CompactTextString(m) }
func (*ReceiveTaskNotificationRequest) ProtoMessage()    {}
func (*ReceiveTaskNotificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{0}
}

func (m *ReceiveTaskNotificationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiveTaskNotificationRequest.Unmarshal(m, b)
}
func (m *ReceiveTaskNotificationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiveTaskNotificationRequest.Marshal(b, m, deterministic)
}
func (m *ReceiveTaskNotificationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiveTaskNotificationRequest.Merge(m, src)
}
func (m *ReceiveTaskNotificationRequest) XXX_Size() int {
	return xxx_messageInfo_ReceiveTaskNotificationRequest.Size(m)
}
func (m *ReceiveTaskNotificationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiveTaskNotificationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiveTaskNotificationRequest proto.InternalMessageInfo

func (m *ReceiveTaskNotificationRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

func (m *ReceiveTaskNotificationRequest) GetAgentVersion() string {
	if m != nil {
		return m.AgentVersion
	}
	return ""
}

// The streaming rpc message that notifies the agent when it has a task
// that it needs to perform on the VM instance.
type ReceiveTaskNotificationResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceiveTaskNotificationResponse) Reset()         { *m = ReceiveTaskNotificationResponse{} }
func (m *ReceiveTaskNotificationResponse) String() string { return proto.CompactTextString(m) }
func (*ReceiveTaskNotificationResponse) ProtoMessage()    {}
func (*ReceiveTaskNotificationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{1}
}

func (m *ReceiveTaskNotificationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiveTaskNotificationResponse.Unmarshal(m, b)
}
func (m *ReceiveTaskNotificationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiveTaskNotificationResponse.Marshal(b, m, deterministic)
}
func (m *ReceiveTaskNotificationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiveTaskNotificationResponse.Merge(m, src)
}
func (m *ReceiveTaskNotificationResponse) XXX_Size() int {
	return xxx_messageInfo_ReceiveTaskNotificationResponse.Size(m)
}
func (m *ReceiveTaskNotificationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiveTaskNotificationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiveTaskNotificationResponse proto.InternalMessageInfo

// A request message for signaling the start of a task execution.
type ReportTaskStartRequest struct {
	// Required. This is the GCE instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken      string   `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReportTaskStartRequest) Reset()         { *m = ReportTaskStartRequest{} }
func (m *ReportTaskStartRequest) String() string { return proto.CompactTextString(m) }
func (*ReportTaskStartRequest) ProtoMessage()    {}
func (*ReportTaskStartRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{2}
}

func (m *ReportTaskStartRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskStartRequest.Unmarshal(m, b)
}
func (m *ReportTaskStartRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskStartRequest.Marshal(b, m, deterministic)
}
func (m *ReportTaskStartRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskStartRequest.Merge(m, src)
}
func (m *ReportTaskStartRequest) XXX_Size() int {
	return xxx_messageInfo_ReportTaskStartRequest.Size(m)
}
func (m *ReportTaskStartRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskStartRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskStartRequest proto.InternalMessageInfo

func (m *ReportTaskStartRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

// A response message that contains the details of the task to work on.
type ReportTaskStartResponse struct {
	// The details of the task that should be worked on.  Can be empty if there
	// is no new task to work on.
	Task                 *Task    `protobuf:"bytes,1,opt,name=task,proto3" json:"task,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReportTaskStartResponse) Reset()         { *m = ReportTaskStartResponse{} }
func (m *ReportTaskStartResponse) String() string { return proto.CompactTextString(m) }
func (*ReportTaskStartResponse) ProtoMessage()    {}
func (*ReportTaskStartResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{3}
}

func (m *ReportTaskStartResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskStartResponse.Unmarshal(m, b)
}
func (m *ReportTaskStartResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskStartResponse.Marshal(b, m, deterministic)
}
func (m *ReportTaskStartResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskStartResponse.Merge(m, src)
}
func (m *ReportTaskStartResponse) XXX_Size() int {
	return xxx_messageInfo_ReportTaskStartResponse.Size(m)
}
func (m *ReportTaskStartResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskStartResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskStartResponse proto.InternalMessageInfo

func (m *ReportTaskStartResponse) GetTask() *Task {
	if m != nil {
		return m.Task
	}
	return nil
}

// A request message for reporting the progress of current task.
type ReportTaskProgressRequest struct {
	// Required. This is the GCE instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. Unique identifier of the task this applies to.
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Required. The type of task to report progress on.
	//
	// Progress must include the appropriate message based on this enum as
	// specified below:
	// APPLY_PATCHES = ApplyPatchesTaskProgress
	// EXEC_STEP = Progress not supported for this type.
	TaskType TaskType `protobuf:"varint,3,opt,name=task_type,json=taskType,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.TaskType" json:"task_type,omitempty"`
	// Intermediate progress of the current task.
	//
	// Types that are valid to be assigned to Progress:
	//	*ReportTaskProgressRequest_ApplyPatchesTaskProgress
	//	*ReportTaskProgressRequest_ExecStepTaskProgress
	Progress             isReportTaskProgressRequest_Progress `protobuf_oneof:"progress"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *ReportTaskProgressRequest) Reset()         { *m = ReportTaskProgressRequest{} }
func (m *ReportTaskProgressRequest) String() string { return proto.CompactTextString(m) }
func (*ReportTaskProgressRequest) ProtoMessage()    {}
func (*ReportTaskProgressRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{4}
}

func (m *ReportTaskProgressRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskProgressRequest.Unmarshal(m, b)
}
func (m *ReportTaskProgressRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskProgressRequest.Marshal(b, m, deterministic)
}
func (m *ReportTaskProgressRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskProgressRequest.Merge(m, src)
}
func (m *ReportTaskProgressRequest) XXX_Size() int {
	return xxx_messageInfo_ReportTaskProgressRequest.Size(m)
}
func (m *ReportTaskProgressRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskProgressRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskProgressRequest proto.InternalMessageInfo

func (m *ReportTaskProgressRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

func (m *ReportTaskProgressRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *ReportTaskProgressRequest) GetTaskType() TaskType {
	if m != nil {
		return m.TaskType
	}
	return TaskType_TASK_TYPE_UNSPECIFIED
}

type isReportTaskProgressRequest_Progress interface {
	isReportTaskProgressRequest_Progress()
}

type ReportTaskProgressRequest_ApplyPatchesTaskProgress struct {
	ApplyPatchesTaskProgress *ApplyPatchesTaskProgress `protobuf:"bytes,4,opt,name=apply_patches_task_progress,json=applyPatchesTaskProgress,proto3,oneof"`
}

type ReportTaskProgressRequest_ExecStepTaskProgress struct {
	ExecStepTaskProgress *ExecStepTaskProgress `protobuf:"bytes,5,opt,name=exec_step_task_progress,json=execStepTaskProgress,proto3,oneof"`
}

func (*ReportTaskProgressRequest_ApplyPatchesTaskProgress) isReportTaskProgressRequest_Progress() {}

func (*ReportTaskProgressRequest_ExecStepTaskProgress) isReportTaskProgressRequest_Progress() {}

func (m *ReportTaskProgressRequest) GetProgress() isReportTaskProgressRequest_Progress {
	if m != nil {
		return m.Progress
	}
	return nil
}

func (m *ReportTaskProgressRequest) GetApplyPatchesTaskProgress() *ApplyPatchesTaskProgress {
	if x, ok := m.GetProgress().(*ReportTaskProgressRequest_ApplyPatchesTaskProgress); ok {
		return x.ApplyPatchesTaskProgress
	}
	return nil
}

func (m *ReportTaskProgressRequest) GetExecStepTaskProgress() *ExecStepTaskProgress {
	if x, ok := m.GetProgress().(*ReportTaskProgressRequest_ExecStepTaskProgress); ok {
		return x.ExecStepTaskProgress
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReportTaskProgressRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReportTaskProgressRequest_ApplyPatchesTaskProgress)(nil),
		(*ReportTaskProgressRequest_ExecStepTaskProgress)(nil),
	}
}

// The response message after the agent reported the current task progress.
type ReportTaskProgressResponse struct {
	// Instructs agent to continue or not.
	TaskDirective        TaskDirective `protobuf:"varint,1,opt,name=task_directive,json=taskDirective,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.TaskDirective" json:"task_directive,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ReportTaskProgressResponse) Reset()         { *m = ReportTaskProgressResponse{} }
func (m *ReportTaskProgressResponse) String() string { return proto.CompactTextString(m) }
func (*ReportTaskProgressResponse) ProtoMessage()    {}
func (*ReportTaskProgressResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{5}
}

func (m *ReportTaskProgressResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskProgressResponse.Unmarshal(m, b)
}
func (m *ReportTaskProgressResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskProgressResponse.Marshal(b, m, deterministic)
}
func (m *ReportTaskProgressResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskProgressResponse.Merge(m, src)
}
func (m *ReportTaskProgressResponse) XXX_Size() int {
	return xxx_messageInfo_ReportTaskProgressResponse.Size(m)
}
func (m *ReportTaskProgressResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskProgressResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskProgressResponse proto.InternalMessageInfo

func (m *ReportTaskProgressResponse) GetTaskDirective() TaskDirective {
	if m != nil {
		return m.TaskDirective
	}
	return TaskDirective_TASK_DIRECTIVE_UNSPECIFIED
}

// A request message for signaling the completion of a task execution.
type ReportTaskCompleteRequest struct {
	// Required. This is the GCE instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. Unique identifier of the task this applies to.
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Required. The type of task to report completed.
	//
	// The output must include the appropriate message based on the following
	// enum values:
	// APPLY_PATCHES = ApplyPatchesTaskOutput
	// EXEC_STEP = ExecStepTaskOutput
	TaskType TaskType `protobuf:"varint,3,opt,name=task_type,json=taskType,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.TaskType" json:"task_type,omitempty"`
	// Descriptive error message if the task execution ended in error.
	ErrorMessage string `protobuf:"bytes,4,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Final output details of the current task.
	//
	// Types that are valid to be assigned to Output:
	//	*ReportTaskCompleteRequest_ApplyPatchesTaskOutput
	//	*ReportTaskCompleteRequest_ExecStepTaskOutput
	Output               isReportTaskCompleteRequest_Output `protobuf_oneof:"output"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ReportTaskCompleteRequest) Reset()         { *m = ReportTaskCompleteRequest{} }
func (m *ReportTaskCompleteRequest) String() string { return proto.CompactTextString(m) }
func (*ReportTaskCompleteRequest) ProtoMessage()    {}
func (*ReportTaskCompleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{6}
}

func (m *ReportTaskCompleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskCompleteRequest.Unmarshal(m, b)
}
func (m *ReportTaskCompleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskCompleteRequest.Marshal(b, m, deterministic)
}
func (m *ReportTaskCompleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskCompleteRequest.Merge(m, src)
}
func (m *ReportTaskCompleteRequest) XXX_Size() int {
	return xxx_messageInfo_ReportTaskCompleteRequest.Size(m)
}
func (m *ReportTaskCompleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskCompleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskCompleteRequest proto.InternalMessageInfo

func (m *ReportTaskCompleteRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

func (m *ReportTaskCompleteRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *ReportTaskCompleteRequest) GetTaskType() TaskType {
	if m != nil {
		return m.TaskType
	}
	return TaskType_TASK_TYPE_UNSPECIFIED
}

func (m *ReportTaskCompleteRequest) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

type isReportTaskCompleteRequest_Output interface {
	isReportTaskCompleteRequest_Output()
}

type ReportTaskCompleteRequest_ApplyPatchesTaskOutput struct {
	ApplyPatchesTaskOutput *ApplyPatchesTaskOutput `protobuf:"bytes,5,opt,name=apply_patches_task_output,json=applyPatchesTaskOutput,proto3,oneof"`
}

type ReportTaskCompleteRequest_ExecStepTaskOutput struct {
	ExecStepTaskOutput *ExecStepTaskOutput `protobuf:"bytes,6,opt,name=exec_step_task_output,json=execStepTaskOutput,proto3,oneof"`
}

func (*ReportTaskCompleteRequest_ApplyPatchesTaskOutput) isReportTaskCompleteRequest_Output() {}

func (*ReportTaskCompleteRequest_ExecStepTaskOutput) isReportTaskCompleteRequest_Output() {}

func (m *ReportTaskCompleteRequest) GetOutput() isReportTaskCompleteRequest_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (m *ReportTaskCompleteRequest) GetApplyPatchesTaskOutput() *ApplyPatchesTaskOutput {
	if x, ok := m.GetOutput().(*ReportTaskCompleteRequest_ApplyPatchesTaskOutput); ok {
		return x.ApplyPatchesTaskOutput
	}
	return nil
}

func (m *ReportTaskCompleteRequest) GetExecStepTaskOutput() *ExecStepTaskOutput {
	if x, ok := m.GetOutput().(*ReportTaskCompleteRequest_ExecStepTaskOutput); ok {
		return x.ExecStepTaskOutput
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReportTaskCompleteRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReportTaskCompleteRequest_ApplyPatchesTaskOutput)(nil),
		(*ReportTaskCompleteRequest_ExecStepTaskOutput)(nil),
	}
}

// The response message after the agent signaled the current task complete.
type ReportTaskCompleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReportTaskCompleteResponse) Reset()         { *m = ReportTaskCompleteResponse{} }
func (m *ReportTaskCompleteResponse) String() string { return proto.CompactTextString(m) }
func (*ReportTaskCompleteResponse) ProtoMessage()    {}
func (*ReportTaskCompleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{7}
}

func (m *ReportTaskCompleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskCompleteResponse.Unmarshal(m, b)
}
func (m *ReportTaskCompleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskCompleteResponse.Marshal(b, m, deterministic)
}
func (m *ReportTaskCompleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskCompleteResponse.Merge(m, src)
}
func (m *ReportTaskCompleteResponse) XXX_Size() int {
	return xxx_messageInfo_ReportTaskCompleteResponse.Size(m)
}
func (m *ReportTaskCompleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskCompleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskCompleteResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*ReceiveTaskNotificationRequest)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReceiveTaskNotificationRequest")
	proto.RegisterType((*ReceiveTaskNotificationResponse)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReceiveTaskNotificationResponse")
	proto.RegisterType((*ReportTaskStartRequest)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReportTaskStartRequest")
	proto.RegisterType((*ReportTaskStartResponse)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReportTaskStartResponse")
	proto.RegisterType((*ReportTaskProgressRequest)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReportTaskProgressRequest")
	proto.RegisterType((*ReportTaskProgressResponse)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReportTaskProgressResponse")
	proto.RegisterType((*ReportTaskCompleteRequest)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReportTaskCompleteRequest")
	proto.RegisterType((*ReportTaskCompleteResponse)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReportTaskCompleteResponse")
}

func init() {
	proto.RegisterFile("google/cloud/osconfig/agentendpoint/v1beta/agentendpoint.proto", fileDescriptor_5f4dbeb1b15ec34f)
}

var fileDescriptor_5f4dbeb1b15ec34f = []byte{
	// 725 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x56, 0xcd, 0x6e, 0xd3, 0x4a,
	0x14, 0x8e, 0xfb, 0x93, 0xdb, 0xce, 0xed, 0x8f, 0xee, 0xa8, 0xb7, 0x49, 0x7d, 0xab, 0xdb, 0x62,
	0x36, 0x15, 0x0b, 0xbb, 0x04, 0x84, 0x84, 0x90, 0x2a, 0xe2, 0xb6, 0xa8, 0x05, 0x01, 0x91, 0x5b,
	0x15, 0x89, 0x8d, 0x99, 0xda, 0xa7, 0xee, 0xa8, 0xae, 0x67, 0xf0, 0x4c, 0xa2, 0x46, 0x48, 0xb0,
	0xe2, 0x2d, 0x90, 0x58, 0xf1, 0x0a, 0x3c, 0x04, 0x3b, 0xb6, 0xac, 0xd8, 0xf1, 0x1a, 0xc8, 0x63,
	0xbb, 0x49, 0xdc, 0x14, 0xd5, 0x29, 0x1b, 0x56, 0x91, 0xcf, 0xf1, 0xf9, 0xbe, 0x2f, 0xe7, 0x7c,
	0x3e, 0x33, 0x68, 0x23, 0x60, 0x2c, 0x08, 0xc1, 0xf2, 0x42, 0xd6, 0xf6, 0x2d, 0x26, 0x3c, 0x16,
	0x1d, 0xd1, 0xc0, 0x22, 0x01, 0x44, 0x12, 0x22, 0x9f, 0x33, 0x1a, 0x49, 0xab, 0x73, 0xfb, 0x10,
	0x24, 0x19, 0x0c, 0x9a, 0x3c, 0x66, 0x92, 0xe1, 0x5b, 0x69, 0xbd, 0xa9, 0xea, 0xcd, 0xbc, 0xde,
	0x1c, 0x7c, 0x35, 0xad, 0xd7, 0x57, 0x32, 0x2e, 0xc2, 0xa9, 0x75, 0x44, 0x21, 0xf4, 0xdd, 0x43,
	0x38, 0x26, 0x1d, 0xca, 0xe2, 0x14, 0x4c, 0xbf, 0x57, 0x42, 0x8c, 0x24, 0xe2, 0x44, 0x64, 0x75,
	0xb5, 0x3e, 0x60, 0x2f, 0xa4, 0x90, 0xab, 0x33, 0xde, 0xa0, 0xff, 0x1d, 0xf0, 0x80, 0x76, 0x60,
	0x9f, 0x88, 0x93, 0x67, 0x4c, 0xd2, 0x23, 0xea, 0x11, 0x49, 0x59, 0xe4, 0xc0, 0xeb, 0x36, 0x08,
	0x89, 0x2d, 0xf4, 0x0f, 0x8d, 0x84, 0x24, 0x91, 0x07, 0x2e, 0xf5, 0x5d, 0xc9, 0x4e, 0x20, 0xaa,
	0x6b, 0xab, 0xda, 0xda, 0xb4, 0x3d, 0xfe, 0xbd, 0x39, 0xe6, 0xcc, 0xe7, 0xd9, 0x5d, 0x7f, 0x3f,
	0xc9, 0xe1, 0x35, 0x34, 0xab, 0xf4, 0xb8, 0x1d, 0x88, 0x05, 0x65, 0x51, 0x7d, 0xac, 0xf7, 0xf2,
	0x8c, 0xca, 0x1c, 0xa4, 0x09, 0xe3, 0x06, 0x5a, 0xb9, 0x94, 0x5c, 0x70, 0x16, 0x09, 0x30, 0x76,
	0xd1, 0xa2, 0x03, 0x9c, 0xc5, 0x32, 0x79, 0x63, 0x4f, 0x92, 0x58, 0x8e, 0xaa, 0xcb, 0x70, 0x51,
	0xed, 0x02, 0x54, 0xca, 0x82, 0xb7, 0xd0, 0x44, 0xd2, 0x2d, 0x55, 0xfe, 0x77, 0x63, 0xdd, 0xbc,
	0xfa, 0xc8, 0xcc, 0x04, 0xcc, 0x51, 0xd5, 0xc6, 0xd7, 0x71, 0xb4, 0xd4, 0x63, 0x68, 0xc5, 0x2c,
	0x88, 0x41, 0x88, 0x91, 0xfb, 0xb8, 0x8c, 0xfe, 0x4a, 0x60, 0x5d, 0xea, 0xf7, 0x77, 0xb0, 0x9a,
	0xc4, 0x76, 0x7d, 0x7c, 0x80, 0xa6, 0x55, 0x56, 0x76, 0x39, 0xd4, 0xc7, 0x57, 0xb5, 0xb5, 0xb9,
	0xc6, 0xdd, 0xb2, 0xba, 0xf7, 0xbb, 0x1c, 0x52, 0xd4, 0x29, 0x99, 0x3d, 0xe2, 0xf7, 0x1a, 0xfa,
	0x8f, 0x70, 0x1e, 0x76, 0x5d, 0x4e, 0xa4, 0x77, 0x0c, 0xc2, 0x55, 0x34, 0x3c, 0xfb, 0x37, 0xf5,
	0x09, 0xd5, 0xa2, 0xad, 0x32, 0x54, 0xcd, 0x04, 0xae, 0x95, 0xa2, 0xf5, 0x77, 0x66, 0xa7, 0xe2,
	0xd4, 0xc9, 0x25, 0x39, 0xdc, 0x45, 0x35, 0x38, 0x03, 0xcf, 0x15, 0x12, 0x78, 0x41, 0xc2, 0xa4,
	0x92, 0xf0, 0xb0, 0x8c, 0x84, 0xed, 0x33, 0xf0, 0xf6, 0x24, 0xf0, 0x02, 0xfd, 0x02, 0x0c, 0x89,
	0xdb, 0x08, 0x4d, 0xe5, 0x5c, 0xc6, 0x5b, 0xa4, 0x0f, 0x1b, 0x69, 0xe6, 0x9b, 0x57, 0x68, 0x4e,
	0x49, 0xf3, 0x69, 0x0c, 0x9e, 0xa4, 0x1d, 0x50, 0x03, 0x9d, 0x6b, 0xdc, 0x2f, 0x3b, 0x89, 0xad,
	0x1c, 0xc0, 0x99, 0x95, 0xfd, 0x8f, 0xc6, 0x8f, 0x01, 0x4f, 0x6d, 0xb2, 0x53, 0x1e, 0x82, 0x84,
	0x3f, 0xcc, 0x53, 0x37, 0xd1, 0x2c, 0xc4, 0x31, 0x8b, 0xdd, 0x53, 0x10, 0x82, 0x04, 0xa0, 0x4c,
	0x34, 0xed, 0xcc, 0xa8, 0xe0, 0xd3, 0x34, 0x86, 0xdf, 0xa1, 0xa5, 0x21, 0xbe, 0x63, 0x6d, 0xc9,
	0xdb, 0x32, 0x1b, 0xb9, 0x7d, 0x1d, 0xd7, 0x3d, 0x57, 0x48, 0x3b, 0x15, 0x67, 0x91, 0x0c, 0xcd,
	0x60, 0x81, 0xfe, 0x2d, 0x38, 0x2e, 0x23, 0xaf, 0x2a, 0xf2, 0x8d, 0x51, 0xfd, 0x76, 0x4e, 0x8c,
	0xe1, 0x42, 0xd4, 0x9e, 0x42, 0xd5, 0x94, 0xc5, 0x58, 0xee, 0x77, 0x5a, 0x6f, 0xd0, 0xa9, 0xd3,
	0x1a, 0xdf, 0x26, 0xd1, 0x42, 0x33, 0x61, 0xda, 0xce, 0x98, 0xf6, 0x20, 0xee, 0x50, 0x0f, 0xf0,
	0x67, 0x2d, 0x59, 0x6b, 0x43, 0x97, 0x28, 0x7e, 0x5c, 0x46, 0xf2, 0xaf, 0x8f, 0x01, 0xfd, 0xc9,
	0x6f, 0xc1, 0xca, 0xb6, 0x7a, 0x65, 0x5d, 0xc3, 0x1f, 0x34, 0x34, 0x5f, 0xd8, 0xc7, 0xd8, 0x2e,
	0x47, 0x32, 0xec, 0x5c, 0xd0, 0x37, 0xaf, 0x85, 0x91, 0x0b, 0xc4, 0x9f, 0x34, 0x84, 0x2f, 0x7e,
	0xf9, 0x78, 0x7b, 0x34, 0xf4, 0xc2, 0x61, 0xa0, 0x3f, 0xba, 0x2e, 0xcc, 0x25, 0x3a, 0x73, 0xdf,
	0x8c, 0xaa, 0xb3, 0xb0, 0x60, 0x46, 0xd5, 0x59, 0xb4, 0xaf, 0x51, 0xd1, 0xf5, 0x2f, 0xcd, 0xda,
	0x79, 0x79, 0x0a, 0x4a, 0x38, 0x15, 0xa6, 0xc7, 0x4e, 0xed, 0x8f, 0x1a, 0x4a, 0x7e, 0x4b, 0x70,
	0xd9, 0x78, 0xe0, 0x63, 0x68, 0x25, 0x77, 0x99, 0x96, 0xf6, 0xf2, 0x45, 0x86, 0x10, 0xb0, 0x90,
	0x44, 0x81, 0xc9, 0xe2, 0xc0, 0x0a, 0x20, 0x52, 0x37, 0x1d, 0xab, 0xc7, 0x79, 0x95, 0xdb, 0xd3,
	0x83, 0x81, 0xe0, 0x61, 0x55, 0x61, 0xdc, 0xf9, 0x19, 0x00, 0x00, 0xff, 0xff, 0xbb, 0x97, 0x33,
	0x86, 0x0d, 0x0a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AgentEndpointServiceClient is the client API for AgentEndpointService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentEndpointServiceClient interface {
	// Stream established by client to receive Task notifications.
	ReceiveTaskNotification(ctx context.Context, in *ReceiveTaskNotificationRequest, opts ...grpc.CallOption) (AgentEndpointService_ReceiveTaskNotificationClient, error)
	// Signals the start of a task execution and returns the task info.
	ReportTaskStart(ctx context.Context, in *ReportTaskStartRequest, opts ...grpc.CallOption) (*ReportTaskStartResponse, error)
	// Signals an intermediary progress checkpoint in task execution.
	ReportTaskProgress(ctx context.Context, in *ReportTaskProgressRequest, opts ...grpc.CallOption) (*ReportTaskProgressResponse, error)
	// Signals that the task execution is complete and optionally returns the next
	// task.
	ReportTaskComplete(ctx context.Context, in *ReportTaskCompleteRequest, opts ...grpc.CallOption) (*ReportTaskCompleteResponse, error)
}

type agentEndpointServiceClient struct {
	cc *grpc.ClientConn
}

func NewAgentEndpointServiceClient(cc *grpc.ClientConn) AgentEndpointServiceClient {
	return &agentEndpointServiceClient{cc}
}

func (c *agentEndpointServiceClient) ReceiveTaskNotification(ctx context.Context, in *ReceiveTaskNotificationRequest, opts ...grpc.CallOption) (AgentEndpointService_ReceiveTaskNotificationClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AgentEndpointService_serviceDesc.Streams[0], "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/ReceiveTaskNotification", opts...)
	if err != nil {
		return nil, err
	}
	x := &agentEndpointServiceReceiveTaskNotificationClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AgentEndpointService_ReceiveTaskNotificationClient interface {
	Recv() (*ReceiveTaskNotificationResponse, error)
	grpc.ClientStream
}

type agentEndpointServiceReceiveTaskNotificationClient struct {
	grpc.ClientStream
}

func (x *agentEndpointServiceReceiveTaskNotificationClient) Recv() (*ReceiveTaskNotificationResponse, error) {
	m := new(ReceiveTaskNotificationResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *agentEndpointServiceClient) ReportTaskStart(ctx context.Context, in *ReportTaskStartRequest, opts ...grpc.CallOption) (*ReportTaskStartResponse, error) {
	out := new(ReportTaskStartResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/ReportTaskStart", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) ReportTaskProgress(ctx context.Context, in *ReportTaskProgressRequest, opts ...grpc.CallOption) (*ReportTaskProgressResponse, error) {
	out := new(ReportTaskProgressResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/ReportTaskProgress", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) ReportTaskComplete(ctx context.Context, in *ReportTaskCompleteRequest, opts ...grpc.CallOption) (*ReportTaskCompleteResponse, error) {
	out := new(ReportTaskCompleteResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/ReportTaskComplete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentEndpointServiceServer is the server API for AgentEndpointService service.
type AgentEndpointServiceServer interface {
	// Stream established by client to receive Task notifications.
	ReceiveTaskNotification(*ReceiveTaskNotificationRequest, AgentEndpointService_ReceiveTaskNotificationServer) error
	// Signals the start of a task execution and returns the task info.
	ReportTaskStart(context.Context, *ReportTaskStartRequest) (*ReportTaskStartResponse, error)
	// Signals an intermediary progress checkpoint in task execution.
	ReportTaskProgress(context.Context, *ReportTaskProgressRequest) (*ReportTaskProgressResponse, error)
	// Signals that the task execution is complete and optionally returns the next
	// task.
	ReportTaskComplete(context.Context, *ReportTaskCompleteRequest) (*ReportTaskCompleteResponse, error)
}

// UnimplementedAgentEndpointServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAgentEndpointServiceServer struct {
}

func (*UnimplementedAgentEndpointServiceServer) ReceiveTaskNotification(req *ReceiveTaskNotificationRequest, srv AgentEndpointService_ReceiveTaskNotificationServer) error {
	return status.Errorf(codes.Unimplemented, "method ReceiveTaskNotification not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) ReportTaskStart(ctx context.Context, req *ReportTaskStartRequest) (*ReportTaskStartResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportTaskStart not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) ReportTaskProgress(ctx context.Context, req *ReportTaskProgressRequest) (*ReportTaskProgressResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportTaskProgress not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) ReportTaskComplete(ctx context.Context, req *ReportTaskCompleteRequest) (*ReportTaskCompleteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportTaskComplete not implemented")
}

func RegisterAgentEndpointServiceServer(s *grpc.Server, srv AgentEndpointServiceServer) {
	s.RegisterService(&_AgentEndpointService_serviceDesc, srv)
}

func _AgentEndpointService_ReceiveTaskNotification_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReceiveTaskNotificationRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AgentEndpointServiceServer).ReceiveTaskNotification(m, &agentEndpointServiceReceiveTaskNotificationServer{stream})
}

type AgentEndpointService_ReceiveTaskNotificationServer interface {
	Send(*ReceiveTaskNotificationResponse) error
	grpc.ServerStream
}

type agentEndpointServiceReceiveTaskNotificationServer struct {
	grpc.ServerStream
}

func (x *agentEndpointServiceReceiveTaskNotificationServer) Send(m *ReceiveTaskNotificationResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _AgentEndpointService_ReportTaskStart_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportTaskStartRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportTaskStart(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/ReportTaskStart",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportTaskStart(ctx, req.(*ReportTaskStartRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_ReportTaskProgress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportTaskProgressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportTaskProgress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/ReportTaskProgress",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportTaskProgress(ctx, req.(*ReportTaskProgressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_ReportTaskComplete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportTaskCompleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportTaskComplete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/ReportTaskComplete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportTaskComplete(ctx, req.(*ReportTaskCompleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AgentEndpointService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService",
	HandlerType: (*AgentEndpointServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ReportTaskStart",
			Handler:    _AgentEndpointService_ReportTaskStart_Handler,
		},
		{
			MethodName: "ReportTaskProgress",
			Handler:    _AgentEndpointService_ReportTaskProgress_Handler,
		},
		{
			MethodName: "ReportTaskComplete",
			Handler:    _AgentEndpointService_ReportTaskComplete_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReceiveTaskNotification",
			Handler:       _AgentEndpointService_ReceiveTaskNotification_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/osconfig/agentendpoint/v1beta/agentendpoint.proto",
}
